<?php

namespace PHPMaker2024\fibre;

// Page object
$PayrollTimeLogAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payroll_time_log: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fpayroll_time_logadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpayroll_time_logadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["employee_id", [fields.employee_id.visible && fields.employee_id.required ? ew.Validators.required(fields.employee_id.caption) : null, ew.Validators.integer], fields.employee_id.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.integer], fields.dated.isInvalid],
            ["in_time", [fields.in_time.visible && fields.in_time.required ? ew.Validators.required(fields.in_time.caption) : null, ew.Validators.datetime(fields.in_time.clientFormatPattern)], fields.in_time.isInvalid],
            ["out_time", [fields.out_time.visible && fields.out_time.required ? ew.Validators.required(fields.out_time.caption) : null, ew.Validators.datetime(fields.out_time.clientFormatPattern)], fields.out_time.isInvalid],
            ["minutes", [fields.minutes.visible && fields.minutes.required ? ew.Validators.required(fields.minutes.caption) : null, ew.Validators.integer], fields.minutes.isInvalid],
            ["late_arrival", [fields.late_arrival.visible && fields.late_arrival.required ? ew.Validators.required(fields.late_arrival.caption) : null, ew.Validators.integer], fields.late_arrival.isInvalid],
            ["early_departure", [fields.early_departure.visible && fields.early_departure.required ? ew.Validators.required(fields.early_departure.caption) : null, ew.Validators.integer], fields.early_departure.isInvalid],
            ["overtime", [fields.overtime.visible && fields.overtime.required ? ew.Validators.required(fields.overtime.caption) : null, ew.Validators.integer], fields.overtime.isInvalid],
            ["breakduration", [fields.breakduration.visible && fields.breakduration.required ? ew.Validators.required(fields.breakduration.caption) : null, ew.Validators.integer], fields.breakduration.isInvalid],
            ["employee_am_id", [fields.employee_am_id.visible && fields.employee_am_id.required ? ew.Validators.required(fields.employee_am_id.caption) : null, ew.Validators.integer], fields.employee_am_id.isInvalid],
            ["offset_consumed", [fields.offset_consumed.visible && fields.offset_consumed.required ? ew.Validators.required(fields.offset_consumed.caption) : null, ew.Validators.integer], fields.offset_consumed.isInvalid],
            ["c_offset", [fields.c_offset.visible && fields.c_offset.required ? ew.Validators.required(fields.c_offset.caption) : null, ew.Validators.integer], fields.c_offset.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpayroll_time_logadd" id="fpayroll_time_logadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payroll_time_log">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->employee_id->Visible) { // employee_id ?>
    <div id="r_employee_id"<?= $Page->employee_id->rowAttributes() ?>>
        <label id="elh_payroll_time_log_employee_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->employee_id->caption() ?><?= $Page->employee_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->employee_id->cellAttributes() ?>>
<span id="el_payroll_time_log_employee_id">
<?php
if (IsRTL()) {
    $Page->employee_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_employee_id" class="ew-auto-suggest">
    <input type="<?= $Page->employee_id->getInputTextType() ?>" class="form-control" name="sv_x_employee_id" id="sv_x_employee_id" value="<?= RemoveHtml($Page->employee_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_id->formatPattern()) ?>"<?= $Page->employee_id->editAttributes() ?> aria-describedby="x_employee_id_help">
</span>
<selection-list hidden class="form-control" data-table="payroll_time_log" data-field="x_employee_id" data-input="sv_x_employee_id" data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id" id="x_employee_id" value="<?= HtmlEncode($Page->employee_id->CurrentValue) ?>"></selection-list>
<?= $Page->employee_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fpayroll_time_logadd", function() {
    fpayroll_time_logadd.createAutoSuggest(Object.assign({"id":"x_employee_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->employee_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.payroll_time_log.fields.employee_id.autoSuggestOptions));
});
</script>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_payroll_time_log_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_payroll_time_log_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="payroll_time_log" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->in_time->Visible) { // in_time ?>
    <div id="r_in_time"<?= $Page->in_time->rowAttributes() ?>>
        <label id="elh_payroll_time_log_in_time" for="x_in_time" class="<?= $Page->LeftColumnClass ?>"><?= $Page->in_time->caption() ?><?= $Page->in_time->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->in_time->cellAttributes() ?>>
<span id="el_payroll_time_log_in_time">
<input type="<?= $Page->in_time->getInputTextType() ?>" name="x_in_time" id="x_in_time" data-table="payroll_time_log" data-field="x_in_time" value="<?= $Page->in_time->EditValue ?>" placeholder="<?= HtmlEncode($Page->in_time->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->in_time->formatPattern()) ?>"<?= $Page->in_time->editAttributes() ?> aria-describedby="x_in_time_help">
<?= $Page->in_time->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->in_time->getErrorMessage() ?></div>
<?php if (!$Page->in_time->ReadOnly && !$Page->in_time->Disabled && !isset($Page->in_time->EditAttrs["readonly"]) && !isset($Page->in_time->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayroll_time_logadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(117) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayroll_time_logadd", "x_in_time", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->out_time->Visible) { // out_time ?>
    <div id="r_out_time"<?= $Page->out_time->rowAttributes() ?>>
        <label id="elh_payroll_time_log_out_time" for="x_out_time" class="<?= $Page->LeftColumnClass ?>"><?= $Page->out_time->caption() ?><?= $Page->out_time->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->out_time->cellAttributes() ?>>
<span id="el_payroll_time_log_out_time">
<input type="<?= $Page->out_time->getInputTextType() ?>" name="x_out_time" id="x_out_time" data-table="payroll_time_log" data-field="x_out_time" value="<?= $Page->out_time->EditValue ?>" placeholder="<?= HtmlEncode($Page->out_time->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->out_time->formatPattern()) ?>"<?= $Page->out_time->editAttributes() ?> aria-describedby="x_out_time_help">
<?= $Page->out_time->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->out_time->getErrorMessage() ?></div>
<?php if (!$Page->out_time->ReadOnly && !$Page->out_time->Disabled && !isset($Page->out_time->EditAttrs["readonly"]) && !isset($Page->out_time->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayroll_time_logadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayroll_time_logadd", "x_out_time", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->minutes->Visible) { // minutes ?>
    <div id="r_minutes"<?= $Page->minutes->rowAttributes() ?>>
        <label id="elh_payroll_time_log_minutes" for="x_minutes" class="<?= $Page->LeftColumnClass ?>"><?= $Page->minutes->caption() ?><?= $Page->minutes->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->minutes->cellAttributes() ?>>
<span id="el_payroll_time_log_minutes">
<input type="<?= $Page->minutes->getInputTextType() ?>" name="x_minutes" id="x_minutes" data-table="payroll_time_log" data-field="x_minutes" value="<?= $Page->minutes->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->minutes->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->minutes->formatPattern()) ?>"<?= $Page->minutes->editAttributes() ?> aria-describedby="x_minutes_help">
<?= $Page->minutes->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->minutes->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->late_arrival->Visible) { // late_arrival ?>
    <div id="r_late_arrival"<?= $Page->late_arrival->rowAttributes() ?>>
        <label id="elh_payroll_time_log_late_arrival" for="x_late_arrival" class="<?= $Page->LeftColumnClass ?>"><?= $Page->late_arrival->caption() ?><?= $Page->late_arrival->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->late_arrival->cellAttributes() ?>>
<span id="el_payroll_time_log_late_arrival">
<input type="<?= $Page->late_arrival->getInputTextType() ?>" name="x_late_arrival" id="x_late_arrival" data-table="payroll_time_log" data-field="x_late_arrival" value="<?= $Page->late_arrival->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->late_arrival->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->late_arrival->formatPattern()) ?>"<?= $Page->late_arrival->editAttributes() ?> aria-describedby="x_late_arrival_help">
<?= $Page->late_arrival->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->late_arrival->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->early_departure->Visible) { // early_departure ?>
    <div id="r_early_departure"<?= $Page->early_departure->rowAttributes() ?>>
        <label id="elh_payroll_time_log_early_departure" for="x_early_departure" class="<?= $Page->LeftColumnClass ?>"><?= $Page->early_departure->caption() ?><?= $Page->early_departure->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->early_departure->cellAttributes() ?>>
<span id="el_payroll_time_log_early_departure">
<input type="<?= $Page->early_departure->getInputTextType() ?>" name="x_early_departure" id="x_early_departure" data-table="payroll_time_log" data-field="x_early_departure" value="<?= $Page->early_departure->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->early_departure->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->early_departure->formatPattern()) ?>"<?= $Page->early_departure->editAttributes() ?> aria-describedby="x_early_departure_help">
<?= $Page->early_departure->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->early_departure->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->overtime->Visible) { // overtime ?>
    <div id="r_overtime"<?= $Page->overtime->rowAttributes() ?>>
        <label id="elh_payroll_time_log_overtime" for="x_overtime" class="<?= $Page->LeftColumnClass ?>"><?= $Page->overtime->caption() ?><?= $Page->overtime->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->overtime->cellAttributes() ?>>
<span id="el_payroll_time_log_overtime">
<input type="<?= $Page->overtime->getInputTextType() ?>" name="x_overtime" id="x_overtime" data-table="payroll_time_log" data-field="x_overtime" value="<?= $Page->overtime->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->overtime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->overtime->formatPattern()) ?>"<?= $Page->overtime->editAttributes() ?> aria-describedby="x_overtime_help">
<?= $Page->overtime->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->overtime->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->breakduration->Visible) { // break duration ?>
    <div id="r_breakduration"<?= $Page->breakduration->rowAttributes() ?>>
        <label id="elh_payroll_time_log_breakduration" for="x_breakduration" class="<?= $Page->LeftColumnClass ?>"><?= $Page->breakduration->caption() ?><?= $Page->breakduration->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->breakduration->cellAttributes() ?>>
<span id="el_payroll_time_log_breakduration">
<input type="<?= $Page->breakduration->getInputTextType() ?>" name="x_breakduration" id="x_breakduration" data-table="payroll_time_log" data-field="x_breakduration" value="<?= $Page->breakduration->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->breakduration->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->breakduration->formatPattern()) ?>"<?= $Page->breakduration->editAttributes() ?> aria-describedby="x_breakduration_help">
<?= $Page->breakduration->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->breakduration->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->employee_am_id->Visible) { // employee_am_id ?>
    <div id="r_employee_am_id"<?= $Page->employee_am_id->rowAttributes() ?>>
        <label id="elh_payroll_time_log_employee_am_id" for="x_employee_am_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->employee_am_id->caption() ?><?= $Page->employee_am_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->employee_am_id->cellAttributes() ?>>
<span id="el_payroll_time_log_employee_am_id">
<input type="<?= $Page->employee_am_id->getInputTextType() ?>" name="x_employee_am_id" id="x_employee_am_id" data-table="payroll_time_log" data-field="x_employee_am_id" value="<?= $Page->employee_am_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->employee_am_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_am_id->formatPattern()) ?>"<?= $Page->employee_am_id->editAttributes() ?> aria-describedby="x_employee_am_id_help">
<?= $Page->employee_am_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->employee_am_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->offset_consumed->Visible) { // offset_consumed ?>
    <div id="r_offset_consumed"<?= $Page->offset_consumed->rowAttributes() ?>>
        <label id="elh_payroll_time_log_offset_consumed" for="x_offset_consumed" class="<?= $Page->LeftColumnClass ?>"><?= $Page->offset_consumed->caption() ?><?= $Page->offset_consumed->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->offset_consumed->cellAttributes() ?>>
<span id="el_payroll_time_log_offset_consumed">
<input type="<?= $Page->offset_consumed->getInputTextType() ?>" name="x_offset_consumed" id="x_offset_consumed" data-table="payroll_time_log" data-field="x_offset_consumed" value="<?= $Page->offset_consumed->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->offset_consumed->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->offset_consumed->formatPattern()) ?>"<?= $Page->offset_consumed->editAttributes() ?> aria-describedby="x_offset_consumed_help">
<?= $Page->offset_consumed->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->offset_consumed->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->c_offset->Visible) { // c_offset ?>
    <div id="r_c_offset"<?= $Page->c_offset->rowAttributes() ?>>
        <label id="elh_payroll_time_log_c_offset" for="x_c_offset" class="<?= $Page->LeftColumnClass ?>"><?= $Page->c_offset->caption() ?><?= $Page->c_offset->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->c_offset->cellAttributes() ?>>
<span id="el_payroll_time_log_c_offset">
<input type="<?= $Page->c_offset->getInputTextType() ?>" name="x_c_offset" id="x_c_offset" data-table="payroll_time_log" data-field="x_c_offset" value="<?= $Page->c_offset->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->c_offset->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->c_offset->formatPattern()) ?>"<?= $Page->c_offset->editAttributes() ?> aria-describedby="x_c_offset_help">
<?= $Page->c_offset->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->c_offset->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpayroll_time_logadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpayroll_time_logadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payroll_time_log");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
