<?php

namespace PHPMaker2024\fibre;

// Page object
$PayrollFixDetailsAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payroll_fix_details: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fpayroll_fix_detailsadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpayroll_fix_detailsadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["employee_id", [fields.employee_id.visible && fields.employee_id.required ? ew.Validators.required(fields.employee_id.caption) : null, ew.Validators.integer], fields.employee_id.isInvalid],
            ["employee_am_id", [fields.employee_am_id.visible && fields.employee_am_id.required ? ew.Validators.required(fields.employee_am_id.caption) : null, ew.Validators.integer], fields.employee_am_id.isInvalid],
            ["job_title", [fields.job_title.visible && fields.job_title.required ? ew.Validators.required(fields.job_title.caption) : null], fields.job_title.isInvalid],
            ["daily_in", [fields.daily_in.visible && fields.daily_in.required ? ew.Validators.required(fields.daily_in.caption) : null, ew.Validators.time(fields.daily_in.clientFormatPattern)], fields.daily_in.isInvalid],
            ["daily_out", [fields.daily_out.visible && fields.daily_out.required ? ew.Validators.required(fields.daily_out.caption) : null, ew.Validators.time(fields.daily_out.clientFormatPattern)], fields.daily_out.isInvalid],
            ["lunch_break_min", [fields.lunch_break_min.visible && fields.lunch_break_min.required ? ew.Validators.required(fields.lunch_break_min.caption) : null, ew.Validators.integer], fields.lunch_break_min.isInvalid],
            ["daily_min", [fields.daily_min.visible && fields.daily_min.required ? ew.Validators.required(fields.daily_min.caption) : null, ew.Validators.integer], fields.daily_min.isInvalid],
            ["weekly_off", [fields.weekly_off.visible && fields.weekly_off.required ? ew.Validators.required(fields.weekly_off.caption) : null], fields.weekly_off.isInvalid],
            ["offsets_benifit_min", [fields.offsets_benifit_min.visible && fields.offsets_benifit_min.required ? ew.Validators.required(fields.offsets_benifit_min.caption) : null, ew.Validators.integer], fields.offsets_benifit_min.isInvalid],
            ["next_increment", [fields.next_increment.visible && fields.next_increment.required ? ew.Validators.required(fields.next_increment.caption) : null, ew.Validators.datetime(fields.next_increment.clientFormatPattern)], fields.next_increment.isInvalid],
            ["current_payroll_startdate", [fields.current_payroll_startdate.visible && fields.current_payroll_startdate.required ? ew.Validators.required(fields.current_payroll_startdate.caption) : null, ew.Validators.datetime(fields.current_payroll_startdate.clientFormatPattern)], fields.current_payroll_startdate.isInvalid],
            ["base_salary", [fields.base_salary.visible && fields.base_salary.required ? ew.Validators.required(fields.base_salary.caption) : null, ew.Validators.float], fields.base_salary.isInvalid],
            ["additional_benefits", [fields.additional_benefits.visible && fields.additional_benefits.required ? ew.Validators.required(fields.additional_benefits.caption) : null], fields.additional_benefits.isInvalid],
            ["extra_min_plan", [fields.extra_min_plan.visible && fields.extra_min_plan.required ? ew.Validators.required(fields.extra_min_plan.caption) : null], fields.extra_min_plan.isInvalid],
            ["office_holidays", [fields.office_holidays.visible && fields.office_holidays.required ? ew.Validators.required(fields.office_holidays.caption) : null], fields.office_holidays.isInvalid],
            ["paid_annual_leave", [fields.paid_annual_leave.visible && fields.paid_annual_leave.required ? ew.Validators.required(fields.paid_annual_leave.caption) : null, ew.Validators.integer], fields.paid_annual_leave.isInvalid],
            ["employee_pf", [fields.employee_pf.visible && fields.employee_pf.required ? ew.Validators.required(fields.employee_pf.caption) : null], fields.employee_pf.isInvalid],
            ["calculation_plan", [fields.calculation_plan.visible && fields.calculation_plan.required ? ew.Validators.required(fields.calculation_plan.caption) : null], fields.calculation_plan.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null, ew.Validators.integer], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["month_min", [fields.month_min.visible && fields.month_min.required ? ew.Validators.required(fields.month_min.caption) : null, ew.Validators.integer], fields.month_min.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
            "weekly_off": <?= $Page->weekly_off->toClientList($Page) ?>,
            "additional_benefits": <?= $Page->additional_benefits->toClientList($Page) ?>,
            "extra_min_plan": <?= $Page->extra_min_plan->toClientList($Page) ?>,
            "office_holidays": <?= $Page->office_holidays->toClientList($Page) ?>,
            "employee_pf": <?= $Page->employee_pf->toClientList($Page) ?>,
            "calculation_plan": <?= $Page->calculation_plan->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpayroll_fix_detailsadd" id="fpayroll_fix_detailsadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payroll_fix_details">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->employee_id->Visible) { // employee_id ?>
    <div id="r_employee_id"<?= $Page->employee_id->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_employee_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->employee_id->caption() ?><?= $Page->employee_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->employee_id->cellAttributes() ?>>
<span id="el_payroll_fix_details_employee_id">
<div class="input-group flex-nowrap">
    <select
        id="x_employee_id"
        name="x_employee_id"
        class="form-control ew-select<?= $Page->employee_id->isInvalidClass() ?>"
        data-select2-id="fpayroll_fix_detailsadd_x_employee_id"
        data-table="payroll_fix_details"
        data-field="x_employee_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->employee_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>"
        <?= $Page->employee_id->editAttributes() ?>>
        <?= $Page->employee_id->selectOptionListHtml("x_employee_id") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "production_employee_view") && !$Page->employee_id->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_employee_id" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->employee_id->caption() ?>" data-title="<?= $Page->employee_id->caption() ?>" data-ew-action="add-option" data-el="x_employee_id" data-url="<?= GetUrl("productionemployeeview2addopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->employee_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage() ?></div>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
<script>
loadjs.ready("fpayroll_fix_detailsadd", function() {
    var options = { name: "x_employee_id", selectId: "fpayroll_fix_detailsadd_x_employee_id" };
    if (fpayroll_fix_detailsadd.lists.employee_id?.lookupOptions.length) {
        options.data = { id: "x_employee_id", form: "fpayroll_fix_detailsadd" };
    } else {
        options.ajax = { id: "x_employee_id", form: "fpayroll_fix_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.payroll_fix_details.fields.employee_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->employee_am_id->Visible) { // employee_am_id ?>
    <div id="r_employee_am_id"<?= $Page->employee_am_id->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_employee_am_id" for="x_employee_am_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->employee_am_id->caption() ?><?= $Page->employee_am_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->employee_am_id->cellAttributes() ?>>
<span id="el_payroll_fix_details_employee_am_id">
<input type="<?= $Page->employee_am_id->getInputTextType() ?>" name="x_employee_am_id" id="x_employee_am_id" data-table="payroll_fix_details" data-field="x_employee_am_id" value="<?= $Page->employee_am_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->employee_am_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_am_id->formatPattern()) ?>"<?= $Page->employee_am_id->editAttributes() ?> aria-describedby="x_employee_am_id_help">
<?= $Page->employee_am_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->employee_am_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->job_title->Visible) { // job_title ?>
    <div id="r_job_title"<?= $Page->job_title->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_job_title" for="x_job_title" class="<?= $Page->LeftColumnClass ?>"><?= $Page->job_title->caption() ?><?= $Page->job_title->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->job_title->cellAttributes() ?>>
<span id="el_payroll_fix_details_job_title">
<input type="<?= $Page->job_title->getInputTextType() ?>" name="x_job_title" id="x_job_title" data-table="payroll_fix_details" data-field="x_job_title" value="<?= $Page->job_title->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->job_title->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->job_title->formatPattern()) ?>"<?= $Page->job_title->editAttributes() ?> aria-describedby="x_job_title_help">
<?= $Page->job_title->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->job_title->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->daily_in->Visible) { // daily_in ?>
    <div id="r_daily_in"<?= $Page->daily_in->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_daily_in" for="x_daily_in" class="<?= $Page->LeftColumnClass ?>"><?= $Page->daily_in->caption() ?><?= $Page->daily_in->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->daily_in->cellAttributes() ?>>
<span id="el_payroll_fix_details_daily_in">
<input type="<?= $Page->daily_in->getInputTextType() ?>" name="x_daily_in" id="x_daily_in" data-table="payroll_fix_details" data-field="x_daily_in" value="<?= $Page->daily_in->EditValue ?>" placeholder="<?= HtmlEncode($Page->daily_in->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->daily_in->formatPattern()) ?>"<?= $Page->daily_in->editAttributes() ?> aria-describedby="x_daily_in_help">
<?= $Page->daily_in->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->daily_in->getErrorMessage() ?></div>
<?php if (!$Page->daily_in->ReadOnly && !$Page->daily_in->Disabled && !isset($Page->daily_in->EditAttrs["readonly"]) && !isset($Page->daily_in->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayroll_fix_detailsadd", "timepicker"], () => ew.createTimePicker("fpayroll_fix_detailsadd", "x_daily_in", Object.assign({"step":15}, { timeFormat: "<?= DateFormat(4) ?>" }, undefined)));
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->daily_out->Visible) { // daily_out ?>
    <div id="r_daily_out"<?= $Page->daily_out->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_daily_out" for="x_daily_out" class="<?= $Page->LeftColumnClass ?>"><?= $Page->daily_out->caption() ?><?= $Page->daily_out->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->daily_out->cellAttributes() ?>>
<span id="el_payroll_fix_details_daily_out">
<input type="<?= $Page->daily_out->getInputTextType() ?>" name="x_daily_out" id="x_daily_out" data-table="payroll_fix_details" data-field="x_daily_out" value="<?= $Page->daily_out->EditValue ?>" placeholder="<?= HtmlEncode($Page->daily_out->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->daily_out->formatPattern()) ?>"<?= $Page->daily_out->editAttributes() ?> aria-describedby="x_daily_out_help">
<?= $Page->daily_out->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->daily_out->getErrorMessage() ?></div>
<?php if (!$Page->daily_out->ReadOnly && !$Page->daily_out->Disabled && !isset($Page->daily_out->EditAttrs["readonly"]) && !isset($Page->daily_out->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayroll_fix_detailsadd", "timepicker"], () => ew.createTimePicker("fpayroll_fix_detailsadd", "x_daily_out", Object.assign({"step":15}, { timeFormat: "<?= DateFormat(4) ?>" }, undefined)));
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lunch_break_min->Visible) { // lunch_break_min ?>
    <div id="r_lunch_break_min"<?= $Page->lunch_break_min->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_lunch_break_min" for="x_lunch_break_min" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lunch_break_min->caption() ?><?= $Page->lunch_break_min->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lunch_break_min->cellAttributes() ?>>
<span id="el_payroll_fix_details_lunch_break_min">
<input type="<?= $Page->lunch_break_min->getInputTextType() ?>" name="x_lunch_break_min" id="x_lunch_break_min" data-table="payroll_fix_details" data-field="x_lunch_break_min" value="<?= $Page->lunch_break_min->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->lunch_break_min->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lunch_break_min->formatPattern()) ?>"<?= $Page->lunch_break_min->editAttributes() ?> aria-describedby="x_lunch_break_min_help">
<?= $Page->lunch_break_min->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lunch_break_min->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->daily_min->Visible) { // daily_min ?>
    <div id="r_daily_min"<?= $Page->daily_min->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_daily_min" for="x_daily_min" class="<?= $Page->LeftColumnClass ?>"><?= $Page->daily_min->caption() ?><?= $Page->daily_min->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->daily_min->cellAttributes() ?>>
<span id="el_payroll_fix_details_daily_min">
<input type="<?= $Page->daily_min->getInputTextType() ?>" name="x_daily_min" id="x_daily_min" data-table="payroll_fix_details" data-field="x_daily_min" value="<?= $Page->daily_min->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->daily_min->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->daily_min->formatPattern()) ?>"<?= $Page->daily_min->editAttributes() ?> aria-describedby="x_daily_min_help">
<?= $Page->daily_min->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->daily_min->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->weekly_off->Visible) { // weekly_off ?>
    <div id="r_weekly_off"<?= $Page->weekly_off->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_weekly_off" for="x_weekly_off" class="<?= $Page->LeftColumnClass ?>"><?= $Page->weekly_off->caption() ?><?= $Page->weekly_off->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->weekly_off->cellAttributes() ?>>
<span id="el_payroll_fix_details_weekly_off">
    <select
        id="x_weekly_off[]"
        name="x_weekly_off[]"
        class="form-select ew-select<?= $Page->weekly_off->isInvalidClass() ?>"
        <?php if (!$Page->weekly_off->IsNativeSelect) { ?>
        data-select2-id="fpayroll_fix_detailsadd_x_weekly_off[]"
        <?php } ?>
        data-table="payroll_fix_details"
        data-field="x_weekly_off"
        multiple
        size="1"
        data-value-separator="<?= $Page->weekly_off->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->weekly_off->getPlaceHolder()) ?>"
        <?= $Page->weekly_off->editAttributes() ?>>
        <?= $Page->weekly_off->selectOptionListHtml("x_weekly_off[]") ?>
    </select>
    <?= $Page->weekly_off->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->weekly_off->getErrorMessage() ?></div>
<?php if (!$Page->weekly_off->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayroll_fix_detailsadd", function() {
    var options = { name: "x_weekly_off[]", selectId: "fpayroll_fix_detailsadd_x_weekly_off[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayroll_fix_detailsadd.lists.weekly_off?.lookupOptions.length) {
        options.data = { id: "x_weekly_off[]", form: "fpayroll_fix_detailsadd" };
    } else {
        options.ajax = { id: "x_weekly_off[]", form: "fpayroll_fix_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payroll_fix_details.fields.weekly_off.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->offsets_benifit_min->Visible) { // offsets_benifit_min ?>
    <div id="r_offsets_benifit_min"<?= $Page->offsets_benifit_min->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_offsets_benifit_min" for="x_offsets_benifit_min" class="<?= $Page->LeftColumnClass ?>"><?= $Page->offsets_benifit_min->caption() ?><?= $Page->offsets_benifit_min->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->offsets_benifit_min->cellAttributes() ?>>
<span id="el_payroll_fix_details_offsets_benifit_min">
<input type="<?= $Page->offsets_benifit_min->getInputTextType() ?>" name="x_offsets_benifit_min" id="x_offsets_benifit_min" data-table="payroll_fix_details" data-field="x_offsets_benifit_min" value="<?= $Page->offsets_benifit_min->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->offsets_benifit_min->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->offsets_benifit_min->formatPattern()) ?>"<?= $Page->offsets_benifit_min->editAttributes() ?> aria-describedby="x_offsets_benifit_min_help">
<?= $Page->offsets_benifit_min->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->offsets_benifit_min->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->next_increment->Visible) { // next_increment ?>
    <div id="r_next_increment"<?= $Page->next_increment->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_next_increment" for="x_next_increment" class="<?= $Page->LeftColumnClass ?>"><?= $Page->next_increment->caption() ?><?= $Page->next_increment->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->next_increment->cellAttributes() ?>>
<span id="el_payroll_fix_details_next_increment">
<input type="<?= $Page->next_increment->getInputTextType() ?>" name="x_next_increment" id="x_next_increment" data-table="payroll_fix_details" data-field="x_next_increment" value="<?= $Page->next_increment->EditValue ?>" placeholder="<?= HtmlEncode($Page->next_increment->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->next_increment->formatPattern()) ?>"<?= $Page->next_increment->editAttributes() ?> aria-describedby="x_next_increment_help">
<?= $Page->next_increment->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->next_increment->getErrorMessage() ?></div>
<?php if (!$Page->next_increment->ReadOnly && !$Page->next_increment->Disabled && !isset($Page->next_increment->EditAttrs["readonly"]) && !isset($Page->next_increment->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayroll_fix_detailsadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayroll_fix_detailsadd", "x_next_increment", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->current_payroll_startdate->Visible) { // current_payroll_startdate ?>
    <div id="r_current_payroll_startdate"<?= $Page->current_payroll_startdate->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_current_payroll_startdate" for="x_current_payroll_startdate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->current_payroll_startdate->caption() ?><?= $Page->current_payroll_startdate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->current_payroll_startdate->cellAttributes() ?>>
<span id="el_payroll_fix_details_current_payroll_startdate">
<input type="<?= $Page->current_payroll_startdate->getInputTextType() ?>" name="x_current_payroll_startdate" id="x_current_payroll_startdate" data-table="payroll_fix_details" data-field="x_current_payroll_startdate" value="<?= $Page->current_payroll_startdate->EditValue ?>" placeholder="<?= HtmlEncode($Page->current_payroll_startdate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->current_payroll_startdate->formatPattern()) ?>"<?= $Page->current_payroll_startdate->editAttributes() ?> aria-describedby="x_current_payroll_startdate_help">
<?= $Page->current_payroll_startdate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->current_payroll_startdate->getErrorMessage() ?></div>
<?php if (!$Page->current_payroll_startdate->ReadOnly && !$Page->current_payroll_startdate->Disabled && !isset($Page->current_payroll_startdate->EditAttrs["readonly"]) && !isset($Page->current_payroll_startdate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayroll_fix_detailsadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayroll_fix_detailsadd", "x_current_payroll_startdate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->base_salary->Visible) { // base_salary ?>
    <div id="r_base_salary"<?= $Page->base_salary->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_base_salary" for="x_base_salary" class="<?= $Page->LeftColumnClass ?>"><?= $Page->base_salary->caption() ?><?= $Page->base_salary->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->base_salary->cellAttributes() ?>>
<span id="el_payroll_fix_details_base_salary">
<input type="<?= $Page->base_salary->getInputTextType() ?>" name="x_base_salary" id="x_base_salary" data-table="payroll_fix_details" data-field="x_base_salary" value="<?= $Page->base_salary->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->base_salary->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->base_salary->formatPattern()) ?>"<?= $Page->base_salary->editAttributes() ?> aria-describedby="x_base_salary_help">
<?= $Page->base_salary->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->base_salary->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->additional_benefits->Visible) { // additional_benefits ?>
    <div id="r_additional_benefits"<?= $Page->additional_benefits->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_additional_benefits" for="x_additional_benefits" class="<?= $Page->LeftColumnClass ?>"><?= $Page->additional_benefits->caption() ?><?= $Page->additional_benefits->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->additional_benefits->cellAttributes() ?>>
<span id="el_payroll_fix_details_additional_benefits">
<div class="input-group flex-nowrap">
    <select
        id="x_additional_benefits"
        name="x_additional_benefits"
        class="form-select ew-select<?= $Page->additional_benefits->isInvalidClass() ?>"
        <?php if (!$Page->additional_benefits->IsNativeSelect) { ?>
        data-select2-id="fpayroll_fix_detailsadd_x_additional_benefits"
        <?php } ?>
        data-table="payroll_fix_details"
        data-field="x_additional_benefits"
        data-value-separator="<?= $Page->additional_benefits->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->additional_benefits->getPlaceHolder()) ?>"
        <?= $Page->additional_benefits->editAttributes() ?>>
        <?= $Page->additional_benefits->selectOptionListHtml("x_additional_benefits") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "payroll_benefits") && !$Page->additional_benefits->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_additional_benefits" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->additional_benefits->caption() ?>" data-title="<?= $Page->additional_benefits->caption() ?>" data-ew-action="add-option" data-el="x_additional_benefits" data-url="<?= GetUrl("payrollbenefitsaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->additional_benefits->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->additional_benefits->getErrorMessage() ?></div>
<?= $Page->additional_benefits->Lookup->getParamTag($Page, "p_x_additional_benefits") ?>
<?php if (!$Page->additional_benefits->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayroll_fix_detailsadd", function() {
    var options = { name: "x_additional_benefits", selectId: "fpayroll_fix_detailsadd_x_additional_benefits" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayroll_fix_detailsadd.lists.additional_benefits?.lookupOptions.length) {
        options.data = { id: "x_additional_benefits", form: "fpayroll_fix_detailsadd" };
    } else {
        options.ajax = { id: "x_additional_benefits", form: "fpayroll_fix_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payroll_fix_details.fields.additional_benefits.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->extra_min_plan->Visible) { // extra_min_plan ?>
    <div id="r_extra_min_plan"<?= $Page->extra_min_plan->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_extra_min_plan" for="x_extra_min_plan" class="<?= $Page->LeftColumnClass ?>"><?= $Page->extra_min_plan->caption() ?><?= $Page->extra_min_plan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->extra_min_plan->cellAttributes() ?>>
<span id="el_payroll_fix_details_extra_min_plan">
    <select
        id="x_extra_min_plan"
        name="x_extra_min_plan"
        class="form-select ew-select<?= $Page->extra_min_plan->isInvalidClass() ?>"
        <?php if (!$Page->extra_min_plan->IsNativeSelect) { ?>
        data-select2-id="fpayroll_fix_detailsadd_x_extra_min_plan"
        <?php } ?>
        data-table="payroll_fix_details"
        data-field="x_extra_min_plan"
        data-value-separator="<?= $Page->extra_min_plan->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->extra_min_plan->getPlaceHolder()) ?>"
        <?= $Page->extra_min_plan->editAttributes() ?>>
        <?= $Page->extra_min_plan->selectOptionListHtml("x_extra_min_plan") ?>
    </select>
    <?= $Page->extra_min_plan->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->extra_min_plan->getErrorMessage() ?></div>
<?php if (!$Page->extra_min_plan->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayroll_fix_detailsadd", function() {
    var options = { name: "x_extra_min_plan", selectId: "fpayroll_fix_detailsadd_x_extra_min_plan" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayroll_fix_detailsadd.lists.extra_min_plan?.lookupOptions.length) {
        options.data = { id: "x_extra_min_plan", form: "fpayroll_fix_detailsadd" };
    } else {
        options.ajax = { id: "x_extra_min_plan", form: "fpayroll_fix_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payroll_fix_details.fields.extra_min_plan.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->office_holidays->Visible) { // office_holidays ?>
    <div id="r_office_holidays"<?= $Page->office_holidays->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_office_holidays" for="x_office_holidays" class="<?= $Page->LeftColumnClass ?>"><?= $Page->office_holidays->caption() ?><?= $Page->office_holidays->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->office_holidays->cellAttributes() ?>>
<span id="el_payroll_fix_details_office_holidays">
    <select
        id="x_office_holidays"
        name="x_office_holidays"
        class="form-select ew-select<?= $Page->office_holidays->isInvalidClass() ?>"
        <?php if (!$Page->office_holidays->IsNativeSelect) { ?>
        data-select2-id="fpayroll_fix_detailsadd_x_office_holidays"
        <?php } ?>
        data-table="payroll_fix_details"
        data-field="x_office_holidays"
        data-value-separator="<?= $Page->office_holidays->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->office_holidays->getPlaceHolder()) ?>"
        <?= $Page->office_holidays->editAttributes() ?>>
        <?= $Page->office_holidays->selectOptionListHtml("x_office_holidays") ?>
    </select>
    <?= $Page->office_holidays->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->office_holidays->getErrorMessage() ?></div>
<?php if (!$Page->office_holidays->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayroll_fix_detailsadd", function() {
    var options = { name: "x_office_holidays", selectId: "fpayroll_fix_detailsadd_x_office_holidays" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayroll_fix_detailsadd.lists.office_holidays?.lookupOptions.length) {
        options.data = { id: "x_office_holidays", form: "fpayroll_fix_detailsadd" };
    } else {
        options.ajax = { id: "x_office_holidays", form: "fpayroll_fix_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payroll_fix_details.fields.office_holidays.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->paid_annual_leave->Visible) { // paid_annual_leave ?>
    <div id="r_paid_annual_leave"<?= $Page->paid_annual_leave->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_paid_annual_leave" for="x_paid_annual_leave" class="<?= $Page->LeftColumnClass ?>"><?= $Page->paid_annual_leave->caption() ?><?= $Page->paid_annual_leave->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->paid_annual_leave->cellAttributes() ?>>
<span id="el_payroll_fix_details_paid_annual_leave">
<input type="<?= $Page->paid_annual_leave->getInputTextType() ?>" name="x_paid_annual_leave" id="x_paid_annual_leave" data-table="payroll_fix_details" data-field="x_paid_annual_leave" value="<?= $Page->paid_annual_leave->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->paid_annual_leave->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->paid_annual_leave->formatPattern()) ?>"<?= $Page->paid_annual_leave->editAttributes() ?> aria-describedby="x_paid_annual_leave_help">
<?= $Page->paid_annual_leave->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->paid_annual_leave->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->employee_pf->Visible) { // employee_pf ?>
    <div id="r_employee_pf"<?= $Page->employee_pf->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_employee_pf" for="x_employee_pf" class="<?= $Page->LeftColumnClass ?>"><?= $Page->employee_pf->caption() ?><?= $Page->employee_pf->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->employee_pf->cellAttributes() ?>>
<span id="el_payroll_fix_details_employee_pf">
    <select
        id="x_employee_pf"
        name="x_employee_pf"
        class="form-select ew-select<?= $Page->employee_pf->isInvalidClass() ?>"
        <?php if (!$Page->employee_pf->IsNativeSelect) { ?>
        data-select2-id="fpayroll_fix_detailsadd_x_employee_pf"
        <?php } ?>
        data-table="payroll_fix_details"
        data-field="x_employee_pf"
        data-value-separator="<?= $Page->employee_pf->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_pf->getPlaceHolder()) ?>"
        <?= $Page->employee_pf->editAttributes() ?>>
        <?= $Page->employee_pf->selectOptionListHtml("x_employee_pf") ?>
    </select>
    <?= $Page->employee_pf->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->employee_pf->getErrorMessage() ?></div>
<?php if (!$Page->employee_pf->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayroll_fix_detailsadd", function() {
    var options = { name: "x_employee_pf", selectId: "fpayroll_fix_detailsadd_x_employee_pf" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayroll_fix_detailsadd.lists.employee_pf?.lookupOptions.length) {
        options.data = { id: "x_employee_pf", form: "fpayroll_fix_detailsadd" };
    } else {
        options.ajax = { id: "x_employee_pf", form: "fpayroll_fix_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payroll_fix_details.fields.employee_pf.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->calculation_plan->Visible) { // calculation_plan ?>
    <div id="r_calculation_plan"<?= $Page->calculation_plan->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_calculation_plan" for="x_calculation_plan" class="<?= $Page->LeftColumnClass ?>"><?= $Page->calculation_plan->caption() ?><?= $Page->calculation_plan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->calculation_plan->cellAttributes() ?>>
<span id="el_payroll_fix_details_calculation_plan">
    <select
        id="x_calculation_plan"
        name="x_calculation_plan"
        class="form-select ew-select<?= $Page->calculation_plan->isInvalidClass() ?>"
        <?php if (!$Page->calculation_plan->IsNativeSelect) { ?>
        data-select2-id="fpayroll_fix_detailsadd_x_calculation_plan"
        <?php } ?>
        data-table="payroll_fix_details"
        data-field="x_calculation_plan"
        data-value-separator="<?= $Page->calculation_plan->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->calculation_plan->getPlaceHolder()) ?>"
        <?= $Page->calculation_plan->editAttributes() ?>>
        <?= $Page->calculation_plan->selectOptionListHtml("x_calculation_plan") ?>
    </select>
    <?= $Page->calculation_plan->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->calculation_plan->getErrorMessage() ?></div>
<?= $Page->calculation_plan->Lookup->getParamTag($Page, "p_x_calculation_plan") ?>
<?php if (!$Page->calculation_plan->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayroll_fix_detailsadd", function() {
    var options = { name: "x_calculation_plan", selectId: "fpayroll_fix_detailsadd_x_calculation_plan" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayroll_fix_detailsadd.lists.calculation_plan?.lookupOptions.length) {
        options.data = { id: "x_calculation_plan", form: "fpayroll_fix_detailsadd" };
    } else {
        options.ajax = { id: "x_calculation_plan", form: "fpayroll_fix_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payroll_fix_details.fields.calculation_plan.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_payroll_fix_details_remarks">
<textarea data-table="payroll_fix_details" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_payroll_fix_details_status">
<?php
if (IsRTL()) {
    $Page->status->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_status" class="ew-auto-suggest">
    <input type="<?= $Page->status->getInputTextType() ?>" class="form-control" name="sv_x_status" id="sv_x_status" value="<?= RemoveHtml($Page->status->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?> aria-describedby="x_status_help">
</span>
<selection-list hidden class="form-control" data-table="payroll_fix_details" data-field="x_status" data-input="sv_x_status" data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->CurrentValue) ?>"></selection-list>
<?= $Page->status->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<script>
loadjs.ready("fpayroll_fix_detailsadd", function() {
    fpayroll_fix_detailsadd.createAutoSuggest(Object.assign({"id":"x_status","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->status->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.payroll_fix_details.fields.status.autoSuggestOptions));
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->month_min->Visible) { // month_min ?>
    <div id="r_month_min"<?= $Page->month_min->rowAttributes() ?>>
        <label id="elh_payroll_fix_details_month_min" for="x_month_min" class="<?= $Page->LeftColumnClass ?>"><?= $Page->month_min->caption() ?><?= $Page->month_min->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->month_min->cellAttributes() ?>>
<span id="el_payroll_fix_details_month_min">
<input type="<?= $Page->month_min->getInputTextType() ?>" name="x_month_min" id="x_month_min" data-table="payroll_fix_details" data-field="x_month_min" value="<?= $Page->month_min->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->month_min->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->month_min->formatPattern()) ?>"<?= $Page->month_min->editAttributes() ?> aria-describedby="x_month_min_help">
<?= $Page->month_min->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->month_min->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpayroll_fix_detailsadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpayroll_fix_detailsadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payroll_fix_details");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
