<?php

namespace PHPMaker2024\fibre;

// Page object
$PaymentResponseSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payment_response: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpayment_responsesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpayment_responsesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["type", [ew.Validators.integer], fields.type.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["_userid", [ew.Validators.integer], fields._userid.isInvalid],
            ["y__userid", [ew.Validators.between], false],
            ["pg_order_number", [], fields.pg_order_number.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["cart_number", [ew.Validators.integer], fields.cart_number.isInvalid],
            ["order_id", [ew.Validators.integer], fields.order_id.isInvalid],
            ["tracking_id", [], fields.tracking_id.isInvalid],
            ["bank_ref_no", [], fields.bank_ref_no.isInvalid],
            ["order_status", [], fields.order_status.isInvalid],
            ["failure_message", [], fields.failure_message.isInvalid],
            ["payment_mode", [], fields.payment_mode.isInvalid],
            ["card_name", [], fields.card_name.isInvalid],
            ["status_code", [], fields.status_code.isInvalid],
            ["status_message", [], fields.status_message.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["trans_date", [], fields.trans_date.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["payment_gateway", [], fields.payment_gateway.isInvalid],
            ["payment_signature", [], fields.payment_signature.isInvalid],
            ["currency_id", [], fields.currency_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "status": <?= $Page->status->toClientList($Page) ?>,
            "_userid": <?= $Page->_userid->toClientList($Page) ?>,
            "currency_id": <?= $Page->currency_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpayment_responsesearch" id="fpayment_responsesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payment_response">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="payment_response" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type" class="row"<?= $Page->type->rowAttributes() ?>>
        <label for="x_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_type"><?= $Page->type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_type" id="z_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->type->getInputTextType() ?>" name="x_type" id="x_type" data-table="payment_response" data-field="x_type" value="<?= $Page->type->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->type->formatPattern()) ?>"<?= $Page->type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpayment_responsesearch_x_status"
        <?php } ?>
        data-table="payment_response"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_responsesearch", function() {
    var options = { name: "x_status", selectId: "fpayment_responsesearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_responsesearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpayment_responsesearch" };
    } else {
        options.ajax = { id: "x_status", form: "fpayment_responsesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_response.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_userid->Visible) { // userid ?>
    <div id="r__userid" class="row"<?= $Page->_userid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response__userid"><?= $Page->_userid->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_userid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z__userid" id="z__userid" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_userid->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_userid->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_payment_response__userid" class="ew-search-field">
    <select
        id="x__userid"
        name="x__userid"
        class="form-control ew-select<?= $Page->_userid->isInvalidClass() ?>"
        data-select2-id="fpayment_responsesearch_x__userid"
        data-table="payment_response"
        data-field="x__userid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->_userid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->_userid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_userid->getPlaceHolder()) ?>"
        <?= $Page->_userid->editAttributes() ?>>
        <?= $Page->_userid->selectOptionListHtml("x__userid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_userid->getErrorMessage(false) ?></div>
<?= $Page->_userid->Lookup->getParamTag($Page, "p_x__userid") ?>
<script>
loadjs.ready("fpayment_responsesearch", function() {
    var options = { name: "x__userid", selectId: "fpayment_responsesearch_x__userid" };
    if (fpayment_responsesearch.lists._userid?.lookupOptions.length) {
        options.data = { id: "x__userid", form: "fpayment_responsesearch" };
    } else {
        options.ajax = { id: "x__userid", form: "fpayment_responsesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.payment_response.fields._userid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_payment_response__userid" class="ew-search-field2 d-none">
    <select
        id="y__userid"
        name="y__userid"
        class="form-control ew-select<?= $Page->_userid->isInvalidClass() ?>"
        data-select2-id="fpayment_responsesearch_y__userid"
        data-table="payment_response"
        data-field="x__userid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->_userid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->_userid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_userid->getPlaceHolder()) ?>"
        <?= $Page->_userid->editAttributes() ?>>
        <?= $Page->_userid->selectOptionListHtml("y__userid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_userid->getErrorMessage(false) ?></div>
<?= $Page->_userid->Lookup->getParamTag($Page, "p_y__userid") ?>
<script>
loadjs.ready("fpayment_responsesearch", function() {
    var options = { name: "y__userid", selectId: "fpayment_responsesearch_y__userid" };
    if (fpayment_responsesearch.lists._userid?.lookupOptions.length) {
        options.data = { id: "y__userid", form: "fpayment_responsesearch" };
    } else {
        options.ajax = { id: "y__userid", form: "fpayment_responsesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.payment_response.fields._userid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pg_order_number->Visible) { // pg_order_number ?>
    <div id="r_pg_order_number" class="row"<?= $Page->pg_order_number->rowAttributes() ?>>
        <label for="x_pg_order_number" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_pg_order_number"><?= $Page->pg_order_number->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pg_order_number" id="z_pg_order_number" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pg_order_number->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_pg_order_number" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pg_order_number->getInputTextType() ?>" name="x_pg_order_number" id="x_pg_order_number" data-table="payment_response" data-field="x_pg_order_number" value="<?= $Page->pg_order_number->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->pg_order_number->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pg_order_number->formatPattern()) ?>"<?= $Page->pg_order_number->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pg_order_number->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="payment_response" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cart_number->Visible) { // cart_number ?>
    <div id="r_cart_number" class="row"<?= $Page->cart_number->rowAttributes() ?>>
        <label for="x_cart_number" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_cart_number"><?= $Page->cart_number->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cart_number" id="z_cart_number" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cart_number->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_cart_number" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cart_number->getInputTextType() ?>" name="x_cart_number" id="x_cart_number" data-table="payment_response" data-field="x_cart_number" value="<?= $Page->cart_number->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cart_number->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_number->formatPattern()) ?>"<?= $Page->cart_number->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cart_number->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_id->Visible) { // order_id ?>
    <div id="r_order_id" class="row"<?= $Page->order_id->rowAttributes() ?>>
        <label for="x_order_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_order_id"><?= $Page->order_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_order_id" id="z_order_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_order_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_id->getInputTextType() ?>" name="x_order_id" id="x_order_id" data-table="payment_response" data-field="x_order_id" value="<?= $Page->order_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->order_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_id->formatPattern()) ?>"<?= $Page->order_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tracking_id->Visible) { // tracking_id ?>
    <div id="r_tracking_id" class="row"<?= $Page->tracking_id->rowAttributes() ?>>
        <label for="x_tracking_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_tracking_id"><?= $Page->tracking_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_tracking_id" id="z_tracking_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tracking_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_tracking_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tracking_id->getInputTextType() ?>" name="x_tracking_id" id="x_tracking_id" data-table="payment_response" data-field="x_tracking_id" value="<?= $Page->tracking_id->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->tracking_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tracking_id->formatPattern()) ?>"<?= $Page->tracking_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tracking_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_ref_no->Visible) { // bank_ref_no ?>
    <div id="r_bank_ref_no" class="row"<?= $Page->bank_ref_no->rowAttributes() ?>>
        <label for="x_bank_ref_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_bank_ref_no"><?= $Page->bank_ref_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bank_ref_no" id="z_bank_ref_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_ref_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_bank_ref_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bank_ref_no->getInputTextType() ?>" name="x_bank_ref_no" id="x_bank_ref_no" data-table="payment_response" data-field="x_bank_ref_no" value="<?= $Page->bank_ref_no->EditValue ?>" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->bank_ref_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_ref_no->formatPattern()) ?>"<?= $Page->bank_ref_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bank_ref_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_status->Visible) { // order_status ?>
    <div id="r_order_status" class="row"<?= $Page->order_status->rowAttributes() ?>>
        <label for="x_order_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_order_status"><?= $Page->order_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_order_status" id="z_order_status" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_order_status" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_status->getInputTextType() ?>" name="x_order_status" id="x_order_status" data-table="payment_response" data-field="x_order_status" value="<?= $Page->order_status->EditValue ?>" size="30" maxlength="15" placeholder="<?= HtmlEncode($Page->order_status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_status->formatPattern()) ?>"<?= $Page->order_status->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_status->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->failure_message->Visible) { // failure_message ?>
    <div id="r_failure_message" class="row"<?= $Page->failure_message->rowAttributes() ?>>
        <label for="x_failure_message" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_failure_message"><?= $Page->failure_message->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_failure_message" id="z_failure_message" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->failure_message->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_failure_message" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->failure_message->getInputTextType() ?>" name="x_failure_message" id="x_failure_message" data-table="payment_response" data-field="x_failure_message" value="<?= $Page->failure_message->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->failure_message->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->failure_message->formatPattern()) ?>"<?= $Page->failure_message->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->failure_message->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment_mode->Visible) { // payment_mode ?>
    <div id="r_payment_mode" class="row"<?= $Page->payment_mode->rowAttributes() ?>>
        <label for="x_payment_mode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_payment_mode"><?= $Page->payment_mode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_payment_mode" id="z_payment_mode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment_mode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_payment_mode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->payment_mode->getInputTextType() ?>" name="x_payment_mode" id="x_payment_mode" data-table="payment_response" data-field="x_payment_mode" value="<?= $Page->payment_mode->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->payment_mode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->payment_mode->formatPattern()) ?>"<?= $Page->payment_mode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->payment_mode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->card_name->Visible) { // card_name ?>
    <div id="r_card_name" class="row"<?= $Page->card_name->rowAttributes() ?>>
        <label for="x_card_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_card_name"><?= $Page->card_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_card_name" id="z_card_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->card_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_card_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->card_name->getInputTextType() ?>" name="x_card_name" id="x_card_name" data-table="payment_response" data-field="x_card_name" value="<?= $Page->card_name->EditValue ?>" size="30" maxlength="30" placeholder="<?= HtmlEncode($Page->card_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->card_name->formatPattern()) ?>"<?= $Page->card_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->card_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status_code->Visible) { // status_code ?>
    <div id="r_status_code" class="row"<?= $Page->status_code->rowAttributes() ?>>
        <label for="x_status_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_status_code"><?= $Page->status_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_status_code" id="z_status_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_status_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->status_code->getInputTextType() ?>" name="x_status_code" id="x_status_code" data-table="payment_response" data-field="x_status_code" value="<?= $Page->status_code->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->status_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status_code->formatPattern()) ?>"<?= $Page->status_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->status_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status_message->Visible) { // status_message ?>
    <div id="r_status_message" class="row"<?= $Page->status_message->rowAttributes() ?>>
        <label for="x_status_message" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_status_message"><?= $Page->status_message->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_status_message" id="z_status_message" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status_message->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_status_message" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->status_message->getInputTextType() ?>" name="x_status_message" id="x_status_message" data-table="payment_response" data-field="x_status_message" value="<?= $Page->status_message->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->status_message->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status_message->formatPattern()) ?>"<?= $Page->status_message->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->status_message->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="payment_response" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->trans_date->Visible) { // trans_date ?>
    <div id="r_trans_date" class="row"<?= $Page->trans_date->rowAttributes() ?>>
        <label for="x_trans_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_trans_date"><?= $Page->trans_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_trans_date" id="z_trans_date" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->trans_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_trans_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->trans_date->getInputTextType() ?>" name="x_trans_date" id="x_trans_date" data-table="payment_response" data-field="x_trans_date" value="<?= $Page->trans_date->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->trans_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->trans_date->formatPattern()) ?>"<?= $Page->trans_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->trans_date->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="payment_response" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayment_responsesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayment_responsesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment_gateway->Visible) { // payment_gateway ?>
    <div id="r_payment_gateway" class="row"<?= $Page->payment_gateway->rowAttributes() ?>>
        <label for="x_payment_gateway" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_payment_gateway"><?= $Page->payment_gateway->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_payment_gateway" id="z_payment_gateway" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment_gateway->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_payment_gateway" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->payment_gateway->getInputTextType() ?>" name="x_payment_gateway" id="x_payment_gateway" data-table="payment_response" data-field="x_payment_gateway" value="<?= $Page->payment_gateway->EditValue ?>" size="30" maxlength="30" placeholder="<?= HtmlEncode($Page->payment_gateway->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->payment_gateway->formatPattern()) ?>"<?= $Page->payment_gateway->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->payment_gateway->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment_signature->Visible) { // payment_signature ?>
    <div id="r_payment_signature" class="row"<?= $Page->payment_signature->rowAttributes() ?>>
        <label for="x_payment_signature" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_payment_signature"><?= $Page->payment_signature->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_payment_signature" id="z_payment_signature" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment_signature->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_payment_signature" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->payment_signature->getInputTextType() ?>" name="x_payment_signature" id="x_payment_signature" data-table="payment_response" data-field="x_payment_signature" value="<?= $Page->payment_signature->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->payment_signature->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->payment_signature->formatPattern()) ?>"<?= $Page->payment_signature->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->payment_signature->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency_id->Visible) { // currency_id ?>
    <div id="r_currency_id" class="row"<?= $Page->currency_id->rowAttributes() ?>>
        <label for="x_currency_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_response_currency_id"><?= $Page->currency_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency_id" id="z_currency_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_response_currency_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency_id"
        name="x_currency_id"
        class="form-select ew-select<?= $Page->currency_id->isInvalidClass() ?>"
        <?php if (!$Page->currency_id->IsNativeSelect) { ?>
        data-select2-id="fpayment_responsesearch_x_currency_id"
        <?php } ?>
        data-table="payment_response"
        data-field="x_currency_id"
        data-value-separator="<?= $Page->currency_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency_id->getPlaceHolder()) ?>"
        <?= $Page->currency_id->editAttributes() ?>>
        <?= $Page->currency_id->selectOptionListHtml("x_currency_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency_id->getErrorMessage(false) ?></div>
<?= $Page->currency_id->Lookup->getParamTag($Page, "p_x_currency_id") ?>
<?php if (!$Page->currency_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_responsesearch", function() {
    var options = { name: "x_currency_id", selectId: "fpayment_responsesearch_x_currency_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_responsesearch.lists.currency_id?.lookupOptions.length) {
        options.data = { id: "x_currency_id", form: "fpayment_responsesearch" };
    } else {
        options.ajax = { id: "x_currency_id", form: "fpayment_responsesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_response.fields.currency_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpayment_responsesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpayment_responsesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpayment_responsesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payment_response");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
