<?php

namespace PHPMaker2024\fibre;

// Page object
$PaymentResponseList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payment_response: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fpayment_responsesrch" id="fpayment_responsesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fpayment_responsesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payment_response: currentTable } });
var currentForm;
var fpayment_responsesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpayment_responsesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["status", [], fields.status.isInvalid],
            ["_userid", [ew.Validators.integer], fields._userid.isInvalid],
            ["y__userid", [ew.Validators.between], false],
            ["pg_order_number", [], fields.pg_order_number.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "status": <?= $Page->status->toClientList($Page) ?>,
            "_userid": <?= $Page->_userid->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->status->Visible) { // status ?>
<?php
if (!$Page->status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->status->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_status" class="ew-search-caption ew-label"><?= $Page->status->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</div>
        </div>
        <div id="el_payment_response_status" class="ew-search-field">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpayment_responsesrch_x_status"
        <?php } ?>
        data-table="payment_response"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_responsesrch", function() {
    var options = { name: "x_status", selectId: "fpayment_responsesrch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_responsesrch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpayment_responsesrch" };
    } else {
        options.ajax = { id: "x_status", form: "fpayment_responsesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_response.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_userid->Visible) { // userid ?>
<?php
if (!$Page->_userid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__userid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_userid->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->_userid->caption() ?></label>
            <div class="ew-search-operator">
<select name="z__userid" id="z__userid" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_userid->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_userid->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_payment_response__userid" class="ew-search-field">
    <select
        id="x__userid"
        name="x__userid"
        class="form-control ew-select<?= $Page->_userid->isInvalidClass() ?>"
        data-select2-id="fpayment_responsesrch_x__userid"
        data-table="payment_response"
        data-field="x__userid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->_userid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->_userid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_userid->getPlaceHolder()) ?>"
        <?= $Page->_userid->editAttributes() ?>>
        <?= $Page->_userid->selectOptionListHtml("x__userid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_userid->getErrorMessage(false) ?></div>
<?= $Page->_userid->Lookup->getParamTag($Page, "p_x__userid") ?>
<script>
loadjs.ready("fpayment_responsesrch", function() {
    var options = { name: "x__userid", selectId: "fpayment_responsesrch_x__userid" };
    if (fpayment_responsesrch.lists._userid?.lookupOptions.length) {
        options.data = { id: "x__userid", form: "fpayment_responsesrch" };
    } else {
        options.ajax = { id: "x__userid", form: "fpayment_responsesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.payment_response.fields._userid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_payment_response__userid" class="ew-search-field2 d-none">
    <select
        id="y__userid"
        name="y__userid"
        class="form-control ew-select<?= $Page->_userid->isInvalidClass() ?>"
        data-select2-id="fpayment_responsesrch_y__userid"
        data-table="payment_response"
        data-field="x__userid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->_userid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->_userid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_userid->getPlaceHolder()) ?>"
        <?= $Page->_userid->editAttributes() ?>>
        <?= $Page->_userid->selectOptionListHtml("y__userid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_userid->getErrorMessage(false) ?></div>
<?= $Page->_userid->Lookup->getParamTag($Page, "p_y__userid") ?>
<script>
loadjs.ready("fpayment_responsesrch", function() {
    var options = { name: "y__userid", selectId: "fpayment_responsesrch_y__userid" };
    if (fpayment_responsesrch.lists._userid?.lookupOptions.length) {
        options.data = { id: "y__userid", form: "fpayment_responsesrch" };
    } else {
        options.ajax = { id: "y__userid", form: "fpayment_responsesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.payment_response.fields._userid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->pg_order_number->Visible) { // pg_order_number ?>
<?php
if (!$Page->pg_order_number->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_pg_order_number" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->pg_order_number->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_pg_order_number" class="ew-search-caption ew-label"><?= $Page->pg_order_number->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pg_order_number" id="z_pg_order_number" value="LIKE">
</div>
        </div>
        <div id="el_payment_response_pg_order_number" class="ew-search-field">
<input type="<?= $Page->pg_order_number->getInputTextType() ?>" name="x_pg_order_number" id="x_pg_order_number" data-table="payment_response" data-field="x_pg_order_number" value="<?= $Page->pg_order_number->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->pg_order_number->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pg_order_number->formatPattern()) ?>"<?= $Page->pg_order_number->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pg_order_number->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fpayment_responsesrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fpayment_responsesrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fpayment_responsesrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fpayment_responsesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fpayment_responsesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fpayment_responsesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fpayment_responsesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payment_response">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_payment_response" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_payment_responselist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_payment_response_id" class="payment_response_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
        <th data-name="type" class="<?= $Page->type->headerCellClass() ?>"><div id="elh_payment_response_type" class="payment_response_type"><?= $Page->renderFieldHeader($Page->type) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_payment_response_status" class="payment_response_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->_userid->Visible) { // userid ?>
        <th data-name="_userid" class="<?= $Page->_userid->headerCellClass() ?>"><div id="elh_payment_response__userid" class="payment_response__userid"><?= $Page->renderFieldHeader($Page->_userid) ?></div></th>
<?php } ?>
<?php if ($Page->pg_order_number->Visible) { // pg_order_number ?>
        <th data-name="pg_order_number" class="<?= $Page->pg_order_number->headerCellClass() ?>"><div id="elh_payment_response_pg_order_number" class="payment_response_pg_order_number"><?= $Page->renderFieldHeader($Page->pg_order_number) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_payment_response_remarks" class="payment_response_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->order_id->Visible) { // order_id ?>
        <th data-name="order_id" class="<?= $Page->order_id->headerCellClass() ?>"><div id="elh_payment_response_order_id" class="payment_response_order_id"><?= $Page->renderFieldHeader($Page->order_id) ?></div></th>
<?php } ?>
<?php if ($Page->tracking_id->Visible) { // tracking_id ?>
        <th data-name="tracking_id" class="<?= $Page->tracking_id->headerCellClass() ?>"><div id="elh_payment_response_tracking_id" class="payment_response_tracking_id"><?= $Page->renderFieldHeader($Page->tracking_id) ?></div></th>
<?php } ?>
<?php if ($Page->bank_ref_no->Visible) { // bank_ref_no ?>
        <th data-name="bank_ref_no" class="<?= $Page->bank_ref_no->headerCellClass() ?>"><div id="elh_payment_response_bank_ref_no" class="payment_response_bank_ref_no"><?= $Page->renderFieldHeader($Page->bank_ref_no) ?></div></th>
<?php } ?>
<?php if ($Page->order_status->Visible) { // order_status ?>
        <th data-name="order_status" class="<?= $Page->order_status->headerCellClass() ?>"><div id="elh_payment_response_order_status" class="payment_response_order_status"><?= $Page->renderFieldHeader($Page->order_status) ?></div></th>
<?php } ?>
<?php if ($Page->failure_message->Visible) { // failure_message ?>
        <th data-name="failure_message" class="<?= $Page->failure_message->headerCellClass() ?>"><div id="elh_payment_response_failure_message" class="payment_response_failure_message"><?= $Page->renderFieldHeader($Page->failure_message) ?></div></th>
<?php } ?>
<?php if ($Page->payment_mode->Visible) { // payment_mode ?>
        <th data-name="payment_mode" class="<?= $Page->payment_mode->headerCellClass() ?>"><div id="elh_payment_response_payment_mode" class="payment_response_payment_mode"><?= $Page->renderFieldHeader($Page->payment_mode) ?></div></th>
<?php } ?>
<?php if ($Page->card_name->Visible) { // card_name ?>
        <th data-name="card_name" class="<?= $Page->card_name->headerCellClass() ?>"><div id="elh_payment_response_card_name" class="payment_response_card_name"><?= $Page->renderFieldHeader($Page->card_name) ?></div></th>
<?php } ?>
<?php if ($Page->status_code->Visible) { // status_code ?>
        <th data-name="status_code" class="<?= $Page->status_code->headerCellClass() ?>"><div id="elh_payment_response_status_code" class="payment_response_status_code"><?= $Page->renderFieldHeader($Page->status_code) ?></div></th>
<?php } ?>
<?php if ($Page->status_message->Visible) { // status_message ?>
        <th data-name="status_message" class="<?= $Page->status_message->headerCellClass() ?>"><div id="elh_payment_response_status_message" class="payment_response_status_message"><?= $Page->renderFieldHeader($Page->status_message) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>"><div id="elh_payment_response_amount" class="payment_response_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php if ($Page->trans_date->Visible) { // trans_date ?>
        <th data-name="trans_date" class="<?= $Page->trans_date->headerCellClass() ?>"><div id="elh_payment_response_trans_date" class="payment_response_trans_date"><?= $Page->renderFieldHeader($Page->trans_date) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_payment_response_datetime" class="payment_response_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->payment_gateway->Visible) { // payment_gateway ?>
        <th data-name="payment_gateway" class="<?= $Page->payment_gateway->headerCellClass() ?>"><div id="elh_payment_response_payment_gateway" class="payment_response_payment_gateway"><?= $Page->renderFieldHeader($Page->payment_gateway) ?></div></th>
<?php } ?>
<?php if ($Page->currency_id->Visible) { // currency_id ?>
        <th data-name="currency_id" class="<?= $Page->currency_id->headerCellClass() ?>"><div id="elh_payment_response_currency_id" class="payment_response_currency_id"><?= $Page->renderFieldHeader($Page->currency_id) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_id" class="el_payment_response_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->type->Visible) { // type ?>
        <td data-name="type"<?= $Page->type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_type" class="el_payment_response_type">
<span<?= $Page->type->viewAttributes() ?>>
<?php if (!EmptyString($Page->type->getViewValue()) && $Page->type->linkAttributes() != "") { ?>
<a<?= $Page->type->linkAttributes() ?>><?= $Page->type->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_status" class="el_payment_response_status">
<span<?= $Page->status->viewAttributes() ?>>
<?php if (!EmptyString($Page->status->getViewValue()) && $Page->status->linkAttributes() != "") { ?>
<a<?= $Page->status->linkAttributes() ?>><?= $Page->status->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->status->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_userid->Visible) { // userid ?>
        <td data-name="_userid"<?= $Page->_userid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response__userid" class="el_payment_response__userid">
<span<?= $Page->_userid->viewAttributes() ?>>
<?php if (!EmptyString($Page->_userid->getViewValue()) && $Page->_userid->linkAttributes() != "") { ?>
<a<?= $Page->_userid->linkAttributes() ?>><?= $Page->_userid->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->_userid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pg_order_number->Visible) { // pg_order_number ?>
        <td data-name="pg_order_number"<?= $Page->pg_order_number->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_pg_order_number" class="el_payment_response_pg_order_number">
<span<?= $Page->pg_order_number->viewAttributes() ?>>
<?= $Page->pg_order_number->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_remarks" class="el_payment_response_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->order_id->Visible) { // order_id ?>
        <td data-name="order_id"<?= $Page->order_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_order_id" class="el_payment_response_order_id">
<span<?= $Page->order_id->viewAttributes() ?>>
<?= $Page->order_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->tracking_id->Visible) { // tracking_id ?>
        <td data-name="tracking_id"<?= $Page->tracking_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_tracking_id" class="el_payment_response_tracking_id">
<span<?= $Page->tracking_id->viewAttributes() ?>>
<?= $Page->tracking_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->bank_ref_no->Visible) { // bank_ref_no ?>
        <td data-name="bank_ref_no"<?= $Page->bank_ref_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_bank_ref_no" class="el_payment_response_bank_ref_no">
<span<?= $Page->bank_ref_no->viewAttributes() ?>>
<?= $Page->bank_ref_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->order_status->Visible) { // order_status ?>
        <td data-name="order_status"<?= $Page->order_status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_order_status" class="el_payment_response_order_status">
<span<?= $Page->order_status->viewAttributes() ?>>
<?= $Page->order_status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->failure_message->Visible) { // failure_message ?>
        <td data-name="failure_message"<?= $Page->failure_message->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_failure_message" class="el_payment_response_failure_message">
<span<?= $Page->failure_message->viewAttributes() ?>>
<?= $Page->failure_message->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->payment_mode->Visible) { // payment_mode ?>
        <td data-name="payment_mode"<?= $Page->payment_mode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_payment_mode" class="el_payment_response_payment_mode">
<span<?= $Page->payment_mode->viewAttributes() ?>>
<?= $Page->payment_mode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->card_name->Visible) { // card_name ?>
        <td data-name="card_name"<?= $Page->card_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_card_name" class="el_payment_response_card_name">
<span<?= $Page->card_name->viewAttributes() ?>>
<?= $Page->card_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status_code->Visible) { // status_code ?>
        <td data-name="status_code"<?= $Page->status_code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_status_code" class="el_payment_response_status_code">
<span<?= $Page->status_code->viewAttributes() ?>>
<?= $Page->status_code->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status_message->Visible) { // status_message ?>
        <td data-name="status_message"<?= $Page->status_message->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_status_message" class="el_payment_response_status_message">
<span<?= $Page->status_message->viewAttributes() ?>>
<?= $Page->status_message->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_amount" class="el_payment_response_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?= $Page->amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->trans_date->Visible) { // trans_date ?>
        <td data-name="trans_date"<?= $Page->trans_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_trans_date" class="el_payment_response_trans_date">
<span<?= $Page->trans_date->viewAttributes() ?>>
<?= $Page->trans_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_datetime" class="el_payment_response_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->payment_gateway->Visible) { // payment_gateway ?>
        <td data-name="payment_gateway"<?= $Page->payment_gateway->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_payment_gateway" class="el_payment_response_payment_gateway">
<span<?= $Page->payment_gateway->viewAttributes() ?>>
<?= $Page->payment_gateway->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->currency_id->Visible) { // currency_id ?>
        <td data-name="currency_id"<?= $Page->currency_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_response_currency_id" class="el_payment_response_currency_id">
<span<?= $Page->currency_id->viewAttributes() ?>>
<?= $Page->currency_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payment_response");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
