<?php

namespace PHPMaker2024\fibre;

// Page object
$PaymentPlanSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payment_plan: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpayment_plansearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpayment_plansearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["plan_type", [], fields.plan_type.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["from_date", [ew.Validators.datetime(fields.from_date.clientFormatPattern)], fields.from_date.isInvalid],
            ["to_date", [ew.Validators.datetime(fields.to_date.clientFormatPattern)], fields.to_date.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["product_type", [], fields.product_type.isInvalid],
            ["y_product_type", [ew.Validators.between], false],
            ["shape", [], fields.shape.isInvalid],
            ["selection", [], fields.selection.isInvalid],
            ["gcode", [], fields.gcode.isInvalid],
            ["ref", [], fields.ref.isInvalid],
            ["description", [], fields.description.isInvalid],
            ["yes_no", [], fields.yes_no.isInvalid],
            ["packing_payment_type", [], fields.packing_payment_type.isInvalid],
            ["fix", [], fields.fix.isInvalid],
            ["method", [], fields.method.isInvalid],
            ["sqm_method", [], fields.sqm_method.isInvalid],
            ["unit", [], fields.unit.isInvalid],
            ["_unit", [ew.Validators.float], fields._unit.isInvalid],
            ["_40", [ew.Validators.float], fields._40.isInvalid],
            ["extra_plan", [], fields.extra_plan.isInvalid],
            ["custom_size", [ew.Validators.float], fields.custom_size.isInvalid],
            ["custom_size_below_st", [ew.Validators.float], fields.custom_size_below_st.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["uploads", [], fields.uploads.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "plan_type": <?= $Page->plan_type->toClientList($Page) ?>,
            "location": <?= $Page->location->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "shape": <?= $Page->shape->toClientList($Page) ?>,
            "selection": <?= $Page->selection->toClientList($Page) ?>,
            "gcode": <?= $Page->gcode->toClientList($Page) ?>,
            "ref": <?= $Page->ref->toClientList($Page) ?>,
            "yes_no": <?= $Page->yes_no->toClientList($Page) ?>,
            "packing_payment_type": <?= $Page->packing_payment_type->toClientList($Page) ?>,
            "fix": <?= $Page->fix->toClientList($Page) ?>,
            "method": <?= $Page->method->toClientList($Page) ?>,
            "sqm_method": <?= $Page->sqm_method->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "extra_plan": <?= $Page->extra_plan->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpayment_plansearch" id="fpayment_plansearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payment_plan">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="payment_plan" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->plan_type->Visible) { // plan_type ?>
    <div id="r_plan_type" class="row"<?= $Page->plan_type->rowAttributes() ?>>
        <label for="x_plan_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_plan_type"><?= $Page->plan_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_plan_type" id="z_plan_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->plan_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_plan_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_plan_type"
        name="x_plan_type"
        class="form-select ew-select<?= $Page->plan_type->isInvalidClass() ?>"
        <?php if (!$Page->plan_type->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_plan_type"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_plan_type"
        data-value-separator="<?= $Page->plan_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->plan_type->getPlaceHolder()) ?>"
        <?= $Page->plan_type->editAttributes() ?>>
        <?= $Page->plan_type->selectOptionListHtml("x_plan_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->plan_type->getErrorMessage(false) ?></div>
<?php if (!$Page->plan_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_plan_type", selectId: "fpayment_plansearch_x_plan_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.plan_type?.lookupOptions.length) {
        options.data = { id: "x_plan_type", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_plan_type", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.plan_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_location" id="z_location" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location[]"
        name="x_location[]"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_location[]"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_location"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_location[]", selectId: "fpayment_plansearch_x_location[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 3;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown payment_plan-x_location-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location[]", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_location[]", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->from_date->Visible) { // from_date ?>
    <div id="r_from_date" class="row"<?= $Page->from_date->rowAttributes() ?>>
        <label for="x_from_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_from_date"><?= $Page->from_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_from_date" id="z_from_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->from_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_from_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->from_date->getInputTextType() ?>" name="x_from_date" id="x_from_date" data-table="payment_plan" data-field="x_from_date" value="<?= $Page->from_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->from_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->from_date->formatPattern()) ?>"<?= $Page->from_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->from_date->getErrorMessage(false) ?></div>
<?php if (!$Page->from_date->ReadOnly && !$Page->from_date->Disabled && !isset($Page->from_date->EditAttrs["readonly"]) && !isset($Page->from_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayment_plansearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayment_plansearch", "x_from_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->to_date->Visible) { // to_date ?>
    <div id="r_to_date" class="row"<?= $Page->to_date->rowAttributes() ?>>
        <label for="x_to_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_to_date"><?= $Page->to_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_to_date" id="z_to_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->to_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_to_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->to_date->getInputTextType() ?>" name="x_to_date" id="x_to_date" data-table="payment_plan" data-field="x_to_date" value="<?= $Page->to_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->to_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->to_date->formatPattern()) ?>"<?= $Page->to_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->to_date->getErrorMessage(false) ?></div>
<?php if (!$Page->to_date->ReadOnly && !$Page->to_date->Disabled && !isset($Page->to_date->EditAttrs["readonly"]) && !isset($Page->to_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayment_plansearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayment_plansearch", "x_to_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_grp"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_grp", selectId: "fpayment_plansearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_s_grp"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_s_grp", selectId: "fpayment_plansearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label for="x_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process" id="z_process" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_process"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_process", selectId: "fpayment_plansearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_process", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type" class="row"<?= $Page->product_type->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_product_type"><?= $Page->product_type->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_product_type" id="z_product_type" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->product_type->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->product_type->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_payment_plan_product_type" class="ew-search-field">
<template id="tp_x_product_type">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="payment_plan" data-field="x_product_type" name="x_product_type" id="x_product_type"<?= $Page->product_type->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_product_type" class="ew-item-list"></div>
<selection-list hidden
    id="x_product_type[]"
    name="x_product_type[]"
    value="<?= HtmlEncode($Page->product_type->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_product_type"
    data-target="dsl_x_product_type"
    data-repeatcolumn="3"
    class="form-control<?= $Page->product_type->isInvalidClass() ?>"
    data-table="payment_plan"
    data-field="x_product_type"
    data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
    <?= $Page->product_type->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_payment_plan_product_type" class="ew-search-field2 d-none">
<template id="tp_y_product_type">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="payment_plan" data-field="x_product_type" name="y_product_type" id="y_product_type"<?= $Page->product_type->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_y_product_type" class="ew-item-list"></div>
<selection-list hidden
    id="y_product_type[]"
    name="y_product_type[]"
    value="<?= HtmlEncode($Page->product_type->AdvancedSearch->SearchValue2) ?>"
    data-type="select-multiple"
    data-template="tp_y_product_type"
    data-target="dsl_y_product_type"
    data-repeatcolumn="3"
    class="form-control<?= $Page->product_type->isInvalidClass() ?>"
    data-table="payment_plan"
    data-field="x_product_type"
    data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
    <?= $Page->product_type->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_y_product_type") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
    <div id="r_shape" class="row"<?= $Page->shape->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_shape"><?= $Page->shape->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_shape" id="z_shape" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shape->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_shape" class="ew-search-field ew-search-field-single">
<template id="tp_x_shape">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="payment_plan" data-field="x_shape" name="x_shape" id="x_shape"<?= $Page->shape->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_shape" class="ew-item-list"></div>
<selection-list hidden
    id="x_shape[]"
    name="x_shape[]"
    value="<?= HtmlEncode($Page->shape->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_shape"
    data-target="dsl_x_shape"
    data-repeatcolumn="3"
    class="form-control<?= $Page->shape->isInvalidClass() ?>"
    data-table="payment_plan"
    data-field="x_shape"
    data-value-separator="<?= $Page->shape->displayValueSeparatorAttribute() ?>"
    <?= $Page->shape->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->shape->getErrorMessage(false) ?></div>
<?= $Page->shape->Lookup->getParamTag($Page, "p_x_shape") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->selection->Visible) { // selection ?>
    <div id="r_selection" class="row"<?= $Page->selection->rowAttributes() ?>>
        <label for="x_selection" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_selection"><?= $Page->selection->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_selection" id="z_selection" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->selection->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_selection" class="ew-search-field ew-search-field-single">
    <select
        id="x_selection"
        name="x_selection"
        class="form-select ew-select<?= $Page->selection->isInvalidClass() ?>"
        <?php if (!$Page->selection->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_selection"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_selection"
        data-value-separator="<?= $Page->selection->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->selection->getPlaceHolder()) ?>"
        <?= $Page->selection->editAttributes() ?>>
        <?= $Page->selection->selectOptionListHtml("x_selection") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->selection->getErrorMessage(false) ?></div>
<?php if (!$Page->selection->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_selection", selectId: "fpayment_plansearch_x_selection" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.selection?.lookupOptions.length) {
        options.data = { id: "x_selection", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_selection", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.selection.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gcode->Visible) { // gcode ?>
    <div id="r_gcode" class="row"<?= $Page->gcode->rowAttributes() ?>>
        <label for="x_gcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_gcode"><?= $Page->gcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_gcode" id="z_gcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_gcode" class="ew-search-field ew-search-field-single">
    <select
        id="x_gcode[]"
        name="x_gcode[]"
        class="form-control ew-select<?= $Page->gcode->isInvalidClass() ?>"
        data-select2-id="fpayment_plansearch_x_gcode[]"
        data-table="payment_plan"
        data-field="x_gcode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->gcode->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->gcode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gcode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->gcode->editAttributes() ?>>
        <?= $Page->gcode->selectOptionListHtml("x_gcode[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->gcode->getErrorMessage(false) ?></div>
<?= $Page->gcode->Lookup->getParamTag($Page, "p_x_gcode") ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_gcode[]", selectId: "fpayment_plansearch_x_gcode[]" };
    options.multiple = true;
    if (fpayment_plansearch.lists.gcode?.lookupOptions.length) {
        options.data = { id: "x_gcode[]", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_gcode[]", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.payment_plan.fields.gcode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref" class="row"<?= $Page->ref->rowAttributes() ?>>
        <label for="x_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_ref"><?= $Page->ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ref" id="z_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_ref" class="ew-search-field ew-search-field-single">
    <select
        id="x_ref[]"
        name="x_ref[]"
        class="form-control ew-select<?= $Page->ref->isInvalidClass() ?>"
        data-select2-id="fpayment_plansearch_x_ref[]"
        data-table="payment_plan"
        data-field="x_ref"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->ref->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>"
        <?= $Page->ref->editAttributes() ?>>
        <?= $Page->ref->selectOptionListHtml("x_ref[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
<?= $Page->ref->Lookup->getParamTag($Page, "p_x_ref") ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_ref[]", selectId: "fpayment_plansearch_x_ref[]" };
    options.multiple = true;
    if (fpayment_plansearch.lists.ref?.lookupOptions.length) {
        options.data = { id: "x_ref[]", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_ref[]", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.payment_plan.fields.ref.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description" class="row"<?= $Page->description->rowAttributes() ?>>
        <label for="x_description" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_description"><?= $Page->description->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description" id="z_description" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="payment_plan" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->yes_no->Visible) { // yes_no ?>
    <div id="r_yes_no" class="row"<?= $Page->yes_no->rowAttributes() ?>>
        <label for="x_yes_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_yes_no"><?= $Page->yes_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_yes_no" id="z_yes_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->yes_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_yes_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_yes_no"
        name="x_yes_no"
        class="form-select ew-select<?= $Page->yes_no->isInvalidClass() ?>"
        <?php if (!$Page->yes_no->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_yes_no"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_yes_no"
        data-value-separator="<?= $Page->yes_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->yes_no->getPlaceHolder()) ?>"
        <?= $Page->yes_no->editAttributes() ?>>
        <?= $Page->yes_no->selectOptionListHtml("x_yes_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->yes_no->getErrorMessage(false) ?></div>
<?php if (!$Page->yes_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_yes_no", selectId: "fpayment_plansearch_x_yes_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.yes_no?.lookupOptions.length) {
        options.data = { id: "x_yes_no", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_yes_no", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.yes_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_payment_type->Visible) { // packing_payment_type ?>
    <div id="r_packing_payment_type" class="row"<?= $Page->packing_payment_type->rowAttributes() ?>>
        <label for="x_packing_payment_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_packing_payment_type"><?= $Page->packing_payment_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_payment_type" id="z_packing_payment_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_payment_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_packing_payment_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_payment_type"
        name="x_packing_payment_type"
        class="form-select ew-select<?= $Page->packing_payment_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_payment_type->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_packing_payment_type"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_packing_payment_type"
        data-value-separator="<?= $Page->packing_payment_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_payment_type->getPlaceHolder()) ?>"
        <?= $Page->packing_payment_type->editAttributes() ?>>
        <?= $Page->packing_payment_type->selectOptionListHtml("x_packing_payment_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_payment_type->getErrorMessage(false) ?></div>
<?php if (!$Page->packing_payment_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_packing_payment_type", selectId: "fpayment_plansearch_x_packing_payment_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.packing_payment_type?.lookupOptions.length) {
        options.data = { id: "x_packing_payment_type", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_packing_payment_type", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.packing_payment_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fix->Visible) { // fix ?>
    <div id="r_fix" class="row"<?= $Page->fix->rowAttributes() ?>>
        <label for="x_fix" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_fix"><?= $Page->fix->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_fix" id="z_fix" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fix->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_fix" class="ew-search-field ew-search-field-single">
    <select
        id="x_fix"
        name="x_fix"
        class="form-select ew-select<?= $Page->fix->isInvalidClass() ?>"
        <?php if (!$Page->fix->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_fix"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_fix"
        data-value-separator="<?= $Page->fix->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->fix->getPlaceHolder()) ?>"
        <?= $Page->fix->editAttributes() ?>>
        <?= $Page->fix->selectOptionListHtml("x_fix") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->fix->getErrorMessage(false) ?></div>
<?php if (!$Page->fix->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_fix", selectId: "fpayment_plansearch_x_fix" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.fix?.lookupOptions.length) {
        options.data = { id: "x_fix", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_fix", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.fix.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method" class="row"<?= $Page->method->rowAttributes() ?>>
        <label for="x_method" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_method"><?= $Page->method->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_method" id="z_method" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->method->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_method" class="ew-search-field ew-search-field-single">
    <select
        id="x_method"
        name="x_method"
        class="form-select ew-select<?= $Page->method->isInvalidClass() ?>"
        <?php if (!$Page->method->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_method"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_method"
        data-value-separator="<?= $Page->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>"
        <?= $Page->method->editAttributes() ?>>
        <?= $Page->method->selectOptionListHtml("x_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->method->getErrorMessage(false) ?></div>
<?= $Page->method->Lookup->getParamTag($Page, "p_x_method") ?>
<?php if (!$Page->method->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_method", selectId: "fpayment_plansearch_x_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.method?.lookupOptions.length) {
        options.data = { id: "x_method", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_method", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm_method->Visible) { // sqm_method ?>
    <div id="r_sqm_method" class="row"<?= $Page->sqm_method->rowAttributes() ?>>
        <label for="x_sqm_method" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_sqm_method"><?= $Page->sqm_method->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm_method" id="z_sqm_method" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm_method->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_sqm_method" class="ew-search-field ew-search-field-single">
    <select
        id="x_sqm_method"
        name="x_sqm_method"
        class="form-select ew-select<?= $Page->sqm_method->isInvalidClass() ?>"
        <?php if (!$Page->sqm_method->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_sqm_method"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_sqm_method"
        data-value-separator="<?= $Page->sqm_method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sqm_method->getPlaceHolder()) ?>"
        <?= $Page->sqm_method->editAttributes() ?>>
        <?= $Page->sqm_method->selectOptionListHtml("x_sqm_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->sqm_method->getErrorMessage(false) ?></div>
<?php if (!$Page->sqm_method->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_sqm_method", selectId: "fpayment_plansearch_x_sqm_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.sqm_method?.lookupOptions.length) {
        options.data = { id: "x_sqm_method", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_sqm_method", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.sqm_method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit" class="row"<?= $Page->unit->rowAttributes() ?>>
        <label for="x_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_unit"><?= $Page->unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unit" id="z_unit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_unit" class="ew-search-field ew-search-field-single">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_unit"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage(false) ?></div>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_unit", selectId: "fpayment_plansearch_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_unit", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_unit->Visible) { // @_unit ?>
    <div id="r__unit" class="row"<?= $Page->_unit->rowAttributes() ?>>
        <label for="x__unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan__unit"><?= $Page->_unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__unit" id="z__unit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan__unit" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_unit->getInputTextType() ?>" name="x__unit" id="x__unit" data-table="payment_plan" data-field="x__unit" value="<?= $Page->_unit->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_unit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_unit->formatPattern()) ?>"<?= $Page->_unit->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_unit->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
    <div id="r__40" class="row"<?= $Page->_40->rowAttributes() ?>>
        <label for="x__40" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan__40"><?= $Page->_40->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__40" id="z__40" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_40->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan__40" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="payment_plan" data-field="x__40" value="<?= $Page->_40->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->extra_plan->Visible) { // extra_plan ?>
    <div id="r_extra_plan" class="row"<?= $Page->extra_plan->rowAttributes() ?>>
        <label for="x_extra_plan" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_extra_plan"><?= $Page->extra_plan->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_extra_plan" id="z_extra_plan" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->extra_plan->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_extra_plan" class="ew-search-field ew-search-field-single">
    <select
        id="x_extra_plan"
        name="x_extra_plan"
        class="form-select ew-select<?= $Page->extra_plan->isInvalidClass() ?>"
        <?php if (!$Page->extra_plan->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_extra_plan"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_extra_plan"
        data-value-separator="<?= $Page->extra_plan->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->extra_plan->getPlaceHolder()) ?>"
        <?= $Page->extra_plan->editAttributes() ?>>
        <?= $Page->extra_plan->selectOptionListHtml("x_extra_plan") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->extra_plan->getErrorMessage(false) ?></div>
<?php if (!$Page->extra_plan->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_extra_plan", selectId: "fpayment_plansearch_x_extra_plan" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.extra_plan?.lookupOptions.length) {
        options.data = { id: "x_extra_plan", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_extra_plan", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.extra_plan.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->custom_size->Visible) { // custom_size ?>
    <div id="r_custom_size" class="row"<?= $Page->custom_size->rowAttributes() ?>>
        <label for="x_custom_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_custom_size"><?= $Page->custom_size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_custom_size" id="z_custom_size" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->custom_size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_custom_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->custom_size->getInputTextType() ?>" name="x_custom_size" id="x_custom_size" data-table="payment_plan" data-field="x_custom_size" value="<?= $Page->custom_size->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->custom_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->custom_size->formatPattern()) ?>"<?= $Page->custom_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->custom_size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->custom_size_below_st->Visible) { // custom_size_below_st ?>
    <div id="r_custom_size_below_st" class="row"<?= $Page->custom_size_below_st->rowAttributes() ?>>
        <label for="x_custom_size_below_st" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_custom_size_below_st"><?= $Page->custom_size_below_st->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_custom_size_below_st" id="z_custom_size_below_st" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->custom_size_below_st->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_custom_size_below_st" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->custom_size_below_st->getInputTextType() ?>" name="x_custom_size_below_st" id="x_custom_size_below_st" data-table="payment_plan" data-field="x_custom_size_below_st" value="<?= $Page->custom_size_below_st->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->custom_size_below_st->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->custom_size_below_st->formatPattern()) ?>"<?= $Page->custom_size_below_st->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->custom_size_below_st->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_status"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_status", selectId: "fpayment_plansearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_status", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads" class="row"<?= $Page->uploads->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_uploads"><?= $Page->uploads->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_uploads" id="z_uploads" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->uploads->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_uploads" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->uploads->getInputTextType() ?>" name="x_uploads" id="x_uploads" data-table="payment_plan" data-field="x_uploads" value="<?= $Page->uploads->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->uploads->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uploads->formatPattern()) ?>"<?= $Page->uploads->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uploads->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fpayment_plansearch_x_operator"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plansearch", function() {
    var options = { name: "x_operator", selectId: "fpayment_plansearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plansearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fpayment_plansearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fpayment_plansearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="payment_plan" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayment_plansearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayment_plansearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpayment_plansearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpayment_plansearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpayment_plansearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payment_plan");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
