<?php

namespace PHPMaker2024\fibre;

// Page object
$PaymentPlanPendingSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payment_plan_pending: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpayment_plan_pendingsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpayment_plan_pendingsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["location", [], fields.location.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["design_id", [], fields.design_id.isInvalid],
            ["product_type", [], fields.product_type.isInvalid],
            ["shape", [], fields.shape.isInvalid],
            ["cs", [], fields.cs.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "shape": <?= $Page->shape->toClientList($Page) ?>,
            "cs": <?= $Page->cs->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpayment_plan_pendingsearch" id="fpayment_plan_pendingsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payment_plan_pending">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_pending_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_pending_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_pendingsearch_x_location"
        <?php } ?>
        data-table="payment_plan_pending"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_pendingsearch", function() {
    var options = { name: "x_location", selectId: "fpayment_plan_pendingsearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_pendingsearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fpayment_plan_pendingsearch" };
    } else {
        options.ajax = { id: "x_location", form: "fpayment_plan_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_pending.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id" class="row"<?= $Page->design_id->rowAttributes() ?>>
        <label for="x_design_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_pending_design_id"><?= $Page->design_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_design_id" id="z_design_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_pending_design_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_design_id"
        name="x_design_id"
        class="form-select ew-select<?= $Page->design_id->isInvalidClass() ?>"
        <?php if (!$Page->design_id->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_pendingsearch_x_design_id"
        <?php } ?>
        data-table="payment_plan_pending"
        data-field="x_design_id"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage(false) ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
<?php if (!$Page->design_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_pendingsearch", function() {
    var options = { name: "x_design_id", selectId: "fpayment_plan_pendingsearch_x_design_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_pendingsearch.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x_design_id", form: "fpayment_plan_pendingsearch" };
    } else {
        options.ajax = { id: "x_design_id", form: "fpayment_plan_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_pending.fields.design_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type" class="row"<?= $Page->product_type->rowAttributes() ?>>
        <label for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_pending_product_type"><?= $Page->product_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_type" id="z_product_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_pending_product_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_pendingsearch_x_product_type"
        <?php } ?>
        data-table="payment_plan_pending"
        data-field="x_product_type"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_pendingsearch", function() {
    var options = { name: "x_product_type", selectId: "fpayment_plan_pendingsearch_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_pendingsearch.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "fpayment_plan_pendingsearch" };
    } else {
        options.ajax = { id: "x_product_type", form: "fpayment_plan_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_pending.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
    <div id="r_shape" class="row"<?= $Page->shape->rowAttributes() ?>>
        <label for="x_shape" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_pending_shape"><?= $Page->shape->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_shape" id="z_shape" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shape->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_pending_shape" class="ew-search-field ew-search-field-single">
    <select
        id="x_shape"
        name="x_shape"
        class="form-select ew-select<?= $Page->shape->isInvalidClass() ?>"
        <?php if (!$Page->shape->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_pendingsearch_x_shape"
        <?php } ?>
        data-table="payment_plan_pending"
        data-field="x_shape"
        data-value-separator="<?= $Page->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shape->getPlaceHolder()) ?>"
        <?= $Page->shape->editAttributes() ?>>
        <?= $Page->shape->selectOptionListHtml("x_shape") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->shape->getErrorMessage(false) ?></div>
<?= $Page->shape->Lookup->getParamTag($Page, "p_x_shape") ?>
<?php if (!$Page->shape->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_pendingsearch", function() {
    var options = { name: "x_shape", selectId: "fpayment_plan_pendingsearch_x_shape" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_pendingsearch.lists.shape?.lookupOptions.length) {
        options.data = { id: "x_shape", form: "fpayment_plan_pendingsearch" };
    } else {
        options.ajax = { id: "x_shape", form: "fpayment_plan_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_pending.fields.shape.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cs->Visible) { // cs ?>
    <div id="r_cs" class="row"<?= $Page->cs->rowAttributes() ?>>
        <label for="x_cs" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_pending_cs"><?= $Page->cs->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cs" id="z_cs" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cs->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_pending_cs" class="ew-search-field ew-search-field-single">
    <select
        id="x_cs"
        name="x_cs"
        class="form-select ew-select<?= $Page->cs->isInvalidClass() ?>"
        <?php if (!$Page->cs->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_pendingsearch_x_cs"
        <?php } ?>
        data-table="payment_plan_pending"
        data-field="x_cs"
        data-value-separator="<?= $Page->cs->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->cs->getPlaceHolder()) ?>"
        <?= $Page->cs->editAttributes() ?>>
        <?= $Page->cs->selectOptionListHtml("x_cs") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->cs->getErrorMessage(false) ?></div>
<?php if (!$Page->cs->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_pendingsearch", function() {
    var options = { name: "x_cs", selectId: "fpayment_plan_pendingsearch_x_cs" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_pendingsearch.lists.cs?.lookupOptions.length) {
        options.data = { id: "x_cs", form: "fpayment_plan_pendingsearch" };
    } else {
        options.ajax = { id: "x_cs", form: "fpayment_plan_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_pending.fields.cs.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpayment_plan_pendingsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpayment_plan_pendingsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpayment_plan_pendingsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payment_plan_pending");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
