<?php

namespace PHPMaker2024\fibre;

// Page object
$PaymentPlanMaterialList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payment_plan_material: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fpayment_plan_materialsrch" id="fpayment_plan_materialsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fpayment_plan_materialsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payment_plan_material: currentTable } });
var currentForm;
var fpayment_plan_materialsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpayment_plan_materialsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["location", [], fields.location.isInvalid],
            ["type", [], fields.type.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["method", [], fields.method.isInvalid],
            ["input_type", [], fields.input_type.isInvalid],
            ["output_type", [], fields.output_type.isInvalid],
            ["_40", [ew.Validators.float], fields._40.isInvalid],
            ["y__40", [ew.Validators.between], false],
            ["status", [], fields.status.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "type": <?= $Page->type->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "method": <?= $Page->method->toClientList($Page) ?>,
            "input_type": <?= $Page->input_type->toClientList($Page) ?>,
            "output_type": <?= $Page->output_type->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->location->Visible) { // location ?>
<?php
if (!$Page->location->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_location" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->location->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->location->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</div>
        </div>
        <div id="el_payment_plan_material_location" class="ew-search-field">
<template id="tp_x_location">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="payment_plan_material" data-field="x_location" name="x_location" id="x_location"<?= $Page->location->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_location" class="ew-item-list"></div>
<selection-list hidden
    id="x_location[]"
    name="x_location[]"
    value="<?= HtmlEncode($Page->location->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_location"
    data-target="dsl_x_location"
    data-repeatcolumn="5"
    class="form-control<?= $Page->location->isInvalidClass() ?>"
    data-table="payment_plan_material"
    data-field="x_location"
    data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
    <?= $Page->location->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
<?php
if (!$Page->type->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_type" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->type->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_type" class="ew-search-caption ew-label"><?= $Page->type->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_type" id="z_type" value="=">
</div>
        </div>
        <div id="el_payment_plan_material_type" class="ew-search-field">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialsrch_x_type"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialsrch", function() {
    var options = { name: "x_type", selectId: "fpayment_plan_materialsrch_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialsrch.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "fpayment_plan_materialsrch" };
    } else {
        options.ajax = { id: "x_type", form: "fpayment_plan_materialsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
<?php
if (!$Page->process->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_process" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->process->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_process" class="ew-search-caption ew-label"><?= $Page->process->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</div>
        </div>
        <div id="el_payment_plan_material_process" class="ew-search-field">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialsrch_x_process"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialsrch", function() {
    var options = { name: "x_process", selectId: "fpayment_plan_materialsrch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialsrch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fpayment_plan_materialsrch" };
    } else {
        options.ajax = { id: "x_process", form: "fpayment_plan_materialsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
<?php
if (!$Page->method->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_method" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->method->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_method" class="ew-search-caption ew-label"><?= $Page->method->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_method" id="z_method" value="LIKE">
</div>
        </div>
        <div id="el_payment_plan_material_method" class="ew-search-field">
    <select
        id="x_method"
        name="x_method"
        class="form-select ew-select<?= $Page->method->isInvalidClass() ?>"
        <?php if (!$Page->method->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialsrch_x_method"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_method"
        data-value-separator="<?= $Page->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>"
        <?= $Page->method->editAttributes() ?>>
        <?= $Page->method->selectOptionListHtml("x_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->method->getErrorMessage(false) ?></div>
<?php if (!$Page->method->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialsrch", function() {
    var options = { name: "x_method", selectId: "fpayment_plan_materialsrch_x_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialsrch.lists.method?.lookupOptions.length) {
        options.data = { id: "x_method", form: "fpayment_plan_materialsrch" };
    } else {
        options.ajax = { id: "x_method", form: "fpayment_plan_materialsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->input_type->Visible) { // input_type ?>
<?php
if (!$Page->input_type->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_input_type" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->input_type->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_input_type" class="ew-search-caption ew-label"><?= $Page->input_type->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_input_type" id="z_input_type" value="=">
</div>
        </div>
        <div id="el_payment_plan_material_input_type" class="ew-search-field">
    <select
        id="x_input_type"
        name="x_input_type"
        class="form-select ew-select<?= $Page->input_type->isInvalidClass() ?>"
        <?php if (!$Page->input_type->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialsrch_x_input_type"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_input_type"
        data-value-separator="<?= $Page->input_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->input_type->getPlaceHolder()) ?>"
        <?= $Page->input_type->editAttributes() ?>>
        <?= $Page->input_type->selectOptionListHtml("x_input_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->input_type->getErrorMessage(false) ?></div>
<?= $Page->input_type->Lookup->getParamTag($Page, "p_x_input_type") ?>
<?php if (!$Page->input_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialsrch", function() {
    var options = { name: "x_input_type", selectId: "fpayment_plan_materialsrch_x_input_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialsrch.lists.input_type?.lookupOptions.length) {
        options.data = { id: "x_input_type", form: "fpayment_plan_materialsrch" };
    } else {
        options.ajax = { id: "x_input_type", form: "fpayment_plan_materialsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.input_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->output_type->Visible) { // output_type ?>
<?php
if (!$Page->output_type->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_output_type" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->output_type->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_output_type" class="ew-search-caption ew-label"><?= $Page->output_type->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_output_type" id="z_output_type" value="=">
</div>
        </div>
        <div id="el_payment_plan_material_output_type" class="ew-search-field">
    <select
        id="x_output_type"
        name="x_output_type"
        class="form-select ew-select<?= $Page->output_type->isInvalidClass() ?>"
        <?php if (!$Page->output_type->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialsrch_x_output_type"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_output_type"
        data-value-separator="<?= $Page->output_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->output_type->getPlaceHolder()) ?>"
        <?= $Page->output_type->editAttributes() ?>>
        <?= $Page->output_type->selectOptionListHtml("x_output_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->output_type->getErrorMessage(false) ?></div>
<?= $Page->output_type->Lookup->getParamTag($Page, "p_x_output_type") ?>
<?php if (!$Page->output_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialsrch", function() {
    var options = { name: "x_output_type", selectId: "fpayment_plan_materialsrch_x_output_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialsrch.lists.output_type?.lookupOptions.length) {
        options.data = { id: "x_output_type", form: "fpayment_plan_materialsrch" };
    } else {
        options.ajax = { id: "x_output_type", form: "fpayment_plan_materialsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.output_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
<?php
if (!$Page->_40->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__40" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_40->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x__40" class="ew-search-caption ew-label"><?= $Page->_40->caption() ?></label>
            <div class="ew-search-operator">
<select name="z__40" id="z__40" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_40->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_40->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_payment_plan_material__40" class="ew-search-field">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="payment_plan_material" data-field="x__40" value="<?= $Page->_40->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_payment_plan_material__40" class="ew-search-field2 d-none">
<input type="<?= $Page->_40->getInputTextType() ?>" name="y__40" id="y__40" data-table="payment_plan_material" data-field="x__40" value="<?= $Page->_40->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
<?php
if (!$Page->status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->status->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_status" class="ew-search-caption ew-label"><?= $Page->status->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</div>
        </div>
        <div id="el_payment_plan_material_status" class="ew-search-field">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialsrch_x_status"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialsrch", function() {
    var options = { name: "x_status", selectId: "fpayment_plan_materialsrch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialsrch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpayment_plan_materialsrch" };
    } else {
        options.ajax = { id: "x_status", form: "fpayment_plan_materialsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fpayment_plan_materialsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fpayment_plan_materialsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fpayment_plan_materialsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fpayment_plan_materialsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fpayment_plan_materialsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fpayment_plan_materialsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fpayment_plan_materialsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payment_plan_material">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_payment_plan_material" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_payment_plan_materiallist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_payment_plan_material_id" class="payment_plan_material_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
        <th data-name="location" class="<?= $Page->location->headerCellClass() ?>"><div id="elh_payment_plan_material_location" class="payment_plan_material_location"><?= $Page->renderFieldHeader($Page->location) ?></div></th>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
        <th data-name="type" class="<?= $Page->type->headerCellClass() ?>"><div id="elh_payment_plan_material_type" class="payment_plan_material_type"><?= $Page->renderFieldHeader($Page->type) ?></div></th>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
        <th data-name="description" class="<?= $Page->description->headerCellClass() ?>"><div id="elh_payment_plan_material_description" class="payment_plan_material_description"><?= $Page->renderFieldHeader($Page->description) ?></div></th>
<?php } ?>
<?php if ($Page->from_date->Visible) { // from_date ?>
        <th data-name="from_date" class="<?= $Page->from_date->headerCellClass() ?>"><div id="elh_payment_plan_material_from_date" class="payment_plan_material_from_date"><?= $Page->renderFieldHeader($Page->from_date) ?></div></th>
<?php } ?>
<?php if ($Page->to_date->Visible) { // to_date ?>
        <th data-name="to_date" class="<?= $Page->to_date->headerCellClass() ?>"><div id="elh_payment_plan_material_to_date" class="payment_plan_material_to_date"><?= $Page->renderFieldHeader($Page->to_date) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_payment_plan_material_grp" class="payment_plan_material_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>"><div id="elh_payment_plan_material_s_grp" class="payment_plan_material_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php if ($Page->varient_ref->Visible) { // varient_ref ?>
        <th data-name="varient_ref" class="<?= $Page->varient_ref->headerCellClass() ?>"><div id="elh_payment_plan_material_varient_ref" class="payment_plan_material_varient_ref"><?= $Page->renderFieldHeader($Page->varient_ref) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_payment_plan_material_product" class="payment_plan_material_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>"><div id="elh_payment_plan_material_rid" class="payment_plan_material_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
        <th data-name="process" class="<?= $Page->process->headerCellClass() ?>"><div id="elh_payment_plan_material_process" class="payment_plan_material_process"><?= $Page->renderFieldHeader($Page->process) ?></div></th>
<?php } ?>
<?php if ($Page->yes_no->Visible) { // yes_no ?>
        <th data-name="yes_no" class="<?= $Page->yes_no->headerCellClass() ?>"><div id="elh_payment_plan_material_yes_no" class="payment_plan_material_yes_no"><?= $Page->renderFieldHeader($Page->yes_no) ?></div></th>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
        <th data-name="method" class="<?= $Page->method->headerCellClass() ?>"><div id="elh_payment_plan_material_method" class="payment_plan_material_method"><?= $Page->renderFieldHeader($Page->method) ?></div></th>
<?php } ?>
<?php if ($Page->process_method->Visible) { // process_method ?>
        <th data-name="process_method" class="<?= $Page->process_method->headerCellClass() ?>"><div id="elh_payment_plan_material_process_method" class="payment_plan_material_process_method"><?= $Page->renderFieldHeader($Page->process_method) ?></div></th>
<?php } ?>
<?php if ($Page->input_type->Visible) { // input_type ?>
        <th data-name="input_type" class="<?= $Page->input_type->headerCellClass() ?>"><div id="elh_payment_plan_material_input_type" class="payment_plan_material_input_type"><?= $Page->renderFieldHeader($Page->input_type) ?></div></th>
<?php } ?>
<?php if ($Page->output_type->Visible) { // output_type ?>
        <th data-name="output_type" class="<?= $Page->output_type->headerCellClass() ?>"><div id="elh_payment_plan_material_output_type" class="payment_plan_material_output_type"><?= $Page->renderFieldHeader($Page->output_type) ?></div></th>
<?php } ?>
<?php if ($Page->ply->Visible) { // ply ?>
        <th data-name="ply" class="<?= $Page->ply->headerCellClass() ?>"><div id="elh_payment_plan_material_ply" class="payment_plan_material_ply"><?= $Page->renderFieldHeader($Page->ply) ?></div></th>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
        <th data-name="_40" class="<?= $Page->_40->headerCellClass() ?>"><div id="elh_payment_plan_material__40" class="payment_plan_material__40"><?= $Page->renderFieldHeader($Page->_40) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_payment_plan_material_status" class="payment_plan_material_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
        <th data-name="uploads" class="<?= $Page->uploads->headerCellClass() ?>"><div id="elh_payment_plan_material_uploads" class="payment_plan_material_uploads"><?= $Page->renderFieldHeader($Page->uploads) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_payment_plan_material_operator" class="payment_plan_material_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_payment_plan_material_datetime" class="payment_plan_material_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_id" class="el_payment_plan_material_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location"<?= $Page->location->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_location" class="el_payment_plan_material_location">
<span<?= $Page->location->viewAttributes() ?>>
<?= $Page->location->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->type->Visible) { // type ?>
        <td data-name="type"<?= $Page->type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_type" class="el_payment_plan_material_type">
<span<?= $Page->type->viewAttributes() ?>>
<?php if (!EmptyString($Page->type->getViewValue()) && $Page->type->linkAttributes() != "") { ?>
<a<?= $Page->type->linkAttributes() ?>><?= $Page->type->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->description->Visible) { // description ?>
        <td data-name="description"<?= $Page->description->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_description" class="el_payment_plan_material_description">
<span<?= $Page->description->viewAttributes() ?>>
<?= $Page->description->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->from_date->Visible) { // from_date ?>
        <td data-name="from_date"<?= $Page->from_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_from_date" class="el_payment_plan_material_from_date">
<span<?= $Page->from_date->viewAttributes() ?>>
<?= $Page->from_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->to_date->Visible) { // to_date ?>
        <td data-name="to_date"<?= $Page->to_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_to_date" class="el_payment_plan_material_to_date">
<span<?= $Page->to_date->viewAttributes() ?>>
<?= $Page->to_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_grp" class="el_payment_plan_material_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_s_grp" class="el_payment_plan_material_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?= $Page->s_grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->varient_ref->Visible) { // varient_ref ?>
        <td data-name="varient_ref"<?= $Page->varient_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_varient_ref" class="el_payment_plan_material_varient_ref">
<span<?= $Page->varient_ref->viewAttributes() ?>>
<?= $Page->varient_ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_product" class="el_payment_plan_material_product">
<span<?= $Page->product->viewAttributes() ?>>
<?= $Page->product->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_rid" class="el_payment_plan_material_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?= $Page->rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process"<?= $Page->process->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_process" class="el_payment_plan_material_process">
<span<?= $Page->process->viewAttributes() ?>>
<?php if (!EmptyString($Page->process->getViewValue()) && $Page->process->linkAttributes() != "") { ?>
<a<?= $Page->process->linkAttributes() ?>><?= $Page->process->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->yes_no->Visible) { // yes_no ?>
        <td data-name="yes_no"<?= $Page->yes_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_yes_no" class="el_payment_plan_material_yes_no">
<span<?= $Page->yes_no->viewAttributes() ?>>
<?= $Page->yes_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->method->Visible) { // method ?>
        <td data-name="method"<?= $Page->method->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_method" class="el_payment_plan_material_method">
<span<?= $Page->method->viewAttributes() ?>>
<?= $Page->method->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_method->Visible) { // process_method ?>
        <td data-name="process_method"<?= $Page->process_method->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_process_method" class="el_payment_plan_material_process_method">
<span<?= $Page->process_method->viewAttributes() ?>>
<?= $Page->process_method->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->input_type->Visible) { // input_type ?>
        <td data-name="input_type"<?= $Page->input_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_input_type" class="el_payment_plan_material_input_type">
<span<?= $Page->input_type->viewAttributes() ?>>
<?= $Page->input_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->output_type->Visible) { // output_type ?>
        <td data-name="output_type"<?= $Page->output_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_output_type" class="el_payment_plan_material_output_type">
<span<?= $Page->output_type->viewAttributes() ?>>
<?= $Page->output_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ply->Visible) { // ply ?>
        <td data-name="ply"<?= $Page->ply->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_ply" class="el_payment_plan_material_ply">
<span<?= $Page->ply->viewAttributes() ?>>
<?= $Page->ply->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_40->Visible) { // @ ?>
        <td data-name="_40"<?= $Page->_40->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material__40" class="el_payment_plan_material__40">
<span<?= $Page->_40->viewAttributes() ?>>
<?= $Page->_40->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_status" class="el_payment_plan_material_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->uploads->Visible) { // uploads ?>
        <td data-name="uploads"<?= $Page->uploads->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_uploads" class="el_payment_plan_material_uploads">
<span>
<?= GetFileViewTag($Page->uploads, $Page->uploads->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_operator" class="el_payment_plan_material_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_payment_plan_material_datetime" class="el_payment_plan_material_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payment_plan_material");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
