<?php

namespace PHPMaker2024\fibre;

// Page object
$PaymentPlanMaterialEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fpayment_plan_materialedit" id="fpayment_plan_materialedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payment_plan_material: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fpayment_plan_materialedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpayment_plan_materialedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["description", [fields.description.visible && fields.description.required ? ew.Validators.required(fields.description.caption) : null], fields.description.isInvalid],
            ["from_date", [fields.from_date.visible && fields.from_date.required ? ew.Validators.required(fields.from_date.caption) : null, ew.Validators.datetime(fields.from_date.clientFormatPattern)], fields.from_date.isInvalid],
            ["to_date", [fields.to_date.visible && fields.to_date.required ? ew.Validators.required(fields.to_date.caption) : null, ew.Validators.datetime(fields.to_date.clientFormatPattern)], fields.to_date.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["varient", [fields.varient.visible && fields.varient.required ? ew.Validators.required(fields.varient.caption) : null], fields.varient.isInvalid],
            ["varient_ref", [fields.varient_ref.visible && fields.varient_ref.required ? ew.Validators.required(fields.varient_ref.caption) : null], fields.varient_ref.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["process", [fields.process.visible && fields.process.required ? ew.Validators.required(fields.process.caption) : null], fields.process.isInvalid],
            ["yes_no", [fields.yes_no.visible && fields.yes_no.required ? ew.Validators.required(fields.yes_no.caption) : null], fields.yes_no.isInvalid],
            ["method", [fields.method.visible && fields.method.required ? ew.Validators.required(fields.method.caption) : null], fields.method.isInvalid],
            ["process_method", [fields.process_method.visible && fields.process_method.required ? ew.Validators.required(fields.process_method.caption) : null], fields.process_method.isInvalid],
            ["input_type", [fields.input_type.visible && fields.input_type.required ? ew.Validators.required(fields.input_type.caption) : null], fields.input_type.isInvalid],
            ["output_type", [fields.output_type.visible && fields.output_type.required ? ew.Validators.required(fields.output_type.caption) : null], fields.output_type.isInvalid],
            ["ply", [fields.ply.visible && fields.ply.required ? ew.Validators.required(fields.ply.caption) : null, ew.Validators.integer], fields.ply.isInvalid],
            ["_40", [fields._40.visible && fields._40.required ? ew.Validators.required(fields._40.caption) : null, ew.Validators.float], fields._40.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "varient": <?= $Page->varient->toClientList($Page) ?>,
            "varient_ref": <?= $Page->varient_ref->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "yes_no": <?= $Page->yes_no->toClientList($Page) ?>,
            "method": <?= $Page->method->toClientList($Page) ?>,
            "process_method": <?= $Page->process_method->toClientList($Page) ?>,
            "input_type": <?= $Page->input_type->toClientList($Page) ?>,
            "output_type": <?= $Page->output_type->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payment_plan_material">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_payment_plan_material_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_payment_plan_material_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="payment_plan_material" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_payment_plan_material_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_payment_plan_material_location">
<template id="tp_x_location">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="payment_plan_material" data-field="x_location" name="x_location" id="x_location"<?= $Page->location->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_location" class="ew-item-list"></div>
<selection-list hidden
    id="x_location[]"
    name="x_location[]"
    value="<?= HtmlEncode($Page->location->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_location"
    data-target="dsl_x_location"
    data-repeatcolumn="5"
    class="form-control<?= $Page->location->isInvalidClass() ?>"
    data-table="payment_plan_material"
    data-field="x_location"
    data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
    <?= $Page->location->editAttributes() ?>></selection-list>
<?= $Page->location->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type"<?= $Page->type->rowAttributes() ?>>
        <label id="elh_payment_plan_material_type" for="x_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->type->caption() ?><?= $Page->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->type->cellAttributes() ?>>
<span id="el_payment_plan_material_type">
<span<?= $Page->type->viewAttributes() ?>>
<?php if (!EmptyString($Page->type->EditValue) && $Page->type->linkAttributes() != "") { ?>
<a<?= $Page->type->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->type->getDisplayValue($Page->type->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->type->getDisplayValue($Page->type->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="payment_plan_material" data-field="x_type" data-hidden="1" name="x_type" id="x_type" value="<?= HtmlEncode($Page->type->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description"<?= $Page->description->rowAttributes() ?>>
        <label id="elh_payment_plan_material_description" for="x_description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description->caption() ?><?= $Page->description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description->cellAttributes() ?>>
<span id="el_payment_plan_material_description">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="payment_plan_material" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?> aria-describedby="x_description_help">
<?= $Page->description->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->from_date->Visible) { // from_date ?>
    <div id="r_from_date"<?= $Page->from_date->rowAttributes() ?>>
        <label id="elh_payment_plan_material_from_date" for="x_from_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->from_date->caption() ?><?= $Page->from_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->from_date->cellAttributes() ?>>
<span id="el_payment_plan_material_from_date">
<input type="<?= $Page->from_date->getInputTextType() ?>" name="x_from_date" id="x_from_date" data-table="payment_plan_material" data-field="x_from_date" value="<?= $Page->from_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->from_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->from_date->formatPattern()) ?>"<?= $Page->from_date->editAttributes() ?> aria-describedby="x_from_date_help">
<?= $Page->from_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->from_date->getErrorMessage() ?></div>
<?php if (!$Page->from_date->ReadOnly && !$Page->from_date->Disabled && !isset($Page->from_date->EditAttrs["readonly"]) && !isset($Page->from_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayment_plan_materialedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayment_plan_materialedit", "x_from_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->to_date->Visible) { // to_date ?>
    <div id="r_to_date"<?= $Page->to_date->rowAttributes() ?>>
        <label id="elh_payment_plan_material_to_date" for="x_to_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->to_date->caption() ?><?= $Page->to_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->to_date->cellAttributes() ?>>
<span id="el_payment_plan_material_to_date">
<input type="<?= $Page->to_date->getInputTextType() ?>" name="x_to_date" id="x_to_date" data-table="payment_plan_material" data-field="x_to_date" value="<?= $Page->to_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->to_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->to_date->formatPattern()) ?>"<?= $Page->to_date->editAttributes() ?> aria-describedby="x_to_date_help">
<?= $Page->to_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->to_date->getErrorMessage() ?></div>
<?php if (!$Page->to_date->ReadOnly && !$Page->to_date->Disabled && !isset($Page->to_date->EditAttrs["readonly"]) && !isset($Page->to_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayment_plan_materialedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayment_plan_materialedit", "x_to_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_payment_plan_material_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_payment_plan_material_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->grp->getDisplayValue($Page->grp->EditValue) ?></span></span>
<input type="hidden" data-table="payment_plan_material" data-field="x_grp" data-hidden="1" name="x_grp" id="x_grp" value="<?= HtmlEncode($Page->grp->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_payment_plan_material_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_payment_plan_material_s_grp">
<template id="tp_x_s_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="payment_plan_material" data-field="x_s_grp" name="x_s_grp" id="x_s_grp"<?= $Page->s_grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_s_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_s_grp[]"
    name="x_s_grp[]"
    value="<?= HtmlEncode($Page->s_grp->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_s_grp"
    data-target="dsl_x_s_grp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->s_grp->isInvalidClass() ?>"
    data-table="payment_plan_material"
    data-field="x_s_grp"
    data-ew-action="update-options"
    data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->s_grp->editAttributes() ?>></selection-list>
<?= $Page->s_grp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->varient->Visible) { // varient ?>
    <div id="r_varient"<?= $Page->varient->rowAttributes() ?>>
        <label id="elh_payment_plan_material_varient" for="x_varient" class="<?= $Page->LeftColumnClass ?>"><?= $Page->varient->caption() ?><?= $Page->varient->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->varient->cellAttributes() ?>>
<span id="el_payment_plan_material_varient">
    <select
        id="x_varient"
        name="x_varient"
        class="form-select ew-select<?= $Page->varient->isInvalidClass() ?>"
        <?php if (!$Page->varient->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialedit_x_varient"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_varient"
        data-value-separator="<?= $Page->varient->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->varient->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->varient->editAttributes() ?>>
        <?= $Page->varient->selectOptionListHtml("x_varient") ?>
    </select>
    <?= $Page->varient->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->varient->getErrorMessage() ?></div>
<?= $Page->varient->Lookup->getParamTag($Page, "p_x_varient") ?>
<?php if (!$Page->varient->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialedit", function() {
    var options = { name: "x_varient", selectId: "fpayment_plan_materialedit_x_varient" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialedit.lists.varient?.lookupOptions.length) {
        options.data = { id: "x_varient", form: "fpayment_plan_materialedit" };
    } else {
        options.ajax = { id: "x_varient", form: "fpayment_plan_materialedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.varient.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->varient_ref->Visible) { // varient_ref ?>
    <div id="r_varient_ref"<?= $Page->varient_ref->rowAttributes() ?>>
        <label id="elh_payment_plan_material_varient_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->varient_ref->caption() ?><?= $Page->varient_ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->varient_ref->cellAttributes() ?>>
<span id="el_payment_plan_material_varient_ref">
<template id="tp_x_varient_ref">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="payment_plan_material" data-field="x_varient_ref" name="x_varient_ref" id="x_varient_ref"<?= $Page->varient_ref->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_varient_ref" class="ew-item-list"></div>
<selection-list hidden
    id="x_varient_ref[]"
    name="x_varient_ref[]"
    value="<?= HtmlEncode($Page->varient_ref->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_varient_ref"
    data-target="dsl_x_varient_ref"
    data-repeatcolumn="3"
    class="form-control<?= $Page->varient_ref->isInvalidClass() ?>"
    data-table="payment_plan_material"
    data-field="x_varient_ref"
    data-value-separator="<?= $Page->varient_ref->displayValueSeparatorAttribute() ?>"
    <?= $Page->varient_ref->editAttributes() ?>></selection-list>
<?= $Page->varient_ref->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->varient_ref->getErrorMessage() ?></div>
<?= $Page->varient_ref->Lookup->getParamTag($Page, "p_x_varient_ref") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_payment_plan_material_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_payment_plan_material_product">
    <select
        id="x_product[]"
        name="x_product[]"
        class="form-control ew-select<?= $Page->product->isInvalidClass() ?>"
        data-select2-id="fpayment_plan_materialedit_x_product[]"
        data-table="payment_plan_material"
        data-field="x_product"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->product->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product[]") ?>
    </select>
    <?= $Page->product->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<script>
loadjs.ready("fpayment_plan_materialedit", function() {
    var options = { name: "x_product[]", selectId: "fpayment_plan_materialedit_x_product[]" };
    options.multiple = true;
    if (fpayment_plan_materialedit.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product[]", form: "fpayment_plan_materialedit" };
    } else {
        options.ajax = { id: "x_product[]", form: "fpayment_plan_materialedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.payment_plan_material.fields.product.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label id="elh_payment_plan_material_rid" for="x_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid->cellAttributes() ?>>
<span id="el_payment_plan_material_rid">
    <select
        id="x_rid[]"
        name="x_rid[]"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fpayment_plan_materialedit_x_rid[]"
        data-table="payment_plan_material"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid[]") ?>
    </select>
    <?= $Page->rid->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage() ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<script>
loadjs.ready("fpayment_plan_materialedit", function() {
    var options = { name: "x_rid[]", selectId: "fpayment_plan_materialedit_x_rid[]" };
    options.multiple = true;
    if (fpayment_plan_materialedit.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid[]", form: "fpayment_plan_materialedit" };
    } else {
        options.ajax = { id: "x_rid[]", form: "fpayment_plan_materialedit", limit: 20 };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.payment_plan_material.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process"<?= $Page->process->rowAttributes() ?>>
        <label id="elh_payment_plan_material_process" for="x_process" class="<?= $Page->LeftColumnClass ?>"><?= $Page->process->caption() ?><?= $Page->process->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->process->cellAttributes() ?>>
<span id="el_payment_plan_material_process">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialedit_x_process"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <?= $Page->process->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage() ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialedit", function() {
    var options = { name: "x_process", selectId: "fpayment_plan_materialedit_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialedit.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fpayment_plan_materialedit" };
    } else {
        options.ajax = { id: "x_process", form: "fpayment_plan_materialedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->yes_no->Visible) { // yes_no ?>
    <div id="r_yes_no"<?= $Page->yes_no->rowAttributes() ?>>
        <label id="elh_payment_plan_material_yes_no" for="x_yes_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->yes_no->caption() ?><?= $Page->yes_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->yes_no->cellAttributes() ?>>
<span id="el_payment_plan_material_yes_no">
    <select
        id="x_yes_no"
        name="x_yes_no"
        class="form-select ew-select<?= $Page->yes_no->isInvalidClass() ?>"
        <?php if (!$Page->yes_no->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialedit_x_yes_no"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_yes_no"
        data-value-separator="<?= $Page->yes_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->yes_no->getPlaceHolder()) ?>"
        <?= $Page->yes_no->editAttributes() ?>>
        <?= $Page->yes_no->selectOptionListHtml("x_yes_no") ?>
    </select>
    <?= $Page->yes_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->yes_no->getErrorMessage() ?></div>
<?php if (!$Page->yes_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialedit", function() {
    var options = { name: "x_yes_no", selectId: "fpayment_plan_materialedit_x_yes_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialedit.lists.yes_no?.lookupOptions.length) {
        options.data = { id: "x_yes_no", form: "fpayment_plan_materialedit" };
    } else {
        options.ajax = { id: "x_yes_no", form: "fpayment_plan_materialedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.yes_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method"<?= $Page->method->rowAttributes() ?>>
        <label id="elh_payment_plan_material_method" for="x_method" class="<?= $Page->LeftColumnClass ?>"><?= $Page->method->caption() ?><?= $Page->method->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->method->cellAttributes() ?>>
<span id="el_payment_plan_material_method">
    <select
        id="x_method"
        name="x_method"
        class="form-select ew-select<?= $Page->method->isInvalidClass() ?>"
        <?php if (!$Page->method->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialedit_x_method"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_method"
        data-value-separator="<?= $Page->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>"
        <?= $Page->method->editAttributes() ?>>
        <?= $Page->method->selectOptionListHtml("x_method") ?>
    </select>
    <?= $Page->method->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->method->getErrorMessage() ?></div>
<?php if (!$Page->method->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialedit", function() {
    var options = { name: "x_method", selectId: "fpayment_plan_materialedit_x_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialedit.lists.method?.lookupOptions.length) {
        options.data = { id: "x_method", form: "fpayment_plan_materialedit" };
    } else {
        options.ajax = { id: "x_method", form: "fpayment_plan_materialedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->process_method->Visible) { // process_method ?>
    <div id="r_process_method"<?= $Page->process_method->rowAttributes() ?>>
        <label id="elh_payment_plan_material_process_method" for="x_process_method" class="<?= $Page->LeftColumnClass ?>"><?= $Page->process_method->caption() ?><?= $Page->process_method->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->process_method->cellAttributes() ?>>
<span id="el_payment_plan_material_process_method">
    <select
        id="x_process_method"
        name="x_process_method"
        class="form-select ew-select<?= $Page->process_method->isInvalidClass() ?>"
        <?php if (!$Page->process_method->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialedit_x_process_method"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_process_method"
        data-value-separator="<?= $Page->process_method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_method->getPlaceHolder()) ?>"
        <?= $Page->process_method->editAttributes() ?>>
        <?= $Page->process_method->selectOptionListHtml("x_process_method") ?>
    </select>
    <?= $Page->process_method->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->process_method->getErrorMessage() ?></div>
<?php if (!$Page->process_method->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialedit", function() {
    var options = { name: "x_process_method", selectId: "fpayment_plan_materialedit_x_process_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialedit.lists.process_method?.lookupOptions.length) {
        options.data = { id: "x_process_method", form: "fpayment_plan_materialedit" };
    } else {
        options.ajax = { id: "x_process_method", form: "fpayment_plan_materialedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.process_method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->input_type->Visible) { // input_type ?>
    <div id="r_input_type"<?= $Page->input_type->rowAttributes() ?>>
        <label id="elh_payment_plan_material_input_type" for="x_input_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->input_type->caption() ?><?= $Page->input_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->input_type->cellAttributes() ?>>
<span id="el_payment_plan_material_input_type">
    <select
        id="x_input_type"
        name="x_input_type"
        class="form-select ew-select<?= $Page->input_type->isInvalidClass() ?>"
        <?php if (!$Page->input_type->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialedit_x_input_type"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_input_type"
        data-value-separator="<?= $Page->input_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->input_type->getPlaceHolder()) ?>"
        <?= $Page->input_type->editAttributes() ?>>
        <?= $Page->input_type->selectOptionListHtml("x_input_type") ?>
    </select>
    <?= $Page->input_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->input_type->getErrorMessage() ?></div>
<?= $Page->input_type->Lookup->getParamTag($Page, "p_x_input_type") ?>
<?php if (!$Page->input_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialedit", function() {
    var options = { name: "x_input_type", selectId: "fpayment_plan_materialedit_x_input_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialedit.lists.input_type?.lookupOptions.length) {
        options.data = { id: "x_input_type", form: "fpayment_plan_materialedit" };
    } else {
        options.ajax = { id: "x_input_type", form: "fpayment_plan_materialedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.input_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->output_type->Visible) { // output_type ?>
    <div id="r_output_type"<?= $Page->output_type->rowAttributes() ?>>
        <label id="elh_payment_plan_material_output_type" for="x_output_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->output_type->caption() ?><?= $Page->output_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->output_type->cellAttributes() ?>>
<span id="el_payment_plan_material_output_type">
    <select
        id="x_output_type"
        name="x_output_type"
        class="form-select ew-select<?= $Page->output_type->isInvalidClass() ?>"
        <?php if (!$Page->output_type->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialedit_x_output_type"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_output_type"
        data-value-separator="<?= $Page->output_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->output_type->getPlaceHolder()) ?>"
        <?= $Page->output_type->editAttributes() ?>>
        <?= $Page->output_type->selectOptionListHtml("x_output_type") ?>
    </select>
    <?= $Page->output_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->output_type->getErrorMessage() ?></div>
<?= $Page->output_type->Lookup->getParamTag($Page, "p_x_output_type") ?>
<?php if (!$Page->output_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialedit", function() {
    var options = { name: "x_output_type", selectId: "fpayment_plan_materialedit_x_output_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialedit.lists.output_type?.lookupOptions.length) {
        options.data = { id: "x_output_type", form: "fpayment_plan_materialedit" };
    } else {
        options.ajax = { id: "x_output_type", form: "fpayment_plan_materialedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.output_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ply->Visible) { // ply ?>
    <div id="r_ply"<?= $Page->ply->rowAttributes() ?>>
        <label id="elh_payment_plan_material_ply" for="x_ply" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ply->caption() ?><?= $Page->ply->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ply->cellAttributes() ?>>
<span id="el_payment_plan_material_ply">
<input type="<?= $Page->ply->getInputTextType() ?>" name="x_ply" id="x_ply" data-table="payment_plan_material" data-field="x_ply" value="<?= $Page->ply->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ply->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ply->formatPattern()) ?>"<?= $Page->ply->editAttributes() ?> aria-describedby="x_ply_help">
<?= $Page->ply->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ply->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
    <div id="r__40"<?= $Page->_40->rowAttributes() ?>>
        <label id="elh_payment_plan_material__40" for="x__40" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_40->caption() ?><?= $Page->_40->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_40->cellAttributes() ?>>
<span id="el_payment_plan_material__40">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="payment_plan_material" data-field="x__40" value="<?= $Page->_40->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?> aria-describedby="x__40_help">
<?= $Page->_40->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_payment_plan_material_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_payment_plan_material_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_materialedit_x_status"
        <?php } ?>
        data-table="payment_plan_material"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_materialedit", function() {
    var options = { name: "x_status", selectId: "fpayment_plan_materialedit_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_materialedit.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpayment_plan_materialedit" };
    } else {
        options.ajax = { id: "x_status", form: "fpayment_plan_materialedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_material.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_payment_plan_material_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_payment_plan_material_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="payment_plan_material"
        data-field="x_uploads"
        data-size="500"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->uploads->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="<?= (Post("fa_x_uploads") == "0") ? "0" : "1" ?>">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpayment_plan_materialedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpayment_plan_materialedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payment_plan_material");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    		$("#r_ply").hide();
    		var type = $("#x_type").val();
    		if (type == 2)
    		{
    		$("#r_product").hide();
    		$("#r_rid").hide();	
    		$("#r_varient").show();
    		$("#r_varient_ref").show();
    		} else if (type == 3) {
    		$("#r_product").show();
    		$("#r_rid").show();
    		$("#r_varient").hide();
    		$("#r_varient_ref").hide();
    		} else {
    		$("#r_product").hide();
    		$("#r_rid").hide();
    		$("#r_varient").hide();
    		$("#r_varient_ref").hide();
    		}
});
</script>
