<?php

namespace PHPMaker2024\fibre;

// Page object
$PaymentPlanEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fpayment_planedit" id="fpayment_planedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payment_plan: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fpayment_planedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpayment_planedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["plan_type", [fields.plan_type.visible && fields.plan_type.required ? ew.Validators.required(fields.plan_type.caption) : null], fields.plan_type.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["from_date", [fields.from_date.visible && fields.from_date.required ? ew.Validators.required(fields.from_date.caption) : null, ew.Validators.datetime(fields.from_date.clientFormatPattern)], fields.from_date.isInvalid],
            ["to_date", [fields.to_date.visible && fields.to_date.required ? ew.Validators.required(fields.to_date.caption) : null, ew.Validators.datetime(fields.to_date.clientFormatPattern)], fields.to_date.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["process", [fields.process.visible && fields.process.required ? ew.Validators.required(fields.process.caption) : null], fields.process.isInvalid],
            ["product_type", [fields.product_type.visible && fields.product_type.required ? ew.Validators.required(fields.product_type.caption) : null], fields.product_type.isInvalid],
            ["shape", [fields.shape.visible && fields.shape.required ? ew.Validators.required(fields.shape.caption) : null], fields.shape.isInvalid],
            ["selection", [fields.selection.visible && fields.selection.required ? ew.Validators.required(fields.selection.caption) : null], fields.selection.isInvalid],
            ["gcode", [fields.gcode.visible && fields.gcode.required ? ew.Validators.required(fields.gcode.caption) : null], fields.gcode.isInvalid],
            ["ref", [fields.ref.visible && fields.ref.required ? ew.Validators.required(fields.ref.caption) : null], fields.ref.isInvalid],
            ["description", [fields.description.visible && fields.description.required ? ew.Validators.required(fields.description.caption) : null], fields.description.isInvalid],
            ["yes_no", [fields.yes_no.visible && fields.yes_no.required ? ew.Validators.required(fields.yes_no.caption) : null], fields.yes_no.isInvalid],
            ["packing_payment_type", [fields.packing_payment_type.visible && fields.packing_payment_type.required ? ew.Validators.required(fields.packing_payment_type.caption) : null], fields.packing_payment_type.isInvalid],
            ["fix", [fields.fix.visible && fields.fix.required ? ew.Validators.required(fields.fix.caption) : null], fields.fix.isInvalid],
            ["method", [fields.method.visible && fields.method.required ? ew.Validators.required(fields.method.caption) : null], fields.method.isInvalid],
            ["sqm_method", [fields.sqm_method.visible && fields.sqm_method.required ? ew.Validators.required(fields.sqm_method.caption) : null], fields.sqm_method.isInvalid],
            ["unit", [fields.unit.visible && fields.unit.required ? ew.Validators.required(fields.unit.caption) : null], fields.unit.isInvalid],
            ["_unit", [fields._unit.visible && fields._unit.required ? ew.Validators.required(fields._unit.caption) : null, ew.Validators.float], fields._unit.isInvalid],
            ["_40", [fields._40.visible && fields._40.required ? ew.Validators.required(fields._40.caption) : null, ew.Validators.float], fields._40.isInvalid],
            ["extra_plan", [fields.extra_plan.visible && fields.extra_plan.required ? ew.Validators.required(fields.extra_plan.caption) : null], fields.extra_plan.isInvalid],
            ["custom_size", [fields.custom_size.visible && fields.custom_size.required ? ew.Validators.required(fields.custom_size.caption) : null, ew.Validators.float], fields.custom_size.isInvalid],
            ["custom_size_below_st", [fields.custom_size_below_st.visible && fields.custom_size_below_st.required ? ew.Validators.required(fields.custom_size_below_st.caption) : null, ew.Validators.float], fields.custom_size_below_st.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "plan_type": <?= $Page->plan_type->toClientList($Page) ?>,
            "location": <?= $Page->location->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "shape": <?= $Page->shape->toClientList($Page) ?>,
            "selection": <?= $Page->selection->toClientList($Page) ?>,
            "gcode": <?= $Page->gcode->toClientList($Page) ?>,
            "ref": <?= $Page->ref->toClientList($Page) ?>,
            "yes_no": <?= $Page->yes_no->toClientList($Page) ?>,
            "packing_payment_type": <?= $Page->packing_payment_type->toClientList($Page) ?>,
            "fix": <?= $Page->fix->toClientList($Page) ?>,
            "method": <?= $Page->method->toClientList($Page) ?>,
            "sqm_method": <?= $Page->sqm_method->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "extra_plan": <?= $Page->extra_plan->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Client script
    // Write your client script here, no need to add script tags.
    			var sel = $("#x_selection").val();
    				if (sel == 0)
    				{
    				$("#r_gcode").hide();
    				$("#r_ref").hide();
    				$('#dsl_x_gcode input[type=checkbox]').prop('checked', false);
    				$('#dsl_x_ref input[type=checkbox]').prop('checked', false);
    				} else {
    				$("#r_gcode").show();
    				$("#r_ref").show();
    				}		
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payment_plan">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_payment_plan_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_payment_plan_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="payment_plan" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->plan_type->Visible) { // plan_type ?>
    <div id="r_plan_type"<?= $Page->plan_type->rowAttributes() ?>>
        <label id="elh_payment_plan_plan_type" for="x_plan_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->plan_type->caption() ?><?= $Page->plan_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->plan_type->cellAttributes() ?>>
<span id="el_payment_plan_plan_type">
    <select
        id="x_plan_type"
        name="x_plan_type"
        class="form-select ew-select<?= $Page->plan_type->isInvalidClass() ?>"
        <?php if (!$Page->plan_type->IsNativeSelect) { ?>
        data-select2-id="fpayment_planedit_x_plan_type"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_plan_type"
        data-value-separator="<?= $Page->plan_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->plan_type->getPlaceHolder()) ?>"
        <?= $Page->plan_type->editAttributes() ?>>
        <?= $Page->plan_type->selectOptionListHtml("x_plan_type") ?>
    </select>
    <?= $Page->plan_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->plan_type->getErrorMessage() ?></div>
<?php if (!$Page->plan_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_plan_type", selectId: "fpayment_planedit_x_plan_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_planedit.lists.plan_type?.lookupOptions.length) {
        options.data = { id: "x_plan_type", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_plan_type", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.plan_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_payment_plan_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_payment_plan_location">
    <select
        id="x_location[]"
        name="x_location[]"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fpayment_planedit_x_location[]"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_location"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location[]") ?>
    </select>
    <?= $Page->location->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_location[]", selectId: "fpayment_planedit_x_location[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 3;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown payment_plan-x_location-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_planedit.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location[]", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_location[]", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->from_date->Visible) { // from_date ?>
    <div id="r_from_date"<?= $Page->from_date->rowAttributes() ?>>
        <label id="elh_payment_plan_from_date" for="x_from_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->from_date->caption() ?><?= $Page->from_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->from_date->cellAttributes() ?>>
<span id="el_payment_plan_from_date">
<input type="<?= $Page->from_date->getInputTextType() ?>" name="x_from_date" id="x_from_date" data-table="payment_plan" data-field="x_from_date" value="<?= $Page->from_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->from_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->from_date->formatPattern()) ?>"<?= $Page->from_date->editAttributes() ?> aria-describedby="x_from_date_help">
<?= $Page->from_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->from_date->getErrorMessage() ?></div>
<?php if (!$Page->from_date->ReadOnly && !$Page->from_date->Disabled && !isset($Page->from_date->EditAttrs["readonly"]) && !isset($Page->from_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayment_planedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayment_planedit", "x_from_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->to_date->Visible) { // to_date ?>
    <div id="r_to_date"<?= $Page->to_date->rowAttributes() ?>>
        <label id="elh_payment_plan_to_date" for="x_to_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->to_date->caption() ?><?= $Page->to_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->to_date->cellAttributes() ?>>
<span id="el_payment_plan_to_date">
<input type="<?= $Page->to_date->getInputTextType() ?>" name="x_to_date" id="x_to_date" data-table="payment_plan" data-field="x_to_date" value="<?= $Page->to_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->to_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->to_date->formatPattern()) ?>"<?= $Page->to_date->editAttributes() ?> aria-describedby="x_to_date_help">
<?= $Page->to_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->to_date->getErrorMessage() ?></div>
<?php if (!$Page->to_date->ReadOnly && !$Page->to_date->Disabled && !isset($Page->to_date->EditAttrs["readonly"]) && !isset($Page->to_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayment_planedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpayment_planedit", "x_to_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_payment_plan_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_payment_plan_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->grp->getDisplayValue($Page->grp->EditValue) ?></span></span>
<input type="hidden" data-table="payment_plan" data-field="x_grp" data-hidden="1" name="x_grp" id="x_grp" value="<?= HtmlEncode($Page->grp->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_payment_plan_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_payment_plan_s_grp">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fpayment_planedit_x_s_grp"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <?= $Page->s_grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_s_grp", selectId: "fpayment_planedit_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_planedit.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process"<?= $Page->process->rowAttributes() ?>>
        <label id="elh_payment_plan_process" for="x_process" class="<?= $Page->LeftColumnClass ?>"><?= $Page->process->caption() ?><?= $Page->process->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->process->cellAttributes() ?>>
<span id="el_payment_plan_process">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fpayment_planedit_x_process"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <?= $Page->process->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage() ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_process", selectId: "fpayment_planedit_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_planedit.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_process", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type"<?= $Page->product_type->rowAttributes() ?>>
        <label id="elh_payment_plan_product_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_type->caption() ?><?= $Page->product_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_type->cellAttributes() ?>>
<span id="el_payment_plan_product_type">
<template id="tp_x_product_type">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="payment_plan" data-field="x_product_type" name="x_product_type" id="x_product_type"<?= $Page->product_type->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_product_type" class="ew-item-list"></div>
<selection-list hidden
    id="x_product_type[]"
    name="x_product_type[]"
    value="<?= HtmlEncode($Page->product_type->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_product_type"
    data-target="dsl_x_product_type"
    data-repeatcolumn="3"
    class="form-control<?= $Page->product_type->isInvalidClass() ?>"
    data-table="payment_plan"
    data-field="x_product_type"
    data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
    <?= $Page->product_type->editAttributes() ?>></selection-list>
<?= $Page->product_type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->product_type->getErrorMessage() ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
    <div id="r_shape"<?= $Page->shape->rowAttributes() ?>>
        <label id="elh_payment_plan_shape" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shape->caption() ?><?= $Page->shape->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shape->cellAttributes() ?>>
<span id="el_payment_plan_shape">
<template id="tp_x_shape">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="payment_plan" data-field="x_shape" name="x_shape" id="x_shape"<?= $Page->shape->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_shape" class="ew-item-list"></div>
<selection-list hidden
    id="x_shape[]"
    name="x_shape[]"
    value="<?= HtmlEncode($Page->shape->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_shape"
    data-target="dsl_x_shape"
    data-repeatcolumn="3"
    class="form-control<?= $Page->shape->isInvalidClass() ?>"
    data-table="payment_plan"
    data-field="x_shape"
    data-value-separator="<?= $Page->shape->displayValueSeparatorAttribute() ?>"
    <?= $Page->shape->editAttributes() ?>></selection-list>
<?= $Page->shape->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->shape->getErrorMessage() ?></div>
<?= $Page->shape->Lookup->getParamTag($Page, "p_x_shape") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->selection->Visible) { // selection ?>
    <div id="r_selection"<?= $Page->selection->rowAttributes() ?>>
        <label id="elh_payment_plan_selection" for="x_selection" class="<?= $Page->LeftColumnClass ?>"><?= $Page->selection->caption() ?><?= $Page->selection->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->selection->cellAttributes() ?>>
<span id="el_payment_plan_selection">
    <select
        id="x_selection"
        name="x_selection"
        class="form-select ew-select<?= $Page->selection->isInvalidClass() ?>"
        <?php if (!$Page->selection->IsNativeSelect) { ?>
        data-select2-id="fpayment_planedit_x_selection"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_selection"
        data-value-separator="<?= $Page->selection->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->selection->getPlaceHolder()) ?>"
        <?= $Page->selection->editAttributes() ?>>
        <?= $Page->selection->selectOptionListHtml("x_selection") ?>
    </select>
    <?= $Page->selection->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->selection->getErrorMessage() ?></div>
<?php if (!$Page->selection->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_selection", selectId: "fpayment_planedit_x_selection" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_planedit.lists.selection?.lookupOptions.length) {
        options.data = { id: "x_selection", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_selection", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.selection.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gcode->Visible) { // gcode ?>
    <div id="r_gcode"<?= $Page->gcode->rowAttributes() ?>>
        <label id="elh_payment_plan_gcode" for="x_gcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gcode->caption() ?><?= $Page->gcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gcode->cellAttributes() ?>>
<span id="el_payment_plan_gcode">
    <select
        id="x_gcode[]"
        name="x_gcode[]"
        class="form-control ew-select<?= $Page->gcode->isInvalidClass() ?>"
        data-select2-id="fpayment_planedit_x_gcode[]"
        data-table="payment_plan"
        data-field="x_gcode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->gcode->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->gcode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gcode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->gcode->editAttributes() ?>>
        <?= $Page->gcode->selectOptionListHtml("x_gcode[]") ?>
    </select>
    <?= $Page->gcode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->gcode->getErrorMessage() ?></div>
<?= $Page->gcode->Lookup->getParamTag($Page, "p_x_gcode") ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_gcode[]", selectId: "fpayment_planedit_x_gcode[]" };
    options.multiple = true;
    if (fpayment_planedit.lists.gcode?.lookupOptions.length) {
        options.data = { id: "x_gcode[]", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_gcode[]", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.payment_plan.fields.gcode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref"<?= $Page->ref->rowAttributes() ?>>
        <label id="elh_payment_plan_ref" for="x_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ref->caption() ?><?= $Page->ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ref->cellAttributes() ?>>
<span id="el_payment_plan_ref">
    <select
        id="x_ref[]"
        name="x_ref[]"
        class="form-control ew-select<?= $Page->ref->isInvalidClass() ?>"
        data-select2-id="fpayment_planedit_x_ref[]"
        data-table="payment_plan"
        data-field="x_ref"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->ref->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>"
        <?= $Page->ref->editAttributes() ?>>
        <?= $Page->ref->selectOptionListHtml("x_ref[]") ?>
    </select>
    <?= $Page->ref->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->ref->getErrorMessage() ?></div>
<?= $Page->ref->Lookup->getParamTag($Page, "p_x_ref") ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_ref[]", selectId: "fpayment_planedit_x_ref[]" };
    options.multiple = true;
    if (fpayment_planedit.lists.ref?.lookupOptions.length) {
        options.data = { id: "x_ref[]", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_ref[]", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.payment_plan.fields.ref.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description"<?= $Page->description->rowAttributes() ?>>
        <label id="elh_payment_plan_description" for="x_description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description->caption() ?><?= $Page->description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description->cellAttributes() ?>>
<span id="el_payment_plan_description">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="payment_plan" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?> aria-describedby="x_description_help">
<?= $Page->description->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->yes_no->Visible) { // yes_no ?>
    <div id="r_yes_no"<?= $Page->yes_no->rowAttributes() ?>>
        <label id="elh_payment_plan_yes_no" for="x_yes_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->yes_no->caption() ?><?= $Page->yes_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->yes_no->cellAttributes() ?>>
<span id="el_payment_plan_yes_no">
    <select
        id="x_yes_no"
        name="x_yes_no"
        class="form-select ew-select<?= $Page->yes_no->isInvalidClass() ?>"
        <?php if (!$Page->yes_no->IsNativeSelect) { ?>
        data-select2-id="fpayment_planedit_x_yes_no"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_yes_no"
        data-value-separator="<?= $Page->yes_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->yes_no->getPlaceHolder()) ?>"
        <?= $Page->yes_no->editAttributes() ?>>
        <?= $Page->yes_no->selectOptionListHtml("x_yes_no") ?>
    </select>
    <?= $Page->yes_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->yes_no->getErrorMessage() ?></div>
<?php if (!$Page->yes_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_yes_no", selectId: "fpayment_planedit_x_yes_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_planedit.lists.yes_no?.lookupOptions.length) {
        options.data = { id: "x_yes_no", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_yes_no", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.yes_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packing_payment_type->Visible) { // packing_payment_type ?>
    <div id="r_packing_payment_type"<?= $Page->packing_payment_type->rowAttributes() ?>>
        <label id="elh_payment_plan_packing_payment_type" for="x_packing_payment_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packing_payment_type->caption() ?><?= $Page->packing_payment_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packing_payment_type->cellAttributes() ?>>
<span id="el_payment_plan_packing_payment_type">
    <select
        id="x_packing_payment_type"
        name="x_packing_payment_type"
        class="form-select ew-select<?= $Page->packing_payment_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_payment_type->IsNativeSelect) { ?>
        data-select2-id="fpayment_planedit_x_packing_payment_type"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_packing_payment_type"
        data-value-separator="<?= $Page->packing_payment_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_payment_type->getPlaceHolder()) ?>"
        <?= $Page->packing_payment_type->editAttributes() ?>>
        <?= $Page->packing_payment_type->selectOptionListHtml("x_packing_payment_type") ?>
    </select>
    <?= $Page->packing_payment_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->packing_payment_type->getErrorMessage() ?></div>
<?php if (!$Page->packing_payment_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_packing_payment_type", selectId: "fpayment_planedit_x_packing_payment_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_planedit.lists.packing_payment_type?.lookupOptions.length) {
        options.data = { id: "x_packing_payment_type", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_packing_payment_type", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.packing_payment_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->fix->Visible) { // fix ?>
    <div id="r_fix"<?= $Page->fix->rowAttributes() ?>>
        <label id="elh_payment_plan_fix" for="x_fix" class="<?= $Page->LeftColumnClass ?>"><?= $Page->fix->caption() ?><?= $Page->fix->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->fix->cellAttributes() ?>>
<span id="el_payment_plan_fix">
    <select
        id="x_fix"
        name="x_fix"
        class="form-select ew-select<?= $Page->fix->isInvalidClass() ?>"
        <?php if (!$Page->fix->IsNativeSelect) { ?>
        data-select2-id="fpayment_planedit_x_fix"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_fix"
        data-value-separator="<?= $Page->fix->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->fix->getPlaceHolder()) ?>"
        <?= $Page->fix->editAttributes() ?>>
        <?= $Page->fix->selectOptionListHtml("x_fix") ?>
    </select>
    <?= $Page->fix->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->fix->getErrorMessage() ?></div>
<?php if (!$Page->fix->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_fix", selectId: "fpayment_planedit_x_fix" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_planedit.lists.fix?.lookupOptions.length) {
        options.data = { id: "x_fix", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_fix", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.fix.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method"<?= $Page->method->rowAttributes() ?>>
        <label id="elh_payment_plan_method" for="x_method" class="<?= $Page->LeftColumnClass ?>"><?= $Page->method->caption() ?><?= $Page->method->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->method->cellAttributes() ?>>
<span id="el_payment_plan_method">
    <select
        id="x_method"
        name="x_method"
        class="form-select ew-select<?= $Page->method->isInvalidClass() ?>"
        <?php if (!$Page->method->IsNativeSelect) { ?>
        data-select2-id="fpayment_planedit_x_method"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_method"
        data-value-separator="<?= $Page->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>"
        <?= $Page->method->editAttributes() ?>>
        <?= $Page->method->selectOptionListHtml("x_method") ?>
    </select>
    <?= $Page->method->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->method->getErrorMessage() ?></div>
<?= $Page->method->Lookup->getParamTag($Page, "p_x_method") ?>
<?php if (!$Page->method->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_method", selectId: "fpayment_planedit_x_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_planedit.lists.method?.lookupOptions.length) {
        options.data = { id: "x_method", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_method", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm_method->Visible) { // sqm_method ?>
    <div id="r_sqm_method"<?= $Page->sqm_method->rowAttributes() ?>>
        <label id="elh_payment_plan_sqm_method" for="x_sqm_method" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm_method->caption() ?><?= $Page->sqm_method->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm_method->cellAttributes() ?>>
<span id="el_payment_plan_sqm_method">
    <select
        id="x_sqm_method"
        name="x_sqm_method"
        class="form-select ew-select<?= $Page->sqm_method->isInvalidClass() ?>"
        <?php if (!$Page->sqm_method->IsNativeSelect) { ?>
        data-select2-id="fpayment_planedit_x_sqm_method"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_sqm_method"
        data-value-separator="<?= $Page->sqm_method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sqm_method->getPlaceHolder()) ?>"
        <?= $Page->sqm_method->editAttributes() ?>>
        <?= $Page->sqm_method->selectOptionListHtml("x_sqm_method") ?>
    </select>
    <?= $Page->sqm_method->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->sqm_method->getErrorMessage() ?></div>
<?php if (!$Page->sqm_method->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_sqm_method", selectId: "fpayment_planedit_x_sqm_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_planedit.lists.sqm_method?.lookupOptions.length) {
        options.data = { id: "x_sqm_method", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_sqm_method", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.sqm_method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit"<?= $Page->unit->rowAttributes() ?>>
        <label id="elh_payment_plan_unit" for="x_unit" class="<?= $Page->LeftColumnClass ?>"><?= $Page->unit->caption() ?><?= $Page->unit->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->unit->cellAttributes() ?>>
<span id="el_payment_plan_unit">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="fpayment_planedit_x_unit"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <?= $Page->unit->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage() ?></div>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_unit", selectId: "fpayment_planedit_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_planedit.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_unit", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_unit->Visible) { // @_unit ?>
    <div id="r__unit"<?= $Page->_unit->rowAttributes() ?>>
        <label id="elh_payment_plan__unit" for="x__unit" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_unit->caption() ?><?= $Page->_unit->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_unit->cellAttributes() ?>>
<span id="el_payment_plan__unit">
<input type="<?= $Page->_unit->getInputTextType() ?>" name="x__unit" id="x__unit" data-table="payment_plan" data-field="x__unit" value="<?= $Page->_unit->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_unit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_unit->formatPattern()) ?>"<?= $Page->_unit->editAttributes() ?> aria-describedby="x__unit_help">
<?= $Page->_unit->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_unit->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
    <div id="r__40"<?= $Page->_40->rowAttributes() ?>>
        <label id="elh_payment_plan__40" for="x__40" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_40->caption() ?><?= $Page->_40->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_40->cellAttributes() ?>>
<span id="el_payment_plan__40">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="payment_plan" data-field="x__40" value="<?= $Page->_40->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?> aria-describedby="x__40_help">
<?= $Page->_40->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->extra_plan->Visible) { // extra_plan ?>
    <div id="r_extra_plan"<?= $Page->extra_plan->rowAttributes() ?>>
        <label id="elh_payment_plan_extra_plan" for="x_extra_plan" class="<?= $Page->LeftColumnClass ?>"><?= $Page->extra_plan->caption() ?><?= $Page->extra_plan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->extra_plan->cellAttributes() ?>>
<span id="el_payment_plan_extra_plan">
    <select
        id="x_extra_plan"
        name="x_extra_plan"
        class="form-select ew-select<?= $Page->extra_plan->isInvalidClass() ?>"
        <?php if (!$Page->extra_plan->IsNativeSelect) { ?>
        data-select2-id="fpayment_planedit_x_extra_plan"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_extra_plan"
        data-value-separator="<?= $Page->extra_plan->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->extra_plan->getPlaceHolder()) ?>"
        <?= $Page->extra_plan->editAttributes() ?>>
        <?= $Page->extra_plan->selectOptionListHtml("x_extra_plan") ?>
    </select>
    <?= $Page->extra_plan->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->extra_plan->getErrorMessage() ?></div>
<?php if (!$Page->extra_plan->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_extra_plan", selectId: "fpayment_planedit_x_extra_plan" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_planedit.lists.extra_plan?.lookupOptions.length) {
        options.data = { id: "x_extra_plan", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_extra_plan", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.extra_plan.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->custom_size->Visible) { // custom_size ?>
    <div id="r_custom_size"<?= $Page->custom_size->rowAttributes() ?>>
        <label id="elh_payment_plan_custom_size" for="x_custom_size" class="<?= $Page->LeftColumnClass ?>"><?= $Page->custom_size->caption() ?><?= $Page->custom_size->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->custom_size->cellAttributes() ?>>
<span id="el_payment_plan_custom_size">
<input type="<?= $Page->custom_size->getInputTextType() ?>" name="x_custom_size" id="x_custom_size" data-table="payment_plan" data-field="x_custom_size" value="<?= $Page->custom_size->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->custom_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->custom_size->formatPattern()) ?>"<?= $Page->custom_size->editAttributes() ?> aria-describedby="x_custom_size_help">
<?= $Page->custom_size->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->custom_size->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->custom_size_below_st->Visible) { // custom_size_below_st ?>
    <div id="r_custom_size_below_st"<?= $Page->custom_size_below_st->rowAttributes() ?>>
        <label id="elh_payment_plan_custom_size_below_st" for="x_custom_size_below_st" class="<?= $Page->LeftColumnClass ?>"><?= $Page->custom_size_below_st->caption() ?><?= $Page->custom_size_below_st->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->custom_size_below_st->cellAttributes() ?>>
<span id="el_payment_plan_custom_size_below_st">
<input type="<?= $Page->custom_size_below_st->getInputTextType() ?>" name="x_custom_size_below_st" id="x_custom_size_below_st" data-table="payment_plan" data-field="x_custom_size_below_st" value="<?= $Page->custom_size_below_st->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->custom_size_below_st->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->custom_size_below_st->formatPattern()) ?>"<?= $Page->custom_size_below_st->editAttributes() ?> aria-describedby="x_custom_size_below_st_help">
<?= $Page->custom_size_below_st->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->custom_size_below_st->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_payment_plan_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_payment_plan_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpayment_planedit_x_status"
        <?php } ?>
        data-table="payment_plan"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_planedit", function() {
    var options = { name: "x_status", selectId: "fpayment_planedit_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_planedit.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpayment_planedit" };
    } else {
        options.ajax = { id: "x_status", form: "fpayment_planedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_payment_plan_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_payment_plan_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="payment_plan"
        data-field="x_uploads"
        data-size="500"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->uploads->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="<?= (Post("fa_x_uploads") == "0") ? "0" : "1" ?>">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpayment_planedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpayment_planedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payment_plan");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    $("#elh_payment_plan_ref").append('<div id="1" class="input-group-append"><h6 style="color:blue" onclick="javascript:SelectAll(\'ref\',\'1\')"><i class="fa fa-check-square-o"></i> Select All</h6></div>');
    $("#elh_payment_plan_ref").append('<div id="2" class="input-group-append"><h6 style="color:blue" onclick="javascript:SelectAll(\'ref\',\'2\')"><i class="fa fa-times"></i> Unselect All</h6></div>');
    		var PROCESS = $('#x_process').val();
    		if((PROCESS == 27)|| (PROCESS == 28)|| (PROCESS == 29))
    		{
    		$("#r_extra_plan").show();
    		$("#r_custom_size").show();
    		} else {
    		$("#r_extra_plan").hide();
    		$("#r_custom_size").hide();
    		}
    		if((PROCESS == 19))
    		{
    		$("#r_packing_payment_type").show();
    		}
    		else
    		{
    		$("#r_packing_payment_type").hide();
    		}
});
</script>
