<?php

namespace PHPMaker2024\fibre;

// Page object
$PaymentPlanCheckSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payment_plan_check: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpayment_plan_checksearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpayment_plan_checksearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["pa_location", [], fields.pa_location.isInvalid],
            ["pa_process", [], fields.pa_process.isInvalid],
            ["pa_ref", [], fields.pa_ref.isInvalid],
            ["pa_size", [ew.Validators.integer], fields.pa_size.isInvalid],
            ["price", [], fields.price.isInvalid],
            ["pa_payment", [], fields.pa_payment.isInvalid],
            ["pps", [ew.Validators.integer], fields.pps.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "pa_location": <?= $Page->pa_location->toClientList($Page) ?>,
            "pa_process": <?= $Page->pa_process->toClientList($Page) ?>,
            "pa_payment": <?= $Page->pa_payment->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpayment_plan_checksearch" id="fpayment_plan_checksearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payment_plan_check">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->pa_location->Visible) { // pa_location ?>
    <div id="r_pa_location" class="row"<?= $Page->pa_location->rowAttributes() ?>>
        <label for="x_pa_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_check_pa_location"><?= $Page->pa_location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pa_location" id="z_pa_location" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pa_location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_check_pa_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_pa_location"
        name="x_pa_location"
        class="form-select ew-select<?= $Page->pa_location->isInvalidClass() ?>"
        <?php if (!$Page->pa_location->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_checksearch_x_pa_location"
        <?php } ?>
        data-table="payment_plan_check"
        data-field="x_pa_location"
        data-value-separator="<?= $Page->pa_location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pa_location->getPlaceHolder()) ?>"
        <?= $Page->pa_location->editAttributes() ?>>
        <?= $Page->pa_location->selectOptionListHtml("x_pa_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pa_location->getErrorMessage(false) ?></div>
<?= $Page->pa_location->Lookup->getParamTag($Page, "p_x_pa_location") ?>
<?php if (!$Page->pa_location->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_checksearch", function() {
    var options = { name: "x_pa_location", selectId: "fpayment_plan_checksearch_x_pa_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_checksearch.lists.pa_location?.lookupOptions.length) {
        options.data = { id: "x_pa_location", form: "fpayment_plan_checksearch" };
    } else {
        options.ajax = { id: "x_pa_location", form: "fpayment_plan_checksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_check.fields.pa_location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pa_process->Visible) { // pa_process ?>
    <div id="r_pa_process" class="row"<?= $Page->pa_process->rowAttributes() ?>>
        <label for="x_pa_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_check_pa_process"><?= $Page->pa_process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pa_process" id="z_pa_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pa_process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_check_pa_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_pa_process"
        name="x_pa_process"
        class="form-select ew-select<?= $Page->pa_process->isInvalidClass() ?>"
        <?php if (!$Page->pa_process->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_checksearch_x_pa_process"
        <?php } ?>
        data-table="payment_plan_check"
        data-field="x_pa_process"
        data-value-separator="<?= $Page->pa_process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pa_process->getPlaceHolder()) ?>"
        <?= $Page->pa_process->editAttributes() ?>>
        <?= $Page->pa_process->selectOptionListHtml("x_pa_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pa_process->getErrorMessage(false) ?></div>
<?= $Page->pa_process->Lookup->getParamTag($Page, "p_x_pa_process") ?>
<?php if (!$Page->pa_process->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_checksearch", function() {
    var options = { name: "x_pa_process", selectId: "fpayment_plan_checksearch_x_pa_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_checksearch.lists.pa_process?.lookupOptions.length) {
        options.data = { id: "x_pa_process", form: "fpayment_plan_checksearch" };
    } else {
        options.ajax = { id: "x_pa_process", form: "fpayment_plan_checksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_check.fields.pa_process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pa_ref->Visible) { // pa_ref ?>
    <div id="r_pa_ref" class="row"<?= $Page->pa_ref->rowAttributes() ?>>
        <label for="x_pa_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_check_pa_ref"><?= $Page->pa_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pa_ref" id="z_pa_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pa_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_check_pa_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pa_ref->getInputTextType() ?>" name="x_pa_ref" id="x_pa_ref" data-table="payment_plan_check" data-field="x_pa_ref" value="<?= $Page->pa_ref->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->pa_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pa_ref->formatPattern()) ?>"<?= $Page->pa_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pa_ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pa_size->Visible) { // pa_size ?>
    <div id="r_pa_size" class="row"<?= $Page->pa_size->rowAttributes() ?>>
        <label for="x_pa_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_check_pa_size"><?= $Page->pa_size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pa_size" id="z_pa_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pa_size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_check_pa_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pa_size->getInputTextType() ?>" name="x_pa_size" id="x_pa_size" data-table="payment_plan_check" data-field="x_pa_size" value="<?= $Page->pa_size->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pa_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pa_size->formatPattern()) ?>"<?= $Page->pa_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pa_size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price" class="row"<?= $Page->price->rowAttributes() ?>>
        <label for="x_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_check_price"><?= $Page->price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_price" id="z_price" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_check_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="payment_plan_check" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" maxlength="19" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pa_payment->Visible) { // pa_payment ?>
    <div id="r_pa_payment" class="row"<?= $Page->pa_payment->rowAttributes() ?>>
        <label for="x_pa_payment" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_check_pa_payment"><?= $Page->pa_payment->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pa_payment" id="z_pa_payment" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pa_payment->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_check_pa_payment" class="ew-search-field ew-search-field-single">
    <select
        id="x_pa_payment"
        name="x_pa_payment"
        class="form-select ew-select<?= $Page->pa_payment->isInvalidClass() ?>"
        <?php if (!$Page->pa_payment->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_checksearch_x_pa_payment"
        <?php } ?>
        data-table="payment_plan_check"
        data-field="x_pa_payment"
        data-value-separator="<?= $Page->pa_payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pa_payment->getPlaceHolder()) ?>"
        <?= $Page->pa_payment->editAttributes() ?>>
        <?= $Page->pa_payment->selectOptionListHtml("x_pa_payment") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pa_payment->getErrorMessage(false) ?></div>
<?= $Page->pa_payment->Lookup->getParamTag($Page, "p_x_pa_payment") ?>
<?php if (!$Page->pa_payment->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_checksearch", function() {
    var options = { name: "x_pa_payment", selectId: "fpayment_plan_checksearch_x_pa_payment" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_checksearch.lists.pa_payment?.lookupOptions.length) {
        options.data = { id: "x_pa_payment", form: "fpayment_plan_checksearch" };
    } else {
        options.ajax = { id: "x_pa_payment", form: "fpayment_plan_checksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_check.fields.pa_payment.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pps->Visible) { // pps ?>
    <div id="r_pps" class="row"<?= $Page->pps->rowAttributes() ?>>
        <label for="x_pps" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_plan_check_pps"><?= $Page->pps->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pps" id="z_pps" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pps->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_plan_check_pps" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pps->getInputTextType() ?>" name="x_pps" id="x_pps" data-table="payment_plan_check" data-field="x_pps" value="<?= $Page->pps->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pps->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pps->formatPattern()) ?>"<?= $Page->pps->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pps->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpayment_plan_checksearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpayment_plan_checksearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpayment_plan_checksearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payment_plan_check");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
