<?php

namespace PHPMaker2024\fibre;

// Page object
$PaymentPlanCheckSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payment_plan_check: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpayment_plan_checksearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpayment_plan_checksearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["pa_location", [], fields.pa_location.isInvalid],
            ["pa_process", [], fields.pa_process.isInvalid],
            ["pa_ref", [], fields.pa_ref.isInvalid],
            ["pa_size", [ew.Validators.integer], fields.pa_size.isInvalid],
            ["price", [], fields.price.isInvalid],
            ["pa_payment", [], fields.pa_payment.isInvalid],
            ["pps", [ew.Validators.integer], fields.pps.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "pa_location": <?= $Page->pa_location->toClientList($Page) ?>,
            "pa_process": <?= $Page->pa_process->toClientList($Page) ?>,
            "pa_payment": <?= $Page->pa_payment->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpayment_plan_checksearch" id="fpayment_plan_checksearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("paymentplanchecklist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payment_plan_check">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_payment_plan_check_pa_location" class="payment_plan_checksearch"><span id="el_payment_plan_check_pa_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_pa_location"
        name="x_pa_location"
        class="form-select ew-select<?= $Page->pa_location->isInvalidClass() ?>"
        <?php if (!$Page->pa_location->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_checksearch_x_pa_location"
        <?php } ?>
        data-table="payment_plan_check"
        data-field="x_pa_location"
        data-value-separator="<?= $Page->pa_location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pa_location->getPlaceHolder()) ?>"
        <?= $Page->pa_location->editAttributes() ?>>
        <?= $Page->pa_location->selectOptionListHtml("x_pa_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pa_location->getErrorMessage(false) ?></div>
<?= $Page->pa_location->Lookup->getParamTag($Page, "p_x_pa_location") ?>
<?php if (!$Page->pa_location->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_checksearch", function() {
    var options = { name: "x_pa_location", selectId: "fpayment_plan_checksearch_x_pa_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_checksearch.lists.pa_location?.lookupOptions.length) {
        options.data = { id: "x_pa_location", form: "fpayment_plan_checksearch" };
    } else {
        options.ajax = { id: "x_pa_location", form: "fpayment_plan_checksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_check.fields.pa_location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_payment_plan_check_pa_process" class="payment_plan_checksearch"><span id="el_payment_plan_check_pa_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_pa_process"
        name="x_pa_process"
        class="form-select ew-select<?= $Page->pa_process->isInvalidClass() ?>"
        <?php if (!$Page->pa_process->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_checksearch_x_pa_process"
        <?php } ?>
        data-table="payment_plan_check"
        data-field="x_pa_process"
        data-value-separator="<?= $Page->pa_process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pa_process->getPlaceHolder()) ?>"
        <?= $Page->pa_process->editAttributes() ?>>
        <?= $Page->pa_process->selectOptionListHtml("x_pa_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pa_process->getErrorMessage(false) ?></div>
<?= $Page->pa_process->Lookup->getParamTag($Page, "p_x_pa_process") ?>
<?php if (!$Page->pa_process->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_checksearch", function() {
    var options = { name: "x_pa_process", selectId: "fpayment_plan_checksearch_x_pa_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_checksearch.lists.pa_process?.lookupOptions.length) {
        options.data = { id: "x_pa_process", form: "fpayment_plan_checksearch" };
    } else {
        options.ajax = { id: "x_pa_process", form: "fpayment_plan_checksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_check.fields.pa_process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_payment_plan_check_pa_ref" class="payment_plan_checksearch"><span id="el_payment_plan_check_pa_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pa_ref->getInputTextType() ?>" name="x_pa_ref" id="x_pa_ref" data-table="payment_plan_check" data-field="x_pa_ref" value="<?= $Page->pa_ref->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->pa_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pa_ref->formatPattern()) ?>"<?= $Page->pa_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pa_ref->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payment_plan_check_pa_size" class="payment_plan_checksearch"><span id="el_payment_plan_check_pa_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pa_size->getInputTextType() ?>" name="x_pa_size" id="x_pa_size" data-table="payment_plan_check" data-field="x_pa_size" value="<?= $Page->pa_size->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pa_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pa_size->formatPattern()) ?>"<?= $Page->pa_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pa_size->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payment_plan_check_price" class="payment_plan_checksearch"><span id="el_payment_plan_check_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="payment_plan_check" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" maxlength="19" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_payment_plan_check_pa_payment" class="payment_plan_checksearch"><span id="el_payment_plan_check_pa_payment" class="ew-search-field ew-search-field-single">
    <select
        id="x_pa_payment"
        name="x_pa_payment"
        class="form-select ew-select<?= $Page->pa_payment->isInvalidClass() ?>"
        <?php if (!$Page->pa_payment->IsNativeSelect) { ?>
        data-select2-id="fpayment_plan_checksearch_x_pa_payment"
        <?php } ?>
        data-table="payment_plan_check"
        data-field="x_pa_payment"
        data-value-separator="<?= $Page->pa_payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pa_payment->getPlaceHolder()) ?>"
        <?= $Page->pa_payment->editAttributes() ?>>
        <?= $Page->pa_payment->selectOptionListHtml("x_pa_payment") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pa_payment->getErrorMessage(false) ?></div>
<?= $Page->pa_payment->Lookup->getParamTag($Page, "p_x_pa_payment") ?>
<?php if (!$Page->pa_payment->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_plan_checksearch", function() {
    var options = { name: "x_pa_payment", selectId: "fpayment_plan_checksearch_x_pa_payment" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_plan_checksearch.lists.pa_payment?.lookupOptions.length) {
        options.data = { id: "x_pa_payment", form: "fpayment_plan_checksearch" };
    } else {
        options.ajax = { id: "x_pa_payment", form: "fpayment_plan_checksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_plan_check.fields.pa_payment.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_payment_plan_check_pps" class="payment_plan_checksearch"><span id="el_payment_plan_check_pps" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pps->getInputTextType() ?>" name="x_pps" id="x_pps" data-table="payment_plan_check" data-field="x_pps" value="<?= $Page->pps->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pps->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pps->formatPattern()) ?>"<?= $Page->pps->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pps->getErrorMessage(false) ?></div>
</span></template>
<div id="payment_plan_check_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "pa_location",
                type: "string",
                label: currentTable.fields.pa_location.caption,
                operators: currentTable.fields.pa_location.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpayment_plan_checksearch.fields.pa_location.validators),
                data: {
                    format: currentTable.fields.pa_location.clientFormatPattern
                }
            },
            {
                id: "pa_process",
                type: "integer",
                label: currentTable.fields.pa_process.caption,
                operators: currentTable.fields.pa_process.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpayment_plan_checksearch.fields.pa_process.validators),
                data: {
                    format: currentTable.fields.pa_process.clientFormatPattern
                }
            },
            {
                id: "pa_ref",
                type: "string",
                label: currentTable.fields.pa_ref.caption,
                operators: currentTable.fields.pa_ref.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayment_plan_checksearch.fields.pa_ref.validators),
                data: {
                    format: currentTable.fields.pa_ref.clientFormatPattern
                }
            },
            {
                id: "pa_size",
                type: "string",
                label: currentTable.fields.pa_size.caption,
                operators: currentTable.fields.pa_size.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayment_plan_checksearch.fields.pa_size.validators),
                data: {
                    format: currentTable.fields.pa_size.clientFormatPattern
                }
            },
            {
                id: "price",
                type: "string",
                label: currentTable.fields.price.caption,
                operators: currentTable.fields.price.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayment_plan_checksearch.fields.price.validators),
                data: {
                    format: currentTable.fields.price.clientFormatPattern
                }
            },
            {
                id: "pa_payment",
                type: "string",
                label: currentTable.fields.pa_payment.caption,
                operators: currentTable.fields.pa_payment.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpayment_plan_checksearch.fields.pa_payment.validators),
                data: {
                    format: currentTable.fields.pa_payment.clientFormatPattern
                }
            },
            {
                id: "pps",
                type: "integer",
                label: currentTable.fields.pps.caption,
                operators: currentTable.fields.pps.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpayment_plan_checksearch.fields.pps.validators),
                data: {
                    format: currentTable.fields.pps.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#payment_plan_check_query_builder"),
        args = {},
        rules = ew.parseJson($("#fpayment_plan_checksearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fpayment_plan_checksearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fpayment_plan_checksearch" formaction="<?= HtmlEncode(GetUrl("paymentplanchecklist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpayment_plan_checksearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fpayment_plan_checksearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payment_plan_check");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
