<?php

namespace PHPMaker2024\fibre;

// Page object
$PaymentEmpGrpCheckSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { payment_emp_grp_check: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpayment_emp_grp_checksearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpayment_emp_grp_checksearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["code", [], fields.code.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["payment_type", [], fields.payment_type.isInvalid],
            ["payment", [], fields.payment.isInvalid],
            ["emp_grp", [ew.Validators.integer], fields.emp_grp.isInvalid],
            ["y_emp_grp", [ew.Validators.between], false],
            ["count", [ew.Validators.integer], fields.count.isInvalid],
            ["y_count", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "process": <?= $Page->process->toClientList($Page) ?>,
            "payment_type": <?= $Page->payment_type->toClientList($Page) ?>,
            "payment": <?= $Page->payment->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpayment_emp_grp_checksearch" id="fpayment_emp_grp_checksearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="payment_emp_grp_check">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label for="x_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_emp_grp_check_code"><?= $Page->code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_code" id="z_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_emp_grp_check_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="payment_emp_grp_check" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label for="x_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_emp_grp_check_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_emp_grp_check_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fpayment_emp_grp_checksearch_x_process"
        <?php } ?>
        data-table="payment_emp_grp_check"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_emp_grp_checksearch", function() {
    var options = { name: "x_process", selectId: "fpayment_emp_grp_checksearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_emp_grp_checksearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fpayment_emp_grp_checksearch" };
    } else {
        options.ajax = { id: "x_process", form: "fpayment_emp_grp_checksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_emp_grp_check.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment_type->Visible) { // payment_type ?>
    <div id="r_payment_type" class="row"<?= $Page->payment_type->rowAttributes() ?>>
        <label for="x_payment_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_emp_grp_check_payment_type"><?= $Page->payment_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_payment_type" id="z_payment_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_emp_grp_check_payment_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_payment_type"
        name="x_payment_type"
        class="form-select ew-select<?= $Page->payment_type->isInvalidClass() ?>"
        <?php if (!$Page->payment_type->IsNativeSelect) { ?>
        data-select2-id="fpayment_emp_grp_checksearch_x_payment_type"
        <?php } ?>
        data-table="payment_emp_grp_check"
        data-field="x_payment_type"
        data-value-separator="<?= $Page->payment_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment_type->getPlaceHolder()) ?>"
        <?= $Page->payment_type->editAttributes() ?>>
        <?= $Page->payment_type->selectOptionListHtml("x_payment_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment_type->getErrorMessage(false) ?></div>
<?php if (!$Page->payment_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_emp_grp_checksearch", function() {
    var options = { name: "x_payment_type", selectId: "fpayment_emp_grp_checksearch_x_payment_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_emp_grp_checksearch.lists.payment_type?.lookupOptions.length) {
        options.data = { id: "x_payment_type", form: "fpayment_emp_grp_checksearch" };
    } else {
        options.ajax = { id: "x_payment_type", form: "fpayment_emp_grp_checksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_emp_grp_check.fields.payment_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment->Visible) { // payment ?>
    <div id="r_payment" class="row"<?= $Page->payment->rowAttributes() ?>>
        <label for="x_payment" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_emp_grp_check_payment"><?= $Page->payment->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_payment" id="z_payment" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_payment_emp_grp_check_payment" class="ew-search-field ew-search-field-single">
    <select
        id="x_payment"
        name="x_payment"
        class="form-select ew-select<?= $Page->payment->isInvalidClass() ?>"
        <?php if (!$Page->payment->IsNativeSelect) { ?>
        data-select2-id="fpayment_emp_grp_checksearch_x_payment"
        <?php } ?>
        data-table="payment_emp_grp_check"
        data-field="x_payment"
        data-value-separator="<?= $Page->payment->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment->getPlaceHolder()) ?>"
        <?= $Page->payment->editAttributes() ?>>
        <?= $Page->payment->selectOptionListHtml("x_payment") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment->getErrorMessage(false) ?></div>
<?= $Page->payment->Lookup->getParamTag($Page, "p_x_payment") ?>
<?php if (!$Page->payment->IsNativeSelect) { ?>
<script>
loadjs.ready("fpayment_emp_grp_checksearch", function() {
    var options = { name: "x_payment", selectId: "fpayment_emp_grp_checksearch_x_payment" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpayment_emp_grp_checksearch.lists.payment?.lookupOptions.length) {
        options.data = { id: "x_payment", form: "fpayment_emp_grp_checksearch" };
    } else {
        options.ajax = { id: "x_payment", form: "fpayment_emp_grp_checksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.payment_emp_grp_check.fields.payment.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emp_grp->Visible) { // emp_grp ?>
    <div id="r_emp_grp" class="row"<?= $Page->emp_grp->rowAttributes() ?>>
        <label for="x_emp_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_emp_grp_check_emp_grp"><?= $Page->emp_grp->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emp_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_emp_grp" id="z_emp_grp" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->emp_grp->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->emp_grp->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_payment_emp_grp_check_emp_grp" class="ew-search-field">
<input type="<?= $Page->emp_grp->getInputTextType() ?>" name="x_emp_grp" id="x_emp_grp" data-table="payment_emp_grp_check" data-field="x_emp_grp" value="<?= $Page->emp_grp->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->emp_grp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emp_grp->formatPattern()) ?>"<?= $Page->emp_grp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->emp_grp->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_payment_emp_grp_check_emp_grp" class="ew-search-field2 d-none">
<input type="<?= $Page->emp_grp->getInputTextType() ?>" name="y_emp_grp" id="y_emp_grp" data-table="payment_emp_grp_check" data-field="x_emp_grp" value="<?= $Page->emp_grp->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->emp_grp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emp_grp->formatPattern()) ?>"<?= $Page->emp_grp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->emp_grp->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->count->Visible) { // count ?>
    <div id="r_count" class="row"<?= $Page->count->rowAttributes() ?>>
        <label for="x_count" class="<?= $Page->LeftColumnClass ?>"><span id="elh_payment_emp_grp_check_count"><?= $Page->count->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->count->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_count" id="z_count" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->count->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->count->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_payment_emp_grp_check_count" class="ew-search-field">
<input type="<?= $Page->count->getInputTextType() ?>" name="x_count" id="x_count" data-table="payment_emp_grp_check" data-field="x_count" value="<?= $Page->count->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->count->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->count->formatPattern()) ?>"<?= $Page->count->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->count->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_payment_emp_grp_check_count" class="ew-search-field2 d-none">
<input type="<?= $Page->count->getInputTextType() ?>" name="y_count" id="y_count" data-table="payment_emp_grp_check" data-field="x_count" value="<?= $Page->count->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->count->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->count->formatPattern()) ?>"<?= $Page->count->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->count->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpayment_emp_grp_checksearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpayment_emp_grp_checksearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpayment_emp_grp_checksearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("payment_emp_grp_check");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
