<?php

namespace PHPMaker2024\fibre;

// Page object
$PartnerQuotationBuyerSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { partner_quotation_buyer: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpartner_quotation_buyersearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpartner_quotation_buyersearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["partner_id", [], fields.partner_id.isInvalid],
            ["partner_details", [], fields.partner_details.isInvalid],
            ["product_type", [], fields.product_type.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["partner_code", [], fields.partner_code.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["unit", [], fields.unit.isInvalid],
            ["quantity_approx", [], fields.quantity_approx.isInvalid],
            ["quantity", [ew.Validators.float], fields.quantity.isInvalid],
            ["price", [ew.Validators.float], fields.price.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["total_amount", [ew.Validators.float], fields.total_amount.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["payment_terms", [], fields.payment_terms.isInvalid],
            ["tax_categories", [], fields.tax_categories.isInvalid],
            ["delivery_period", [ew.Validators.integer], fields.delivery_period.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["pp_operator", [ew.Validators.integer], fields.pp_operator.isInvalid],
            ["pp_datetime", [ew.Validators.datetime(fields.pp_datetime.clientFormatPattern)], fields.pp_datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "product_code": <?= $Page->product_code->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "payment_terms": <?= $Page->payment_terms->toClientList($Page) ?>,
            "tax_categories": <?= $Page->tax_categories->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpartner_quotation_buyersearch" id="fpartner_quotation_buyersearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="partner_quotation_buyer">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="partner_quotation_buyer" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyersearch_x_company_id"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyersearch", function() {
    var options = { name: "x_company_id", selectId: "fpartner_quotation_buyersearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyersearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fpartner_quotation_buyersearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fpartner_quotation_buyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
    <div id="r_partner_id" class="row"<?= $Page->partner_id->rowAttributes() ?>>
        <label for="x_partner_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_partner_id"><?= $Page->partner_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner_id" id="z_partner_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_partner_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-select ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        <?php if (!$Page->partner_id->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyersearch_x_partner_id"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_partner_id"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<?php if (!$Page->partner_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyersearch", function() {
    var options = { name: "x_partner_id", selectId: "fpartner_quotation_buyersearch_x_partner_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyersearch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fpartner_quotation_buyersearch" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fpartner_quotation_buyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.partner_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_details->Visible) { // partner_details ?>
    <div id="r_partner_details" class="row"<?= $Page->partner_details->rowAttributes() ?>>
        <label for="x_partner_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_partner_details"><?= $Page->partner_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_details" id="z_partner_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_partner_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_details->getInputTextType() ?>" name="x_partner_details" id="x_partner_details" data-table="partner_quotation_buyer" data-field="x_partner_details" value="<?= $Page->partner_details->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->partner_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_details->formatPattern()) ?>"<?= $Page->partner_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type" class="row"<?= $Page->product_type->rowAttributes() ?>>
        <label for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_product_type"><?= $Page->product_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_type" id="z_product_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_product_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyersearch_x_product_type"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_product_type"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyersearch", function() {
    var options = { name: "x_product_type", selectId: "fpartner_quotation_buyersearch_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyersearch.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "fpartner_quotation_buyersearch" };
    } else {
        options.ajax = { id: "x_product_type", form: "fpartner_quotation_buyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyersearch_x_product"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyersearch", function() {
    var options = { name: "x_product", selectId: "fpartner_quotation_buyersearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyersearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fpartner_quotation_buyersearch" };
    } else {
        options.ajax = { id: "x_product", form: "fpartner_quotation_buyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_product_code" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_code"
        name="x_product_code"
        class="form-select ew-select<?= $Page->product_code->isInvalidClass() ?>"
        <?php if (!$Page->product_code->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyersearch_x_product_code"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_product_code"
        data-value-separator="<?= $Page->product_code->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>"
        <?= $Page->product_code->editAttributes() ?>>
        <?= $Page->product_code->selectOptionListHtml("x_product_code") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
<?= $Page->product_code->Lookup->getParamTag($Page, "p_x_product_code") ?>
<?php if (!$Page->product_code->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyersearch", function() {
    var options = { name: "x_product_code", selectId: "fpartner_quotation_buyersearch_x_product_code" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyersearch.lists.product_code?.lookupOptions.length) {
        options.data = { id: "x_product_code", form: "fpartner_quotation_buyersearch" };
    } else {
        options.ajax = { id: "x_product_code", form: "fpartner_quotation_buyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.product_code.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_code->Visible) { // partner_code ?>
    <div id="r_partner_code" class="row"<?= $Page->partner_code->rowAttributes() ?>>
        <label for="x_partner_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_partner_code"><?= $Page->partner_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_code" id="z_partner_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_partner_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_code->getInputTextType() ?>" name="x_partner_code" id="x_partner_code" data-table="partner_quotation_buyer" data-field="x_partner_code" value="<?= $Page->partner_code->EditValue ?>" maxlength="1000" placeholder="<?= HtmlEncode($Page->partner_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_code->formatPattern()) ?>"<?= $Page->partner_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyersearch_x_packing_type"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyersearch", function() {
    var options = { name: "x_packing_type", selectId: "fpartner_quotation_buyersearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyersearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpartner_quotation_buyersearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpartner_quotation_buyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit" class="row"<?= $Page->unit->rowAttributes() ?>>
        <label for="x_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_unit"><?= $Page->unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unit" id="z_unit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_unit" class="ew-search-field ew-search-field-single">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyersearch_x_unit"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage(false) ?></div>
<?= $Page->unit->Lookup->getParamTag($Page, "p_x_unit") ?>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyersearch", function() {
    var options = { name: "x_unit", selectId: "fpartner_quotation_buyersearch_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyersearch.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "fpartner_quotation_buyersearch" };
    } else {
        options.ajax = { id: "x_unit", form: "fpartner_quotation_buyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity_approx->Visible) { // quantity_approx ?>
    <div id="r_quantity_approx" class="row"<?= $Page->quantity_approx->rowAttributes() ?>>
        <label for="x_quantity_approx" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_quantity_approx"><?= $Page->quantity_approx->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_quantity_approx" id="z_quantity_approx" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity_approx->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_quantity_approx" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity_approx->getInputTextType() ?>" name="x_quantity_approx" id="x_quantity_approx" data-table="partner_quotation_buyer" data-field="x_quantity_approx" value="<?= $Page->quantity_approx->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->quantity_approx->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity_approx->formatPattern()) ?>"<?= $Page->quantity_approx->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity_approx->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="partner_quotation_buyer" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price" class="row"<?= $Page->price->rowAttributes() ?>>
        <label for="x_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_price"><?= $Page->price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price" id="z_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="partner_quotation_buyer" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="partner_quotation_buyer" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label for="x_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency" id="z_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyersearch_x_currency"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyersearch", function() {
    var options = { name: "x_currency", selectId: "fpartner_quotation_buyersearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyersearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fpartner_quotation_buyersearch" };
    } else {
        options.ajax = { id: "x_currency", form: "fpartner_quotation_buyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->total_amount->Visible) { // total_amount ?>
    <div id="r_total_amount" class="row"<?= $Page->total_amount->rowAttributes() ?>>
        <label for="x_total_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_total_amount"><?= $Page->total_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_total_amount" id="z_total_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->total_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_total_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->total_amount->getInputTextType() ?>" name="x_total_amount" id="x_total_amount" data-table="partner_quotation_buyer" data-field="x_total_amount" value="<?= $Page->total_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->total_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->total_amount->formatPattern()) ?>"<?= $Page->total_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->total_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="partner_quotation_buyer" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment_terms->Visible) { // payment_terms ?>
    <div id="r_payment_terms" class="row"<?= $Page->payment_terms->rowAttributes() ?>>
        <label for="x_payment_terms" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_payment_terms"><?= $Page->payment_terms->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_payment_terms" id="z_payment_terms" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment_terms->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_payment_terms" class="ew-search-field ew-search-field-single">
    <select
        id="x_payment_terms"
        name="x_payment_terms"
        class="form-select ew-select<?= $Page->payment_terms->isInvalidClass() ?>"
        <?php if (!$Page->payment_terms->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyersearch_x_payment_terms"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_payment_terms"
        data-value-separator="<?= $Page->payment_terms->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment_terms->getPlaceHolder()) ?>"
        <?= $Page->payment_terms->editAttributes() ?>>
        <?= $Page->payment_terms->selectOptionListHtml("x_payment_terms") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment_terms->getErrorMessage(false) ?></div>
<?= $Page->payment_terms->Lookup->getParamTag($Page, "p_x_payment_terms") ?>
<?php if (!$Page->payment_terms->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyersearch", function() {
    var options = { name: "x_payment_terms", selectId: "fpartner_quotation_buyersearch_x_payment_terms" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyersearch.lists.payment_terms?.lookupOptions.length) {
        options.data = { id: "x_payment_terms", form: "fpartner_quotation_buyersearch" };
    } else {
        options.ajax = { id: "x_payment_terms", form: "fpartner_quotation_buyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.payment_terms.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tax_categories->Visible) { // tax_categories ?>
    <div id="r_tax_categories" class="row"<?= $Page->tax_categories->rowAttributes() ?>>
        <label for="x_tax_categories" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_tax_categories"><?= $Page->tax_categories->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_tax_categories" id="z_tax_categories" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tax_categories->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_tax_categories" class="ew-search-field ew-search-field-single">
    <select
        id="x_tax_categories"
        name="x_tax_categories"
        class="form-select ew-select<?= $Page->tax_categories->isInvalidClass() ?>"
        <?php if (!$Page->tax_categories->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyersearch_x_tax_categories"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_tax_categories"
        data-value-separator="<?= $Page->tax_categories->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->tax_categories->getPlaceHolder()) ?>"
        <?= $Page->tax_categories->editAttributes() ?>>
        <?= $Page->tax_categories->selectOptionListHtml("x_tax_categories") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->tax_categories->getErrorMessage(false) ?></div>
<?= $Page->tax_categories->Lookup->getParamTag($Page, "p_x_tax_categories") ?>
<?php if (!$Page->tax_categories->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyersearch", function() {
    var options = { name: "x_tax_categories", selectId: "fpartner_quotation_buyersearch_x_tax_categories" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyersearch.lists.tax_categories?.lookupOptions.length) {
        options.data = { id: "x_tax_categories", form: "fpartner_quotation_buyersearch" };
    } else {
        options.ajax = { id: "x_tax_categories", form: "fpartner_quotation_buyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.tax_categories.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delivery_period->Visible) { // delivery_period ?>
    <div id="r_delivery_period" class="row"<?= $Page->delivery_period->rowAttributes() ?>>
        <label for="x_delivery_period" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_delivery_period"><?= $Page->delivery_period->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_delivery_period" id="z_delivery_period" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delivery_period->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_delivery_period" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->delivery_period->getInputTextType() ?>" name="x_delivery_period" id="x_delivery_period" data-table="partner_quotation_buyer" data-field="x_delivery_period" value="<?= $Page->delivery_period->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->delivery_period->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->delivery_period->formatPattern()) ?>"<?= $Page->delivery_period->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->delivery_period->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyersearch_x_status"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyersearch", function() {
    var options = { name: "x_status", selectId: "fpartner_quotation_buyersearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyersearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpartner_quotation_buyersearch" };
    } else {
        options.ajax = { id: "x_status", form: "fpartner_quotation_buyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="partner_quotation_buyer" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="partner_quotation_buyer" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpartner_quotation_buyersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpartner_quotation_buyersearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pp_operator->Visible) { // pp_operator ?>
    <div id="r_pp_operator" class="row"<?= $Page->pp_operator->rowAttributes() ?>>
        <label for="x_pp_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_pp_operator"><?= $Page->pp_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pp_operator" id="z_pp_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pp_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_pp_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pp_operator->getInputTextType() ?>" name="x_pp_operator" id="x_pp_operator" data-table="partner_quotation_buyer" data-field="x_pp_operator" value="<?= $Page->pp_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pp_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pp_operator->formatPattern()) ?>"<?= $Page->pp_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pp_operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pp_datetime->Visible) { // pp_datetime ?>
    <div id="r_pp_datetime" class="row"<?= $Page->pp_datetime->rowAttributes() ?>>
        <label for="x_pp_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_pp_datetime"><?= $Page->pp_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pp_datetime" id="z_pp_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pp_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_quotation_buyer_pp_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pp_datetime->getInputTextType() ?>" name="x_pp_datetime" id="x_pp_datetime" data-table="partner_quotation_buyer" data-field="x_pp_datetime" value="<?= $Page->pp_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->pp_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pp_datetime->formatPattern()) ?>"<?= $Page->pp_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pp_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->pp_datetime->ReadOnly && !$Page->pp_datetime->Disabled && !isset($Page->pp_datetime->EditAttrs["readonly"]) && !isset($Page->pp_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpartner_quotation_buyersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpartner_quotation_buyersearch", "x_pp_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpartner_quotation_buyersearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpartner_quotation_buyersearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpartner_quotation_buyersearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("partner_quotation_buyer");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
