<?php

namespace PHPMaker2024\fibre;

// Page object
$PartnerQuotationBuyerEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fpartner_quotation_buyeredit" id="fpartner_quotation_buyeredit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { partner_quotation_buyer: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fpartner_quotation_buyeredit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpartner_quotation_buyeredit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null], fields.company_id.isInvalid],
            ["partner_id", [fields.partner_id.visible && fields.partner_id.required ? ew.Validators.required(fields.partner_id.caption) : null], fields.partner_id.isInvalid],
            ["partner_details", [fields.partner_details.visible && fields.partner_details.required ? ew.Validators.required(fields.partner_details.caption) : null], fields.partner_details.isInvalid],
            ["product_type", [fields.product_type.visible && fields.product_type.required ? ew.Validators.required(fields.product_type.caption) : null], fields.product_type.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["product_code", [fields.product_code.visible && fields.product_code.required ? ew.Validators.required(fields.product_code.caption) : null], fields.product_code.isInvalid],
            ["partner_code", [fields.partner_code.visible && fields.partner_code.required ? ew.Validators.required(fields.partner_code.caption) : null], fields.partner_code.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["unit", [fields.unit.visible && fields.unit.required ? ew.Validators.required(fields.unit.caption) : null], fields.unit.isInvalid],
            ["quantity_approx", [fields.quantity_approx.visible && fields.quantity_approx.required ? ew.Validators.required(fields.quantity_approx.caption) : null], fields.quantity_approx.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["price", [fields.price.visible && fields.price.required ? ew.Validators.required(fields.price.caption) : null, ew.Validators.float], fields.price.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["currency", [fields.currency.visible && fields.currency.required ? ew.Validators.required(fields.currency.caption) : null], fields.currency.isInvalid],
            ["total_amount", [fields.total_amount.visible && fields.total_amount.required ? ew.Validators.required(fields.total_amount.caption) : null, ew.Validators.float], fields.total_amount.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["payment_terms", [fields.payment_terms.visible && fields.payment_terms.required ? ew.Validators.required(fields.payment_terms.caption) : null], fields.payment_terms.isInvalid],
            ["tax_categories", [fields.tax_categories.visible && fields.tax_categories.required ? ew.Validators.required(fields.tax_categories.caption) : null], fields.tax_categories.isInvalid],
            ["delivery_period", [fields.delivery_period.visible && fields.delivery_period.required ? ew.Validators.required(fields.delivery_period.caption) : null, ew.Validators.integer], fields.delivery_period.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["pp_operator", [fields.pp_operator.visible && fields.pp_operator.required ? ew.Validators.required(fields.pp_operator.caption) : null], fields.pp_operator.isInvalid],
            ["pp_datetime", [fields.pp_datetime.visible && fields.pp_datetime.required ? ew.Validators.required(fields.pp_datetime.caption) : null], fields.pp_datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "product_code": <?= $Page->product_code->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "payment_terms": <?= $Page->payment_terms->toClientList($Page) ?>,
            "tax_categories": <?= $Page->tax_categories->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="partner_quotation_buyer">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="partner_quotation_buyer" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_company_id" for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->company_id->caption() ?><?= $Page->company_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->company_id->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_company_id">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyeredit_x_company_id"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <?= $Page->company_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage() ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyeredit", function() {
    var options = { name: "x_company_id", selectId: "fpartner_quotation_buyeredit_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyeredit.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fpartner_quotation_buyeredit" };
    } else {
        options.ajax = { id: "x_company_id", form: "fpartner_quotation_buyeredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
    <div id="r_partner_id"<?= $Page->partner_id->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_partner_id" for="x_partner_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->partner_id->caption() ?><?= $Page->partner_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->partner_id->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_partner_id">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-select ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        <?php if (!$Page->partner_id->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyeredit_x_partner_id"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_partner_id"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <?= $Page->partner_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage() ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<?php if (!$Page->partner_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyeredit", function() {
    var options = { name: "x_partner_id", selectId: "fpartner_quotation_buyeredit_x_partner_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyeredit.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fpartner_quotation_buyeredit" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fpartner_quotation_buyeredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.partner_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->partner_details->Visible) { // partner_details ?>
    <div id="r_partner_details"<?= $Page->partner_details->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_partner_details" for="x_partner_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->partner_details->caption() ?><?= $Page->partner_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->partner_details->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_partner_details">
<textarea data-table="partner_quotation_buyer" data-field="x_partner_details" name="x_partner_details" id="x_partner_details" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->partner_details->getPlaceHolder()) ?>"<?= $Page->partner_details->editAttributes() ?> aria-describedby="x_partner_details_help"><?= $Page->partner_details->EditValue ?></textarea>
<?= $Page->partner_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->partner_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type"<?= $Page->product_type->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_product_type" for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_type->caption() ?><?= $Page->product_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_type->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_product_type">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyeredit_x_product_type"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_product_type"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <?= $Page->product_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage() ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyeredit", function() {
    var options = { name: "x_product_type", selectId: "fpartner_quotation_buyeredit_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyeredit.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "fpartner_quotation_buyeredit" };
    } else {
        options.ajax = { id: "x_product_type", form: "fpartner_quotation_buyeredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_product">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyeredit_x_product"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <?= $Page->product->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyeredit", function() {
    var options = { name: "x_product", selectId: "fpartner_quotation_buyeredit_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyeredit.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fpartner_quotation_buyeredit" };
    } else {
        options.ajax = { id: "x_product", form: "fpartner_quotation_buyeredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code"<?= $Page->product_code->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_product_code" for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_code->caption() ?><?= $Page->product_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_code->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_product_code">
    <select
        id="x_product_code"
        name="x_product_code"
        class="form-select ew-select<?= $Page->product_code->isInvalidClass() ?>"
        <?php if (!$Page->product_code->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyeredit_x_product_code"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_product_code"
        data-value-separator="<?= $Page->product_code->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>"
        <?= $Page->product_code->editAttributes() ?>>
        <?= $Page->product_code->selectOptionListHtml("x_product_code") ?>
    </select>
    <?= $Page->product_code->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->product_code->getErrorMessage() ?></div>
<?= $Page->product_code->Lookup->getParamTag($Page, "p_x_product_code") ?>
<?php if (!$Page->product_code->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyeredit", function() {
    var options = { name: "x_product_code", selectId: "fpartner_quotation_buyeredit_x_product_code" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyeredit.lists.product_code?.lookupOptions.length) {
        options.data = { id: "x_product_code", form: "fpartner_quotation_buyeredit" };
    } else {
        options.ajax = { id: "x_product_code", form: "fpartner_quotation_buyeredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.product_code.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->partner_code->Visible) { // partner_code ?>
    <div id="r_partner_code"<?= $Page->partner_code->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_partner_code" for="x_partner_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->partner_code->caption() ?><?= $Page->partner_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->partner_code->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_partner_code">
<textarea data-table="partner_quotation_buyer" data-field="x_partner_code" name="x_partner_code" id="x_partner_code" cols="35" rows="3" placeholder="<?= HtmlEncode($Page->partner_code->getPlaceHolder()) ?>"<?= $Page->partner_code->editAttributes() ?> aria-describedby="x_partner_code_help"><?= $Page->partner_code->EditValue ?></textarea>
<?= $Page->partner_code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->partner_code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type"<?= $Page->packing_type->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_packing_type" for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packing_type->caption() ?><?= $Page->packing_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packing_type->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_packing_type">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyeredit_x_packing_type"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <?= $Page->packing_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage() ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyeredit", function() {
    var options = { name: "x_packing_type", selectId: "fpartner_quotation_buyeredit_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyeredit.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpartner_quotation_buyeredit" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpartner_quotation_buyeredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit"<?= $Page->unit->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_unit" for="x_unit" class="<?= $Page->LeftColumnClass ?>"><?= $Page->unit->caption() ?><?= $Page->unit->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->unit->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_unit">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyeredit_x_unit"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <?= $Page->unit->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage() ?></div>
<?= $Page->unit->Lookup->getParamTag($Page, "p_x_unit") ?>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyeredit", function() {
    var options = { name: "x_unit", selectId: "fpartner_quotation_buyeredit_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyeredit.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "fpartner_quotation_buyeredit" };
    } else {
        options.ajax = { id: "x_unit", form: "fpartner_quotation_buyeredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity_approx->Visible) { // quantity_approx ?>
    <div id="r_quantity_approx"<?= $Page->quantity_approx->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_quantity_approx" for="x_quantity_approx" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity_approx->caption() ?><?= $Page->quantity_approx->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity_approx->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_quantity_approx">
<input type="<?= $Page->quantity_approx->getInputTextType() ?>" name="x_quantity_approx" id="x_quantity_approx" data-table="partner_quotation_buyer" data-field="x_quantity_approx" value="<?= $Page->quantity_approx->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->quantity_approx->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity_approx->formatPattern()) ?>"<?= $Page->quantity_approx->editAttributes() ?> aria-describedby="x_quantity_approx_help">
<?= $Page->quantity_approx->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity_approx->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="partner_quotation_buyer" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price"<?= $Page->price->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_price" for="x_price" class="<?= $Page->LeftColumnClass ?>"><?= $Page->price->caption() ?><?= $Page->price->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->price->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_price">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="partner_quotation_buyer" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?> aria-describedby="x_price_help">
<?= $Page->price->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_amount">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="partner_quotation_buyer" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?> aria-describedby="x_amount_help">
<?= $Page->amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency"<?= $Page->currency->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_currency" for="x_currency" class="<?= $Page->LeftColumnClass ?>"><?= $Page->currency->caption() ?><?= $Page->currency->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->currency->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_currency">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyeredit_x_currency"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <?= $Page->currency->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage() ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyeredit", function() {
    var options = { name: "x_currency", selectId: "fpartner_quotation_buyeredit_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyeredit.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fpartner_quotation_buyeredit" };
    } else {
        options.ajax = { id: "x_currency", form: "fpartner_quotation_buyeredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->total_amount->Visible) { // total_amount ?>
    <div id="r_total_amount"<?= $Page->total_amount->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_total_amount" for="x_total_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->total_amount->caption() ?><?= $Page->total_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->total_amount->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_total_amount">
<input type="<?= $Page->total_amount->getInputTextType() ?>" name="x_total_amount" id="x_total_amount" data-table="partner_quotation_buyer" data-field="x_total_amount" value="<?= $Page->total_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->total_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->total_amount->formatPattern()) ?>"<?= $Page->total_amount->editAttributes() ?> aria-describedby="x_total_amount_help">
<?= $Page->total_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->total_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="partner_quotation_buyer" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->payment_terms->Visible) { // payment_terms ?>
    <div id="r_payment_terms"<?= $Page->payment_terms->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_payment_terms" for="x_payment_terms" class="<?= $Page->LeftColumnClass ?>"><?= $Page->payment_terms->caption() ?><?= $Page->payment_terms->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->payment_terms->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_payment_terms">
    <select
        id="x_payment_terms"
        name="x_payment_terms"
        class="form-select ew-select<?= $Page->payment_terms->isInvalidClass() ?>"
        <?php if (!$Page->payment_terms->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyeredit_x_payment_terms"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_payment_terms"
        data-value-separator="<?= $Page->payment_terms->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment_terms->getPlaceHolder()) ?>"
        <?= $Page->payment_terms->editAttributes() ?>>
        <?= $Page->payment_terms->selectOptionListHtml("x_payment_terms") ?>
    </select>
    <?= $Page->payment_terms->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->payment_terms->getErrorMessage() ?></div>
<?= $Page->payment_terms->Lookup->getParamTag($Page, "p_x_payment_terms") ?>
<?php if (!$Page->payment_terms->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyeredit", function() {
    var options = { name: "x_payment_terms", selectId: "fpartner_quotation_buyeredit_x_payment_terms" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyeredit.lists.payment_terms?.lookupOptions.length) {
        options.data = { id: "x_payment_terms", form: "fpartner_quotation_buyeredit" };
    } else {
        options.ajax = { id: "x_payment_terms", form: "fpartner_quotation_buyeredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.payment_terms.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->tax_categories->Visible) { // tax_categories ?>
    <div id="r_tax_categories"<?= $Page->tax_categories->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_tax_categories" for="x_tax_categories" class="<?= $Page->LeftColumnClass ?>"><?= $Page->tax_categories->caption() ?><?= $Page->tax_categories->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->tax_categories->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_tax_categories">
    <select
        id="x_tax_categories"
        name="x_tax_categories"
        class="form-select ew-select<?= $Page->tax_categories->isInvalidClass() ?>"
        <?php if (!$Page->tax_categories->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyeredit_x_tax_categories"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_tax_categories"
        data-value-separator="<?= $Page->tax_categories->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->tax_categories->getPlaceHolder()) ?>"
        <?= $Page->tax_categories->editAttributes() ?>>
        <?= $Page->tax_categories->selectOptionListHtml("x_tax_categories") ?>
    </select>
    <?= $Page->tax_categories->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->tax_categories->getErrorMessage() ?></div>
<?= $Page->tax_categories->Lookup->getParamTag($Page, "p_x_tax_categories") ?>
<?php if (!$Page->tax_categories->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyeredit", function() {
    var options = { name: "x_tax_categories", selectId: "fpartner_quotation_buyeredit_x_tax_categories" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyeredit.lists.tax_categories?.lookupOptions.length) {
        options.data = { id: "x_tax_categories", form: "fpartner_quotation_buyeredit" };
    } else {
        options.ajax = { id: "x_tax_categories", form: "fpartner_quotation_buyeredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.tax_categories.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->delivery_period->Visible) { // delivery_period ?>
    <div id="r_delivery_period"<?= $Page->delivery_period->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_delivery_period" for="x_delivery_period" class="<?= $Page->LeftColumnClass ?>"><?= $Page->delivery_period->caption() ?><?= $Page->delivery_period->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->delivery_period->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_delivery_period">
<input type="<?= $Page->delivery_period->getInputTextType() ?>" name="x_delivery_period" id="x_delivery_period" data-table="partner_quotation_buyer" data-field="x_delivery_period" value="<?= $Page->delivery_period->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->delivery_period->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->delivery_period->formatPattern()) ?>"<?= $Page->delivery_period->editAttributes() ?> aria-describedby="x_delivery_period_help">
<?= $Page->delivery_period->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->delivery_period->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_partner_quotation_buyer_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpartner_quotation_buyeredit_x_status"
        <?php } ?>
        data-table="partner_quotation_buyer"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_quotation_buyeredit", function() {
    var options = { name: "x_status", selectId: "fpartner_quotation_buyeredit_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_quotation_buyeredit.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpartner_quotation_buyeredit" };
    } else {
        options.ajax = { id: "x_status", form: "fpartner_quotation_buyeredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_quotation_buyer.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpartner_quotation_buyeredit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpartner_quotation_buyeredit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("partner_quotation_buyer");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
