<?php

namespace PHPMaker2024\fibre;

// Page object
$PartnerProductRefSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { partner_product_ref: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpartner_product_refsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpartner_product_refsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["partner_type", [], fields.partner_type.isInvalid],
            ["partner", [], fields.partner.isInvalid],
            ["partner_ref", [], fields.partner_ref.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["partner_code", [], fields.partner_code.isInvalid],
            ["product_type", [], fields.product_type.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["spl_ins", [], fields.spl_ins.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["batch_no", [ew.Validators.integer], fields.batch_no.isInvalid],
            ["shape", [], fields.shape.isInvalid],
            ["unit", [], fields.unit.isInvalid],
            ["w", [], fields.w.isInvalid],
            ["w_cm", [ew.Validators.float], fields.w_cm.isInvalid],
            ["l", [], fields.l.isInvalid],
            ["l_cm", [ew.Validators.float], fields.l_cm.isInvalid],
            ["h", [], fields.h.isInvalid],
            ["h_cm", [ew.Validators.float], fields.h_cm.isInvalid],
            ["partner_size", [], fields.partner_size.isInvalid],
            ["sqm", [], fields.sqm.isInvalid],
            ["cbm", [ew.Validators.float], fields.cbm.isInvalid],
            ["weight_sqm", [ew.Validators.float], fields.weight_sqm.isInvalid],
            ["sqm_a", [ew.Validators.float], fields.sqm_a.isInvalid],
            ["_2srm_a", [ew.Validators.float], fields._2srm_a.isInvalid],
            ["_4srm_a", [ew.Validators.float], fields._4srm_a.isInvalid],
            ["price", [ew.Validators.float], fields.price.isInvalid],
            ["price_cs", [ew.Validators.float], fields.price_cs.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["hsn", [], fields.hsn.isInvalid],
            ["composition", [], fields.composition.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["d_01", [], fields.d_01.isInvalid],
            ["d_02", [], fields.d_02.isInvalid],
            ["d_03", [], fields.d_03.isInvalid],
            ["d_04", [], fields.d_04.isInvalid],
            ["d_05", [], fields.d_05.isInvalid],
            ["d_06", [], fields.d_06.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "partner_type": <?= $Page->partner_type->toClientList($Page) ?>,
            "partner": <?= $Page->partner->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "shape": <?= $Page->shape->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "hsn": <?= $Page->hsn->toClientList($Page) ?>,
            "composition": <?= $Page->composition->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpartner_product_refsearch" id="fpartner_product_refsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="partner_product_ref">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="partner_product_ref" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_type->Visible) { // partner_type ?>
    <div id="r_partner_type" class="row"<?= $Page->partner_type->rowAttributes() ?>>
        <label for="x_partner_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_partner_type"><?= $Page->partner_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner_type" id="z_partner_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_partner_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner_type"
        name="x_partner_type"
        class="form-select ew-select<?= $Page->partner_type->isInvalidClass() ?>"
        <?php if (!$Page->partner_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsearch_x_partner_type"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_partner_type"
        data-value-separator="<?= $Page->partner_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->partner_type->editAttributes() ?>>
        <?= $Page->partner_type->selectOptionListHtml("x_partner_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_type->getErrorMessage(false) ?></div>
<?= $Page->partner_type->Lookup->getParamTag($Page, "p_x_partner_type") ?>
<?php if (!$Page->partner_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_partner_type", selectId: "fpartner_product_refsearch_x_partner_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsearch.lists.partner_type?.lookupOptions.length) {
        options.data = { id: "x_partner_type", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_partner_type", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.partner_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner->Visible) { // partner ?>
    <div id="r_partner" class="row"<?= $Page->partner->rowAttributes() ?>>
        <label for="x_partner" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_partner"><?= $Page->partner->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner" id="z_partner" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_partner" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner"
        name="x_partner"
        class="form-control ew-select<?= $Page->partner->isInvalidClass() ?>"
        data-select2-id="fpartner_product_refsearch_x_partner"
        data-table="partner_product_ref"
        data-field="x_partner"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner->getPlaceHolder()) ?>"
        <?= $Page->partner->editAttributes() ?>>
        <?= $Page->partner->selectOptionListHtml("x_partner") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner->getErrorMessage(false) ?></div>
<?= $Page->partner->Lookup->getParamTag($Page, "p_x_partner") ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_partner", selectId: "fpartner_product_refsearch_x_partner" };
    if (fpartner_product_refsearch.lists.partner?.lookupOptions.length) {
        options.data = { id: "x_partner", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_partner", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.partner_product_ref.fields.partner.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_ref->Visible) { // partner_ref ?>
    <div id="r_partner_ref" class="row"<?= $Page->partner_ref->rowAttributes() ?>>
        <label for="x_partner_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_partner_ref"><?= $Page->partner_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_ref" id="z_partner_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_partner_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_ref->getInputTextType() ?>" name="x_partner_ref" id="x_partner_ref" data-table="partner_product_ref" data-field="x_partner_ref" value="<?= $Page->partner_ref->EditValue ?>" size="30" maxlength="144" placeholder="<?= HtmlEncode($Page->partner_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_ref->formatPattern()) ?>"<?= $Page->partner_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref__barcode"><?= $Page->_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__barcode" id="z__barcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref__barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="partner_product_ref" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_code->Visible) { // partner_code ?>
    <div id="r_partner_code" class="row"<?= $Page->partner_code->rowAttributes() ?>>
        <label for="x_partner_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_partner_code"><?= $Page->partner_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_code" id="z_partner_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_partner_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_code->getInputTextType() ?>" name="x_partner_code" id="x_partner_code" data-table="partner_product_ref" data-field="x_partner_code" value="<?= $Page->partner_code->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->partner_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_code->formatPattern()) ?>"<?= $Page->partner_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type" class="row"<?= $Page->product_type->rowAttributes() ?>>
        <label for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_product_type"><?= $Page->product_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_type" id="z_product_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_product_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsearch_x_product_type"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_product_type"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_product_type", selectId: "fpartner_product_refsearch_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsearch.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_product_type", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsearch_x_grp"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_grp", selectId: "fpartner_product_refsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsearch_x_s_grp"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_s_grp", selectId: "fpartner_product_refsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsearch_x_product"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_product", selectId: "fpartner_product_refsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->spl_ins->Visible) { // spl_ins ?>
    <div id="r_spl_ins" class="row"<?= $Page->spl_ins->rowAttributes() ?>>
        <label for="x_spl_ins" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_spl_ins"><?= $Page->spl_ins->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_spl_ins" id="z_spl_ins" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->spl_ins->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_spl_ins" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->spl_ins->getInputTextType() ?>" name="x_spl_ins" id="x_spl_ins" data-table="partner_product_ref" data-field="x_spl_ins" value="<?= $Page->spl_ins->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->spl_ins->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->spl_ins->formatPattern()) ?>"<?= $Page->spl_ins->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->spl_ins->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsearch_x_packing_type"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_packing_type", selectId: "fpartner_product_refsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_batch_no" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->batch_no->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_batch_no" class="ew-auto-suggest">
    <input type="<?= $Page->batch_no->getInputTextType() ?>" class="form-control" name="sv_x_batch_no" id="sv_x_batch_no" value="<?= RemoveHtml($Page->batch_no->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="partner_product_ref" data-field="x_batch_no" data-input="sv_x_batch_no" data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>" name="x_batch_no" id="x_batch_no" value="<?= HtmlEncode($Page->batch_no->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    fpartner_product_refsearch.createAutoSuggest(Object.assign({"id":"x_batch_no","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->batch_no->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.partner_product_ref.fields.batch_no.autoSuggestOptions));
});
</script>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
    <div id="r_shape" class="row"<?= $Page->shape->rowAttributes() ?>>
        <label for="x_shape" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_shape"><?= $Page->shape->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_shape" id="z_shape" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shape->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_shape" class="ew-search-field ew-search-field-single">
    <select
        id="x_shape"
        name="x_shape"
        class="form-select ew-select<?= $Page->shape->isInvalidClass() ?>"
        <?php if (!$Page->shape->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsearch_x_shape"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_shape"
        data-value-separator="<?= $Page->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shape->getPlaceHolder()) ?>"
        <?= $Page->shape->editAttributes() ?>>
        <?= $Page->shape->selectOptionListHtml("x_shape") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->shape->getErrorMessage(false) ?></div>
<?= $Page->shape->Lookup->getParamTag($Page, "p_x_shape") ?>
<?php if (!$Page->shape->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_shape", selectId: "fpartner_product_refsearch_x_shape" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsearch.lists.shape?.lookupOptions.length) {
        options.data = { id: "x_shape", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_shape", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.shape.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit" class="row"<?= $Page->unit->rowAttributes() ?>>
        <label for="x_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_unit"><?= $Page->unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unit" id="z_unit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_unit" class="ew-search-field ew-search-field-single">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsearch_x_unit"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage(false) ?></div>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_unit", selectId: "fpartner_product_refsearch_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsearch.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_unit", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->w->Visible) { // w ?>
    <div id="r_w" class="row"<?= $Page->w->rowAttributes() ?>>
        <label for="x_w" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_w"><?= $Page->w->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_w" id="z_w" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->w->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_w" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->w->getInputTextType() ?>" name="x_w" id="x_w" data-table="partner_product_ref" data-field="x_w" value="<?= $Page->w->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->w->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w->formatPattern()) ?>"<?= $Page->w->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->w->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->w_cm->Visible) { // w_cm ?>
    <div id="r_w_cm" class="row"<?= $Page->w_cm->rowAttributes() ?>>
        <label for="x_w_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_w_cm"><?= $Page->w_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_w_cm" id="z_w_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->w_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_w_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->w_cm->getInputTextType() ?>" name="x_w_cm" id="x_w_cm" data-table="partner_product_ref" data-field="x_w_cm" value="<?= $Page->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w_cm->formatPattern()) ?>"<?= $Page->w_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->w_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->l->Visible) { // l ?>
    <div id="r_l" class="row"<?= $Page->l->rowAttributes() ?>>
        <label for="x_l" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_l"><?= $Page->l->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_l" id="z_l" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->l->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_l" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->l->getInputTextType() ?>" name="x_l" id="x_l" data-table="partner_product_ref" data-field="x_l" value="<?= $Page->l->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->l->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l->formatPattern()) ?>"<?= $Page->l->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->l->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->l_cm->Visible) { // l_cm ?>
    <div id="r_l_cm" class="row"<?= $Page->l_cm->rowAttributes() ?>>
        <label for="x_l_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_l_cm"><?= $Page->l_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_l_cm" id="z_l_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->l_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_l_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->l_cm->getInputTextType() ?>" name="x_l_cm" id="x_l_cm" data-table="partner_product_ref" data-field="x_l_cm" value="<?= $Page->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l_cm->formatPattern()) ?>"<?= $Page->l_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->l_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->h->Visible) { // h ?>
    <div id="r_h" class="row"<?= $Page->h->rowAttributes() ?>>
        <label for="x_h" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_h"><?= $Page->h->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_h" id="z_h" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->h->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_h" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->h->getInputTextType() ?>" name="x_h" id="x_h" data-table="partner_product_ref" data-field="x_h" value="<?= $Page->h->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->h->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->h->formatPattern()) ?>"<?= $Page->h->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->h->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->h_cm->Visible) { // h_cm ?>
    <div id="r_h_cm" class="row"<?= $Page->h_cm->rowAttributes() ?>>
        <label for="x_h_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_h_cm"><?= $Page->h_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_h_cm" id="z_h_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->h_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_h_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->h_cm->getInputTextType() ?>" name="x_h_cm" id="x_h_cm" data-table="partner_product_ref" data-field="x_h_cm" value="<?= $Page->h_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->h_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->h_cm->formatPattern()) ?>"<?= $Page->h_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->h_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_size->Visible) { // partner_size ?>
    <div id="r_partner_size" class="row"<?= $Page->partner_size->rowAttributes() ?>>
        <label for="x_partner_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_partner_size"><?= $Page->partner_size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_size" id="z_partner_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_partner_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_size->getInputTextType() ?>" name="x_partner_size" id="x_partner_size" data-table="partner_product_ref" data-field="x_partner_size" value="<?= $Page->partner_size->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_size->formatPattern()) ?>"<?= $Page->partner_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="partner_product_ref" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
    <div id="r_cbm" class="row"<?= $Page->cbm->rowAttributes() ?>>
        <label for="x_cbm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_cbm"><?= $Page->cbm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cbm" id="z_cbm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cbm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_cbm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cbm->getInputTextType() ?>" name="x_cbm" id="x_cbm" data-table="partner_product_ref" data-field="x_cbm" value="<?= $Page->cbm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cbm->formatPattern()) ?>"<?= $Page->cbm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cbm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->weight_sqm->Visible) { // weight_sqm ?>
    <div id="r_weight_sqm" class="row"<?= $Page->weight_sqm->rowAttributes() ?>>
        <label for="x_weight_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_weight_sqm"><?= $Page->weight_sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_weight_sqm" id="z_weight_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weight_sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_weight_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->weight_sqm->getInputTextType() ?>" name="x_weight_sqm" id="x_weight_sqm" data-table="partner_product_ref" data-field="x_weight_sqm" value="<?= $Page->weight_sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->weight_sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->weight_sqm->formatPattern()) ?>"<?= $Page->weight_sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->weight_sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm_a->Visible) { // sqm_a ?>
    <div id="r_sqm_a" class="row"<?= $Page->sqm_a->rowAttributes() ?>>
        <label for="x_sqm_a" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_sqm_a"><?= $Page->sqm_a->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm_a" id="z_sqm_a" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm_a->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_sqm_a" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm_a->getInputTextType() ?>" name="x_sqm_a" id="x_sqm_a" data-table="partner_product_ref" data-field="x_sqm_a" value="<?= $Page->sqm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm_a->formatPattern()) ?>"<?= $Page->sqm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm_a->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_2srm_a->Visible) { // 2srm_a ?>
    <div id="r__2srm_a" class="row"<?= $Page->_2srm_a->rowAttributes() ?>>
        <label for="x__2srm_a" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref__2srm_a"><?= $Page->_2srm_a->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__2srm_a" id="z__2srm_a" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_2srm_a->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref__2srm_a" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_2srm_a->getInputTextType() ?>" name="x__2srm_a" id="x__2srm_a" data-table="partner_product_ref" data-field="x__2srm_a" value="<?= $Page->_2srm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_2srm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_2srm_a->formatPattern()) ?>"<?= $Page->_2srm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_2srm_a->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_4srm_a->Visible) { // 4srm_a ?>
    <div id="r__4srm_a" class="row"<?= $Page->_4srm_a->rowAttributes() ?>>
        <label for="x__4srm_a" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref__4srm_a"><?= $Page->_4srm_a->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__4srm_a" id="z__4srm_a" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_4srm_a->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref__4srm_a" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_4srm_a->getInputTextType() ?>" name="x__4srm_a" id="x__4srm_a" data-table="partner_product_ref" data-field="x__4srm_a" value="<?= $Page->_4srm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_4srm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_4srm_a->formatPattern()) ?>"<?= $Page->_4srm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_4srm_a->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price" class="row"<?= $Page->price->rowAttributes() ?>>
        <label for="x_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_price"><?= $Page->price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price" id="z_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="partner_product_ref" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price_cs->Visible) { // price_cs ?>
    <div id="r_price_cs" class="row"<?= $Page->price_cs->rowAttributes() ?>>
        <label for="x_price_cs" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_price_cs"><?= $Page->price_cs->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price_cs" id="z_price_cs" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price_cs->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_price_cs" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price_cs->getInputTextType() ?>" name="x_price_cs" id="x_price_cs" data-table="partner_product_ref" data-field="x_price_cs" value="<?= $Page->price_cs->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price_cs->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price_cs->formatPattern()) ?>"<?= $Page->price_cs->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price_cs->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label for="x_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency" id="z_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsearch_x_currency"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_currency", selectId: "fpartner_product_refsearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_currency", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->hsn->Visible) { // hsn ?>
    <div id="r_hsn" class="row"<?= $Page->hsn->rowAttributes() ?>>
        <label for="x_hsn" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_hsn"><?= $Page->hsn->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_hsn" id="z_hsn" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->hsn->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_hsn" class="ew-search-field ew-search-field-single">
    <select
        id="x_hsn"
        name="x_hsn"
        class="form-select ew-select<?= $Page->hsn->isInvalidClass() ?>"
        <?php if (!$Page->hsn->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsearch_x_hsn"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_hsn"
        data-value-separator="<?= $Page->hsn->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->hsn->getPlaceHolder()) ?>"
        <?= $Page->hsn->editAttributes() ?>>
        <?= $Page->hsn->selectOptionListHtml("x_hsn") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->hsn->getErrorMessage(false) ?></div>
<?= $Page->hsn->Lookup->getParamTag($Page, "p_x_hsn") ?>
<?php if (!$Page->hsn->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_hsn", selectId: "fpartner_product_refsearch_x_hsn" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsearch.lists.hsn?.lookupOptions.length) {
        options.data = { id: "x_hsn", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_hsn", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.hsn.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->composition->Visible) { // composition ?>
    <div id="r_composition" class="row"<?= $Page->composition->rowAttributes() ?>>
        <label for="x_composition" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_composition"><?= $Page->composition->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_composition" id="z_composition" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->composition->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_composition" class="ew-search-field ew-search-field-single">
    <select
        id="x_composition"
        name="x_composition"
        class="form-select ew-select<?= $Page->composition->isInvalidClass() ?>"
        <?php if (!$Page->composition->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsearch_x_composition"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_composition"
        data-value-separator="<?= $Page->composition->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->composition->getPlaceHolder()) ?>"
        <?= $Page->composition->editAttributes() ?>>
        <?= $Page->composition->selectOptionListHtml("x_composition") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->composition->getErrorMessage(false) ?></div>
<?= $Page->composition->Lookup->getParamTag($Page, "p_x_composition") ?>
<?php if (!$Page->composition->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_composition", selectId: "fpartner_product_refsearch_x_composition" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsearch.lists.composition?.lookupOptions.length) {
        options.data = { id: "x_composition", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_composition", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.composition.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsearch_x_status"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_status", selectId: "fpartner_product_refsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsearch_x_operator"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsearch", function() {
    var options = { name: "x_operator", selectId: "fpartner_product_refsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fpartner_product_refsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fpartner_product_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="partner_product_ref" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpartner_product_refsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpartner_product_refsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_01->Visible) { // d_01 ?>
    <div id="r_d_01" class="row"<?= $Page->d_01->rowAttributes() ?>>
        <label for="x_d_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_d_01"><?= $Page->d_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_01" id="z_d_01" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_d_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_01->getInputTextType() ?>" name="x_d_01" id="x_d_01" data-table="partner_product_ref" data-field="x_d_01" value="<?= $Page->d_01->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->d_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_01->formatPattern()) ?>"<?= $Page->d_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_02->Visible) { // d_02 ?>
    <div id="r_d_02" class="row"<?= $Page->d_02->rowAttributes() ?>>
        <label for="x_d_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_d_02"><?= $Page->d_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_02" id="z_d_02" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_d_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_02->getInputTextType() ?>" name="x_d_02" id="x_d_02" data-table="partner_product_ref" data-field="x_d_02" value="<?= $Page->d_02->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->d_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_02->formatPattern()) ?>"<?= $Page->d_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_03->Visible) { // d_03 ?>
    <div id="r_d_03" class="row"<?= $Page->d_03->rowAttributes() ?>>
        <label for="x_d_03" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_d_03"><?= $Page->d_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_03" id="z_d_03" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_d_03" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_03->getInputTextType() ?>" name="x_d_03" id="x_d_03" data-table="partner_product_ref" data-field="x_d_03" value="<?= $Page->d_03->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->d_03->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_03->formatPattern()) ?>"<?= $Page->d_03->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_03->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_04->Visible) { // d_04 ?>
    <div id="r_d_04" class="row"<?= $Page->d_04->rowAttributes() ?>>
        <label for="x_d_04" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_d_04"><?= $Page->d_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_04" id="z_d_04" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_d_04" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_04->getInputTextType() ?>" name="x_d_04" id="x_d_04" data-table="partner_product_ref" data-field="x_d_04" value="<?= $Page->d_04->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->d_04->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_04->formatPattern()) ?>"<?= $Page->d_04->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_04->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_05->Visible) { // d_05 ?>
    <div id="r_d_05" class="row"<?= $Page->d_05->rowAttributes() ?>>
        <label for="x_d_05" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_d_05"><?= $Page->d_05->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_05" id="z_d_05" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_05->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_d_05" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_05->getInputTextType() ?>" name="x_d_05" id="x_d_05" data-table="partner_product_ref" data-field="x_d_05" value="<?= $Page->d_05->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->d_05->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_05->formatPattern()) ?>"<?= $Page->d_05->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_05->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_06->Visible) { // d_06 ?>
    <div id="r_d_06" class="row"<?= $Page->d_06->rowAttributes() ?>>
        <label for="x_d_06" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_product_ref_d_06"><?= $Page->d_06->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_06" id="z_d_06" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_06->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_product_ref_d_06" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_06->getInputTextType() ?>" name="x_d_06" id="x_d_06" data-table="partner_product_ref" data-field="x_d_06" value="<?= $Page->d_06->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->d_06->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_06->formatPattern()) ?>"<?= $Page->d_06->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_06->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpartner_product_refsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpartner_product_refsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpartner_product_refsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("partner_product_ref");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
