<?php

namespace PHPMaker2024\fibre;

// Page object
$PartnerProductRefList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { partner_product_ref: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "ref") {
    if ($Page->MasterRecordExists) {
        include_once "views/RefMaster.php";
    }
}
?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "ref_code") {
    if ($Page->MasterRecordExists) {
        include_once "views/RefCodeMaster.php";
    }
}
?>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fpartner_product_refsrch" id="fpartner_product_refsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fpartner_product_refsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { partner_product_ref: currentTable } });
var currentForm;
var fpartner_product_refsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpartner_product_refsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["partner_type", [], fields.partner_type.isInvalid],
            ["partner", [], fields.partner.isInvalid],
            ["price", [ew.Validators.float], fields.price.isInvalid],
            ["status", [], fields.status.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "partner_type": <?= $Page->partner_type->toClientList($Page) ?>,
            "partner": <?= $Page->partner->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->partner_type->Visible) { // partner_type ?>
<?php
if (!$Page->partner_type->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_partner_type" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->partner_type->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_partner_type" class="ew-search-caption ew-label"><?= $Page->partner_type->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner_type" id="z_partner_type" value="=">
</div>
        </div>
        <div id="el_partner_product_ref_partner_type" class="ew-search-field">
    <select
        id="x_partner_type"
        name="x_partner_type"
        class="form-select ew-select<?= $Page->partner_type->isInvalidClass() ?>"
        <?php if (!$Page->partner_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsrch_x_partner_type"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_partner_type"
        data-value-separator="<?= $Page->partner_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->partner_type->editAttributes() ?>>
        <?= $Page->partner_type->selectOptionListHtml("x_partner_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_type->getErrorMessage(false) ?></div>
<?= $Page->partner_type->Lookup->getParamTag($Page, "p_x_partner_type") ?>
<?php if (!$Page->partner_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsrch", function() {
    var options = { name: "x_partner_type", selectId: "fpartner_product_refsrch_x_partner_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsrch.lists.partner_type?.lookupOptions.length) {
        options.data = { id: "x_partner_type", form: "fpartner_product_refsrch" };
    } else {
        options.ajax = { id: "x_partner_type", form: "fpartner_product_refsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.partner_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->partner->Visible) { // partner ?>
<?php
if (!$Page->partner->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_partner" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->partner->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_partner" class="ew-search-caption ew-label"><?= $Page->partner->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner" id="z_partner" value="=">
</div>
        </div>
        <div id="el_partner_product_ref_partner" class="ew-search-field">
    <select
        id="x_partner"
        name="x_partner"
        class="form-control ew-select<?= $Page->partner->isInvalidClass() ?>"
        data-select2-id="fpartner_product_refsrch_x_partner"
        data-table="partner_product_ref"
        data-field="x_partner"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner->getPlaceHolder()) ?>"
        <?= $Page->partner->editAttributes() ?>>
        <?= $Page->partner->selectOptionListHtml("x_partner") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner->getErrorMessage(false) ?></div>
<?= $Page->partner->Lookup->getParamTag($Page, "p_x_partner") ?>
<script>
loadjs.ready("fpartner_product_refsrch", function() {
    var options = { name: "x_partner", selectId: "fpartner_product_refsrch_x_partner" };
    if (fpartner_product_refsrch.lists.partner?.lookupOptions.length) {
        options.data = { id: "x_partner", form: "fpartner_product_refsrch" };
    } else {
        options.ajax = { id: "x_partner", form: "fpartner_product_refsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.partner_product_ref.fields.partner.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
<?php
if (!$Page->price->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_price" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->price->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_price" class="ew-search-caption ew-label"><?= $Page->price->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price" id="z_price" value="=">
</div>
        </div>
        <div id="el_partner_product_ref_price" class="ew-search-field">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="partner_product_ref" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
<?php
if (!$Page->status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->status->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_status" class="ew-search-caption ew-label"><?= $Page->status->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</div>
        </div>
        <div id="el_partner_product_ref_status" class="ew-search-field">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refsrch_x_status"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refsrch", function() {
    var options = { name: "x_status", selectId: "fpartner_product_refsrch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refsrch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpartner_product_refsrch" };
    } else {
        options.ajax = { id: "x_status", form: "fpartner_product_refsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fpartner_product_refsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fpartner_product_refsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fpartner_product_refsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fpartner_product_refsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fpartner_product_refsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fpartner_product_refsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fpartner_product_refsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="partner_product_ref">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "ref" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="ref">
<input type="hidden" name="fk_id" value="<?= HtmlEncode($Page->rid->getSessionValue()) ?>">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "ref_code" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="ref_code">
<input type="hidden" name="fk_id" value="<?= HtmlEncode($Page->rid->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_partner_product_ref" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_partner_product_reflist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_partner_product_ref_id" class="partner_product_ref_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->partner_type->Visible) { // partner_type ?>
        <th data-name="partner_type" class="<?= $Page->partner_type->headerCellClass() ?>"><div id="elh_partner_product_ref_partner_type" class="partner_product_ref_partner_type"><?= $Page->renderFieldHeader($Page->partner_type) ?></div></th>
<?php } ?>
<?php if ($Page->partner->Visible) { // partner ?>
        <th data-name="partner" class="<?= $Page->partner->headerCellClass() ?>"><div id="elh_partner_product_ref_partner" class="partner_product_ref_partner"><?= $Page->renderFieldHeader($Page->partner) ?></div></th>
<?php } ?>
<?php if ($Page->partner_ref->Visible) { // partner_ref ?>
        <th data-name="partner_ref" class="<?= $Page->partner_ref->headerCellClass() ?>"><div id="elh_partner_product_ref_partner_ref" class="partner_product_ref_partner_ref"><?= $Page->renderFieldHeader($Page->partner_ref) ?></div></th>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>"><div id="elh_partner_product_ref__barcode" class="partner_product_ref__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->partner_code->Visible) { // partner_code ?>
        <th data-name="partner_code" class="<?= $Page->partner_code->headerCellClass() ?>"><div id="elh_partner_product_ref_partner_code" class="partner_product_ref_partner_code"><?= $Page->renderFieldHeader($Page->partner_code) ?></div></th>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
        <th data-name="product_type" class="<?= $Page->product_type->headerCellClass() ?>"><div id="elh_partner_product_ref_product_type" class="partner_product_ref_product_type"><?= $Page->renderFieldHeader($Page->product_type) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_partner_product_ref_grp" class="partner_product_ref_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>"><div id="elh_partner_product_ref_s_grp" class="partner_product_ref_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_partner_product_ref_product" class="partner_product_ref_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_partner_product_ref_rid" class="partner_product_ref_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->spl_ins->Visible) { // spl_ins ?>
        <th data-name="spl_ins" class="<?= $Page->spl_ins->headerCellClass() ?>"><div id="elh_partner_product_ref_spl_ins" class="partner_product_ref_spl_ins"><?= $Page->renderFieldHeader($Page->spl_ins) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_partner_product_ref_packing_type" class="partner_product_ref_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_partner_product_ref_batch_no" class="partner_product_ref_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
        <th data-name="shape" class="<?= $Page->shape->headerCellClass() ?>"><div id="elh_partner_product_ref_shape" class="partner_product_ref_shape"><?= $Page->renderFieldHeader($Page->shape) ?></div></th>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
        <th data-name="unit" class="<?= $Page->unit->headerCellClass() ?>"><div id="elh_partner_product_ref_unit" class="partner_product_ref_unit"><?= $Page->renderFieldHeader($Page->unit) ?></div></th>
<?php } ?>
<?php if ($Page->w->Visible) { // w ?>
        <th data-name="w" class="<?= $Page->w->headerCellClass() ?>"><div id="elh_partner_product_ref_w" class="partner_product_ref_w"><?= $Page->renderFieldHeader($Page->w) ?></div></th>
<?php } ?>
<?php if ($Page->w_cm->Visible) { // w_cm ?>
        <th data-name="w_cm" class="<?= $Page->w_cm->headerCellClass() ?>"><div id="elh_partner_product_ref_w_cm" class="partner_product_ref_w_cm"><?= $Page->renderFieldHeader($Page->w_cm) ?></div></th>
<?php } ?>
<?php if ($Page->l->Visible) { // l ?>
        <th data-name="l" class="<?= $Page->l->headerCellClass() ?>"><div id="elh_partner_product_ref_l" class="partner_product_ref_l"><?= $Page->renderFieldHeader($Page->l) ?></div></th>
<?php } ?>
<?php if ($Page->l_cm->Visible) { // l_cm ?>
        <th data-name="l_cm" class="<?= $Page->l_cm->headerCellClass() ?>"><div id="elh_partner_product_ref_l_cm" class="partner_product_ref_l_cm"><?= $Page->renderFieldHeader($Page->l_cm) ?></div></th>
<?php } ?>
<?php if ($Page->h->Visible) { // h ?>
        <th data-name="h" class="<?= $Page->h->headerCellClass() ?>"><div id="elh_partner_product_ref_h" class="partner_product_ref_h"><?= $Page->renderFieldHeader($Page->h) ?></div></th>
<?php } ?>
<?php if ($Page->h_cm->Visible) { // h_cm ?>
        <th data-name="h_cm" class="<?= $Page->h_cm->headerCellClass() ?>"><div id="elh_partner_product_ref_h_cm" class="partner_product_ref_h_cm"><?= $Page->renderFieldHeader($Page->h_cm) ?></div></th>
<?php } ?>
<?php if ($Page->partner_size->Visible) { // partner_size ?>
        <th data-name="partner_size" class="<?= $Page->partner_size->headerCellClass() ?>"><div id="elh_partner_product_ref_partner_size" class="partner_product_ref_partner_size"><?= $Page->renderFieldHeader($Page->partner_size) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_partner_product_ref_sqm" class="partner_product_ref_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
        <th data-name="cbm" class="<?= $Page->cbm->headerCellClass() ?>"><div id="elh_partner_product_ref_cbm" class="partner_product_ref_cbm"><?= $Page->renderFieldHeader($Page->cbm) ?></div></th>
<?php } ?>
<?php if ($Page->weight_sqm->Visible) { // weight_sqm ?>
        <th data-name="weight_sqm" class="<?= $Page->weight_sqm->headerCellClass() ?>"><div id="elh_partner_product_ref_weight_sqm" class="partner_product_ref_weight_sqm"><?= $Page->renderFieldHeader($Page->weight_sqm) ?></div></th>
<?php } ?>
<?php if ($Page->sqm_a->Visible) { // sqm_a ?>
        <th data-name="sqm_a" class="<?= $Page->sqm_a->headerCellClass() ?>"><div id="elh_partner_product_ref_sqm_a" class="partner_product_ref_sqm_a"><?= $Page->renderFieldHeader($Page->sqm_a) ?></div></th>
<?php } ?>
<?php if ($Page->_2srm_a->Visible) { // 2srm_a ?>
        <th data-name="_2srm_a" class="<?= $Page->_2srm_a->headerCellClass() ?>"><div id="elh_partner_product_ref__2srm_a" class="partner_product_ref__2srm_a"><?= $Page->renderFieldHeader($Page->_2srm_a) ?></div></th>
<?php } ?>
<?php if ($Page->_4srm_a->Visible) { // 4srm_a ?>
        <th data-name="_4srm_a" class="<?= $Page->_4srm_a->headerCellClass() ?>"><div id="elh_partner_product_ref__4srm_a" class="partner_product_ref__4srm_a"><?= $Page->renderFieldHeader($Page->_4srm_a) ?></div></th>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
        <th data-name="price" class="<?= $Page->price->headerCellClass() ?>"><div id="elh_partner_product_ref_price" class="partner_product_ref_price"><?= $Page->renderFieldHeader($Page->price) ?></div></th>
<?php } ?>
<?php if ($Page->price_cs->Visible) { // price_cs ?>
        <th data-name="price_cs" class="<?= $Page->price_cs->headerCellClass() ?>"><div id="elh_partner_product_ref_price_cs" class="partner_product_ref_price_cs"><?= $Page->renderFieldHeader($Page->price_cs) ?></div></th>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
        <th data-name="currency" class="<?= $Page->currency->headerCellClass() ?>"><div id="elh_partner_product_ref_currency" class="partner_product_ref_currency"><?= $Page->renderFieldHeader($Page->currency) ?></div></th>
<?php } ?>
<?php if ($Page->hsn->Visible) { // hsn ?>
        <th data-name="hsn" class="<?= $Page->hsn->headerCellClass() ?>"><div id="elh_partner_product_ref_hsn" class="partner_product_ref_hsn"><?= $Page->renderFieldHeader($Page->hsn) ?></div></th>
<?php } ?>
<?php if ($Page->composition->Visible) { // composition ?>
        <th data-name="composition" class="<?= $Page->composition->headerCellClass() ?>"><div id="elh_partner_product_ref_composition" class="partner_product_ref_composition"><?= $Page->renderFieldHeader($Page->composition) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_partner_product_ref_status" class="partner_product_ref_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_partner_product_ref_operator" class="partner_product_ref_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_partner_product_ref_datetime" class="partner_product_ref_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->d_01->Visible) { // d_01 ?>
        <th data-name="d_01" class="<?= $Page->d_01->headerCellClass() ?>"><div id="elh_partner_product_ref_d_01" class="partner_product_ref_d_01"><?= $Page->renderFieldHeader($Page->d_01) ?></div></th>
<?php } ?>
<?php if ($Page->d_02->Visible) { // d_02 ?>
        <th data-name="d_02" class="<?= $Page->d_02->headerCellClass() ?>"><div id="elh_partner_product_ref_d_02" class="partner_product_ref_d_02"><?= $Page->renderFieldHeader($Page->d_02) ?></div></th>
<?php } ?>
<?php if ($Page->d_03->Visible) { // d_03 ?>
        <th data-name="d_03" class="<?= $Page->d_03->headerCellClass() ?>"><div id="elh_partner_product_ref_d_03" class="partner_product_ref_d_03"><?= $Page->renderFieldHeader($Page->d_03) ?></div></th>
<?php } ?>
<?php if ($Page->d_04->Visible) { // d_04 ?>
        <th data-name="d_04" class="<?= $Page->d_04->headerCellClass() ?>"><div id="elh_partner_product_ref_d_04" class="partner_product_ref_d_04"><?= $Page->renderFieldHeader($Page->d_04) ?></div></th>
<?php } ?>
<?php if ($Page->d_05->Visible) { // d_05 ?>
        <th data-name="d_05" class="<?= $Page->d_05->headerCellClass() ?>"><div id="elh_partner_product_ref_d_05" class="partner_product_ref_d_05"><?= $Page->renderFieldHeader($Page->d_05) ?></div></th>
<?php } ?>
<?php if ($Page->d_06->Visible) { // d_06 ?>
        <th data-name="d_06" class="<?= $Page->d_06->headerCellClass() ?>"><div id="elh_partner_product_ref_d_06" class="partner_product_ref_d_06"><?= $Page->renderFieldHeader($Page->d_06) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_id" class="el_partner_product_ref_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_type->Visible) { // partner_type ?>
        <td data-name="partner_type"<?= $Page->partner_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_partner_type" class="el_partner_product_ref_partner_type">
<span<?= $Page->partner_type->viewAttributes() ?>>
<?= $Page->partner_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner->Visible) { // partner ?>
        <td data-name="partner"<?= $Page->partner->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_partner" class="el_partner_product_ref_partner">
<span<?= $Page->partner->viewAttributes() ?>>
<?= $Page->partner->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_ref->Visible) { // partner_ref ?>
        <td data-name="partner_ref"<?= $Page->partner_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_partner_ref" class="el_partner_product_ref_partner_ref">
<span<?= $Page->partner_ref->viewAttributes() ?>>
<?= $Page->partner_ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref__barcode" class="el_partner_product_ref__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_code->Visible) { // partner_code ?>
        <td data-name="partner_code"<?= $Page->partner_code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_partner_code" class="el_partner_product_ref_partner_code">
<span<?= $Page->partner_code->viewAttributes() ?>>
<?= $Page->partner_code->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_type->Visible) { // product_type ?>
        <td data-name="product_type"<?= $Page->product_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_product_type" class="el_partner_product_ref_product_type">
<span<?= $Page->product_type->viewAttributes() ?>>
<?= $Page->product_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_grp" class="el_partner_product_ref_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->grp->getViewValue()) && $Page->grp->linkAttributes() != "") { ?>
<a<?= $Page->grp->linkAttributes() ?>><?= $Page->grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_s_grp" class="el_partner_product_ref_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->s_grp->getViewValue()) && $Page->s_grp->linkAttributes() != "") { ?>
<a<?= $Page->s_grp->linkAttributes() ?>><?= $Page->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_product" class="el_partner_product_ref_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_rid" class="el_partner_product_ref_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?= $Page->rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->spl_ins->Visible) { // spl_ins ?>
        <td data-name="spl_ins"<?= $Page->spl_ins->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_spl_ins" class="el_partner_product_ref_spl_ins">
<span<?= $Page->spl_ins->viewAttributes() ?>>
<?= $Page->spl_ins->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_packing_type" class="el_partner_product_ref_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?= $Page->packing_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_batch_no" class="el_partner_product_ref_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?= $Page->batch_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shape->Visible) { // shape ?>
        <td data-name="shape"<?= $Page->shape->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_shape" class="el_partner_product_ref_shape">
<span<?= $Page->shape->viewAttributes() ?>>
<?= $Page->shape->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->unit->Visible) { // unit ?>
        <td data-name="unit"<?= $Page->unit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_unit" class="el_partner_product_ref_unit">
<span<?= $Page->unit->viewAttributes() ?>>
<?php if (!EmptyString($Page->unit->getViewValue()) && $Page->unit->linkAttributes() != "") { ?>
<a<?= $Page->unit->linkAttributes() ?>><?= $Page->unit->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->unit->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->w->Visible) { // w ?>
        <td data-name="w"<?= $Page->w->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_w" class="el_partner_product_ref_w">
<span<?= $Page->w->viewAttributes() ?>>
<?= $Page->w->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->w_cm->Visible) { // w_cm ?>
        <td data-name="w_cm"<?= $Page->w_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_w_cm" class="el_partner_product_ref_w_cm">
<span<?= $Page->w_cm->viewAttributes() ?>>
<?= $Page->w_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->l->Visible) { // l ?>
        <td data-name="l"<?= $Page->l->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_l" class="el_partner_product_ref_l">
<span<?= $Page->l->viewAttributes() ?>>
<?= $Page->l->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->l_cm->Visible) { // l_cm ?>
        <td data-name="l_cm"<?= $Page->l_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_l_cm" class="el_partner_product_ref_l_cm">
<span<?= $Page->l_cm->viewAttributes() ?>>
<?= $Page->l_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->h->Visible) { // h ?>
        <td data-name="h"<?= $Page->h->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_h" class="el_partner_product_ref_h">
<span<?= $Page->h->viewAttributes() ?>>
<?= $Page->h->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->h_cm->Visible) { // h_cm ?>
        <td data-name="h_cm"<?= $Page->h_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_h_cm" class="el_partner_product_ref_h_cm">
<span<?= $Page->h_cm->viewAttributes() ?>>
<?= $Page->h_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_size->Visible) { // partner_size ?>
        <td data-name="partner_size"<?= $Page->partner_size->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_partner_size" class="el_partner_product_ref_partner_size">
<span<?= $Page->partner_size->viewAttributes() ?>>
<?= $Page->partner_size->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_sqm" class="el_partner_product_ref_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cbm->Visible) { // cbm ?>
        <td data-name="cbm"<?= $Page->cbm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_cbm" class="el_partner_product_ref_cbm">
<span<?= $Page->cbm->viewAttributes() ?>>
<?= $Page->cbm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->weight_sqm->Visible) { // weight_sqm ?>
        <td data-name="weight_sqm"<?= $Page->weight_sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_weight_sqm" class="el_partner_product_ref_weight_sqm">
<span<?= $Page->weight_sqm->viewAttributes() ?>>
<?= $Page->weight_sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm_a->Visible) { // sqm_a ?>
        <td data-name="sqm_a"<?= $Page->sqm_a->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_sqm_a" class="el_partner_product_ref_sqm_a">
<span<?= $Page->sqm_a->viewAttributes() ?>>
<?= $Page->sqm_a->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_2srm_a->Visible) { // 2srm_a ?>
        <td data-name="_2srm_a"<?= $Page->_2srm_a->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref__2srm_a" class="el_partner_product_ref__2srm_a">
<span<?= $Page->_2srm_a->viewAttributes() ?>>
<?= $Page->_2srm_a->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_4srm_a->Visible) { // 4srm_a ?>
        <td data-name="_4srm_a"<?= $Page->_4srm_a->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref__4srm_a" class="el_partner_product_ref__4srm_a">
<span<?= $Page->_4srm_a->viewAttributes() ?>>
<?= $Page->_4srm_a->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->price->Visible) { // price ?>
        <td data-name="price"<?= $Page->price->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_price" class="el_partner_product_ref_price">
<span<?= $Page->price->viewAttributes() ?>>
<?= $Page->price->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->price_cs->Visible) { // price_cs ?>
        <td data-name="price_cs"<?= $Page->price_cs->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_price_cs" class="el_partner_product_ref_price_cs">
<span<?= $Page->price_cs->viewAttributes() ?>>
<?= $Page->price_cs->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->currency->Visible) { // currency ?>
        <td data-name="currency"<?= $Page->currency->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_currency" class="el_partner_product_ref_currency">
<span<?= $Page->currency->viewAttributes() ?>>
<?= $Page->currency->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->hsn->Visible) { // hsn ?>
        <td data-name="hsn"<?= $Page->hsn->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_hsn" class="el_partner_product_ref_hsn">
<span<?= $Page->hsn->viewAttributes() ?>>
<?= $Page->hsn->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->composition->Visible) { // composition ?>
        <td data-name="composition"<?= $Page->composition->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_composition" class="el_partner_product_ref_composition">
<span<?= $Page->composition->viewAttributes() ?>>
<?= $Page->composition->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_status" class="el_partner_product_ref_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_operator" class="el_partner_product_ref_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_datetime" class="el_partner_product_ref_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_01->Visible) { // d_01 ?>
        <td data-name="d_01"<?= $Page->d_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_d_01" class="el_partner_product_ref_d_01">
<span<?= $Page->d_01->viewAttributes() ?>>
<?= $Page->d_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_02->Visible) { // d_02 ?>
        <td data-name="d_02"<?= $Page->d_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_d_02" class="el_partner_product_ref_d_02">
<span<?= $Page->d_02->viewAttributes() ?>>
<?= $Page->d_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_03->Visible) { // d_03 ?>
        <td data-name="d_03"<?= $Page->d_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_d_03" class="el_partner_product_ref_d_03">
<span<?= $Page->d_03->viewAttributes() ?>>
<?= $Page->d_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_04->Visible) { // d_04 ?>
        <td data-name="d_04"<?= $Page->d_04->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_d_04" class="el_partner_product_ref_d_04">
<span<?= $Page->d_04->viewAttributes() ?>>
<?= $Page->d_04->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_05->Visible) { // d_05 ?>
        <td data-name="d_05"<?= $Page->d_05->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_d_05" class="el_partner_product_ref_d_05">
<span<?= $Page->d_05->viewAttributes() ?>>
<?= $Page->d_05->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_06->Visible) { // d_06 ?>
        <td data-name="d_06"<?= $Page->d_06->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_partner_product_ref_d_06" class="el_partner_product_ref_d_06">
<span<?= $Page->d_06->viewAttributes() ?>>
<?= $Page->d_06->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("partner_product_ref");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
