<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("PartnerProductRefGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fpartner_product_refgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { partner_product_ref: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpartner_product_refgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["partner_type", [fields.partner_type.visible && fields.partner_type.required ? ew.Validators.required(fields.partner_type.caption) : null], fields.partner_type.isInvalid],
            ["partner", [fields.partner.visible && fields.partner.required ? ew.Validators.required(fields.partner.caption) : null], fields.partner.isInvalid],
            ["partner_ref", [fields.partner_ref.visible && fields.partner_ref.required ? ew.Validators.required(fields.partner_ref.caption) : null], fields.partner_ref.isInvalid],
            ["_barcode", [fields._barcode.visible && fields._barcode.required ? ew.Validators.required(fields._barcode.caption) : null], fields._barcode.isInvalid],
            ["partner_code", [fields.partner_code.visible && fields.partner_code.required ? ew.Validators.required(fields.partner_code.caption) : null], fields.partner_code.isInvalid],
            ["product_type", [fields.product_type.visible && fields.product_type.required ? ew.Validators.required(fields.product_type.caption) : null], fields.product_type.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["spl_ins", [fields.spl_ins.visible && fields.spl_ins.required ? ew.Validators.required(fields.spl_ins.caption) : null], fields.spl_ins.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null, ew.Validators.integer], fields.batch_no.isInvalid],
            ["shape", [fields.shape.visible && fields.shape.required ? ew.Validators.required(fields.shape.caption) : null], fields.shape.isInvalid],
            ["unit", [fields.unit.visible && fields.unit.required ? ew.Validators.required(fields.unit.caption) : null], fields.unit.isInvalid],
            ["w", [fields.w.visible && fields.w.required ? ew.Validators.required(fields.w.caption) : null], fields.w.isInvalid],
            ["w_cm", [fields.w_cm.visible && fields.w_cm.required ? ew.Validators.required(fields.w_cm.caption) : null, ew.Validators.float], fields.w_cm.isInvalid],
            ["l", [fields.l.visible && fields.l.required ? ew.Validators.required(fields.l.caption) : null], fields.l.isInvalid],
            ["l_cm", [fields.l_cm.visible && fields.l_cm.required ? ew.Validators.required(fields.l_cm.caption) : null, ew.Validators.float], fields.l_cm.isInvalid],
            ["h", [fields.h.visible && fields.h.required ? ew.Validators.required(fields.h.caption) : null], fields.h.isInvalid],
            ["h_cm", [fields.h_cm.visible && fields.h_cm.required ? ew.Validators.required(fields.h_cm.caption) : null, ew.Validators.float], fields.h_cm.isInvalid],
            ["partner_size", [fields.partner_size.visible && fields.partner_size.required ? ew.Validators.required(fields.partner_size.caption) : null], fields.partner_size.isInvalid],
            ["sqm", [fields.sqm.visible && fields.sqm.required ? ew.Validators.required(fields.sqm.caption) : null], fields.sqm.isInvalid],
            ["cbm", [fields.cbm.visible && fields.cbm.required ? ew.Validators.required(fields.cbm.caption) : null, ew.Validators.float], fields.cbm.isInvalid],
            ["weight_sqm", [fields.weight_sqm.visible && fields.weight_sqm.required ? ew.Validators.required(fields.weight_sqm.caption) : null, ew.Validators.float], fields.weight_sqm.isInvalid],
            ["sqm_a", [fields.sqm_a.visible && fields.sqm_a.required ? ew.Validators.required(fields.sqm_a.caption) : null, ew.Validators.float], fields.sqm_a.isInvalid],
            ["_2srm_a", [fields._2srm_a.visible && fields._2srm_a.required ? ew.Validators.required(fields._2srm_a.caption) : null, ew.Validators.float], fields._2srm_a.isInvalid],
            ["_4srm_a", [fields._4srm_a.visible && fields._4srm_a.required ? ew.Validators.required(fields._4srm_a.caption) : null, ew.Validators.float], fields._4srm_a.isInvalid],
            ["price", [fields.price.visible && fields.price.required ? ew.Validators.required(fields.price.caption) : null, ew.Validators.float], fields.price.isInvalid],
            ["price_cs", [fields.price_cs.visible && fields.price_cs.required ? ew.Validators.required(fields.price_cs.caption) : null, ew.Validators.float], fields.price_cs.isInvalid],
            ["currency", [fields.currency.visible && fields.currency.required ? ew.Validators.required(fields.currency.caption) : null], fields.currency.isInvalid],
            ["hsn", [fields.hsn.visible && fields.hsn.required ? ew.Validators.required(fields.hsn.caption) : null], fields.hsn.isInvalid],
            ["composition", [fields.composition.visible && fields.composition.required ? ew.Validators.required(fields.composition.caption) : null], fields.composition.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["d_01", [fields.d_01.visible && fields.d_01.required ? ew.Validators.required(fields.d_01.caption) : null], fields.d_01.isInvalid],
            ["d_02", [fields.d_02.visible && fields.d_02.required ? ew.Validators.required(fields.d_02.caption) : null], fields.d_02.isInvalid],
            ["d_03", [fields.d_03.visible && fields.d_03.required ? ew.Validators.required(fields.d_03.caption) : null], fields.d_03.isInvalid],
            ["d_04", [fields.d_04.visible && fields.d_04.required ? ew.Validators.required(fields.d_04.caption) : null], fields.d_04.isInvalid],
            ["d_05", [fields.d_05.visible && fields.d_05.required ? ew.Validators.required(fields.d_05.caption) : null], fields.d_05.isInvalid],
            ["d_06", [fields.d_06.visible && fields.d_06.required ? ew.Validators.required(fields.d_06.caption) : null], fields.d_06.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["partner_type",false],["partner",false],["partner_ref",false],["_barcode",false],["partner_code",false],["product_type",false],["grp",false],["s_grp",false],["product",false],["rid",false],["spl_ins",false],["packing_type",false],["batch_no",false],["shape",false],["unit",false],["w",false],["w_cm",false],["l",false],["l_cm",false],["h",false],["h_cm",false],["partner_size",false],["sqm",false],["cbm",false],["weight_sqm",false],["sqm_a",false],["_2srm_a",false],["_4srm_a",false],["price",false],["price_cs",false],["currency",false],["hsn",false],["composition",false],["status",false],["d_01",false],["d_02",false],["d_03",false],["d_04",false],["d_05",false],["d_06",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "partner_type": <?= $Grid->partner_type->toClientList($Grid) ?>,
            "partner": <?= $Grid->partner->toClientList($Grid) ?>,
            "product_type": <?= $Grid->product_type->toClientList($Grid) ?>,
            "grp": <?= $Grid->grp->toClientList($Grid) ?>,
            "s_grp": <?= $Grid->s_grp->toClientList($Grid) ?>,
            "product": <?= $Grid->product->toClientList($Grid) ?>,
            "rid": <?= $Grid->rid->toClientList($Grid) ?>,
            "packing_type": <?= $Grid->packing_type->toClientList($Grid) ?>,
            "batch_no": <?= $Grid->batch_no->toClientList($Grid) ?>,
            "shape": <?= $Grid->shape->toClientList($Grid) ?>,
            "unit": <?= $Grid->unit->toClientList($Grid) ?>,
            "currency": <?= $Grid->currency->toClientList($Grid) ?>,
            "hsn": <?= $Grid->hsn->toClientList($Grid) ?>,
            "composition": <?= $Grid->composition->toClientList($Grid) ?>,
            "status": <?= $Grid->status->toClientList($Grid) ?>,
            "operator": <?= $Grid->operator->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fpartner_product_refgrid" class="ew-form ew-list-form">
<div id="gmp_partner_product_ref" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_partner_product_refgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_partner_product_ref_id" class="partner_product_ref_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->partner_type->Visible) { // partner_type ?>
        <th data-name="partner_type" class="<?= $Grid->partner_type->headerCellClass() ?>"><div id="elh_partner_product_ref_partner_type" class="partner_product_ref_partner_type"><?= $Grid->renderFieldHeader($Grid->partner_type) ?></div></th>
<?php } ?>
<?php if ($Grid->partner->Visible) { // partner ?>
        <th data-name="partner" class="<?= $Grid->partner->headerCellClass() ?>"><div id="elh_partner_product_ref_partner" class="partner_product_ref_partner"><?= $Grid->renderFieldHeader($Grid->partner) ?></div></th>
<?php } ?>
<?php if ($Grid->partner_ref->Visible) { // partner_ref ?>
        <th data-name="partner_ref" class="<?= $Grid->partner_ref->headerCellClass() ?>"><div id="elh_partner_product_ref_partner_ref" class="partner_product_ref_partner_ref"><?= $Grid->renderFieldHeader($Grid->partner_ref) ?></div></th>
<?php } ?>
<?php if ($Grid->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Grid->_barcode->headerCellClass() ?>"><div id="elh_partner_product_ref__barcode" class="partner_product_ref__barcode"><?= $Grid->renderFieldHeader($Grid->_barcode) ?></div></th>
<?php } ?>
<?php if ($Grid->partner_code->Visible) { // partner_code ?>
        <th data-name="partner_code" class="<?= $Grid->partner_code->headerCellClass() ?>"><div id="elh_partner_product_ref_partner_code" class="partner_product_ref_partner_code"><?= $Grid->renderFieldHeader($Grid->partner_code) ?></div></th>
<?php } ?>
<?php if ($Grid->product_type->Visible) { // product_type ?>
        <th data-name="product_type" class="<?= $Grid->product_type->headerCellClass() ?>"><div id="elh_partner_product_ref_product_type" class="partner_product_ref_product_type"><?= $Grid->renderFieldHeader($Grid->product_type) ?></div></th>
<?php } ?>
<?php if ($Grid->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Grid->grp->headerCellClass() ?>"><div id="elh_partner_product_ref_grp" class="partner_product_ref_grp"><?= $Grid->renderFieldHeader($Grid->grp) ?></div></th>
<?php } ?>
<?php if ($Grid->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Grid->s_grp->headerCellClass() ?>"><div id="elh_partner_product_ref_s_grp" class="partner_product_ref_s_grp"><?= $Grid->renderFieldHeader($Grid->s_grp) ?></div></th>
<?php } ?>
<?php if ($Grid->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Grid->product->headerCellClass() ?>"><div id="elh_partner_product_ref_product" class="partner_product_ref_product"><?= $Grid->renderFieldHeader($Grid->product) ?></div></th>
<?php } ?>
<?php if ($Grid->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Grid->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_partner_product_ref_rid" class="partner_product_ref_rid"><?= $Grid->renderFieldHeader($Grid->rid) ?></div></th>
<?php } ?>
<?php if ($Grid->spl_ins->Visible) { // spl_ins ?>
        <th data-name="spl_ins" class="<?= $Grid->spl_ins->headerCellClass() ?>"><div id="elh_partner_product_ref_spl_ins" class="partner_product_ref_spl_ins"><?= $Grid->renderFieldHeader($Grid->spl_ins) ?></div></th>
<?php } ?>
<?php if ($Grid->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Grid->packing_type->headerCellClass() ?>"><div id="elh_partner_product_ref_packing_type" class="partner_product_ref_packing_type"><?= $Grid->renderFieldHeader($Grid->packing_type) ?></div></th>
<?php } ?>
<?php if ($Grid->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Grid->batch_no->headerCellClass() ?>"><div id="elh_partner_product_ref_batch_no" class="partner_product_ref_batch_no"><?= $Grid->renderFieldHeader($Grid->batch_no) ?></div></th>
<?php } ?>
<?php if ($Grid->shape->Visible) { // shape ?>
        <th data-name="shape" class="<?= $Grid->shape->headerCellClass() ?>"><div id="elh_partner_product_ref_shape" class="partner_product_ref_shape"><?= $Grid->renderFieldHeader($Grid->shape) ?></div></th>
<?php } ?>
<?php if ($Grid->unit->Visible) { // unit ?>
        <th data-name="unit" class="<?= $Grid->unit->headerCellClass() ?>"><div id="elh_partner_product_ref_unit" class="partner_product_ref_unit"><?= $Grid->renderFieldHeader($Grid->unit) ?></div></th>
<?php } ?>
<?php if ($Grid->w->Visible) { // w ?>
        <th data-name="w" class="<?= $Grid->w->headerCellClass() ?>"><div id="elh_partner_product_ref_w" class="partner_product_ref_w"><?= $Grid->renderFieldHeader($Grid->w) ?></div></th>
<?php } ?>
<?php if ($Grid->w_cm->Visible) { // w_cm ?>
        <th data-name="w_cm" class="<?= $Grid->w_cm->headerCellClass() ?>"><div id="elh_partner_product_ref_w_cm" class="partner_product_ref_w_cm"><?= $Grid->renderFieldHeader($Grid->w_cm) ?></div></th>
<?php } ?>
<?php if ($Grid->l->Visible) { // l ?>
        <th data-name="l" class="<?= $Grid->l->headerCellClass() ?>"><div id="elh_partner_product_ref_l" class="partner_product_ref_l"><?= $Grid->renderFieldHeader($Grid->l) ?></div></th>
<?php } ?>
<?php if ($Grid->l_cm->Visible) { // l_cm ?>
        <th data-name="l_cm" class="<?= $Grid->l_cm->headerCellClass() ?>"><div id="elh_partner_product_ref_l_cm" class="partner_product_ref_l_cm"><?= $Grid->renderFieldHeader($Grid->l_cm) ?></div></th>
<?php } ?>
<?php if ($Grid->h->Visible) { // h ?>
        <th data-name="h" class="<?= $Grid->h->headerCellClass() ?>"><div id="elh_partner_product_ref_h" class="partner_product_ref_h"><?= $Grid->renderFieldHeader($Grid->h) ?></div></th>
<?php } ?>
<?php if ($Grid->h_cm->Visible) { // h_cm ?>
        <th data-name="h_cm" class="<?= $Grid->h_cm->headerCellClass() ?>"><div id="elh_partner_product_ref_h_cm" class="partner_product_ref_h_cm"><?= $Grid->renderFieldHeader($Grid->h_cm) ?></div></th>
<?php } ?>
<?php if ($Grid->partner_size->Visible) { // partner_size ?>
        <th data-name="partner_size" class="<?= $Grid->partner_size->headerCellClass() ?>"><div id="elh_partner_product_ref_partner_size" class="partner_product_ref_partner_size"><?= $Grid->renderFieldHeader($Grid->partner_size) ?></div></th>
<?php } ?>
<?php if ($Grid->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Grid->sqm->headerCellClass() ?>"><div id="elh_partner_product_ref_sqm" class="partner_product_ref_sqm"><?= $Grid->renderFieldHeader($Grid->sqm) ?></div></th>
<?php } ?>
<?php if ($Grid->cbm->Visible) { // cbm ?>
        <th data-name="cbm" class="<?= $Grid->cbm->headerCellClass() ?>"><div id="elh_partner_product_ref_cbm" class="partner_product_ref_cbm"><?= $Grid->renderFieldHeader($Grid->cbm) ?></div></th>
<?php } ?>
<?php if ($Grid->weight_sqm->Visible) { // weight_sqm ?>
        <th data-name="weight_sqm" class="<?= $Grid->weight_sqm->headerCellClass() ?>"><div id="elh_partner_product_ref_weight_sqm" class="partner_product_ref_weight_sqm"><?= $Grid->renderFieldHeader($Grid->weight_sqm) ?></div></th>
<?php } ?>
<?php if ($Grid->sqm_a->Visible) { // sqm_a ?>
        <th data-name="sqm_a" class="<?= $Grid->sqm_a->headerCellClass() ?>"><div id="elh_partner_product_ref_sqm_a" class="partner_product_ref_sqm_a"><?= $Grid->renderFieldHeader($Grid->sqm_a) ?></div></th>
<?php } ?>
<?php if ($Grid->_2srm_a->Visible) { // 2srm_a ?>
        <th data-name="_2srm_a" class="<?= $Grid->_2srm_a->headerCellClass() ?>"><div id="elh_partner_product_ref__2srm_a" class="partner_product_ref__2srm_a"><?= $Grid->renderFieldHeader($Grid->_2srm_a) ?></div></th>
<?php } ?>
<?php if ($Grid->_4srm_a->Visible) { // 4srm_a ?>
        <th data-name="_4srm_a" class="<?= $Grid->_4srm_a->headerCellClass() ?>"><div id="elh_partner_product_ref__4srm_a" class="partner_product_ref__4srm_a"><?= $Grid->renderFieldHeader($Grid->_4srm_a) ?></div></th>
<?php } ?>
<?php if ($Grid->price->Visible) { // price ?>
        <th data-name="price" class="<?= $Grid->price->headerCellClass() ?>"><div id="elh_partner_product_ref_price" class="partner_product_ref_price"><?= $Grid->renderFieldHeader($Grid->price) ?></div></th>
<?php } ?>
<?php if ($Grid->price_cs->Visible) { // price_cs ?>
        <th data-name="price_cs" class="<?= $Grid->price_cs->headerCellClass() ?>"><div id="elh_partner_product_ref_price_cs" class="partner_product_ref_price_cs"><?= $Grid->renderFieldHeader($Grid->price_cs) ?></div></th>
<?php } ?>
<?php if ($Grid->currency->Visible) { // currency ?>
        <th data-name="currency" class="<?= $Grid->currency->headerCellClass() ?>"><div id="elh_partner_product_ref_currency" class="partner_product_ref_currency"><?= $Grid->renderFieldHeader($Grid->currency) ?></div></th>
<?php } ?>
<?php if ($Grid->hsn->Visible) { // hsn ?>
        <th data-name="hsn" class="<?= $Grid->hsn->headerCellClass() ?>"><div id="elh_partner_product_ref_hsn" class="partner_product_ref_hsn"><?= $Grid->renderFieldHeader($Grid->hsn) ?></div></th>
<?php } ?>
<?php if ($Grid->composition->Visible) { // composition ?>
        <th data-name="composition" class="<?= $Grid->composition->headerCellClass() ?>"><div id="elh_partner_product_ref_composition" class="partner_product_ref_composition"><?= $Grid->renderFieldHeader($Grid->composition) ?></div></th>
<?php } ?>
<?php if ($Grid->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Grid->status->headerCellClass() ?>"><div id="elh_partner_product_ref_status" class="partner_product_ref_status"><?= $Grid->renderFieldHeader($Grid->status) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_partner_product_ref_operator" class="partner_product_ref_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_partner_product_ref_datetime" class="partner_product_ref_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php if ($Grid->d_01->Visible) { // d_01 ?>
        <th data-name="d_01" class="<?= $Grid->d_01->headerCellClass() ?>"><div id="elh_partner_product_ref_d_01" class="partner_product_ref_d_01"><?= $Grid->renderFieldHeader($Grid->d_01) ?></div></th>
<?php } ?>
<?php if ($Grid->d_02->Visible) { // d_02 ?>
        <th data-name="d_02" class="<?= $Grid->d_02->headerCellClass() ?>"><div id="elh_partner_product_ref_d_02" class="partner_product_ref_d_02"><?= $Grid->renderFieldHeader($Grid->d_02) ?></div></th>
<?php } ?>
<?php if ($Grid->d_03->Visible) { // d_03 ?>
        <th data-name="d_03" class="<?= $Grid->d_03->headerCellClass() ?>"><div id="elh_partner_product_ref_d_03" class="partner_product_ref_d_03"><?= $Grid->renderFieldHeader($Grid->d_03) ?></div></th>
<?php } ?>
<?php if ($Grid->d_04->Visible) { // d_04 ?>
        <th data-name="d_04" class="<?= $Grid->d_04->headerCellClass() ?>"><div id="elh_partner_product_ref_d_04" class="partner_product_ref_d_04"><?= $Grid->renderFieldHeader($Grid->d_04) ?></div></th>
<?php } ?>
<?php if ($Grid->d_05->Visible) { // d_05 ?>
        <th data-name="d_05" class="<?= $Grid->d_05->headerCellClass() ?>"><div id="elh_partner_product_ref_d_05" class="partner_product_ref_d_05"><?= $Grid->renderFieldHeader($Grid->d_05) ?></div></th>
<?php } ?>
<?php if ($Grid->d_06->Visible) { // d_06 ?>
        <th data-name="d_06" class="<?= $Grid->d_06->headerCellClass() ?>"><div id="elh_partner_product_ref_d_06" class="partner_product_ref_d_06"><?= $Grid->renderFieldHeader($Grid->d_06) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_id" class="el_partner_product_ref_id"></span>
<input type="hidden" data-table="partner_product_ref" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_id" class="el_partner_product_ref_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="partner_product_ref" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_id" class="el_partner_product_ref_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_id" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_id" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_id" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_id" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="partner_product_ref" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->partner_type->Visible) { // partner_type ?>
        <td data-name="partner_type"<?= $Grid->partner_type->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner_type" class="el_partner_product_ref_partner_type">
    <select
        id="x<?= $Grid->RowIndex ?>_partner_type"
        name="x<?= $Grid->RowIndex ?>_partner_type"
        class="form-select ew-select<?= $Grid->partner_type->isInvalidClass() ?>"
        <?php if (!$Grid->partner_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_partner_type"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_partner_type"
        data-value-separator="<?= $Grid->partner_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->partner_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->partner_type->editAttributes() ?>>
        <?= $Grid->partner_type->selectOptionListHtml("x{$Grid->RowIndex}_partner_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->partner_type->getErrorMessage() ?></div>
<?= $Grid->partner_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_partner_type") ?>
<?php if (!$Grid->partner_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_partner_type", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_partner_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.partner_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_partner_type", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_partner_type", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.partner_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_partner_type" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_partner_type" id="o<?= $Grid->RowIndex ?>_partner_type" value="<?= HtmlEncode($Grid->partner_type->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner_type" class="el_partner_product_ref_partner_type">
    <select
        id="x<?= $Grid->RowIndex ?>_partner_type"
        name="x<?= $Grid->RowIndex ?>_partner_type"
        class="form-select ew-select<?= $Grid->partner_type->isInvalidClass() ?>"
        <?php if (!$Grid->partner_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_partner_type"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_partner_type"
        data-value-separator="<?= $Grid->partner_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->partner_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->partner_type->editAttributes() ?>>
        <?= $Grid->partner_type->selectOptionListHtml("x{$Grid->RowIndex}_partner_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->partner_type->getErrorMessage() ?></div>
<?= $Grid->partner_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_partner_type") ?>
<?php if (!$Grid->partner_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_partner_type", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_partner_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.partner_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_partner_type", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_partner_type", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.partner_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner_type" class="el_partner_product_ref_partner_type">
<span<?= $Grid->partner_type->viewAttributes() ?>>
<?= $Grid->partner_type->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_partner_type" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_partner_type" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_partner_type" value="<?= HtmlEncode($Grid->partner_type->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_partner_type" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_partner_type" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_partner_type" value="<?= HtmlEncode($Grid->partner_type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->partner->Visible) { // partner ?>
        <td data-name="partner"<?= $Grid->partner->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner" class="el_partner_product_ref_partner">
    <select
        id="x<?= $Grid->RowIndex ?>_partner"
        name="x<?= $Grid->RowIndex ?>_partner"
        class="form-control ew-select<?= $Grid->partner->isInvalidClass() ?>"
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_partner"
        data-table="partner_product_ref"
        data-field="x_partner"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->partner->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->partner->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->partner->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Grid->partner->editAttributes() ?>>
        <?= $Grid->partner->selectOptionListHtml("x{$Grid->RowIndex}_partner") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->partner->getErrorMessage() ?></div>
<?= $Grid->partner->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_partner") ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_partner", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_partner" };
    if (fpartner_product_refgrid.lists.partner?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_partner", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_partner", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.partner_product_ref.fields.partner.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_partner" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_partner" id="o<?= $Grid->RowIndex ?>_partner" value="<?= HtmlEncode($Grid->partner->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner" class="el_partner_product_ref_partner">
    <select
        id="x<?= $Grid->RowIndex ?>_partner"
        name="x<?= $Grid->RowIndex ?>_partner"
        class="form-control ew-select<?= $Grid->partner->isInvalidClass() ?>"
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_partner"
        data-table="partner_product_ref"
        data-field="x_partner"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->partner->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->partner->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->partner->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Grid->partner->editAttributes() ?>>
        <?= $Grid->partner->selectOptionListHtml("x{$Grid->RowIndex}_partner") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->partner->getErrorMessage() ?></div>
<?= $Grid->partner->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_partner") ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_partner", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_partner" };
    if (fpartner_product_refgrid.lists.partner?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_partner", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_partner", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.partner_product_ref.fields.partner.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner" class="el_partner_product_ref_partner">
<span<?= $Grid->partner->viewAttributes() ?>>
<?= $Grid->partner->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_partner" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_partner" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_partner" value="<?= HtmlEncode($Grid->partner->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_partner" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_partner" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_partner" value="<?= HtmlEncode($Grid->partner->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->partner_ref->Visible) { // partner_ref ?>
        <td data-name="partner_ref"<?= $Grid->partner_ref->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner_ref" class="el_partner_product_ref_partner_ref">
<input type="<?= $Grid->partner_ref->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_partner_ref" id="x<?= $Grid->RowIndex ?>_partner_ref" data-table="partner_product_ref" data-field="x_partner_ref" value="<?= $Grid->partner_ref->EditValue ?>" size="30" maxlength="144" placeholder="<?= HtmlEncode($Grid->partner_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->partner_ref->formatPattern()) ?>"<?= $Grid->partner_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->partner_ref->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_partner_ref" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_partner_ref" id="o<?= $Grid->RowIndex ?>_partner_ref" value="<?= HtmlEncode($Grid->partner_ref->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner_ref" class="el_partner_product_ref_partner_ref">
<input type="<?= $Grid->partner_ref->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_partner_ref" id="x<?= $Grid->RowIndex ?>_partner_ref" data-table="partner_product_ref" data-field="x_partner_ref" value="<?= $Grid->partner_ref->EditValue ?>" size="30" maxlength="144" placeholder="<?= HtmlEncode($Grid->partner_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->partner_ref->formatPattern()) ?>"<?= $Grid->partner_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->partner_ref->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner_ref" class="el_partner_product_ref_partner_ref">
<span<?= $Grid->partner_ref->viewAttributes() ?>>
<?= $Grid->partner_ref->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_partner_ref" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_partner_ref" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_partner_ref" value="<?= HtmlEncode($Grid->partner_ref->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_partner_ref" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_partner_ref" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_partner_ref" value="<?= HtmlEncode($Grid->partner_ref->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Grid->_barcode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref__barcode" class="el_partner_product_ref__barcode">
<input type="<?= $Grid->_barcode->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__barcode" id="x<?= $Grid->RowIndex ?>__barcode" data-table="partner_product_ref" data-field="x__barcode" value="<?= $Grid->_barcode->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Grid->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_barcode->formatPattern()) ?>"<?= $Grid->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_barcode->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x__barcode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__barcode" id="o<?= $Grid->RowIndex ?>__barcode" value="<?= HtmlEncode($Grid->_barcode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref__barcode" class="el_partner_product_ref__barcode">
<input type="<?= $Grid->_barcode->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__barcode" id="x<?= $Grid->RowIndex ?>__barcode" data-table="partner_product_ref" data-field="x__barcode" value="<?= $Grid->_barcode->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Grid->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_barcode->formatPattern()) ?>"<?= $Grid->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_barcode->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref__barcode" class="el_partner_product_ref__barcode">
<span<?= $Grid->_barcode->viewAttributes() ?>>
<?= $Grid->_barcode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x__barcode" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>__barcode" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>__barcode" value="<?= HtmlEncode($Grid->_barcode->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x__barcode" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>__barcode" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>__barcode" value="<?= HtmlEncode($Grid->_barcode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->partner_code->Visible) { // partner_code ?>
        <td data-name="partner_code"<?= $Grid->partner_code->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner_code" class="el_partner_product_ref_partner_code">
<input type="<?= $Grid->partner_code->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_partner_code" id="x<?= $Grid->RowIndex ?>_partner_code" data-table="partner_product_ref" data-field="x_partner_code" value="<?= $Grid->partner_code->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->partner_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->partner_code->formatPattern()) ?>"<?= $Grid->partner_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->partner_code->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_partner_code" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_partner_code" id="o<?= $Grid->RowIndex ?>_partner_code" value="<?= HtmlEncode($Grid->partner_code->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner_code" class="el_partner_product_ref_partner_code">
<input type="<?= $Grid->partner_code->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_partner_code" id="x<?= $Grid->RowIndex ?>_partner_code" data-table="partner_product_ref" data-field="x_partner_code" value="<?= $Grid->partner_code->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->partner_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->partner_code->formatPattern()) ?>"<?= $Grid->partner_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->partner_code->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner_code" class="el_partner_product_ref_partner_code">
<span<?= $Grid->partner_code->viewAttributes() ?>>
<?= $Grid->partner_code->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_partner_code" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_partner_code" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_partner_code" value="<?= HtmlEncode($Grid->partner_code->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_partner_code" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_partner_code" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_partner_code" value="<?= HtmlEncode($Grid->partner_code->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->product_type->Visible) { // product_type ?>
        <td data-name="product_type"<?= $Grid->product_type->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_product_type" class="el_partner_product_ref_product_type">
    <select
        id="x<?= $Grid->RowIndex ?>_product_type"
        name="x<?= $Grid->RowIndex ?>_product_type"
        class="form-select ew-select<?= $Grid->product_type->isInvalidClass() ?>"
        <?php if (!$Grid->product_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_product_type"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_product_type"
        data-value-separator="<?= $Grid->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product_type->getPlaceHolder()) ?>"
        <?= $Grid->product_type->editAttributes() ?>>
        <?= $Grid->product_type->selectOptionListHtml("x{$Grid->RowIndex}_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product_type->getErrorMessage() ?></div>
<?= $Grid->product_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product_type") ?>
<?php if (!$Grid->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product_type", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product_type", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product_type", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_product_type" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_product_type" id="o<?= $Grid->RowIndex ?>_product_type" value="<?= HtmlEncode($Grid->product_type->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_product_type" class="el_partner_product_ref_product_type">
    <select
        id="x<?= $Grid->RowIndex ?>_product_type"
        name="x<?= $Grid->RowIndex ?>_product_type"
        class="form-select ew-select<?= $Grid->product_type->isInvalidClass() ?>"
        <?php if (!$Grid->product_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_product_type"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_product_type"
        data-value-separator="<?= $Grid->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product_type->getPlaceHolder()) ?>"
        <?= $Grid->product_type->editAttributes() ?>>
        <?= $Grid->product_type->selectOptionListHtml("x{$Grid->RowIndex}_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product_type->getErrorMessage() ?></div>
<?= $Grid->product_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product_type") ?>
<?php if (!$Grid->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product_type", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product_type", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product_type", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_product_type" class="el_partner_product_ref_product_type">
<span<?= $Grid->product_type->viewAttributes() ?>>
<?= $Grid->product_type->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_product_type" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_product_type" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_product_type" value="<?= HtmlEncode($Grid->product_type->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_product_type" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_product_type" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_product_type" value="<?= HtmlEncode($Grid->product_type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Grid->grp->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_grp" class="el_partner_product_ref_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_grp"
        name="x<?= $Grid->RowIndex ?>_grp"
        class="form-select ew-select<?= $Grid->grp->isInvalidClass() ?>"
        <?php if (!$Grid->grp->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_grp"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_grp"
        data-value-separator="<?= $Grid->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->grp->editAttributes() ?>>
        <?= $Grid->grp->selectOptionListHtml("x{$Grid->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->grp->getErrorMessage() ?></div>
<?= $Grid->grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_grp") ?>
<?php if (!$Grid->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_grp", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_grp" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_grp" id="o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_grp" class="el_partner_product_ref_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_grp"
        name="x<?= $Grid->RowIndex ?>_grp"
        class="form-select ew-select<?= $Grid->grp->isInvalidClass() ?>"
        <?php if (!$Grid->grp->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_grp"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_grp"
        data-value-separator="<?= $Grid->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->grp->editAttributes() ?>>
        <?= $Grid->grp->selectOptionListHtml("x{$Grid->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->grp->getErrorMessage() ?></div>
<?= $Grid->grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_grp") ?>
<?php if (!$Grid->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_grp", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_grp" class="el_partner_product_ref_grp">
<span<?= $Grid->grp->viewAttributes() ?>>
<?php if (!EmptyString($Grid->grp->getViewValue()) && $Grid->grp->linkAttributes() != "") { ?>
<a<?= $Grid->grp->linkAttributes() ?>><?= $Grid->grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_grp" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_grp" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_grp" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_grp" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Grid->s_grp->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_s_grp" class="el_partner_product_ref_s_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_s_grp"
        name="x<?= $Grid->RowIndex ?>_s_grp"
        class="form-select ew-select<?= $Grid->s_grp->isInvalidClass() ?>"
        <?php if (!$Grid->s_grp->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_s_grp"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_s_grp"
        data-value-separator="<?= $Grid->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->s_grp->editAttributes() ?>>
        <?= $Grid->s_grp->selectOptionListHtml("x{$Grid->RowIndex}_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_grp->getErrorMessage() ?></div>
<?= $Grid->s_grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_grp") ?>
<?php if (!$Grid->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_grp", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_s_grp" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_s_grp" id="o<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_s_grp" class="el_partner_product_ref_s_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_s_grp"
        name="x<?= $Grid->RowIndex ?>_s_grp"
        class="form-select ew-select<?= $Grid->s_grp->isInvalidClass() ?>"
        <?php if (!$Grid->s_grp->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_s_grp"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_s_grp"
        data-value-separator="<?= $Grid->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->s_grp->editAttributes() ?>>
        <?= $Grid->s_grp->selectOptionListHtml("x{$Grid->RowIndex}_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_grp->getErrorMessage() ?></div>
<?= $Grid->s_grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_grp") ?>
<?php if (!$Grid->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_grp", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_s_grp" class="el_partner_product_ref_s_grp">
<span<?= $Grid->s_grp->viewAttributes() ?>>
<?php if (!EmptyString($Grid->s_grp->getViewValue()) && $Grid->s_grp->linkAttributes() != "") { ?>
<a<?= $Grid->s_grp->linkAttributes() ?>><?= $Grid->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_s_grp" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_s_grp" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_s_grp" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_s_grp" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->product->Visible) { // product ?>
        <td data-name="product"<?= $Grid->product->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_product" class="el_partner_product_ref_product">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-select ew-select<?= $Grid->product->isInvalidClass() ?>"
        <?php if (!$Grid->product->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_product"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_product"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<?php if (!$Grid->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_product" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_product" id="o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_product" class="el_partner_product_ref_product">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-select ew-select<?= $Grid->product->isInvalidClass() ?>"
        <?php if (!$Grid->product->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_product"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_product"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<?php if (!$Grid->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_product" class="el_partner_product_ref_product">
<span<?= $Grid->product->viewAttributes() ?>>
<?php if (!EmptyString($Grid->product->getViewValue()) && $Grid->product->linkAttributes() != "") { ?>
<a<?= $Grid->product->linkAttributes() ?>><?= $Grid->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->product->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_product" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_product" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_product" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_product" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Grid->rid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->rid->getSessionValue() != "") { ?>
<span<?= $Grid->rid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->rid->getDisplayValue($Grid->rid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_rid" name="x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_rid" class="el_partner_product_ref_rid">
    <select
        id="x<?= $Grid->RowIndex ?>_rid"
        name="x<?= $Grid->RowIndex ?>_rid"
        class="form-select ew-select<?= $Grid->rid->isInvalidClass() ?>"
        <?php if (!$Grid->rid->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_rid"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_rid"
        data-value-separator="<?= $Grid->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->rid->editAttributes() ?>>
        <?= $Grid->rid->selectOptionListHtml("x{$Grid->RowIndex}_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->rid->getErrorMessage() ?></div>
<?= $Grid->rid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_rid") ?>
<?php if (!$Grid->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_rid", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.rid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_rid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_rid" id="o<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->rid->getSessionValue() != "") { ?>
<span<?= $Grid->rid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->rid->getDisplayValue($Grid->rid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_rid" name="x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_rid" class="el_partner_product_ref_rid">
    <select
        id="x<?= $Grid->RowIndex ?>_rid"
        name="x<?= $Grid->RowIndex ?>_rid"
        class="form-select ew-select<?= $Grid->rid->isInvalidClass() ?>"
        <?php if (!$Grid->rid->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_rid"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_rid"
        data-value-separator="<?= $Grid->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->rid->editAttributes() ?>>
        <?= $Grid->rid->selectOptionListHtml("x{$Grid->RowIndex}_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->rid->getErrorMessage() ?></div>
<?= $Grid->rid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_rid") ?>
<?php if (!$Grid->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_rid", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.rid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_rid" class="el_partner_product_ref_rid">
<span<?= $Grid->rid->viewAttributes() ?>>
<?= $Grid->rid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_rid" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_rid" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_rid" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_rid" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->spl_ins->Visible) { // spl_ins ?>
        <td data-name="spl_ins"<?= $Grid->spl_ins->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_spl_ins" class="el_partner_product_ref_spl_ins">
<input type="<?= $Grid->spl_ins->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_spl_ins" id="x<?= $Grid->RowIndex ?>_spl_ins" data-table="partner_product_ref" data-field="x_spl_ins" value="<?= $Grid->spl_ins->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->spl_ins->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->spl_ins->formatPattern()) ?>"<?= $Grid->spl_ins->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->spl_ins->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_spl_ins" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_spl_ins" id="o<?= $Grid->RowIndex ?>_spl_ins" value="<?= HtmlEncode($Grid->spl_ins->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_spl_ins" class="el_partner_product_ref_spl_ins">
<input type="<?= $Grid->spl_ins->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_spl_ins" id="x<?= $Grid->RowIndex ?>_spl_ins" data-table="partner_product_ref" data-field="x_spl_ins" value="<?= $Grid->spl_ins->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->spl_ins->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->spl_ins->formatPattern()) ?>"<?= $Grid->spl_ins->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->spl_ins->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_spl_ins" class="el_partner_product_ref_spl_ins">
<span<?= $Grid->spl_ins->viewAttributes() ?>>
<?= $Grid->spl_ins->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_spl_ins" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_spl_ins" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_spl_ins" value="<?= HtmlEncode($Grid->spl_ins->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_spl_ins" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_spl_ins" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_spl_ins" value="<?= HtmlEncode($Grid->spl_ins->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Grid->packing_type->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_packing_type" class="el_partner_product_ref_packing_type">
    <select
        id="x<?= $Grid->RowIndex ?>_packing_type"
        name="x<?= $Grid->RowIndex ?>_packing_type"
        class="form-select ew-select<?= $Grid->packing_type->isInvalidClass() ?>"
        <?php if (!$Grid->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_packing_type"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_packing_type"
        data-value-separator="<?= $Grid->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->packing_type->getPlaceHolder()) ?>"
        <?= $Grid->packing_type->editAttributes() ?>>
        <?= $Grid->packing_type->selectOptionListHtml("x{$Grid->RowIndex}_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->packing_type->getErrorMessage() ?></div>
<?= $Grid->packing_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_packing_type") ?>
<?php if (!$Grid->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_packing_type", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_packing_type" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_packing_type" id="o<?= $Grid->RowIndex ?>_packing_type" value="<?= HtmlEncode($Grid->packing_type->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_packing_type" class="el_partner_product_ref_packing_type">
    <select
        id="x<?= $Grid->RowIndex ?>_packing_type"
        name="x<?= $Grid->RowIndex ?>_packing_type"
        class="form-select ew-select<?= $Grid->packing_type->isInvalidClass() ?>"
        <?php if (!$Grid->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_packing_type"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_packing_type"
        data-value-separator="<?= $Grid->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->packing_type->getPlaceHolder()) ?>"
        <?= $Grid->packing_type->editAttributes() ?>>
        <?= $Grid->packing_type->selectOptionListHtml("x{$Grid->RowIndex}_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->packing_type->getErrorMessage() ?></div>
<?= $Grid->packing_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_packing_type") ?>
<?php if (!$Grid->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_packing_type", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_packing_type" class="el_partner_product_ref_packing_type">
<span<?= $Grid->packing_type->viewAttributes() ?>>
<?= $Grid->packing_type->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_packing_type" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_packing_type" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_packing_type" value="<?= HtmlEncode($Grid->packing_type->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_packing_type" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_packing_type" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_packing_type" value="<?= HtmlEncode($Grid->packing_type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Grid->batch_no->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_batch_no" class="el_partner_product_ref_batch_no">
<?php
if (IsRTL()) {
    $Grid->batch_no->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_batch_no" class="ew-auto-suggest">
    <input type="<?= $Grid->batch_no->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_batch_no" id="sv_x<?= $Grid->RowIndex ?>_batch_no" value="<?= RemoveHtml($Grid->batch_no->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->batch_no->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->batch_no->formatPattern()) ?>"<?= $Grid->batch_no->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="partner_product_ref" data-field="x_batch_no" data-input="sv_x<?= $Grid->RowIndex ?>_batch_no" data-value-separator="<?= $Grid->batch_no->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_batch_no" id="x<?= $Grid->RowIndex ?>_batch_no" value="<?= HtmlEncode($Grid->batch_no->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->batch_no->getErrorMessage() ?></div>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    fpartner_product_refgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_batch_no","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->batch_no->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.partner_product_ref.fields.batch_no.autoSuggestOptions));
});
</script>
<?= $Grid->batch_no->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_batch_no") ?>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_batch_no" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_batch_no" id="o<?= $Grid->RowIndex ?>_batch_no" value="<?= HtmlEncode($Grid->batch_no->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_batch_no" class="el_partner_product_ref_batch_no">
<?php
if (IsRTL()) {
    $Grid->batch_no->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_batch_no" class="ew-auto-suggest">
    <input type="<?= $Grid->batch_no->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_batch_no" id="sv_x<?= $Grid->RowIndex ?>_batch_no" value="<?= RemoveHtml($Grid->batch_no->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->batch_no->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->batch_no->formatPattern()) ?>"<?= $Grid->batch_no->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="partner_product_ref" data-field="x_batch_no" data-input="sv_x<?= $Grid->RowIndex ?>_batch_no" data-value-separator="<?= $Grid->batch_no->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_batch_no" id="x<?= $Grid->RowIndex ?>_batch_no" value="<?= HtmlEncode($Grid->batch_no->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->batch_no->getErrorMessage() ?></div>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    fpartner_product_refgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_batch_no","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->batch_no->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.partner_product_ref.fields.batch_no.autoSuggestOptions));
});
</script>
<?= $Grid->batch_no->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_batch_no") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_batch_no" class="el_partner_product_ref_batch_no">
<span<?= $Grid->batch_no->viewAttributes() ?>>
<?= $Grid->batch_no->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_batch_no" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_batch_no" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_batch_no" value="<?= HtmlEncode($Grid->batch_no->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_batch_no" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_batch_no" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_batch_no" value="<?= HtmlEncode($Grid->batch_no->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->shape->Visible) { // shape ?>
        <td data-name="shape"<?= $Grid->shape->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_shape" class="el_partner_product_ref_shape">
    <select
        id="x<?= $Grid->RowIndex ?>_shape"
        name="x<?= $Grid->RowIndex ?>_shape"
        class="form-select ew-select<?= $Grid->shape->isInvalidClass() ?>"
        <?php if (!$Grid->shape->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_shape"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_shape"
        data-value-separator="<?= $Grid->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->shape->getPlaceHolder()) ?>"
        <?= $Grid->shape->editAttributes() ?>>
        <?= $Grid->shape->selectOptionListHtml("x{$Grid->RowIndex}_shape") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->shape->getErrorMessage() ?></div>
<?= $Grid->shape->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_shape") ?>
<?php if (!$Grid->shape->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_shape", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_shape" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.shape?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_shape", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_shape", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.shape.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_shape" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_shape" id="o<?= $Grid->RowIndex ?>_shape" value="<?= HtmlEncode($Grid->shape->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_shape" class="el_partner_product_ref_shape">
    <select
        id="x<?= $Grid->RowIndex ?>_shape"
        name="x<?= $Grid->RowIndex ?>_shape"
        class="form-select ew-select<?= $Grid->shape->isInvalidClass() ?>"
        <?php if (!$Grid->shape->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_shape"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_shape"
        data-value-separator="<?= $Grid->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->shape->getPlaceHolder()) ?>"
        <?= $Grid->shape->editAttributes() ?>>
        <?= $Grid->shape->selectOptionListHtml("x{$Grid->RowIndex}_shape") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->shape->getErrorMessage() ?></div>
<?= $Grid->shape->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_shape") ?>
<?php if (!$Grid->shape->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_shape", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_shape" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.shape?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_shape", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_shape", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.shape.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_shape" class="el_partner_product_ref_shape">
<span<?= $Grid->shape->viewAttributes() ?>>
<?= $Grid->shape->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_shape" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_shape" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_shape" value="<?= HtmlEncode($Grid->shape->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_shape" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_shape" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_shape" value="<?= HtmlEncode($Grid->shape->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->unit->Visible) { // unit ?>
        <td data-name="unit"<?= $Grid->unit->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_unit" class="el_partner_product_ref_unit">
    <select
        id="x<?= $Grid->RowIndex ?>_unit"
        name="x<?= $Grid->RowIndex ?>_unit"
        class="form-select ew-select<?= $Grid->unit->isInvalidClass() ?>"
        <?php if (!$Grid->unit->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_unit"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_unit"
        data-value-separator="<?= $Grid->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->unit->getPlaceHolder()) ?>"
        <?= $Grid->unit->editAttributes() ?>>
        <?= $Grid->unit->selectOptionListHtml("x{$Grid->RowIndex}_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->unit->getErrorMessage() ?></div>
<?php if (!$Grid->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_unit", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.unit?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_unit", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_unit", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_unit" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_unit" id="o<?= $Grid->RowIndex ?>_unit" value="<?= HtmlEncode($Grid->unit->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_unit" class="el_partner_product_ref_unit">
    <select
        id="x<?= $Grid->RowIndex ?>_unit"
        name="x<?= $Grid->RowIndex ?>_unit"
        class="form-select ew-select<?= $Grid->unit->isInvalidClass() ?>"
        <?php if (!$Grid->unit->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_unit"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_unit"
        data-value-separator="<?= $Grid->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->unit->getPlaceHolder()) ?>"
        <?= $Grid->unit->editAttributes() ?>>
        <?= $Grid->unit->selectOptionListHtml("x{$Grid->RowIndex}_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->unit->getErrorMessage() ?></div>
<?php if (!$Grid->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_unit", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.unit?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_unit", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_unit", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_unit" class="el_partner_product_ref_unit">
<span<?= $Grid->unit->viewAttributes() ?>>
<?php if (!EmptyString($Grid->unit->getViewValue()) && $Grid->unit->linkAttributes() != "") { ?>
<a<?= $Grid->unit->linkAttributes() ?>><?= $Grid->unit->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->unit->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_unit" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_unit" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_unit" value="<?= HtmlEncode($Grid->unit->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_unit" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_unit" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_unit" value="<?= HtmlEncode($Grid->unit->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->w->Visible) { // w ?>
        <td data-name="w"<?= $Grid->w->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_w" class="el_partner_product_ref_w">
<input type="<?= $Grid->w->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_w" id="x<?= $Grid->RowIndex ?>_w" data-table="partner_product_ref" data-field="x_w" value="<?= $Grid->w->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->w->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->w->formatPattern()) ?>"<?= $Grid->w->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->w->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_w" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_w" id="o<?= $Grid->RowIndex ?>_w" value="<?= HtmlEncode($Grid->w->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_w" class="el_partner_product_ref_w">
<input type="<?= $Grid->w->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_w" id="x<?= $Grid->RowIndex ?>_w" data-table="partner_product_ref" data-field="x_w" value="<?= $Grid->w->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->w->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->w->formatPattern()) ?>"<?= $Grid->w->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->w->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_w" class="el_partner_product_ref_w">
<span<?= $Grid->w->viewAttributes() ?>>
<?= $Grid->w->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_w" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_w" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_w" value="<?= HtmlEncode($Grid->w->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_w" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_w" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_w" value="<?= HtmlEncode($Grid->w->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->w_cm->Visible) { // w_cm ?>
        <td data-name="w_cm"<?= $Grid->w_cm->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_w_cm" class="el_partner_product_ref_w_cm">
<input type="<?= $Grid->w_cm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_w_cm" id="x<?= $Grid->RowIndex ?>_w_cm" data-table="partner_product_ref" data-field="x_w_cm" value="<?= $Grid->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->w_cm->formatPattern()) ?>"<?= $Grid->w_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->w_cm->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_w_cm" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_w_cm" id="o<?= $Grid->RowIndex ?>_w_cm" value="<?= HtmlEncode($Grid->w_cm->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_w_cm" class="el_partner_product_ref_w_cm">
<input type="<?= $Grid->w_cm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_w_cm" id="x<?= $Grid->RowIndex ?>_w_cm" data-table="partner_product_ref" data-field="x_w_cm" value="<?= $Grid->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->w_cm->formatPattern()) ?>"<?= $Grid->w_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->w_cm->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_w_cm" class="el_partner_product_ref_w_cm">
<span<?= $Grid->w_cm->viewAttributes() ?>>
<?= $Grid->w_cm->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_w_cm" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_w_cm" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_w_cm" value="<?= HtmlEncode($Grid->w_cm->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_w_cm" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_w_cm" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_w_cm" value="<?= HtmlEncode($Grid->w_cm->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->l->Visible) { // l ?>
        <td data-name="l"<?= $Grid->l->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_l" class="el_partner_product_ref_l">
<input type="<?= $Grid->l->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_l" id="x<?= $Grid->RowIndex ?>_l" data-table="partner_product_ref" data-field="x_l" value="<?= $Grid->l->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->l->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->l->formatPattern()) ?>"<?= $Grid->l->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->l->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_l" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_l" id="o<?= $Grid->RowIndex ?>_l" value="<?= HtmlEncode($Grid->l->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_l" class="el_partner_product_ref_l">
<input type="<?= $Grid->l->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_l" id="x<?= $Grid->RowIndex ?>_l" data-table="partner_product_ref" data-field="x_l" value="<?= $Grid->l->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->l->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->l->formatPattern()) ?>"<?= $Grid->l->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->l->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_l" class="el_partner_product_ref_l">
<span<?= $Grid->l->viewAttributes() ?>>
<?= $Grid->l->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_l" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_l" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_l" value="<?= HtmlEncode($Grid->l->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_l" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_l" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_l" value="<?= HtmlEncode($Grid->l->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->l_cm->Visible) { // l_cm ?>
        <td data-name="l_cm"<?= $Grid->l_cm->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_l_cm" class="el_partner_product_ref_l_cm">
<input type="<?= $Grid->l_cm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_l_cm" id="x<?= $Grid->RowIndex ?>_l_cm" data-table="partner_product_ref" data-field="x_l_cm" value="<?= $Grid->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->l_cm->formatPattern()) ?>"<?= $Grid->l_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->l_cm->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_l_cm" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_l_cm" id="o<?= $Grid->RowIndex ?>_l_cm" value="<?= HtmlEncode($Grid->l_cm->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_l_cm" class="el_partner_product_ref_l_cm">
<input type="<?= $Grid->l_cm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_l_cm" id="x<?= $Grid->RowIndex ?>_l_cm" data-table="partner_product_ref" data-field="x_l_cm" value="<?= $Grid->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->l_cm->formatPattern()) ?>"<?= $Grid->l_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->l_cm->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_l_cm" class="el_partner_product_ref_l_cm">
<span<?= $Grid->l_cm->viewAttributes() ?>>
<?= $Grid->l_cm->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_l_cm" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_l_cm" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_l_cm" value="<?= HtmlEncode($Grid->l_cm->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_l_cm" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_l_cm" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_l_cm" value="<?= HtmlEncode($Grid->l_cm->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->h->Visible) { // h ?>
        <td data-name="h"<?= $Grid->h->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_h" class="el_partner_product_ref_h">
<input type="<?= $Grid->h->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_h" id="x<?= $Grid->RowIndex ?>_h" data-table="partner_product_ref" data-field="x_h" value="<?= $Grid->h->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->h->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->h->formatPattern()) ?>"<?= $Grid->h->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->h->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_h" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_h" id="o<?= $Grid->RowIndex ?>_h" value="<?= HtmlEncode($Grid->h->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_h" class="el_partner_product_ref_h">
<input type="<?= $Grid->h->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_h" id="x<?= $Grid->RowIndex ?>_h" data-table="partner_product_ref" data-field="x_h" value="<?= $Grid->h->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->h->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->h->formatPattern()) ?>"<?= $Grid->h->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->h->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_h" class="el_partner_product_ref_h">
<span<?= $Grid->h->viewAttributes() ?>>
<?= $Grid->h->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_h" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_h" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_h" value="<?= HtmlEncode($Grid->h->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_h" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_h" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_h" value="<?= HtmlEncode($Grid->h->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->h_cm->Visible) { // h_cm ?>
        <td data-name="h_cm"<?= $Grid->h_cm->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_h_cm" class="el_partner_product_ref_h_cm">
<input type="<?= $Grid->h_cm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_h_cm" id="x<?= $Grid->RowIndex ?>_h_cm" data-table="partner_product_ref" data-field="x_h_cm" value="<?= $Grid->h_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->h_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->h_cm->formatPattern()) ?>"<?= $Grid->h_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->h_cm->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_h_cm" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_h_cm" id="o<?= $Grid->RowIndex ?>_h_cm" value="<?= HtmlEncode($Grid->h_cm->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_h_cm" class="el_partner_product_ref_h_cm">
<input type="<?= $Grid->h_cm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_h_cm" id="x<?= $Grid->RowIndex ?>_h_cm" data-table="partner_product_ref" data-field="x_h_cm" value="<?= $Grid->h_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->h_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->h_cm->formatPattern()) ?>"<?= $Grid->h_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->h_cm->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_h_cm" class="el_partner_product_ref_h_cm">
<span<?= $Grid->h_cm->viewAttributes() ?>>
<?= $Grid->h_cm->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_h_cm" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_h_cm" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_h_cm" value="<?= HtmlEncode($Grid->h_cm->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_h_cm" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_h_cm" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_h_cm" value="<?= HtmlEncode($Grid->h_cm->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->partner_size->Visible) { // partner_size ?>
        <td data-name="partner_size"<?= $Grid->partner_size->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner_size" class="el_partner_product_ref_partner_size">
<input type="<?= $Grid->partner_size->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_partner_size" id="x<?= $Grid->RowIndex ?>_partner_size" data-table="partner_product_ref" data-field="x_partner_size" value="<?= $Grid->partner_size->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Grid->partner_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->partner_size->formatPattern()) ?>"<?= $Grid->partner_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->partner_size->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_partner_size" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_partner_size" id="o<?= $Grid->RowIndex ?>_partner_size" value="<?= HtmlEncode($Grid->partner_size->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner_size" class="el_partner_product_ref_partner_size">
<input type="<?= $Grid->partner_size->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_partner_size" id="x<?= $Grid->RowIndex ?>_partner_size" data-table="partner_product_ref" data-field="x_partner_size" value="<?= $Grid->partner_size->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Grid->partner_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->partner_size->formatPattern()) ?>"<?= $Grid->partner_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->partner_size->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_partner_size" class="el_partner_product_ref_partner_size">
<span<?= $Grid->partner_size->viewAttributes() ?>>
<?= $Grid->partner_size->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_partner_size" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_partner_size" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_partner_size" value="<?= HtmlEncode($Grid->partner_size->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_partner_size" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_partner_size" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_partner_size" value="<?= HtmlEncode($Grid->partner_size->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Grid->sqm->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_sqm" class="el_partner_product_ref_sqm">
<input type="<?= $Grid->sqm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_sqm" id="x<?= $Grid->RowIndex ?>_sqm" data-table="partner_product_ref" data-field="x_sqm" value="<?= $Grid->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->sqm->formatPattern()) ?>"<?= $Grid->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->sqm->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_sqm" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_sqm" id="o<?= $Grid->RowIndex ?>_sqm" value="<?= HtmlEncode($Grid->sqm->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_sqm" class="el_partner_product_ref_sqm">
<input type="<?= $Grid->sqm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_sqm" id="x<?= $Grid->RowIndex ?>_sqm" data-table="partner_product_ref" data-field="x_sqm" value="<?= $Grid->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->sqm->formatPattern()) ?>"<?= $Grid->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->sqm->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_sqm" class="el_partner_product_ref_sqm">
<span<?= $Grid->sqm->viewAttributes() ?>>
<?= $Grid->sqm->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_sqm" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_sqm" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_sqm" value="<?= HtmlEncode($Grid->sqm->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_sqm" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_sqm" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_sqm" value="<?= HtmlEncode($Grid->sqm->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->cbm->Visible) { // cbm ?>
        <td data-name="cbm"<?= $Grid->cbm->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_cbm" class="el_partner_product_ref_cbm">
<input type="<?= $Grid->cbm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_cbm" id="x<?= $Grid->RowIndex ?>_cbm" data-table="partner_product_ref" data-field="x_cbm" value="<?= $Grid->cbm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->cbm->formatPattern()) ?>"<?= $Grid->cbm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->cbm->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_cbm" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_cbm" id="o<?= $Grid->RowIndex ?>_cbm" value="<?= HtmlEncode($Grid->cbm->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_cbm" class="el_partner_product_ref_cbm">
<input type="<?= $Grid->cbm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_cbm" id="x<?= $Grid->RowIndex ?>_cbm" data-table="partner_product_ref" data-field="x_cbm" value="<?= $Grid->cbm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->cbm->formatPattern()) ?>"<?= $Grid->cbm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->cbm->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_cbm" class="el_partner_product_ref_cbm">
<span<?= $Grid->cbm->viewAttributes() ?>>
<?= $Grid->cbm->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_cbm" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_cbm" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_cbm" value="<?= HtmlEncode($Grid->cbm->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_cbm" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_cbm" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_cbm" value="<?= HtmlEncode($Grid->cbm->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->weight_sqm->Visible) { // weight_sqm ?>
        <td data-name="weight_sqm"<?= $Grid->weight_sqm->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_weight_sqm" class="el_partner_product_ref_weight_sqm">
<input type="<?= $Grid->weight_sqm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_weight_sqm" id="x<?= $Grid->RowIndex ?>_weight_sqm" data-table="partner_product_ref" data-field="x_weight_sqm" value="<?= $Grid->weight_sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->weight_sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->weight_sqm->formatPattern()) ?>"<?= $Grid->weight_sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->weight_sqm->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_weight_sqm" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_weight_sqm" id="o<?= $Grid->RowIndex ?>_weight_sqm" value="<?= HtmlEncode($Grid->weight_sqm->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_weight_sqm" class="el_partner_product_ref_weight_sqm">
<input type="<?= $Grid->weight_sqm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_weight_sqm" id="x<?= $Grid->RowIndex ?>_weight_sqm" data-table="partner_product_ref" data-field="x_weight_sqm" value="<?= $Grid->weight_sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->weight_sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->weight_sqm->formatPattern()) ?>"<?= $Grid->weight_sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->weight_sqm->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_weight_sqm" class="el_partner_product_ref_weight_sqm">
<span<?= $Grid->weight_sqm->viewAttributes() ?>>
<?= $Grid->weight_sqm->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_weight_sqm" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_weight_sqm" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_weight_sqm" value="<?= HtmlEncode($Grid->weight_sqm->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_weight_sqm" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_weight_sqm" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_weight_sqm" value="<?= HtmlEncode($Grid->weight_sqm->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->sqm_a->Visible) { // sqm_a ?>
        <td data-name="sqm_a"<?= $Grid->sqm_a->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_sqm_a" class="el_partner_product_ref_sqm_a">
<input type="<?= $Grid->sqm_a->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_sqm_a" id="x<?= $Grid->RowIndex ?>_sqm_a" data-table="partner_product_ref" data-field="x_sqm_a" value="<?= $Grid->sqm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->sqm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->sqm_a->formatPattern()) ?>"<?= $Grid->sqm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->sqm_a->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_sqm_a" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_sqm_a" id="o<?= $Grid->RowIndex ?>_sqm_a" value="<?= HtmlEncode($Grid->sqm_a->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_sqm_a" class="el_partner_product_ref_sqm_a">
<input type="<?= $Grid->sqm_a->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_sqm_a" id="x<?= $Grid->RowIndex ?>_sqm_a" data-table="partner_product_ref" data-field="x_sqm_a" value="<?= $Grid->sqm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->sqm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->sqm_a->formatPattern()) ?>"<?= $Grid->sqm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->sqm_a->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_sqm_a" class="el_partner_product_ref_sqm_a">
<span<?= $Grid->sqm_a->viewAttributes() ?>>
<?= $Grid->sqm_a->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_sqm_a" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_sqm_a" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_sqm_a" value="<?= HtmlEncode($Grid->sqm_a->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_sqm_a" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_sqm_a" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_sqm_a" value="<?= HtmlEncode($Grid->sqm_a->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_2srm_a->Visible) { // 2srm_a ?>
        <td data-name="_2srm_a"<?= $Grid->_2srm_a->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref__2srm_a" class="el_partner_product_ref__2srm_a">
<input type="<?= $Grid->_2srm_a->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__2srm_a" id="x<?= $Grid->RowIndex ?>__2srm_a" data-table="partner_product_ref" data-field="x__2srm_a" value="<?= $Grid->_2srm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->_2srm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_2srm_a->formatPattern()) ?>"<?= $Grid->_2srm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_2srm_a->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x__2srm_a" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__2srm_a" id="o<?= $Grid->RowIndex ?>__2srm_a" value="<?= HtmlEncode($Grid->_2srm_a->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref__2srm_a" class="el_partner_product_ref__2srm_a">
<input type="<?= $Grid->_2srm_a->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__2srm_a" id="x<?= $Grid->RowIndex ?>__2srm_a" data-table="partner_product_ref" data-field="x__2srm_a" value="<?= $Grid->_2srm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->_2srm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_2srm_a->formatPattern()) ?>"<?= $Grid->_2srm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_2srm_a->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref__2srm_a" class="el_partner_product_ref__2srm_a">
<span<?= $Grid->_2srm_a->viewAttributes() ?>>
<?= $Grid->_2srm_a->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x__2srm_a" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>__2srm_a" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>__2srm_a" value="<?= HtmlEncode($Grid->_2srm_a->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x__2srm_a" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>__2srm_a" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>__2srm_a" value="<?= HtmlEncode($Grid->_2srm_a->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_4srm_a->Visible) { // 4srm_a ?>
        <td data-name="_4srm_a"<?= $Grid->_4srm_a->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref__4srm_a" class="el_partner_product_ref__4srm_a">
<input type="<?= $Grid->_4srm_a->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__4srm_a" id="x<?= $Grid->RowIndex ?>__4srm_a" data-table="partner_product_ref" data-field="x__4srm_a" value="<?= $Grid->_4srm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->_4srm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_4srm_a->formatPattern()) ?>"<?= $Grid->_4srm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_4srm_a->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x__4srm_a" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__4srm_a" id="o<?= $Grid->RowIndex ?>__4srm_a" value="<?= HtmlEncode($Grid->_4srm_a->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref__4srm_a" class="el_partner_product_ref__4srm_a">
<input type="<?= $Grid->_4srm_a->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__4srm_a" id="x<?= $Grid->RowIndex ?>__4srm_a" data-table="partner_product_ref" data-field="x__4srm_a" value="<?= $Grid->_4srm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->_4srm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_4srm_a->formatPattern()) ?>"<?= $Grid->_4srm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_4srm_a->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref__4srm_a" class="el_partner_product_ref__4srm_a">
<span<?= $Grid->_4srm_a->viewAttributes() ?>>
<?= $Grid->_4srm_a->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x__4srm_a" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>__4srm_a" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>__4srm_a" value="<?= HtmlEncode($Grid->_4srm_a->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x__4srm_a" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>__4srm_a" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>__4srm_a" value="<?= HtmlEncode($Grid->_4srm_a->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->price->Visible) { // price ?>
        <td data-name="price"<?= $Grid->price->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_price" class="el_partner_product_ref_price">
<input type="<?= $Grid->price->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_price" id="x<?= $Grid->RowIndex ?>_price" data-table="partner_product_ref" data-field="x_price" value="<?= $Grid->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->price->formatPattern()) ?>"<?= $Grid->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->price->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_price" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_price" id="o<?= $Grid->RowIndex ?>_price" value="<?= HtmlEncode($Grid->price->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_price" class="el_partner_product_ref_price">
<input type="<?= $Grid->price->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_price" id="x<?= $Grid->RowIndex ?>_price" data-table="partner_product_ref" data-field="x_price" value="<?= $Grid->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->price->formatPattern()) ?>"<?= $Grid->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->price->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_price" class="el_partner_product_ref_price">
<span<?= $Grid->price->viewAttributes() ?>>
<?= $Grid->price->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_price" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_price" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_price" value="<?= HtmlEncode($Grid->price->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_price" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_price" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_price" value="<?= HtmlEncode($Grid->price->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->price_cs->Visible) { // price_cs ?>
        <td data-name="price_cs"<?= $Grid->price_cs->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_price_cs" class="el_partner_product_ref_price_cs">
<input type="<?= $Grid->price_cs->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_price_cs" id="x<?= $Grid->RowIndex ?>_price_cs" data-table="partner_product_ref" data-field="x_price_cs" value="<?= $Grid->price_cs->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->price_cs->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->price_cs->formatPattern()) ?>"<?= $Grid->price_cs->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->price_cs->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_price_cs" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_price_cs" id="o<?= $Grid->RowIndex ?>_price_cs" value="<?= HtmlEncode($Grid->price_cs->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_price_cs" class="el_partner_product_ref_price_cs">
<input type="<?= $Grid->price_cs->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_price_cs" id="x<?= $Grid->RowIndex ?>_price_cs" data-table="partner_product_ref" data-field="x_price_cs" value="<?= $Grid->price_cs->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->price_cs->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->price_cs->formatPattern()) ?>"<?= $Grid->price_cs->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->price_cs->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_price_cs" class="el_partner_product_ref_price_cs">
<span<?= $Grid->price_cs->viewAttributes() ?>>
<?= $Grid->price_cs->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_price_cs" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_price_cs" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_price_cs" value="<?= HtmlEncode($Grid->price_cs->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_price_cs" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_price_cs" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_price_cs" value="<?= HtmlEncode($Grid->price_cs->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->currency->Visible) { // currency ?>
        <td data-name="currency"<?= $Grid->currency->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_currency" class="el_partner_product_ref_currency">
    <select
        id="x<?= $Grid->RowIndex ?>_currency"
        name="x<?= $Grid->RowIndex ?>_currency"
        class="form-select ew-select<?= $Grid->currency->isInvalidClass() ?>"
        <?php if (!$Grid->currency->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_currency"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_currency"
        data-value-separator="<?= $Grid->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->currency->getPlaceHolder()) ?>"
        <?= $Grid->currency->editAttributes() ?>>
        <?= $Grid->currency->selectOptionListHtml("x{$Grid->RowIndex}_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->currency->getErrorMessage() ?></div>
<?= $Grid->currency->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_currency") ?>
<?php if (!$Grid->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_currency", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.currency?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_currency", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_currency", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_currency" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_currency" id="o<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_currency" class="el_partner_product_ref_currency">
    <select
        id="x<?= $Grid->RowIndex ?>_currency"
        name="x<?= $Grid->RowIndex ?>_currency"
        class="form-select ew-select<?= $Grid->currency->isInvalidClass() ?>"
        <?php if (!$Grid->currency->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_currency"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_currency"
        data-value-separator="<?= $Grid->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->currency->getPlaceHolder()) ?>"
        <?= $Grid->currency->editAttributes() ?>>
        <?= $Grid->currency->selectOptionListHtml("x{$Grid->RowIndex}_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->currency->getErrorMessage() ?></div>
<?= $Grid->currency->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_currency") ?>
<?php if (!$Grid->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_currency", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.currency?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_currency", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_currency", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_currency" class="el_partner_product_ref_currency">
<span<?= $Grid->currency->viewAttributes() ?>>
<?= $Grid->currency->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_currency" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_currency" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_currency" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_currency" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->hsn->Visible) { // hsn ?>
        <td data-name="hsn"<?= $Grid->hsn->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_hsn" class="el_partner_product_ref_hsn">
    <select
        id="x<?= $Grid->RowIndex ?>_hsn"
        name="x<?= $Grid->RowIndex ?>_hsn"
        class="form-select ew-select<?= $Grid->hsn->isInvalidClass() ?>"
        <?php if (!$Grid->hsn->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_hsn"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_hsn"
        data-value-separator="<?= $Grid->hsn->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->hsn->getPlaceHolder()) ?>"
        <?= $Grid->hsn->editAttributes() ?>>
        <?= $Grid->hsn->selectOptionListHtml("x{$Grid->RowIndex}_hsn") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->hsn->getErrorMessage() ?></div>
<?= $Grid->hsn->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_hsn") ?>
<?php if (!$Grid->hsn->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_hsn", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_hsn" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.hsn?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_hsn", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_hsn", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.hsn.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_hsn" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_hsn" id="o<?= $Grid->RowIndex ?>_hsn" value="<?= HtmlEncode($Grid->hsn->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_hsn" class="el_partner_product_ref_hsn">
    <select
        id="x<?= $Grid->RowIndex ?>_hsn"
        name="x<?= $Grid->RowIndex ?>_hsn"
        class="form-select ew-select<?= $Grid->hsn->isInvalidClass() ?>"
        <?php if (!$Grid->hsn->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_hsn"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_hsn"
        data-value-separator="<?= $Grid->hsn->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->hsn->getPlaceHolder()) ?>"
        <?= $Grid->hsn->editAttributes() ?>>
        <?= $Grid->hsn->selectOptionListHtml("x{$Grid->RowIndex}_hsn") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->hsn->getErrorMessage() ?></div>
<?= $Grid->hsn->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_hsn") ?>
<?php if (!$Grid->hsn->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_hsn", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_hsn" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.hsn?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_hsn", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_hsn", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.hsn.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_hsn" class="el_partner_product_ref_hsn">
<span<?= $Grid->hsn->viewAttributes() ?>>
<?= $Grid->hsn->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_hsn" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_hsn" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_hsn" value="<?= HtmlEncode($Grid->hsn->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_hsn" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_hsn" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_hsn" value="<?= HtmlEncode($Grid->hsn->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->composition->Visible) { // composition ?>
        <td data-name="composition"<?= $Grid->composition->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_composition" class="el_partner_product_ref_composition">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_composition"
        name="x<?= $Grid->RowIndex ?>_composition"
        class="form-select ew-select<?= $Grid->composition->isInvalidClass() ?>"
        <?php if (!$Grid->composition->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_composition"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_composition"
        data-value-separator="<?= $Grid->composition->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->composition->getPlaceHolder()) ?>"
        <?= $Grid->composition->editAttributes() ?>>
        <?= $Grid->composition->selectOptionListHtml("x{$Grid->RowIndex}_composition") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "composition") && !$Grid->composition->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_composition" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->composition->caption() ?>" data-title="<?= $Grid->composition->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_composition" data-url="<?= GetUrl("compositionaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->composition->getErrorMessage() ?></div>
<?= $Grid->composition->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_composition") ?>
<?php if (!$Grid->composition->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_composition", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_composition" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.composition?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_composition", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_composition", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.composition.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_composition" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_composition" id="o<?= $Grid->RowIndex ?>_composition" value="<?= HtmlEncode($Grid->composition->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_composition" class="el_partner_product_ref_composition">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_composition"
        name="x<?= $Grid->RowIndex ?>_composition"
        class="form-select ew-select<?= $Grid->composition->isInvalidClass() ?>"
        <?php if (!$Grid->composition->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_composition"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_composition"
        data-value-separator="<?= $Grid->composition->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->composition->getPlaceHolder()) ?>"
        <?= $Grid->composition->editAttributes() ?>>
        <?= $Grid->composition->selectOptionListHtml("x{$Grid->RowIndex}_composition") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "composition") && !$Grid->composition->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_composition" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->composition->caption() ?>" data-title="<?= $Grid->composition->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_composition" data-url="<?= GetUrl("compositionaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->composition->getErrorMessage() ?></div>
<?= $Grid->composition->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_composition") ?>
<?php if (!$Grid->composition->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_composition", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_composition" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.composition?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_composition", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_composition", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.composition.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_composition" class="el_partner_product_ref_composition">
<span<?= $Grid->composition->viewAttributes() ?>>
<?= $Grid->composition->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_composition" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_composition" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_composition" value="<?= HtmlEncode($Grid->composition->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_composition" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_composition" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_composition" value="<?= HtmlEncode($Grid->composition->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->status->Visible) { // status ?>
        <td data-name="status"<?= $Grid->status->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_status" class="el_partner_product_ref_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_status" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_status" id="o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_status" class="el_partner_product_ref_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="partner_product_ref"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_product_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "fpartner_product_refgrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_product_refgrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "fpartner_product_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "fpartner_product_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_product_ref.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_status" class="el_partner_product_ref_status">
<span<?= $Grid->status->viewAttributes() ?>>
<?= $Grid->status->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_status" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_status" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_status" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_status" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_operator" class="el_partner_product_ref_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_operator" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_operator" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_operator" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_operator" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_datetime" class="el_partner_product_ref_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_datetime" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_datetime" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_datetime" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_datetime" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->d_01->Visible) { // d_01 ?>
        <td data-name="d_01"<?= $Grid->d_01->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_01" class="el_partner_product_ref_d_01">
<input type="<?= $Grid->d_01->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_d_01" id="x<?= $Grid->RowIndex ?>_d_01" data-table="partner_product_ref" data-field="x_d_01" value="<?= $Grid->d_01->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->d_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->d_01->formatPattern()) ?>"<?= $Grid->d_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->d_01->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_d_01" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_d_01" id="o<?= $Grid->RowIndex ?>_d_01" value="<?= HtmlEncode($Grid->d_01->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_01" class="el_partner_product_ref_d_01">
<input type="<?= $Grid->d_01->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_d_01" id="x<?= $Grid->RowIndex ?>_d_01" data-table="partner_product_ref" data-field="x_d_01" value="<?= $Grid->d_01->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->d_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->d_01->formatPattern()) ?>"<?= $Grid->d_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->d_01->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_01" class="el_partner_product_ref_d_01">
<span<?= $Grid->d_01->viewAttributes() ?>>
<?= $Grid->d_01->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_d_01" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_d_01" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_d_01" value="<?= HtmlEncode($Grid->d_01->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_d_01" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_d_01" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_d_01" value="<?= HtmlEncode($Grid->d_01->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->d_02->Visible) { // d_02 ?>
        <td data-name="d_02"<?= $Grid->d_02->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_02" class="el_partner_product_ref_d_02">
<input type="<?= $Grid->d_02->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_d_02" id="x<?= $Grid->RowIndex ?>_d_02" data-table="partner_product_ref" data-field="x_d_02" value="<?= $Grid->d_02->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->d_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->d_02->formatPattern()) ?>"<?= $Grid->d_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->d_02->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_d_02" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_d_02" id="o<?= $Grid->RowIndex ?>_d_02" value="<?= HtmlEncode($Grid->d_02->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_02" class="el_partner_product_ref_d_02">
<input type="<?= $Grid->d_02->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_d_02" id="x<?= $Grid->RowIndex ?>_d_02" data-table="partner_product_ref" data-field="x_d_02" value="<?= $Grid->d_02->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->d_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->d_02->formatPattern()) ?>"<?= $Grid->d_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->d_02->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_02" class="el_partner_product_ref_d_02">
<span<?= $Grid->d_02->viewAttributes() ?>>
<?= $Grid->d_02->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_d_02" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_d_02" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_d_02" value="<?= HtmlEncode($Grid->d_02->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_d_02" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_d_02" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_d_02" value="<?= HtmlEncode($Grid->d_02->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->d_03->Visible) { // d_03 ?>
        <td data-name="d_03"<?= $Grid->d_03->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_03" class="el_partner_product_ref_d_03">
<input type="<?= $Grid->d_03->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_d_03" id="x<?= $Grid->RowIndex ?>_d_03" data-table="partner_product_ref" data-field="x_d_03" value="<?= $Grid->d_03->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->d_03->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->d_03->formatPattern()) ?>"<?= $Grid->d_03->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->d_03->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_d_03" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_d_03" id="o<?= $Grid->RowIndex ?>_d_03" value="<?= HtmlEncode($Grid->d_03->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_03" class="el_partner_product_ref_d_03">
<input type="<?= $Grid->d_03->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_d_03" id="x<?= $Grid->RowIndex ?>_d_03" data-table="partner_product_ref" data-field="x_d_03" value="<?= $Grid->d_03->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->d_03->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->d_03->formatPattern()) ?>"<?= $Grid->d_03->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->d_03->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_03" class="el_partner_product_ref_d_03">
<span<?= $Grid->d_03->viewAttributes() ?>>
<?= $Grid->d_03->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_d_03" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_d_03" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_d_03" value="<?= HtmlEncode($Grid->d_03->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_d_03" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_d_03" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_d_03" value="<?= HtmlEncode($Grid->d_03->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->d_04->Visible) { // d_04 ?>
        <td data-name="d_04"<?= $Grid->d_04->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_04" class="el_partner_product_ref_d_04">
<input type="<?= $Grid->d_04->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_d_04" id="x<?= $Grid->RowIndex ?>_d_04" data-table="partner_product_ref" data-field="x_d_04" value="<?= $Grid->d_04->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->d_04->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->d_04->formatPattern()) ?>"<?= $Grid->d_04->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->d_04->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_d_04" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_d_04" id="o<?= $Grid->RowIndex ?>_d_04" value="<?= HtmlEncode($Grid->d_04->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_04" class="el_partner_product_ref_d_04">
<input type="<?= $Grid->d_04->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_d_04" id="x<?= $Grid->RowIndex ?>_d_04" data-table="partner_product_ref" data-field="x_d_04" value="<?= $Grid->d_04->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->d_04->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->d_04->formatPattern()) ?>"<?= $Grid->d_04->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->d_04->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_04" class="el_partner_product_ref_d_04">
<span<?= $Grid->d_04->viewAttributes() ?>>
<?= $Grid->d_04->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_d_04" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_d_04" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_d_04" value="<?= HtmlEncode($Grid->d_04->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_d_04" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_d_04" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_d_04" value="<?= HtmlEncode($Grid->d_04->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->d_05->Visible) { // d_05 ?>
        <td data-name="d_05"<?= $Grid->d_05->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_05" class="el_partner_product_ref_d_05">
<input type="<?= $Grid->d_05->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_d_05" id="x<?= $Grid->RowIndex ?>_d_05" data-table="partner_product_ref" data-field="x_d_05" value="<?= $Grid->d_05->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->d_05->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->d_05->formatPattern()) ?>"<?= $Grid->d_05->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->d_05->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_d_05" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_d_05" id="o<?= $Grid->RowIndex ?>_d_05" value="<?= HtmlEncode($Grid->d_05->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_05" class="el_partner_product_ref_d_05">
<input type="<?= $Grid->d_05->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_d_05" id="x<?= $Grid->RowIndex ?>_d_05" data-table="partner_product_ref" data-field="x_d_05" value="<?= $Grid->d_05->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->d_05->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->d_05->formatPattern()) ?>"<?= $Grid->d_05->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->d_05->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_05" class="el_partner_product_ref_d_05">
<span<?= $Grid->d_05->viewAttributes() ?>>
<?= $Grid->d_05->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_d_05" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_d_05" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_d_05" value="<?= HtmlEncode($Grid->d_05->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_d_05" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_d_05" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_d_05" value="<?= HtmlEncode($Grid->d_05->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->d_06->Visible) { // d_06 ?>
        <td data-name="d_06"<?= $Grid->d_06->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_06" class="el_partner_product_ref_d_06">
<input type="<?= $Grid->d_06->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_d_06" id="x<?= $Grid->RowIndex ?>_d_06" data-table="partner_product_ref" data-field="x_d_06" value="<?= $Grid->d_06->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->d_06->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->d_06->formatPattern()) ?>"<?= $Grid->d_06->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->d_06->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_d_06" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_d_06" id="o<?= $Grid->RowIndex ?>_d_06" value="<?= HtmlEncode($Grid->d_06->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_06" class="el_partner_product_ref_d_06">
<input type="<?= $Grid->d_06->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_d_06" id="x<?= $Grid->RowIndex ?>_d_06" data-table="partner_product_ref" data-field="x_d_06" value="<?= $Grid->d_06->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->d_06->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->d_06->formatPattern()) ?>"<?= $Grid->d_06->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->d_06->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_product_ref_d_06" class="el_partner_product_ref_d_06">
<span<?= $Grid->d_06->viewAttributes() ?>>
<?= $Grid->d_06->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_product_ref" data-field="x_d_06" data-hidden="1" name="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_d_06" id="fpartner_product_refgrid$x<?= $Grid->RowIndex ?>_d_06" value="<?= HtmlEncode($Grid->d_06->FormValue) ?>">
<input type="hidden" data-table="partner_product_ref" data-field="x_d_06" data-hidden="1" data-old name="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_d_06" id="fpartner_product_refgrid$o<?= $Grid->RowIndex ?>_d_06" value="<?= HtmlEncode($Grid->d_06->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fpartner_product_refgrid","load"], () => fpartner_product_refgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fpartner_product_refgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("partner_product_ref");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
