<?php

namespace PHPMaker2024\fibre;

// Page object
$PartnerBalanceSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { partner_balance: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpartner_balancesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpartner_balancesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["location", [], fields.location.isInvalid],
            ["partner_id", [ew.Validators.integer], fields.partner_id.isInvalid],
            ["y_partner_id", [ew.Validators.between], false],
            ["balance", [ew.Validators.float], fields.balance.isInvalid],
            ["receipt", [ew.Validators.float], fields.receipt.isInvalid],
            ["panel_amount", [ew.Validators.integer], fields.panel_amount.isInvalid],
            ["total_amount", [ew.Validators.float], fields.total_amount.isInvalid],
            ["ref", [], fields.ref.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "ref": <?= $Page->ref->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpartner_balancesearch" id="fpartner_balancesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="partner_balance">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_balance_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_balance_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fpartner_balancesearch_x_location"
        <?php } ?>
        data-table="partner_balance"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_balancesearch", function() {
    var options = { name: "x_location", selectId: "fpartner_balancesearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_balancesearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fpartner_balancesearch" };
    } else {
        options.ajax = { id: "x_location", form: "fpartner_balancesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_balance.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
    <div id="r_partner_id" class="row"<?= $Page->partner_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_balance_partner_id"><?= $Page->partner_id->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_partner_id" id="z_partner_id" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->partner_id->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->partner_id->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_partner_balance_partner_id" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->partner_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_partner_id" class="ew-auto-suggest">
    <input type="<?= $Page->partner_id->getInputTextType() ?>" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?= RemoveHtml($Page->partner_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_id->formatPattern()) ?>"<?= $Page->partner_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="partner_balance" data-field="x_partner_id" data-input="sv_x_partner_id" data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?= HtmlEncode($Page->partner_id->AdvancedSearch->SearchValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpartner_balancesearch", function() {
    fpartner_balancesearch.createAutoSuggest(Object.assign({"id":"x_partner_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->partner_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.partner_balance.fields.partner_id.autoSuggestOptions));
});
</script>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_partner_balance_partner_id" class="ew-search-field2 d-none">
<?php
if (IsRTL()) {
    $Page->partner_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_y_partner_id" class="ew-auto-suggest">
    <input type="<?= $Page->partner_id->getInputTextType() ?>" class="form-control" name="sv_y_partner_id" id="sv_y_partner_id" value="<?= RemoveHtml($Page->partner_id->EditValue2) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_id->formatPattern()) ?>"<?= $Page->partner_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="partner_balance" data-field="x_partner_id" data-input="sv_y_partner_id" data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>" name="y_partner_id" id="y_partner_id" value="<?= HtmlEncode($Page->partner_id->AdvancedSearch->SearchValue2) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpartner_balancesearch", function() {
    fpartner_balancesearch.createAutoSuggest(Object.assign({"id":"y_partner_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->partner_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.partner_balance.fields.partner_id.autoSuggestOptions));
});
</script>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_y_partner_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->balance->Visible) { // balance ?>
    <div id="r_balance" class="row"<?= $Page->balance->rowAttributes() ?>>
        <label for="x_balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_balance_balance"><?= $Page->balance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_balance" id="z_balance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_balance_balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->balance->getInputTextType() ?>" name="x_balance" id="x_balance" data-table="partner_balance" data-field="x_balance" value="<?= $Page->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->receipt->Visible) { // receipt ?>
    <div id="r_receipt" class="row"<?= $Page->receipt->rowAttributes() ?>>
        <label for="x_receipt" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_balance_receipt"><?= $Page->receipt->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_receipt" id="z_receipt" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->receipt->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_balance_receipt" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->receipt->getInputTextType() ?>" name="x_receipt" id="x_receipt" data-table="partner_balance" data-field="x_receipt" value="<?= $Page->receipt->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->receipt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->receipt->formatPattern()) ?>"<?= $Page->receipt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->receipt->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->panel_amount->Visible) { // panel_amount ?>
    <div id="r_panel_amount" class="row"<?= $Page->panel_amount->rowAttributes() ?>>
        <label for="x_panel_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_balance_panel_amount"><?= $Page->panel_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_panel_amount" id="z_panel_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->panel_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_balance_panel_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->panel_amount->getInputTextType() ?>" name="x_panel_amount" id="x_panel_amount" data-table="partner_balance" data-field="x_panel_amount" value="<?= $Page->panel_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->panel_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->panel_amount->formatPattern()) ?>"<?= $Page->panel_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->panel_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->total_amount->Visible) { // total_amount ?>
    <div id="r_total_amount" class="row"<?= $Page->total_amount->rowAttributes() ?>>
        <label for="x_total_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_balance_total_amount"><?= $Page->total_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_total_amount" id="z_total_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->total_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_balance_total_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->total_amount->getInputTextType() ?>" name="x_total_amount" id="x_total_amount" data-table="partner_balance" data-field="x_total_amount" value="<?= $Page->total_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->total_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->total_amount->formatPattern()) ?>"<?= $Page->total_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->total_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref" class="row"<?= $Page->ref->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_balance_ref"><?= $Page->ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ref" id="z_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_balance_ref" class="ew-search-field ew-search-field-single">
<template id="tp_x_ref">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="partner_balance" data-field="x_ref" name="x_ref" id="x_ref"<?= $Page->ref->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_ref" class="ew-item-list"></div>
<selection-list hidden
    id="x_ref"
    name="x_ref"
    value="<?= HtmlEncode($Page->ref->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_ref"
    data-target="dsl_x_ref"
    data-repeatcolumn="5"
    class="form-control<?= $Page->ref->isInvalidClass() ?>"
    data-table="partner_balance"
    data-field="x_ref"
    data-value-separator="<?= $Page->ref->displayValueSeparatorAttribute() ?>"
    <?= $Page->ref->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
<?= $Page->ref->Lookup->getParamTag($Page, "p_x_ref") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_partner_balance_dated"><?= $Page->dated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dated" id="z_dated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_partner_balance_dated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="partner_balance" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpartner_balancesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpartner_balancesearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpartner_balancesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpartner_balancesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpartner_balancesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("partner_balance");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
