<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("PartnerBalanceGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fpartner_balancegrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { partner_balance: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpartner_balancegrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["partner_id", [fields.partner_id.visible && fields.partner_id.required ? ew.Validators.required(fields.partner_id.caption) : null, ew.Validators.integer], fields.partner_id.isInvalid],
            ["balance", [fields.balance.visible && fields.balance.required ? ew.Validators.required(fields.balance.caption) : null, ew.Validators.float], fields.balance.isInvalid],
            ["receipt", [fields.receipt.visible && fields.receipt.required ? ew.Validators.required(fields.receipt.caption) : null, ew.Validators.float], fields.receipt.isInvalid],
            ["panel_amount", [fields.panel_amount.visible && fields.panel_amount.required ? ew.Validators.required(fields.panel_amount.caption) : null, ew.Validators.integer], fields.panel_amount.isInvalid],
            ["total_amount", [fields.total_amount.visible && fields.total_amount.required ? ew.Validators.required(fields.total_amount.caption) : null, ew.Validators.float], fields.total_amount.isInvalid],
            ["ref", [fields.ref.visible && fields.ref.required ? ew.Validators.required(fields.ref.caption) : null], fields.ref.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["location",false],["partner_id",false],["balance",false],["receipt",false],["panel_amount",false],["total_amount",false],["ref",false],["dated",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Grid->location->toClientList($Grid) ?>,
            "partner_id": <?= $Grid->partner_id->toClientList($Grid) ?>,
            "ref": <?= $Grid->ref->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fpartner_balancegrid" class="ew-form ew-list-form">
<div id="gmp_partner_balance" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_partner_balancegrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->location->Visible) { // location ?>
        <th data-name="location" class="<?= $Grid->location->headerCellClass() ?>"><div id="elh_partner_balance_location" class="partner_balance_location"><?= $Grid->renderFieldHeader($Grid->location) ?></div></th>
<?php } ?>
<?php if ($Grid->partner_id->Visible) { // partner_id ?>
        <th data-name="partner_id" class="<?= $Grid->partner_id->headerCellClass() ?>"><div id="elh_partner_balance_partner_id" class="partner_balance_partner_id"><?= $Grid->renderFieldHeader($Grid->partner_id) ?></div></th>
<?php } ?>
<?php if ($Grid->balance->Visible) { // balance ?>
        <th data-name="balance" class="<?= $Grid->balance->headerCellClass() ?>"><div id="elh_partner_balance_balance" class="partner_balance_balance"><?= $Grid->renderFieldHeader($Grid->balance) ?></div></th>
<?php } ?>
<?php if ($Grid->receipt->Visible) { // receipt ?>
        <th data-name="receipt" class="<?= $Grid->receipt->headerCellClass() ?>"><div id="elh_partner_balance_receipt" class="partner_balance_receipt"><?= $Grid->renderFieldHeader($Grid->receipt) ?></div></th>
<?php } ?>
<?php if ($Grid->panel_amount->Visible) { // panel_amount ?>
        <th data-name="panel_amount" class="<?= $Grid->panel_amount->headerCellClass() ?>"><div id="elh_partner_balance_panel_amount" class="partner_balance_panel_amount"><?= $Grid->renderFieldHeader($Grid->panel_amount) ?></div></th>
<?php } ?>
<?php if ($Grid->total_amount->Visible) { // total_amount ?>
        <th data-name="total_amount" class="<?= $Grid->total_amount->headerCellClass() ?>"><div id="elh_partner_balance_total_amount" class="partner_balance_total_amount"><?= $Grid->renderFieldHeader($Grid->total_amount) ?></div></th>
<?php } ?>
<?php if ($Grid->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Grid->ref->headerCellClass() ?>"><div id="elh_partner_balance_ref" class="partner_balance_ref"><?= $Grid->renderFieldHeader($Grid->ref) ?></div></th>
<?php } ?>
<?php if ($Grid->dated->Visible) { // dated ?>
        <th data-name="dated" class="<?= $Grid->dated->headerCellClass() ?>"><div id="elh_partner_balance_dated" class="partner_balance_dated"><?= $Grid->renderFieldHeader($Grid->dated) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->location->Visible) { // location ?>
        <td data-name="location"<?= $Grid->location->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->location->getSessionValue() != "") { ?>
<span<?= $Grid->location->viewAttributes() ?>>
<?php if (!EmptyString($Grid->location->ViewValue) && $Grid->location->linkAttributes() != "") { ?>
<a<?= $Grid->location->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->location->getDisplayValue($Grid->location->ViewValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->location->getDisplayValue($Grid->location->ViewValue) ?></span>
<?php } ?>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_location" name="x<?= $Grid->RowIndex ?>_location" value="<?= HtmlEncode($Grid->location->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_location" class="el_partner_balance_location">
    <select
        id="x<?= $Grid->RowIndex ?>_location"
        name="x<?= $Grid->RowIndex ?>_location"
        class="form-select ew-select<?= $Grid->location->isInvalidClass() ?>"
        <?php if (!$Grid->location->IsNativeSelect) { ?>
        data-select2-id="fpartner_balancegrid_x<?= $Grid->RowIndex ?>_location"
        <?php } ?>
        data-table="partner_balance"
        data-field="x_location"
        data-value-separator="<?= $Grid->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->location->getPlaceHolder()) ?>"
        <?= $Grid->location->editAttributes() ?>>
        <?= $Grid->location->selectOptionListHtml("x{$Grid->RowIndex}_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->location->getErrorMessage() ?></div>
<?= $Grid->location->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_location") ?>
<?php if (!$Grid->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_balancegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_location", selectId: "fpartner_balancegrid_x<?= $Grid->RowIndex ?>_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_balancegrid.lists.location?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_location", form: "fpartner_balancegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_location", form: "fpartner_balancegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_balance.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="partner_balance" data-field="x_location" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_location" id="o<?= $Grid->RowIndex ?>_location" value="<?= HtmlEncode($Grid->location->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->location->getSessionValue() != "") { ?>
<span<?= $Grid->location->viewAttributes() ?>>
<?php if (!EmptyString($Grid->location->ViewValue) && $Grid->location->linkAttributes() != "") { ?>
<a<?= $Grid->location->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->location->getDisplayValue($Grid->location->ViewValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->location->getDisplayValue($Grid->location->ViewValue) ?></span>
<?php } ?>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_location" name="x<?= $Grid->RowIndex ?>_location" value="<?= HtmlEncode($Grid->location->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_location" class="el_partner_balance_location">
    <select
        id="x<?= $Grid->RowIndex ?>_location"
        name="x<?= $Grid->RowIndex ?>_location"
        class="form-select ew-select<?= $Grid->location->isInvalidClass() ?>"
        <?php if (!$Grid->location->IsNativeSelect) { ?>
        data-select2-id="fpartner_balancegrid_x<?= $Grid->RowIndex ?>_location"
        <?php } ?>
        data-table="partner_balance"
        data-field="x_location"
        data-value-separator="<?= $Grid->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->location->getPlaceHolder()) ?>"
        <?= $Grid->location->editAttributes() ?>>
        <?= $Grid->location->selectOptionListHtml("x{$Grid->RowIndex}_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->location->getErrorMessage() ?></div>
<?= $Grid->location->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_location") ?>
<?php if (!$Grid->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fpartner_balancegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_location", selectId: "fpartner_balancegrid_x<?= $Grid->RowIndex ?>_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpartner_balancegrid.lists.location?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_location", form: "fpartner_balancegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_location", form: "fpartner_balancegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.partner_balance.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_location" class="el_partner_balance_location">
<span<?= $Grid->location->viewAttributes() ?>>
<?php if (!EmptyString($Grid->location->getViewValue()) && $Grid->location->linkAttributes() != "") { ?>
<a<?= $Grid->location->linkAttributes() ?>><?= $Grid->location->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->location->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_location" data-hidden="1" name="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_location" id="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_location" value="<?= HtmlEncode($Grid->location->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_location" data-hidden="1" data-old name="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_location" id="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_location" value="<?= HtmlEncode($Grid->location->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->partner_id->Visible) { // partner_id ?>
        <td data-name="partner_id"<?= $Grid->partner_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->partner_id->getSessionValue() != "") { ?>
<span<?= $Grid->partner_id->viewAttributes() ?>>
<?php if (!EmptyString($Grid->partner_id->ViewValue) && $Grid->partner_id->linkAttributes() != "") { ?>
<a<?= $Grid->partner_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->partner_id->getDisplayValue($Grid->partner_id->ViewValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->partner_id->getDisplayValue($Grid->partner_id->ViewValue) ?></span>
<?php } ?>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_partner_id" name="x<?= $Grid->RowIndex ?>_partner_id" value="<?= HtmlEncode($Grid->partner_id->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_partner_id" class="el_partner_balance_partner_id">
<?php
if (IsRTL()) {
    $Grid->partner_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_partner_id" class="ew-auto-suggest">
    <input type="<?= $Grid->partner_id->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_partner_id" id="sv_x<?= $Grid->RowIndex ?>_partner_id" value="<?= RemoveHtml($Grid->partner_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->partner_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->partner_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->partner_id->formatPattern()) ?>"<?= $Grid->partner_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="partner_balance" data-field="x_partner_id" data-input="sv_x<?= $Grid->RowIndex ?>_partner_id" data-value-separator="<?= $Grid->partner_id->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_partner_id" id="x<?= $Grid->RowIndex ?>_partner_id" value="<?= HtmlEncode($Grid->partner_id->CurrentValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Grid->partner_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fpartner_balancegrid", function() {
    fpartner_balancegrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_partner_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Grid->partner_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.partner_balance.fields.partner_id.autoSuggestOptions));
});
</script>
<?= $Grid->partner_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_partner_id") ?>
</span>
<?php } ?>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_partner_id" id="o<?= $Grid->RowIndex ?>_partner_id" value="<?= HtmlEncode($Grid->partner_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->partner_id->getSessionValue() != "") { ?>
<span<?= $Grid->partner_id->viewAttributes() ?>>
<?php if (!EmptyString($Grid->partner_id->ViewValue) && $Grid->partner_id->linkAttributes() != "") { ?>
<a<?= $Grid->partner_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->partner_id->getDisplayValue($Grid->partner_id->ViewValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->partner_id->getDisplayValue($Grid->partner_id->ViewValue) ?></span>
<?php } ?>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_partner_id" name="x<?= $Grid->RowIndex ?>_partner_id" value="<?= HtmlEncode($Grid->partner_id->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_partner_id" class="el_partner_balance_partner_id">
<?php
if (IsRTL()) {
    $Grid->partner_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_partner_id" class="ew-auto-suggest">
    <input type="<?= $Grid->partner_id->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_partner_id" id="sv_x<?= $Grid->RowIndex ?>_partner_id" value="<?= RemoveHtml($Grid->partner_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->partner_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->partner_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->partner_id->formatPattern()) ?>"<?= $Grid->partner_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="partner_balance" data-field="x_partner_id" data-input="sv_x<?= $Grid->RowIndex ?>_partner_id" data-value-separator="<?= $Grid->partner_id->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_partner_id" id="x<?= $Grid->RowIndex ?>_partner_id" value="<?= HtmlEncode($Grid->partner_id->CurrentValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Grid->partner_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fpartner_balancegrid", function() {
    fpartner_balancegrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_partner_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Grid->partner_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.partner_balance.fields.partner_id.autoSuggestOptions));
});
</script>
<?= $Grid->partner_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_partner_id") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_partner_id" class="el_partner_balance_partner_id">
<span<?= $Grid->partner_id->viewAttributes() ?>>
<?php if (!EmptyString($Grid->partner_id->getViewValue()) && $Grid->partner_id->linkAttributes() != "") { ?>
<a<?= $Grid->partner_id->linkAttributes() ?>><?= $Grid->partner_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->partner_id->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" data-hidden="1" name="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_partner_id" id="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_partner_id" value="<?= HtmlEncode($Grid->partner_id->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" data-hidden="1" data-old name="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_partner_id" id="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_partner_id" value="<?= HtmlEncode($Grid->partner_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->balance->Visible) { // balance ?>
        <td data-name="balance"<?= $Grid->balance->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_balance" class="el_partner_balance_balance">
<input type="<?= $Grid->balance->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_balance" id="x<?= $Grid->RowIndex ?>_balance" data-table="partner_balance" data-field="x_balance" value="<?= $Grid->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->balance->formatPattern()) ?>"<?= $Grid->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->balance->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_balance" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_balance" id="o<?= $Grid->RowIndex ?>_balance" value="<?= HtmlEncode($Grid->balance->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_balance" class="el_partner_balance_balance">
<input type="<?= $Grid->balance->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_balance" id="x<?= $Grid->RowIndex ?>_balance" data-table="partner_balance" data-field="x_balance" value="<?= $Grid->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->balance->formatPattern()) ?>"<?= $Grid->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->balance->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_balance" class="el_partner_balance_balance">
<span<?= $Grid->balance->viewAttributes() ?>>
<?php if (!EmptyString($Grid->balance->getViewValue()) && $Grid->balance->linkAttributes() != "") { ?>
<a<?= $Grid->balance->linkAttributes() ?>><?= $Grid->balance->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->balance->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_balance" data-hidden="1" name="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_balance" id="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_balance" value="<?= HtmlEncode($Grid->balance->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_balance" data-hidden="1" data-old name="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_balance" id="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_balance" value="<?= HtmlEncode($Grid->balance->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->receipt->Visible) { // receipt ?>
        <td data-name="receipt"<?= $Grid->receipt->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_receipt" class="el_partner_balance_receipt">
<input type="<?= $Grid->receipt->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_receipt" id="x<?= $Grid->RowIndex ?>_receipt" data-table="partner_balance" data-field="x_receipt" value="<?= $Grid->receipt->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->receipt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->receipt->formatPattern()) ?>"<?= $Grid->receipt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->receipt->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_receipt" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_receipt" id="o<?= $Grid->RowIndex ?>_receipt" value="<?= HtmlEncode($Grid->receipt->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_receipt" class="el_partner_balance_receipt">
<input type="<?= $Grid->receipt->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_receipt" id="x<?= $Grid->RowIndex ?>_receipt" data-table="partner_balance" data-field="x_receipt" value="<?= $Grid->receipt->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->receipt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->receipt->formatPattern()) ?>"<?= $Grid->receipt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->receipt->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_receipt" class="el_partner_balance_receipt">
<span<?= $Grid->receipt->viewAttributes() ?>>
<?php if (!EmptyString($Grid->receipt->getViewValue()) && $Grid->receipt->linkAttributes() != "") { ?>
<a<?= $Grid->receipt->linkAttributes() ?>><?= $Grid->receipt->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->receipt->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_receipt" data-hidden="1" name="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_receipt" id="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_receipt" value="<?= HtmlEncode($Grid->receipt->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_receipt" data-hidden="1" data-old name="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_receipt" id="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_receipt" value="<?= HtmlEncode($Grid->receipt->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->panel_amount->Visible) { // panel_amount ?>
        <td data-name="panel_amount"<?= $Grid->panel_amount->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_panel_amount" class="el_partner_balance_panel_amount">
<input type="<?= $Grid->panel_amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_panel_amount" id="x<?= $Grid->RowIndex ?>_panel_amount" data-table="partner_balance" data-field="x_panel_amount" value="<?= $Grid->panel_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->panel_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->panel_amount->formatPattern()) ?>"<?= $Grid->panel_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->panel_amount->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_panel_amount" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_panel_amount" id="o<?= $Grid->RowIndex ?>_panel_amount" value="<?= HtmlEncode($Grid->panel_amount->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_panel_amount" class="el_partner_balance_panel_amount">
<input type="<?= $Grid->panel_amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_panel_amount" id="x<?= $Grid->RowIndex ?>_panel_amount" data-table="partner_balance" data-field="x_panel_amount" value="<?= $Grid->panel_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->panel_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->panel_amount->formatPattern()) ?>"<?= $Grid->panel_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->panel_amount->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_panel_amount" class="el_partner_balance_panel_amount">
<span<?= $Grid->panel_amount->viewAttributes() ?>>
<?= $Grid->panel_amount->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_panel_amount" data-hidden="1" name="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_panel_amount" id="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_panel_amount" value="<?= HtmlEncode($Grid->panel_amount->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_panel_amount" data-hidden="1" data-old name="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_panel_amount" id="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_panel_amount" value="<?= HtmlEncode($Grid->panel_amount->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->total_amount->Visible) { // total_amount ?>
        <td data-name="total_amount"<?= $Grid->total_amount->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_total_amount" class="el_partner_balance_total_amount">
<input type="<?= $Grid->total_amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_total_amount" id="x<?= $Grid->RowIndex ?>_total_amount" data-table="partner_balance" data-field="x_total_amount" value="<?= $Grid->total_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->total_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->total_amount->formatPattern()) ?>"<?= $Grid->total_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->total_amount->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_total_amount" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_total_amount" id="o<?= $Grid->RowIndex ?>_total_amount" value="<?= HtmlEncode($Grid->total_amount->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_total_amount" class="el_partner_balance_total_amount">
<input type="<?= $Grid->total_amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_total_amount" id="x<?= $Grid->RowIndex ?>_total_amount" data-table="partner_balance" data-field="x_total_amount" value="<?= $Grid->total_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->total_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->total_amount->formatPattern()) ?>"<?= $Grid->total_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->total_amount->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_total_amount" class="el_partner_balance_total_amount">
<span<?= $Grid->total_amount->viewAttributes() ?>>
<?php if (!EmptyString($Grid->total_amount->getViewValue()) && $Grid->total_amount->linkAttributes() != "") { ?>
<a<?= $Grid->total_amount->linkAttributes() ?>><?= $Grid->total_amount->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->total_amount->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_total_amount" data-hidden="1" name="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_total_amount" id="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_total_amount" value="<?= HtmlEncode($Grid->total_amount->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_total_amount" data-hidden="1" data-old name="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_total_amount" id="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_total_amount" value="<?= HtmlEncode($Grid->total_amount->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Grid->ref->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_ref" class="el_partner_balance_ref">
<template id="tp_x<?= $Grid->RowIndex ?>_ref">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="partner_balance" data-field="x_ref" name="x<?= $Grid->RowIndex ?>_ref" id="x<?= $Grid->RowIndex ?>_ref"<?= $Grid->ref->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_ref" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_ref"
    name="x<?= $Grid->RowIndex ?>_ref"
    value="<?= HtmlEncode($Grid->ref->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x<?= $Grid->RowIndex ?>_ref"
    data-target="dsl_x<?= $Grid->RowIndex ?>_ref"
    data-repeatcolumn="5"
    class="form-control<?= $Grid->ref->isInvalidClass() ?>"
    data-table="partner_balance"
    data-field="x_ref"
    data-value-separator="<?= $Grid->ref->displayValueSeparatorAttribute() ?>"
    <?= $Grid->ref->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->ref->getErrorMessage() ?></div>
<?= $Grid->ref->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ref") ?>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_ref" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ref" id="o<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_ref" class="el_partner_balance_ref">
<template id="tp_x<?= $Grid->RowIndex ?>_ref">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="partner_balance" data-field="x_ref" name="x<?= $Grid->RowIndex ?>_ref" id="x<?= $Grid->RowIndex ?>_ref"<?= $Grid->ref->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_ref" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_ref"
    name="x<?= $Grid->RowIndex ?>_ref"
    value="<?= HtmlEncode($Grid->ref->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x<?= $Grid->RowIndex ?>_ref"
    data-target="dsl_x<?= $Grid->RowIndex ?>_ref"
    data-repeatcolumn="5"
    class="form-control<?= $Grid->ref->isInvalidClass() ?>"
    data-table="partner_balance"
    data-field="x_ref"
    data-value-separator="<?= $Grid->ref->displayValueSeparatorAttribute() ?>"
    <?= $Grid->ref->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->ref->getErrorMessage() ?></div>
<?= $Grid->ref->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ref") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_ref" class="el_partner_balance_ref">
<span<?= $Grid->ref->viewAttributes() ?>>
<?= $Grid->ref->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_ref" data-hidden="1" name="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_ref" id="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_ref" data-hidden="1" data-old name="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_ref" id="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->dated->Visible) { // dated ?>
        <td data-name="dated"<?= $Grid->dated->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_dated" class="el_partner_balance_dated">
<input type="<?= $Grid->dated->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_dated" id="x<?= $Grid->RowIndex ?>_dated" data-table="partner_balance" data-field="x_dated" value="<?= $Grid->dated->EditValue ?>" placeholder="<?= HtmlEncode($Grid->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->dated->formatPattern()) ?>"<?= $Grid->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->dated->getErrorMessage() ?></div>
<?php if (!$Grid->dated->ReadOnly && !$Grid->dated->Disabled && !isset($Grid->dated->EditAttrs["readonly"]) && !isset($Grid->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpartner_balancegrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpartner_balancegrid", "x<?= $Grid->RowIndex ?>_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_dated" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_dated" id="o<?= $Grid->RowIndex ?>_dated" value="<?= HtmlEncode($Grid->dated->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_dated" class="el_partner_balance_dated">
<input type="<?= $Grid->dated->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_dated" id="x<?= $Grid->RowIndex ?>_dated" data-table="partner_balance" data-field="x_dated" value="<?= $Grid->dated->EditValue ?>" placeholder="<?= HtmlEncode($Grid->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->dated->formatPattern()) ?>"<?= $Grid->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->dated->getErrorMessage() ?></div>
<?php if (!$Grid->dated->ReadOnly && !$Grid->dated->Disabled && !isset($Grid->dated->EditAttrs["readonly"]) && !isset($Grid->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpartner_balancegrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpartner_balancegrid", "x<?= $Grid->RowIndex ?>_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_partner_balance_dated" class="el_partner_balance_dated">
<span<?= $Grid->dated->viewAttributes() ?>>
<?= $Grid->dated->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_dated" data-hidden="1" name="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_dated" id="fpartner_balancegrid$x<?= $Grid->RowIndex ?>_dated" value="<?= HtmlEncode($Grid->dated->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_dated" data-hidden="1" data-old name="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_dated" id="fpartner_balancegrid$o<?= $Grid->RowIndex ?>_dated" value="<?= HtmlEncode($Grid->dated->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fpartner_balancegrid","load"], () => fpartner_balancegrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Grid->RowType = RowType::AGGREGATE;
$Grid->resetAttributes();
$Grid->renderRow();
?>
<?php if ($Grid->TotalRecords > 0 && $Grid->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Grid->renderListOptions();

// Render list options (footer, left)
$Grid->ListOptions->render("footer", "left");
?>
    <?php if ($Grid->location->Visible) { // location ?>
        <td data-name="location" class="<?= $Grid->location->footerCellClass() ?>"><span id="elf_partner_balance_location" class="partner_balance_location">
        </span></td>
    <?php } ?>
    <?php if ($Grid->partner_id->Visible) { // partner_id ?>
        <td data-name="partner_id" class="<?= $Grid->partner_id->footerCellClass() ?>"><span id="elf_partner_balance_partner_id" class="partner_balance_partner_id">
        </span></td>
    <?php } ?>
    <?php if ($Grid->balance->Visible) { // balance ?>
        <td data-name="balance" class="<?= $Grid->balance->footerCellClass() ?>"><span id="elf_partner_balance_balance" class="partner_balance_balance">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?php if (!EmptyString($Grid->balance->ViewValue) && $Grid->balance->linkAttributes() != "") { ?>
        <a<?= $Grid->balance->linkAttributes() ?>><?= $Grid->balance->ViewValue ?></a>
        <?php } else { ?>
        <?= $Grid->balance->ViewValue ?>
        <?php } ?>
        </span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->receipt->Visible) { // receipt ?>
        <td data-name="receipt" class="<?= $Grid->receipt->footerCellClass() ?>"><span id="elf_partner_balance_receipt" class="partner_balance_receipt">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?php if (!EmptyString($Grid->receipt->ViewValue) && $Grid->receipt->linkAttributes() != "") { ?>
        <a<?= $Grid->receipt->linkAttributes() ?>><?= $Grid->receipt->ViewValue ?></a>
        <?php } else { ?>
        <?= $Grid->receipt->ViewValue ?>
        <?php } ?>
        </span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->panel_amount->Visible) { // panel_amount ?>
        <td data-name="panel_amount" class="<?= $Grid->panel_amount->footerCellClass() ?>"><span id="elf_partner_balance_panel_amount" class="partner_balance_panel_amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->panel_amount->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->total_amount->Visible) { // total_amount ?>
        <td data-name="total_amount" class="<?= $Grid->total_amount->footerCellClass() ?>"><span id="elf_partner_balance_total_amount" class="partner_balance_total_amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?php if (!EmptyString($Grid->total_amount->ViewValue) && $Grid->total_amount->linkAttributes() != "") { ?>
        <a<?= $Grid->total_amount->linkAttributes() ?>><?= $Grid->total_amount->ViewValue ?></a>
        <?php } else { ?>
        <?= $Grid->total_amount->ViewValue ?>
        <?php } ?>
        </span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->ref->Visible) { // ref ?>
        <td data-name="ref" class="<?= $Grid->ref->footerCellClass() ?>"><span id="elf_partner_balance_ref" class="partner_balance_ref">
        </span></td>
    <?php } ?>
    <?php if ($Grid->dated->Visible) { // dated ?>
        <td data-name="dated" class="<?= $Grid->dated->footerCellClass() ?>"><span id="elf_partner_balance_dated" class="partner_balance_dated">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Grid->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fpartner_balancegrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("partner_balance");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
