<?php

namespace PHPMaker2024\fibre;

// Page object
$PackingTypeTableSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { packing_type_table: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpacking_type_tablesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpacking_type_tablesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["packing", [], fields.packing.isInvalid],
            ["code", [ew.Validators.regex(/^([a-zA-Z0-9_-]){3,3}$/)], fields.code.isInvalid],
            ["ply", [ew.Validators.integer], fields.ply.isInvalid],
            ["rid_new", [ew.Validators.integer], fields.rid_new.isInvalid],
            ["internal_external", [], fields.internal_external.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "ply": <?= $Page->ply->toClientList($Page) ?>,
            "rid_new": <?= $Page->rid_new->toClientList($Page) ?>,
            "internal_external": <?= $Page->internal_external->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpacking_type_tablesearch" id="fpacking_type_tablesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="packing_type_table">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_type_table_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_type_table_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="packing_type_table" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_type_table_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_type_table_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp[]"
        name="x_grp[]"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fpacking_type_tablesearch_x_grp[]"
        <?php } ?>
        data-table="packing_type_table"
        data-field="x_grp"
        multiple
        size="1"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_type_tablesearch", function() {
    var options = { name: "x_grp[]", selectId: "fpacking_type_tablesearch_x_grp[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_type_tablesearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp[]", form: "fpacking_type_tablesearch" };
    } else {
        options.ajax = { id: "x_grp[]", form: "fpacking_type_tablesearch", limit: 5 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_type_table.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing->Visible) { // packing ?>
    <div id="r_packing" class="row"<?= $Page->packing->rowAttributes() ?>>
        <label for="x_packing" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_type_table_packing"><?= $Page->packing->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_packing" id="z_packing" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_type_table_packing" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packing->getInputTextType() ?>" name="x_packing" id="x_packing" data-table="packing_type_table" data-field="x_packing" value="<?= $Page->packing->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->packing->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packing->formatPattern()) ?>"<?= $Page->packing->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packing->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label for="x_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_type_table_code"><?= $Page->code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_code" id="z_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_type_table_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="packing_type_table" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="3" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ply->Visible) { // ply ?>
    <div id="r_ply" class="row"<?= $Page->ply->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_type_table_ply"><?= $Page->ply->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ply" id="z_ply" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ply->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_type_table_ply" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->ply->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_ply" class="ew-auto-suggest">
    <input type="<?= $Page->ply->getInputTextType() ?>" class="form-control" name="sv_x_ply" id="sv_x_ply" value="<?= RemoveHtml($Page->ply->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->ply->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->ply->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ply->formatPattern()) ?>"<?= $Page->ply->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="packing_type_table" data-field="x_ply" data-input="sv_x_ply" data-value-separator="<?= $Page->ply->displayValueSeparatorAttribute() ?>" name="x_ply" id="x_ply" value="<?= HtmlEncode($Page->ply->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->ply->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpacking_type_tablesearch", function() {
    fpacking_type_tablesearch.createAutoSuggest(Object.assign({"id":"x_ply","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->ply->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.packing_type_table.fields.ply.autoSuggestOptions));
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid_new->Visible) { // rid_new ?>
    <div id="r_rid_new" class="row"<?= $Page->rid_new->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_type_table_rid_new"><?= $Page->rid_new->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid_new" id="z_rid_new" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid_new->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_type_table_rid_new" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->rid_new->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid_new" class="ew-auto-suggest">
    <input type="<?= $Page->rid_new->getInputTextType() ?>" class="form-control" name="sv_x_rid_new" id="sv_x_rid_new" value="<?= RemoveHtml($Page->rid_new->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid_new->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid_new->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid_new->formatPattern()) ?>"<?= $Page->rid_new->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="packing_type_table" data-field="x_rid_new" data-input="sv_x_rid_new" data-value-separator="<?= $Page->rid_new->displayValueSeparatorAttribute() ?>" name="x_rid_new" id="x_rid_new" value="<?= HtmlEncode($Page->rid_new->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid_new->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpacking_type_tablesearch", function() {
    fpacking_type_tablesearch.createAutoSuggest(Object.assign({"id":"x_rid_new","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->rid_new->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.packing_type_table.fields.rid_new.autoSuggestOptions));
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->internal_external->Visible) { // internal_external ?>
    <div id="r_internal_external" class="row"<?= $Page->internal_external->rowAttributes() ?>>
        <label for="x_internal_external" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_type_table_internal_external"><?= $Page->internal_external->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_internal_external" id="z_internal_external" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->internal_external->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_type_table_internal_external" class="ew-search-field ew-search-field-single">
    <select
        id="x_internal_external"
        name="x_internal_external"
        class="form-select ew-select<?= $Page->internal_external->isInvalidClass() ?>"
        <?php if (!$Page->internal_external->IsNativeSelect) { ?>
        data-select2-id="fpacking_type_tablesearch_x_internal_external"
        <?php } ?>
        data-table="packing_type_table"
        data-field="x_internal_external"
        data-value-separator="<?= $Page->internal_external->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->internal_external->getPlaceHolder()) ?>"
        <?= $Page->internal_external->editAttributes() ?>>
        <?= $Page->internal_external->selectOptionListHtml("x_internal_external") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->internal_external->getErrorMessage(false) ?></div>
<?php if (!$Page->internal_external->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_type_tablesearch", function() {
    var options = { name: "x_internal_external", selectId: "fpacking_type_tablesearch_x_internal_external" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_type_tablesearch.lists.internal_external?.lookupOptions.length) {
        options.data = { id: "x_internal_external", form: "fpacking_type_tablesearch" };
    } else {
        options.ajax = { id: "x_internal_external", form: "fpacking_type_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_type_table.fields.internal_external.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_type_table_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process" id="z_process" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_type_table_process" class="ew-search-field ew-search-field-single">
<template id="tp_x_process">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="packing_type_table" data-field="x_process" name="x_process" id="x_process"<?= $Page->process->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_process" class="ew-item-list"></div>
<selection-list hidden
    id="x_process[]"
    name="x_process[]"
    value="<?= HtmlEncode($Page->process->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_process"
    data-target="dsl_x_process"
    data-repeatcolumn="5"
    class="form-control<?= $Page->process->isInvalidClass() ?>"
    data-table="packing_type_table"
    data-field="x_process"
    data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
    <?= $Page->process->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_type_table_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_type_table_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpacking_type_tablesearch_x_status"
        <?php } ?>
        data-table="packing_type_table"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_type_tablesearch", function() {
    var options = { name: "x_status", selectId: "fpacking_type_tablesearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_type_tablesearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpacking_type_tablesearch" };
    } else {
        options.ajax = { id: "x_status", form: "fpacking_type_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_type_table.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_type_table_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_type_table_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fpacking_type_tablesearch_x_operator"
        <?php } ?>
        data-table="packing_type_table"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_type_tablesearch", function() {
    var options = { name: "x_operator", selectId: "fpacking_type_tablesearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_type_tablesearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fpacking_type_tablesearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fpacking_type_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_type_table.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_type_table_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_type_table_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="packing_type_table" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpacking_type_tablesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpacking_type_tablesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpacking_type_tablesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("packing_type_table");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
