<?php

namespace PHPMaker2024\fibre;

// Page object
$PackingProcessFSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { packing_process_f: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpacking_process_fsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpacking_process_fsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["godown", [], fields.godown.isInvalid],
            ["Balance", [ew.Validators.float], fields.Balance.isInvalid],
            ["y_Balance", [ew.Validators.between], false],
            ["IN", [ew.Validators.float], fields.IN.isInvalid],
            ["OUT", [ew.Validators.integer], fields.OUT.isInvalid],
            ["packets", [ew.Validators.integer], fields.packets.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["lot_no", [ew.Validators.integer], fields.lot_no.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["tmp_lot", [ew.Validators.float], fields.tmp_lot.isInvalid],
            ["product_n", [], fields.product_n.isInvalid],
            ["process_type", [ew.Validators.integer], fields.process_type.isInvalid],
            ["gcode", [], fields.gcode.isInvalid],
            ["avg_yield", [ew.Validators.integer], fields.avg_yield.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "product": <?= $Page->product->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpacking_process_fsearch" id="fpacking_process_fsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="packing_process_f">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="packing_process_f" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_dated"><?= $Page->dated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dated" id="z_dated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_dated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="packing_process_f" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product" id="z_product" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_product" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->product->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_product" class="ew-auto-suggest">
    <input type="<?= $Page->product->getInputTextType() ?>" class="form-control" name="sv_x_product" id="sv_x_product" value="<?= RemoveHtml($Page->product->EditValue) ?>" autocomplete="off" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product->formatPattern()) ?>"<?= $Page->product->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="packing_process_f" data-field="x_product" data-input="sv_x_product" data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?= HtmlEncode($Page->product->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpacking_process_fsearch", function() {
    fpacking_process_fsearch.createAutoSuggest(Object.assign({"id":"x_product","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->product->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.packing_process_f.fields.product.autoSuggestOptions));
});
</script>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="packing_process_f" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="300" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label for="x_godown" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_godown" class="ew-search-field ew-search-field-single">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fpacking_process_fsearch_x_godown"
        <?php } ?>
        data-table="packing_process_f"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_process_fsearch", function() {
    var options = { name: "x_godown", selectId: "fpacking_process_fsearch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_process_fsearch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fpacking_process_fsearch" };
    } else {
        options.ajax = { id: "x_godown", form: "fpacking_process_fsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_process_f.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
    <div id="r_Balance" class="row"<?= $Page->Balance->rowAttributes() ?>>
        <label for="x_Balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_Balance"><?= $Page->Balance->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Balance" id="z_Balance" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Balance->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Balance->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_packing_process_f_Balance" class="ew-search-field">
<input type="<?= $Page->Balance->getInputTextType() ?>" name="x_Balance" id="x_Balance" data-table="packing_process_f" data-field="x_Balance" value="<?= $Page->Balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Balance->formatPattern()) ?>"<?= $Page->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Balance->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_packing_process_f_Balance" class="ew-search-field2 d-none">
<input type="<?= $Page->Balance->getInputTextType() ?>" name="y_Balance" id="y_Balance" data-table="packing_process_f" data-field="x_Balance" value="<?= $Page->Balance->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Balance->formatPattern()) ?>"<?= $Page->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->IN->Visible) { // IN ?>
    <div id="r_IN" class="row"<?= $Page->IN->rowAttributes() ?>>
        <label for="x_IN" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_IN"><?= $Page->IN->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_IN" id="z_IN" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->IN->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_IN" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->IN->getInputTextType() ?>" name="x_IN" id="x_IN" data-table="packing_process_f" data-field="x_IN" value="<?= $Page->IN->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->IN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->IN->formatPattern()) ?>"<?= $Page->IN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->IN->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->OUT->Visible) { // OUT ?>
    <div id="r_OUT" class="row"<?= $Page->OUT->rowAttributes() ?>>
        <label for="x_OUT" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_OUT"><?= $Page->OUT->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_OUT" id="z_OUT" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->OUT->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_OUT" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->OUT->getInputTextType() ?>" name="x_OUT" id="x_OUT" data-table="packing_process_f" data-field="x_OUT" value="<?= $Page->OUT->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->OUT->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->OUT->formatPattern()) ?>"<?= $Page->OUT->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->OUT->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_packets"><?= $Page->packets->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packets" id="z_packets" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="packing_process_f" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpacking_process_fsearch_x_packing_type"
        <?php } ?>
        data-table="packing_process_f"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_process_fsearch", function() {
    var options = { name: "x_packing_type", selectId: "fpacking_process_fsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_process_fsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpacking_process_fsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpacking_process_fsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_process_f.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_lot_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="packing_process_f" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="packing_process_f" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fpacking_process_fsearch_x_status"
        <?php } ?>
        data-table="packing_process_f"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_process_fsearch", function() {
    var options = { name: "x_status", selectId: "fpacking_process_fsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_process_fsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fpacking_process_fsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fpacking_process_fsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_process_f.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tmp_lot->Visible) { // tmp_lot ?>
    <div id="r_tmp_lot" class="row"<?= $Page->tmp_lot->rowAttributes() ?>>
        <label for="x_tmp_lot" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_tmp_lot"><?= $Page->tmp_lot->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tmp_lot->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_tmp_lot" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tmp_lot->getInputTextType() ?>" name="x_tmp_lot" id="x_tmp_lot" data-table="packing_process_f" data-field="x_tmp_lot" value="<?= $Page->tmp_lot->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->tmp_lot->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tmp_lot->formatPattern()) ?>"<?= $Page->tmp_lot->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tmp_lot->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_n->Visible) { // product_n ?>
    <div id="r_product_n" class="row"<?= $Page->product_n->rowAttributes() ?>>
        <label for="x_product_n" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_product_n"><?= $Page->product_n->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_n" id="z_product_n" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_n->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_product_n" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_n->getInputTextType() ?>" name="x_product_n" id="x_product_n" data-table="packing_process_f" data-field="x_product_n" value="<?= $Page->product_n->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->product_n->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_n->formatPattern()) ?>"<?= $Page->product_n->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_n->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_type->Visible) { // process_type ?>
    <div id="r_process_type" class="row"<?= $Page->process_type->rowAttributes() ?>>
        <label for="x_process_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_process_type"><?= $Page->process_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process_type" id="z_process_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_process_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->process_type->getInputTextType() ?>" name="x_process_type" id="x_process_type" data-table="packing_process_f" data-field="x_process_type" value="<?= $Page->process_type->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->process_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process_type->formatPattern()) ?>"<?= $Page->process_type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->process_type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gcode->Visible) { // gcode ?>
    <div id="r_gcode" class="row"<?= $Page->gcode->rowAttributes() ?>>
        <label for="x_gcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_gcode"><?= $Page->gcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_gcode" id="z_gcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_gcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gcode->getInputTextType() ?>" name="x_gcode" id="x_gcode" data-table="packing_process_f" data-field="x_gcode" value="<?= $Page->gcode->EditValue ?>" size="30" maxlength="3" placeholder="<?= HtmlEncode($Page->gcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gcode->formatPattern()) ?>"<?= $Page->gcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->avg_yield->Visible) { // avg_yield ?>
    <div id="r_avg_yield" class="row"<?= $Page->avg_yield->rowAttributes() ?>>
        <label for="x_avg_yield" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_process_f_avg_yield"><?= $Page->avg_yield->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_avg_yield" id="z_avg_yield" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->avg_yield->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_process_f_avg_yield" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->avg_yield->getInputTextType() ?>" name="x_avg_yield" id="x_avg_yield" data-table="packing_process_f" data-field="x_avg_yield" value="<?= $Page->avg_yield->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->avg_yield->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->avg_yield->formatPattern()) ?>"<?= $Page->avg_yield->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->avg_yield->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpacking_process_fsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpacking_process_fsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpacking_process_fsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("packing_process_f");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
