<?php

namespace PHPMaker2024\fibre;

// Page object
$PackingListTmpList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { packing_list_tmp: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fpacking_list_tmpsrch" id="fpacking_list_tmpsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fpacking_list_tmpsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { packing_list_tmp: currentTable } });
var currentForm;
var fpacking_list_tmpsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpacking_list_tmpsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fpacking_list_tmpsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fpacking_list_tmpsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fpacking_list_tmpsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fpacking_list_tmpsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fpacking_list_tmpsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fpacking_list_tmpsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fpacking_list_tmpsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="packing_list_tmp">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_packing_list_tmp" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_packing_list_tmplist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_packing_list_tmp_id" class="packing_list_tmp_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
        <th data-name="pl_no" class="<?= $Page->pl_no->headerCellClass() ?>"><div id="elh_packing_list_tmp_pl_no" class="packing_list_tmp_pl_no"><?= $Page->renderFieldHeader($Page->pl_no) ?></div></th>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <th data-name="buyers_id" class="<?= $Page->buyers_id->headerCellClass() ?>"><div id="elh_packing_list_tmp_buyers_id" class="packing_list_tmp_buyers_id"><?= $Page->renderFieldHeader($Page->buyers_id) ?></div></th>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>"><div id="elh_packing_list_tmp__barcode" class="packing_list_tmp__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->roll_no_start->Visible) { // roll_no_start ?>
        <th data-name="roll_no_start" class="<?= $Page->roll_no_start->headerCellClass() ?>"><div id="elh_packing_list_tmp_roll_no_start" class="packing_list_tmp_roll_no_start"><?= $Page->renderFieldHeader($Page->roll_no_start) ?></div></th>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
        <th data-name="design" class="<?= $Page->design->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_packing_list_tmp_design" class="packing_list_tmp_design"><?= $Page->renderFieldHeader($Page->design) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <th data-name="buyer_ref" class="<?= $Page->buyer_ref->headerCellClass() ?>"><div id="elh_packing_list_tmp_buyer_ref" class="packing_list_tmp_buyer_ref"><?= $Page->renderFieldHeader($Page->buyer_ref) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_code->Visible) { // buyer_code ?>
        <th data-name="buyer_code" class="<?= $Page->buyer_code->headerCellClass() ?>"><div id="elh_packing_list_tmp_buyer_code" class="packing_list_tmp_buyer_code"><?= $Page->renderFieldHeader($Page->buyer_code) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <th data-name="buyer_uid" class="<?= $Page->buyer_uid->headerCellClass() ?>"><div id="elh_packing_list_tmp_buyer_uid" class="packing_list_tmp_buyer_uid"><?= $Page->renderFieldHeader($Page->buyer_uid) ?></div></th>
<?php } ?>
<?php if ($Page->partner_ref->Visible) { // partner_ref ?>
        <th data-name="partner_ref" class="<?= $Page->partner_ref->headerCellClass() ?>"><div id="elh_packing_list_tmp_partner_ref" class="packing_list_tmp_partner_ref"><?= $Page->renderFieldHeader($Page->partner_ref) ?></div></th>
<?php } ?>
<?php if ($Page->no_of_bales->Visible) { // no_of_bales ?>
        <th data-name="no_of_bales" class="<?= $Page->no_of_bales->headerCellClass() ?>"><div id="elh_packing_list_tmp_no_of_bales" class="packing_list_tmp_no_of_bales"><?= $Page->renderFieldHeader($Page->no_of_bales) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_po->Visible) { // buyer_po ?>
        <th data-name="buyer_po" class="<?= $Page->buyer_po->headerCellClass() ?>"><div id="elh_packing_list_tmp_buyer_po" class="packing_list_tmp_buyer_po"><?= $Page->renderFieldHeader($Page->buyer_po) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_packing_list_tmp_quantity" class="packing_list_tmp_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
        <th data-name="size" class="<?= $Page->size->headerCellClass() ?>"><div id="elh_packing_list_tmp_size" class="packing_list_tmp_size"><?= $Page->renderFieldHeader($Page->size) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_packing_list_tmp_sqm" class="packing_list_tmp_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->sqm_a->Visible) { // sqm_a ?>
        <th data-name="sqm_a" class="<?= $Page->sqm_a->headerCellClass() ?>"><div id="elh_packing_list_tmp_sqm_a" class="packing_list_tmp_sqm_a"><?= $Page->renderFieldHeader($Page->sqm_a) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>"><div id="elh_packing_list_tmp_amount" class="packing_list_tmp_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
        <th data-name="currency" class="<?= $Page->currency->headerCellClass() ?>"><div id="elh_packing_list_tmp_currency" class="packing_list_tmp_currency"><?= $Page->renderFieldHeader($Page->currency) ?></div></th>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
        <th data-name="price" class="<?= $Page->price->headerCellClass() ?>"><div id="elh_packing_list_tmp_price" class="packing_list_tmp_price"><?= $Page->renderFieldHeader($Page->price) ?></div></th>
<?php } ?>
<?php if ($Page->discount->Visible) { // discount ?>
        <th data-name="discount" class="<?= $Page->discount->headerCellClass() ?>"><div id="elh_packing_list_tmp_discount" class="packing_list_tmp_discount"><?= $Page->renderFieldHeader($Page->discount) ?></div></th>
<?php } ?>
<?php if ($Page->hsn->Visible) { // hsn ?>
        <th data-name="hsn" class="<?= $Page->hsn->headerCellClass() ?>"><div id="elh_packing_list_tmp_hsn" class="packing_list_tmp_hsn"><?= $Page->renderFieldHeader($Page->hsn) ?></div></th>
<?php } ?>
<?php if ($Page->gst->Visible) { // gst ?>
        <th data-name="gst" class="<?= $Page->gst->headerCellClass() ?>"><div id="elh_packing_list_tmp_gst" class="packing_list_tmp_gst"><?= $Page->renderFieldHeader($Page->gst) ?></div></th>
<?php } ?>
<?php if ($Page->composition->Visible) { // composition ?>
        <th data-name="composition" class="<?= $Page->composition->headerCellClass() ?>"><div id="elh_packing_list_tmp_composition" class="packing_list_tmp_composition"><?= $Page->renderFieldHeader($Page->composition) ?></div></th>
<?php } ?>
<?php if ($Page->price_exchange->Visible) { // price_exchange ?>
        <th data-name="price_exchange" class="<?= $Page->price_exchange->headerCellClass() ?>"><div id="elh_packing_list_tmp_price_exchange" class="packing_list_tmp_price_exchange"><?= $Page->renderFieldHeader($Page->price_exchange) ?></div></th>
<?php } ?>
<?php if ($Page->amount_exchange->Visible) { // amount_exchange ?>
        <th data-name="amount_exchange" class="<?= $Page->amount_exchange->headerCellClass() ?>"><div id="elh_packing_list_tmp_amount_exchange" class="packing_list_tmp_amount_exchange"><?= $Page->renderFieldHeader($Page->amount_exchange) ?></div></th>
<?php } ?>
<?php if ($Page->partner_other_ref->Visible) { // partner_other_ref ?>
        <th data-name="partner_other_ref" class="<?= $Page->partner_other_ref->headerCellClass() ?>"><div id="elh_packing_list_tmp_partner_other_ref" class="packing_list_tmp_partner_other_ref"><?= $Page->renderFieldHeader($Page->partner_other_ref) ?></div></th>
<?php } ?>
<?php if ($Page->design_code->Visible) { // design_code ?>
        <th data-name="design_code" class="<?= $Page->design_code->headerCellClass() ?>"><div id="elh_packing_list_tmp_design_code" class="packing_list_tmp_design_code"><?= $Page->renderFieldHeader($Page->design_code) ?></div></th>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
        <th data-name="cbm" class="<?= $Page->cbm->headerCellClass() ?>"><div id="elh_packing_list_tmp_cbm" class="packing_list_tmp_cbm"><?= $Page->renderFieldHeader($Page->cbm) ?></div></th>
<?php } ?>
<?php if ($Page->weight->Visible) { // weight ?>
        <th data-name="weight" class="<?= $Page->weight->headerCellClass() ?>"><div id="elh_packing_list_tmp_weight" class="packing_list_tmp_weight"><?= $Page->renderFieldHeader($Page->weight) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
        <th data-name="buyer_loc" class="<?= $Page->buyer_loc->headerCellClass() ?>"><div id="elh_packing_list_tmp_buyer_loc" class="packing_list_tmp_buyer_loc"><?= $Page->renderFieldHeader($Page->buyer_loc) ?></div></th>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_packing_list_tmp_po" class="packing_list_tmp_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_id" class="el_packing_list_tmp_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pl_no->Visible) { // pl_no ?>
        <td data-name="pl_no"<?= $Page->pl_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_pl_no" class="el_packing_list_tmp_pl_no">
<span<?= $Page->pl_no->viewAttributes() ?>>
<?= $Page->pl_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id"<?= $Page->buyers_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_buyers_id" class="el_packing_list_tmp_buyers_id">
<span<?= $Page->buyers_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyers_id->getViewValue()) && $Page->buyers_id->linkAttributes() != "") { ?>
<a<?= $Page->buyers_id->linkAttributes() ?>><?= $Page->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp__barcode" class="el_packing_list_tmp__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->roll_no_start->Visible) { // roll_no_start ?>
        <td data-name="roll_no_start"<?= $Page->roll_no_start->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_roll_no_start" class="el_packing_list_tmp_roll_no_start">
<span<?= $Page->roll_no_start->viewAttributes() ?>>
<?= $Page->roll_no_start->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design->Visible) { // design ?>
        <td data-name="design"<?= $Page->design->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_design" class="el_packing_list_tmp_design">
<span<?= $Page->design->viewAttributes() ?>>
<?= $Page->design->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <td data-name="buyer_ref"<?= $Page->buyer_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_buyer_ref" class="el_packing_list_tmp_buyer_ref">
<span<?= $Page->buyer_ref->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyer_ref->getViewValue()) && $Page->buyer_ref->linkAttributes() != "") { ?>
<a<?= $Page->buyer_ref->linkAttributes() ?>><?= $Page->buyer_ref->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->buyer_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_code->Visible) { // buyer_code ?>
        <td data-name="buyer_code"<?= $Page->buyer_code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_buyer_code" class="el_packing_list_tmp_buyer_code">
<span<?= $Page->buyer_code->viewAttributes() ?>>
<?= $Page->buyer_code->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <td data-name="buyer_uid"<?= $Page->buyer_uid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_buyer_uid" class="el_packing_list_tmp_buyer_uid">
<span<?= $Page->buyer_uid->viewAttributes() ?>>
<?= $Page->buyer_uid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_ref->Visible) { // partner_ref ?>
        <td data-name="partner_ref"<?= $Page->partner_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_partner_ref" class="el_packing_list_tmp_partner_ref">
<span<?= $Page->partner_ref->viewAttributes() ?>>
<?= $Page->partner_ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->no_of_bales->Visible) { // no_of_bales ?>
        <td data-name="no_of_bales"<?= $Page->no_of_bales->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_no_of_bales" class="el_packing_list_tmp_no_of_bales">
<span<?= $Page->no_of_bales->viewAttributes() ?>>
<?= $Page->no_of_bales->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_po->Visible) { // buyer_po ?>
        <td data-name="buyer_po"<?= $Page->buyer_po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_buyer_po" class="el_packing_list_tmp_buyer_po">
<span<?= $Page->buyer_po->viewAttributes() ?>>
<?= $Page->buyer_po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_quantity" class="el_packing_list_tmp_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size->Visible) { // size ?>
        <td data-name="size"<?= $Page->size->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_size" class="el_packing_list_tmp_size">
<span<?= $Page->size->viewAttributes() ?>>
<?= $Page->size->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_sqm" class="el_packing_list_tmp_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm_a->Visible) { // sqm_a ?>
        <td data-name="sqm_a"<?= $Page->sqm_a->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_sqm_a" class="el_packing_list_tmp_sqm_a">
<span<?= $Page->sqm_a->viewAttributes() ?>>
<?= $Page->sqm_a->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_amount" class="el_packing_list_tmp_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?= $Page->amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->currency->Visible) { // currency ?>
        <td data-name="currency"<?= $Page->currency->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_currency" class="el_packing_list_tmp_currency">
<span<?= $Page->currency->viewAttributes() ?>>
<?= $Page->currency->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->price->Visible) { // price ?>
        <td data-name="price"<?= $Page->price->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_price" class="el_packing_list_tmp_price">
<span<?= $Page->price->viewAttributes() ?>>
<?= $Page->price->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->discount->Visible) { // discount ?>
        <td data-name="discount"<?= $Page->discount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_discount" class="el_packing_list_tmp_discount">
<span<?= $Page->discount->viewAttributes() ?>>
<?= $Page->discount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->hsn->Visible) { // hsn ?>
        <td data-name="hsn"<?= $Page->hsn->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_hsn" class="el_packing_list_tmp_hsn">
<span<?= $Page->hsn->viewAttributes() ?>>
<?= $Page->hsn->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->gst->Visible) { // gst ?>
        <td data-name="gst"<?= $Page->gst->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_gst" class="el_packing_list_tmp_gst">
<span<?= $Page->gst->viewAttributes() ?>>
<?= $Page->gst->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->composition->Visible) { // composition ?>
        <td data-name="composition"<?= $Page->composition->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_composition" class="el_packing_list_tmp_composition">
<span<?= $Page->composition->viewAttributes() ?>>
<?= $Page->composition->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->price_exchange->Visible) { // price_exchange ?>
        <td data-name="price_exchange"<?= $Page->price_exchange->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_price_exchange" class="el_packing_list_tmp_price_exchange">
<span<?= $Page->price_exchange->viewAttributes() ?>>
<?= $Page->price_exchange->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount_exchange->Visible) { // amount_exchange ?>
        <td data-name="amount_exchange"<?= $Page->amount_exchange->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_amount_exchange" class="el_packing_list_tmp_amount_exchange">
<span<?= $Page->amount_exchange->viewAttributes() ?>>
<?= $Page->amount_exchange->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_other_ref->Visible) { // partner_other_ref ?>
        <td data-name="partner_other_ref"<?= $Page->partner_other_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_partner_other_ref" class="el_packing_list_tmp_partner_other_ref">
<span<?= $Page->partner_other_ref->viewAttributes() ?>>
<?= $Page->partner_other_ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design_code->Visible) { // design_code ?>
        <td data-name="design_code"<?= $Page->design_code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_design_code" class="el_packing_list_tmp_design_code">
<span<?= $Page->design_code->viewAttributes() ?>>
<?= $Page->design_code->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cbm->Visible) { // cbm ?>
        <td data-name="cbm"<?= $Page->cbm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_cbm" class="el_packing_list_tmp_cbm">
<span<?= $Page->cbm->viewAttributes() ?>>
<?= $Page->cbm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->weight->Visible) { // weight ?>
        <td data-name="weight"<?= $Page->weight->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_weight" class="el_packing_list_tmp_weight">
<span<?= $Page->weight->viewAttributes() ?>>
<?= $Page->weight->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
        <td data-name="buyer_loc"<?= $Page->buyer_loc->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_buyer_loc" class="el_packing_list_tmp_buyer_loc">
<span<?= $Page->buyer_loc->viewAttributes() ?>>
<?= $Page->buyer_loc->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_packing_list_tmp_po" class="el_packing_list_tmp_po">
<span<?= $Page->po->viewAttributes() ?>>
<?= $Page->po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_packing_list_tmp_id" class="packing_list_tmp_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->pl_no->Visible) { // pl_no ?>
        <td data-name="pl_no" class="<?= $Page->pl_no->footerCellClass() ?>"><span id="elf_packing_list_tmp_pl_no" class="packing_list_tmp_pl_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id" class="<?= $Page->buyers_id->footerCellClass() ?>"><span id="elf_packing_list_tmp_buyers_id" class="packing_list_tmp_buyers_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode" class="<?= $Page->_barcode->footerCellClass() ?>"><span id="elf_packing_list_tmp__barcode" class="packing_list_tmp__barcode">
        <span class="ew-aggregate"><?= $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
        <?= $Page->_barcode->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->roll_no_start->Visible) { // roll_no_start ?>
        <td data-name="roll_no_start" class="<?= $Page->roll_no_start->footerCellClass() ?>"><span id="elf_packing_list_tmp_roll_no_start" class="packing_list_tmp_roll_no_start">
        </span></td>
    <?php } ?>
    <?php if ($Page->design->Visible) { // design ?>
        <td data-name="design" class="<?= $Page->design->footerCellClass() ?>"><span id="elf_packing_list_tmp_design" class="packing_list_tmp_design">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <td data-name="buyer_ref" class="<?= $Page->buyer_ref->footerCellClass() ?>"><span id="elf_packing_list_tmp_buyer_ref" class="packing_list_tmp_buyer_ref">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_code->Visible) { // buyer_code ?>
        <td data-name="buyer_code" class="<?= $Page->buyer_code->footerCellClass() ?>"><span id="elf_packing_list_tmp_buyer_code" class="packing_list_tmp_buyer_code">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_uid->Visible) { // buyer_uid ?>
        <td data-name="buyer_uid" class="<?= $Page->buyer_uid->footerCellClass() ?>"><span id="elf_packing_list_tmp_buyer_uid" class="packing_list_tmp_buyer_uid">
        </span></td>
    <?php } ?>
    <?php if ($Page->partner_ref->Visible) { // partner_ref ?>
        <td data-name="partner_ref" class="<?= $Page->partner_ref->footerCellClass() ?>"><span id="elf_packing_list_tmp_partner_ref" class="packing_list_tmp_partner_ref">
        </span></td>
    <?php } ?>
    <?php if ($Page->no_of_bales->Visible) { // no_of_bales ?>
        <td data-name="no_of_bales" class="<?= $Page->no_of_bales->footerCellClass() ?>"><span id="elf_packing_list_tmp_no_of_bales" class="packing_list_tmp_no_of_bales">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_po->Visible) { // buyer_po ?>
        <td data-name="buyer_po" class="<?= $Page->buyer_po->footerCellClass() ?>"><span id="elf_packing_list_tmp_buyer_po" class="packing_list_tmp_buyer_po">
        </span></td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity" class="<?= $Page->quantity->footerCellClass() ?>"><span id="elf_packing_list_tmp_quantity" class="packing_list_tmp_quantity">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->quantity->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->size->Visible) { // size ?>
        <td data-name="size" class="<?= $Page->size->footerCellClass() ?>"><span id="elf_packing_list_tmp_size" class="packing_list_tmp_size">
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm" class="<?= $Page->sqm->footerCellClass() ?>"><span id="elf_packing_list_tmp_sqm" class="packing_list_tmp_sqm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->sqm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm_a->Visible) { // sqm_a ?>
        <td data-name="sqm_a" class="<?= $Page->sqm_a->footerCellClass() ?>"><span id="elf_packing_list_tmp_sqm_a" class="packing_list_tmp_sqm_a">
        </span></td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount" class="<?= $Page->amount->footerCellClass() ?>"><span id="elf_packing_list_tmp_amount" class="packing_list_tmp_amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->amount->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->currency->Visible) { // currency ?>
        <td data-name="currency" class="<?= $Page->currency->footerCellClass() ?>"><span id="elf_packing_list_tmp_currency" class="packing_list_tmp_currency">
        </span></td>
    <?php } ?>
    <?php if ($Page->price->Visible) { // price ?>
        <td data-name="price" class="<?= $Page->price->footerCellClass() ?>"><span id="elf_packing_list_tmp_price" class="packing_list_tmp_price">
        </span></td>
    <?php } ?>
    <?php if ($Page->discount->Visible) { // discount ?>
        <td data-name="discount" class="<?= $Page->discount->footerCellClass() ?>"><span id="elf_packing_list_tmp_discount" class="packing_list_tmp_discount">
        </span></td>
    <?php } ?>
    <?php if ($Page->hsn->Visible) { // hsn ?>
        <td data-name="hsn" class="<?= $Page->hsn->footerCellClass() ?>"><span id="elf_packing_list_tmp_hsn" class="packing_list_tmp_hsn">
        </span></td>
    <?php } ?>
    <?php if ($Page->gst->Visible) { // gst ?>
        <td data-name="gst" class="<?= $Page->gst->footerCellClass() ?>"><span id="elf_packing_list_tmp_gst" class="packing_list_tmp_gst">
        </span></td>
    <?php } ?>
    <?php if ($Page->composition->Visible) { // composition ?>
        <td data-name="composition" class="<?= $Page->composition->footerCellClass() ?>"><span id="elf_packing_list_tmp_composition" class="packing_list_tmp_composition">
        </span></td>
    <?php } ?>
    <?php if ($Page->price_exchange->Visible) { // price_exchange ?>
        <td data-name="price_exchange" class="<?= $Page->price_exchange->footerCellClass() ?>"><span id="elf_packing_list_tmp_price_exchange" class="packing_list_tmp_price_exchange">
        </span></td>
    <?php } ?>
    <?php if ($Page->amount_exchange->Visible) { // amount_exchange ?>
        <td data-name="amount_exchange" class="<?= $Page->amount_exchange->footerCellClass() ?>"><span id="elf_packing_list_tmp_amount_exchange" class="packing_list_tmp_amount_exchange">
        </span></td>
    <?php } ?>
    <?php if ($Page->partner_other_ref->Visible) { // partner_other_ref ?>
        <td data-name="partner_other_ref" class="<?= $Page->partner_other_ref->footerCellClass() ?>"><span id="elf_packing_list_tmp_partner_other_ref" class="packing_list_tmp_partner_other_ref">
        </span></td>
    <?php } ?>
    <?php if ($Page->design_code->Visible) { // design_code ?>
        <td data-name="design_code" class="<?= $Page->design_code->footerCellClass() ?>"><span id="elf_packing_list_tmp_design_code" class="packing_list_tmp_design_code">
        </span></td>
    <?php } ?>
    <?php if ($Page->cbm->Visible) { // cbm ?>
        <td data-name="cbm" class="<?= $Page->cbm->footerCellClass() ?>"><span id="elf_packing_list_tmp_cbm" class="packing_list_tmp_cbm">
        </span></td>
    <?php } ?>
    <?php if ($Page->weight->Visible) { // weight ?>
        <td data-name="weight" class="<?= $Page->weight->footerCellClass() ?>"><span id="elf_packing_list_tmp_weight" class="packing_list_tmp_weight">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
        <td data-name="buyer_loc" class="<?= $Page->buyer_loc->footerCellClass() ?>"><span id="elf_packing_list_tmp_buyer_loc" class="packing_list_tmp_buyer_loc">
        </span></td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po" class="<?= $Page->po->footerCellClass() ?>"><span id="elf_packing_list_tmp_po" class="packing_list_tmp_po">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("packing_list_tmp");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
