<?php

namespace PHPMaker2024\fibre;

// Page object
$PackingListSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { packing_list: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpacking_listsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpacking_listsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["pl_no", [ew.Validators.float], fields.pl_no.isInvalid],
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["_barcode", [ew.Validators.integer], fields._barcode.isInvalid],
            ["no_of_bales", [ew.Validators.integer], fields.no_of_bales.isInvalid],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["buyer_code", [], fields.buyer_code.isInvalid],
            ["buyer_po", [], fields.buyer_po.isInvalid],
            ["quantity", [ew.Validators.integer], fields.quantity.isInvalid],
            ["size", [], fields.size.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["sqm_a", [ew.Validators.float], fields.sqm_a.isInvalid],
            ["price", [ew.Validators.float], fields.price.isInvalid],
            ["price_a", [ew.Validators.float], fields.price_a.isInvalid],
            ["discount", [ew.Validators.float], fields.discount.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["composition", [], fields.composition.isInvalid],
            ["hsn", [], fields.hsn.isInvalid],
            ["gst", [ew.Validators.float], fields.gst.isInvalid],
            ["price_exchange", [ew.Validators.float], fields.price_exchange.isInvalid],
            ["price_exchange_a", [ew.Validators.float], fields.price_exchange_a.isInvalid],
            ["amount_exchange", [ew.Validators.float], fields.amount_exchange.isInvalid],
            ["cbm", [ew.Validators.float], fields.cbm.isInvalid],
            ["weight", [ew.Validators.float], fields.weight.isInvalid],
            ["partner_other_ref", [], fields.partner_other_ref.isInvalid],
            ["buyer_loc", [], fields.buyer_loc.isInvalid],
            ["po", [], fields.po.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "buyer_ref": <?= $Page->buyer_ref->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpacking_listsearch" id="fpacking_listsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="packing_list">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="packing_list" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
    <div id="r_pl_no" class="row"<?= $Page->pl_no->rowAttributes() ?>>
        <label for="x_pl_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_pl_no"><?= $Page->pl_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pl_no" id="z_pl_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pl_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_pl_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pl_no->getInputTextType() ?>" name="x_pl_no" id="x_pl_no" data-table="packing_list" data-field="x_pl_no" value="<?= $Page->pl_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_no->formatPattern()) ?>"<?= $Page->pl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pl_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id" class="row"<?= $Page->buyers_id->rowAttributes() ?>>
        <label for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_buyers_id"><?= $Page->buyers_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyers_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_buyers_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fpacking_listsearch_x_buyers_id"
        <?php } ?>
        data-table="packing_list"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_listsearch", function() {
    var options = { name: "x_buyers_id", selectId: "fpacking_listsearch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_listsearch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fpacking_listsearch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fpacking_listsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_list.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list__barcode"><?= $Page->_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__barcode" id="z__barcode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list__barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="packing_list" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->no_of_bales->Visible) { // no_of_bales ?>
    <div id="r_no_of_bales" class="row"<?= $Page->no_of_bales->rowAttributes() ?>>
        <label for="x_no_of_bales" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_of_bales"><?= $Page->no_of_bales->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_no_of_bales" id="z_no_of_bales" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->no_of_bales->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_of_bales" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->no_of_bales->getInputTextType() ?>" name="x_no_of_bales" id="x_no_of_bales" data-table="packing_list" data-field="x_no_of_bales" value="<?= $Page->no_of_bales->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->no_of_bales->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no_of_bales->formatPattern()) ?>"<?= $Page->no_of_bales->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->no_of_bales->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
    <div id="r_buyer_ref" class="row"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label for="x_buyer_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_buyer_ref"><?= $Page->buyer_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_buyer_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_ref->getInputTextType() ?>" name="x_buyer_ref" id="x_buyer_ref" data-table="packing_list" data-field="x_buyer_ref" value="<?= $Page->buyer_ref->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_ref->formatPattern()) ?>"<?= $Page->buyer_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
<?= $Page->buyer_ref->Lookup->getParamTag($Page, "p_x_buyer_ref") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_code->Visible) { // buyer_code ?>
    <div id="r_buyer_code" class="row"<?= $Page->buyer_code->rowAttributes() ?>>
        <label for="x_buyer_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_buyer_code"><?= $Page->buyer_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_code" id="z_buyer_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_buyer_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_code->getInputTextType() ?>" name="x_buyer_code" id="x_buyer_code" data-table="packing_list" data-field="x_buyer_code" value="<?= $Page->buyer_code->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->buyer_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_code->formatPattern()) ?>"<?= $Page->buyer_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_po->Visible) { // buyer_po ?>
    <div id="r_buyer_po" class="row"<?= $Page->buyer_po->rowAttributes() ?>>
        <label for="x_buyer_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_buyer_po"><?= $Page->buyer_po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_po" id="z_buyer_po" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_buyer_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_po->getInputTextType() ?>" name="x_buyer_po" id="x_buyer_po" data-table="packing_list" data-field="x_buyer_po" value="<?= $Page->buyer_po->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_po->formatPattern()) ?>"<?= $Page->buyer_po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="packing_list" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
    <div id="r_size" class="row"<?= $Page->size->rowAttributes() ?>>
        <label for="x_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_size"><?= $Page->size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size" id="z_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size->getInputTextType() ?>" name="x_size" id="x_size" data-table="packing_list" data-field="x_size" value="<?= $Page->size->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size->formatPattern()) ?>"<?= $Page->size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="packing_list" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm_a->Visible) { // sqm_a ?>
    <div id="r_sqm_a" class="row"<?= $Page->sqm_a->rowAttributes() ?>>
        <label for="x_sqm_a" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_sqm_a"><?= $Page->sqm_a->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm_a" id="z_sqm_a" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm_a->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_sqm_a" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm_a->getInputTextType() ?>" name="x_sqm_a" id="x_sqm_a" data-table="packing_list" data-field="x_sqm_a" value="<?= $Page->sqm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm_a->formatPattern()) ?>"<?= $Page->sqm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm_a->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price" class="row"<?= $Page->price->rowAttributes() ?>>
        <label for="x_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_price"><?= $Page->price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price" id="z_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="packing_list" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price_a->Visible) { // price_a ?>
    <div id="r_price_a" class="row"<?= $Page->price_a->rowAttributes() ?>>
        <label for="x_price_a" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_price_a"><?= $Page->price_a->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price_a" id="z_price_a" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price_a->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_price_a" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price_a->getInputTextType() ?>" name="x_price_a" id="x_price_a" data-table="packing_list" data-field="x_price_a" value="<?= $Page->price_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price_a->formatPattern()) ?>"<?= $Page->price_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price_a->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->discount->Visible) { // discount ?>
    <div id="r_discount" class="row"<?= $Page->discount->rowAttributes() ?>>
        <label for="x_discount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_discount"><?= $Page->discount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_discount" id="z_discount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->discount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_discount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->discount->getInputTextType() ?>" name="x_discount" id="x_discount" data-table="packing_list" data-field="x_discount" value="<?= $Page->discount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->discount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->discount->formatPattern()) ?>"<?= $Page->discount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->discount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="packing_list" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label for="x_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency" id="z_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fpacking_listsearch_x_currency"
        <?php } ?>
        data-table="packing_list"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_listsearch", function() {
    var options = { name: "x_currency", selectId: "fpacking_listsearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_listsearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fpacking_listsearch" };
    } else {
        options.ajax = { id: "x_currency", form: "fpacking_listsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_list.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->composition->Visible) { // composition ?>
    <div id="r_composition" class="row"<?= $Page->composition->rowAttributes() ?>>
        <label for="x_composition" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_composition"><?= $Page->composition->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_composition" id="z_composition" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->composition->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_composition" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->composition->getInputTextType() ?>" name="x_composition" id="x_composition" data-table="packing_list" data-field="x_composition" value="<?= $Page->composition->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->composition->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->composition->formatPattern()) ?>"<?= $Page->composition->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->composition->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->hsn->Visible) { // hsn ?>
    <div id="r_hsn" class="row"<?= $Page->hsn->rowAttributes() ?>>
        <label for="x_hsn" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_hsn"><?= $Page->hsn->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_hsn" id="z_hsn" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->hsn->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_hsn" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->hsn->getInputTextType() ?>" name="x_hsn" id="x_hsn" data-table="packing_list" data-field="x_hsn" value="<?= $Page->hsn->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->hsn->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->hsn->formatPattern()) ?>"<?= $Page->hsn->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->hsn->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gst->Visible) { // gst ?>
    <div id="r_gst" class="row"<?= $Page->gst->rowAttributes() ?>>
        <label for="x_gst" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_gst"><?= $Page->gst->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gst" id="z_gst" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gst->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_gst" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gst->getInputTextType() ?>" name="x_gst" id="x_gst" data-table="packing_list" data-field="x_gst" value="<?= $Page->gst->EditValue ?>" size="30" maxlength="190" placeholder="<?= HtmlEncode($Page->gst->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gst->formatPattern()) ?>"<?= $Page->gst->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gst->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price_exchange->Visible) { // price_exchange ?>
    <div id="r_price_exchange" class="row"<?= $Page->price_exchange->rowAttributes() ?>>
        <label for="x_price_exchange" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_price_exchange"><?= $Page->price_exchange->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price_exchange" id="z_price_exchange" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price_exchange->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_price_exchange" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price_exchange->getInputTextType() ?>" name="x_price_exchange" id="x_price_exchange" data-table="packing_list" data-field="x_price_exchange" value="<?= $Page->price_exchange->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price_exchange->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price_exchange->formatPattern()) ?>"<?= $Page->price_exchange->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price_exchange->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price_exchange_a->Visible) { // price_exchange_a ?>
    <div id="r_price_exchange_a" class="row"<?= $Page->price_exchange_a->rowAttributes() ?>>
        <label for="x_price_exchange_a" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_price_exchange_a"><?= $Page->price_exchange_a->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price_exchange_a" id="z_price_exchange_a" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price_exchange_a->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_price_exchange_a" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price_exchange_a->getInputTextType() ?>" name="x_price_exchange_a" id="x_price_exchange_a" data-table="packing_list" data-field="x_price_exchange_a" value="<?= $Page->price_exchange_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price_exchange_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price_exchange_a->formatPattern()) ?>"<?= $Page->price_exchange_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price_exchange_a->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount_exchange->Visible) { // amount_exchange ?>
    <div id="r_amount_exchange" class="row"<?= $Page->amount_exchange->rowAttributes() ?>>
        <label for="x_amount_exchange" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_amount_exchange"><?= $Page->amount_exchange->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount_exchange" id="z_amount_exchange" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount_exchange->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_amount_exchange" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount_exchange->getInputTextType() ?>" name="x_amount_exchange" id="x_amount_exchange" data-table="packing_list" data-field="x_amount_exchange" value="<?= $Page->amount_exchange->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount_exchange->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount_exchange->formatPattern()) ?>"<?= $Page->amount_exchange->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount_exchange->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
    <div id="r_cbm" class="row"<?= $Page->cbm->rowAttributes() ?>>
        <label for="x_cbm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_cbm"><?= $Page->cbm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cbm" id="z_cbm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cbm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_cbm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cbm->getInputTextType() ?>" name="x_cbm" id="x_cbm" data-table="packing_list" data-field="x_cbm" value="<?= $Page->cbm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cbm->formatPattern()) ?>"<?= $Page->cbm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cbm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->weight->Visible) { // weight ?>
    <div id="r_weight" class="row"<?= $Page->weight->rowAttributes() ?>>
        <label for="x_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_weight"><?= $Page->weight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_weight" id="z_weight" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->weight->getInputTextType() ?>" name="x_weight" id="x_weight" data-table="packing_list" data-field="x_weight" value="<?= $Page->weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->weight->formatPattern()) ?>"<?= $Page->weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_other_ref->Visible) { // partner_other_ref ?>
    <div id="r_partner_other_ref" class="row"<?= $Page->partner_other_ref->rowAttributes() ?>>
        <label for="x_partner_other_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_partner_other_ref"><?= $Page->partner_other_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_other_ref" id="z_partner_other_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_other_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_partner_other_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_other_ref->getInputTextType() ?>" name="x_partner_other_ref" id="x_partner_other_ref" data-table="packing_list" data-field="x_partner_other_ref" value="<?= $Page->partner_other_ref->EditValue ?>" size="30" maxlength="492" placeholder="<?= HtmlEncode($Page->partner_other_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_other_ref->formatPattern()) ?>"<?= $Page->partner_other_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_other_ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
    <div id="r_buyer_loc" class="row"<?= $Page->buyer_loc->rowAttributes() ?>>
        <label for="x_buyer_loc" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_buyer_loc"><?= $Page->buyer_loc->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_loc" id="z_buyer_loc" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_loc->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_buyer_loc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="packing_list" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_po"><?= $Page->po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_po" id="z_po" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="packing_list" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpacking_listsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpacking_listsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpacking_listsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("packing_list");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
