<?php

namespace PHPMaker2024\fibre;

// Page object
$PackingListNoUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { packing_list_no: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fpacking_list_noupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpacking_list_noupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["pl_no", [fields.pl_no.visible && fields.pl_no.required ? ew.Validators.required(fields.pl_no.caption) : null, ew.Validators.float, ew.Validators.selected], fields.pl_no.isInvalid],
            ["buyer_loc", [fields.buyer_loc.visible && fields.buyer_loc.required ? ew.Validators.required(fields.buyer_loc.caption) : null], fields.buyer_loc.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpacking_list_noupdate" id="fpacking_list_noupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="packing_list_no">
<?php if ($Page->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_packing_list_noupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"<?= $Page->Disabled ?>><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->pl_no->Visible && (!$Page->isConfirm() || $Page->pl_no->multiUpdateSelected())) { // pl_no ?>
    <div id="r_pl_no"<?= $Page->pl_no->rowAttributes() ?>>
        <label for="x_pl_no" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_pl_no" id="u_pl_no" class="form-check-input ew-multi-select" value="1"<?= $Page->pl_no->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_pl_no"><?= $Page->pl_no->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_pl_no" id="u_pl_no" value="<?= $Page->pl_no->MultiUpdate ?>">
            <?= $Page->pl_no->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pl_no->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_packing_list_no_pl_no">
                <input type="<?= $Page->pl_no->getInputTextType() ?>" name="x_pl_no" id="x_pl_no" data-table="packing_list_no" data-field="x_pl_no" value="<?= $Page->pl_no->EditValue ?>" size="15" placeholder="<?= HtmlEncode($Page->pl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_no->formatPattern()) ?>"<?= $Page->pl_no->editAttributes() ?> aria-describedby="x_pl_no_help">
                <?= $Page->pl_no->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->pl_no->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_packing_list_no_pl_no">
                <span<?= $Page->pl_no->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->pl_no->getDisplayValue($Page->pl_no->ViewValue))) ?>"></span>
                <input type="hidden" data-table="packing_list_no" data-field="x_pl_no" data-hidden="1" name="x_pl_no" id="x_pl_no" value="<?= HtmlEncode($Page->pl_no->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_loc->Visible && (!$Page->isConfirm() || $Page->buyer_loc->multiUpdateSelected())) { // buyer_loc ?>
    <div id="r_buyer_loc"<?= $Page->buyer_loc->rowAttributes() ?>>
        <label for="x_buyer_loc" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_buyer_loc" id="u_buyer_loc" class="form-check-input ew-multi-select" value="1"<?= $Page->buyer_loc->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_buyer_loc"><?= $Page->buyer_loc->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_buyer_loc" id="u_buyer_loc" value="<?= $Page->buyer_loc->MultiUpdate ?>">
            <?= $Page->buyer_loc->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_loc->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_packing_list_no_buyer_loc">
                <input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="packing_list_no" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?> aria-describedby="x_buyer_loc_help">
                <?= $Page->buyer_loc->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_packing_list_no_buyer_loc">
                <span<?= $Page->buyer_loc->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->buyer_loc->getDisplayValue($Page->buyer_loc->ViewValue))) ?>"></span>
                <input type="hidden" data-table="packing_list_no" data-field="x_buyer_loc" data-hidden="1" name="x_buyer_loc" id="x_buyer_loc" value="<?= HtmlEncode($Page->buyer_loc->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$Page->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpacking_list_noupdate" data-ew-action="set-action" data-value="confirm"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpacking_list_noupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpacking_list_noupdate"><?= $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" form="fpacking_list_noupdate" data-ew-action="set-action" data-value="cancel"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("packing_list_no");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
