<?php

namespace PHPMaker2024\fibre;

// Page object
$PackingListNoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { packing_list_no: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpacking_list_nosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpacking_list_nosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["buyer_po", [], fields.buyer_po.isInvalid],
            ["roll_no", [ew.Validators.integer], fields.roll_no.isInvalid],
            ["y_roll_no", [ew.Validators.between], false],
            ["qty", [ew.Validators.integer], fields.qty.isInvalid],
            ["pl_no", [ew.Validators.float], fields.pl_no.isInvalid],
            ["_barcode", [ew.Validators.integer], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["design_id", [], fields.design_id.isInvalid],
            ["size_buyer", [], fields.size_buyer.isInvalid],
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["sqm_a", [ew.Validators.float], fields.sqm_a.isInvalid],
            ["current_works", [], fields.current_works.isInvalid],
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["buyer_loc", [], fields.buyer_loc.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpacking_list_nosearch" id="fpacking_list_nosearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="packing_list_no">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->buyer_po->Visible) { // buyer_po ?>
    <div id="r_buyer_po" class="row"<?= $Page->buyer_po->rowAttributes() ?>>
        <label for="x_buyer_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_buyer_po"><?= $Page->buyer_po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_po" id="z_buyer_po" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_buyer_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_po->getInputTextType() ?>" name="x_buyer_po" id="x_buyer_po" data-table="packing_list_no" data-field="x_buyer_po" value="<?= $Page->buyer_po->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_po->formatPattern()) ?>"<?= $Page->buyer_po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->roll_no->Visible) { // roll_no ?>
    <div id="r_roll_no" class="row"<?= $Page->roll_no->rowAttributes() ?>>
        <label for="x_roll_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_roll_no"><?= $Page->roll_no->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->roll_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_roll_no" id="z_roll_no" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->roll_no->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->roll_no->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_packing_list_no_roll_no" class="ew-search-field">
<input type="<?= $Page->roll_no->getInputTextType() ?>" name="x_roll_no" id="x_roll_no" data-table="packing_list_no" data-field="x_roll_no" value="<?= $Page->roll_no->EditValue ?>" size="10" placeholder="<?= HtmlEncode($Page->roll_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->roll_no->formatPattern()) ?>"<?= $Page->roll_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->roll_no->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_packing_list_no_roll_no" class="ew-search-field2 d-none">
<input type="<?= $Page->roll_no->getInputTextType() ?>" name="y_roll_no" id="y_roll_no" data-table="packing_list_no" data-field="x_roll_no" value="<?= $Page->roll_no->EditValue2 ?>" size="10" placeholder="<?= HtmlEncode($Page->roll_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->roll_no->formatPattern()) ?>"<?= $Page->roll_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->roll_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <div id="r_qty" class="row"<?= $Page->qty->rowAttributes() ?>>
        <label for="x_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_qty"><?= $Page->qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty" id="z_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty->getInputTextType() ?>" name="x_qty" id="x_qty" data-table="packing_list_no" data-field="x_qty" value="<?= $Page->qty->EditValue ?>" size="10" placeholder="<?= HtmlEncode($Page->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty->formatPattern()) ?>"<?= $Page->qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
    <div id="r_pl_no" class="row"<?= $Page->pl_no->rowAttributes() ?>>
        <label for="x_pl_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_pl_no"><?= $Page->pl_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pl_no" id="z_pl_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pl_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_pl_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pl_no->getInputTextType() ?>" name="x_pl_no" id="x_pl_no" data-table="packing_list_no" data-field="x_pl_no" value="<?= $Page->pl_no->EditValue ?>" size="15" placeholder="<?= HtmlEncode($Page->pl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_no->formatPattern()) ?>"<?= $Page->pl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pl_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no__barcode"><?= $Page->_barcode->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_packing_list_no__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="packing_list_no" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_packing_list_no__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="packing_list_no" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
    <div id="r_buyer_ref" class="row"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label for="x_buyer_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_buyer_ref"><?= $Page->buyer_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_buyer_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_ref->getInputTextType() ?>" name="x_buyer_ref" id="x_buyer_ref" data-table="packing_list_no" data-field="x_buyer_ref" value="<?= $Page->buyer_ref->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_ref->formatPattern()) ?>"<?= $Page->buyer_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id" class="row"<?= $Page->design_id->rowAttributes() ?>>
        <label for="x_design_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_design_id"><?= $Page->design_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_design_id" id="z_design_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_design_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_design_id"
        name="x_design_id"
        class="form-select ew-select<?= $Page->design_id->isInvalidClass() ?>"
        <?php if (!$Page->design_id->IsNativeSelect) { ?>
        data-select2-id="fpacking_list_nosearch_x_design_id"
        <?php } ?>
        data-table="packing_list_no"
        data-field="x_design_id"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage(false) ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
<?php if (!$Page->design_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_list_nosearch", function() {
    var options = { name: "x_design_id", selectId: "fpacking_list_nosearch_x_design_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_list_nosearch.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x_design_id", form: "fpacking_list_nosearch" };
    } else {
        options.ajax = { id: "x_design_id", form: "fpacking_list_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_list_no.fields.design_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_buyer->Visible) { // size_buyer ?>
    <div id="r_size_buyer" class="row"<?= $Page->size_buyer->rowAttributes() ?>>
        <label for="x_size_buyer" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_size_buyer"><?= $Page->size_buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_buyer" id="z_size_buyer" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_size_buyer" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_buyer->getInputTextType() ?>" name="x_size_buyer" id="x_size_buyer" data-table="packing_list_no" data-field="x_size_buyer" value="<?= $Page->size_buyer->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_buyer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_buyer->formatPattern()) ?>"<?= $Page->size_buyer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_buyer->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id" class="row"<?= $Page->buyers_id->rowAttributes() ?>>
        <label for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_buyers_id"><?= $Page->buyers_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyers_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_buyers_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fpacking_list_nosearch_x_buyers_id"
        <?php } ?>
        data-table="packing_list_no"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_list_nosearch", function() {
    var options = { name: "x_buyers_id", selectId: "fpacking_list_nosearch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_list_nosearch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fpacking_list_nosearch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fpacking_list_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_list_no.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_po"><?= $Page->po->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_packing_list_no_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="packing_list_no" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_packing_list_no_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="packing_list_no" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week" class="row"<?= $Page->despatch_week->rowAttributes() ?>>
        <label for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_despatch_week"><?= $Page->despatch_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_despatch_week" id="z_despatch_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatch_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_despatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fpacking_list_nosearch_x_despatch_week"
        <?php } ?>
        data-table="packing_list_no"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_list_nosearch", function() {
    var options = { name: "x_despatch_week", selectId: "fpacking_list_nosearch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_list_nosearch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fpacking_list_nosearch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fpacking_list_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_list_no.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="packing_list_no" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm_a->Visible) { // sqm_a ?>
    <div id="r_sqm_a" class="row"<?= $Page->sqm_a->rowAttributes() ?>>
        <label for="x_sqm_a" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_sqm_a"><?= $Page->sqm_a->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm_a" id="z_sqm_a" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm_a->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_sqm_a" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm_a->getInputTextType() ?>" name="x_sqm_a" id="x_sqm_a" data-table="packing_list_no" data-field="x_sqm_a" value="<?= $Page->sqm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm_a->formatPattern()) ?>"<?= $Page->sqm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm_a->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
    <div id="r_current_works" class="row"<?= $Page->current_works->rowAttributes() ?>>
        <label for="x_current_works" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_current_works"><?= $Page->current_works->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_current_works" id="z_current_works" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->current_works->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_current_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_current_works"
        name="x_current_works"
        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
        <?php if (!$Page->current_works->IsNativeSelect) { ?>
        data-select2-id="fpacking_list_nosearch_x_current_works"
        <?php } ?>
        data-table="packing_list_no"
        data-field="x_current_works"
        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
        <?= $Page->current_works->editAttributes() ?>>
        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage(false) ?></div>
<?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
<?php if (!$Page->current_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_list_nosearch", function() {
    var options = { name: "x_current_works", selectId: "fpacking_list_nosearch_x_current_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_list_nosearch.lists.current_works?.lookupOptions.length) {
        options.data = { id: "x_current_works", form: "fpacking_list_nosearch" };
    } else {
        options.ajax = { id: "x_current_works", form: "fpacking_list_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_list_no.fields.current_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="packing_list_no" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="packing_list_no" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="packing_list_no" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpacking_list_nosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpacking_list_nosearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_loc->Visible) { // buyer_loc ?>
    <div id="r_buyer_loc" class="row"<?= $Page->buyer_loc->rowAttributes() ?>>
        <label for="x_buyer_loc" class="<?= $Page->LeftColumnClass ?>"><span id="elh_packing_list_no_buyer_loc"><?= $Page->buyer_loc->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_loc" id="z_buyer_loc" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_loc->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_packing_list_no_buyer_loc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="packing_list_no" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpacking_list_nosearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpacking_list_nosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpacking_list_nosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("packing_list_no");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
