<?php

namespace PHPMaker2024\fibre;

// Page object
$PackingListNoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { packing_list_no: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpacking_list_nosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpacking_list_nosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["buyer_po", [], fields.buyer_po.isInvalid],
            ["roll_no", [ew.Validators.integer], fields.roll_no.isInvalid],
            ["y_roll_no", [ew.Validators.between], false],
            ["qty", [ew.Validators.integer], fields.qty.isInvalid],
            ["pl_no", [ew.Validators.float], fields.pl_no.isInvalid],
            ["_barcode", [ew.Validators.integer], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["design_id", [], fields.design_id.isInvalid],
            ["size_buyer", [], fields.size_buyer.isInvalid],
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["sqm_a", [ew.Validators.float], fields.sqm_a.isInvalid],
            ["current_works", [], fields.current_works.isInvalid],
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["buyer_loc", [], fields.buyer_loc.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpacking_list_nosearch" id="fpacking_list_nosearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("packinglistnolist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="packing_list_no">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_packing_list_no_buyer_po" class="packing_list_nosearch"><span id="el_packing_list_no_buyer_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_po->getInputTextType() ?>" name="x_buyer_po" id="x_buyer_po" data-table="packing_list_no" data-field="x_buyer_po" value="<?= $Page->buyer_po->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_po->formatPattern()) ?>"<?= $Page->buyer_po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_po->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_packing_list_no_roll_no" class="packing_list_nosearch"><span id="el_packing_list_no_roll_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->roll_no->getInputTextType() ?>" name="x_roll_no" id="x_roll_no" data-table="packing_list_no" data-field="x_roll_no" value="<?= $Page->roll_no->EditValue ?>" size="10" placeholder="<?= HtmlEncode($Page->roll_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->roll_no->formatPattern()) ?>"<?= $Page->roll_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->roll_no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_packing_list_no_qty" class="packing_list_nosearch"><span id="el_packing_list_no_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty->getInputTextType() ?>" name="x_qty" id="x_qty" data-table="packing_list_no" data-field="x_qty" value="<?= $Page->qty->EditValue ?>" size="10" placeholder="<?= HtmlEncode($Page->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty->formatPattern()) ?>"<?= $Page->qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_packing_list_no_pl_no" class="packing_list_nosearch"><span id="el_packing_list_no_pl_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pl_no->getInputTextType() ?>" name="x_pl_no" id="x_pl_no" data-table="packing_list_no" data-field="x_pl_no" value="<?= $Page->pl_no->EditValue ?>" size="15" placeholder="<?= HtmlEncode($Page->pl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_no->formatPattern()) ?>"<?= $Page->pl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pl_no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_packing_list_no__barcode" class="packing_list_nosearch"><span id="el_packing_list_no__barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="packing_list_no" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_packing_list_no_buyer_ref" class="packing_list_nosearch"><span id="el_packing_list_no_buyer_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_ref->getInputTextType() ?>" name="x_buyer_ref" id="x_buyer_ref" data-table="packing_list_no" data-field="x_buyer_ref" value="<?= $Page->buyer_ref->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_ref->formatPattern()) ?>"<?= $Page->buyer_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_packing_list_no_design_id" class="packing_list_nosearch"><span id="el_packing_list_no_design_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_design_id"
        name="x_design_id"
        class="form-select ew-select<?= $Page->design_id->isInvalidClass() ?>"
        <?php if (!$Page->design_id->IsNativeSelect) { ?>
        data-select2-id="fpacking_list_nosearch_x_design_id"
        <?php } ?>
        data-table="packing_list_no"
        data-field="x_design_id"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage(false) ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
<?php if (!$Page->design_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_list_nosearch", function() {
    var options = { name: "x_design_id", selectId: "fpacking_list_nosearch_x_design_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_list_nosearch.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x_design_id", form: "fpacking_list_nosearch" };
    } else {
        options.ajax = { id: "x_design_id", form: "fpacking_list_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_list_no.fields.design_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_packing_list_no_size_buyer" class="packing_list_nosearch"><span id="el_packing_list_no_size_buyer" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_buyer->getInputTextType() ?>" name="x_size_buyer" id="x_size_buyer" data-table="packing_list_no" data-field="x_size_buyer" value="<?= $Page->size_buyer->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_buyer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_buyer->formatPattern()) ?>"<?= $Page->size_buyer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_buyer->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_packing_list_no_buyers_id" class="packing_list_nosearch"><span id="el_packing_list_no_buyers_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fpacking_list_nosearch_x_buyers_id"
        <?php } ?>
        data-table="packing_list_no"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_list_nosearch", function() {
    var options = { name: "x_buyers_id", selectId: "fpacking_list_nosearch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_list_nosearch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fpacking_list_nosearch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fpacking_list_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_list_no.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_packing_list_no_po" class="packing_list_nosearch"><span id="el_packing_list_no_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="packing_list_no" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_packing_list_no_despatch_week" class="packing_list_nosearch"><span id="el_packing_list_no_despatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fpacking_list_nosearch_x_despatch_week"
        <?php } ?>
        data-table="packing_list_no"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_list_nosearch", function() {
    var options = { name: "x_despatch_week", selectId: "fpacking_list_nosearch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_list_nosearch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fpacking_list_nosearch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fpacking_list_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_list_no.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_packing_list_no_sqm" class="packing_list_nosearch"><span id="el_packing_list_no_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="packing_list_no" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_packing_list_no_sqm_a" class="packing_list_nosearch"><span id="el_packing_list_no_sqm_a" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm_a->getInputTextType() ?>" name="x_sqm_a" id="x_sqm_a" data-table="packing_list_no" data-field="x_sqm_a" value="<?= $Page->sqm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm_a->formatPattern()) ?>"<?= $Page->sqm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm_a->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_packing_list_no_current_works" class="packing_list_nosearch"><span id="el_packing_list_no_current_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_current_works"
        name="x_current_works"
        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
        <?php if (!$Page->current_works->IsNativeSelect) { ?>
        data-select2-id="fpacking_list_nosearch_x_current_works"
        <?php } ?>
        data-table="packing_list_no"
        data-field="x_current_works"
        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
        <?= $Page->current_works->editAttributes() ?>>
        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage(false) ?></div>
<?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
<?php if (!$Page->current_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fpacking_list_nosearch", function() {
    var options = { name: "x_current_works", selectId: "fpacking_list_nosearch_x_current_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpacking_list_nosearch.lists.current_works?.lookupOptions.length) {
        options.data = { id: "x_current_works", form: "fpacking_list_nosearch" };
    } else {
        options.ajax = { id: "x_current_works", form: "fpacking_list_nosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.packing_list_no.fields.current_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_packing_list_no_id" class="packing_list_nosearch"><span id="el_packing_list_no_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="packing_list_no" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_packing_list_no_operator" class="packing_list_nosearch"><span id="el_packing_list_no_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="packing_list_no" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_packing_list_no_datetime" class="packing_list_nosearch"><span id="el_packing_list_no_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="packing_list_no" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpacking_list_nosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpacking_list_nosearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_packing_list_no_buyer_loc" class="packing_list_nosearch"><span id="el_packing_list_no_buyer_loc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_loc->getInputTextType() ?>" name="x_buyer_loc" id="x_buyer_loc" data-table="packing_list_no" data-field="x_buyer_loc" value="<?= $Page->buyer_loc->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_loc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_loc->formatPattern()) ?>"<?= $Page->buyer_loc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_loc->getErrorMessage(false) ?></div>
</span></template>
<div id="packing_list_no_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "buyer_po",
                type: "string",
                label: currentTable.fields.buyer_po.caption,
                operators: currentTable.fields.buyer_po.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.buyer_po.validators),
                data: {
                    format: currentTable.fields.buyer_po.clientFormatPattern
                }
            },
            {
                id: "roll_no",
                type: "integer",
                label: currentTable.fields.roll_no.caption,
                operators: currentTable.fields.roll_no.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.roll_no.validators),
                data: {
                    format: currentTable.fields.roll_no.clientFormatPattern
                }
            },
            {
                id: "qty",
                type: "integer",
                label: currentTable.fields.qty.caption,
                operators: currentTable.fields.qty.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.qty.validators),
                data: {
                    format: currentTable.fields.qty.clientFormatPattern
                }
            },
            {
                id: "pl_no",
                type: "double",
                label: currentTable.fields.pl_no.caption,
                operators: currentTable.fields.pl_no.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.pl_no.validators),
                data: {
                    format: currentTable.fields.pl_no.clientFormatPattern
                }
            },
            {
                id: "_barcode",
                type: "integer",
                label: currentTable.fields._barcode.caption,
                operators: currentTable.fields._barcode.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields._barcode.validators),
                data: {
                    format: currentTable.fields._barcode.clientFormatPattern
                }
            },
            {
                id: "buyer_ref",
                type: "integer",
                label: currentTable.fields.buyer_ref.caption,
                operators: currentTable.fields.buyer_ref.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.buyer_ref.validators),
                data: {
                    format: currentTable.fields.buyer_ref.clientFormatPattern
                }
            },
            {
                id: "design_id",
                type: "string",
                label: currentTable.fields.design_id.caption,
                operators: currentTable.fields.design_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.design_id.validators),
                data: {
                    format: currentTable.fields.design_id.clientFormatPattern
                }
            },
            {
                id: "size_buyer",
                type: "string",
                label: currentTable.fields.size_buyer.caption,
                operators: currentTable.fields.size_buyer.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.size_buyer.validators),
                data: {
                    format: currentTable.fields.size_buyer.clientFormatPattern
                }
            },
            {
                id: "buyers_id",
                type: "integer",
                label: currentTable.fields.buyers_id.caption,
                operators: currentTable.fields.buyers_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.buyers_id.validators),
                data: {
                    format: currentTable.fields.buyers_id.clientFormatPattern
                }
            },
            {
                id: "po",
                type: "integer",
                label: currentTable.fields.po.caption,
                operators: currentTable.fields.po.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.po.validators),
                data: {
                    format: currentTable.fields.po.clientFormatPattern
                }
            },
            {
                id: "despatch_week",
                type: "integer",
                label: currentTable.fields.despatch_week.caption,
                operators: currentTable.fields.despatch_week.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.despatch_week.validators),
                data: {
                    format: currentTable.fields.despatch_week.clientFormatPattern
                }
            },
            {
                id: "sqm",
                type: "double",
                label: currentTable.fields.sqm.caption,
                operators: currentTable.fields.sqm.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.sqm.validators),
                data: {
                    format: currentTable.fields.sqm.clientFormatPattern
                }
            },
            {
                id: "sqm_a",
                type: "double",
                label: currentTable.fields.sqm_a.caption,
                operators: currentTable.fields.sqm_a.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.sqm_a.validators),
                data: {
                    format: currentTable.fields.sqm_a.clientFormatPattern
                }
            },
            {
                id: "current_works",
                type: "integer",
                label: currentTable.fields.current_works.caption,
                operators: currentTable.fields.current_works.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.current_works.validators),
                data: {
                    format: currentTable.fields.current_works.clientFormatPattern
                }
            },
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
            {
                id: "buyer_loc",
                type: "string",
                label: currentTable.fields.buyer_loc.caption,
                operators: currentTable.fields.buyer_loc.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpacking_list_nosearch.fields.buyer_loc.validators),
                data: {
                    format: currentTable.fields.buyer_loc.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#packing_list_no_query_builder"),
        args = {},
        rules = ew.parseJson($("#fpacking_list_nosearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fpacking_list_nosearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fpacking_list_nosearch" formaction="<?= HtmlEncode(GetUrl("packinglistnolist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpacking_list_nosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fpacking_list_nosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("packing_list_no");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
