<?php

namespace PHPMaker2024\fibre;

// Page object
$PStockSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { p_stock: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fp_stocksearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fp_stocksearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["s_date", [ew.Validators.datetime(fields.s_date.clientFormatPattern)], fields.s_date.isInvalid],
            ["stock_id", [], fields.stock_id.isInvalid],
            ["location", [ew.Validators.integer], fields.location.isInvalid],
            ["rid", [ew.Validators.integer], fields.rid.isInvalid],
            ["packing_type", [ew.Validators.integer], fields.packing_type.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["b_stock_packets", [ew.Validators.float], fields.b_stock_packets.isInvalid],
            ["b_stock", [ew.Validators.float], fields.b_stock.isInvalid],
            ["p_stock_packets", [ew.Validators.float], fields.p_stock_packets.isInvalid],
            ["p_stock", [ew.Validators.float], fields.p_stock.isInvalid],
            ["shortage_packets", [ew.Validators.float], fields.shortage_packets.isInvalid],
            ["shortage", [ew.Validators.float], fields.shortage.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["remarks_1", [], fields.remarks_1.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "stock_id": <?= $Page->stock_id->toClientList($Page) ?>,
            "location": <?= $Page->location->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fp_stocksearch" id="fp_stocksearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="p_stock">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="p_stock" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_date->Visible) { // s_date ?>
    <div id="r_s_date" class="row"<?= $Page->s_date->rowAttributes() ?>>
        <label for="x_s_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_s_date"><?= $Page->s_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_date" id="z_s_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_s_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->s_date->getInputTextType() ?>" name="x_s_date" id="x_s_date" data-table="p_stock" data-field="x_s_date" value="<?= $Page->s_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->s_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->s_date->formatPattern()) ?>"<?= $Page->s_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->s_date->getErrorMessage(false) ?></div>
<?php if (!$Page->s_date->ReadOnly && !$Page->s_date->Disabled && !isset($Page->s_date->EditAttrs["readonly"]) && !isset($Page->s_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fp_stocksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fp_stocksearch", "x_s_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->stock_id->Visible) { // stock_id ?>
    <div id="r_stock_id" class="row"<?= $Page->stock_id->rowAttributes() ?>>
        <label for="x_stock_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_stock_id"><?= $Page->stock_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_stock_id" id="z_stock_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->stock_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_stock_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_stock_id"
        name="x_stock_id"
        class="form-control ew-select<?= $Page->stock_id->isInvalidClass() ?>"
        data-select2-id="fp_stocksearch_x_stock_id"
        data-table="p_stock"
        data-field="x_stock_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->stock_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->stock_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->stock_id->getPlaceHolder()) ?>"
        <?= $Page->stock_id->editAttributes() ?>>
        <?= $Page->stock_id->selectOptionListHtml("x_stock_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->stock_id->getErrorMessage(false) ?></div>
<?= $Page->stock_id->Lookup->getParamTag($Page, "p_x_stock_id") ?>
<script>
loadjs.ready("fp_stocksearch", function() {
    var options = { name: "x_stock_id", selectId: "fp_stocksearch_x_stock_id" };
    if (fp_stocksearch.lists.stock_id?.lookupOptions.length) {
        options.data = { id: "x_stock_id", form: "fp_stocksearch" };
    } else {
        options.ajax = { id: "x_stock_id", form: "fp_stocksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_stock.fields.stock_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-control ew-select<?= $Page->location->isInvalidClass() ?>"
        data-select2-id="fp_stocksearch_x_location"
        data-table="p_stock"
        data-field="x_location"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->location->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<script>
loadjs.ready("fp_stocksearch", function() {
    var options = { name: "x_location", selectId: "fp_stocksearch_x_location" };
    if (fp_stocksearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fp_stocksearch" };
    } else {
        options.ajax = { id: "x_location", form: "fp_stocksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_stock.fields.location.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid" id="z_rid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid"
        name="x_rid"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fp_stocksearch_x_rid"
        data-table="p_stock"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<script>
loadjs.ready("fp_stocksearch", function() {
    var options = { name: "x_rid", selectId: "fp_stocksearch_x_rid" };
    if (fp_stocksearch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fp_stocksearch" };
    } else {
        options.ajax = { id: "x_rid", form: "fp_stocksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_stock.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-control ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        data-select2-id="fp_stocksearch_x_packing_type"
        data-table="p_stock"
        data-field="x_packing_type"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->packing_type->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<script>
loadjs.ready("fp_stocksearch", function() {
    var options = { name: "x_packing_type", selectId: "fp_stocksearch_x_packing_type" };
    if (fp_stocksearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fp_stocksearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fp_stocksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_stock.fields.packing_type.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_lot_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="p_stock" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_stock_packets->Visible) { // b_stock_packets ?>
    <div id="r_b_stock_packets" class="row"<?= $Page->b_stock_packets->rowAttributes() ?>>
        <label for="x_b_stock_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_b_stock_packets"><?= $Page->b_stock_packets->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_b_stock_packets" id="z_b_stock_packets" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_stock_packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_b_stock_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_stock_packets->getInputTextType() ?>" name="x_b_stock_packets" id="x_b_stock_packets" data-table="p_stock" data-field="x_b_stock_packets" value="<?= $Page->b_stock_packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->b_stock_packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_stock_packets->formatPattern()) ?>"<?= $Page->b_stock_packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_stock_packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_stock->Visible) { // b_stock ?>
    <div id="r_b_stock" class="row"<?= $Page->b_stock->rowAttributes() ?>>
        <label for="x_b_stock" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_b_stock"><?= $Page->b_stock->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_b_stock" id="z_b_stock" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_stock->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_b_stock" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_stock->getInputTextType() ?>" name="x_b_stock" id="x_b_stock" data-table="p_stock" data-field="x_b_stock" value="<?= $Page->b_stock->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->b_stock->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_stock->formatPattern()) ?>"<?= $Page->b_stock->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_stock->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->p_stock_packets->Visible) { // p_stock_packets ?>
    <div id="r_p_stock_packets" class="row"<?= $Page->p_stock_packets->rowAttributes() ?>>
        <label for="x_p_stock_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_p_stock_packets"><?= $Page->p_stock_packets->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_p_stock_packets" id="z_p_stock_packets" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->p_stock_packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_p_stock_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->p_stock_packets->getInputTextType() ?>" name="x_p_stock_packets" id="x_p_stock_packets" data-table="p_stock" data-field="x_p_stock_packets" value="<?= $Page->p_stock_packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->p_stock_packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->p_stock_packets->formatPattern()) ?>"<?= $Page->p_stock_packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->p_stock_packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->p_stock->Visible) { // p_stock ?>
    <div id="r_p_stock" class="row"<?= $Page->p_stock->rowAttributes() ?>>
        <label for="x_p_stock" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_p_stock"><?= $Page->p_stock->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_p_stock" id="z_p_stock" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->p_stock->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_p_stock" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->p_stock->getInputTextType() ?>" name="x_p_stock" id="x_p_stock" data-table="p_stock" data-field="x_p_stock" value="<?= $Page->p_stock->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->p_stock->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->p_stock->formatPattern()) ?>"<?= $Page->p_stock->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->p_stock->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shortage_packets->Visible) { // shortage_packets ?>
    <div id="r_shortage_packets" class="row"<?= $Page->shortage_packets->rowAttributes() ?>>
        <label for="x_shortage_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_shortage_packets"><?= $Page->shortage_packets->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_shortage_packets" id="z_shortage_packets" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shortage_packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_shortage_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->shortage_packets->getInputTextType() ?>" name="x_shortage_packets" id="x_shortage_packets" data-table="p_stock" data-field="x_shortage_packets" value="<?= $Page->shortage_packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->shortage_packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shortage_packets->formatPattern()) ?>"<?= $Page->shortage_packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->shortage_packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shortage->Visible) { // shortage ?>
    <div id="r_shortage" class="row"<?= $Page->shortage->rowAttributes() ?>>
        <label for="x_shortage" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_shortage"><?= $Page->shortage->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_shortage" id="z_shortage" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shortage->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_shortage" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->shortage->getInputTextType() ?>" name="x_shortage" id="x_shortage" data-table="p_stock" data-field="x_shortage" value="<?= $Page->shortage->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->shortage->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shortage->formatPattern()) ?>"<?= $Page->shortage->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->shortage->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="p_stock" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks_1->Visible) { // remarks_1 ?>
    <div id="r_remarks_1" class="row"<?= $Page->remarks_1->rowAttributes() ?>>
        <label for="x_remarks_1" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_remarks_1"><?= $Page->remarks_1->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks_1" id="z_remarks_1" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks_1->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_remarks_1" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks_1->getInputTextType() ?>" name="x_remarks_1" id="x_remarks_1" data-table="p_stock" data-field="x_remarks_1" value="<?= $Page->remarks_1->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks_1->formatPattern()) ?>"<?= $Page->remarks_1->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks_1->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fp_stocksearch_x_operator"
        <?php } ?>
        data-table="p_stock"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_stocksearch", function() {
    var options = { name: "x_operator", selectId: "fp_stocksearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_stocksearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fp_stocksearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fp_stocksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_stock.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_stock_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_stock_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="p_stock" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fp_stocksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fp_stocksearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fp_stocksearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fp_stocksearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fp_stocksearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("p_stock");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
