<?php

namespace PHPMaker2024\fibre;

// Page object
$PStockEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fp_stockedit" id="fp_stockedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { p_stock: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fp_stockedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fp_stockedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["s_date", [fields.s_date.visible && fields.s_date.required ? ew.Validators.required(fields.s_date.caption) : null], fields.s_date.isInvalid],
            ["stock_id", [fields.stock_id.visible && fields.stock_id.required ? ew.Validators.required(fields.stock_id.caption) : null], fields.stock_id.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["lot_no", [fields.lot_no.visible && fields.lot_no.required ? ew.Validators.required(fields.lot_no.caption) : null], fields.lot_no.isInvalid],
            ["b_stock_packets", [fields.b_stock_packets.visible && fields.b_stock_packets.required ? ew.Validators.required(fields.b_stock_packets.caption) : null], fields.b_stock_packets.isInvalid],
            ["b_stock", [fields.b_stock.visible && fields.b_stock.required ? ew.Validators.required(fields.b_stock.caption) : null], fields.b_stock.isInvalid],
            ["p_stock_packets", [fields.p_stock_packets.visible && fields.p_stock_packets.required ? ew.Validators.required(fields.p_stock_packets.caption) : null, ew.Validators.float], fields.p_stock_packets.isInvalid],
            ["p_stock", [fields.p_stock.visible && fields.p_stock.required ? ew.Validators.required(fields.p_stock.caption) : null, ew.Validators.float], fields.p_stock.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["remarks_1", [fields.remarks_1.visible && fields.remarks_1.required ? ew.Validators.required(fields.remarks_1.caption) : null], fields.remarks_1.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="p_stock">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_p_stock_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_p_stock_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="p_stock" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_date->Visible) { // s_date ?>
    <div id="r_s_date"<?= $Page->s_date->rowAttributes() ?>>
        <label id="elh_p_stock_s_date" for="x_s_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_date->caption() ?><?= $Page->s_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_date->cellAttributes() ?>>
<span id="el_p_stock_s_date">
<span<?= $Page->s_date->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->s_date->getDisplayValue($Page->s_date->EditValue))) ?>"></span>
<input type="hidden" data-table="p_stock" data-field="x_s_date" data-hidden="1" name="x_s_date" id="x_s_date" value="<?= HtmlEncode($Page->s_date->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->stock_id->Visible) { // stock_id ?>
    <div id="r_stock_id"<?= $Page->stock_id->rowAttributes() ?>>
        <label id="elh_p_stock_stock_id" for="x_stock_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->stock_id->caption() ?><?= $Page->stock_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->stock_id->cellAttributes() ?>>
<span id="el_p_stock_stock_id">
<span<?= $Page->stock_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->stock_id->getDisplayValue($Page->stock_id->EditValue) ?></span></span>
<input type="hidden" data-table="p_stock" data-field="x_stock_id" data-hidden="1" name="x_stock_id" id="x_stock_id" value="<?= HtmlEncode($Page->stock_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_p_stock_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_p_stock_location">
<span<?= $Page->location->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->location->getDisplayValue($Page->location->EditValue) ?></span></span>
<input type="hidden" data-table="p_stock" data-field="x_location" data-hidden="1" name="x_location" id="x_location" value="<?= HtmlEncode($Page->location->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label id="elh_p_stock_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid->cellAttributes() ?>>
<span id="el_p_stock_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->rid->getDisplayValue($Page->rid->EditValue) ?></span></span>
<input type="hidden" data-table="p_stock" data-field="x_rid" data-hidden="1" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type"<?= $Page->packing_type->rowAttributes() ?>>
        <label id="elh_p_stock_packing_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packing_type->caption() ?><?= $Page->packing_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packing_type->cellAttributes() ?>>
<span id="el_p_stock_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->packing_type->getDisplayValue($Page->packing_type->EditValue) ?></span></span>
<input type="hidden" data-table="p_stock" data-field="x_packing_type" data-hidden="1" name="x_packing_type" id="x_packing_type" value="<?= HtmlEncode($Page->packing_type->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no"<?= $Page->lot_no->rowAttributes() ?>>
        <label id="elh_p_stock_lot_no" for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lot_no->caption() ?><?= $Page->lot_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lot_no->cellAttributes() ?>>
<span id="el_p_stock_lot_no">
<span<?= $Page->lot_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->lot_no->getDisplayValue($Page->lot_no->EditValue))) ?>"></span>
<input type="hidden" data-table="p_stock" data-field="x_lot_no" data-hidden="1" name="x_lot_no" id="x_lot_no" value="<?= HtmlEncode($Page->lot_no->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->b_stock_packets->Visible) { // b_stock_packets ?>
    <div id="r_b_stock_packets"<?= $Page->b_stock_packets->rowAttributes() ?>>
        <label id="elh_p_stock_b_stock_packets" for="x_b_stock_packets" class="<?= $Page->LeftColumnClass ?>"><?= $Page->b_stock_packets->caption() ?><?= $Page->b_stock_packets->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->b_stock_packets->cellAttributes() ?>>
<span id="el_p_stock_b_stock_packets">
<span<?= $Page->b_stock_packets->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->b_stock_packets->getDisplayValue($Page->b_stock_packets->EditValue))) ?>"></span>
<input type="hidden" data-table="p_stock" data-field="x_b_stock_packets" data-hidden="1" name="x_b_stock_packets" id="x_b_stock_packets" value="<?= HtmlEncode($Page->b_stock_packets->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->b_stock->Visible) { // b_stock ?>
    <div id="r_b_stock"<?= $Page->b_stock->rowAttributes() ?>>
        <label id="elh_p_stock_b_stock" for="x_b_stock" class="<?= $Page->LeftColumnClass ?>"><?= $Page->b_stock->caption() ?><?= $Page->b_stock->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->b_stock->cellAttributes() ?>>
<span id="el_p_stock_b_stock">
<span<?= $Page->b_stock->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->b_stock->getDisplayValue($Page->b_stock->EditValue))) ?>"></span>
<input type="hidden" data-table="p_stock" data-field="x_b_stock" data-hidden="1" name="x_b_stock" id="x_b_stock" value="<?= HtmlEncode($Page->b_stock->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->p_stock_packets->Visible) { // p_stock_packets ?>
    <div id="r_p_stock_packets"<?= $Page->p_stock_packets->rowAttributes() ?>>
        <label id="elh_p_stock_p_stock_packets" for="x_p_stock_packets" class="<?= $Page->LeftColumnClass ?>"><?= $Page->p_stock_packets->caption() ?><?= $Page->p_stock_packets->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->p_stock_packets->cellAttributes() ?>>
<span id="el_p_stock_p_stock_packets">
<input type="<?= $Page->p_stock_packets->getInputTextType() ?>" name="x_p_stock_packets" id="x_p_stock_packets" data-table="p_stock" data-field="x_p_stock_packets" value="<?= $Page->p_stock_packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->p_stock_packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->p_stock_packets->formatPattern()) ?>"<?= $Page->p_stock_packets->editAttributes() ?> aria-describedby="x_p_stock_packets_help">
<?= $Page->p_stock_packets->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->p_stock_packets->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->p_stock->Visible) { // p_stock ?>
    <div id="r_p_stock"<?= $Page->p_stock->rowAttributes() ?>>
        <label id="elh_p_stock_p_stock" for="x_p_stock" class="<?= $Page->LeftColumnClass ?>"><?= $Page->p_stock->caption() ?><?= $Page->p_stock->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->p_stock->cellAttributes() ?>>
<span id="el_p_stock_p_stock">
<input type="<?= $Page->p_stock->getInputTextType() ?>" name="x_p_stock" id="x_p_stock" data-table="p_stock" data-field="x_p_stock" value="<?= $Page->p_stock->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->p_stock->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->p_stock->formatPattern()) ?>"<?= $Page->p_stock->editAttributes() ?> aria-describedby="x_p_stock_help">
<?= $Page->p_stock->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->p_stock->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_p_stock_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_p_stock_remarks">
<textarea data-table="p_stock" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks_1->Visible) { // remarks_1 ?>
    <div id="r_remarks_1"<?= $Page->remarks_1->rowAttributes() ?>>
        <label id="elh_p_stock_remarks_1" for="x_remarks_1" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks_1->caption() ?><?= $Page->remarks_1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks_1->cellAttributes() ?>>
<span id="el_p_stock_remarks_1">
<input type="<?= $Page->remarks_1->getInputTextType() ?>" name="x_remarks_1" id="x_remarks_1" data-table="p_stock" data-field="x_remarks_1" value="<?= $Page->remarks_1->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks_1->formatPattern()) ?>"<?= $Page->remarks_1->editAttributes() ?> aria-describedby="x_remarks_1_help">
<?= $Page->remarks_1->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks_1->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fp_stockedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fp_stockedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("p_stock");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
