<?php

namespace PHPMaker2024\fibre;

// Page object
$PStockAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { p_stock: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fp_stockadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fp_stockadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["s_date", [fields.s_date.visible && fields.s_date.required ? ew.Validators.required(fields.s_date.caption) : null, ew.Validators.datetime(fields.s_date.clientFormatPattern)], fields.s_date.isInvalid],
            ["stock_id", [fields.stock_id.visible && fields.stock_id.required ? ew.Validators.required(fields.stock_id.caption) : null], fields.stock_id.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null, ew.Validators.integer], fields.location.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null, ew.Validators.integer], fields.rid.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null, ew.Validators.integer], fields.packing_type.isInvalid],
            ["lot_no", [fields.lot_no.visible && fields.lot_no.required ? ew.Validators.required(fields.lot_no.caption) : null], fields.lot_no.isInvalid],
            ["b_stock_packets", [fields.b_stock_packets.visible && fields.b_stock_packets.required ? ew.Validators.required(fields.b_stock_packets.caption) : null, ew.Validators.float], fields.b_stock_packets.isInvalid],
            ["b_stock", [fields.b_stock.visible && fields.b_stock.required ? ew.Validators.required(fields.b_stock.caption) : null, ew.Validators.float], fields.b_stock.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "stock_id": <?= $Page->stock_id->toClientList($Page) ?>,
            "location": <?= $Page->location->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fp_stockadd" id="fp_stockadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="p_stock">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->s_date->Visible) { // s_date ?>
    <div id="r_s_date"<?= $Page->s_date->rowAttributes() ?>>
        <label id="elh_p_stock_s_date" for="x_s_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_date->caption() ?><?= $Page->s_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_date->cellAttributes() ?>>
<span id="el_p_stock_s_date">
<input type="<?= $Page->s_date->getInputTextType() ?>" name="x_s_date" id="x_s_date" data-table="p_stock" data-field="x_s_date" value="<?= $Page->s_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->s_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->s_date->formatPattern()) ?>"<?= $Page->s_date->editAttributes() ?> aria-describedby="x_s_date_help">
<?= $Page->s_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->s_date->getErrorMessage() ?></div>
<?php if (!$Page->s_date->ReadOnly && !$Page->s_date->Disabled && !isset($Page->s_date->EditAttrs["readonly"]) && !isset($Page->s_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fp_stockadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fp_stockadd", "x_s_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->stock_id->Visible) { // stock_id ?>
    <div id="r_stock_id"<?= $Page->stock_id->rowAttributes() ?>>
        <label id="elh_p_stock_stock_id" for="x_stock_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->stock_id->caption() ?><?= $Page->stock_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->stock_id->cellAttributes() ?>>
<span id="el_p_stock_stock_id">
    <select
        id="x_stock_id"
        name="x_stock_id"
        class="form-control ew-select<?= $Page->stock_id->isInvalidClass() ?>"
        data-select2-id="fp_stockadd_x_stock_id"
        data-table="p_stock"
        data-field="x_stock_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->stock_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->stock_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->stock_id->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->stock_id->editAttributes() ?>>
        <?= $Page->stock_id->selectOptionListHtml("x_stock_id") ?>
    </select>
    <?= $Page->stock_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->stock_id->getErrorMessage() ?></div>
<?= $Page->stock_id->Lookup->getParamTag($Page, "p_x_stock_id") ?>
<script>
loadjs.ready("fp_stockadd", function() {
    var options = { name: "x_stock_id", selectId: "fp_stockadd_x_stock_id" };
    if (fp_stockadd.lists.stock_id?.lookupOptions.length) {
        options.data = { id: "x_stock_id", form: "fp_stockadd" };
    } else {
        options.ajax = { id: "x_stock_id", form: "fp_stockadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_stock.fields.stock_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_p_stock_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_p_stock_location">
    <select
        id="x_location"
        name="x_location"
        class="form-control ew-select<?= $Page->location->isInvalidClass() ?>"
        data-select2-id="fp_stockadd_x_location"
        data-table="p_stock"
        data-field="x_location"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->location->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <?= $Page->location->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<script>
loadjs.ready("fp_stockadd", function() {
    var options = { name: "x_location", selectId: "fp_stockadd_x_location" };
    if (fp_stockadd.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fp_stockadd" };
    } else {
        options.ajax = { id: "x_location", form: "fp_stockadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_stock.fields.location.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label id="elh_p_stock_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid->cellAttributes() ?>>
<span id="el_p_stock_rid">
    <select
        id="x_rid"
        name="x_rid"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fp_stockadd_x_rid"
        data-table="p_stock"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <?= $Page->rid->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage() ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<script>
loadjs.ready("fp_stockadd", function() {
    var options = { name: "x_rid", selectId: "fp_stockadd_x_rid" };
    if (fp_stockadd.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fp_stockadd" };
    } else {
        options.ajax = { id: "x_rid", form: "fp_stockadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_stock.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type"<?= $Page->packing_type->rowAttributes() ?>>
        <label id="elh_p_stock_packing_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packing_type->caption() ?><?= $Page->packing_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packing_type->cellAttributes() ?>>
<span id="el_p_stock_packing_type">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-control ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        data-select2-id="fp_stockadd_x_packing_type"
        data-table="p_stock"
        data-field="x_packing_type"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->packing_type->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <?= $Page->packing_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage() ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<script>
loadjs.ready("fp_stockadd", function() {
    var options = { name: "x_packing_type", selectId: "fp_stockadd_x_packing_type" };
    if (fp_stockadd.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fp_stockadd" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fp_stockadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_stock.fields.packing_type.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no"<?= $Page->lot_no->rowAttributes() ?>>
        <label id="elh_p_stock_lot_no" for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lot_no->caption() ?><?= $Page->lot_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lot_no->cellAttributes() ?>>
<span id="el_p_stock_lot_no">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="p_stock" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?> aria-describedby="x_lot_no_help">
<?= $Page->lot_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->b_stock_packets->Visible) { // b_stock_packets ?>
    <div id="r_b_stock_packets"<?= $Page->b_stock_packets->rowAttributes() ?>>
        <label id="elh_p_stock_b_stock_packets" for="x_b_stock_packets" class="<?= $Page->LeftColumnClass ?>"><?= $Page->b_stock_packets->caption() ?><?= $Page->b_stock_packets->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->b_stock_packets->cellAttributes() ?>>
<span id="el_p_stock_b_stock_packets">
<input type="<?= $Page->b_stock_packets->getInputTextType() ?>" name="x_b_stock_packets" id="x_b_stock_packets" data-table="p_stock" data-field="x_b_stock_packets" value="<?= $Page->b_stock_packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->b_stock_packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_stock_packets->formatPattern()) ?>"<?= $Page->b_stock_packets->editAttributes() ?> aria-describedby="x_b_stock_packets_help">
<?= $Page->b_stock_packets->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->b_stock_packets->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->b_stock->Visible) { // b_stock ?>
    <div id="r_b_stock"<?= $Page->b_stock->rowAttributes() ?>>
        <label id="elh_p_stock_b_stock" for="x_b_stock" class="<?= $Page->LeftColumnClass ?>"><?= $Page->b_stock->caption() ?><?= $Page->b_stock->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->b_stock->cellAttributes() ?>>
<span id="el_p_stock_b_stock">
<input type="<?= $Page->b_stock->getInputTextType() ?>" name="x_b_stock" id="x_b_stock" data-table="p_stock" data-field="x_b_stock" value="<?= $Page->b_stock->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->b_stock->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_stock->formatPattern()) ?>"<?= $Page->b_stock->editAttributes() ?> aria-describedby="x_b_stock_help">
<?= $Page->b_stock->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->b_stock->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fp_stockadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fp_stockadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("p_stock");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
