<?php

namespace PHPMaker2024\fibre;

// Page object
$PSizeAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { p_size: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fp_sizeadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fp_sizeadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["description", [fields.description.visible && fields.description.required ? ew.Validators.required(fields.description.caption) : null], fields.description.isInvalid],
            ["size", [fields.size.visible && fields.size.required ? ew.Validators.required(fields.size.caption) : null], fields.size.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["qty_in_sheet", [fields.qty_in_sheet.visible && fields.qty_in_sheet.required ? ew.Validators.required(fields.qty_in_sheet.caption) : null, ew.Validators.float], fields.qty_in_sheet.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "type": <?= $Page->type->toClientList($Page) ?>,
            "size": <?= $Page->size->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fp_sizeadd" id="fp_sizeadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="p_size">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type"<?= $Page->type->rowAttributes() ?>>
        <label id="elh_p_size_type" for="x_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->type->caption() ?><?= $Page->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->type->cellAttributes() ?>>
<span id="el_p_size_type">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="fp_sizeadd_x_type"
        <?php } ?>
        data-table="p_size"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <?= $Page->type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage() ?></div>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_sizeadd", function() {
    var options = { name: "x_type", selectId: "fp_sizeadd_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_sizeadd.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "fp_sizeadd" };
    } else {
        options.ajax = { id: "x_type", form: "fp_sizeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_size.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description"<?= $Page->description->rowAttributes() ?>>
        <label id="elh_p_size_description" for="x_description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description->caption() ?><?= $Page->description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description->cellAttributes() ?>>
<span id="el_p_size_description">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="p_size" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?> aria-describedby="x_description_help">
<?= $Page->description->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
    <div id="r_size"<?= $Page->size->rowAttributes() ?>>
        <label id="elh_p_size_size" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size->caption() ?><?= $Page->size->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size->cellAttributes() ?>>
<span id="el_p_size_size">
<template id="tp_x_size">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="p_size" data-field="x_size" name="x_size" id="x_size"<?= $Page->size->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_size" class="ew-item-list"></div>
<selection-list hidden
    id="x_size"
    name="x_size"
    value="<?= HtmlEncode($Page->size->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_size"
    data-target="dsl_x_size"
    data-repeatcolumn="1"
    class="form-control<?= $Page->size->isInvalidClass() ?>"
    data-table="p_size"
    data-field="x_size"
    data-value-separator="<?= $Page->size->displayValueSeparatorAttribute() ?>"
    <?= $Page->size->editAttributes() ?>></selection-list>
<?= $Page->size->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage() ?></div>
<?= $Page->size->Lookup->getParamTag($Page, "p_x_size") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label id="elh_p_size_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid->cellAttributes() ?>>
<span id="el_p_size_rid">
<template id="tp_x_rid">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="p_size" data-field="x_rid" name="x_rid" id="x_rid"<?= $Page->rid->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_rid" class="ew-item-list"></div>
<selection-list hidden
    id="x_rid[]"
    name="x_rid[]"
    value="<?= HtmlEncode($Page->rid->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_rid"
    data-target="dsl_x_rid"
    data-repeatcolumn="2"
    class="form-control<?= $Page->rid->isInvalidClass() ?>"
    data-table="p_size"
    data-field="x_rid"
    data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
    <?= $Page->rid->editAttributes() ?>></selection-list>
<?= $Page->rid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage() ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->qty_in_sheet->Visible) { // qty_in_sheet ?>
    <div id="r_qty_in_sheet"<?= $Page->qty_in_sheet->rowAttributes() ?>>
        <label id="elh_p_size_qty_in_sheet" for="x_qty_in_sheet" class="<?= $Page->LeftColumnClass ?>"><?= $Page->qty_in_sheet->caption() ?><?= $Page->qty_in_sheet->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->qty_in_sheet->cellAttributes() ?>>
<span id="el_p_size_qty_in_sheet">
<input type="<?= $Page->qty_in_sheet->getInputTextType() ?>" name="x_qty_in_sheet" id="x_qty_in_sheet" data-table="p_size" data-field="x_qty_in_sheet" value="<?= $Page->qty_in_sheet->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->qty_in_sheet->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_in_sheet->formatPattern()) ?>"<?= $Page->qty_in_sheet->editAttributes() ?> aria-describedby="x_qty_in_sheet_help">
<?= $Page->qty_in_sheet->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->qty_in_sheet->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_p_size_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_p_size_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fp_sizeadd_x_status"
        <?php } ?>
        data-table="p_size"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_sizeadd", function() {
    var options = { name: "x_status", selectId: "fp_sizeadd_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_sizeadd.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fp_sizeadd" };
    } else {
        options.ajax = { id: "x_status", form: "fp_sizeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_size.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fp_sizeadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fp_sizeadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("p_size");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    			$("#r_size").hide();
    			$("#r_rid").show();			
});
</script>
