<?php

namespace PHPMaker2024\fibre;

// Page object
$PEastimateSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { p_eastimate: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fp_eastimatesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fp_eastimatesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["job_type", [], fields.job_type.isInvalid],
            ["job_category", [], fields.job_category.isInvalid],
            ["company_id", [ew.Validators.integer], fields.company_id.isInvalid],
            ["description", [], fields.description.isInvalid],
            ["size", [], fields.size.isInvalid],
            ["quantity", [ew.Validators.float], fields.quantity.isInvalid],
            ["pages", [], fields.pages.isInvalid],
            ["paper", [ew.Validators.integer], fields.paper.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["pr_01", [], fields.pr_01.isInvalid],
            ["qty_pr_01", [ew.Validators.float], fields.qty_pr_01.isInvalid],
            ["pl_01", [], fields.pl_01.isInvalid],
            ["qty_pl_01", [ew.Validators.float], fields.qty_pl_01.isInvalid],
            ["pr_02", [], fields.pr_02.isInvalid],
            ["qty_pr_02", [ew.Validators.float], fields.qty_pr_02.isInvalid],
            ["pl_02", [], fields.pl_02.isInvalid],
            ["qty_pl_02", [ew.Validators.float], fields.qty_pl_02.isInvalid],
            ["pr_03", [], fields.pr_03.isInvalid],
            ["qty_pr_03", [ew.Validators.float], fields.qty_pr_03.isInvalid],
            ["pl_03", [], fields.pl_03.isInvalid],
            ["qty_pl_03", [ew.Validators.float], fields.qty_pl_03.isInvalid],
            ["pr_04", [], fields.pr_04.isInvalid],
            ["qty_pr_04", [ew.Validators.float], fields.qty_pr_04.isInvalid],
            ["pl_04", [], fields.pl_04.isInvalid],
            ["qty_pl_04", [ew.Validators.float], fields.qty_pl_04.isInvalid],
            ["pa_01", [], fields.pa_01.isInvalid],
            ["qty_pa_01", [ew.Validators.float], fields.qty_pa_01.isInvalid],
            ["pa_02", [], fields.pa_02.isInvalid],
            ["qty_pa_02", [ew.Validators.float], fields.qty_pa_02.isInvalid],
            ["pa_03", [], fields.pa_03.isInvalid],
            ["qty_pa_03", [ew.Validators.float], fields.qty_pa_03.isInvalid],
            ["pa_04", [], fields.pa_04.isInvalid],
            ["qty_pa_04", [ew.Validators.float], fields.qty_pa_04.isInvalid],
            ["pa_05", [ew.Validators.integer], fields.pa_05.isInvalid],
            ["qty_pa_05", [ew.Validators.float], fields.qty_pa_05.isInvalid],
            ["pc_01", [], fields.pc_01.isInvalid],
            ["qty_pc_01", [ew.Validators.float], fields.qty_pc_01.isInvalid],
            ["pc_02", [], fields.pc_02.isInvalid],
            ["qty_pc_02", [ew.Validators.float], fields.qty_pc_02.isInvalid],
            ["o_01", [], fields.o_01.isInvalid],
            ["qty_o_01", [ew.Validators.float], fields.qty_o_01.isInvalid],
            ["lamination_type", [], fields.lamination_type.isInvalid],
            ["lamination_qty", [ew.Validators.integer], fields.lamination_qty.isInvalid],
            ["die_type", [], fields.die_type.isInvalid],
            ["die_qty", [ew.Validators.integer], fields.die_qty.isInvalid],
            ["binding_type", [], fields.binding_type.isInvalid],
            ["binding_qty", [ew.Validators.float], fields.binding_qty.isInvalid],
            ["number_type", [], fields.number_type.isInvalid],
            ["number_qty", [ew.Validators.integer], fields.number_qty.isInvalid],
            ["de_01", [], fields.de_01.isInvalid],
            ["qty_de_01", [ew.Validators.float], fields.qty_de_01.isInvalid],
            ["de_02", [], fields.de_02.isInvalid],
            ["qty_de_02", [ew.Validators.float], fields.qty_de_02.isInvalid],
            ["de_03", [], fields.de_03.isInvalid],
            ["qty_de_03", [ew.Validators.float], fields.qty_de_03.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.integer], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "job_type": <?= $Page->job_type->toClientList($Page) ?>,
            "job_category": <?= $Page->job_category->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "size": <?= $Page->size->toClientList($Page) ?>,
            "pr_01": <?= $Page->pr_01->toClientList($Page) ?>,
            "pl_01": <?= $Page->pl_01->toClientList($Page) ?>,
            "pr_02": <?= $Page->pr_02->toClientList($Page) ?>,
            "pl_02": <?= $Page->pl_02->toClientList($Page) ?>,
            "pr_03": <?= $Page->pr_03->toClientList($Page) ?>,
            "pl_03": <?= $Page->pl_03->toClientList($Page) ?>,
            "pr_04": <?= $Page->pr_04->toClientList($Page) ?>,
            "pl_04": <?= $Page->pl_04->toClientList($Page) ?>,
            "pa_01": <?= $Page->pa_01->toClientList($Page) ?>,
            "pa_02": <?= $Page->pa_02->toClientList($Page) ?>,
            "pa_03": <?= $Page->pa_03->toClientList($Page) ?>,
            "pa_04": <?= $Page->pa_04->toClientList($Page) ?>,
            "pa_05": <?= $Page->pa_05->toClientList($Page) ?>,
            "pc_01": <?= $Page->pc_01->toClientList($Page) ?>,
            "pc_02": <?= $Page->pc_02->toClientList($Page) ?>,
            "o_01": <?= $Page->o_01->toClientList($Page) ?>,
            "lamination_type": <?= $Page->lamination_type->toClientList($Page) ?>,
            "die_type": <?= $Page->die_type->toClientList($Page) ?>,
            "binding_type": <?= $Page->binding_type->toClientList($Page) ?>,
            "number_type": <?= $Page->number_type->toClientList($Page) ?>,
            "de_01": <?= $Page->de_01->toClientList($Page) ?>,
            "de_02": <?= $Page->de_02->toClientList($Page) ?>,
            "de_03": <?= $Page->de_03->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fp_eastimatesearch" id="fp_eastimatesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="p_eastimate">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="p_eastimate" data-field="x_id" value="<?= $Page->id->EditValue ?>" data-page="0" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->job_type->Visible) { // job_type ?>
    <div id="r_job_type" class="row"<?= $Page->job_type->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_job_type"><?= $Page->job_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_job_type" id="z_job_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->job_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_job_type" class="ew-search-field ew-search-field-single">
<template id="tp_x_job_type">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="p_eastimate" data-field="x_job_type" name="x_job_type" id="x_job_type"<?= $Page->job_type->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_job_type" class="ew-item-list"></div>
<selection-list hidden
    id="x_job_type"
    name="x_job_type"
    value="<?= HtmlEncode($Page->job_type->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_job_type"
    data-target="dsl_x_job_type"
    data-repeatcolumn="5"
    class="form-control<?= $Page->job_type->isInvalidClass() ?>"
    data-table="p_eastimate"
    data-field="x_job_type"
    data-page="0"
    data-value-separator="<?= $Page->job_type->displayValueSeparatorAttribute() ?>"
    <?= $Page->job_type->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->job_type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->job_category->Visible) { // job_category ?>
    <div id="r_job_category" class="row"<?= $Page->job_category->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_job_category"><?= $Page->job_category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_job_category" id="z_job_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->job_category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_job_category" class="ew-search-field ew-search-field-single">
<template id="tp_x_job_category">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="p_eastimate" data-field="x_job_category" name="x_job_category" id="x_job_category"<?= $Page->job_category->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_job_category" class="ew-item-list"></div>
<selection-list hidden
    id="x_job_category"
    name="x_job_category"
    value="<?= HtmlEncode($Page->job_category->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_job_category"
    data-target="dsl_x_job_category"
    data-repeatcolumn="5"
    class="form-control<?= $Page->job_category->isInvalidClass() ?>"
    data-table="p_eastimate"
    data-field="x_job_category"
    data-page="0"
    data-value-separator="<?= $Page->job_category->displayValueSeparatorAttribute() ?>"
    <?= $Page->job_category->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->job_category->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-control ew-select<?= $Page->company_id->isInvalidClass() ?>"
        data-select2-id="fp_eastimatesearch_x_company_id"
        data-table="p_eastimate"
        data-field="x_company_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->company_id->caption())) ?>"
        data-modal-lookup="true"
        data-page="0"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_company_id", selectId: "fp_eastimatesearch_x_company_id" };
    if (fp_eastimatesearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_eastimate.fields.company_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description" class="row"<?= $Page->description->rowAttributes() ?>>
        <label for="x_description" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_description"><?= $Page->description->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description" id="z_description" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="p_eastimate" data-field="x_description" value="<?= $Page->description->EditValue ?>" data-page="0" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
    <div id="r_size" class="row"<?= $Page->size->rowAttributes() ?>>
        <label for="x_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_size"><?= $Page->size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_size" id="z_size" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_size" class="ew-search-field ew-search-field-single">
    <select
        id="x_size"
        name="x_size"
        class="form-select ew-select<?= $Page->size->isInvalidClass() ?>"
        <?php if (!$Page->size->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_size"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_size"
        data-page="0"
        data-value-separator="<?= $Page->size->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->size->getPlaceHolder()) ?>"
        <?= $Page->size->editAttributes() ?>>
        <?= $Page->size->selectOptionListHtml("x_size") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->size->getErrorMessage(false) ?></div>
<?= $Page->size->Lookup->getParamTag($Page, "p_x_size") ?>
<?php if (!$Page->size->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_size", selectId: "fp_eastimatesearch_x_size" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.size?.lookupOptions.length) {
        options.data = { id: "x_size", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_size", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.size.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="p_eastimate" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" data-page="0" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pages->Visible) { // pages ?>
    <div id="r_pages" class="row"<?= $Page->pages->rowAttributes() ?>>
        <label for="x_pages" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pages"><?= $Page->pages->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pages" id="z_pages" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pages->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pages" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pages->getInputTextType() ?>" name="x_pages" id="x_pages" data-table="p_eastimate" data-field="x_pages" value="<?= $Page->pages->EditValue ?>" data-page="0" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->pages->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pages->formatPattern()) ?>"<?= $Page->pages->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pages->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->paper->Visible) { // paper ?>
    <div id="r_paper" class="row"<?= $Page->paper->rowAttributes() ?>>
        <label for="x_paper" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_paper"><?= $Page->paper->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_paper" id="z_paper" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->paper->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_paper" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->paper->getInputTextType() ?>" name="x_paper" id="x_paper" data-table="p_eastimate" data-field="x_paper" value="<?= $Page->paper->EditValue ?>" data-page="0" size="30" placeholder="<?= HtmlEncode($Page->paper->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->paper->formatPattern()) ?>"<?= $Page->paper->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->paper->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="p_eastimate" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" data-page="0" maxlength="252" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_PEastimateSearch"><!-- multi-page accordion -->
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_p_eastimate1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_p_eastimate1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->pr_01->Visible) { // pr_01 ?>
    <div id="r_pr_01" class="row"<?= $Page->pr_01->rowAttributes() ?>>
        <label for="x_pr_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pr_01"><?= $Page->pr_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pr_01" id="z_pr_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pr_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pr_01" class="ew-search-field ew-search-field-single">
    <select
        id="x_pr_01"
        name="x_pr_01"
        class="form-select ew-select<?= $Page->pr_01->isInvalidClass() ?>"
        <?php if (!$Page->pr_01->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_pr_01"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_pr_01"
        data-page="1"
        data-value-separator="<?= $Page->pr_01->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pr_01->getPlaceHolder()) ?>"
        <?= $Page->pr_01->editAttributes() ?>>
        <?= $Page->pr_01->selectOptionListHtml("x_pr_01") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pr_01->getErrorMessage(false) ?></div>
<?= $Page->pr_01->Lookup->getParamTag($Page, "p_x_pr_01") ?>
<?php if (!$Page->pr_01->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pr_01", selectId: "fp_eastimatesearch_x_pr_01" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.pr_01?.lookupOptions.length) {
        options.data = { id: "x_pr_01", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pr_01", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.pr_01.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pr_01->Visible) { // qty_pr_01 ?>
    <div id="r_qty_pr_01" class="row"<?= $Page->qty_pr_01->rowAttributes() ?>>
        <label for="x_qty_pr_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pr_01"><?= $Page->qty_pr_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pr_01" id="z_qty_pr_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pr_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pr_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pr_01->getInputTextType() ?>" name="x_qty_pr_01" id="x_qty_pr_01" data-table="p_eastimate" data-field="x_qty_pr_01" value="<?= $Page->qty_pr_01->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->qty_pr_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pr_01->formatPattern()) ?>"<?= $Page->qty_pr_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pr_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pl_01->Visible) { // pl_01 ?>
    <div id="r_pl_01" class="row"<?= $Page->pl_01->rowAttributes() ?>>
        <label for="x_pl_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pl_01"><?= $Page->pl_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pl_01" id="z_pl_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pl_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pl_01" class="ew-search-field ew-search-field-single">
    <select
        id="x_pl_01"
        name="x_pl_01"
        class="form-select ew-select<?= $Page->pl_01->isInvalidClass() ?>"
        <?php if (!$Page->pl_01->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_pl_01"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_pl_01"
        data-page="1"
        data-value-separator="<?= $Page->pl_01->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pl_01->getPlaceHolder()) ?>"
        <?= $Page->pl_01->editAttributes() ?>>
        <?= $Page->pl_01->selectOptionListHtml("x_pl_01") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pl_01->getErrorMessage(false) ?></div>
<?= $Page->pl_01->Lookup->getParamTag($Page, "p_x_pl_01") ?>
<?php if (!$Page->pl_01->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pl_01", selectId: "fp_eastimatesearch_x_pl_01" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.pl_01?.lookupOptions.length) {
        options.data = { id: "x_pl_01", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pl_01", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.pl_01.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pl_01->Visible) { // qty_pl_01 ?>
    <div id="r_qty_pl_01" class="row"<?= $Page->qty_pl_01->rowAttributes() ?>>
        <label for="x_qty_pl_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pl_01"><?= $Page->qty_pl_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pl_01" id="z_qty_pl_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pl_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pl_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pl_01->getInputTextType() ?>" name="x_qty_pl_01" id="x_qty_pl_01" data-table="p_eastimate" data-field="x_qty_pl_01" value="<?= $Page->qty_pl_01->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->qty_pl_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pl_01->formatPattern()) ?>"<?= $Page->qty_pl_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pl_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_p_eastimate2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_p_eastimate2"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->pr_02->Visible) { // pr_02 ?>
    <div id="r_pr_02" class="row"<?= $Page->pr_02->rowAttributes() ?>>
        <label for="x_pr_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pr_02"><?= $Page->pr_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pr_02" id="z_pr_02" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pr_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pr_02" class="ew-search-field ew-search-field-single">
    <select
        id="x_pr_02"
        name="x_pr_02"
        class="form-select ew-select<?= $Page->pr_02->isInvalidClass() ?>"
        <?php if (!$Page->pr_02->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_pr_02"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_pr_02"
        data-page="2"
        data-value-separator="<?= $Page->pr_02->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pr_02->getPlaceHolder()) ?>"
        <?= $Page->pr_02->editAttributes() ?>>
        <?= $Page->pr_02->selectOptionListHtml("x_pr_02") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pr_02->getErrorMessage(false) ?></div>
<?= $Page->pr_02->Lookup->getParamTag($Page, "p_x_pr_02") ?>
<?php if (!$Page->pr_02->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pr_02", selectId: "fp_eastimatesearch_x_pr_02" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.pr_02?.lookupOptions.length) {
        options.data = { id: "x_pr_02", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pr_02", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.pr_02.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pr_02->Visible) { // qty_pr_02 ?>
    <div id="r_qty_pr_02" class="row"<?= $Page->qty_pr_02->rowAttributes() ?>>
        <label for="x_qty_pr_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pr_02"><?= $Page->qty_pr_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pr_02" id="z_qty_pr_02" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pr_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pr_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pr_02->getInputTextType() ?>" name="x_qty_pr_02" id="x_qty_pr_02" data-table="p_eastimate" data-field="x_qty_pr_02" value="<?= $Page->qty_pr_02->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->qty_pr_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pr_02->formatPattern()) ?>"<?= $Page->qty_pr_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pr_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pl_02->Visible) { // pl_02 ?>
    <div id="r_pl_02" class="row"<?= $Page->pl_02->rowAttributes() ?>>
        <label for="x_pl_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pl_02"><?= $Page->pl_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pl_02" id="z_pl_02" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pl_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pl_02" class="ew-search-field ew-search-field-single">
    <select
        id="x_pl_02"
        name="x_pl_02"
        class="form-select ew-select<?= $Page->pl_02->isInvalidClass() ?>"
        <?php if (!$Page->pl_02->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_pl_02"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_pl_02"
        data-page="2"
        data-value-separator="<?= $Page->pl_02->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pl_02->getPlaceHolder()) ?>"
        <?= $Page->pl_02->editAttributes() ?>>
        <?= $Page->pl_02->selectOptionListHtml("x_pl_02") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pl_02->getErrorMessage(false) ?></div>
<?= $Page->pl_02->Lookup->getParamTag($Page, "p_x_pl_02") ?>
<?php if (!$Page->pl_02->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pl_02", selectId: "fp_eastimatesearch_x_pl_02" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.pl_02?.lookupOptions.length) {
        options.data = { id: "x_pl_02", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pl_02", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.pl_02.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pl_02->Visible) { // qty_pl_02 ?>
    <div id="r_qty_pl_02" class="row"<?= $Page->qty_pl_02->rowAttributes() ?>>
        <label for="x_qty_pl_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pl_02"><?= $Page->qty_pl_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pl_02" id="z_qty_pl_02" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pl_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pl_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pl_02->getInputTextType() ?>" name="x_qty_pl_02" id="x_qty_pl_02" data-table="p_eastimate" data-field="x_qty_pl_02" value="<?= $Page->qty_pl_02->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->qty_pl_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pl_02->formatPattern()) ?>"<?= $Page->qty_pl_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pl_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(3)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_p_eastimate3"><?= $Page->pageCaption(3) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(3)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_p_eastimate3"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->pr_03->Visible) { // pr_03 ?>
    <div id="r_pr_03" class="row"<?= $Page->pr_03->rowAttributes() ?>>
        <label for="x_pr_03" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pr_03"><?= $Page->pr_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pr_03" id="z_pr_03" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pr_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pr_03" class="ew-search-field ew-search-field-single">
    <select
        id="x_pr_03"
        name="x_pr_03"
        class="form-select ew-select<?= $Page->pr_03->isInvalidClass() ?>"
        <?php if (!$Page->pr_03->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_pr_03"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_pr_03"
        data-page="3"
        data-value-separator="<?= $Page->pr_03->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pr_03->getPlaceHolder()) ?>"
        <?= $Page->pr_03->editAttributes() ?>>
        <?= $Page->pr_03->selectOptionListHtml("x_pr_03") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pr_03->getErrorMessage(false) ?></div>
<?= $Page->pr_03->Lookup->getParamTag($Page, "p_x_pr_03") ?>
<?php if (!$Page->pr_03->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pr_03", selectId: "fp_eastimatesearch_x_pr_03" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.pr_03?.lookupOptions.length) {
        options.data = { id: "x_pr_03", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pr_03", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.pr_03.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pr_03->Visible) { // qty_pr_03 ?>
    <div id="r_qty_pr_03" class="row"<?= $Page->qty_pr_03->rowAttributes() ?>>
        <label for="x_qty_pr_03" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pr_03"><?= $Page->qty_pr_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pr_03" id="z_qty_pr_03" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pr_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pr_03" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pr_03->getInputTextType() ?>" name="x_qty_pr_03" id="x_qty_pr_03" data-table="p_eastimate" data-field="x_qty_pr_03" value="<?= $Page->qty_pr_03->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->qty_pr_03->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pr_03->formatPattern()) ?>"<?= $Page->qty_pr_03->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pr_03->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pl_03->Visible) { // pl_03 ?>
    <div id="r_pl_03" class="row"<?= $Page->pl_03->rowAttributes() ?>>
        <label for="x_pl_03" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pl_03"><?= $Page->pl_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pl_03" id="z_pl_03" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pl_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pl_03" class="ew-search-field ew-search-field-single">
    <select
        id="x_pl_03"
        name="x_pl_03"
        class="form-select ew-select<?= $Page->pl_03->isInvalidClass() ?>"
        <?php if (!$Page->pl_03->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_pl_03"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_pl_03"
        data-page="3"
        data-value-separator="<?= $Page->pl_03->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pl_03->getPlaceHolder()) ?>"
        <?= $Page->pl_03->editAttributes() ?>>
        <?= $Page->pl_03->selectOptionListHtml("x_pl_03") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pl_03->getErrorMessage(false) ?></div>
<?= $Page->pl_03->Lookup->getParamTag($Page, "p_x_pl_03") ?>
<?php if (!$Page->pl_03->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pl_03", selectId: "fp_eastimatesearch_x_pl_03" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.pl_03?.lookupOptions.length) {
        options.data = { id: "x_pl_03", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pl_03", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.pl_03.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pl_03->Visible) { // qty_pl_03 ?>
    <div id="r_qty_pl_03" class="row"<?= $Page->qty_pl_03->rowAttributes() ?>>
        <label for="x_qty_pl_03" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pl_03"><?= $Page->qty_pl_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pl_03" id="z_qty_pl_03" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pl_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pl_03" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pl_03->getInputTextType() ?>" name="x_qty_pl_03" id="x_qty_pl_03" data-table="p_eastimate" data-field="x_qty_pl_03" value="<?= $Page->qty_pl_03->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->qty_pl_03->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pl_03->formatPattern()) ?>"<?= $Page->qty_pl_03->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pl_03->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(4)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(4)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_p_eastimate4"><?= $Page->pageCaption(4) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(4)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_p_eastimate4"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->pr_04->Visible) { // pr_04 ?>
    <div id="r_pr_04" class="row"<?= $Page->pr_04->rowAttributes() ?>>
        <label for="x_pr_04" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pr_04"><?= $Page->pr_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pr_04" id="z_pr_04" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pr_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pr_04" class="ew-search-field ew-search-field-single">
    <select
        id="x_pr_04"
        name="x_pr_04"
        class="form-select ew-select<?= $Page->pr_04->isInvalidClass() ?>"
        <?php if (!$Page->pr_04->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_pr_04"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_pr_04"
        data-page="4"
        data-value-separator="<?= $Page->pr_04->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pr_04->getPlaceHolder()) ?>"
        <?= $Page->pr_04->editAttributes() ?>>
        <?= $Page->pr_04->selectOptionListHtml("x_pr_04") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pr_04->getErrorMessage(false) ?></div>
<?= $Page->pr_04->Lookup->getParamTag($Page, "p_x_pr_04") ?>
<?php if (!$Page->pr_04->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pr_04", selectId: "fp_eastimatesearch_x_pr_04" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.pr_04?.lookupOptions.length) {
        options.data = { id: "x_pr_04", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pr_04", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.pr_04.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pr_04->Visible) { // qty_pr_04 ?>
    <div id="r_qty_pr_04" class="row"<?= $Page->qty_pr_04->rowAttributes() ?>>
        <label for="x_qty_pr_04" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pr_04"><?= $Page->qty_pr_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pr_04" id="z_qty_pr_04" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pr_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pr_04" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pr_04->getInputTextType() ?>" name="x_qty_pr_04" id="x_qty_pr_04" data-table="p_eastimate" data-field="x_qty_pr_04" value="<?= $Page->qty_pr_04->EditValue ?>" data-page="4" size="30" placeholder="<?= HtmlEncode($Page->qty_pr_04->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pr_04->formatPattern()) ?>"<?= $Page->qty_pr_04->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pr_04->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pl_04->Visible) { // pl_04 ?>
    <div id="r_pl_04" class="row"<?= $Page->pl_04->rowAttributes() ?>>
        <label for="x_pl_04" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pl_04"><?= $Page->pl_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pl_04" id="z_pl_04" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pl_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pl_04" class="ew-search-field ew-search-field-single">
    <select
        id="x_pl_04"
        name="x_pl_04"
        class="form-select ew-select<?= $Page->pl_04->isInvalidClass() ?>"
        <?php if (!$Page->pl_04->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_pl_04"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_pl_04"
        data-page="4"
        data-value-separator="<?= $Page->pl_04->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pl_04->getPlaceHolder()) ?>"
        <?= $Page->pl_04->editAttributes() ?>>
        <?= $Page->pl_04->selectOptionListHtml("x_pl_04") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pl_04->getErrorMessage(false) ?></div>
<?= $Page->pl_04->Lookup->getParamTag($Page, "p_x_pl_04") ?>
<?php if (!$Page->pl_04->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pl_04", selectId: "fp_eastimatesearch_x_pl_04" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.pl_04?.lookupOptions.length) {
        options.data = { id: "x_pl_04", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pl_04", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.pl_04.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pl_04->Visible) { // qty_pl_04 ?>
    <div id="r_qty_pl_04" class="row"<?= $Page->qty_pl_04->rowAttributes() ?>>
        <label for="x_qty_pl_04" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pl_04"><?= $Page->qty_pl_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pl_04" id="z_qty_pl_04" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pl_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pl_04" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pl_04->getInputTextType() ?>" name="x_qty_pl_04" id="x_qty_pl_04" data-table="p_eastimate" data-field="x_qty_pl_04" value="<?= $Page->qty_pl_04->EditValue ?>" data-page="4" size="30" placeholder="<?= HtmlEncode($Page->qty_pl_04->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pl_04->formatPattern()) ?>"<?= $Page->qty_pl_04->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pl_04->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(5)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(5)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_p_eastimate5"><?= $Page->pageCaption(5) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(5)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_p_eastimate5"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->pa_01->Visible) { // pa_01 ?>
    <div id="r_pa_01" class="row"<?= $Page->pa_01->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pa_01"><?= $Page->pa_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pa_01" id="z_pa_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pa_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pa_01" class="ew-search-field ew-search-field-single">
    <select
        id="x_pa_01"
        name="x_pa_01"
        class="form-control ew-select<?= $Page->pa_01->isInvalidClass() ?>"
        data-select2-id="fp_eastimatesearch_x_pa_01"
        data-table="p_eastimate"
        data-field="x_pa_01"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->pa_01->caption())) ?>"
        data-modal-lookup="true"
        data-page="5"
        data-value-separator="<?= $Page->pa_01->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pa_01->getPlaceHolder()) ?>"
        <?= $Page->pa_01->editAttributes() ?>>
        <?= $Page->pa_01->selectOptionListHtml("x_pa_01") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pa_01->getErrorMessage(false) ?></div>
<?= $Page->pa_01->Lookup->getParamTag($Page, "p_x_pa_01") ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pa_01", selectId: "fp_eastimatesearch_x_pa_01" };
    if (fp_eastimatesearch.lists.pa_01?.lookupOptions.length) {
        options.data = { id: "x_pa_01", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pa_01", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_eastimate.fields.pa_01.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pa_01->Visible) { // qty_pa_01 ?>
    <div id="r_qty_pa_01" class="row"<?= $Page->qty_pa_01->rowAttributes() ?>>
        <label for="x_qty_pa_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pa_01"><?= $Page->qty_pa_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pa_01" id="z_qty_pa_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pa_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pa_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pa_01->getInputTextType() ?>" name="x_qty_pa_01" id="x_qty_pa_01" data-table="p_eastimate" data-field="x_qty_pa_01" value="<?= $Page->qty_pa_01->EditValue ?>" data-page="5" size="30" placeholder="<?= HtmlEncode($Page->qty_pa_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pa_01->formatPattern()) ?>"<?= $Page->qty_pa_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pa_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pa_02->Visible) { // pa_02 ?>
    <div id="r_pa_02" class="row"<?= $Page->pa_02->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pa_02"><?= $Page->pa_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pa_02" id="z_pa_02" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pa_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pa_02" class="ew-search-field ew-search-field-single">
    <select
        id="x_pa_02"
        name="x_pa_02"
        class="form-control ew-select<?= $Page->pa_02->isInvalidClass() ?>"
        data-select2-id="fp_eastimatesearch_x_pa_02"
        data-table="p_eastimate"
        data-field="x_pa_02"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->pa_02->caption())) ?>"
        data-modal-lookup="true"
        data-page="5"
        data-value-separator="<?= $Page->pa_02->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pa_02->getPlaceHolder()) ?>"
        <?= $Page->pa_02->editAttributes() ?>>
        <?= $Page->pa_02->selectOptionListHtml("x_pa_02") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pa_02->getErrorMessage(false) ?></div>
<?= $Page->pa_02->Lookup->getParamTag($Page, "p_x_pa_02") ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pa_02", selectId: "fp_eastimatesearch_x_pa_02" };
    if (fp_eastimatesearch.lists.pa_02?.lookupOptions.length) {
        options.data = { id: "x_pa_02", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pa_02", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_eastimate.fields.pa_02.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pa_02->Visible) { // qty_pa_02 ?>
    <div id="r_qty_pa_02" class="row"<?= $Page->qty_pa_02->rowAttributes() ?>>
        <label for="x_qty_pa_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pa_02"><?= $Page->qty_pa_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pa_02" id="z_qty_pa_02" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pa_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pa_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pa_02->getInputTextType() ?>" name="x_qty_pa_02" id="x_qty_pa_02" data-table="p_eastimate" data-field="x_qty_pa_02" value="<?= $Page->qty_pa_02->EditValue ?>" data-page="5" size="30" placeholder="<?= HtmlEncode($Page->qty_pa_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pa_02->formatPattern()) ?>"<?= $Page->qty_pa_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pa_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pa_03->Visible) { // pa_03 ?>
    <div id="r_pa_03" class="row"<?= $Page->pa_03->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pa_03"><?= $Page->pa_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pa_03" id="z_pa_03" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pa_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pa_03" class="ew-search-field ew-search-field-single">
    <select
        id="x_pa_03"
        name="x_pa_03"
        class="form-control ew-select<?= $Page->pa_03->isInvalidClass() ?>"
        data-select2-id="fp_eastimatesearch_x_pa_03"
        data-table="p_eastimate"
        data-field="x_pa_03"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->pa_03->caption())) ?>"
        data-modal-lookup="true"
        data-page="5"
        data-value-separator="<?= $Page->pa_03->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pa_03->getPlaceHolder()) ?>"
        <?= $Page->pa_03->editAttributes() ?>>
        <?= $Page->pa_03->selectOptionListHtml("x_pa_03") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pa_03->getErrorMessage(false) ?></div>
<?= $Page->pa_03->Lookup->getParamTag($Page, "p_x_pa_03") ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pa_03", selectId: "fp_eastimatesearch_x_pa_03" };
    if (fp_eastimatesearch.lists.pa_03?.lookupOptions.length) {
        options.data = { id: "x_pa_03", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pa_03", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_eastimate.fields.pa_03.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pa_03->Visible) { // qty_pa_03 ?>
    <div id="r_qty_pa_03" class="row"<?= $Page->qty_pa_03->rowAttributes() ?>>
        <label for="x_qty_pa_03" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pa_03"><?= $Page->qty_pa_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pa_03" id="z_qty_pa_03" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pa_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pa_03" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pa_03->getInputTextType() ?>" name="x_qty_pa_03" id="x_qty_pa_03" data-table="p_eastimate" data-field="x_qty_pa_03" value="<?= $Page->qty_pa_03->EditValue ?>" data-page="5" size="30" placeholder="<?= HtmlEncode($Page->qty_pa_03->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pa_03->formatPattern()) ?>"<?= $Page->qty_pa_03->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pa_03->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pa_04->Visible) { // pa_04 ?>
    <div id="r_pa_04" class="row"<?= $Page->pa_04->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pa_04"><?= $Page->pa_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pa_04" id="z_pa_04" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pa_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pa_04" class="ew-search-field ew-search-field-single">
    <select
        id="x_pa_04"
        name="x_pa_04"
        class="form-control ew-select<?= $Page->pa_04->isInvalidClass() ?>"
        data-select2-id="fp_eastimatesearch_x_pa_04"
        data-table="p_eastimate"
        data-field="x_pa_04"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->pa_04->caption())) ?>"
        data-modal-lookup="true"
        data-page="5"
        data-value-separator="<?= $Page->pa_04->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pa_04->getPlaceHolder()) ?>"
        <?= $Page->pa_04->editAttributes() ?>>
        <?= $Page->pa_04->selectOptionListHtml("x_pa_04") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pa_04->getErrorMessage(false) ?></div>
<?= $Page->pa_04->Lookup->getParamTag($Page, "p_x_pa_04") ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pa_04", selectId: "fp_eastimatesearch_x_pa_04" };
    if (fp_eastimatesearch.lists.pa_04?.lookupOptions.length) {
        options.data = { id: "x_pa_04", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pa_04", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_eastimate.fields.pa_04.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pa_04->Visible) { // qty_pa_04 ?>
    <div id="r_qty_pa_04" class="row"<?= $Page->qty_pa_04->rowAttributes() ?>>
        <label for="x_qty_pa_04" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pa_04"><?= $Page->qty_pa_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pa_04" id="z_qty_pa_04" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pa_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pa_04" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pa_04->getInputTextType() ?>" name="x_qty_pa_04" id="x_qty_pa_04" data-table="p_eastimate" data-field="x_qty_pa_04" value="<?= $Page->qty_pa_04->EditValue ?>" data-page="5" size="30" placeholder="<?= HtmlEncode($Page->qty_pa_04->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pa_04->formatPattern()) ?>"<?= $Page->qty_pa_04->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pa_04->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pa_05->Visible) { // pa_05 ?>
    <div id="r_pa_05" class="row"<?= $Page->pa_05->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pa_05"><?= $Page->pa_05->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pa_05" id="z_pa_05" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pa_05->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pa_05" class="ew-search-field ew-search-field-single">
    <select
        id="x_pa_05"
        name="x_pa_05"
        class="form-control ew-select<?= $Page->pa_05->isInvalidClass() ?>"
        data-select2-id="fp_eastimatesearch_x_pa_05"
        data-table="p_eastimate"
        data-field="x_pa_05"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->pa_05->caption())) ?>"
        data-modal-lookup="true"
        data-page="5"
        data-value-separator="<?= $Page->pa_05->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pa_05->getPlaceHolder()) ?>"
        <?= $Page->pa_05->editAttributes() ?>>
        <?= $Page->pa_05->selectOptionListHtml("x_pa_05") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pa_05->getErrorMessage(false) ?></div>
<?= $Page->pa_05->Lookup->getParamTag($Page, "p_x_pa_05") ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pa_05", selectId: "fp_eastimatesearch_x_pa_05" };
    if (fp_eastimatesearch.lists.pa_05?.lookupOptions.length) {
        options.data = { id: "x_pa_05", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pa_05", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_eastimate.fields.pa_05.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pa_05->Visible) { // qty_pa_05 ?>
    <div id="r_qty_pa_05" class="row"<?= $Page->qty_pa_05->rowAttributes() ?>>
        <label for="x_qty_pa_05" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pa_05"><?= $Page->qty_pa_05->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pa_05" id="z_qty_pa_05" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pa_05->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pa_05" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pa_05->getInputTextType() ?>" name="x_qty_pa_05" id="x_qty_pa_05" data-table="p_eastimate" data-field="x_qty_pa_05" value="<?= $Page->qty_pa_05->EditValue ?>" data-page="5" size="30" placeholder="<?= HtmlEncode($Page->qty_pa_05->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pa_05->formatPattern()) ?>"<?= $Page->qty_pa_05->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pa_05->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(6)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(6)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_p_eastimate6"><?= $Page->pageCaption(6) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(6)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_p_eastimate6"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->pc_01->Visible) { // pc_01 ?>
    <div id="r_pc_01" class="row"<?= $Page->pc_01->rowAttributes() ?>>
        <label for="x_pc_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pc_01"><?= $Page->pc_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pc_01" id="z_pc_01" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pc_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pc_01" class="ew-search-field ew-search-field-single">
    <select
        id="x_pc_01"
        name="x_pc_01"
        class="form-select ew-select<?= $Page->pc_01->isInvalidClass() ?>"
        <?php if (!$Page->pc_01->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_pc_01"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_pc_01"
        data-page="6"
        data-value-separator="<?= $Page->pc_01->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pc_01->getPlaceHolder()) ?>"
        <?= $Page->pc_01->editAttributes() ?>>
        <?= $Page->pc_01->selectOptionListHtml("x_pc_01") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pc_01->getErrorMessage(false) ?></div>
<?= $Page->pc_01->Lookup->getParamTag($Page, "p_x_pc_01") ?>
<?php if (!$Page->pc_01->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pc_01", selectId: "fp_eastimatesearch_x_pc_01" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.pc_01?.lookupOptions.length) {
        options.data = { id: "x_pc_01", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pc_01", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.pc_01.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pc_01->Visible) { // qty_pc_01 ?>
    <div id="r_qty_pc_01" class="row"<?= $Page->qty_pc_01->rowAttributes() ?>>
        <label for="x_qty_pc_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pc_01"><?= $Page->qty_pc_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pc_01" id="z_qty_pc_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pc_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pc_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pc_01->getInputTextType() ?>" name="x_qty_pc_01" id="x_qty_pc_01" data-table="p_eastimate" data-field="x_qty_pc_01" value="<?= $Page->qty_pc_01->EditValue ?>" data-page="6" size="30" placeholder="<?= HtmlEncode($Page->qty_pc_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pc_01->formatPattern()) ?>"<?= $Page->qty_pc_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pc_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pc_02->Visible) { // pc_02 ?>
    <div id="r_pc_02" class="row"<?= $Page->pc_02->rowAttributes() ?>>
        <label for="x_pc_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_pc_02"><?= $Page->pc_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pc_02" id="z_pc_02" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pc_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_pc_02" class="ew-search-field ew-search-field-single">
    <select
        id="x_pc_02"
        name="x_pc_02"
        class="form-select ew-select<?= $Page->pc_02->isInvalidClass() ?>"
        <?php if (!$Page->pc_02->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_pc_02"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_pc_02"
        data-page="6"
        data-value-separator="<?= $Page->pc_02->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pc_02->getPlaceHolder()) ?>"
        <?= $Page->pc_02->editAttributes() ?>>
        <?= $Page->pc_02->selectOptionListHtml("x_pc_02") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pc_02->getErrorMessage(false) ?></div>
<?= $Page->pc_02->Lookup->getParamTag($Page, "p_x_pc_02") ?>
<?php if (!$Page->pc_02->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_pc_02", selectId: "fp_eastimatesearch_x_pc_02" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.pc_02?.lookupOptions.length) {
        options.data = { id: "x_pc_02", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_pc_02", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.pc_02.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_pc_02->Visible) { // qty_pc_02 ?>
    <div id="r_qty_pc_02" class="row"<?= $Page->qty_pc_02->rowAttributes() ?>>
        <label for="x_qty_pc_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_pc_02"><?= $Page->qty_pc_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_pc_02" id="z_qty_pc_02" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_pc_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_pc_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_pc_02->getInputTextType() ?>" name="x_qty_pc_02" id="x_qty_pc_02" data-table="p_eastimate" data-field="x_qty_pc_02" value="<?= $Page->qty_pc_02->EditValue ?>" data-page="6" size="30" placeholder="<?= HtmlEncode($Page->qty_pc_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_pc_02->formatPattern()) ?>"<?= $Page->qty_pc_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_pc_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->o_01->Visible) { // o_01 ?>
    <div id="r_o_01" class="row"<?= $Page->o_01->rowAttributes() ?>>
        <label for="x_o_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_o_01"><?= $Page->o_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_o_01" id="z_o_01" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->o_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_o_01" class="ew-search-field ew-search-field-single">
    <select
        id="x_o_01"
        name="x_o_01"
        class="form-select ew-select<?= $Page->o_01->isInvalidClass() ?>"
        <?php if (!$Page->o_01->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_o_01"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_o_01"
        data-page="6"
        data-value-separator="<?= $Page->o_01->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->o_01->getPlaceHolder()) ?>"
        <?= $Page->o_01->editAttributes() ?>>
        <?= $Page->o_01->selectOptionListHtml("x_o_01") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->o_01->getErrorMessage(false) ?></div>
<?= $Page->o_01->Lookup->getParamTag($Page, "p_x_o_01") ?>
<?php if (!$Page->o_01->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_o_01", selectId: "fp_eastimatesearch_x_o_01" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.o_01?.lookupOptions.length) {
        options.data = { id: "x_o_01", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_o_01", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.o_01.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_o_01->Visible) { // qty_o_01 ?>
    <div id="r_qty_o_01" class="row"<?= $Page->qty_o_01->rowAttributes() ?>>
        <label for="x_qty_o_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_o_01"><?= $Page->qty_o_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_o_01" id="z_qty_o_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_o_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_o_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_o_01->getInputTextType() ?>" name="x_qty_o_01" id="x_qty_o_01" data-table="p_eastimate" data-field="x_qty_o_01" value="<?= $Page->qty_o_01->EditValue ?>" data-page="6" size="30" placeholder="<?= HtmlEncode($Page->qty_o_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_o_01->formatPattern()) ?>"<?= $Page->qty_o_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_o_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(7)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(7)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_p_eastimate7"><?= $Page->pageCaption(7) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(7)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_p_eastimate7"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->lamination_type->Visible) { // lamination_type ?>
    <div id="r_lamination_type" class="row"<?= $Page->lamination_type->rowAttributes() ?>>
        <label for="x_lamination_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_lamination_type"><?= $Page->lamination_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lamination_type" id="z_lamination_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lamination_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_lamination_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_lamination_type"
        name="x_lamination_type"
        class="form-select ew-select<?= $Page->lamination_type->isInvalidClass() ?>"
        <?php if (!$Page->lamination_type->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_lamination_type"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_lamination_type"
        data-page="7"
        data-value-separator="<?= $Page->lamination_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->lamination_type->getPlaceHolder()) ?>"
        <?= $Page->lamination_type->editAttributes() ?>>
        <?= $Page->lamination_type->selectOptionListHtml("x_lamination_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->lamination_type->getErrorMessage(false) ?></div>
<?= $Page->lamination_type->Lookup->getParamTag($Page, "p_x_lamination_type") ?>
<?php if (!$Page->lamination_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_lamination_type", selectId: "fp_eastimatesearch_x_lamination_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.lamination_type?.lookupOptions.length) {
        options.data = { id: "x_lamination_type", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_lamination_type", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.lamination_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lamination_qty->Visible) { // lamination_qty ?>
    <div id="r_lamination_qty" class="row"<?= $Page->lamination_qty->rowAttributes() ?>>
        <label for="x_lamination_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_lamination_qty"><?= $Page->lamination_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lamination_qty" id="z_lamination_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lamination_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_lamination_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lamination_qty->getInputTextType() ?>" name="x_lamination_qty" id="x_lamination_qty" data-table="p_eastimate" data-field="x_lamination_qty" value="<?= $Page->lamination_qty->EditValue ?>" data-page="7" size="30" placeholder="<?= HtmlEncode($Page->lamination_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lamination_qty->formatPattern()) ?>"<?= $Page->lamination_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lamination_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->die_type->Visible) { // die_type ?>
    <div id="r_die_type" class="row"<?= $Page->die_type->rowAttributes() ?>>
        <label for="x_die_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_die_type"><?= $Page->die_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_die_type" id="z_die_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->die_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_die_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_die_type"
        name="x_die_type"
        class="form-select ew-select<?= $Page->die_type->isInvalidClass() ?>"
        <?php if (!$Page->die_type->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_die_type"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_die_type"
        data-page="7"
        data-value-separator="<?= $Page->die_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->die_type->getPlaceHolder()) ?>"
        <?= $Page->die_type->editAttributes() ?>>
        <?= $Page->die_type->selectOptionListHtml("x_die_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->die_type->getErrorMessage(false) ?></div>
<?= $Page->die_type->Lookup->getParamTag($Page, "p_x_die_type") ?>
<?php if (!$Page->die_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_die_type", selectId: "fp_eastimatesearch_x_die_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.die_type?.lookupOptions.length) {
        options.data = { id: "x_die_type", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_die_type", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.die_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->die_qty->Visible) { // die_qty ?>
    <div id="r_die_qty" class="row"<?= $Page->die_qty->rowAttributes() ?>>
        <label for="x_die_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_die_qty"><?= $Page->die_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_die_qty" id="z_die_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->die_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_die_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->die_qty->getInputTextType() ?>" name="x_die_qty" id="x_die_qty" data-table="p_eastimate" data-field="x_die_qty" value="<?= $Page->die_qty->EditValue ?>" data-page="7" size="30" placeholder="<?= HtmlEncode($Page->die_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->die_qty->formatPattern()) ?>"<?= $Page->die_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->die_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(8)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(8)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_p_eastimate8"><?= $Page->pageCaption(8) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(8)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_p_eastimate8"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->binding_type->Visible) { // binding_type ?>
    <div id="r_binding_type" class="row"<?= $Page->binding_type->rowAttributes() ?>>
        <label for="x_binding_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_binding_type"><?= $Page->binding_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_binding_type" id="z_binding_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->binding_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_binding_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_binding_type"
        name="x_binding_type"
        class="form-select ew-select<?= $Page->binding_type->isInvalidClass() ?>"
        <?php if (!$Page->binding_type->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_binding_type"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_binding_type"
        data-page="8"
        data-value-separator="<?= $Page->binding_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->binding_type->getPlaceHolder()) ?>"
        <?= $Page->binding_type->editAttributes() ?>>
        <?= $Page->binding_type->selectOptionListHtml("x_binding_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->binding_type->getErrorMessage(false) ?></div>
<?= $Page->binding_type->Lookup->getParamTag($Page, "p_x_binding_type") ?>
<?php if (!$Page->binding_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_binding_type", selectId: "fp_eastimatesearch_x_binding_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.binding_type?.lookupOptions.length) {
        options.data = { id: "x_binding_type", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_binding_type", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.binding_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->binding_qty->Visible) { // binding_qty ?>
    <div id="r_binding_qty" class="row"<?= $Page->binding_qty->rowAttributes() ?>>
        <label for="x_binding_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_binding_qty"><?= $Page->binding_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_binding_qty" id="z_binding_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->binding_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_binding_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->binding_qty->getInputTextType() ?>" name="x_binding_qty" id="x_binding_qty" data-table="p_eastimate" data-field="x_binding_qty" value="<?= $Page->binding_qty->EditValue ?>" data-page="8" size="30" placeholder="<?= HtmlEncode($Page->binding_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->binding_qty->formatPattern()) ?>"<?= $Page->binding_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->binding_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->number_type->Visible) { // number_type ?>
    <div id="r_number_type" class="row"<?= $Page->number_type->rowAttributes() ?>>
        <label for="x_number_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_number_type"><?= $Page->number_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_number_type" id="z_number_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->number_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_number_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_number_type"
        name="x_number_type"
        class="form-select ew-select<?= $Page->number_type->isInvalidClass() ?>"
        <?php if (!$Page->number_type->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_number_type"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_number_type"
        data-page="8"
        data-value-separator="<?= $Page->number_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->number_type->getPlaceHolder()) ?>"
        <?= $Page->number_type->editAttributes() ?>>
        <?= $Page->number_type->selectOptionListHtml("x_number_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->number_type->getErrorMessage(false) ?></div>
<?= $Page->number_type->Lookup->getParamTag($Page, "p_x_number_type") ?>
<?php if (!$Page->number_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_number_type", selectId: "fp_eastimatesearch_x_number_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.number_type?.lookupOptions.length) {
        options.data = { id: "x_number_type", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_number_type", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.number_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->number_qty->Visible) { // number_qty ?>
    <div id="r_number_qty" class="row"<?= $Page->number_qty->rowAttributes() ?>>
        <label for="x_number_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_number_qty"><?= $Page->number_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_number_qty" id="z_number_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->number_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_number_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->number_qty->getInputTextType() ?>" name="x_number_qty" id="x_number_qty" data-table="p_eastimate" data-field="x_number_qty" value="<?= $Page->number_qty->EditValue ?>" data-page="8" size="30" placeholder="<?= HtmlEncode($Page->number_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->number_qty->formatPattern()) ?>"<?= $Page->number_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->number_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(9)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(9)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_p_eastimate9"><?= $Page->pageCaption(9) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(9)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_p_eastimate9"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->de_01->Visible) { // de_01 ?>
    <div id="r_de_01" class="row"<?= $Page->de_01->rowAttributes() ?>>
        <label for="x_de_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_de_01"><?= $Page->de_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_de_01" id="z_de_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->de_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_de_01" class="ew-search-field ew-search-field-single">
    <select
        id="x_de_01"
        name="x_de_01"
        class="form-select ew-select<?= $Page->de_01->isInvalidClass() ?>"
        <?php if (!$Page->de_01->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_de_01"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_de_01"
        data-page="9"
        data-value-separator="<?= $Page->de_01->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->de_01->getPlaceHolder()) ?>"
        <?= $Page->de_01->editAttributes() ?>>
        <?= $Page->de_01->selectOptionListHtml("x_de_01") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->de_01->getErrorMessage(false) ?></div>
<?= $Page->de_01->Lookup->getParamTag($Page, "p_x_de_01") ?>
<?php if (!$Page->de_01->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_de_01", selectId: "fp_eastimatesearch_x_de_01" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.de_01?.lookupOptions.length) {
        options.data = { id: "x_de_01", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_de_01", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.de_01.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_de_01->Visible) { // qty_de_01 ?>
    <div id="r_qty_de_01" class="row"<?= $Page->qty_de_01->rowAttributes() ?>>
        <label for="x_qty_de_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_de_01"><?= $Page->qty_de_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_de_01" id="z_qty_de_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_de_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_de_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_de_01->getInputTextType() ?>" name="x_qty_de_01" id="x_qty_de_01" data-table="p_eastimate" data-field="x_qty_de_01" value="<?= $Page->qty_de_01->EditValue ?>" data-page="9" size="30" placeholder="<?= HtmlEncode($Page->qty_de_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_de_01->formatPattern()) ?>"<?= $Page->qty_de_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_de_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->de_02->Visible) { // de_02 ?>
    <div id="r_de_02" class="row"<?= $Page->de_02->rowAttributes() ?>>
        <label for="x_de_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_de_02"><?= $Page->de_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_de_02" id="z_de_02" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->de_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_de_02" class="ew-search-field ew-search-field-single">
    <select
        id="x_de_02"
        name="x_de_02"
        class="form-select ew-select<?= $Page->de_02->isInvalidClass() ?>"
        <?php if (!$Page->de_02->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_de_02"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_de_02"
        data-page="9"
        data-value-separator="<?= $Page->de_02->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->de_02->getPlaceHolder()) ?>"
        <?= $Page->de_02->editAttributes() ?>>
        <?= $Page->de_02->selectOptionListHtml("x_de_02") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->de_02->getErrorMessage(false) ?></div>
<?= $Page->de_02->Lookup->getParamTag($Page, "p_x_de_02") ?>
<?php if (!$Page->de_02->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_de_02", selectId: "fp_eastimatesearch_x_de_02" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.de_02?.lookupOptions.length) {
        options.data = { id: "x_de_02", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_de_02", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.de_02.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_de_02->Visible) { // qty_de_02 ?>
    <div id="r_qty_de_02" class="row"<?= $Page->qty_de_02->rowAttributes() ?>>
        <label for="x_qty_de_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_de_02"><?= $Page->qty_de_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_de_02" id="z_qty_de_02" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_de_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_de_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_de_02->getInputTextType() ?>" name="x_qty_de_02" id="x_qty_de_02" data-table="p_eastimate" data-field="x_qty_de_02" value="<?= $Page->qty_de_02->EditValue ?>" data-page="9" size="30" placeholder="<?= HtmlEncode($Page->qty_de_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_de_02->formatPattern()) ?>"<?= $Page->qty_de_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_de_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->de_03->Visible) { // de_03 ?>
    <div id="r_de_03" class="row"<?= $Page->de_03->rowAttributes() ?>>
        <label for="x_de_03" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_de_03"><?= $Page->de_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_de_03" id="z_de_03" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->de_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_de_03" class="ew-search-field ew-search-field-single">
    <select
        id="x_de_03"
        name="x_de_03"
        class="form-select ew-select<?= $Page->de_03->isInvalidClass() ?>"
        <?php if (!$Page->de_03->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_de_03"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_de_03"
        data-page="9"
        data-value-separator="<?= $Page->de_03->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->de_03->getPlaceHolder()) ?>"
        <?= $Page->de_03->editAttributes() ?>>
        <?= $Page->de_03->selectOptionListHtml("x_de_03") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->de_03->getErrorMessage(false) ?></div>
<?= $Page->de_03->Lookup->getParamTag($Page, "p_x_de_03") ?>
<?php if (!$Page->de_03->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_de_03", selectId: "fp_eastimatesearch_x_de_03" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.de_03?.lookupOptions.length) {
        options.data = { id: "x_de_03", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_de_03", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.de_03.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty_de_03->Visible) { // qty_de_03 ?>
    <div id="r_qty_de_03" class="row"<?= $Page->qty_de_03->rowAttributes() ?>>
        <label for="x_qty_de_03" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_qty_de_03"><?= $Page->qty_de_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty_de_03" id="z_qty_de_03" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty_de_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_qty_de_03" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty_de_03->getInputTextType() ?>" name="x_qty_de_03" id="x_qty_de_03" data-table="p_eastimate" data-field="x_qty_de_03" value="<?= $Page->qty_de_03->EditValue ?>" data-page="9" size="30" placeholder="<?= HtmlEncode($Page->qty_de_03->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty_de_03->formatPattern()) ?>"<?= $Page->qty_de_03->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty_de_03->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fp_eastimatesearch_x_operator"
        <?php } ?>
        data-table="p_eastimate"
        data-field="x_operator"
        data-page="9"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_eastimatesearch", function() {
    var options = { name: "x_operator", selectId: "fp_eastimatesearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_eastimatesearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fp_eastimatesearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fp_eastimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_eastimate.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_eastimate_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_eastimate_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="p_eastimate" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" data-page="9" size="30" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fp_eastimatesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fp_eastimatesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fp_eastimatesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("p_eastimate");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
