<?php

namespace PHPMaker2024\fibre;

// Page object
$PEastimateList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { p_eastimate: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fp_eastimatesrch" id="fp_eastimatesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fp_eastimatesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { p_eastimate: currentTable } });
var currentForm;
var fp_eastimatesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fp_eastimatesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fp_eastimatesrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fp_eastimatesrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fp_eastimatesrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fp_eastimatesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fp_eastimatesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fp_eastimatesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fp_eastimatesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="p_eastimate">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_p_eastimate" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_p_eastimatelist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_p_eastimate_id" class="p_eastimate_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->job_type->Visible) { // job_type ?>
        <th data-name="job_type" class="<?= $Page->job_type->headerCellClass() ?>"><div id="elh_p_eastimate_job_type" class="p_eastimate_job_type"><?= $Page->renderFieldHeader($Page->job_type) ?></div></th>
<?php } ?>
<?php if ($Page->job_category->Visible) { // job_category ?>
        <th data-name="job_category" class="<?= $Page->job_category->headerCellClass() ?>"><div id="elh_p_eastimate_job_category" class="p_eastimate_job_category"><?= $Page->renderFieldHeader($Page->job_category) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_p_eastimate_company_id" class="p_eastimate_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
        <th data-name="description" class="<?= $Page->description->headerCellClass() ?>"><div id="elh_p_eastimate_description" class="p_eastimate_description"><?= $Page->renderFieldHeader($Page->description) ?></div></th>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
        <th data-name="size" class="<?= $Page->size->headerCellClass() ?>"><div id="elh_p_eastimate_size" class="p_eastimate_size"><?= $Page->renderFieldHeader($Page->size) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_p_eastimate_quantity" class="p_eastimate_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->pages->Visible) { // pages ?>
        <th data-name="pages" class="<?= $Page->pages->headerCellClass() ?>"><div id="elh_p_eastimate_pages" class="p_eastimate_pages"><?= $Page->renderFieldHeader($Page->pages) ?></div></th>
<?php } ?>
<?php if ($Page->paper->Visible) { // paper ?>
        <th data-name="paper" class="<?= $Page->paper->headerCellClass() ?>"><div id="elh_p_eastimate_paper" class="p_eastimate_paper"><?= $Page->renderFieldHeader($Page->paper) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_p_eastimate_remarks" class="p_eastimate_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->pr_01->Visible) { // pr_01 ?>
        <th data-name="pr_01" class="<?= $Page->pr_01->headerCellClass() ?>"><div id="elh_p_eastimate_pr_01" class="p_eastimate_pr_01"><?= $Page->renderFieldHeader($Page->pr_01) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pr_01->Visible) { // qty_pr_01 ?>
        <th data-name="qty_pr_01" class="<?= $Page->qty_pr_01->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pr_01" class="p_eastimate_qty_pr_01"><?= $Page->renderFieldHeader($Page->qty_pr_01) ?></div></th>
<?php } ?>
<?php if ($Page->pl_01->Visible) { // pl_01 ?>
        <th data-name="pl_01" class="<?= $Page->pl_01->headerCellClass() ?>"><div id="elh_p_eastimate_pl_01" class="p_eastimate_pl_01"><?= $Page->renderFieldHeader($Page->pl_01) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pl_01->Visible) { // qty_pl_01 ?>
        <th data-name="qty_pl_01" class="<?= $Page->qty_pl_01->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pl_01" class="p_eastimate_qty_pl_01"><?= $Page->renderFieldHeader($Page->qty_pl_01) ?></div></th>
<?php } ?>
<?php if ($Page->pr_02->Visible) { // pr_02 ?>
        <th data-name="pr_02" class="<?= $Page->pr_02->headerCellClass() ?>"><div id="elh_p_eastimate_pr_02" class="p_eastimate_pr_02"><?= $Page->renderFieldHeader($Page->pr_02) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pr_02->Visible) { // qty_pr_02 ?>
        <th data-name="qty_pr_02" class="<?= $Page->qty_pr_02->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pr_02" class="p_eastimate_qty_pr_02"><?= $Page->renderFieldHeader($Page->qty_pr_02) ?></div></th>
<?php } ?>
<?php if ($Page->pl_02->Visible) { // pl_02 ?>
        <th data-name="pl_02" class="<?= $Page->pl_02->headerCellClass() ?>"><div id="elh_p_eastimate_pl_02" class="p_eastimate_pl_02"><?= $Page->renderFieldHeader($Page->pl_02) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pl_02->Visible) { // qty_pl_02 ?>
        <th data-name="qty_pl_02" class="<?= $Page->qty_pl_02->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pl_02" class="p_eastimate_qty_pl_02"><?= $Page->renderFieldHeader($Page->qty_pl_02) ?></div></th>
<?php } ?>
<?php if ($Page->pr_03->Visible) { // pr_03 ?>
        <th data-name="pr_03" class="<?= $Page->pr_03->headerCellClass() ?>"><div id="elh_p_eastimate_pr_03" class="p_eastimate_pr_03"><?= $Page->renderFieldHeader($Page->pr_03) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pr_03->Visible) { // qty_pr_03 ?>
        <th data-name="qty_pr_03" class="<?= $Page->qty_pr_03->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pr_03" class="p_eastimate_qty_pr_03"><?= $Page->renderFieldHeader($Page->qty_pr_03) ?></div></th>
<?php } ?>
<?php if ($Page->pl_03->Visible) { // pl_03 ?>
        <th data-name="pl_03" class="<?= $Page->pl_03->headerCellClass() ?>"><div id="elh_p_eastimate_pl_03" class="p_eastimate_pl_03"><?= $Page->renderFieldHeader($Page->pl_03) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pl_03->Visible) { // qty_pl_03 ?>
        <th data-name="qty_pl_03" class="<?= $Page->qty_pl_03->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pl_03" class="p_eastimate_qty_pl_03"><?= $Page->renderFieldHeader($Page->qty_pl_03) ?></div></th>
<?php } ?>
<?php if ($Page->pr_04->Visible) { // pr_04 ?>
        <th data-name="pr_04" class="<?= $Page->pr_04->headerCellClass() ?>"><div id="elh_p_eastimate_pr_04" class="p_eastimate_pr_04"><?= $Page->renderFieldHeader($Page->pr_04) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pr_04->Visible) { // qty_pr_04 ?>
        <th data-name="qty_pr_04" class="<?= $Page->qty_pr_04->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pr_04" class="p_eastimate_qty_pr_04"><?= $Page->renderFieldHeader($Page->qty_pr_04) ?></div></th>
<?php } ?>
<?php if ($Page->pl_04->Visible) { // pl_04 ?>
        <th data-name="pl_04" class="<?= $Page->pl_04->headerCellClass() ?>"><div id="elh_p_eastimate_pl_04" class="p_eastimate_pl_04"><?= $Page->renderFieldHeader($Page->pl_04) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pl_04->Visible) { // qty_pl_04 ?>
        <th data-name="qty_pl_04" class="<?= $Page->qty_pl_04->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pl_04" class="p_eastimate_qty_pl_04"><?= $Page->renderFieldHeader($Page->qty_pl_04) ?></div></th>
<?php } ?>
<?php if ($Page->pa_01->Visible) { // pa_01 ?>
        <th data-name="pa_01" class="<?= $Page->pa_01->headerCellClass() ?>"><div id="elh_p_eastimate_pa_01" class="p_eastimate_pa_01"><?= $Page->renderFieldHeader($Page->pa_01) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pa_01->Visible) { // qty_pa_01 ?>
        <th data-name="qty_pa_01" class="<?= $Page->qty_pa_01->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pa_01" class="p_eastimate_qty_pa_01"><?= $Page->renderFieldHeader($Page->qty_pa_01) ?></div></th>
<?php } ?>
<?php if ($Page->pa_02->Visible) { // pa_02 ?>
        <th data-name="pa_02" class="<?= $Page->pa_02->headerCellClass() ?>"><div id="elh_p_eastimate_pa_02" class="p_eastimate_pa_02"><?= $Page->renderFieldHeader($Page->pa_02) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pa_02->Visible) { // qty_pa_02 ?>
        <th data-name="qty_pa_02" class="<?= $Page->qty_pa_02->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pa_02" class="p_eastimate_qty_pa_02"><?= $Page->renderFieldHeader($Page->qty_pa_02) ?></div></th>
<?php } ?>
<?php if ($Page->pa_03->Visible) { // pa_03 ?>
        <th data-name="pa_03" class="<?= $Page->pa_03->headerCellClass() ?>"><div id="elh_p_eastimate_pa_03" class="p_eastimate_pa_03"><?= $Page->renderFieldHeader($Page->pa_03) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pa_03->Visible) { // qty_pa_03 ?>
        <th data-name="qty_pa_03" class="<?= $Page->qty_pa_03->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pa_03" class="p_eastimate_qty_pa_03"><?= $Page->renderFieldHeader($Page->qty_pa_03) ?></div></th>
<?php } ?>
<?php if ($Page->pa_04->Visible) { // pa_04 ?>
        <th data-name="pa_04" class="<?= $Page->pa_04->headerCellClass() ?>"><div id="elh_p_eastimate_pa_04" class="p_eastimate_pa_04"><?= $Page->renderFieldHeader($Page->pa_04) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pa_04->Visible) { // qty_pa_04 ?>
        <th data-name="qty_pa_04" class="<?= $Page->qty_pa_04->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pa_04" class="p_eastimate_qty_pa_04"><?= $Page->renderFieldHeader($Page->qty_pa_04) ?></div></th>
<?php } ?>
<?php if ($Page->pa_05->Visible) { // pa_05 ?>
        <th data-name="pa_05" class="<?= $Page->pa_05->headerCellClass() ?>"><div id="elh_p_eastimate_pa_05" class="p_eastimate_pa_05"><?= $Page->renderFieldHeader($Page->pa_05) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pa_05->Visible) { // qty_pa_05 ?>
        <th data-name="qty_pa_05" class="<?= $Page->qty_pa_05->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pa_05" class="p_eastimate_qty_pa_05"><?= $Page->renderFieldHeader($Page->qty_pa_05) ?></div></th>
<?php } ?>
<?php if ($Page->pc_01->Visible) { // pc_01 ?>
        <th data-name="pc_01" class="<?= $Page->pc_01->headerCellClass() ?>"><div id="elh_p_eastimate_pc_01" class="p_eastimate_pc_01"><?= $Page->renderFieldHeader($Page->pc_01) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pc_01->Visible) { // qty_pc_01 ?>
        <th data-name="qty_pc_01" class="<?= $Page->qty_pc_01->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pc_01" class="p_eastimate_qty_pc_01"><?= $Page->renderFieldHeader($Page->qty_pc_01) ?></div></th>
<?php } ?>
<?php if ($Page->pc_02->Visible) { // pc_02 ?>
        <th data-name="pc_02" class="<?= $Page->pc_02->headerCellClass() ?>"><div id="elh_p_eastimate_pc_02" class="p_eastimate_pc_02"><?= $Page->renderFieldHeader($Page->pc_02) ?></div></th>
<?php } ?>
<?php if ($Page->qty_pc_02->Visible) { // qty_pc_02 ?>
        <th data-name="qty_pc_02" class="<?= $Page->qty_pc_02->headerCellClass() ?>"><div id="elh_p_eastimate_qty_pc_02" class="p_eastimate_qty_pc_02"><?= $Page->renderFieldHeader($Page->qty_pc_02) ?></div></th>
<?php } ?>
<?php if ($Page->o_01->Visible) { // o_01 ?>
        <th data-name="o_01" class="<?= $Page->o_01->headerCellClass() ?>"><div id="elh_p_eastimate_o_01" class="p_eastimate_o_01"><?= $Page->renderFieldHeader($Page->o_01) ?></div></th>
<?php } ?>
<?php if ($Page->qty_o_01->Visible) { // qty_o_01 ?>
        <th data-name="qty_o_01" class="<?= $Page->qty_o_01->headerCellClass() ?>"><div id="elh_p_eastimate_qty_o_01" class="p_eastimate_qty_o_01"><?= $Page->renderFieldHeader($Page->qty_o_01) ?></div></th>
<?php } ?>
<?php if ($Page->lamination_type->Visible) { // lamination_type ?>
        <th data-name="lamination_type" class="<?= $Page->lamination_type->headerCellClass() ?>"><div id="elh_p_eastimate_lamination_type" class="p_eastimate_lamination_type"><?= $Page->renderFieldHeader($Page->lamination_type) ?></div></th>
<?php } ?>
<?php if ($Page->lamination_qty->Visible) { // lamination_qty ?>
        <th data-name="lamination_qty" class="<?= $Page->lamination_qty->headerCellClass() ?>"><div id="elh_p_eastimate_lamination_qty" class="p_eastimate_lamination_qty"><?= $Page->renderFieldHeader($Page->lamination_qty) ?></div></th>
<?php } ?>
<?php if ($Page->die_type->Visible) { // die_type ?>
        <th data-name="die_type" class="<?= $Page->die_type->headerCellClass() ?>"><div id="elh_p_eastimate_die_type" class="p_eastimate_die_type"><?= $Page->renderFieldHeader($Page->die_type) ?></div></th>
<?php } ?>
<?php if ($Page->die_qty->Visible) { // die_qty ?>
        <th data-name="die_qty" class="<?= $Page->die_qty->headerCellClass() ?>"><div id="elh_p_eastimate_die_qty" class="p_eastimate_die_qty"><?= $Page->renderFieldHeader($Page->die_qty) ?></div></th>
<?php } ?>
<?php if ($Page->binding_type->Visible) { // binding_type ?>
        <th data-name="binding_type" class="<?= $Page->binding_type->headerCellClass() ?>"><div id="elh_p_eastimate_binding_type" class="p_eastimate_binding_type"><?= $Page->renderFieldHeader($Page->binding_type) ?></div></th>
<?php } ?>
<?php if ($Page->binding_qty->Visible) { // binding_qty ?>
        <th data-name="binding_qty" class="<?= $Page->binding_qty->headerCellClass() ?>"><div id="elh_p_eastimate_binding_qty" class="p_eastimate_binding_qty"><?= $Page->renderFieldHeader($Page->binding_qty) ?></div></th>
<?php } ?>
<?php if ($Page->number_type->Visible) { // number_type ?>
        <th data-name="number_type" class="<?= $Page->number_type->headerCellClass() ?>"><div id="elh_p_eastimate_number_type" class="p_eastimate_number_type"><?= $Page->renderFieldHeader($Page->number_type) ?></div></th>
<?php } ?>
<?php if ($Page->number_qty->Visible) { // number_qty ?>
        <th data-name="number_qty" class="<?= $Page->number_qty->headerCellClass() ?>"><div id="elh_p_eastimate_number_qty" class="p_eastimate_number_qty"><?= $Page->renderFieldHeader($Page->number_qty) ?></div></th>
<?php } ?>
<?php if ($Page->de_01->Visible) { // de_01 ?>
        <th data-name="de_01" class="<?= $Page->de_01->headerCellClass() ?>"><div id="elh_p_eastimate_de_01" class="p_eastimate_de_01"><?= $Page->renderFieldHeader($Page->de_01) ?></div></th>
<?php } ?>
<?php if ($Page->qty_de_01->Visible) { // qty_de_01 ?>
        <th data-name="qty_de_01" class="<?= $Page->qty_de_01->headerCellClass() ?>"><div id="elh_p_eastimate_qty_de_01" class="p_eastimate_qty_de_01"><?= $Page->renderFieldHeader($Page->qty_de_01) ?></div></th>
<?php } ?>
<?php if ($Page->de_02->Visible) { // de_02 ?>
        <th data-name="de_02" class="<?= $Page->de_02->headerCellClass() ?>"><div id="elh_p_eastimate_de_02" class="p_eastimate_de_02"><?= $Page->renderFieldHeader($Page->de_02) ?></div></th>
<?php } ?>
<?php if ($Page->qty_de_02->Visible) { // qty_de_02 ?>
        <th data-name="qty_de_02" class="<?= $Page->qty_de_02->headerCellClass() ?>"><div id="elh_p_eastimate_qty_de_02" class="p_eastimate_qty_de_02"><?= $Page->renderFieldHeader($Page->qty_de_02) ?></div></th>
<?php } ?>
<?php if ($Page->de_03->Visible) { // de_03 ?>
        <th data-name="de_03" class="<?= $Page->de_03->headerCellClass() ?>"><div id="elh_p_eastimate_de_03" class="p_eastimate_de_03"><?= $Page->renderFieldHeader($Page->de_03) ?></div></th>
<?php } ?>
<?php if ($Page->qty_de_03->Visible) { // qty_de_03 ?>
        <th data-name="qty_de_03" class="<?= $Page->qty_de_03->headerCellClass() ?>"><div id="elh_p_eastimate_qty_de_03" class="p_eastimate_qty_de_03"><?= $Page->renderFieldHeader($Page->qty_de_03) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_p_eastimate_operator" class="p_eastimate_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_p_eastimate_datetime" class="p_eastimate_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_id" class="el_p_eastimate_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->job_type->Visible) { // job_type ?>
        <td data-name="job_type"<?= $Page->job_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_job_type" class="el_p_eastimate_job_type">
<span<?= $Page->job_type->viewAttributes() ?>>
<?= $Page->job_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->job_category->Visible) { // job_category ?>
        <td data-name="job_category"<?= $Page->job_category->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_job_category" class="el_p_eastimate_job_category">
<span<?= $Page->job_category->viewAttributes() ?>>
<?= $Page->job_category->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_company_id" class="el_p_eastimate_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->description->Visible) { // description ?>
        <td data-name="description"<?= $Page->description->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_description" class="el_p_eastimate_description">
<span<?= $Page->description->viewAttributes() ?>>
<?= $Page->description->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size->Visible) { // size ?>
        <td data-name="size"<?= $Page->size->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_size" class="el_p_eastimate_size">
<span<?= $Page->size->viewAttributes() ?>>
<?= $Page->size->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_quantity" class="el_p_eastimate_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pages->Visible) { // pages ?>
        <td data-name="pages"<?= $Page->pages->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pages" class="el_p_eastimate_pages">
<span<?= $Page->pages->viewAttributes() ?>>
<?= $Page->pages->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->paper->Visible) { // paper ?>
        <td data-name="paper"<?= $Page->paper->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_paper" class="el_p_eastimate_paper">
<span<?= $Page->paper->viewAttributes() ?>>
<?= $Page->paper->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_remarks" class="el_p_eastimate_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pr_01->Visible) { // pr_01 ?>
        <td data-name="pr_01"<?= $Page->pr_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pr_01" class="el_p_eastimate_pr_01">
<span<?= $Page->pr_01->viewAttributes() ?>>
<?= $Page->pr_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pr_01->Visible) { // qty_pr_01 ?>
        <td data-name="qty_pr_01"<?= $Page->qty_pr_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pr_01" class="el_p_eastimate_qty_pr_01">
<span<?= $Page->qty_pr_01->viewAttributes() ?>>
<?= $Page->qty_pr_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pl_01->Visible) { // pl_01 ?>
        <td data-name="pl_01"<?= $Page->pl_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pl_01" class="el_p_eastimate_pl_01">
<span<?= $Page->pl_01->viewAttributes() ?>>
<?= $Page->pl_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pl_01->Visible) { // qty_pl_01 ?>
        <td data-name="qty_pl_01"<?= $Page->qty_pl_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pl_01" class="el_p_eastimate_qty_pl_01">
<span<?= $Page->qty_pl_01->viewAttributes() ?>>
<?= $Page->qty_pl_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pr_02->Visible) { // pr_02 ?>
        <td data-name="pr_02"<?= $Page->pr_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pr_02" class="el_p_eastimate_pr_02">
<span<?= $Page->pr_02->viewAttributes() ?>>
<?= $Page->pr_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pr_02->Visible) { // qty_pr_02 ?>
        <td data-name="qty_pr_02"<?= $Page->qty_pr_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pr_02" class="el_p_eastimate_qty_pr_02">
<span<?= $Page->qty_pr_02->viewAttributes() ?>>
<?= $Page->qty_pr_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pl_02->Visible) { // pl_02 ?>
        <td data-name="pl_02"<?= $Page->pl_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pl_02" class="el_p_eastimate_pl_02">
<span<?= $Page->pl_02->viewAttributes() ?>>
<?= $Page->pl_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pl_02->Visible) { // qty_pl_02 ?>
        <td data-name="qty_pl_02"<?= $Page->qty_pl_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pl_02" class="el_p_eastimate_qty_pl_02">
<span<?= $Page->qty_pl_02->viewAttributes() ?>>
<?= $Page->qty_pl_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pr_03->Visible) { // pr_03 ?>
        <td data-name="pr_03"<?= $Page->pr_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pr_03" class="el_p_eastimate_pr_03">
<span<?= $Page->pr_03->viewAttributes() ?>>
<?= $Page->pr_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pr_03->Visible) { // qty_pr_03 ?>
        <td data-name="qty_pr_03"<?= $Page->qty_pr_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pr_03" class="el_p_eastimate_qty_pr_03">
<span<?= $Page->qty_pr_03->viewAttributes() ?>>
<?= $Page->qty_pr_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pl_03->Visible) { // pl_03 ?>
        <td data-name="pl_03"<?= $Page->pl_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pl_03" class="el_p_eastimate_pl_03">
<span<?= $Page->pl_03->viewAttributes() ?>>
<?= $Page->pl_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pl_03->Visible) { // qty_pl_03 ?>
        <td data-name="qty_pl_03"<?= $Page->qty_pl_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pl_03" class="el_p_eastimate_qty_pl_03">
<span<?= $Page->qty_pl_03->viewAttributes() ?>>
<?= $Page->qty_pl_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pr_04->Visible) { // pr_04 ?>
        <td data-name="pr_04"<?= $Page->pr_04->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pr_04" class="el_p_eastimate_pr_04">
<span<?= $Page->pr_04->viewAttributes() ?>>
<?= $Page->pr_04->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pr_04->Visible) { // qty_pr_04 ?>
        <td data-name="qty_pr_04"<?= $Page->qty_pr_04->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pr_04" class="el_p_eastimate_qty_pr_04">
<span<?= $Page->qty_pr_04->viewAttributes() ?>>
<?= $Page->qty_pr_04->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pl_04->Visible) { // pl_04 ?>
        <td data-name="pl_04"<?= $Page->pl_04->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pl_04" class="el_p_eastimate_pl_04">
<span<?= $Page->pl_04->viewAttributes() ?>>
<?= $Page->pl_04->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pl_04->Visible) { // qty_pl_04 ?>
        <td data-name="qty_pl_04"<?= $Page->qty_pl_04->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pl_04" class="el_p_eastimate_qty_pl_04">
<span<?= $Page->qty_pl_04->viewAttributes() ?>>
<?= $Page->qty_pl_04->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_01->Visible) { // pa_01 ?>
        <td data-name="pa_01"<?= $Page->pa_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pa_01" class="el_p_eastimate_pa_01">
<span<?= $Page->pa_01->viewAttributes() ?>>
<?= $Page->pa_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pa_01->Visible) { // qty_pa_01 ?>
        <td data-name="qty_pa_01"<?= $Page->qty_pa_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pa_01" class="el_p_eastimate_qty_pa_01">
<span<?= $Page->qty_pa_01->viewAttributes() ?>>
<?= $Page->qty_pa_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_02->Visible) { // pa_02 ?>
        <td data-name="pa_02"<?= $Page->pa_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pa_02" class="el_p_eastimate_pa_02">
<span<?= $Page->pa_02->viewAttributes() ?>>
<?= $Page->pa_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pa_02->Visible) { // qty_pa_02 ?>
        <td data-name="qty_pa_02"<?= $Page->qty_pa_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pa_02" class="el_p_eastimate_qty_pa_02">
<span<?= $Page->qty_pa_02->viewAttributes() ?>>
<?= $Page->qty_pa_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_03->Visible) { // pa_03 ?>
        <td data-name="pa_03"<?= $Page->pa_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pa_03" class="el_p_eastimate_pa_03">
<span<?= $Page->pa_03->viewAttributes() ?>>
<?= $Page->pa_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pa_03->Visible) { // qty_pa_03 ?>
        <td data-name="qty_pa_03"<?= $Page->qty_pa_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pa_03" class="el_p_eastimate_qty_pa_03">
<span<?= $Page->qty_pa_03->viewAttributes() ?>>
<?= $Page->qty_pa_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_04->Visible) { // pa_04 ?>
        <td data-name="pa_04"<?= $Page->pa_04->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pa_04" class="el_p_eastimate_pa_04">
<span<?= $Page->pa_04->viewAttributes() ?>>
<?= $Page->pa_04->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pa_04->Visible) { // qty_pa_04 ?>
        <td data-name="qty_pa_04"<?= $Page->qty_pa_04->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pa_04" class="el_p_eastimate_qty_pa_04">
<span<?= $Page->qty_pa_04->viewAttributes() ?>>
<?= $Page->qty_pa_04->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_05->Visible) { // pa_05 ?>
        <td data-name="pa_05"<?= $Page->pa_05->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pa_05" class="el_p_eastimate_pa_05">
<span<?= $Page->pa_05->viewAttributes() ?>>
<?= $Page->pa_05->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pa_05->Visible) { // qty_pa_05 ?>
        <td data-name="qty_pa_05"<?= $Page->qty_pa_05->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pa_05" class="el_p_eastimate_qty_pa_05">
<span<?= $Page->qty_pa_05->viewAttributes() ?>>
<?= $Page->qty_pa_05->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_01->Visible) { // pc_01 ?>
        <td data-name="pc_01"<?= $Page->pc_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pc_01" class="el_p_eastimate_pc_01">
<span<?= $Page->pc_01->viewAttributes() ?>>
<?= $Page->pc_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pc_01->Visible) { // qty_pc_01 ?>
        <td data-name="qty_pc_01"<?= $Page->qty_pc_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pc_01" class="el_p_eastimate_qty_pc_01">
<span<?= $Page->qty_pc_01->viewAttributes() ?>>
<?= $Page->qty_pc_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_02->Visible) { // pc_02 ?>
        <td data-name="pc_02"<?= $Page->pc_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_pc_02" class="el_p_eastimate_pc_02">
<span<?= $Page->pc_02->viewAttributes() ?>>
<?= $Page->pc_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_pc_02->Visible) { // qty_pc_02 ?>
        <td data-name="qty_pc_02"<?= $Page->qty_pc_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_pc_02" class="el_p_eastimate_qty_pc_02">
<span<?= $Page->qty_pc_02->viewAttributes() ?>>
<?= $Page->qty_pc_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->o_01->Visible) { // o_01 ?>
        <td data-name="o_01"<?= $Page->o_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_o_01" class="el_p_eastimate_o_01">
<span<?= $Page->o_01->viewAttributes() ?>>
<?= $Page->o_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_o_01->Visible) { // qty_o_01 ?>
        <td data-name="qty_o_01"<?= $Page->qty_o_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_o_01" class="el_p_eastimate_qty_o_01">
<span<?= $Page->qty_o_01->viewAttributes() ?>>
<?= $Page->qty_o_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lamination_type->Visible) { // lamination_type ?>
        <td data-name="lamination_type"<?= $Page->lamination_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_lamination_type" class="el_p_eastimate_lamination_type">
<span<?= $Page->lamination_type->viewAttributes() ?>>
<?= $Page->lamination_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lamination_qty->Visible) { // lamination_qty ?>
        <td data-name="lamination_qty"<?= $Page->lamination_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_lamination_qty" class="el_p_eastimate_lamination_qty">
<span<?= $Page->lamination_qty->viewAttributes() ?>>
<?= $Page->lamination_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->die_type->Visible) { // die_type ?>
        <td data-name="die_type"<?= $Page->die_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_die_type" class="el_p_eastimate_die_type">
<span<?= $Page->die_type->viewAttributes() ?>>
<?= $Page->die_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->die_qty->Visible) { // die_qty ?>
        <td data-name="die_qty"<?= $Page->die_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_die_qty" class="el_p_eastimate_die_qty">
<span<?= $Page->die_qty->viewAttributes() ?>>
<?= $Page->die_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->binding_type->Visible) { // binding_type ?>
        <td data-name="binding_type"<?= $Page->binding_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_binding_type" class="el_p_eastimate_binding_type">
<span<?= $Page->binding_type->viewAttributes() ?>>
<?= $Page->binding_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->binding_qty->Visible) { // binding_qty ?>
        <td data-name="binding_qty"<?= $Page->binding_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_binding_qty" class="el_p_eastimate_binding_qty">
<span<?= $Page->binding_qty->viewAttributes() ?>>
<?= $Page->binding_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->number_type->Visible) { // number_type ?>
        <td data-name="number_type"<?= $Page->number_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_number_type" class="el_p_eastimate_number_type">
<span<?= $Page->number_type->viewAttributes() ?>>
<?= $Page->number_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->number_qty->Visible) { // number_qty ?>
        <td data-name="number_qty"<?= $Page->number_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_number_qty" class="el_p_eastimate_number_qty">
<span<?= $Page->number_qty->viewAttributes() ?>>
<?= $Page->number_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->de_01->Visible) { // de_01 ?>
        <td data-name="de_01"<?= $Page->de_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_de_01" class="el_p_eastimate_de_01">
<span<?= $Page->de_01->viewAttributes() ?>>
<?= $Page->de_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_de_01->Visible) { // qty_de_01 ?>
        <td data-name="qty_de_01"<?= $Page->qty_de_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_de_01" class="el_p_eastimate_qty_de_01">
<span<?= $Page->qty_de_01->viewAttributes() ?>>
<?= $Page->qty_de_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->de_02->Visible) { // de_02 ?>
        <td data-name="de_02"<?= $Page->de_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_de_02" class="el_p_eastimate_de_02">
<span<?= $Page->de_02->viewAttributes() ?>>
<?= $Page->de_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_de_02->Visible) { // qty_de_02 ?>
        <td data-name="qty_de_02"<?= $Page->qty_de_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_de_02" class="el_p_eastimate_qty_de_02">
<span<?= $Page->qty_de_02->viewAttributes() ?>>
<?= $Page->qty_de_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->de_03->Visible) { // de_03 ?>
        <td data-name="de_03"<?= $Page->de_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_de_03" class="el_p_eastimate_de_03">
<span<?= $Page->de_03->viewAttributes() ?>>
<?= $Page->de_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty_de_03->Visible) { // qty_de_03 ?>
        <td data-name="qty_de_03"<?= $Page->qty_de_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_qty_de_03" class="el_p_eastimate_qty_de_03">
<span<?= $Page->qty_de_03->viewAttributes() ?>>
<?= $Page->qty_de_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_operator" class="el_p_eastimate_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_p_eastimate_datetime" class="el_p_eastimate_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("p_eastimate");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
