<?php

namespace PHPMaker2024\fibre;

// Page object
$PCartSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { p_cart: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fp_cartsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fp_cartsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["company_id", [ew.Validators.integer], fields.company_id.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["y_s_grp", [ew.Validators.between], false],
            ["rid_tmp", [], fields.rid_tmp.isInvalid],
            ["rid", [ew.Validators.integer], fields.rid.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["color", [], fields.color.isInvalid],
            ["quantity_sub", [ew.Validators.integer], fields.quantity_sub.isInvalid],
            ["qty", [ew.Validators.float], fields.qty.isInvalid],
            ["price", [ew.Validators.float], fields.price.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.integer], fields.datetime.isInvalid],
            ["po_id", [ew.Validators.integer], fields.po_id.isInvalid],
            ["c_operator", [], fields.c_operator.isInvalid],
            ["c_datetime", [ew.Validators.datetime(fields.c_datetime.clientFormatPattern)], fields.c_datetime.isInvalid],
            ["d_operator", [ew.Validators.integer], fields.d_operator.isInvalid],
            ["d_datetime", [ew.Validators.datetime(fields.d_datetime.clientFormatPattern)], fields.d_datetime.isInvalid],
            ["day_p", [], fields.day_p.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "rid_tmp": <?= $Page->rid_tmp->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "color": <?= $Page->color->toClientList($Page) ?>,
            "c_operator": <?= $Page->c_operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fp_cartsearch" id="fp_cartsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="p_cart">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="p_cart" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-control ew-select<?= $Page->company_id->isInvalidClass() ?>"
        data-select2-id="fp_cartsearch_x_company_id"
        data-table="p_cart"
        data-field="x_company_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->company_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<script>
loadjs.ready("fp_cartsearch", function() {
    var options = { name: "x_company_id", selectId: "fp_cartsearch_x_company_id" };
    if (fp_cartsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fp_cartsearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fp_cartsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_cart.fields.company_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_s_grp"><?= $Page->s_grp->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_s_grp" id="z_s_grp" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->s_grp->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->s_grp->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_p_cart_s_grp" class="ew-search-field">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fp_cartsearch_x_s_grp"
        <?php } ?>
        data-table="p_cart"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_cartsearch", function() {
    var options = { name: "x_s_grp", selectId: "fp_cartsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_cartsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fp_cartsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fp_cartsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_cart.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_p_cart_s_grp" class="ew-search-field2 d-none">
    <select
        id="y_s_grp"
        name="y_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fp_cartsearch_y_s_grp"
        <?php } ?>
        data-table="p_cart"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("y_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_y_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_cartsearch", function() {
    var options = { name: "y_s_grp", selectId: "fp_cartsearch_y_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_cartsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "y_s_grp", form: "fp_cartsearch" };
    } else {
        options.ajax = { id: "y_s_grp", form: "fp_cartsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_cart.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid_tmp->Visible) { // rid_tmp ?>
    <div id="r_rid_tmp" class="row"<?= $Page->rid_tmp->rowAttributes() ?>>
        <label for="x_rid_tmp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_rid_tmp"><?= $Page->rid_tmp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid_tmp" id="z_rid_tmp" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid_tmp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_rid_tmp" class="ew-search-field">
    <select
        id="x_rid_tmp"
        name="x_rid_tmp"
        class="form-control ew-select<?= $Page->rid_tmp->isInvalidClass() ?>"
        data-select2-id="fp_cartsearch_x_rid_tmp"
        data-table="p_cart"
        data-field="x_rid_tmp"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid_tmp->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid_tmp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_tmp->getPlaceHolder()) ?>"
        <?= $Page->rid_tmp->editAttributes() ?>>
        <?= $Page->rid_tmp->selectOptionListHtml("x_rid_tmp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid_tmp->getErrorMessage(false) ?></div>
<?= $Page->rid_tmp->Lookup->getParamTag($Page, "p_x_rid_tmp") ?>
<script>
loadjs.ready("fp_cartsearch", function() {
    var options = { name: "x_rid_tmp", selectId: "fp_cartsearch_x_rid_tmp" };
    if (fp_cartsearch.lists.rid_tmp?.lookupOptions.length) {
        options.data = { id: "x_rid_tmp", form: "fp_cartsearch" };
    } else {
        options.ajax = { id: "x_rid_tmp", form: "fp_cartsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_cart.fields.rid_tmp.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_rid_tmp_1" name="v_rid_tmp" value="AND"<?= ($Page->rid_tmp->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_rid_tmp_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_rid_tmp_2" name="v_rid_tmp" value="OR"<?= ($Page->rid_tmp->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_rid_tmp_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_rid_tmp" id="w_rid_tmp" value="=">
</span>
                    <span id="el2_p_cart_rid_tmp" class="ew-search-field2">
    <select
        id="y_rid_tmp"
        name="y_rid_tmp"
        class="form-control ew-select<?= $Page->rid_tmp->isInvalidClass() ?>"
        data-select2-id="fp_cartsearch_y_rid_tmp"
        data-table="p_cart"
        data-field="x_rid_tmp"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid_tmp->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid_tmp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_tmp->getPlaceHolder()) ?>"
        <?= $Page->rid_tmp->editAttributes() ?>>
        <?= $Page->rid_tmp->selectOptionListHtml("y_rid_tmp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid_tmp->getErrorMessage(false) ?></div>
<?= $Page->rid_tmp->Lookup->getParamTag($Page, "p_y_rid_tmp") ?>
<script>
loadjs.ready("fp_cartsearch", function() {
    var options = { name: "y_rid_tmp", selectId: "fp_cartsearch_y_rid_tmp" };
    if (fp_cartsearch.lists.rid_tmp?.lookupOptions.length) {
        options.data = { id: "y_rid_tmp", form: "fp_cartsearch" };
    } else {
        options.ajax = { id: "y_rid_tmp", form: "fp_cartsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.p_cart.fields.rid_tmp.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_rid" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="p_cart" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fp_cartsearch", function() {
    fp_cartsearch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.p_cart.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fp_cartsearch_x_packing_type"
        <?php } ?>
        data-table="p_cart"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_cartsearch", function() {
    var options = { name: "x_packing_type", selectId: "fp_cartsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_cartsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fp_cartsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fp_cartsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_cart.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->color->Visible) { // color ?>
    <div id="r_color" class="row"<?= $Page->color->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_color"><?= $Page->color->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_color" id="z_color" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->color->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_color" class="ew-search-field ew-search-field-single">
<template id="tp_x_color">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="p_cart" data-field="x_color" name="x_color" id="x_color"<?= $Page->color->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_color" class="ew-item-list"></div>
<selection-list hidden
    id="x_color[]"
    name="x_color[]"
    value="<?= HtmlEncode($Page->color->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_color"
    data-target="dsl_x_color"
    data-repeatcolumn="4"
    class="form-control<?= $Page->color->isInvalidClass() ?>"
    data-table="p_cart"
    data-field="x_color"
    data-value-separator="<?= $Page->color->displayValueSeparatorAttribute() ?>"
    <?= $Page->color->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->color->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity_sub->Visible) { // quantity_sub ?>
    <div id="r_quantity_sub" class="row"<?= $Page->quantity_sub->rowAttributes() ?>>
        <label for="x_quantity_sub" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_quantity_sub"><?= $Page->quantity_sub->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity_sub" id="z_quantity_sub" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity_sub->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_quantity_sub" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity_sub->getInputTextType() ?>" name="x_quantity_sub" id="x_quantity_sub" data-table="p_cart" data-field="x_quantity_sub" value="<?= $Page->quantity_sub->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity_sub->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity_sub->formatPattern()) ?>"<?= $Page->quantity_sub->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity_sub->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <div id="r_qty" class="row"<?= $Page->qty->rowAttributes() ?>>
        <label for="x_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_qty"><?= $Page->qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty" id="z_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty->getInputTextType() ?>" name="x_qty" id="x_qty" data-table="p_cart" data-field="x_qty" value="<?= $Page->qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty->formatPattern()) ?>"<?= $Page->qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price" class="row"<?= $Page->price->rowAttributes() ?>>
        <label for="x_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_price"><?= $Page->price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price" id="z_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="p_cart" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="p_cart" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="p_cart" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="p_cart" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="p_cart" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_id->Visible) { // po_id ?>
    <div id="r_po_id" class="row"<?= $Page->po_id->rowAttributes() ?>>
        <label for="x_po_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_po_id"><?= $Page->po_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po_id" id="z_po_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_po_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po_id->getInputTextType() ?>" name="x_po_id" id="x_po_id" data-table="p_cart" data-field="x_po_id" value="<?= $Page->po_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_id->formatPattern()) ?>"<?= $Page->po_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->c_operator->Visible) { // c_operator ?>
    <div id="r_c_operator" class="row"<?= $Page->c_operator->rowAttributes() ?>>
        <label for="x_c_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_c_operator"><?= $Page->c_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_c_operator" id="z_c_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->c_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_c_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_c_operator"
        name="x_c_operator"
        class="form-select ew-select<?= $Page->c_operator->isInvalidClass() ?>"
        <?php if (!$Page->c_operator->IsNativeSelect) { ?>
        data-select2-id="fp_cartsearch_x_c_operator"
        <?php } ?>
        data-table="p_cart"
        data-field="x_c_operator"
        data-value-separator="<?= $Page->c_operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->c_operator->getPlaceHolder()) ?>"
        <?= $Page->c_operator->editAttributes() ?>>
        <?= $Page->c_operator->selectOptionListHtml("x_c_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->c_operator->getErrorMessage(false) ?></div>
<?= $Page->c_operator->Lookup->getParamTag($Page, "p_x_c_operator") ?>
<?php if (!$Page->c_operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fp_cartsearch", function() {
    var options = { name: "x_c_operator", selectId: "fp_cartsearch_x_c_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fp_cartsearch.lists.c_operator?.lookupOptions.length) {
        options.data = { id: "x_c_operator", form: "fp_cartsearch" };
    } else {
        options.ajax = { id: "x_c_operator", form: "fp_cartsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.p_cart.fields.c_operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->c_datetime->Visible) { // c_datetime ?>
    <div id="r_c_datetime" class="row"<?= $Page->c_datetime->rowAttributes() ?>>
        <label for="x_c_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_c_datetime"><?= $Page->c_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_c_datetime" id="z_c_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->c_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_c_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->c_datetime->getInputTextType() ?>" name="x_c_datetime" id="x_c_datetime" data-table="p_cart" data-field="x_c_datetime" value="<?= $Page->c_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->c_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->c_datetime->formatPattern()) ?>"<?= $Page->c_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->c_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->c_datetime->ReadOnly && !$Page->c_datetime->Disabled && !isset($Page->c_datetime->EditAttrs["readonly"]) && !isset($Page->c_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fp_cartsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fp_cartsearch", "x_c_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_operator->Visible) { // d_operator ?>
    <div id="r_d_operator" class="row"<?= $Page->d_operator->rowAttributes() ?>>
        <label for="x_d_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_d_operator"><?= $Page->d_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_operator" id="z_d_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_d_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_operator->getInputTextType() ?>" name="x_d_operator" id="x_d_operator" data-table="p_cart" data-field="x_d_operator" value="<?= $Page->d_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->d_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_operator->formatPattern()) ?>"<?= $Page->d_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_datetime->Visible) { // d_datetime ?>
    <div id="r_d_datetime" class="row"<?= $Page->d_datetime->rowAttributes() ?>>
        <label for="x_d_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_d_datetime"><?= $Page->d_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_datetime" id="z_d_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_d_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_datetime->getInputTextType() ?>" name="x_d_datetime" id="x_d_datetime" data-table="p_cart" data-field="x_d_datetime" value="<?= $Page->d_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->d_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_datetime->formatPattern()) ?>"<?= $Page->d_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->d_datetime->ReadOnly && !$Page->d_datetime->Disabled && !isset($Page->d_datetime->EditAttrs["readonly"]) && !isset($Page->d_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fp_cartsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fp_cartsearch", "x_d_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->day_p->Visible) { // day_p ?>
    <div id="r_day_p" class="row"<?= $Page->day_p->rowAttributes() ?>>
        <label for="x_day_p" class="<?= $Page->LeftColumnClass ?>"><span id="elh_p_cart_day_p"><?= $Page->day_p->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_day_p" id="z_day_p" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->day_p->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_p_cart_day_p" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->day_p->getInputTextType() ?>" name="x_day_p" id="x_day_p" data-table="p_cart" data-field="x_day_p" value="<?= $Page->day_p->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->day_p->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->day_p->formatPattern()) ?>"<?= $Page->day_p->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->day_p->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fp_cartsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fp_cartsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fp_cartsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("p_cart");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
