<?php

namespace PHPMaker2024\fibre;

// Page object
$OmsTableList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { oms_table: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="foms_tablesrch" id="foms_tablesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="foms_tablesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { oms_table: currentTable } });
var currentForm;
var foms_tablesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("foms_tablesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["reports_to", [], fields.reports_to.isInvalid],
            ["buyer_order", [], fields.buyer_order.isInvalid],
            ["ex_factory_p", [], fields.ex_factory_p.isInvalid],
            ["y_ex_factory_p", [ew.Validators.between], false],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["design", [], fields.design.isInvalid],
            ["pending", [ew.Validators.float], fields.pending.isInvalid],
            ["y_pending", [ew.Validators.between], false],
            ["remarks", [], fields.remarks.isInvalid],
            ["pl_no", [], fields.pl_no.isInvalid],
            ["completed", [], fields.completed.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "ex_factory_p": <?= $Page->ex_factory_p->toClientList($Page) ?>,
            "completed": <?= $Page->completed->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
<?php
if (!$Page->buyers_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyers_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyers_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_buyers_id" class="ew-search-caption ew-label"><?= $Page->buyers_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</div>
        </div>
        <div id="el_oms_table_buyers_id" class="ew-search-field">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="foms_tablesrch_x_buyers_id"
        <?php } ?>
        data-table="oms_table"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("foms_tablesrch", function() {
    var options = { name: "x_buyers_id", selectId: "foms_tablesrch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (foms_tablesrch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "foms_tablesrch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "foms_tablesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.oms_table.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
<?php
if (!$Page->reports_to->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_reports_to" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->reports_to->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_reports_to" class="ew-search-caption ew-label"><?= $Page->reports_to->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_reports_to" id="z_reports_to" value="=">
</div>
        </div>
        <div id="el_oms_table_reports_to" class="ew-search-field">
    <select
        id="x_reports_to[]"
        name="x_reports_to[]"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="foms_tablesrch_x_reports_to[]"
        <?php } ?>
        data-table="oms_table"
        data-field="x_reports_to"
        multiple
        size="1"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage(false) ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("foms_tablesrch", function() {
    var options = { name: "x_reports_to[]", selectId: "foms_tablesrch_x_reports_to[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (foms_tablesrch.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to[]", form: "foms_tablesrch" };
    } else {
        options.ajax = { id: "x_reports_to[]", form: "foms_tablesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.oms_table.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyer_order->Visible) { // buyer_order ?>
<?php
if (!$Page->buyer_order->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer_order" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer_order->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_buyer_order" class="ew-search-caption ew-label"><?= $Page->buyer_order->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_order" id="z_buyer_order" value="LIKE">
</div>
        </div>
        <div id="el_oms_table_buyer_order" class="ew-search-field">
<input type="<?= $Page->buyer_order->getInputTextType() ?>" name="x_buyer_order" id="x_buyer_order" data-table="oms_table" data-field="x_buyer_order" value="<?= $Page->buyer_order->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_order->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_order->formatPattern()) ?>"<?= $Page->buyer_order->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_order->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ex_factory_p->Visible) { // ex_factory_p ?>
<?php
if (!$Page->ex_factory_p->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ex_factory_p" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ex_factory_p->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_ex_factory_p" class="ew-search-caption ew-label"><?= $Page->ex_factory_p->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_ex_factory_p" id="z_ex_factory_p" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->ex_factory_p->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->ex_factory_p->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_oms_table_ex_factory_p" class="ew-search-field">
    <select
        id="x_ex_factory_p[]"
        name="x_ex_factory_p[]"
        class="form-select ew-select<?= $Page->ex_factory_p->isInvalidClass() ?>"
        <?php if (!$Page->ex_factory_p->IsNativeSelect) { ?>
        data-select2-id="foms_tablesrch_x_ex_factory_p[]"
        <?php } ?>
        data-table="oms_table"
        data-field="x_ex_factory_p"
        multiple
        size="1"
        data-value-separator="<?= $Page->ex_factory_p->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ex_factory_p->getPlaceHolder()) ?>"
        <?= $Page->ex_factory_p->editAttributes() ?>>
        <?= $Page->ex_factory_p->selectOptionListHtml("x_ex_factory_p[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ex_factory_p->getErrorMessage(false) ?></div>
<?= $Page->ex_factory_p->Lookup->getParamTag($Page, "p_x_ex_factory_p") ?>
<?php if (!$Page->ex_factory_p->IsNativeSelect) { ?>
<style>oms_table-x_ex_factory_p-dropdown { max-height: 300px !important; overflow-y: auto }</style>
<script>
loadjs.ready("foms_tablesrch", function() {
    var options = { name: "x_ex_factory_p[]", selectId: "foms_tablesrch_x_ex_factory_p[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (foms_tablesrch.lists.ex_factory_p?.lookupOptions.length) {
        options.data = { id: "x_ex_factory_p[]", form: "foms_tablesrch" };
    } else {
        options.ajax = { id: "x_ex_factory_p[]", form: "foms_tablesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.oms_table.fields.ex_factory_p.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_oms_table_ex_factory_p" class="ew-search-field2 d-none">
    <select
        id="y_ex_factory_p[]"
        name="y_ex_factory_p[]"
        class="form-select ew-select<?= $Page->ex_factory_p->isInvalidClass() ?>"
        <?php if (!$Page->ex_factory_p->IsNativeSelect) { ?>
        data-select2-id="foms_tablesrch_y_ex_factory_p[]"
        <?php } ?>
        data-table="oms_table"
        data-field="x_ex_factory_p"
        multiple
        size="1"
        data-value-separator="<?= $Page->ex_factory_p->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ex_factory_p->getPlaceHolder()) ?>"
        <?= $Page->ex_factory_p->editAttributes() ?>>
        <?= $Page->ex_factory_p->selectOptionListHtml("y_ex_factory_p[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ex_factory_p->getErrorMessage(false) ?></div>
<?= $Page->ex_factory_p->Lookup->getParamTag($Page, "p_y_ex_factory_p") ?>
<?php if (!$Page->ex_factory_p->IsNativeSelect) { ?>
<style>oms_table-x_ex_factory_p-dropdown { max-height: 300px !important; overflow-y: auto }</style>
<script>
loadjs.ready("foms_tablesrch", function() {
    var options = { name: "y_ex_factory_p[]", selectId: "foms_tablesrch_y_ex_factory_p[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (foms_tablesrch.lists.ex_factory_p?.lookupOptions.length) {
        options.data = { id: "y_ex_factory_p[]", form: "foms_tablesrch" };
    } else {
        options.ajax = { id: "y_ex_factory_p[]", form: "foms_tablesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.oms_table.fields.ex_factory_p.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
<?php
if (!$Page->po->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_po" class="ew-search-caption ew-label"><?= $Page->po->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_oms_table_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="oms_table" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_oms_table_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="oms_table" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
<?php
if (!$Page->design->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_design" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->design->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_design" class="ew-search-caption ew-label"><?= $Page->design->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design" id="z_design" value="LIKE">
</div>
        </div>
        <div id="el_oms_table_design" class="ew-search-field">
<input type="<?= $Page->design->getInputTextType() ?>" name="x_design" id="x_design" data-table="oms_table" data-field="x_design" value="<?= $Page->design->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design->formatPattern()) ?>"<?= $Page->design->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->pending->Visible) { // pending ?>
<?php
if (!$Page->pending->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_pending" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->pending->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_pending" class="ew-search-caption ew-label"><?= $Page->pending->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_pending" id="z_pending" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->pending->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->pending->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_oms_table_pending" class="ew-search-field">
<input type="<?= $Page->pending->getInputTextType() ?>" name="x_pending" id="x_pending" data-table="oms_table" data-field="x_pending" value="<?= $Page->pending->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending->formatPattern()) ?>"<?= $Page->pending->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_oms_table_pending" class="ew-search-field2 d-none">
<input type="<?= $Page->pending->getInputTextType() ?>" name="y_pending" id="y_pending" data-table="oms_table" data-field="x_pending" value="<?= $Page->pending->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->pending->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending->formatPattern()) ?>"<?= $Page->pending->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
<?php
if (!$Page->remarks->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_remarks" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->remarks->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_remarks" class="ew-search-caption ew-label"><?= $Page->remarks->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</div>
        </div>
        <div id="el_oms_table_remarks" class="ew-search-field">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="oms_table" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
<?php
if (!$Page->pl_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_pl_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->pl_no->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_pl_no" class="ew-search-caption ew-label"><?= $Page->pl_no->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pl_no" id="z_pl_no" value="LIKE">
</div>
        </div>
        <div id="el_oms_table_pl_no" class="ew-search-field">
<input type="<?= $Page->pl_no->getInputTextType() ?>" name="x_pl_no" id="x_pl_no" data-table="oms_table" data-field="x_pl_no" value="<?= $Page->pl_no->EditValue ?>" maxlength="192" placeholder="<?= HtmlEncode($Page->pl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_no->formatPattern()) ?>"<?= $Page->pl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pl_no->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->completed->Visible) { // completed ?>
<?php
if (!$Page->completed->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_completed" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->completed->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_completed" class="ew-search-caption ew-label"><?= $Page->completed->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_completed" id="z_completed" value="LIKE">
</div>
        </div>
        <div id="el_oms_table_completed" class="ew-search-field">
    <select
        id="x_completed"
        name="x_completed"
        class="form-select ew-select<?= $Page->completed->isInvalidClass() ?>"
        <?php if (!$Page->completed->IsNativeSelect) { ?>
        data-select2-id="foms_tablesrch_x_completed"
        <?php } ?>
        data-table="oms_table"
        data-field="x_completed"
        data-value-separator="<?= $Page->completed->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->completed->getPlaceHolder()) ?>"
        <?= $Page->completed->editAttributes() ?>>
        <?= $Page->completed->selectOptionListHtml("x_completed") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->completed->getErrorMessage(false) ?></div>
<?php if (!$Page->completed->IsNativeSelect) { ?>
<script>
loadjs.ready("foms_tablesrch", function() {
    var options = { name: "x_completed", selectId: "foms_tablesrch_x_completed" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (foms_tablesrch.lists.completed?.lookupOptions.length) {
        options.data = { id: "x_completed", form: "foms_tablesrch" };
    } else {
        options.ajax = { id: "x_completed", form: "foms_tablesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.oms_table.fields.completed.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="foms_tablesrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="foms_tablesrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="foms_tablesrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="foms_tablesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="foms_tablesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="foms_tablesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="foms_tablesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="oms_table">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_oms_table" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_oms_tablelist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_oms_table_id" class="oms_table_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <th data-name="buyers_id" class="<?= $Page->buyers_id->headerCellClass() ?>"><div id="elh_oms_table_buyers_id" class="oms_table_buyers_id"><?= $Page->renderFieldHeader($Page->buyers_id) ?></div></th>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
        <th data-name="reports_to" class="<?= $Page->reports_to->headerCellClass() ?>"><div id="elh_oms_table_reports_to" class="oms_table_reports_to"><?= $Page->renderFieldHeader($Page->reports_to) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_order->Visible) { // buyer_order ?>
        <th data-name="buyer_order" class="<?= $Page->buyer_order->headerCellClass() ?>"><div id="elh_oms_table_buyer_order" class="oms_table_buyer_order"><?= $Page->renderFieldHeader($Page->buyer_order) ?></div></th>
<?php } ?>
<?php if ($Page->item->Visible) { // item ?>
        <th data-name="item" class="<?= $Page->item->headerCellClass() ?>"><div id="elh_oms_table_item" class="oms_table_item"><?= $Page->renderFieldHeader($Page->item) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <th data-name="buyer_ref" class="<?= $Page->buyer_ref->headerCellClass() ?>"><div id="elh_oms_table_buyer_ref" class="oms_table_buyer_ref"><?= $Page->renderFieldHeader($Page->buyer_ref) ?></div></th>
<?php } ?>
<?php if ($Page->order_week->Visible) { // order_week ?>
        <th data-name="order_week" class="<?= $Page->order_week->headerCellClass() ?>"><div id="elh_oms_table_order_week" class="oms_table_order_week"><?= $Page->renderFieldHeader($Page->order_week) ?></div></th>
<?php } ?>
<?php if ($Page->order_date->Visible) { // order_date ?>
        <th data-name="order_date" class="<?= $Page->order_date->headerCellClass() ?>"><div id="elh_oms_table_order_date" class="oms_table_order_date"><?= $Page->renderFieldHeader($Page->order_date) ?></div></th>
<?php } ?>
<?php if ($Page->ex_factory->Visible) { // ex_factory ?>
        <th data-name="ex_factory" class="<?= $Page->ex_factory->headerCellClass() ?>"><div id="elh_oms_table_ex_factory" class="oms_table_ex_factory"><?= $Page->renderFieldHeader($Page->ex_factory) ?></div></th>
<?php } ?>
<?php if ($Page->ex_factory_p->Visible) { // ex_factory_p ?>
        <th data-name="ex_factory_p" class="<?= $Page->ex_factory_p->headerCellClass() ?>"><div id="elh_oms_table_ex_factory_p" class="oms_table_ex_factory_p"><?= $Page->renderFieldHeader($Page->ex_factory_p) ?></div></th>
<?php } ?>
<?php if ($Page->shipping_mode->Visible) { // shipping_mode ?>
        <th data-name="shipping_mode" class="<?= $Page->shipping_mode->headerCellClass() ?>"><div id="elh_oms_table_shipping_mode" class="oms_table_shipping_mode"><?= $Page->renderFieldHeader($Page->shipping_mode) ?></div></th>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_oms_table_po" class="oms_table_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
        <th data-name="design" class="<?= $Page->design->headerCellClass() ?>"><div id="elh_oms_table_design" class="oms_table_design"><?= $Page->renderFieldHeader($Page->design) ?></div></th>
<?php } ?>
<?php if ($Page->size_buyer->Visible) { // size_buyer ?>
        <th data-name="size_buyer" class="<?= $Page->size_buyer->headerCellClass() ?>"><div id="elh_oms_table_size_buyer" class="oms_table_size_buyer"><?= $Page->renderFieldHeader($Page->size_buyer) ?></div></th>
<?php } ?>
<?php if ($Page->width->Visible) { // width ?>
        <th data-name="width" class="<?= $Page->width->headerCellClass() ?>"><div id="elh_oms_table_width" class="oms_table_width"><?= $Page->renderFieldHeader($Page->width) ?></div></th>
<?php } ?>
<?php if ($Page->length->Visible) { // length ?>
        <th data-name="length" class="<?= $Page->length->headerCellClass() ?>"><div id="elh_oms_table_length" class="oms_table_length"><?= $Page->renderFieldHeader($Page->length) ?></div></th>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
        <th data-name="qty" class="<?= $Page->qty->headerCellClass() ?>"><div id="elh_oms_table_qty" class="oms_table_qty"><?= $Page->renderFieldHeader($Page->qty) ?></div></th>
<?php } ?>
<?php if ($Page->revised_qty->Visible) { // revised_qty ?>
        <th data-name="revised_qty" class="<?= $Page->revised_qty->headerCellClass() ?>"><div id="elh_oms_table_revised_qty" class="oms_table_revised_qty"><?= $Page->renderFieldHeader($Page->revised_qty) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_oms_table_sqm" class="oms_table_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->d_qty->Visible) { // d_qty ?>
        <th data-name="d_qty" class="<?= $Page->d_qty->headerCellClass() ?>"><div id="elh_oms_table_d_qty" class="oms_table_d_qty"><?= $Page->renderFieldHeader($Page->d_qty) ?></div></th>
<?php } ?>
<?php if ($Page->pending->Visible) { // pending ?>
        <th data-name="pending" class="<?= $Page->pending->headerCellClass() ?>"><div id="elh_oms_table_pending" class="oms_table_pending"><?= $Page->renderFieldHeader($Page->pending) ?></div></th>
<?php } ?>
<?php if ($Page->pending_sqm->Visible) { // pending_sqm ?>
        <th data-name="pending_sqm" class="<?= $Page->pending_sqm->headerCellClass() ?>"><div id="elh_oms_table_pending_sqm" class="oms_table_pending_sqm"><?= $Page->renderFieldHeader($Page->pending_sqm) ?></div></th>
<?php } ?>
<?php if ($Page->offloom->Visible) { // offloom ?>
        <th data-name="offloom" class="<?= $Page->offloom->headerCellClass() ?>"><div id="elh_oms_table_offloom" class="oms_table_offloom"><?= $Page->renderFieldHeader($Page->offloom) ?></div></th>
<?php } ?>
<?php if ($Page->pending_offloom->Visible) { // pending_offloom ?>
        <th data-name="pending_offloom" class="<?= $Page->pending_offloom->headerCellClass() ?>"><div id="elh_oms_table_pending_offloom" class="oms_table_pending_offloom"><?= $Page->renderFieldHeader($Page->pending_offloom) ?></div></th>
<?php } ?>
<?php if ($Page->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
        <th data-name="pending_offloom_sqm" class="<?= $Page->pending_offloom_sqm->headerCellClass() ?>"><div id="elh_oms_table_pending_offloom_sqm" class="oms_table_pending_offloom_sqm"><?= $Page->renderFieldHeader($Page->pending_offloom_sqm) ?></div></th>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
        <th data-name="cbm" class="<?= $Page->cbm->headerCellClass() ?>"><div id="elh_oms_table_cbm" class="oms_table_cbm"><?= $Page->renderFieldHeader($Page->cbm) ?></div></th>
<?php } ?>
<?php if ($Page->total_cbm->Visible) { // total_cbm ?>
        <th data-name="total_cbm" class="<?= $Page->total_cbm->headerCellClass() ?>"><div id="elh_oms_table_total_cbm" class="oms_table_total_cbm"><?= $Page->renderFieldHeader($Page->total_cbm) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_oms_table_remarks" class="oms_table_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
        <th data-name="pl_no" class="<?= $Page->pl_no->headerCellClass() ?>"><div id="elh_oms_table_pl_no" class="oms_table_pl_no"><?= $Page->renderFieldHeader($Page->pl_no) ?></div></th>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
        <th data-name="invoice_date" class="<?= $Page->invoice_date->headerCellClass() ?>"><div id="elh_oms_table_invoice_date" class="oms_table_invoice_date"><?= $Page->renderFieldHeader($Page->invoice_date) ?></div></th>
<?php } ?>
<?php if ($Page->sailing_week->Visible) { // sailing_week ?>
        <th data-name="sailing_week" class="<?= $Page->sailing_week->headerCellClass() ?>"><div id="elh_oms_table_sailing_week" class="oms_table_sailing_week"><?= $Page->renderFieldHeader($Page->sailing_week) ?></div></th>
<?php } ?>
<?php if ($Page->seller_remarks->Visible) { // seller_remarks ?>
        <th data-name="seller_remarks" class="<?= $Page->seller_remarks->headerCellClass() ?>"><div id="elh_oms_table_seller_remarks" class="oms_table_seller_remarks"><?= $Page->renderFieldHeader($Page->seller_remarks) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_oms_table_status" class="oms_table_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->rejection->Visible) { // rejection ?>
        <th data-name="rejection" class="<?= $Page->rejection->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_oms_table_rejection" class="oms_table_rejection"><?= $Page->renderFieldHeader($Page->rejection) ?></div></th>
<?php } ?>
<?php if ($Page->completed->Visible) { // completed ?>
        <th data-name="completed" class="<?= $Page->completed->headerCellClass() ?>"><div id="elh_oms_table_completed" class="oms_table_completed"><?= $Page->renderFieldHeader($Page->completed) ?></div></th>
<?php } ?>
<?php if ($Page->weight_sqm->Visible) { // weight_sqm ?>
        <th data-name="weight_sqm" class="<?= $Page->weight_sqm->headerCellClass() ?>"><div id="elh_oms_table_weight_sqm" class="oms_table_weight_sqm"><?= $Page->renderFieldHeader($Page->weight_sqm) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_id" class="el_oms_table_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id"<?= $Page->buyers_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_buyers_id" class="el_oms_table_buyers_id">
<span<?= $Page->buyers_id->viewAttributes() ?>>
<?= $Page->buyers_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->reports_to->Visible) { // reports_to ?>
        <td data-name="reports_to"<?= $Page->reports_to->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_reports_to" class="el_oms_table_reports_to">
<span<?= $Page->reports_to->viewAttributes() ?>>
<?= $Page->reports_to->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_order->Visible) { // buyer_order ?>
        <td data-name="buyer_order"<?= $Page->buyer_order->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_buyer_order" class="el_oms_table_buyer_order">
<span<?= $Page->buyer_order->viewAttributes() ?>>
<?= $Page->buyer_order->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->item->Visible) { // item ?>
        <td data-name="item"<?= $Page->item->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_item" class="el_oms_table_item">
<span<?= $Page->item->viewAttributes() ?>>
<?= $Page->item->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <td data-name="buyer_ref"<?= $Page->buyer_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_buyer_ref" class="el_oms_table_buyer_ref">
<span<?= $Page->buyer_ref->viewAttributes() ?>>
<?= $Page->buyer_ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->order_week->Visible) { // order_week ?>
        <td data-name="order_week"<?= $Page->order_week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_order_week" class="el_oms_table_order_week">
<span<?= $Page->order_week->viewAttributes() ?>>
<?= $Page->order_week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->order_date->Visible) { // order_date ?>
        <td data-name="order_date"<?= $Page->order_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_order_date" class="el_oms_table_order_date">
<span<?= $Page->order_date->viewAttributes() ?>>
<?= $Page->order_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ex_factory->Visible) { // ex_factory ?>
        <td data-name="ex_factory"<?= $Page->ex_factory->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_ex_factory" class="el_oms_table_ex_factory">
<span<?= $Page->ex_factory->viewAttributes() ?>>
<?= $Page->ex_factory->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ex_factory_p->Visible) { // ex_factory_p ?>
        <td data-name="ex_factory_p"<?= $Page->ex_factory_p->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_ex_factory_p" class="el_oms_table_ex_factory_p">
<span<?= $Page->ex_factory_p->viewAttributes() ?>>
<?= $Page->ex_factory_p->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shipping_mode->Visible) { // shipping_mode ?>
        <td data-name="shipping_mode"<?= $Page->shipping_mode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_shipping_mode" class="el_oms_table_shipping_mode">
<span<?= $Page->shipping_mode->viewAttributes() ?>>
<?= $Page->shipping_mode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_po" class="el_oms_table_po">
<span<?= $Page->po->viewAttributes() ?>>
<?= $Page->po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design->Visible) { // design ?>
        <td data-name="design"<?= $Page->design->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_design" class="el_oms_table_design">
<span<?= $Page->design->viewAttributes() ?>>
<?= $Page->design->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_buyer->Visible) { // size_buyer ?>
        <td data-name="size_buyer"<?= $Page->size_buyer->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_size_buyer" class="el_oms_table_size_buyer">
<span<?= $Page->size_buyer->viewAttributes() ?>>
<?= $Page->size_buyer->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->width->Visible) { // width ?>
        <td data-name="width"<?= $Page->width->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_width" class="el_oms_table_width">
<span<?= $Page->width->viewAttributes() ?>>
<?= $Page->width->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->length->Visible) { // length ?>
        <td data-name="length"<?= $Page->length->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_length" class="el_oms_table_length">
<span<?= $Page->length->viewAttributes() ?>>
<?= $Page->length->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty->Visible) { // qty ?>
        <td data-name="qty"<?= $Page->qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_qty" class="el_oms_table_qty">
<span<?= $Page->qty->viewAttributes() ?>>
<?= $Page->qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->revised_qty->Visible) { // revised_qty ?>
        <td data-name="revised_qty"<?= $Page->revised_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_revised_qty" class="el_oms_table_revised_qty">
<span<?= $Page->revised_qty->viewAttributes() ?>>
<?= $Page->revised_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_sqm" class="el_oms_table_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_qty->Visible) { // d_qty ?>
        <td data-name="d_qty"<?= $Page->d_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_d_qty" class="el_oms_table_d_qty">
<span<?= $Page->d_qty->viewAttributes() ?>>
<?= $Page->d_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pending->Visible) { // pending ?>
        <td data-name="pending"<?= $Page->pending->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_pending" class="el_oms_table_pending">
<span<?= $Page->pending->viewAttributes() ?>>
<?php if (!EmptyString($Page->pending->getViewValue()) && $Page->pending->linkAttributes() != "") { ?>
<a<?= $Page->pending->linkAttributes() ?>><?= $Page->pending->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->pending->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pending_sqm->Visible) { // pending_sqm ?>
        <td data-name="pending_sqm"<?= $Page->pending_sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_pending_sqm" class="el_oms_table_pending_sqm">
<span<?= $Page->pending_sqm->viewAttributes() ?>>
<?= $Page->pending_sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->offloom->Visible) { // offloom ?>
        <td data-name="offloom"<?= $Page->offloom->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_offloom" class="el_oms_table_offloom">
<span<?= $Page->offloom->viewAttributes() ?>>
<?= $Page->offloom->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pending_offloom->Visible) { // pending_offloom ?>
        <td data-name="pending_offloom"<?= $Page->pending_offloom->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_pending_offloom" class="el_oms_table_pending_offloom">
<span<?= $Page->pending_offloom->viewAttributes() ?>>
<?= $Page->pending_offloom->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
        <td data-name="pending_offloom_sqm"<?= $Page->pending_offloom_sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_pending_offloom_sqm" class="el_oms_table_pending_offloom_sqm">
<span<?= $Page->pending_offloom_sqm->viewAttributes() ?>>
<?= $Page->pending_offloom_sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cbm->Visible) { // cbm ?>
        <td data-name="cbm"<?= $Page->cbm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_cbm" class="el_oms_table_cbm">
<span<?= $Page->cbm->viewAttributes() ?>>
<?= $Page->cbm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->total_cbm->Visible) { // total_cbm ?>
        <td data-name="total_cbm"<?= $Page->total_cbm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_total_cbm" class="el_oms_table_total_cbm">
<span<?= $Page->total_cbm->viewAttributes() ?>>
<?= $Page->total_cbm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_remarks" class="el_oms_table_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pl_no->Visible) { // pl_no ?>
        <td data-name="pl_no"<?= $Page->pl_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_pl_no" class="el_oms_table_pl_no">
<span<?= $Page->pl_no->viewAttributes() ?>>
<?php if (!EmptyString($Page->pl_no->getViewValue()) && $Page->pl_no->linkAttributes() != "") { ?>
<a<?= $Page->pl_no->linkAttributes() ?>><?= $Page->pl_no->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->pl_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->invoice_date->Visible) { // invoice_date ?>
        <td data-name="invoice_date"<?= $Page->invoice_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_invoice_date" class="el_oms_table_invoice_date">
<span<?= $Page->invoice_date->viewAttributes() ?>>
<?= $Page->invoice_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sailing_week->Visible) { // sailing_week ?>
        <td data-name="sailing_week"<?= $Page->sailing_week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_sailing_week" class="el_oms_table_sailing_week">
<span<?= $Page->sailing_week->viewAttributes() ?>>
<?= $Page->sailing_week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->seller_remarks->Visible) { // seller_remarks ?>
        <td data-name="seller_remarks"<?= $Page->seller_remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_seller_remarks" class="el_oms_table_seller_remarks">
<span<?= $Page->seller_remarks->viewAttributes() ?>>
<?= $Page->seller_remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_status" class="el_oms_table_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rejection->Visible) { // rejection ?>
        <td data-name="rejection"<?= $Page->rejection->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_rejection" class="el_oms_table_rejection">
<span<?= $Page->rejection->viewAttributes() ?>>
<?= $Page->rejection->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->completed->Visible) { // completed ?>
        <td data-name="completed"<?= $Page->completed->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_completed" class="el_oms_table_completed">
<span<?= $Page->completed->viewAttributes() ?>>
<?= $Page->completed->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->weight_sqm->Visible) { // weight_sqm ?>
        <td data-name="weight_sqm"<?= $Page->weight_sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_oms_table_weight_sqm" class="el_oms_table_weight_sqm">
<span<?= $Page->weight_sqm->viewAttributes() ?>>
<?= $Page->weight_sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_oms_table_id" class="oms_table_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id" class="<?= $Page->buyers_id->footerCellClass() ?>"><span id="elf_oms_table_buyers_id" class="oms_table_buyers_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->reports_to->Visible) { // reports_to ?>
        <td data-name="reports_to" class="<?= $Page->reports_to->footerCellClass() ?>"><span id="elf_oms_table_reports_to" class="oms_table_reports_to">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_order->Visible) { // buyer_order ?>
        <td data-name="buyer_order" class="<?= $Page->buyer_order->footerCellClass() ?>"><span id="elf_oms_table_buyer_order" class="oms_table_buyer_order">
        </span></td>
    <?php } ?>
    <?php if ($Page->item->Visible) { // item ?>
        <td data-name="item" class="<?= $Page->item->footerCellClass() ?>"><span id="elf_oms_table_item" class="oms_table_item">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <td data-name="buyer_ref" class="<?= $Page->buyer_ref->footerCellClass() ?>"><span id="elf_oms_table_buyer_ref" class="oms_table_buyer_ref">
        </span></td>
    <?php } ?>
    <?php if ($Page->order_week->Visible) { // order_week ?>
        <td data-name="order_week" class="<?= $Page->order_week->footerCellClass() ?>"><span id="elf_oms_table_order_week" class="oms_table_order_week">
        </span></td>
    <?php } ?>
    <?php if ($Page->order_date->Visible) { // order_date ?>
        <td data-name="order_date" class="<?= $Page->order_date->footerCellClass() ?>"><span id="elf_oms_table_order_date" class="oms_table_order_date">
        </span></td>
    <?php } ?>
    <?php if ($Page->ex_factory->Visible) { // ex_factory ?>
        <td data-name="ex_factory" class="<?= $Page->ex_factory->footerCellClass() ?>"><span id="elf_oms_table_ex_factory" class="oms_table_ex_factory">
        </span></td>
    <?php } ?>
    <?php if ($Page->ex_factory_p->Visible) { // ex_factory_p ?>
        <td data-name="ex_factory_p" class="<?= $Page->ex_factory_p->footerCellClass() ?>"><span id="elf_oms_table_ex_factory_p" class="oms_table_ex_factory_p">
        </span></td>
    <?php } ?>
    <?php if ($Page->shipping_mode->Visible) { // shipping_mode ?>
        <td data-name="shipping_mode" class="<?= $Page->shipping_mode->footerCellClass() ?>"><span id="elf_oms_table_shipping_mode" class="oms_table_shipping_mode">
        </span></td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po" class="<?= $Page->po->footerCellClass() ?>"><span id="elf_oms_table_po" class="oms_table_po">
        </span></td>
    <?php } ?>
    <?php if ($Page->design->Visible) { // design ?>
        <td data-name="design" class="<?= $Page->design->footerCellClass() ?>"><span id="elf_oms_table_design" class="oms_table_design">
        </span></td>
    <?php } ?>
    <?php if ($Page->size_buyer->Visible) { // size_buyer ?>
        <td data-name="size_buyer" class="<?= $Page->size_buyer->footerCellClass() ?>"><span id="elf_oms_table_size_buyer" class="oms_table_size_buyer">
        </span></td>
    <?php } ?>
    <?php if ($Page->width->Visible) { // width ?>
        <td data-name="width" class="<?= $Page->width->footerCellClass() ?>"><span id="elf_oms_table_width" class="oms_table_width">
        </span></td>
    <?php } ?>
    <?php if ($Page->length->Visible) { // length ?>
        <td data-name="length" class="<?= $Page->length->footerCellClass() ?>"><span id="elf_oms_table_length" class="oms_table_length">
        </span></td>
    <?php } ?>
    <?php if ($Page->qty->Visible) { // qty ?>
        <td data-name="qty" class="<?= $Page->qty->footerCellClass() ?>"><span id="elf_oms_table_qty" class="oms_table_qty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->qty->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->revised_qty->Visible) { // revised_qty ?>
        <td data-name="revised_qty" class="<?= $Page->revised_qty->footerCellClass() ?>"><span id="elf_oms_table_revised_qty" class="oms_table_revised_qty">
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm" class="<?= $Page->sqm->footerCellClass() ?>"><span id="elf_oms_table_sqm" class="oms_table_sqm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->sqm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->d_qty->Visible) { // d_qty ?>
        <td data-name="d_qty" class="<?= $Page->d_qty->footerCellClass() ?>"><span id="elf_oms_table_d_qty" class="oms_table_d_qty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->d_qty->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->pending->Visible) { // pending ?>
        <td data-name="pending" class="<?= $Page->pending->footerCellClass() ?>"><span id="elf_oms_table_pending" class="oms_table_pending">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?php if (!EmptyString($Page->pending->ViewValue) && $Page->pending->linkAttributes() != "") { ?>
        <a<?= $Page->pending->linkAttributes() ?>><?= $Page->pending->ViewValue ?></a>
        <?php } else { ?>
        <?= $Page->pending->ViewValue ?>
        <?php } ?>
        </span>
        </span></td>
    <?php } ?>
    <?php if ($Page->pending_sqm->Visible) { // pending_sqm ?>
        <td data-name="pending_sqm" class="<?= $Page->pending_sqm->footerCellClass() ?>"><span id="elf_oms_table_pending_sqm" class="oms_table_pending_sqm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->pending_sqm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->offloom->Visible) { // offloom ?>
        <td data-name="offloom" class="<?= $Page->offloom->footerCellClass() ?>"><span id="elf_oms_table_offloom" class="oms_table_offloom">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->offloom->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->pending_offloom->Visible) { // pending_offloom ?>
        <td data-name="pending_offloom" class="<?= $Page->pending_offloom->footerCellClass() ?>"><span id="elf_oms_table_pending_offloom" class="oms_table_pending_offloom">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->pending_offloom->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
        <td data-name="pending_offloom_sqm" class="<?= $Page->pending_offloom_sqm->footerCellClass() ?>"><span id="elf_oms_table_pending_offloom_sqm" class="oms_table_pending_offloom_sqm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->pending_offloom_sqm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->cbm->Visible) { // cbm ?>
        <td data-name="cbm" class="<?= $Page->cbm->footerCellClass() ?>"><span id="elf_oms_table_cbm" class="oms_table_cbm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->cbm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->total_cbm->Visible) { // total_cbm ?>
        <td data-name="total_cbm" class="<?= $Page->total_cbm->footerCellClass() ?>"><span id="elf_oms_table_total_cbm" class="oms_table_total_cbm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->total_cbm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks" class="<?= $Page->remarks->footerCellClass() ?>"><span id="elf_oms_table_remarks" class="oms_table_remarks">
        </span></td>
    <?php } ?>
    <?php if ($Page->pl_no->Visible) { // pl_no ?>
        <td data-name="pl_no" class="<?= $Page->pl_no->footerCellClass() ?>"><span id="elf_oms_table_pl_no" class="oms_table_pl_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->invoice_date->Visible) { // invoice_date ?>
        <td data-name="invoice_date" class="<?= $Page->invoice_date->footerCellClass() ?>"><span id="elf_oms_table_invoice_date" class="oms_table_invoice_date">
        </span></td>
    <?php } ?>
    <?php if ($Page->sailing_week->Visible) { // sailing_week ?>
        <td data-name="sailing_week" class="<?= $Page->sailing_week->footerCellClass() ?>"><span id="elf_oms_table_sailing_week" class="oms_table_sailing_week">
        </span></td>
    <?php } ?>
    <?php if ($Page->seller_remarks->Visible) { // seller_remarks ?>
        <td data-name="seller_remarks" class="<?= $Page->seller_remarks->footerCellClass() ?>"><span id="elf_oms_table_seller_remarks" class="oms_table_seller_remarks">
        </span></td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status" class="<?= $Page->status->footerCellClass() ?>"><span id="elf_oms_table_status" class="oms_table_status">
        </span></td>
    <?php } ?>
    <?php if ($Page->rejection->Visible) { // rejection ?>
        <td data-name="rejection" class="<?= $Page->rejection->footerCellClass() ?>"><span id="elf_oms_table_rejection" class="oms_table_rejection">
        </span></td>
    <?php } ?>
    <?php if ($Page->completed->Visible) { // completed ?>
        <td data-name="completed" class="<?= $Page->completed->footerCellClass() ?>"><span id="elf_oms_table_completed" class="oms_table_completed">
        </span></td>
    <?php } ?>
    <?php if ($Page->weight_sqm->Visible) { // weight_sqm ?>
        <td data-name="weight_sqm" class="<?= $Page->weight_sqm->footerCellClass() ?>"><span id="elf_oms_table_weight_sqm" class="oms_table_weight_sqm">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("oms_table");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    function pldetails(ID) 
    	{
    		const pld = ID.split(":")
    		$.getJSON(window.location.origin +"/apcajax?ID="+pld[0]+"&getpldetails="+pld[1],function(data){
    		Obj='<div class="modal" id="myModal"><div class="modal-dialog modal-dialog-scrollable modal-lg"><div class="modal-content"><!-- Modal Header --><div class="modal-header"><h1 class="modal-title">Packing List Details</h1><button type="button" class="close" data-bs-dismiss="modal">×</button></div><!-- Modal body --><div class="modal-body"><p>'+data+'</p></div><!-- Modal footer --><div class="modal-footer"><button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button></div></div></div></div></div>';
     		   		$("body").prepend(Obj);
     		   		$("#myModal").modal("show")
    	});
    	}
});
</script>
<?php } ?>
