<?php

namespace PHPMaker2024\fibre;

// Page object
$OmsTableEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="foms_tableedit" id="foms_tableedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { oms_table: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var foms_tableedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("foms_tableedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["buyers_id", [fields.buyers_id.visible && fields.buyers_id.required ? ew.Validators.required(fields.buyers_id.caption) : null], fields.buyers_id.isInvalid],
            ["reports_to", [fields.reports_to.visible && fields.reports_to.required ? ew.Validators.required(fields.reports_to.caption) : null], fields.reports_to.isInvalid],
            ["buyer_order", [fields.buyer_order.visible && fields.buyer_order.required ? ew.Validators.required(fields.buyer_order.caption) : null], fields.buyer_order.isInvalid],
            ["item", [fields.item.visible && fields.item.required ? ew.Validators.required(fields.item.caption) : null], fields.item.isInvalid],
            ["buyer_ref", [fields.buyer_ref.visible && fields.buyer_ref.required ? ew.Validators.required(fields.buyer_ref.caption) : null], fields.buyer_ref.isInvalid],
            ["order_week", [fields.order_week.visible && fields.order_week.required ? ew.Validators.required(fields.order_week.caption) : null], fields.order_week.isInvalid],
            ["order_date", [fields.order_date.visible && fields.order_date.required ? ew.Validators.required(fields.order_date.caption) : null], fields.order_date.isInvalid],
            ["ex_factory", [fields.ex_factory.visible && fields.ex_factory.required ? ew.Validators.required(fields.ex_factory.caption) : null], fields.ex_factory.isInvalid],
            ["ex_factory_p", [fields.ex_factory_p.visible && fields.ex_factory_p.required ? ew.Validators.required(fields.ex_factory_p.caption) : null], fields.ex_factory_p.isInvalid],
            ["shipping_mode", [fields.shipping_mode.visible && fields.shipping_mode.required ? ew.Validators.required(fields.shipping_mode.caption) : null], fields.shipping_mode.isInvalid],
            ["po", [fields.po.visible && fields.po.required ? ew.Validators.required(fields.po.caption) : null], fields.po.isInvalid],
            ["design", [fields.design.visible && fields.design.required ? ew.Validators.required(fields.design.caption) : null], fields.design.isInvalid],
            ["size_buyer", [fields.size_buyer.visible && fields.size_buyer.required ? ew.Validators.required(fields.size_buyer.caption) : null], fields.size_buyer.isInvalid],
            ["width", [fields.width.visible && fields.width.required ? ew.Validators.required(fields.width.caption) : null], fields.width.isInvalid],
            ["length", [fields.length.visible && fields.length.required ? ew.Validators.required(fields.length.caption) : null], fields.length.isInvalid],
            ["qty", [fields.qty.visible && fields.qty.required ? ew.Validators.required(fields.qty.caption) : null], fields.qty.isInvalid],
            ["revised_qty", [fields.revised_qty.visible && fields.revised_qty.required ? ew.Validators.required(fields.revised_qty.caption) : null], fields.revised_qty.isInvalid],
            ["sqm", [fields.sqm.visible && fields.sqm.required ? ew.Validators.required(fields.sqm.caption) : null], fields.sqm.isInvalid],
            ["d_qty", [fields.d_qty.visible && fields.d_qty.required ? ew.Validators.required(fields.d_qty.caption) : null], fields.d_qty.isInvalid],
            ["pending", [fields.pending.visible && fields.pending.required ? ew.Validators.required(fields.pending.caption) : null], fields.pending.isInvalid],
            ["pending_sqm", [fields.pending_sqm.visible && fields.pending_sqm.required ? ew.Validators.required(fields.pending_sqm.caption) : null], fields.pending_sqm.isInvalid],
            ["offloom", [fields.offloom.visible && fields.offloom.required ? ew.Validators.required(fields.offloom.caption) : null], fields.offloom.isInvalid],
            ["pending_offloom", [fields.pending_offloom.visible && fields.pending_offloom.required ? ew.Validators.required(fields.pending_offloom.caption) : null], fields.pending_offloom.isInvalid],
            ["pending_offloom_sqm", [fields.pending_offloom_sqm.visible && fields.pending_offloom_sqm.required ? ew.Validators.required(fields.pending_offloom_sqm.caption) : null], fields.pending_offloom_sqm.isInvalid],
            ["cbm", [fields.cbm.visible && fields.cbm.required ? ew.Validators.required(fields.cbm.caption) : null], fields.cbm.isInvalid],
            ["total_cbm", [fields.total_cbm.visible && fields.total_cbm.required ? ew.Validators.required(fields.total_cbm.caption) : null], fields.total_cbm.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["pl_no", [fields.pl_no.visible && fields.pl_no.required ? ew.Validators.required(fields.pl_no.caption) : null], fields.pl_no.isInvalid],
            ["invoice_date", [fields.invoice_date.visible && fields.invoice_date.required ? ew.Validators.required(fields.invoice_date.caption) : null], fields.invoice_date.isInvalid],
            ["sailing_week", [fields.sailing_week.visible && fields.sailing_week.required ? ew.Validators.required(fields.sailing_week.caption) : null], fields.sailing_week.isInvalid],
            ["seller_remarks", [fields.seller_remarks.visible && fields.seller_remarks.required ? ew.Validators.required(fields.seller_remarks.caption) : null], fields.seller_remarks.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["rejection", [fields.rejection.visible && fields.rejection.required ? ew.Validators.required(fields.rejection.caption) : null], fields.rejection.isInvalid],
            ["weight_sqm", [fields.weight_sqm.visible && fields.weight_sqm.required ? ew.Validators.required(fields.weight_sqm.caption) : null, ew.Validators.float], fields.weight_sqm.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="oms_table">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_oms_table_id" for="x_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_oms_table_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id"<?= $Page->buyers_id->rowAttributes() ?>>
        <label id="elh_oms_table_buyers_id" for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyers_id->caption() ?><?= $Page->buyers_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyers_id->cellAttributes() ?>>
<span id="el_oms_table_buyers_id">
<span<?= $Page->buyers_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->buyers_id->getDisplayValue($Page->buyers_id->EditValue) ?></span></span>
<input type="hidden" data-table="oms_table" data-field="x_buyers_id" data-hidden="1" name="x_buyers_id" id="x_buyers_id" value="<?= HtmlEncode($Page->buyers_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
    <div id="r_reports_to"<?= $Page->reports_to->rowAttributes() ?>>
        <label id="elh_oms_table_reports_to" for="x_reports_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->reports_to->caption() ?><?= $Page->reports_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->reports_to->cellAttributes() ?>>
<span id="el_oms_table_reports_to">
<span<?= $Page->reports_to->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->reports_to->getDisplayValue($Page->reports_to->EditValue) ?></span></span>
<input type="hidden" data-table="oms_table" data-field="x_reports_to" data-hidden="1" name="x_reports_to" id="x_reports_to" value="<?= HtmlEncode($Page->reports_to->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_order->Visible) { // buyer_order ?>
    <div id="r_buyer_order"<?= $Page->buyer_order->rowAttributes() ?>>
        <label id="elh_oms_table_buyer_order" for="x_buyer_order" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_order->caption() ?><?= $Page->buyer_order->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_order->cellAttributes() ?>>
<span id="el_oms_table_buyer_order">
<span<?= $Page->buyer_order->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->buyer_order->getDisplayValue($Page->buyer_order->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_buyer_order" data-hidden="1" name="x_buyer_order" id="x_buyer_order" value="<?= HtmlEncode($Page->buyer_order->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->item->Visible) { // item ?>
    <div id="r_item"<?= $Page->item->rowAttributes() ?>>
        <label id="elh_oms_table_item" for="x_item" class="<?= $Page->LeftColumnClass ?>"><?= $Page->item->caption() ?><?= $Page->item->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->item->cellAttributes() ?>>
<span id="el_oms_table_item">
<span<?= $Page->item->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->item->getDisplayValue($Page->item->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_item" data-hidden="1" name="x_item" id="x_item" value="<?= HtmlEncode($Page->item->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
    <div id="r_buyer_ref"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label id="elh_oms_table_buyer_ref" for="x_buyer_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_ref->caption() ?><?= $Page->buyer_ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_ref->cellAttributes() ?>>
<span id="el_oms_table_buyer_ref">
<span<?= $Page->buyer_ref->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->buyer_ref->getDisplayValue($Page->buyer_ref->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_buyer_ref" data-hidden="1" name="x_buyer_ref" id="x_buyer_ref" value="<?= HtmlEncode($Page->buyer_ref->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->order_week->Visible) { // order_week ?>
    <div id="r_order_week"<?= $Page->order_week->rowAttributes() ?>>
        <label id="elh_oms_table_order_week" for="x_order_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->order_week->caption() ?><?= $Page->order_week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->order_week->cellAttributes() ?>>
<span id="el_oms_table_order_week">
<span<?= $Page->order_week->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->order_week->getDisplayValue($Page->order_week->EditValue) ?></span></span>
<input type="hidden" data-table="oms_table" data-field="x_order_week" data-hidden="1" name="x_order_week" id="x_order_week" value="<?= HtmlEncode($Page->order_week->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->order_date->Visible) { // order_date ?>
    <div id="r_order_date"<?= $Page->order_date->rowAttributes() ?>>
        <label id="elh_oms_table_order_date" for="x_order_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->order_date->caption() ?><?= $Page->order_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->order_date->cellAttributes() ?>>
<span id="el_oms_table_order_date">
<span<?= $Page->order_date->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->order_date->getDisplayValue($Page->order_date->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_order_date" data-hidden="1" name="x_order_date" id="x_order_date" value="<?= HtmlEncode($Page->order_date->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ex_factory->Visible) { // ex_factory ?>
    <div id="r_ex_factory"<?= $Page->ex_factory->rowAttributes() ?>>
        <label id="elh_oms_table_ex_factory" for="x_ex_factory" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ex_factory->caption() ?><?= $Page->ex_factory->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ex_factory->cellAttributes() ?>>
<span id="el_oms_table_ex_factory">
<span<?= $Page->ex_factory->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ex_factory->getDisplayValue($Page->ex_factory->EditValue) ?></span></span>
<input type="hidden" data-table="oms_table" data-field="x_ex_factory" data-hidden="1" name="x_ex_factory" id="x_ex_factory" value="<?= HtmlEncode($Page->ex_factory->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ex_factory_p->Visible) { // ex_factory_p ?>
    <div id="r_ex_factory_p"<?= $Page->ex_factory_p->rowAttributes() ?>>
        <label id="elh_oms_table_ex_factory_p" for="x_ex_factory_p" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ex_factory_p->caption() ?><?= $Page->ex_factory_p->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ex_factory_p->cellAttributes() ?>>
<span id="el_oms_table_ex_factory_p">
<span<?= $Page->ex_factory_p->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ex_factory_p->getDisplayValue($Page->ex_factory_p->EditValue) ?></span></span>
<input type="hidden" data-table="oms_table" data-field="x_ex_factory_p" data-hidden="1" name="x_ex_factory_p" id="x_ex_factory_p" value="<?= HtmlEncode($Page->ex_factory_p->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shipping_mode->Visible) { // shipping_mode ?>
    <div id="r_shipping_mode"<?= $Page->shipping_mode->rowAttributes() ?>>
        <label id="elh_oms_table_shipping_mode" for="x_shipping_mode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shipping_mode->caption() ?><?= $Page->shipping_mode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shipping_mode->cellAttributes() ?>>
<span id="el_oms_table_shipping_mode">
<span<?= $Page->shipping_mode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->shipping_mode->getDisplayValue($Page->shipping_mode->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_shipping_mode" data-hidden="1" name="x_shipping_mode" id="x_shipping_mode" value="<?= HtmlEncode($Page->shipping_mode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po"<?= $Page->po->rowAttributes() ?>>
        <label id="elh_oms_table_po" for="x_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po->caption() ?><?= $Page->po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po->cellAttributes() ?>>
<span id="el_oms_table_po">
<span<?= $Page->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->po->getDisplayValue($Page->po->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_po" data-hidden="1" name="x_po" id="x_po" value="<?= HtmlEncode($Page->po->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
    <div id="r_design"<?= $Page->design->rowAttributes() ?>>
        <label id="elh_oms_table_design" for="x_design" class="<?= $Page->LeftColumnClass ?>"><?= $Page->design->caption() ?><?= $Page->design->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->design->cellAttributes() ?>>
<span id="el_oms_table_design">
<span<?= $Page->design->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->design->getDisplayValue($Page->design->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_design" data-hidden="1" name="x_design" id="x_design" value="<?= HtmlEncode($Page->design->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size_buyer->Visible) { // size_buyer ?>
    <div id="r_size_buyer"<?= $Page->size_buyer->rowAttributes() ?>>
        <label id="elh_oms_table_size_buyer" for="x_size_buyer" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size_buyer->caption() ?><?= $Page->size_buyer->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size_buyer->cellAttributes() ?>>
<span id="el_oms_table_size_buyer">
<span<?= $Page->size_buyer->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->size_buyer->getDisplayValue($Page->size_buyer->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_size_buyer" data-hidden="1" name="x_size_buyer" id="x_size_buyer" value="<?= HtmlEncode($Page->size_buyer->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->width->Visible) { // width ?>
    <div id="r_width"<?= $Page->width->rowAttributes() ?>>
        <label id="elh_oms_table_width" for="x_width" class="<?= $Page->LeftColumnClass ?>"><?= $Page->width->caption() ?><?= $Page->width->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->width->cellAttributes() ?>>
<span id="el_oms_table_width">
<span<?= $Page->width->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->width->getDisplayValue($Page->width->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_width" data-hidden="1" name="x_width" id="x_width" value="<?= HtmlEncode($Page->width->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->length->Visible) { // length ?>
    <div id="r_length"<?= $Page->length->rowAttributes() ?>>
        <label id="elh_oms_table_length" for="x_length" class="<?= $Page->LeftColumnClass ?>"><?= $Page->length->caption() ?><?= $Page->length->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->length->cellAttributes() ?>>
<span id="el_oms_table_length">
<span<?= $Page->length->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->length->getDisplayValue($Page->length->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_length" data-hidden="1" name="x_length" id="x_length" value="<?= HtmlEncode($Page->length->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <div id="r_qty"<?= $Page->qty->rowAttributes() ?>>
        <label id="elh_oms_table_qty" for="x_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->qty->caption() ?><?= $Page->qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->qty->cellAttributes() ?>>
<span id="el_oms_table_qty">
<span<?= $Page->qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->qty->getDisplayValue($Page->qty->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_qty" data-hidden="1" name="x_qty" id="x_qty" value="<?= HtmlEncode($Page->qty->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->revised_qty->Visible) { // revised_qty ?>
    <div id="r_revised_qty"<?= $Page->revised_qty->rowAttributes() ?>>
        <label id="elh_oms_table_revised_qty" for="x_revised_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->revised_qty->caption() ?><?= $Page->revised_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->revised_qty->cellAttributes() ?>>
<span id="el_oms_table_revised_qty">
<span<?= $Page->revised_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->revised_qty->getDisplayValue($Page->revised_qty->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_revised_qty" data-hidden="1" name="x_revised_qty" id="x_revised_qty" value="<?= HtmlEncode($Page->revised_qty->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm"<?= $Page->sqm->rowAttributes() ?>>
        <label id="elh_oms_table_sqm" for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm->caption() ?><?= $Page->sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm->cellAttributes() ?>>
<span id="el_oms_table_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->sqm->getDisplayValue($Page->sqm->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_sqm" data-hidden="1" name="x_sqm" id="x_sqm" value="<?= HtmlEncode($Page->sqm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->d_qty->Visible) { // d_qty ?>
    <div id="r_d_qty"<?= $Page->d_qty->rowAttributes() ?>>
        <label id="elh_oms_table_d_qty" for="x_d_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->d_qty->caption() ?><?= $Page->d_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->d_qty->cellAttributes() ?>>
<span id="el_oms_table_d_qty">
<span<?= $Page->d_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->d_qty->getDisplayValue($Page->d_qty->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_d_qty" data-hidden="1" name="x_d_qty" id="x_d_qty" value="<?= HtmlEncode($Page->d_qty->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pending->Visible) { // pending ?>
    <div id="r_pending"<?= $Page->pending->rowAttributes() ?>>
        <label id="elh_oms_table_pending" for="x_pending" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pending->caption() ?><?= $Page->pending->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pending->cellAttributes() ?>>
<span id="el_oms_table_pending">
<span<?= $Page->pending->viewAttributes() ?>>
<?php if (!EmptyString($Page->pending->EditValue) && $Page->pending->linkAttributes() != "") { ?>
<a<?= $Page->pending->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->pending->getDisplayValue($Page->pending->EditValue))) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->pending->getDisplayValue($Page->pending->EditValue))) ?>">
<?php } ?>
</span>
<input type="hidden" data-table="oms_table" data-field="x_pending" data-hidden="1" name="x_pending" id="x_pending" value="<?= HtmlEncode($Page->pending->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pending_sqm->Visible) { // pending_sqm ?>
    <div id="r_pending_sqm"<?= $Page->pending_sqm->rowAttributes() ?>>
        <label id="elh_oms_table_pending_sqm" for="x_pending_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pending_sqm->caption() ?><?= $Page->pending_sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pending_sqm->cellAttributes() ?>>
<span id="el_oms_table_pending_sqm">
<span<?= $Page->pending_sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->pending_sqm->getDisplayValue($Page->pending_sqm->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_pending_sqm" data-hidden="1" name="x_pending_sqm" id="x_pending_sqm" value="<?= HtmlEncode($Page->pending_sqm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->offloom->Visible) { // offloom ?>
    <div id="r_offloom"<?= $Page->offloom->rowAttributes() ?>>
        <label id="elh_oms_table_offloom" for="x_offloom" class="<?= $Page->LeftColumnClass ?>"><?= $Page->offloom->caption() ?><?= $Page->offloom->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->offloom->cellAttributes() ?>>
<span id="el_oms_table_offloom">
<span<?= $Page->offloom->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->offloom->getDisplayValue($Page->offloom->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_offloom" data-hidden="1" name="x_offloom" id="x_offloom" value="<?= HtmlEncode($Page->offloom->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pending_offloom->Visible) { // pending_offloom ?>
    <div id="r_pending_offloom"<?= $Page->pending_offloom->rowAttributes() ?>>
        <label id="elh_oms_table_pending_offloom" for="x_pending_offloom" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pending_offloom->caption() ?><?= $Page->pending_offloom->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pending_offloom->cellAttributes() ?>>
<span id="el_oms_table_pending_offloom">
<span<?= $Page->pending_offloom->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->pending_offloom->getDisplayValue($Page->pending_offloom->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_pending_offloom" data-hidden="1" name="x_pending_offloom" id="x_pending_offloom" value="<?= HtmlEncode($Page->pending_offloom->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
    <div id="r_pending_offloom_sqm"<?= $Page->pending_offloom_sqm->rowAttributes() ?>>
        <label id="elh_oms_table_pending_offloom_sqm" for="x_pending_offloom_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pending_offloom_sqm->caption() ?><?= $Page->pending_offloom_sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pending_offloom_sqm->cellAttributes() ?>>
<span id="el_oms_table_pending_offloom_sqm">
<span<?= $Page->pending_offloom_sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->pending_offloom_sqm->getDisplayValue($Page->pending_offloom_sqm->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_pending_offloom_sqm" data-hidden="1" name="x_pending_offloom_sqm" id="x_pending_offloom_sqm" value="<?= HtmlEncode($Page->pending_offloom_sqm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
    <div id="r_cbm"<?= $Page->cbm->rowAttributes() ?>>
        <label id="elh_oms_table_cbm" for="x_cbm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cbm->caption() ?><?= $Page->cbm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cbm->cellAttributes() ?>>
<span id="el_oms_table_cbm">
<span<?= $Page->cbm->viewAttributes() ?>>
<?= $Page->cbm->EditValue ?></span>
<input type="hidden" data-table="oms_table" data-field="x_cbm" data-hidden="1" name="x_cbm" id="x_cbm" value="<?= HtmlEncode($Page->cbm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->total_cbm->Visible) { // total_cbm ?>
    <div id="r_total_cbm"<?= $Page->total_cbm->rowAttributes() ?>>
        <label id="elh_oms_table_total_cbm" for="x_total_cbm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->total_cbm->caption() ?><?= $Page->total_cbm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->total_cbm->cellAttributes() ?>>
<span id="el_oms_table_total_cbm">
<span<?= $Page->total_cbm->viewAttributes() ?>>
<?= $Page->total_cbm->EditValue ?></span>
<input type="hidden" data-table="oms_table" data-field="x_total_cbm" data-hidden="1" name="x_total_cbm" id="x_total_cbm" value="<?= HtmlEncode($Page->total_cbm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_oms_table_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_oms_table_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->remarks->getDisplayValue($Page->remarks->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_remarks" data-hidden="1" name="x_remarks" id="x_remarks" value="<?= HtmlEncode($Page->remarks->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
    <div id="r_pl_no"<?= $Page->pl_no->rowAttributes() ?>>
        <label id="elh_oms_table_pl_no" for="x_pl_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pl_no->caption() ?><?= $Page->pl_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pl_no->cellAttributes() ?>>
<span id="el_oms_table_pl_no">
<span<?= $Page->pl_no->viewAttributes() ?>>
<?php if (!EmptyString($Page->pl_no->EditValue) && $Page->pl_no->linkAttributes() != "") { ?>
<a<?= $Page->pl_no->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->pl_no->getDisplayValue($Page->pl_no->EditValue))) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->pl_no->getDisplayValue($Page->pl_no->EditValue))) ?>">
<?php } ?>
</span>
<input type="hidden" data-table="oms_table" data-field="x_pl_no" data-hidden="1" name="x_pl_no" id="x_pl_no" value="<?= HtmlEncode($Page->pl_no->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
    <div id="r_invoice_date"<?= $Page->invoice_date->rowAttributes() ?>>
        <label id="elh_oms_table_invoice_date" for="x_invoice_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->invoice_date->caption() ?><?= $Page->invoice_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->invoice_date->cellAttributes() ?>>
<span id="el_oms_table_invoice_date">
<span<?= $Page->invoice_date->viewAttributes() ?>>
<?= $Page->invoice_date->EditValue ?></span>
<input type="hidden" data-table="oms_table" data-field="x_invoice_date" data-hidden="1" name="x_invoice_date" id="x_invoice_date" value="<?= HtmlEncode($Page->invoice_date->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sailing_week->Visible) { // sailing_week ?>
    <div id="r_sailing_week"<?= $Page->sailing_week->rowAttributes() ?>>
        <label id="elh_oms_table_sailing_week" for="x_sailing_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sailing_week->caption() ?><?= $Page->sailing_week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sailing_week->cellAttributes() ?>>
<span id="el_oms_table_sailing_week">
<span<?= $Page->sailing_week->viewAttributes() ?>>
<?= $Page->sailing_week->EditValue ?></span>
<input type="hidden" data-table="oms_table" data-field="x_sailing_week" data-hidden="1" name="x_sailing_week" id="x_sailing_week" value="<?= HtmlEncode($Page->sailing_week->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->seller_remarks->Visible) { // seller_remarks ?>
    <div id="r_seller_remarks"<?= $Page->seller_remarks->rowAttributes() ?>>
        <label id="elh_oms_table_seller_remarks" for="x_seller_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->seller_remarks->caption() ?><?= $Page->seller_remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->seller_remarks->cellAttributes() ?>>
<span id="el_oms_table_seller_remarks">
<textarea data-table="oms_table" data-field="x_seller_remarks" name="x_seller_remarks" id="x_seller_remarks" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->seller_remarks->getPlaceHolder()) ?>"<?= $Page->seller_remarks->editAttributes() ?> aria-describedby="x_seller_remarks_help"><?= $Page->seller_remarks->EditValue ?></textarea>
<?= $Page->seller_remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->seller_remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_oms_table_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_oms_table_status">
<span<?= $Page->status->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->status->getDisplayValue($Page->status->EditValue) ?></span></span>
<input type="hidden" data-table="oms_table" data-field="x_status" data-hidden="1" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rejection->Visible) { // rejection ?>
    <div id="r_rejection"<?= $Page->rejection->rowAttributes() ?>>
        <label id="elh_oms_table_rejection" for="x_rejection" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rejection->caption() ?><?= $Page->rejection->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rejection->cellAttributes() ?>>
<span id="el_oms_table_rejection">
<span<?= $Page->rejection->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->rejection->getDisplayValue($Page->rejection->EditValue))) ?>"></span>
<input type="hidden" data-table="oms_table" data-field="x_rejection" data-hidden="1" name="x_rejection" id="x_rejection" value="<?= HtmlEncode($Page->rejection->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->weight_sqm->Visible) { // weight_sqm ?>
    <div id="r_weight_sqm"<?= $Page->weight_sqm->rowAttributes() ?>>
        <label id="elh_oms_table_weight_sqm" for="x_weight_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->weight_sqm->caption() ?><?= $Page->weight_sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->weight_sqm->cellAttributes() ?>>
<span id="el_oms_table_weight_sqm">
<input type="<?= $Page->weight_sqm->getInputTextType() ?>" name="x_weight_sqm" id="x_weight_sqm" data-table="oms_table" data-field="x_weight_sqm" value="<?= $Page->weight_sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->weight_sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->weight_sqm->formatPattern()) ?>"<?= $Page->weight_sqm->editAttributes() ?> aria-describedby="x_weight_sqm_help">
<?= $Page->weight_sqm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->weight_sqm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="foms_tableedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="foms_tableedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("oms_table");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
