<?php

namespace PHPMaker2024\fibre;

// Page object
$MultiplePriceSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { multiple_price: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmultiple_pricesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmultiple_pricesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["buyer", [], fields.buyer.isInvalid],
            ["buyer_1", [], fields.buyer_1.isInvalid],
            ["buyer_id", [], fields.buyer_id.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["code", [], fields.code.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["level", [], fields.level.isInvalid],
            ["min_qty", [ew.Validators.integer], fields.min_qty.isInvalid],
            ["max_qty", [ew.Validators.integer], fields.max_qty.isInvalid],
            ["increment", [ew.Validators.integer], fields.increment.isInvalid],
            ["price_min_qty", [ew.Validators.float], fields.price_min_qty.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
            "buyer_1": <?= $Page->buyer_1->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "code": <?= $Page->code->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "level": <?= $Page->level->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmultiple_pricesearch" id="fmultiple_pricesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="multiple_price">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="multiple_price" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricesearch_x_company_id"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricesearch", function() {
    var options = { name: "x_company_id", selectId: "fmultiple_pricesearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricesearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fmultiple_pricesearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fmultiple_pricesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
    <div id="r_buyer" class="row"<?= $Page->buyer->rowAttributes() ?>>
        <label for="x_buyer" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_buyer"><?= $Page->buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer" id="z_buyer" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_buyer" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer"
        name="x_buyer"
        class="form-select ew-select<?= $Page->buyer->isInvalidClass() ?>"
        <?php if (!$Page->buyer->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricesearch_x_buyer"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_buyer"
        data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>"
        <?= $Page->buyer->editAttributes() ?>>
        <?= $Page->buyer->selectOptionListHtml("x_buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer->getErrorMessage(false) ?></div>
<?php if (!$Page->buyer->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricesearch", function() {
    var options = { name: "x_buyer", selectId: "fmultiple_pricesearch_x_buyer" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricesearch.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x_buyer", form: "fmultiple_pricesearch" };
    } else {
        options.ajax = { id: "x_buyer", form: "fmultiple_pricesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.buyer.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_1->Visible) { // buyer_1 ?>
    <div id="r_buyer_1" class="row"<?= $Page->buyer_1->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_buyer_1"><?= $Page->buyer_1->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_1" id="z_buyer_1" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_1->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_buyer_1" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer_1[]"
        name="x_buyer_1[]"
        class="form-control ew-select<?= $Page->buyer_1->isInvalidClass() ?>"
        data-select2-id="fmultiple_pricesearch_x_buyer_1[]"
        data-table="multiple_price"
        data-field="x_buyer_1"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer_1->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->buyer_1->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_1->getPlaceHolder()) ?>"
        <?= $Page->buyer_1->editAttributes() ?>>
        <?= $Page->buyer_1->selectOptionListHtml("x_buyer_1[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_1->getErrorMessage(false) ?></div>
<?= $Page->buyer_1->Lookup->getParamTag($Page, "p_x_buyer_1") ?>
<script>
loadjs.ready("fmultiple_pricesearch", function() {
    var options = { name: "x_buyer_1[]", selectId: "fmultiple_pricesearch_x_buyer_1[]" };
    options.multiple = true;
    if (fmultiple_pricesearch.lists.buyer_1?.lookupOptions.length) {
        options.data = { id: "x_buyer_1[]", form: "fmultiple_pricesearch" };
    } else {
        options.ajax = { id: "x_buyer_1[]", form: "fmultiple_pricesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.multiple_price.fields.buyer_1.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id" class="row"<?= $Page->buyer_id->rowAttributes() ?>>
        <label for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_buyer_id"><?= $Page->buyer_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_buyer_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_id->getInputTextType() ?>" name="x_buyer_id" id="x_buyer_id" data-table="multiple_price" data-field="x_buyer_id" value="<?= $Page->buyer_id->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_id->formatPattern()) ?>"<?= $Page->buyer_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricesearch_x_grp"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricesearch", function() {
    var options = { name: "x_grp", selectId: "fmultiple_pricesearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricesearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fmultiple_pricesearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fmultiple_pricesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricesearch_x_product"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricesearch", function() {
    var options = { name: "x_product", selectId: "fmultiple_pricesearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricesearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fmultiple_pricesearch" };
    } else {
        options.ajax = { id: "x_product", form: "fmultiple_pricesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_code"><?= $Page->code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_code" id="z_code" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_code" class="ew-search-field ew-search-field-single">
<template id="tp_x_code">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="multiple_price" data-field="x_code" name="x_code" id="x_code"<?= $Page->code->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_code" class="ew-item-list"></div>
<selection-list hidden
    id="x_code"
    name="x_code"
    value="<?= HtmlEncode($Page->code->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_code"
    data-target="dsl_x_code"
    data-repeatcolumn="2"
    class="form-control<?= $Page->code->isInvalidClass() ?>"
    data-table="multiple_price"
    data-field="x_code"
    data-value-separator="<?= $Page->code->displayValueSeparatorAttribute() ?>"
    <?= $Page->code->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
<?= $Page->code->Lookup->getParamTag($Page, "p_x_code") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricesearch_x_packing_type"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricesearch", function() {
    var options = { name: "x_packing_type", selectId: "fmultiple_pricesearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricesearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fmultiple_pricesearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fmultiple_pricesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->level->Visible) { // level ?>
    <div id="r_level" class="row"<?= $Page->level->rowAttributes() ?>>
        <label for="x_level" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_level"><?= $Page->level->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_level" id="z_level" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->level->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_level" class="ew-search-field ew-search-field-single">
    <select
        id="x_level"
        name="x_level"
        class="form-select ew-select<?= $Page->level->isInvalidClass() ?>"
        <?php if (!$Page->level->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricesearch_x_level"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_level"
        data-value-separator="<?= $Page->level->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->level->getPlaceHolder()) ?>"
        <?= $Page->level->editAttributes() ?>>
        <?= $Page->level->selectOptionListHtml("x_level") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->level->getErrorMessage(false) ?></div>
<?php if (!$Page->level->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricesearch", function() {
    var options = { name: "x_level", selectId: "fmultiple_pricesearch_x_level" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricesearch.lists.level?.lookupOptions.length) {
        options.data = { id: "x_level", form: "fmultiple_pricesearch" };
    } else {
        options.ajax = { id: "x_level", form: "fmultiple_pricesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.level.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->min_qty->Visible) { // min_qty ?>
    <div id="r_min_qty" class="row"<?= $Page->min_qty->rowAttributes() ?>>
        <label for="x_min_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_min_qty"><?= $Page->min_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_min_qty" id="z_min_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->min_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_min_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->min_qty->getInputTextType() ?>" name="x_min_qty" id="x_min_qty" data-table="multiple_price" data-field="x_min_qty" value="<?= $Page->min_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->min_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->min_qty->formatPattern()) ?>"<?= $Page->min_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->min_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->max_qty->Visible) { // max_qty ?>
    <div id="r_max_qty" class="row"<?= $Page->max_qty->rowAttributes() ?>>
        <label for="x_max_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_max_qty"><?= $Page->max_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_max_qty" id="z_max_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->max_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_max_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->max_qty->getInputTextType() ?>" name="x_max_qty" id="x_max_qty" data-table="multiple_price" data-field="x_max_qty" value="<?= $Page->max_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->max_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->max_qty->formatPattern()) ?>"<?= $Page->max_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->max_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->increment->Visible) { // increment ?>
    <div id="r_increment" class="row"<?= $Page->increment->rowAttributes() ?>>
        <label for="x_increment" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_increment"><?= $Page->increment->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_increment" id="z_increment" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->increment->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_increment" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->increment->getInputTextType() ?>" name="x_increment" id="x_increment" data-table="multiple_price" data-field="x_increment" value="<?= $Page->increment->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->increment->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->increment->formatPattern()) ?>"<?= $Page->increment->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->increment->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price_min_qty->Visible) { // price_min_qty ?>
    <div id="r_price_min_qty" class="row"<?= $Page->price_min_qty->rowAttributes() ?>>
        <label for="x_price_min_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_price_min_qty"><?= $Page->price_min_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price_min_qty" id="z_price_min_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price_min_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_price_min_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price_min_qty->getInputTextType() ?>" name="x_price_min_qty" id="x_price_min_qty" data-table="multiple_price" data-field="x_price_min_qty" value="<?= $Page->price_min_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price_min_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price_min_qty->formatPattern()) ?>"<?= $Page->price_min_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price_min_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label for="x_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency" id="z_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricesearch_x_currency"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricesearch", function() {
    var options = { name: "x_currency", selectId: "fmultiple_pricesearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricesearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fmultiple_pricesearch" };
    } else {
        options.ajax = { id: "x_currency", form: "fmultiple_pricesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_operator" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->operator->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_operator" class="ew-auto-suggest">
    <input type="<?= $Page->operator->getInputTextType() ?>" class="form-control" name="sv_x_operator" id="sv_x_operator" value="<?= RemoveHtml($Page->operator->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="multiple_price" data-field="x_operator" data-input="sv_x_operator" data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fmultiple_pricesearch", function() {
    fmultiple_pricesearch.createAutoSuggest(Object.assign({"id":"x_operator","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->operator->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.multiple_price.fields.operator.autoSuggestOptions));
});
</script>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_multiple_price_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_multiple_price_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="multiple_price" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmultiple_pricesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmultiple_pricesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmultiple_pricesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmultiple_pricesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmultiple_pricesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("multiple_price");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
