<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("MultiplePriceGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fmultiple_pricegrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { multiple_price: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmultiple_pricegrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null], fields.company_id.isInvalid],
            ["buyer", [fields.buyer.visible && fields.buyer.required ? ew.Validators.required(fields.buyer.caption) : null], fields.buyer.isInvalid],
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null], fields.buyer_id.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["code", [fields.code.visible && fields.code.required ? ew.Validators.required(fields.code.caption) : null], fields.code.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["level", [fields.level.visible && fields.level.required ? ew.Validators.required(fields.level.caption) : null], fields.level.isInvalid],
            ["min_qty", [fields.min_qty.visible && fields.min_qty.required ? ew.Validators.required(fields.min_qty.caption) : null, ew.Validators.integer], fields.min_qty.isInvalid],
            ["max_qty", [fields.max_qty.visible && fields.max_qty.required ? ew.Validators.required(fields.max_qty.caption) : null, ew.Validators.integer], fields.max_qty.isInvalid],
            ["increment", [fields.increment.visible && fields.increment.required ? ew.Validators.required(fields.increment.caption) : null, ew.Validators.integer], fields.increment.isInvalid],
            ["price_min_qty", [fields.price_min_qty.visible && fields.price_min_qty.required ? ew.Validators.required(fields.price_min_qty.caption) : null, ew.Validators.float], fields.price_min_qty.isInvalid],
            ["currency", [fields.currency.visible && fields.currency.required ? ew.Validators.required(fields.currency.caption) : null], fields.currency.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["company_id",false],["buyer",false],["buyer_id",false],["grp",false],["product",false],["code",false],["packing_type",false],["level",false],["min_qty",false],["max_qty",false],["increment",false],["price_min_qty",false],["currency",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Grid->company_id->toClientList($Grid) ?>,
            "buyer": <?= $Grid->buyer->toClientList($Grid) ?>,
            "grp": <?= $Grid->grp->toClientList($Grid) ?>,
            "product": <?= $Grid->product->toClientList($Grid) ?>,
            "code": <?= $Grid->code->toClientList($Grid) ?>,
            "packing_type": <?= $Grid->packing_type->toClientList($Grid) ?>,
            "level": <?= $Grid->level->toClientList($Grid) ?>,
            "currency": <?= $Grid->currency->toClientList($Grid) ?>,
            "operator": <?= $Grid->operator->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fmultiple_pricegrid" class="ew-form ew-list-form">
<div id="gmp_multiple_price" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_multiple_pricegrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_multiple_price_id" class="multiple_price_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Grid->company_id->headerCellClass() ?>"><div id="elh_multiple_price_company_id" class="multiple_price_company_id"><?= $Grid->renderFieldHeader($Grid->company_id) ?></div></th>
<?php } ?>
<?php if ($Grid->buyer->Visible) { // buyer ?>
        <th data-name="buyer" class="<?= $Grid->buyer->headerCellClass() ?>"><div id="elh_multiple_price_buyer" class="multiple_price_buyer"><?= $Grid->renderFieldHeader($Grid->buyer) ?></div></th>
<?php } ?>
<?php if ($Grid->buyer_id->Visible) { // buyer_id ?>
        <th data-name="buyer_id" class="<?= $Grid->buyer_id->headerCellClass() ?>"><div id="elh_multiple_price_buyer_id" class="multiple_price_buyer_id"><?= $Grid->renderFieldHeader($Grid->buyer_id) ?></div></th>
<?php } ?>
<?php if ($Grid->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Grid->grp->headerCellClass() ?>"><div id="elh_multiple_price_grp" class="multiple_price_grp"><?= $Grid->renderFieldHeader($Grid->grp) ?></div></th>
<?php } ?>
<?php if ($Grid->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Grid->product->headerCellClass() ?>"><div id="elh_multiple_price_product" class="multiple_price_product"><?= $Grid->renderFieldHeader($Grid->product) ?></div></th>
<?php } ?>
<?php if ($Grid->code->Visible) { // code ?>
        <th data-name="code" class="<?= $Grid->code->headerCellClass() ?>"><div id="elh_multiple_price_code" class="multiple_price_code"><?= $Grid->renderFieldHeader($Grid->code) ?></div></th>
<?php } ?>
<?php if ($Grid->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Grid->packing_type->headerCellClass() ?>"><div id="elh_multiple_price_packing_type" class="multiple_price_packing_type"><?= $Grid->renderFieldHeader($Grid->packing_type) ?></div></th>
<?php } ?>
<?php if ($Grid->level->Visible) { // level ?>
        <th data-name="level" class="<?= $Grid->level->headerCellClass() ?>"><div id="elh_multiple_price_level" class="multiple_price_level"><?= $Grid->renderFieldHeader($Grid->level) ?></div></th>
<?php } ?>
<?php if ($Grid->min_qty->Visible) { // min_qty ?>
        <th data-name="min_qty" class="<?= $Grid->min_qty->headerCellClass() ?>"><div id="elh_multiple_price_min_qty" class="multiple_price_min_qty"><?= $Grid->renderFieldHeader($Grid->min_qty) ?></div></th>
<?php } ?>
<?php if ($Grid->max_qty->Visible) { // max_qty ?>
        <th data-name="max_qty" class="<?= $Grid->max_qty->headerCellClass() ?>"><div id="elh_multiple_price_max_qty" class="multiple_price_max_qty"><?= $Grid->renderFieldHeader($Grid->max_qty) ?></div></th>
<?php } ?>
<?php if ($Grid->increment->Visible) { // increment ?>
        <th data-name="increment" class="<?= $Grid->increment->headerCellClass() ?>"><div id="elh_multiple_price_increment" class="multiple_price_increment"><?= $Grid->renderFieldHeader($Grid->increment) ?></div></th>
<?php } ?>
<?php if ($Grid->price_min_qty->Visible) { // price_min_qty ?>
        <th data-name="price_min_qty" class="<?= $Grid->price_min_qty->headerCellClass() ?>"><div id="elh_multiple_price_price_min_qty" class="multiple_price_price_min_qty"><?= $Grid->renderFieldHeader($Grid->price_min_qty) ?></div></th>
<?php } ?>
<?php if ($Grid->currency->Visible) { // currency ?>
        <th data-name="currency" class="<?= $Grid->currency->headerCellClass() ?>"><div id="elh_multiple_price_currency" class="multiple_price_currency"><?= $Grid->renderFieldHeader($Grid->currency) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_multiple_price_operator" class="multiple_price_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_multiple_price_datetime" class="multiple_price_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_id" class="el_multiple_price_id"></span>
<input type="hidden" data-table="multiple_price" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_id" class="el_multiple_price_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="multiple_price" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_id" class="el_multiple_price_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_id" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_id" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_id" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_id" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="multiple_price" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Grid->company_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_company_id" class="el_multiple_price_company_id">
    <select
        id="x<?= $Grid->RowIndex ?>_company_id"
        name="x<?= $Grid->RowIndex ?>_company_id"
        class="form-select ew-select<?= $Grid->company_id->isInvalidClass() ?>"
        <?php if (!$Grid->company_id->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_company_id"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_company_id"
        data-value-separator="<?= $Grid->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>"
        <?= $Grid->company_id->editAttributes() ?>>
        <?= $Grid->company_id->selectOptionListHtml("x{$Grid->RowIndex}_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->company_id->getErrorMessage() ?></div>
<?= $Grid->company_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_company_id") ?>
<?php if (!$Grid->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_company_id", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_company_id", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_company_id", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="multiple_price" data-field="x_company_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_company_id" id="o<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_company_id" class="el_multiple_price_company_id">
    <select
        id="x<?= $Grid->RowIndex ?>_company_id"
        name="x<?= $Grid->RowIndex ?>_company_id"
        class="form-select ew-select<?= $Grid->company_id->isInvalidClass() ?>"
        <?php if (!$Grid->company_id->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_company_id"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_company_id"
        data-value-separator="<?= $Grid->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>"
        <?= $Grid->company_id->editAttributes() ?>>
        <?= $Grid->company_id->selectOptionListHtml("x{$Grid->RowIndex}_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->company_id->getErrorMessage() ?></div>
<?= $Grid->company_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_company_id") ?>
<?php if (!$Grid->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_company_id", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_company_id", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_company_id", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_company_id" class="el_multiple_price_company_id">
<span<?= $Grid->company_id->viewAttributes() ?>>
<?= $Grid->company_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_company_id" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_company_id" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_company_id" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_company_id" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->buyer->Visible) { // buyer ?>
        <td data-name="buyer"<?= $Grid->buyer->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_buyer" class="el_multiple_price_buyer">
    <select
        id="x<?= $Grid->RowIndex ?>_buyer"
        name="x<?= $Grid->RowIndex ?>_buyer"
        class="form-select ew-select<?= $Grid->buyer->isInvalidClass() ?>"
        <?php if (!$Grid->buyer->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_buyer"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_buyer"
        data-value-separator="<?= $Grid->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->buyer->getPlaceHolder()) ?>"
        <?= $Grid->buyer->editAttributes() ?>>
        <?= $Grid->buyer->selectOptionListHtml("x{$Grid->RowIndex}_buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->buyer->getErrorMessage() ?></div>
<?php if (!$Grid->buyer->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_buyer", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_buyer" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_buyer", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_buyer", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.buyer.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="multiple_price" data-field="x_buyer" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_buyer" id="o<?= $Grid->RowIndex ?>_buyer" value="<?= HtmlEncode($Grid->buyer->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_buyer" class="el_multiple_price_buyer">
    <select
        id="x<?= $Grid->RowIndex ?>_buyer"
        name="x<?= $Grid->RowIndex ?>_buyer"
        class="form-select ew-select<?= $Grid->buyer->isInvalidClass() ?>"
        <?php if (!$Grid->buyer->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_buyer"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_buyer"
        data-value-separator="<?= $Grid->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->buyer->getPlaceHolder()) ?>"
        <?= $Grid->buyer->editAttributes() ?>>
        <?= $Grid->buyer->selectOptionListHtml("x{$Grid->RowIndex}_buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->buyer->getErrorMessage() ?></div>
<?php if (!$Grid->buyer->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_buyer", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_buyer" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_buyer", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_buyer", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.buyer.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_buyer" class="el_multiple_price_buyer">
<span<?= $Grid->buyer->viewAttributes() ?>>
<?= $Grid->buyer->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_buyer" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_buyer" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_buyer" value="<?= HtmlEncode($Grid->buyer->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_buyer" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_buyer" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_buyer" value="<?= HtmlEncode($Grid->buyer->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id"<?= $Grid->buyer_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_buyer_id" class="el_multiple_price_buyer_id">
<input type="<?= $Grid->buyer_id->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_buyer_id" id="x<?= $Grid->RowIndex ?>_buyer_id" data-table="multiple_price" data-field="x_buyer_id" value="<?= $Grid->buyer_id->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Grid->buyer_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->buyer_id->formatPattern()) ?>"<?= $Grid->buyer_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->buyer_id->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="multiple_price" data-field="x_buyer_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_buyer_id" id="o<?= $Grid->RowIndex ?>_buyer_id" value="<?= HtmlEncode($Grid->buyer_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_buyer_id" class="el_multiple_price_buyer_id">
<input type="<?= $Grid->buyer_id->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_buyer_id" id="x<?= $Grid->RowIndex ?>_buyer_id" data-table="multiple_price" data-field="x_buyer_id" value="<?= $Grid->buyer_id->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Grid->buyer_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->buyer_id->formatPattern()) ?>"<?= $Grid->buyer_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->buyer_id->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_buyer_id" class="el_multiple_price_buyer_id">
<span<?= $Grid->buyer_id->viewAttributes() ?>>
<?= $Grid->buyer_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_buyer_id" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_buyer_id" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_buyer_id" value="<?= HtmlEncode($Grid->buyer_id->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_buyer_id" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_buyer_id" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_buyer_id" value="<?= HtmlEncode($Grid->buyer_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Grid->grp->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_grp" class="el_multiple_price_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_grp"
        name="x<?= $Grid->RowIndex ?>_grp"
        class="form-select ew-select<?= $Grid->grp->isInvalidClass() ?>"
        <?php if (!$Grid->grp->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_grp"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_grp"
        data-value-separator="<?= $Grid->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->grp->editAttributes() ?>>
        <?= $Grid->grp->selectOptionListHtml("x{$Grid->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->grp->getErrorMessage() ?></div>
<?= $Grid->grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_grp") ?>
<?php if (!$Grid->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_grp", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="multiple_price" data-field="x_grp" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_grp" id="o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_grp" class="el_multiple_price_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_grp"
        name="x<?= $Grid->RowIndex ?>_grp"
        class="form-select ew-select<?= $Grid->grp->isInvalidClass() ?>"
        <?php if (!$Grid->grp->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_grp"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_grp"
        data-value-separator="<?= $Grid->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->grp->editAttributes() ?>>
        <?= $Grid->grp->selectOptionListHtml("x{$Grid->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->grp->getErrorMessage() ?></div>
<?= $Grid->grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_grp") ?>
<?php if (!$Grid->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_grp", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_grp" class="el_multiple_price_grp">
<span<?= $Grid->grp->viewAttributes() ?>>
<?php if (!EmptyString($Grid->grp->getViewValue()) && $Grid->grp->linkAttributes() != "") { ?>
<a<?= $Grid->grp->linkAttributes() ?>><?= $Grid->grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_grp" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_grp" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_grp" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_grp" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->product->Visible) { // product ?>
        <td data-name="product"<?= $Grid->product->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_product" class="el_multiple_price_product">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-select ew-select<?= $Grid->product->isInvalidClass() ?>"
        <?php if (!$Grid->product->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_product"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_product"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<?php if (!$Grid->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="multiple_price" data-field="x_product" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_product" id="o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_product" class="el_multiple_price_product">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-select ew-select<?= $Grid->product->isInvalidClass() ?>"
        <?php if (!$Grid->product->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_product"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_product"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<?php if (!$Grid->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_product" class="el_multiple_price_product">
<span<?= $Grid->product->viewAttributes() ?>>
<?php if (!EmptyString($Grid->product->getViewValue()) && $Grid->product->linkAttributes() != "") { ?>
<a<?= $Grid->product->linkAttributes() ?>><?= $Grid->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->product->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_product" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_product" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_product" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_product" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->code->Visible) { // code ?>
        <td data-name="code"<?= $Grid->code->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->code->getSessionValue() != "") { ?>
<span<?= $Grid->code->viewAttributes() ?>>
<?php if (!EmptyString($Grid->code->ViewValue) && $Grid->code->linkAttributes() != "") { ?>
<a<?= $Grid->code->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->code->getDisplayValue($Grid->code->ViewValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->code->getDisplayValue($Grid->code->ViewValue) ?></span>
<?php } ?>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_code" name="x<?= $Grid->RowIndex ?>_code" value="<?= HtmlEncode($Grid->code->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_code" class="el_multiple_price_code">
<template id="tp_x<?= $Grid->RowIndex ?>_code">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="multiple_price" data-field="x_code" name="x<?= $Grid->RowIndex ?>_code" id="x<?= $Grid->RowIndex ?>_code"<?= $Grid->code->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_code" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_code"
    name="x<?= $Grid->RowIndex ?>_code"
    value="<?= HtmlEncode($Grid->code->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x<?= $Grid->RowIndex ?>_code"
    data-target="dsl_x<?= $Grid->RowIndex ?>_code"
    data-repeatcolumn="2"
    class="form-control<?= $Grid->code->isInvalidClass() ?>"
    data-table="multiple_price"
    data-field="x_code"
    data-value-separator="<?= $Grid->code->displayValueSeparatorAttribute() ?>"
    <?= $Grid->code->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->code->getErrorMessage() ?></div>
<?= $Grid->code->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_code") ?>
</span>
<?php } ?>
<input type="hidden" data-table="multiple_price" data-field="x_code" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_code" id="o<?= $Grid->RowIndex ?>_code" value="<?= HtmlEncode($Grid->code->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->code->getSessionValue() != "") { ?>
<span<?= $Grid->code->viewAttributes() ?>>
<?php if (!EmptyString($Grid->code->ViewValue) && $Grid->code->linkAttributes() != "") { ?>
<a<?= $Grid->code->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->code->getDisplayValue($Grid->code->ViewValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->code->getDisplayValue($Grid->code->ViewValue) ?></span>
<?php } ?>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_code" name="x<?= $Grid->RowIndex ?>_code" value="<?= HtmlEncode($Grid->code->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_code" class="el_multiple_price_code">
<template id="tp_x<?= $Grid->RowIndex ?>_code">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="multiple_price" data-field="x_code" name="x<?= $Grid->RowIndex ?>_code" id="x<?= $Grid->RowIndex ?>_code"<?= $Grid->code->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_code" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_code"
    name="x<?= $Grid->RowIndex ?>_code"
    value="<?= HtmlEncode($Grid->code->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x<?= $Grid->RowIndex ?>_code"
    data-target="dsl_x<?= $Grid->RowIndex ?>_code"
    data-repeatcolumn="2"
    class="form-control<?= $Grid->code->isInvalidClass() ?>"
    data-table="multiple_price"
    data-field="x_code"
    data-value-separator="<?= $Grid->code->displayValueSeparatorAttribute() ?>"
    <?= $Grid->code->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->code->getErrorMessage() ?></div>
<?= $Grid->code->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_code") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_code" class="el_multiple_price_code">
<span<?= $Grid->code->viewAttributes() ?>>
<?php if (!EmptyString($Grid->code->getViewValue()) && $Grid->code->linkAttributes() != "") { ?>
<a<?= $Grid->code->linkAttributes() ?>><?= $Grid->code->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->code->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_code" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_code" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_code" value="<?= HtmlEncode($Grid->code->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_code" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_code" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_code" value="<?= HtmlEncode($Grid->code->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Grid->packing_type->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_packing_type" class="el_multiple_price_packing_type">
    <select
        id="x<?= $Grid->RowIndex ?>_packing_type"
        name="x<?= $Grid->RowIndex ?>_packing_type"
        class="form-select ew-select<?= $Grid->packing_type->isInvalidClass() ?>"
        <?php if (!$Grid->packing_type->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_packing_type"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_packing_type"
        data-value-separator="<?= $Grid->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->packing_type->getPlaceHolder()) ?>"
        <?= $Grid->packing_type->editAttributes() ?>>
        <?= $Grid->packing_type->selectOptionListHtml("x{$Grid->RowIndex}_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->packing_type->getErrorMessage() ?></div>
<?= $Grid->packing_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_packing_type") ?>
<?php if (!$Grid->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_packing_type", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="multiple_price" data-field="x_packing_type" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_packing_type" id="o<?= $Grid->RowIndex ?>_packing_type" value="<?= HtmlEncode($Grid->packing_type->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_packing_type" class="el_multiple_price_packing_type">
    <select
        id="x<?= $Grid->RowIndex ?>_packing_type"
        name="x<?= $Grid->RowIndex ?>_packing_type"
        class="form-select ew-select<?= $Grid->packing_type->isInvalidClass() ?>"
        <?php if (!$Grid->packing_type->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_packing_type"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_packing_type"
        data-value-separator="<?= $Grid->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->packing_type->getPlaceHolder()) ?>"
        <?= $Grid->packing_type->editAttributes() ?>>
        <?= $Grid->packing_type->selectOptionListHtml("x{$Grid->RowIndex}_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->packing_type->getErrorMessage() ?></div>
<?= $Grid->packing_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_packing_type") ?>
<?php if (!$Grid->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_packing_type", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_packing_type" class="el_multiple_price_packing_type">
<span<?= $Grid->packing_type->viewAttributes() ?>>
<?= $Grid->packing_type->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_packing_type" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_packing_type" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_packing_type" value="<?= HtmlEncode($Grid->packing_type->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_packing_type" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_packing_type" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_packing_type" value="<?= HtmlEncode($Grid->packing_type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->level->Visible) { // level ?>
        <td data-name="level"<?= $Grid->level->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_level" class="el_multiple_price_level">
    <select
        id="x<?= $Grid->RowIndex ?>_level"
        name="x<?= $Grid->RowIndex ?>_level"
        class="form-select ew-select<?= $Grid->level->isInvalidClass() ?>"
        <?php if (!$Grid->level->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_level"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_level"
        data-value-separator="<?= $Grid->level->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->level->getPlaceHolder()) ?>"
        <?= $Grid->level->editAttributes() ?>>
        <?= $Grid->level->selectOptionListHtml("x{$Grid->RowIndex}_level") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->level->getErrorMessage() ?></div>
<?php if (!$Grid->level->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_level", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_level" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.level?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_level", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_level", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.level.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="multiple_price" data-field="x_level" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_level" id="o<?= $Grid->RowIndex ?>_level" value="<?= HtmlEncode($Grid->level->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_level" class="el_multiple_price_level">
    <select
        id="x<?= $Grid->RowIndex ?>_level"
        name="x<?= $Grid->RowIndex ?>_level"
        class="form-select ew-select<?= $Grid->level->isInvalidClass() ?>"
        <?php if (!$Grid->level->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_level"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_level"
        data-value-separator="<?= $Grid->level->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->level->getPlaceHolder()) ?>"
        <?= $Grid->level->editAttributes() ?>>
        <?= $Grid->level->selectOptionListHtml("x{$Grid->RowIndex}_level") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->level->getErrorMessage() ?></div>
<?php if (!$Grid->level->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_level", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_level" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.level?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_level", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_level", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.level.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_level" class="el_multiple_price_level">
<span<?= $Grid->level->viewAttributes() ?>>
<?php if (!EmptyString($Grid->level->getViewValue()) && $Grid->level->linkAttributes() != "") { ?>
<a<?= $Grid->level->linkAttributes() ?>><?= $Grid->level->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->level->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_level" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_level" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_level" value="<?= HtmlEncode($Grid->level->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_level" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_level" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_level" value="<?= HtmlEncode($Grid->level->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->min_qty->Visible) { // min_qty ?>
        <td data-name="min_qty"<?= $Grid->min_qty->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_min_qty" class="el_multiple_price_min_qty">
<input type="<?= $Grid->min_qty->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_min_qty" id="x<?= $Grid->RowIndex ?>_min_qty" data-table="multiple_price" data-field="x_min_qty" value="<?= $Grid->min_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->min_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->min_qty->formatPattern()) ?>"<?= $Grid->min_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->min_qty->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="multiple_price" data-field="x_min_qty" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_min_qty" id="o<?= $Grid->RowIndex ?>_min_qty" value="<?= HtmlEncode($Grid->min_qty->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_min_qty" class="el_multiple_price_min_qty">
<input type="<?= $Grid->min_qty->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_min_qty" id="x<?= $Grid->RowIndex ?>_min_qty" data-table="multiple_price" data-field="x_min_qty" value="<?= $Grid->min_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->min_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->min_qty->formatPattern()) ?>"<?= $Grid->min_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->min_qty->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_min_qty" class="el_multiple_price_min_qty">
<span<?= $Grid->min_qty->viewAttributes() ?>>
<?= $Grid->min_qty->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_min_qty" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_min_qty" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_min_qty" value="<?= HtmlEncode($Grid->min_qty->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_min_qty" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_min_qty" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_min_qty" value="<?= HtmlEncode($Grid->min_qty->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->max_qty->Visible) { // max_qty ?>
        <td data-name="max_qty"<?= $Grid->max_qty->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_max_qty" class="el_multiple_price_max_qty">
<input type="<?= $Grid->max_qty->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_max_qty" id="x<?= $Grid->RowIndex ?>_max_qty" data-table="multiple_price" data-field="x_max_qty" value="<?= $Grid->max_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->max_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->max_qty->formatPattern()) ?>"<?= $Grid->max_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->max_qty->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="multiple_price" data-field="x_max_qty" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_max_qty" id="o<?= $Grid->RowIndex ?>_max_qty" value="<?= HtmlEncode($Grid->max_qty->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_max_qty" class="el_multiple_price_max_qty">
<input type="<?= $Grid->max_qty->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_max_qty" id="x<?= $Grid->RowIndex ?>_max_qty" data-table="multiple_price" data-field="x_max_qty" value="<?= $Grid->max_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->max_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->max_qty->formatPattern()) ?>"<?= $Grid->max_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->max_qty->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_max_qty" class="el_multiple_price_max_qty">
<span<?= $Grid->max_qty->viewAttributes() ?>>
<?= $Grid->max_qty->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_max_qty" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_max_qty" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_max_qty" value="<?= HtmlEncode($Grid->max_qty->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_max_qty" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_max_qty" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_max_qty" value="<?= HtmlEncode($Grid->max_qty->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->increment->Visible) { // increment ?>
        <td data-name="increment"<?= $Grid->increment->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_increment" class="el_multiple_price_increment">
<input type="<?= $Grid->increment->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_increment" id="x<?= $Grid->RowIndex ?>_increment" data-table="multiple_price" data-field="x_increment" value="<?= $Grid->increment->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->increment->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->increment->formatPattern()) ?>"<?= $Grid->increment->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->increment->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="multiple_price" data-field="x_increment" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_increment" id="o<?= $Grid->RowIndex ?>_increment" value="<?= HtmlEncode($Grid->increment->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_increment" class="el_multiple_price_increment">
<input type="<?= $Grid->increment->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_increment" id="x<?= $Grid->RowIndex ?>_increment" data-table="multiple_price" data-field="x_increment" value="<?= $Grid->increment->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->increment->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->increment->formatPattern()) ?>"<?= $Grid->increment->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->increment->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_increment" class="el_multiple_price_increment">
<span<?= $Grid->increment->viewAttributes() ?>>
<?= $Grid->increment->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_increment" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_increment" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_increment" value="<?= HtmlEncode($Grid->increment->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_increment" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_increment" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_increment" value="<?= HtmlEncode($Grid->increment->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->price_min_qty->Visible) { // price_min_qty ?>
        <td data-name="price_min_qty"<?= $Grid->price_min_qty->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_price_min_qty" class="el_multiple_price_price_min_qty">
<input type="<?= $Grid->price_min_qty->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_price_min_qty" id="x<?= $Grid->RowIndex ?>_price_min_qty" data-table="multiple_price" data-field="x_price_min_qty" value="<?= $Grid->price_min_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->price_min_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->price_min_qty->formatPattern()) ?>"<?= $Grid->price_min_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->price_min_qty->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="multiple_price" data-field="x_price_min_qty" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_price_min_qty" id="o<?= $Grid->RowIndex ?>_price_min_qty" value="<?= HtmlEncode($Grid->price_min_qty->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_price_min_qty" class="el_multiple_price_price_min_qty">
<input type="<?= $Grid->price_min_qty->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_price_min_qty" id="x<?= $Grid->RowIndex ?>_price_min_qty" data-table="multiple_price" data-field="x_price_min_qty" value="<?= $Grid->price_min_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->price_min_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->price_min_qty->formatPattern()) ?>"<?= $Grid->price_min_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->price_min_qty->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_price_min_qty" class="el_multiple_price_price_min_qty">
<span<?= $Grid->price_min_qty->viewAttributes() ?>>
<?= $Grid->price_min_qty->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_price_min_qty" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_price_min_qty" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_price_min_qty" value="<?= HtmlEncode($Grid->price_min_qty->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_price_min_qty" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_price_min_qty" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_price_min_qty" value="<?= HtmlEncode($Grid->price_min_qty->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->currency->Visible) { // currency ?>
        <td data-name="currency"<?= $Grid->currency->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_currency" class="el_multiple_price_currency">
    <select
        id="x<?= $Grid->RowIndex ?>_currency"
        name="x<?= $Grid->RowIndex ?>_currency"
        class="form-select ew-select<?= $Grid->currency->isInvalidClass() ?>"
        <?php if (!$Grid->currency->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_currency"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_currency"
        data-value-separator="<?= $Grid->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->currency->getPlaceHolder()) ?>"
        <?= $Grid->currency->editAttributes() ?>>
        <?= $Grid->currency->selectOptionListHtml("x{$Grid->RowIndex}_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->currency->getErrorMessage() ?></div>
<?= $Grid->currency->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_currency") ?>
<?php if (!$Grid->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_currency", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.currency?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_currency", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_currency", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="multiple_price" data-field="x_currency" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_currency" id="o<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_currency" class="el_multiple_price_currency">
    <select
        id="x<?= $Grid->RowIndex ?>_currency"
        name="x<?= $Grid->RowIndex ?>_currency"
        class="form-select ew-select<?= $Grid->currency->isInvalidClass() ?>"
        <?php if (!$Grid->currency->IsNativeSelect) { ?>
        data-select2-id="fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_currency"
        <?php } ?>
        data-table="multiple_price"
        data-field="x_currency"
        data-value-separator="<?= $Grid->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->currency->getPlaceHolder()) ?>"
        <?= $Grid->currency->editAttributes() ?>>
        <?= $Grid->currency->selectOptionListHtml("x{$Grid->RowIndex}_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->currency->getErrorMessage() ?></div>
<?= $Grid->currency->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_currency") ?>
<?php if (!$Grid->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fmultiple_pricegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_currency", selectId: "fmultiple_pricegrid_x<?= $Grid->RowIndex ?>_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmultiple_pricegrid.lists.currency?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_currency", form: "fmultiple_pricegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_currency", form: "fmultiple_pricegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.multiple_price.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_currency" class="el_multiple_price_currency">
<span<?= $Grid->currency->viewAttributes() ?>>
<?= $Grid->currency->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_currency" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_currency" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_currency" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_currency" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="multiple_price" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_operator" class="el_multiple_price_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?php if (!EmptyString($Grid->operator->getViewValue()) && $Grid->operator->linkAttributes() != "") { ?>
<a<?= $Grid->operator->linkAttributes() ?>><?= $Grid->operator->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->operator->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_operator" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_operator" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_operator" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_operator" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="multiple_price" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_multiple_price_datetime" class="el_multiple_price_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="multiple_price" data-field="x_datetime" data-hidden="1" name="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_datetime" id="fmultiple_pricegrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="multiple_price" data-field="x_datetime" data-hidden="1" data-old name="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_datetime" id="fmultiple_pricegrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fmultiple_pricegrid","load"], () => fmultiple_pricegrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fmultiple_pricegrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("multiple_price");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
