<?php

namespace PHPMaker2024\fibre;

// Page object
$MonthlyProductionBuyerwiseSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { monthly_production_buyerwise: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmonthly_production_buyerwisesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmonthly_production_buyerwisesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["month", [], fields.month.isInvalid],
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["payment_type", [], fields.payment_type.isInvalid],
            ["pcs", [ew.Validators.integer], fields.pcs.isInvalid],
            ["y_pcs", [ew.Validators.between], false],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["y_sqm", [ew.Validators.between], false],
            ["amount", [ew.Validators.float], fields.amount.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "month": <?= $Page->month->toClientList($Page) ?>,
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "location": <?= $Page->location->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "payment_type": <?= $Page->payment_type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmonthly_production_buyerwisesearch" id="fmonthly_production_buyerwisesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="monthly_production_buyerwise">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->month->Visible) { // month ?>
    <div id="r_month" class="row"<?= $Page->month->rowAttributes() ?>>
        <label for="x_month" class="<?= $Page->LeftColumnClass ?>"><span id="elh_monthly_production_buyerwise_month"><?= $Page->month->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_month" id="z_month" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->month->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_monthly_production_buyerwise_month" class="ew-search-field ew-search-field-single">
    <select
        id="x_month"
        name="x_month"
        class="form-select ew-select<?= $Page->month->isInvalidClass() ?>"
        <?php if (!$Page->month->IsNativeSelect) { ?>
        data-select2-id="fmonthly_production_buyerwisesearch_x_month"
        <?php } ?>
        data-table="monthly_production_buyerwise"
        data-field="x_month"
        data-value-separator="<?= $Page->month->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->month->getPlaceHolder()) ?>"
        <?= $Page->month->editAttributes() ?>>
        <?= $Page->month->selectOptionListHtml("x_month") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->month->getErrorMessage(false) ?></div>
<?= $Page->month->Lookup->getParamTag($Page, "p_x_month") ?>
<?php if (!$Page->month->IsNativeSelect) { ?>
<script>
loadjs.ready("fmonthly_production_buyerwisesearch", function() {
    var options = { name: "x_month", selectId: "fmonthly_production_buyerwisesearch_x_month" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmonthly_production_buyerwisesearch.lists.month?.lookupOptions.length) {
        options.data = { id: "x_month", form: "fmonthly_production_buyerwisesearch" };
    } else {
        options.ajax = { id: "x_month", form: "fmonthly_production_buyerwisesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.monthly_production_buyerwise.fields.month.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id" class="row"<?= $Page->buyers_id->rowAttributes() ?>>
        <label for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_monthly_production_buyerwise_buyers_id"><?= $Page->buyers_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyers_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_monthly_production_buyerwise_buyers_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fmonthly_production_buyerwisesearch_x_buyers_id"
        <?php } ?>
        data-table="monthly_production_buyerwise"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmonthly_production_buyerwisesearch", function() {
    var options = { name: "x_buyers_id", selectId: "fmonthly_production_buyerwisesearch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmonthly_production_buyerwisesearch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fmonthly_production_buyerwisesearch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fmonthly_production_buyerwisesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.monthly_production_buyerwise.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_monthly_production_buyerwise_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_monthly_production_buyerwise_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fmonthly_production_buyerwisesearch_x_location"
        <?php } ?>
        data-table="monthly_production_buyerwise"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fmonthly_production_buyerwisesearch", function() {
    var options = { name: "x_location", selectId: "fmonthly_production_buyerwisesearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmonthly_production_buyerwisesearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fmonthly_production_buyerwisesearch" };
    } else {
        options.ajax = { id: "x_location", form: "fmonthly_production_buyerwisesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.monthly_production_buyerwise.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_monthly_production_buyerwise_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_category" id="z_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_monthly_production_buyerwise_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fmonthly_production_buyerwisesearch_x_category"
        <?php } ?>
        data-table="monthly_production_buyerwise"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fmonthly_production_buyerwisesearch", function() {
    var options = { name: "x_category", selectId: "fmonthly_production_buyerwisesearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmonthly_production_buyerwisesearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fmonthly_production_buyerwisesearch" };
    } else {
        options.ajax = { id: "x_category", form: "fmonthly_production_buyerwisesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.monthly_production_buyerwise.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label for="x_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_monthly_production_buyerwise_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_monthly_production_buyerwise_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fmonthly_production_buyerwisesearch_x_process"
        <?php } ?>
        data-table="monthly_production_buyerwise"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fmonthly_production_buyerwisesearch", function() {
    var options = { name: "x_process", selectId: "fmonthly_production_buyerwisesearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmonthly_production_buyerwisesearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fmonthly_production_buyerwisesearch" };
    } else {
        options.ajax = { id: "x_process", form: "fmonthly_production_buyerwisesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.monthly_production_buyerwise.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment_type->Visible) { // payment_type ?>
    <div id="r_payment_type" class="row"<?= $Page->payment_type->rowAttributes() ?>>
        <label for="x_payment_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_monthly_production_buyerwise_payment_type"><?= $Page->payment_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_payment_type" id="z_payment_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_monthly_production_buyerwise_payment_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_payment_type"
        name="x_payment_type"
        class="form-select ew-select<?= $Page->payment_type->isInvalidClass() ?>"
        <?php if (!$Page->payment_type->IsNativeSelect) { ?>
        data-select2-id="fmonthly_production_buyerwisesearch_x_payment_type"
        <?php } ?>
        data-table="monthly_production_buyerwise"
        data-field="x_payment_type"
        data-value-separator="<?= $Page->payment_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment_type->getPlaceHolder()) ?>"
        <?= $Page->payment_type->editAttributes() ?>>
        <?= $Page->payment_type->selectOptionListHtml("x_payment_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment_type->getErrorMessage(false) ?></div>
<?php if (!$Page->payment_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fmonthly_production_buyerwisesearch", function() {
    var options = { name: "x_payment_type", selectId: "fmonthly_production_buyerwisesearch_x_payment_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmonthly_production_buyerwisesearch.lists.payment_type?.lookupOptions.length) {
        options.data = { id: "x_payment_type", form: "fmonthly_production_buyerwisesearch" };
    } else {
        options.ajax = { id: "x_payment_type", form: "fmonthly_production_buyerwisesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.monthly_production_buyerwise.fields.payment_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pcs->Visible) { // pcs ?>
    <div id="r_pcs" class="row"<?= $Page->pcs->rowAttributes() ?>>
        <label for="x_pcs" class="<?= $Page->LeftColumnClass ?>"><span id="elh_monthly_production_buyerwise_pcs"><?= $Page->pcs->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pcs->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_pcs" id="z_pcs" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->pcs->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->pcs->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_monthly_production_buyerwise_pcs" class="ew-search-field">
<input type="<?= $Page->pcs->getInputTextType() ?>" name="x_pcs" id="x_pcs" data-table="monthly_production_buyerwise" data-field="x_pcs" value="<?= $Page->pcs->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pcs->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pcs->formatPattern()) ?>"<?= $Page->pcs->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pcs->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_monthly_production_buyerwise_pcs" class="ew-search-field2 d-none">
<input type="<?= $Page->pcs->getInputTextType() ?>" name="y_pcs" id="y_pcs" data-table="monthly_production_buyerwise" data-field="x_pcs" value="<?= $Page->pcs->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->pcs->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pcs->formatPattern()) ?>"<?= $Page->pcs->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pcs->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_monthly_production_buyerwise_sqm"><?= $Page->sqm->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_sqm" id="z_sqm" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->sqm->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->sqm->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_monthly_production_buyerwise_sqm" class="ew-search-field">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="monthly_production_buyerwise" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_monthly_production_buyerwise_sqm" class="ew-search-field2 d-none">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="y_sqm" id="y_sqm" data-table="monthly_production_buyerwise" data-field="x_sqm" value="<?= $Page->sqm->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_monthly_production_buyerwise_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_monthly_production_buyerwise_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="monthly_production_buyerwise" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmonthly_production_buyerwisesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmonthly_production_buyerwisesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmonthly_production_buyerwisesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("monthly_production_buyerwise");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
