<?php

namespace PHPMaker2024\fibre;

// Page object
$MonthlyProductionBuyerwiseList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { monthly_production_buyerwise: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fmonthly_production_buyerwisesrch" id="fmonthly_production_buyerwisesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fmonthly_production_buyerwisesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { monthly_production_buyerwise: currentTable } });
var currentForm;
var fmonthly_production_buyerwisesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmonthly_production_buyerwisesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["month", [], fields.month.isInvalid],
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["payment_type", [], fields.payment_type.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "month": <?= $Page->month->toClientList($Page) ?>,
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "location": <?= $Page->location->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "payment_type": <?= $Page->payment_type->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->month->Visible) { // month ?>
<?php
if (!$Page->month->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_month" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->month->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_month" class="ew-search-caption ew-label"><?= $Page->month->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_month" id="z_month" value="LIKE">
</div>
        </div>
        <div id="el_monthly_production_buyerwise_month" class="ew-search-field">
    <select
        id="x_month"
        name="x_month"
        class="form-select ew-select<?= $Page->month->isInvalidClass() ?>"
        <?php if (!$Page->month->IsNativeSelect) { ?>
        data-select2-id="fmonthly_production_buyerwisesrch_x_month"
        <?php } ?>
        data-table="monthly_production_buyerwise"
        data-field="x_month"
        data-value-separator="<?= $Page->month->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->month->getPlaceHolder()) ?>"
        <?= $Page->month->editAttributes() ?>>
        <?= $Page->month->selectOptionListHtml("x_month") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->month->getErrorMessage(false) ?></div>
<?= $Page->month->Lookup->getParamTag($Page, "p_x_month") ?>
<?php if (!$Page->month->IsNativeSelect) { ?>
<script>
loadjs.ready("fmonthly_production_buyerwisesrch", function() {
    var options = { name: "x_month", selectId: "fmonthly_production_buyerwisesrch_x_month" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmonthly_production_buyerwisesrch.lists.month?.lookupOptions.length) {
        options.data = { id: "x_month", form: "fmonthly_production_buyerwisesrch" };
    } else {
        options.ajax = { id: "x_month", form: "fmonthly_production_buyerwisesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.monthly_production_buyerwise.fields.month.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
<?php
if (!$Page->buyers_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyers_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyers_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_buyers_id" class="ew-search-caption ew-label"><?= $Page->buyers_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</div>
        </div>
        <div id="el_monthly_production_buyerwise_buyers_id" class="ew-search-field">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fmonthly_production_buyerwisesrch_x_buyers_id"
        <?php } ?>
        data-table="monthly_production_buyerwise"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmonthly_production_buyerwisesrch", function() {
    var options = { name: "x_buyers_id", selectId: "fmonthly_production_buyerwisesrch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmonthly_production_buyerwisesrch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fmonthly_production_buyerwisesrch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fmonthly_production_buyerwisesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.monthly_production_buyerwise.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
<?php
if (!$Page->location->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_location" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->location->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_location" class="ew-search-caption ew-label"><?= $Page->location->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</div>
        </div>
        <div id="el_monthly_production_buyerwise_location" class="ew-search-field">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fmonthly_production_buyerwisesrch_x_location"
        <?php } ?>
        data-table="monthly_production_buyerwise"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fmonthly_production_buyerwisesrch", function() {
    var options = { name: "x_location", selectId: "fmonthly_production_buyerwisesrch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmonthly_production_buyerwisesrch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fmonthly_production_buyerwisesrch" };
    } else {
        options.ajax = { id: "x_location", form: "fmonthly_production_buyerwisesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.monthly_production_buyerwise.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
<?php
if (!$Page->category->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_category" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->category->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_category" class="ew-search-caption ew-label"><?= $Page->category->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_category" id="z_category" value="=">
</div>
        </div>
        <div id="el_monthly_production_buyerwise_category" class="ew-search-field">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fmonthly_production_buyerwisesrch_x_category"
        <?php } ?>
        data-table="monthly_production_buyerwise"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fmonthly_production_buyerwisesrch", function() {
    var options = { name: "x_category", selectId: "fmonthly_production_buyerwisesrch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmonthly_production_buyerwisesrch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fmonthly_production_buyerwisesrch" };
    } else {
        options.ajax = { id: "x_category", form: "fmonthly_production_buyerwisesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.monthly_production_buyerwise.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
<?php
if (!$Page->process->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_process" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->process->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_process" class="ew-search-caption ew-label"><?= $Page->process->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</div>
        </div>
        <div id="el_monthly_production_buyerwise_process" class="ew-search-field">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fmonthly_production_buyerwisesrch_x_process"
        <?php } ?>
        data-table="monthly_production_buyerwise"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fmonthly_production_buyerwisesrch", function() {
    var options = { name: "x_process", selectId: "fmonthly_production_buyerwisesrch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmonthly_production_buyerwisesrch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fmonthly_production_buyerwisesrch" };
    } else {
        options.ajax = { id: "x_process", form: "fmonthly_production_buyerwisesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.monthly_production_buyerwise.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->payment_type->Visible) { // payment_type ?>
<?php
if (!$Page->payment_type->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_payment_type" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->payment_type->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_payment_type" class="ew-search-caption ew-label"><?= $Page->payment_type->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_payment_type" id="z_payment_type" value="=">
</div>
        </div>
        <div id="el_monthly_production_buyerwise_payment_type" class="ew-search-field">
    <select
        id="x_payment_type"
        name="x_payment_type"
        class="form-select ew-select<?= $Page->payment_type->isInvalidClass() ?>"
        <?php if (!$Page->payment_type->IsNativeSelect) { ?>
        data-select2-id="fmonthly_production_buyerwisesrch_x_payment_type"
        <?php } ?>
        data-table="monthly_production_buyerwise"
        data-field="x_payment_type"
        data-value-separator="<?= $Page->payment_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment_type->getPlaceHolder()) ?>"
        <?= $Page->payment_type->editAttributes() ?>>
        <?= $Page->payment_type->selectOptionListHtml("x_payment_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->payment_type->getErrorMessage(false) ?></div>
<?php if (!$Page->payment_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fmonthly_production_buyerwisesrch", function() {
    var options = { name: "x_payment_type", selectId: "fmonthly_production_buyerwisesrch_x_payment_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmonthly_production_buyerwisesrch.lists.payment_type?.lookupOptions.length) {
        options.data = { id: "x_payment_type", form: "fmonthly_production_buyerwisesrch" };
    } else {
        options.ajax = { id: "x_payment_type", form: "fmonthly_production_buyerwisesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.monthly_production_buyerwise.fields.payment_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fmonthly_production_buyerwisesrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fmonthly_production_buyerwisesrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fmonthly_production_buyerwisesrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fmonthly_production_buyerwisesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fmonthly_production_buyerwisesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fmonthly_production_buyerwisesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fmonthly_production_buyerwisesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="monthly_production_buyerwise">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_monthly_production_buyerwise" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_monthly_production_buyerwiselist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->month->Visible) { // month ?>
        <th data-name="month" class="<?= $Page->month->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_month" class="monthly_production_buyerwise_month"><?= $Page->renderFieldHeader($Page->month) ?></div></th>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <th data-name="buyers_id" class="<?= $Page->buyers_id->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_buyers_id" class="monthly_production_buyerwise_buyers_id"><?= $Page->renderFieldHeader($Page->buyers_id) ?></div></th>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
        <th data-name="location" class="<?= $Page->location->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_location" class="monthly_production_buyerwise_location"><?= $Page->renderFieldHeader($Page->location) ?></div></th>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
        <th data-name="category" class="<?= $Page->category->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_category" class="monthly_production_buyerwise_category"><?= $Page->renderFieldHeader($Page->category) ?></div></th>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
        <th data-name="process" class="<?= $Page->process->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_process" class="monthly_production_buyerwise_process"><?= $Page->renderFieldHeader($Page->process) ?></div></th>
<?php } ?>
<?php if ($Page->payment_type->Visible) { // payment_type ?>
        <th data-name="payment_type" class="<?= $Page->payment_type->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_payment_type" class="monthly_production_buyerwise_payment_type"><?= $Page->renderFieldHeader($Page->payment_type) ?></div></th>
<?php } ?>
<?php if ($Page->pcs->Visible) { // pcs ?>
        <th data-name="pcs" class="<?= $Page->pcs->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_pcs" class="monthly_production_buyerwise_pcs"><?= $Page->renderFieldHeader($Page->pcs) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_sqm" class="monthly_production_buyerwise_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_amount" class="monthly_production_buyerwise_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->month->Visible) { // month ?>
        <td data-name="month"<?= $Page->month->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_monthly_production_buyerwise_month" class="el_monthly_production_buyerwise_month">
<span<?= $Page->month->viewAttributes() ?>>
<?= $Page->month->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id"<?= $Page->buyers_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_monthly_production_buyerwise_buyers_id" class="el_monthly_production_buyerwise_buyers_id">
<span<?= $Page->buyers_id->viewAttributes() ?>>
<?= $Page->buyers_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location"<?= $Page->location->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_monthly_production_buyerwise_location" class="el_monthly_production_buyerwise_location">
<span<?= $Page->location->viewAttributes() ?>>
<?= $Page->location->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->category->Visible) { // category ?>
        <td data-name="category"<?= $Page->category->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_monthly_production_buyerwise_category" class="el_monthly_production_buyerwise_category">
<span<?= $Page->category->viewAttributes() ?>>
<?= $Page->category->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process"<?= $Page->process->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_monthly_production_buyerwise_process" class="el_monthly_production_buyerwise_process">
<span<?= $Page->process->viewAttributes() ?>>
<?= $Page->process->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->payment_type->Visible) { // payment_type ?>
        <td data-name="payment_type"<?= $Page->payment_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_monthly_production_buyerwise_payment_type" class="el_monthly_production_buyerwise_payment_type">
<span<?= $Page->payment_type->viewAttributes() ?>>
<?= $Page->payment_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pcs->Visible) { // pcs ?>
        <td data-name="pcs"<?= $Page->pcs->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_monthly_production_buyerwise_pcs" class="el_monthly_production_buyerwise_pcs">
<span<?= $Page->pcs->viewAttributes() ?>>
<?= $Page->pcs->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_monthly_production_buyerwise_sqm" class="el_monthly_production_buyerwise_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_monthly_production_buyerwise_amount" class="el_monthly_production_buyerwise_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?= $Page->amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->month->Visible) { // month ?>
        <td data-name="month" class="<?= $Page->month->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_month" class="monthly_production_buyerwise_month">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id" class="<?= $Page->buyers_id->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_buyers_id" class="monthly_production_buyerwise_buyers_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location" class="<?= $Page->location->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_location" class="monthly_production_buyerwise_location">
        </span></td>
    <?php } ?>
    <?php if ($Page->category->Visible) { // category ?>
        <td data-name="category" class="<?= $Page->category->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_category" class="monthly_production_buyerwise_category">
        </span></td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process" class="<?= $Page->process->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_process" class="monthly_production_buyerwise_process">
        </span></td>
    <?php } ?>
    <?php if ($Page->payment_type->Visible) { // payment_type ?>
        <td data-name="payment_type" class="<?= $Page->payment_type->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_payment_type" class="monthly_production_buyerwise_payment_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->pcs->Visible) { // pcs ?>
        <td data-name="pcs" class="<?= $Page->pcs->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_pcs" class="monthly_production_buyerwise_pcs">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->pcs->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm" class="<?= $Page->sqm->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_sqm" class="monthly_production_buyerwise_sqm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->sqm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount" class="<?= $Page->amount->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_amount" class="monthly_production_buyerwise_amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->amount->ViewValue ?></span>
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("monthly_production_buyerwise");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
