<?php

namespace PHPMaker2024\fibre;

// Page object
$MgsCertificateDataSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { mgs_certificate_data: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmgs_certificate_datasearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmgs_certificate_datasearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["certificate_id", [], fields.certificate_id.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["line_1", [], fields.line_1.isInvalid],
            ["line_2", [], fields.line_2.isInvalid],
            ["e_mail", [], fields.e_mail.isInvalid],
            ["updated", [ew.Validators.integer], fields.updated.isInvalid],
            ["jpg", [], fields.jpg.isInvalid],
            ["pdf", [], fields.pdf.isInvalid],
            ["mail_status", [], fields.mail_status.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "certificate_id": <?= $Page->certificate_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmgs_certificate_datasearch" id="fmgs_certificate_datasearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="mgs_certificate_data">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_mgs_certificate_data_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="mgs_certificate_data" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->certificate_id->Visible) { // certificate_id ?>
    <div id="r_certificate_id" class="row"<?= $Page->certificate_id->rowAttributes() ?>>
        <label for="x_certificate_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_certificate_id"><?= $Page->certificate_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_certificate_id" id="z_certificate_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->certificate_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_mgs_certificate_data_certificate_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_certificate_id"
        name="x_certificate_id"
        class="form-select ew-select<?= $Page->certificate_id->isInvalidClass() ?>"
        <?php if (!$Page->certificate_id->IsNativeSelect) { ?>
        data-select2-id="fmgs_certificate_datasearch_x_certificate_id"
        <?php } ?>
        data-table="mgs_certificate_data"
        data-field="x_certificate_id"
        data-value-separator="<?= $Page->certificate_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->certificate_id->getPlaceHolder()) ?>"
        <?= $Page->certificate_id->editAttributes() ?>>
        <?= $Page->certificate_id->selectOptionListHtml("x_certificate_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->certificate_id->getErrorMessage(false) ?></div>
<?= $Page->certificate_id->Lookup->getParamTag($Page, "p_x_certificate_id") ?>
<?php if (!$Page->certificate_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmgs_certificate_datasearch", function() {
    var options = { name: "x_certificate_id", selectId: "fmgs_certificate_datasearch_x_certificate_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmgs_certificate_datasearch.lists.certificate_id?.lookupOptions.length) {
        options.data = { id: "x_certificate_id", form: "fmgs_certificate_datasearch" };
    } else {
        options.ajax = { id: "x_certificate_id", form: "fmgs_certificate_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.mgs_certificate_data.fields.certificate_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label for="x_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_mgs_certificate_data_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="mgs_certificate_data" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->line_1->Visible) { // line_1 ?>
    <div id="r_line_1" class="row"<?= $Page->line_1->rowAttributes() ?>>
        <label for="x_line_1" class="<?= $Page->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_line_1"><?= $Page->line_1->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_line_1" id="z_line_1" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->line_1->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_mgs_certificate_data_line_1" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->line_1->getInputTextType() ?>" name="x_line_1" id="x_line_1" data-table="mgs_certificate_data" data-field="x_line_1" value="<?= $Page->line_1->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->line_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->line_1->formatPattern()) ?>"<?= $Page->line_1->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->line_1->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->line_2->Visible) { // line_2 ?>
    <div id="r_line_2" class="row"<?= $Page->line_2->rowAttributes() ?>>
        <label for="x_line_2" class="<?= $Page->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_line_2"><?= $Page->line_2->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_line_2" id="z_line_2" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->line_2->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_mgs_certificate_data_line_2" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->line_2->getInputTextType() ?>" name="x_line_2" id="x_line_2" data-table="mgs_certificate_data" data-field="x_line_2" value="<?= $Page->line_2->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->line_2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->line_2->formatPattern()) ?>"<?= $Page->line_2->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->line_2->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->e_mail->Visible) { // e_mail ?>
    <div id="r_e_mail" class="row"<?= $Page->e_mail->rowAttributes() ?>>
        <label for="x_e_mail" class="<?= $Page->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_e_mail"><?= $Page->e_mail->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_e_mail" id="z_e_mail" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->e_mail->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_mgs_certificate_data_e_mail" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->e_mail->getInputTextType() ?>" name="x_e_mail" id="x_e_mail" data-table="mgs_certificate_data" data-field="x_e_mail" value="<?= $Page->e_mail->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->e_mail->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->e_mail->formatPattern()) ?>"<?= $Page->e_mail->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->e_mail->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->updated->Visible) { // updated ?>
    <div id="r_updated" class="row"<?= $Page->updated->rowAttributes() ?>>
        <label for="x_updated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_updated"><?= $Page->updated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_updated" id="z_updated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->updated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_mgs_certificate_data_updated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->updated->getInputTextType() ?>" name="x_updated" id="x_updated" data-table="mgs_certificate_data" data-field="x_updated" value="<?= $Page->updated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->updated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->updated->formatPattern()) ?>"<?= $Page->updated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->updated->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jpg->Visible) { // jpg ?>
    <div id="r_jpg" class="row"<?= $Page->jpg->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_jpg"><?= $Page->jpg->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_jpg" id="z_jpg" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jpg->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_mgs_certificate_data_jpg" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jpg->getInputTextType() ?>" name="x_jpg" id="x_jpg" data-table="mgs_certificate_data" data-field="x_jpg" value="<?= $Page->jpg->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->jpg->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jpg->formatPattern()) ?>"<?= $Page->jpg->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jpg->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pdf->Visible) { // pdf ?>
    <div id="r_pdf" class="row"<?= $Page->pdf->rowAttributes() ?>>
        <label for="x_pdf" class="<?= $Page->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_pdf"><?= $Page->pdf->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pdf" id="z_pdf" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pdf->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_mgs_certificate_data_pdf" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pdf->getInputTextType() ?>" name="x_pdf" id="x_pdf" data-table="mgs_certificate_data" data-field="x_pdf" value="<?= $Page->pdf->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->pdf->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pdf->formatPattern()) ?>"<?= $Page->pdf->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pdf->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mail_status->Visible) { // mail_status ?>
    <div id="r_mail_status" class="row"<?= $Page->mail_status->rowAttributes() ?>>
        <label for="x_mail_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_mail_status"><?= $Page->mail_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mail_status" id="z_mail_status" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mail_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_mgs_certificate_data_mail_status" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mail_status->getInputTextType() ?>" name="x_mail_status" id="x_mail_status" data-table="mgs_certificate_data" data-field="x_mail_status" value="<?= $Page->mail_status->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->mail_status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mail_status->formatPattern()) ?>"<?= $Page->mail_status->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mail_status->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_mgs_certificate_data_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="mgs_certificate_data" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_mgs_certificate_data_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="mgs_certificate_data" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmgs_certificate_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmgs_certificate_datasearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmgs_certificate_datasearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmgs_certificate_datasearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmgs_certificate_datasearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("mgs_certificate_data");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
