<?php

namespace PHPMaker2024\fibre;

// Page object
$MessageTemplateAdminSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { message_template_admin: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmessage_template_adminsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmessage_template_adminsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["description", [], fields.description.isInvalid],
            ["variables", [], fields.variables.isInvalid],
            ["subject", [], fields.subject.isInvalid],
            ["status_email_user", [], fields.status_email_user.isInvalid],
            ["email_template_user", [], fields.email_template_user.isInvalid],
            ["mail_to_office", [], fields.mail_to_office.isInvalid],
            ["status_email_office", [], fields.status_email_office.isInvalid],
            ["email_template_office", [], fields.email_template_office.isInvalid],
            ["status_sms_user", [], fields.status_sms_user.isInvalid],
            ["sms_template_user", [], fields.sms_template_user.isInvalid],
            ["sms_template_user_id", [], fields.sms_template_user_id.isInvalid],
            ["status_sms_office", [], fields.status_sms_office.isInvalid],
            ["sms_to_office", [], fields.sms_to_office.isInvalid],
            ["sms_template_office", [], fields.sms_template_office.isInvalid],
            ["sms_template_office_id", [], fields.sms_template_office_id.isInvalid],
            ["wa_status_user", [], fields.wa_status_user.isInvalid],
            ["wa_type_user", [], fields.wa_type_user.isInvalid],
            ["wa_template_user", [], fields.wa_template_user.isInvalid],
            ["wa_status_office", [], fields.wa_status_office.isInvalid],
            ["wa_type_office", [], fields.wa_type_office.isInvalid],
            ["wa_to_office", [], fields.wa_to_office.isInvalid],
            ["wa_template_office", [], fields.wa_template_office.isInvalid],
            ["wa_id", [], fields.wa_id.isInvalid],
            ["notification_status_user", [], fields.notification_status_user.isInvalid],
            ["notification_template_user", [], fields.notification_template_user.isInvalid],
            ["notification_status_office", [], fields.notification_status_office.isInvalid],
            ["notification_to_office", [], fields.notification_to_office.isInvalid],
            ["notification_template_office", [], fields.notification_template_office.isInvalid],
            ["code", [], fields.code.isInvalid],
            ["_visible", [], fields._visible.isInvalid],
            ["cron", [], fields.cron.isInvalid],
            ["next_cycle", [ew.Validators.datetime(fields.next_cycle.clientFormatPattern)], fields.next_cycle.isInvalid],
            ["delay", [ew.Validators.integer], fields.delay.isInvalid],
            ["delay_method", [], fields.delay_method.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["operator_admin", [ew.Validators.integer], fields.operator_admin.isInvalid],
            ["datetime_admin", [ew.Validators.datetime(fields.datetime_admin.clientFormatPattern)], fields.datetime_admin.isInvalid],
            ["company_id", [], fields.company_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "status_email_user": <?= $Page->status_email_user->toClientList($Page) ?>,
            "status_email_office": <?= $Page->status_email_office->toClientList($Page) ?>,
            "status_sms_user": <?= $Page->status_sms_user->toClientList($Page) ?>,
            "status_sms_office": <?= $Page->status_sms_office->toClientList($Page) ?>,
            "wa_status_user": <?= $Page->wa_status_user->toClientList($Page) ?>,
            "wa_type_user": <?= $Page->wa_type_user->toClientList($Page) ?>,
            "wa_status_office": <?= $Page->wa_status_office->toClientList($Page) ?>,
            "wa_type_office": <?= $Page->wa_type_office->toClientList($Page) ?>,
            "wa_id": <?= $Page->wa_id->toClientList($Page) ?>,
            "notification_status_user": <?= $Page->notification_status_user->toClientList($Page) ?>,
            "notification_status_office": <?= $Page->notification_status_office->toClientList($Page) ?>,
            "notification_to_office": <?= $Page->notification_to_office->toClientList($Page) ?>,
            "_visible": <?= $Page->_visible->toClientList($Page) ?>,
            "cron": <?= $Page->cron->toClientList($Page) ?>,
            "delay_method": <?= $Page->delay_method->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmessage_template_adminsearch" id="fmessage_template_adminsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="message_template_admin">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="message_template_admin" data-field="x_id" value="<?= $Page->id->EditValue ?>" data-page="0" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_grp"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_grp"
        data-page="0"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_grp", selectId: "fmessage_template_adminsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description" class="row"<?= $Page->description->rowAttributes() ?>>
        <label for="x_description" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_description"><?= $Page->description->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description" id="z_description" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="message_template_admin" data-field="x_description" value="<?= $Page->description->EditValue ?>" data-page="0" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->variables->Visible) { // variables ?>
    <div id="r_variables" class="row"<?= $Page->variables->rowAttributes() ?>>
        <label for="x_variables" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_variables"><?= $Page->variables->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_variables" id="z_variables" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->variables->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_variables" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->variables->getInputTextType() ?>" name="x_variables" id="x_variables" data-table="message_template_admin" data-field="x_variables" value="<?= $Page->variables->EditValue ?>" data-page="0" maxlength="65535" placeholder="<?= HtmlEncode($Page->variables->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->variables->formatPattern()) ?>"<?= $Page->variables->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->variables->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="ew-nav<?= $Page->MultiPages->containerClasses() ?>" id="pages_MessageTemplateAdminSearch"><!-- multi-page tabs -->
    <ul class="<?= $Page->MultiPages->navClasses() ?>" role="tablist">
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(1) ?>" data-bs-target="#tab_message_template_admin1" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_message_template_admin1" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>"><?= $Page->pageCaption(1) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(2) ?>" data-bs-target="#tab_message_template_admin2" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_message_template_admin2" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>"><?= $Page->pageCaption(2) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(3) ?>" data-bs-target="#tab_message_template_admin3" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_message_template_admin3" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>"><?= $Page->pageCaption(3) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(4) ?>" data-bs-target="#tab_message_template_admin4" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_message_template_admin4" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(4)) ?>"><?= $Page->pageCaption(4) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(5) ?>" data-bs-target="#tab_message_template_admin5" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_message_template_admin5" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(5)) ?>"><?= $Page->pageCaption(5) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(6) ?>" data-bs-target="#tab_message_template_admin6" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_message_template_admin6" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(6)) ?>"><?= $Page->pageCaption(6) ?></button></li>
    </ul>
    <div class="<?= $Page->MultiPages->tabContentClasses() ?>"><!-- multi-page tabs .tab-content -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(1) ?>" id="tab_message_template_admin1" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->subject->Visible) { // subject ?>
    <div id="r_subject" class="row"<?= $Page->subject->rowAttributes() ?>>
        <label for="x_subject" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_subject"><?= $Page->subject->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_subject" id="z_subject" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->subject->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_subject" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->subject->getInputTextType() ?>" name="x_subject" id="x_subject" data-table="message_template_admin" data-field="x_subject" value="<?= $Page->subject->EditValue ?>" data-page="1" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->subject->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->subject->formatPattern()) ?>"<?= $Page->subject->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->subject->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status_email_user->Visible) { // status_email_user ?>
    <div id="r_status_email_user" class="row"<?= $Page->status_email_user->rowAttributes() ?>>
        <label for="x_status_email_user" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_status_email_user"><?= $Page->status_email_user->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status_email_user" id="z_status_email_user" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status_email_user->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_status_email_user" class="ew-search-field ew-search-field-single">
    <select
        id="x_status_email_user"
        name="x_status_email_user"
        class="form-select ew-select<?= $Page->status_email_user->isInvalidClass() ?>"
        <?php if (!$Page->status_email_user->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_status_email_user"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_status_email_user"
        data-page="1"
        data-value-separator="<?= $Page->status_email_user->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status_email_user->getPlaceHolder()) ?>"
        <?= $Page->status_email_user->editAttributes() ?>>
        <?= $Page->status_email_user->selectOptionListHtml("x_status_email_user") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status_email_user->getErrorMessage(false) ?></div>
<?php if (!$Page->status_email_user->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_status_email_user", selectId: "fmessage_template_adminsearch_x_status_email_user" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.status_email_user?.lookupOptions.length) {
        options.data = { id: "x_status_email_user", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_status_email_user", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.status_email_user.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->email_template_user->Visible) { // email_template_user ?>
    <div id="r_email_template_user" class="row"<?= $Page->email_template_user->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_email_template_user"><?= $Page->email_template_user->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_email_template_user" id="z_email_template_user" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->email_template_user->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_email_template_user" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->email_template_user->getInputTextType() ?>" name="x_email_template_user" id="x_email_template_user" data-table="message_template_admin" data-field="x_email_template_user" value="<?= $Page->email_template_user->EditValue ?>" data-page="1" maxlength="65535" placeholder="<?= HtmlEncode($Page->email_template_user->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->email_template_user->formatPattern()) ?>"<?= $Page->email_template_user->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->email_template_user->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mail_to_office->Visible) { // mail_to_office ?>
    <div id="r_mail_to_office" class="row"<?= $Page->mail_to_office->rowAttributes() ?>>
        <label for="x_mail_to_office" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_mail_to_office"><?= $Page->mail_to_office->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mail_to_office" id="z_mail_to_office" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mail_to_office->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_mail_to_office" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mail_to_office->getInputTextType() ?>" name="x_mail_to_office" id="x_mail_to_office" data-table="message_template_admin" data-field="x_mail_to_office" value="<?= $Page->mail_to_office->EditValue ?>" data-page="1" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->mail_to_office->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mail_to_office->formatPattern()) ?>"<?= $Page->mail_to_office->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mail_to_office->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status_email_office->Visible) { // status_email_office ?>
    <div id="r_status_email_office" class="row"<?= $Page->status_email_office->rowAttributes() ?>>
        <label for="x_status_email_office" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_status_email_office"><?= $Page->status_email_office->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status_email_office" id="z_status_email_office" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status_email_office->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_status_email_office" class="ew-search-field ew-search-field-single">
    <select
        id="x_status_email_office"
        name="x_status_email_office"
        class="form-select ew-select<?= $Page->status_email_office->isInvalidClass() ?>"
        <?php if (!$Page->status_email_office->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_status_email_office"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_status_email_office"
        data-page="1"
        data-value-separator="<?= $Page->status_email_office->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status_email_office->getPlaceHolder()) ?>"
        <?= $Page->status_email_office->editAttributes() ?>>
        <?= $Page->status_email_office->selectOptionListHtml("x_status_email_office") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status_email_office->getErrorMessage(false) ?></div>
<?php if (!$Page->status_email_office->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_status_email_office", selectId: "fmessage_template_adminsearch_x_status_email_office" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.status_email_office?.lookupOptions.length) {
        options.data = { id: "x_status_email_office", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_status_email_office", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.status_email_office.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->email_template_office->Visible) { // email_template_office ?>
    <div id="r_email_template_office" class="row"<?= $Page->email_template_office->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_email_template_office"><?= $Page->email_template_office->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_email_template_office" id="z_email_template_office" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->email_template_office->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_email_template_office" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->email_template_office->getInputTextType() ?>" name="x_email_template_office" id="x_email_template_office" data-table="message_template_admin" data-field="x_email_template_office" value="<?= $Page->email_template_office->EditValue ?>" data-page="1" maxlength="65535" placeholder="<?= HtmlEncode($Page->email_template_office->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->email_template_office->formatPattern()) ?>"<?= $Page->email_template_office->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->email_template_office->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_company_id"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_company_id"
        data-page="1"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_company_id", selectId: "fmessage_template_adminsearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(2) ?>" id="tab_message_template_admin2" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->status_sms_user->Visible) { // status_sms_user ?>
    <div id="r_status_sms_user" class="row"<?= $Page->status_sms_user->rowAttributes() ?>>
        <label for="x_status_sms_user" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_status_sms_user"><?= $Page->status_sms_user->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status_sms_user" id="z_status_sms_user" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status_sms_user->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_status_sms_user" class="ew-search-field ew-search-field-single">
    <select
        id="x_status_sms_user"
        name="x_status_sms_user"
        class="form-select ew-select<?= $Page->status_sms_user->isInvalidClass() ?>"
        <?php if (!$Page->status_sms_user->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_status_sms_user"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_status_sms_user"
        data-page="2"
        data-value-separator="<?= $Page->status_sms_user->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status_sms_user->getPlaceHolder()) ?>"
        <?= $Page->status_sms_user->editAttributes() ?>>
        <?= $Page->status_sms_user->selectOptionListHtml("x_status_sms_user") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status_sms_user->getErrorMessage(false) ?></div>
<?php if (!$Page->status_sms_user->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_status_sms_user", selectId: "fmessage_template_adminsearch_x_status_sms_user" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.status_sms_user?.lookupOptions.length) {
        options.data = { id: "x_status_sms_user", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_status_sms_user", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.status_sms_user.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sms_template_user->Visible) { // sms_template_user ?>
    <div id="r_sms_template_user" class="row"<?= $Page->sms_template_user->rowAttributes() ?>>
        <label for="x_sms_template_user" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_sms_template_user"><?= $Page->sms_template_user->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_sms_template_user" id="z_sms_template_user" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sms_template_user->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_sms_template_user" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sms_template_user->getInputTextType() ?>" name="x_sms_template_user" id="x_sms_template_user" data-table="message_template_admin" data-field="x_sms_template_user" value="<?= $Page->sms_template_user->EditValue ?>" data-page="2" maxlength="250" placeholder="<?= HtmlEncode($Page->sms_template_user->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sms_template_user->formatPattern()) ?>"<?= $Page->sms_template_user->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sms_template_user->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sms_template_user_id->Visible) { // sms_template_user_id ?>
    <div id="r_sms_template_user_id" class="row"<?= $Page->sms_template_user_id->rowAttributes() ?>>
        <label for="x_sms_template_user_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_sms_template_user_id"><?= $Page->sms_template_user_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_sms_template_user_id" id="z_sms_template_user_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sms_template_user_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_sms_template_user_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sms_template_user_id->getInputTextType() ?>" name="x_sms_template_user_id" id="x_sms_template_user_id" data-table="message_template_admin" data-field="x_sms_template_user_id" value="<?= $Page->sms_template_user_id->EditValue ?>" data-page="2" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->sms_template_user_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sms_template_user_id->formatPattern()) ?>"<?= $Page->sms_template_user_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sms_template_user_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status_sms_office->Visible) { // status_sms_office ?>
    <div id="r_status_sms_office" class="row"<?= $Page->status_sms_office->rowAttributes() ?>>
        <label for="x_status_sms_office" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_status_sms_office"><?= $Page->status_sms_office->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status_sms_office" id="z_status_sms_office" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status_sms_office->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_status_sms_office" class="ew-search-field ew-search-field-single">
    <select
        id="x_status_sms_office"
        name="x_status_sms_office"
        class="form-select ew-select<?= $Page->status_sms_office->isInvalidClass() ?>"
        <?php if (!$Page->status_sms_office->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_status_sms_office"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_status_sms_office"
        data-page="2"
        data-value-separator="<?= $Page->status_sms_office->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status_sms_office->getPlaceHolder()) ?>"
        <?= $Page->status_sms_office->editAttributes() ?>>
        <?= $Page->status_sms_office->selectOptionListHtml("x_status_sms_office") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status_sms_office->getErrorMessage(false) ?></div>
<?php if (!$Page->status_sms_office->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_status_sms_office", selectId: "fmessage_template_adminsearch_x_status_sms_office" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.status_sms_office?.lookupOptions.length) {
        options.data = { id: "x_status_sms_office", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_status_sms_office", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.status_sms_office.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sms_to_office->Visible) { // sms_to_office ?>
    <div id="r_sms_to_office" class="row"<?= $Page->sms_to_office->rowAttributes() ?>>
        <label for="x_sms_to_office" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_sms_to_office"><?= $Page->sms_to_office->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_sms_to_office" id="z_sms_to_office" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sms_to_office->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_sms_to_office" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sms_to_office->getInputTextType() ?>" name="x_sms_to_office" id="x_sms_to_office" data-table="message_template_admin" data-field="x_sms_to_office" value="<?= $Page->sms_to_office->EditValue ?>" data-page="2" size="30" maxlength="44" placeholder="<?= HtmlEncode($Page->sms_to_office->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sms_to_office->formatPattern()) ?>"<?= $Page->sms_to_office->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sms_to_office->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sms_template_office->Visible) { // sms_template_office ?>
    <div id="r_sms_template_office" class="row"<?= $Page->sms_template_office->rowAttributes() ?>>
        <label for="x_sms_template_office" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_sms_template_office"><?= $Page->sms_template_office->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_sms_template_office" id="z_sms_template_office" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sms_template_office->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_sms_template_office" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sms_template_office->getInputTextType() ?>" name="x_sms_template_office" id="x_sms_template_office" data-table="message_template_admin" data-field="x_sms_template_office" value="<?= $Page->sms_template_office->EditValue ?>" data-page="2" maxlength="250" placeholder="<?= HtmlEncode($Page->sms_template_office->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sms_template_office->formatPattern()) ?>"<?= $Page->sms_template_office->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sms_template_office->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sms_template_office_id->Visible) { // sms_template_office_id ?>
    <div id="r_sms_template_office_id" class="row"<?= $Page->sms_template_office_id->rowAttributes() ?>>
        <label for="x_sms_template_office_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_sms_template_office_id"><?= $Page->sms_template_office_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_sms_template_office_id" id="z_sms_template_office_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sms_template_office_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_sms_template_office_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sms_template_office_id->getInputTextType() ?>" name="x_sms_template_office_id" id="x_sms_template_office_id" data-table="message_template_admin" data-field="x_sms_template_office_id" value="<?= $Page->sms_template_office_id->EditValue ?>" data-page="2" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->sms_template_office_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sms_template_office_id->formatPattern()) ?>"<?= $Page->sms_template_office_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sms_template_office_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(3) ?>" id="tab_message_template_admin3" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->notification_status_user->Visible) { // notification_status_user ?>
    <div id="r_notification_status_user" class="row"<?= $Page->notification_status_user->rowAttributes() ?>>
        <label for="x_notification_status_user" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_notification_status_user"><?= $Page->notification_status_user->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_notification_status_user" id="z_notification_status_user" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->notification_status_user->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_notification_status_user" class="ew-search-field ew-search-field-single">
    <select
        id="x_notification_status_user"
        name="x_notification_status_user"
        class="form-select ew-select<?= $Page->notification_status_user->isInvalidClass() ?>"
        <?php if (!$Page->notification_status_user->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_notification_status_user"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_notification_status_user"
        data-page="3"
        data-value-separator="<?= $Page->notification_status_user->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->notification_status_user->getPlaceHolder()) ?>"
        <?= $Page->notification_status_user->editAttributes() ?>>
        <?= $Page->notification_status_user->selectOptionListHtml("x_notification_status_user") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->notification_status_user->getErrorMessage(false) ?></div>
<?php if (!$Page->notification_status_user->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_notification_status_user", selectId: "fmessage_template_adminsearch_x_notification_status_user" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.notification_status_user?.lookupOptions.length) {
        options.data = { id: "x_notification_status_user", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_notification_status_user", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.notification_status_user.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->notification_template_user->Visible) { // notification_template_user ?>
    <div id="r_notification_template_user" class="row"<?= $Page->notification_template_user->rowAttributes() ?>>
        <label for="x_notification_template_user" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_notification_template_user"><?= $Page->notification_template_user->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_notification_template_user" id="z_notification_template_user" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->notification_template_user->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_notification_template_user" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->notification_template_user->getInputTextType() ?>" name="x_notification_template_user" id="x_notification_template_user" data-table="message_template_admin" data-field="x_notification_template_user" value="<?= $Page->notification_template_user->EditValue ?>" data-page="3" maxlength="255" placeholder="<?= HtmlEncode($Page->notification_template_user->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->notification_template_user->formatPattern()) ?>"<?= $Page->notification_template_user->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->notification_template_user->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->notification_status_office->Visible) { // notification_status_office ?>
    <div id="r_notification_status_office" class="row"<?= $Page->notification_status_office->rowAttributes() ?>>
        <label for="x_notification_status_office" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_notification_status_office"><?= $Page->notification_status_office->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_notification_status_office" id="z_notification_status_office" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->notification_status_office->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_notification_status_office" class="ew-search-field ew-search-field-single">
    <select
        id="x_notification_status_office"
        name="x_notification_status_office"
        class="form-select ew-select<?= $Page->notification_status_office->isInvalidClass() ?>"
        <?php if (!$Page->notification_status_office->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_notification_status_office"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_notification_status_office"
        data-page="3"
        data-value-separator="<?= $Page->notification_status_office->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->notification_status_office->getPlaceHolder()) ?>"
        <?= $Page->notification_status_office->editAttributes() ?>>
        <?= $Page->notification_status_office->selectOptionListHtml("x_notification_status_office") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->notification_status_office->getErrorMessage(false) ?></div>
<?php if (!$Page->notification_status_office->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_notification_status_office", selectId: "fmessage_template_adminsearch_x_notification_status_office" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.notification_status_office?.lookupOptions.length) {
        options.data = { id: "x_notification_status_office", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_notification_status_office", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.notification_status_office.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->notification_to_office->Visible) { // notification_to_office ?>
    <div id="r_notification_to_office" class="row"<?= $Page->notification_to_office->rowAttributes() ?>>
        <label for="x_notification_to_office" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_notification_to_office"><?= $Page->notification_to_office->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_notification_to_office" id="z_notification_to_office" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->notification_to_office->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_notification_to_office" class="ew-search-field ew-search-field-single">
    <select
        id="x_notification_to_office[]"
        name="x_notification_to_office[]"
        class="form-select ew-select<?= $Page->notification_to_office->isInvalidClass() ?>"
        <?php if (!$Page->notification_to_office->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_notification_to_office[]"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_notification_to_office"
        multiple
        size="1"
        data-page="3"
        data-value-separator="<?= $Page->notification_to_office->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->notification_to_office->getPlaceHolder()) ?>"
        <?= $Page->notification_to_office->editAttributes() ?>>
        <?= $Page->notification_to_office->selectOptionListHtml("x_notification_to_office[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->notification_to_office->getErrorMessage(false) ?></div>
<?= $Page->notification_to_office->Lookup->getParamTag($Page, "p_x_notification_to_office") ?>
<?php if (!$Page->notification_to_office->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_notification_to_office[]", selectId: "fmessage_template_adminsearch_x_notification_to_office[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.notification_to_office?.lookupOptions.length) {
        options.data = { id: "x_notification_to_office[]", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_notification_to_office[]", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.notification_to_office.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->notification_template_office->Visible) { // notification_template_office ?>
    <div id="r_notification_template_office" class="row"<?= $Page->notification_template_office->rowAttributes() ?>>
        <label for="x_notification_template_office" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_notification_template_office"><?= $Page->notification_template_office->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_notification_template_office" id="z_notification_template_office" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->notification_template_office->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_notification_template_office" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->notification_template_office->getInputTextType() ?>" name="x_notification_template_office" id="x_notification_template_office" data-table="message_template_admin" data-field="x_notification_template_office" value="<?= $Page->notification_template_office->EditValue ?>" data-page="3" maxlength="255" placeholder="<?= HtmlEncode($Page->notification_template_office->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->notification_template_office->formatPattern()) ?>"<?= $Page->notification_template_office->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->notification_template_office->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(4) ?>" id="tab_message_template_admin4" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->wa_status_user->Visible) { // wa_status_user ?>
    <div id="r_wa_status_user" class="row"<?= $Page->wa_status_user->rowAttributes() ?>>
        <label for="x_wa_status_user" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_status_user"><?= $Page->wa_status_user->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_wa_status_user" id="z_wa_status_user" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->wa_status_user->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_wa_status_user" class="ew-search-field ew-search-field-single">
    <select
        id="x_wa_status_user"
        name="x_wa_status_user"
        class="form-select ew-select<?= $Page->wa_status_user->isInvalidClass() ?>"
        <?php if (!$Page->wa_status_user->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_wa_status_user"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_wa_status_user"
        data-page="4"
        data-value-separator="<?= $Page->wa_status_user->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->wa_status_user->getPlaceHolder()) ?>"
        <?= $Page->wa_status_user->editAttributes() ?>>
        <?= $Page->wa_status_user->selectOptionListHtml("x_wa_status_user") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->wa_status_user->getErrorMessage(false) ?></div>
<?php if (!$Page->wa_status_user->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_wa_status_user", selectId: "fmessage_template_adminsearch_x_wa_status_user" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.wa_status_user?.lookupOptions.length) {
        options.data = { id: "x_wa_status_user", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_wa_status_user", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.wa_status_user.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->wa_type_user->Visible) { // wa_type_user ?>
    <div id="r_wa_type_user" class="row"<?= $Page->wa_type_user->rowAttributes() ?>>
        <label for="x_wa_type_user" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_type_user"><?= $Page->wa_type_user->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_wa_type_user" id="z_wa_type_user" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->wa_type_user->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_wa_type_user" class="ew-search-field ew-search-field-single">
    <select
        id="x_wa_type_user"
        name="x_wa_type_user"
        class="form-select ew-select<?= $Page->wa_type_user->isInvalidClass() ?>"
        <?php if (!$Page->wa_type_user->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_wa_type_user"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_wa_type_user"
        data-page="4"
        data-value-separator="<?= $Page->wa_type_user->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->wa_type_user->getPlaceHolder()) ?>"
        <?= $Page->wa_type_user->editAttributes() ?>>
        <?= $Page->wa_type_user->selectOptionListHtml("x_wa_type_user") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->wa_type_user->getErrorMessage(false) ?></div>
<?= $Page->wa_type_user->Lookup->getParamTag($Page, "p_x_wa_type_user") ?>
<?php if (!$Page->wa_type_user->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_wa_type_user", selectId: "fmessage_template_adminsearch_x_wa_type_user" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.wa_type_user?.lookupOptions.length) {
        options.data = { id: "x_wa_type_user", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_wa_type_user", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.wa_type_user.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->wa_template_user->Visible) { // wa_template_user ?>
    <div id="r_wa_template_user" class="row"<?= $Page->wa_template_user->rowAttributes() ?>>
        <label for="x_wa_template_user" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_template_user"><?= $Page->wa_template_user->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_wa_template_user" id="z_wa_template_user" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->wa_template_user->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_wa_template_user" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->wa_template_user->getInputTextType() ?>" name="x_wa_template_user" id="x_wa_template_user" data-table="message_template_admin" data-field="x_wa_template_user" value="<?= $Page->wa_template_user->EditValue ?>" data-page="4" size="35" maxlength="1000" placeholder="<?= HtmlEncode($Page->wa_template_user->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->wa_template_user->formatPattern()) ?>"<?= $Page->wa_template_user->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->wa_template_user->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->wa_status_office->Visible) { // wa_status_office ?>
    <div id="r_wa_status_office" class="row"<?= $Page->wa_status_office->rowAttributes() ?>>
        <label for="x_wa_status_office" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_status_office"><?= $Page->wa_status_office->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_wa_status_office" id="z_wa_status_office" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->wa_status_office->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_wa_status_office" class="ew-search-field ew-search-field-single">
    <select
        id="x_wa_status_office"
        name="x_wa_status_office"
        class="form-select ew-select<?= $Page->wa_status_office->isInvalidClass() ?>"
        <?php if (!$Page->wa_status_office->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_wa_status_office"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_wa_status_office"
        data-page="4"
        data-value-separator="<?= $Page->wa_status_office->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->wa_status_office->getPlaceHolder()) ?>"
        <?= $Page->wa_status_office->editAttributes() ?>>
        <?= $Page->wa_status_office->selectOptionListHtml("x_wa_status_office") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->wa_status_office->getErrorMessage(false) ?></div>
<?php if (!$Page->wa_status_office->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_wa_status_office", selectId: "fmessage_template_adminsearch_x_wa_status_office" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.wa_status_office?.lookupOptions.length) {
        options.data = { id: "x_wa_status_office", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_wa_status_office", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.wa_status_office.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->wa_type_office->Visible) { // wa_type_office ?>
    <div id="r_wa_type_office" class="row"<?= $Page->wa_type_office->rowAttributes() ?>>
        <label for="x_wa_type_office" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_type_office"><?= $Page->wa_type_office->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_wa_type_office" id="z_wa_type_office" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->wa_type_office->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_wa_type_office" class="ew-search-field ew-search-field-single">
    <select
        id="x_wa_type_office"
        name="x_wa_type_office"
        class="form-select ew-select<?= $Page->wa_type_office->isInvalidClass() ?>"
        <?php if (!$Page->wa_type_office->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_wa_type_office"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_wa_type_office"
        data-page="4"
        data-value-separator="<?= $Page->wa_type_office->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->wa_type_office->getPlaceHolder()) ?>"
        <?= $Page->wa_type_office->editAttributes() ?>>
        <?= $Page->wa_type_office->selectOptionListHtml("x_wa_type_office") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->wa_type_office->getErrorMessage(false) ?></div>
<?= $Page->wa_type_office->Lookup->getParamTag($Page, "p_x_wa_type_office") ?>
<?php if (!$Page->wa_type_office->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_wa_type_office", selectId: "fmessage_template_adminsearch_x_wa_type_office" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.wa_type_office?.lookupOptions.length) {
        options.data = { id: "x_wa_type_office", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_wa_type_office", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.wa_type_office.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->wa_to_office->Visible) { // wa_to_office ?>
    <div id="r_wa_to_office" class="row"<?= $Page->wa_to_office->rowAttributes() ?>>
        <label for="x_wa_to_office" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_to_office"><?= $Page->wa_to_office->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_wa_to_office" id="z_wa_to_office" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->wa_to_office->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_wa_to_office" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->wa_to_office->getInputTextType() ?>" name="x_wa_to_office" id="x_wa_to_office" data-table="message_template_admin" data-field="x_wa_to_office" value="<?= $Page->wa_to_office->EditValue ?>" data-page="4" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->wa_to_office->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->wa_to_office->formatPattern()) ?>"<?= $Page->wa_to_office->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->wa_to_office->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->wa_template_office->Visible) { // wa_template_office ?>
    <div id="r_wa_template_office" class="row"<?= $Page->wa_template_office->rowAttributes() ?>>
        <label for="x_wa_template_office" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_template_office"><?= $Page->wa_template_office->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_wa_template_office" id="z_wa_template_office" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->wa_template_office->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_wa_template_office" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->wa_template_office->getInputTextType() ?>" name="x_wa_template_office" id="x_wa_template_office" data-table="message_template_admin" data-field="x_wa_template_office" value="<?= $Page->wa_template_office->EditValue ?>" data-page="4" size="35" maxlength="1000" placeholder="<?= HtmlEncode($Page->wa_template_office->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->wa_template_office->formatPattern()) ?>"<?= $Page->wa_template_office->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->wa_template_office->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->wa_id->Visible) { // wa_id ?>
    <div id="r_wa_id" class="row"<?= $Page->wa_id->rowAttributes() ?>>
        <label for="x_wa_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_id"><?= $Page->wa_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_wa_id" id="z_wa_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->wa_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_wa_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_wa_id"
        name="x_wa_id"
        class="form-select ew-select<?= $Page->wa_id->isInvalidClass() ?>"
        <?php if (!$Page->wa_id->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_wa_id"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_wa_id"
        data-page="4"
        data-value-separator="<?= $Page->wa_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->wa_id->getPlaceHolder()) ?>"
        <?= $Page->wa_id->editAttributes() ?>>
        <?= $Page->wa_id->selectOptionListHtml("x_wa_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->wa_id->getErrorMessage(false) ?></div>
<?= $Page->wa_id->Lookup->getParamTag($Page, "p_x_wa_id") ?>
<?php if (!$Page->wa_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_wa_id", selectId: "fmessage_template_adminsearch_x_wa_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.wa_id?.lookupOptions.length) {
        options.data = { id: "x_wa_id", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_wa_id", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.wa_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(5) ?>" id="tab_message_template_admin5" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label for="x_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_code"><?= $Page->code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_code" id="z_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="message_template_admin" data-field="x_code" value="<?= $Page->code->EditValue ?>" data-page="5" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(6) ?>" id="tab_message_template_admin6" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->_visible->Visible) { // visible ?>
    <div id="r__visible" class="row"<?= $Page->_visible->rowAttributes() ?>>
        <label for="x__visible" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin__visible"><?= $Page->_visible->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__visible" id="z__visible" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_visible->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin__visible" class="ew-search-field ew-search-field-single">
    <select
        id="x__visible"
        name="x__visible"
        class="form-select ew-select<?= $Page->_visible->isInvalidClass() ?>"
        <?php if (!$Page->_visible->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x__visible"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x__visible"
        data-page="6"
        data-value-separator="<?= $Page->_visible->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_visible->getPlaceHolder()) ?>"
        <?= $Page->_visible->editAttributes() ?>>
        <?= $Page->_visible->selectOptionListHtml("x__visible") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_visible->getErrorMessage(false) ?></div>
<?php if (!$Page->_visible->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x__visible", selectId: "fmessage_template_adminsearch_x__visible" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists._visible?.lookupOptions.length) {
        options.data = { id: "x__visible", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x__visible", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields._visible.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cron->Visible) { // cron ?>
    <div id="r_cron" class="row"<?= $Page->cron->rowAttributes() ?>>
        <label for="x_cron" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_cron"><?= $Page->cron->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cron" id="z_cron" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cron->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_cron" class="ew-search-field ew-search-field-single">
    <select
        id="x_cron"
        name="x_cron"
        class="form-select ew-select<?= $Page->cron->isInvalidClass() ?>"
        <?php if (!$Page->cron->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_cron"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_cron"
        data-page="6"
        data-value-separator="<?= $Page->cron->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->cron->getPlaceHolder()) ?>"
        <?= $Page->cron->editAttributes() ?>>
        <?= $Page->cron->selectOptionListHtml("x_cron") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->cron->getErrorMessage(false) ?></div>
<?php if (!$Page->cron->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_cron", selectId: "fmessage_template_adminsearch_x_cron" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.cron?.lookupOptions.length) {
        options.data = { id: "x_cron", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_cron", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.cron.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->next_cycle->Visible) { // next_cycle ?>
    <div id="r_next_cycle" class="row"<?= $Page->next_cycle->rowAttributes() ?>>
        <label for="x_next_cycle" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_next_cycle"><?= $Page->next_cycle->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_next_cycle" id="z_next_cycle" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->next_cycle->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_next_cycle" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->next_cycle->getInputTextType() ?>" name="x_next_cycle" id="x_next_cycle" data-table="message_template_admin" data-field="x_next_cycle" value="<?= $Page->next_cycle->EditValue ?>" data-page="6" placeholder="<?= HtmlEncode($Page->next_cycle->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->next_cycle->formatPattern()) ?>"<?= $Page->next_cycle->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->next_cycle->getErrorMessage(false) ?></div>
<?php if (!$Page->next_cycle->ReadOnly && !$Page->next_cycle->Disabled && !isset($Page->next_cycle->EditAttrs["readonly"]) && !isset($Page->next_cycle->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmessage_template_adminsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmessage_template_adminsearch", "x_next_cycle", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delay->Visible) { // delay ?>
    <div id="r_delay" class="row"<?= $Page->delay->rowAttributes() ?>>
        <label for="x_delay" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_delay"><?= $Page->delay->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_delay" id="z_delay" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delay->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_delay" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->delay->getInputTextType() ?>" name="x_delay" id="x_delay" data-table="message_template_admin" data-field="x_delay" value="<?= $Page->delay->EditValue ?>" data-page="6" size="30" placeholder="<?= HtmlEncode($Page->delay->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->delay->formatPattern()) ?>"<?= $Page->delay->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->delay->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delay_method->Visible) { // delay_method ?>
    <div id="r_delay_method" class="row"<?= $Page->delay_method->rowAttributes() ?>>
        <label for="x_delay_method" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_delay_method"><?= $Page->delay_method->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_delay_method" id="z_delay_method" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delay_method->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_delay_method" class="ew-search-field ew-search-field-single">
    <select
        id="x_delay_method"
        name="x_delay_method"
        class="form-select ew-select<?= $Page->delay_method->isInvalidClass() ?>"
        <?php if (!$Page->delay_method->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsearch_x_delay_method"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_delay_method"
        data-page="6"
        data-value-separator="<?= $Page->delay_method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->delay_method->getPlaceHolder()) ?>"
        <?= $Page->delay_method->editAttributes() ?>>
        <?= $Page->delay_method->selectOptionListHtml("x_delay_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->delay_method->getErrorMessage(false) ?></div>
<?php if (!$Page->delay_method->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsearch", function() {
    var options = { name: "x_delay_method", selectId: "fmessage_template_adminsearch_x_delay_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsearch.lists.delay_method?.lookupOptions.length) {
        options.data = { id: "x_delay_method", form: "fmessage_template_adminsearch" };
    } else {
        options.ajax = { id: "x_delay_method", form: "fmessage_template_adminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.delay_method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="message_template_admin" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" data-page="6" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="message_template_admin" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" data-page="6" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator_admin->Visible) { // operator_admin ?>
    <div id="r_operator_admin" class="row"<?= $Page->operator_admin->rowAttributes() ?>>
        <label for="x_operator_admin" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_operator_admin"><?= $Page->operator_admin->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator_admin" id="z_operator_admin" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator_admin->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_operator_admin" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator_admin->getInputTextType() ?>" name="x_operator_admin" id="x_operator_admin" data-table="message_template_admin" data-field="x_operator_admin" value="<?= $Page->operator_admin->EditValue ?>" data-page="6" size="30" placeholder="<?= HtmlEncode($Page->operator_admin->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator_admin->formatPattern()) ?>"<?= $Page->operator_admin->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator_admin->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime_admin->Visible) { // datetime_admin ?>
    <div id="r_datetime_admin" class="row"<?= $Page->datetime_admin->rowAttributes() ?>>
        <label for="x_datetime_admin" class="<?= $Page->LeftColumnClass ?>"><span id="elh_message_template_admin_datetime_admin"><?= $Page->datetime_admin->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime_admin" id="z_datetime_admin" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime_admin->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_message_template_admin_datetime_admin" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime_admin->getInputTextType() ?>" name="x_datetime_admin" id="x_datetime_admin" data-table="message_template_admin" data-field="x_datetime_admin" value="<?= $Page->datetime_admin->EditValue ?>" data-page="6" placeholder="<?= HtmlEncode($Page->datetime_admin->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime_admin->formatPattern()) ?>"<?= $Page->datetime_admin->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime_admin->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
    </div><!-- /multi-page tabs .tab-content -->
</div><!-- /multi-page tabs -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmessage_template_adminsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmessage_template_adminsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmessage_template_adminsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("message_template_admin");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
