<?php

namespace PHPMaker2024\fibre;

// Page object
$MessageTemplateAdminList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { message_template_admin: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fmessage_template_adminsrch" id="fmessage_template_adminsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fmessage_template_adminsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { message_template_admin: currentTable } });
var currentForm;
var fmessage_template_adminsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmessage_template_adminsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["grp", [], fields.grp.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->id->Visible) { // id ?>
<?php
if (!$Page->id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_id" class="ew-search-caption ew-label"><?= $Page->id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</div>
        </div>
        <div id="el_message_template_admin_id" class="ew-search-field">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="message_template_admin" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
<?php
if (!$Page->grp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_grp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->grp->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_grp" class="ew-search-caption ew-label"><?= $Page->grp->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</div>
        </div>
        <div id="el_message_template_admin_grp" class="ew-search-field">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fmessage_template_adminsrch_x_grp"
        <?php } ?>
        data-table="message_template_admin"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmessage_template_adminsrch", function() {
    var options = { name: "x_grp", selectId: "fmessage_template_adminsrch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmessage_template_adminsrch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fmessage_template_adminsrch" };
    } else {
        options.ajax = { id: "x_grp", form: "fmessage_template_adminsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.message_template_admin.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fmessage_template_adminsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fmessage_template_adminsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fmessage_template_adminsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fmessage_template_adminsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fmessage_template_adminsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fmessage_template_adminsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fmessage_template_adminsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="message_template_admin">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_message_template_admin" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_message_template_adminlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_message_template_admin_id" class="message_template_admin_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_message_template_admin_grp" class="message_template_admin_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
        <th data-name="description" class="<?= $Page->description->headerCellClass() ?>"><div id="elh_message_template_admin_description" class="message_template_admin_description"><?= $Page->renderFieldHeader($Page->description) ?></div></th>
<?php } ?>
<?php if ($Page->subject->Visible) { // subject ?>
        <th data-name="subject" class="<?= $Page->subject->headerCellClass() ?>"><div id="elh_message_template_admin_subject" class="message_template_admin_subject"><?= $Page->renderFieldHeader($Page->subject) ?></div></th>
<?php } ?>
<?php if ($Page->status_email_user->Visible) { // status_email_user ?>
        <th data-name="status_email_user" class="<?= $Page->status_email_user->headerCellClass() ?>"><div id="elh_message_template_admin_status_email_user" class="message_template_admin_status_email_user"><?= $Page->renderFieldHeader($Page->status_email_user) ?></div></th>
<?php } ?>
<?php if ($Page->mail_to_office->Visible) { // mail_to_office ?>
        <th data-name="mail_to_office" class="<?= $Page->mail_to_office->headerCellClass() ?>"><div id="elh_message_template_admin_mail_to_office" class="message_template_admin_mail_to_office"><?= $Page->renderFieldHeader($Page->mail_to_office) ?></div></th>
<?php } ?>
<?php if ($Page->status_email_office->Visible) { // status_email_office ?>
        <th data-name="status_email_office" class="<?= $Page->status_email_office->headerCellClass() ?>"><div id="elh_message_template_admin_status_email_office" class="message_template_admin_status_email_office"><?= $Page->renderFieldHeader($Page->status_email_office) ?></div></th>
<?php } ?>
<?php if ($Page->status_sms_user->Visible) { // status_sms_user ?>
        <th data-name="status_sms_user" class="<?= $Page->status_sms_user->headerCellClass() ?>"><div id="elh_message_template_admin_status_sms_user" class="message_template_admin_status_sms_user"><?= $Page->renderFieldHeader($Page->status_sms_user) ?></div></th>
<?php } ?>
<?php if ($Page->sms_template_user_id->Visible) { // sms_template_user_id ?>
        <th data-name="sms_template_user_id" class="<?= $Page->sms_template_user_id->headerCellClass() ?>"><div id="elh_message_template_admin_sms_template_user_id" class="message_template_admin_sms_template_user_id"><?= $Page->renderFieldHeader($Page->sms_template_user_id) ?></div></th>
<?php } ?>
<?php if ($Page->sms_to_office->Visible) { // sms_to_office ?>
        <th data-name="sms_to_office" class="<?= $Page->sms_to_office->headerCellClass() ?>"><div id="elh_message_template_admin_sms_to_office" class="message_template_admin_sms_to_office"><?= $Page->renderFieldHeader($Page->sms_to_office) ?></div></th>
<?php } ?>
<?php if ($Page->sms_template_office->Visible) { // sms_template_office ?>
        <th data-name="sms_template_office" class="<?= $Page->sms_template_office->headerCellClass() ?>"><div id="elh_message_template_admin_sms_template_office" class="message_template_admin_sms_template_office"><?= $Page->renderFieldHeader($Page->sms_template_office) ?></div></th>
<?php } ?>
<?php if ($Page->sms_template_office_id->Visible) { // sms_template_office_id ?>
        <th data-name="sms_template_office_id" class="<?= $Page->sms_template_office_id->headerCellClass() ?>"><div id="elh_message_template_admin_sms_template_office_id" class="message_template_admin_sms_template_office_id"><?= $Page->renderFieldHeader($Page->sms_template_office_id) ?></div></th>
<?php } ?>
<?php if ($Page->wa_status_user->Visible) { // wa_status_user ?>
        <th data-name="wa_status_user" class="<?= $Page->wa_status_user->headerCellClass() ?>"><div id="elh_message_template_admin_wa_status_user" class="message_template_admin_wa_status_user"><?= $Page->renderFieldHeader($Page->wa_status_user) ?></div></th>
<?php } ?>
<?php if ($Page->wa_type_user->Visible) { // wa_type_user ?>
        <th data-name="wa_type_user" class="<?= $Page->wa_type_user->headerCellClass() ?>"><div id="elh_message_template_admin_wa_type_user" class="message_template_admin_wa_type_user"><?= $Page->renderFieldHeader($Page->wa_type_user) ?></div></th>
<?php } ?>
<?php if ($Page->wa_status_office->Visible) { // wa_status_office ?>
        <th data-name="wa_status_office" class="<?= $Page->wa_status_office->headerCellClass() ?>"><div id="elh_message_template_admin_wa_status_office" class="message_template_admin_wa_status_office"><?= $Page->renderFieldHeader($Page->wa_status_office) ?></div></th>
<?php } ?>
<?php if ($Page->wa_type_office->Visible) { // wa_type_office ?>
        <th data-name="wa_type_office" class="<?= $Page->wa_type_office->headerCellClass() ?>"><div id="elh_message_template_admin_wa_type_office" class="message_template_admin_wa_type_office"><?= $Page->renderFieldHeader($Page->wa_type_office) ?></div></th>
<?php } ?>
<?php if ($Page->wa_to_office->Visible) { // wa_to_office ?>
        <th data-name="wa_to_office" class="<?= $Page->wa_to_office->headerCellClass() ?>"><div id="elh_message_template_admin_wa_to_office" class="message_template_admin_wa_to_office"><?= $Page->renderFieldHeader($Page->wa_to_office) ?></div></th>
<?php } ?>
<?php if ($Page->wa_id->Visible) { // wa_id ?>
        <th data-name="wa_id" class="<?= $Page->wa_id->headerCellClass() ?>"><div id="elh_message_template_admin_wa_id" class="message_template_admin_wa_id"><?= $Page->renderFieldHeader($Page->wa_id) ?></div></th>
<?php } ?>
<?php if ($Page->notification_status_user->Visible) { // notification_status_user ?>
        <th data-name="notification_status_user" class="<?= $Page->notification_status_user->headerCellClass() ?>"><div id="elh_message_template_admin_notification_status_user" class="message_template_admin_notification_status_user"><?= $Page->renderFieldHeader($Page->notification_status_user) ?></div></th>
<?php } ?>
<?php if ($Page->notification_status_office->Visible) { // notification_status_office ?>
        <th data-name="notification_status_office" class="<?= $Page->notification_status_office->headerCellClass() ?>"><div id="elh_message_template_admin_notification_status_office" class="message_template_admin_notification_status_office"><?= $Page->renderFieldHeader($Page->notification_status_office) ?></div></th>
<?php } ?>
<?php if ($Page->notification_to_office->Visible) { // notification_to_office ?>
        <th data-name="notification_to_office" class="<?= $Page->notification_to_office->headerCellClass() ?>"><div id="elh_message_template_admin_notification_to_office" class="message_template_admin_notification_to_office"><?= $Page->renderFieldHeader($Page->notification_to_office) ?></div></th>
<?php } ?>
<?php if ($Page->_visible->Visible) { // visible ?>
        <th data-name="_visible" class="<?= $Page->_visible->headerCellClass() ?>"><div id="elh_message_template_admin__visible" class="message_template_admin__visible"><?= $Page->renderFieldHeader($Page->_visible) ?></div></th>
<?php } ?>
<?php if ($Page->cron->Visible) { // cron ?>
        <th data-name="cron" class="<?= $Page->cron->headerCellClass() ?>"><div id="elh_message_template_admin_cron" class="message_template_admin_cron"><?= $Page->renderFieldHeader($Page->cron) ?></div></th>
<?php } ?>
<?php if ($Page->next_cycle->Visible) { // next_cycle ?>
        <th data-name="next_cycle" class="<?= $Page->next_cycle->headerCellClass() ?>"><div id="elh_message_template_admin_next_cycle" class="message_template_admin_next_cycle"><?= $Page->renderFieldHeader($Page->next_cycle) ?></div></th>
<?php } ?>
<?php if ($Page->delay->Visible) { // delay ?>
        <th data-name="delay" class="<?= $Page->delay->headerCellClass() ?>"><div id="elh_message_template_admin_delay" class="message_template_admin_delay"><?= $Page->renderFieldHeader($Page->delay) ?></div></th>
<?php } ?>
<?php if ($Page->delay_method->Visible) { // delay_method ?>
        <th data-name="delay_method" class="<?= $Page->delay_method->headerCellClass() ?>"><div id="elh_message_template_admin_delay_method" class="message_template_admin_delay_method"><?= $Page->renderFieldHeader($Page->delay_method) ?></div></th>
<?php } ?>
<?php if ($Page->operator_admin->Visible) { // operator_admin ?>
        <th data-name="operator_admin" class="<?= $Page->operator_admin->headerCellClass() ?>"><div id="elh_message_template_admin_operator_admin" class="message_template_admin_operator_admin"><?= $Page->renderFieldHeader($Page->operator_admin) ?></div></th>
<?php } ?>
<?php if ($Page->datetime_admin->Visible) { // datetime_admin ?>
        <th data-name="datetime_admin" class="<?= $Page->datetime_admin->headerCellClass() ?>"><div id="elh_message_template_admin_datetime_admin" class="message_template_admin_datetime_admin"><?= $Page->renderFieldHeader($Page->datetime_admin) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_message_template_admin_company_id" class="message_template_admin_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_id" class="el_message_template_admin_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_grp" class="el_message_template_admin_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->description->Visible) { // description ?>
        <td data-name="description"<?= $Page->description->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_description" class="el_message_template_admin_description">
<span<?= $Page->description->viewAttributes() ?>>
<?php if (!EmptyString($Page->description->getViewValue()) && $Page->description->linkAttributes() != "") { ?>
<a<?= $Page->description->linkAttributes() ?>><?= $Page->description->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->description->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->subject->Visible) { // subject ?>
        <td data-name="subject"<?= $Page->subject->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_subject" class="el_message_template_admin_subject">
<span<?= $Page->subject->viewAttributes() ?>>
<?= $Page->subject->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status_email_user->Visible) { // status_email_user ?>
        <td data-name="status_email_user"<?= $Page->status_email_user->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_status_email_user" class="el_message_template_admin_status_email_user">
<span<?= $Page->status_email_user->viewAttributes() ?>>
<?= $Page->status_email_user->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mail_to_office->Visible) { // mail_to_office ?>
        <td data-name="mail_to_office"<?= $Page->mail_to_office->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_mail_to_office" class="el_message_template_admin_mail_to_office">
<span<?= $Page->mail_to_office->viewAttributes() ?>>
<?= $Page->mail_to_office->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status_email_office->Visible) { // status_email_office ?>
        <td data-name="status_email_office"<?= $Page->status_email_office->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_status_email_office" class="el_message_template_admin_status_email_office">
<span<?= $Page->status_email_office->viewAttributes() ?>>
<?= $Page->status_email_office->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status_sms_user->Visible) { // status_sms_user ?>
        <td data-name="status_sms_user"<?= $Page->status_sms_user->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_status_sms_user" class="el_message_template_admin_status_sms_user">
<span<?= $Page->status_sms_user->viewAttributes() ?>>
<?= $Page->status_sms_user->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sms_template_user_id->Visible) { // sms_template_user_id ?>
        <td data-name="sms_template_user_id"<?= $Page->sms_template_user_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_sms_template_user_id" class="el_message_template_admin_sms_template_user_id">
<span<?= $Page->sms_template_user_id->viewAttributes() ?>>
<?= $Page->sms_template_user_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sms_to_office->Visible) { // sms_to_office ?>
        <td data-name="sms_to_office"<?= $Page->sms_to_office->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_sms_to_office" class="el_message_template_admin_sms_to_office">
<span<?= $Page->sms_to_office->viewAttributes() ?>>
<?= $Page->sms_to_office->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sms_template_office->Visible) { // sms_template_office ?>
        <td data-name="sms_template_office"<?= $Page->sms_template_office->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_sms_template_office" class="el_message_template_admin_sms_template_office">
<span<?= $Page->sms_template_office->viewAttributes() ?>>
<?= $Page->sms_template_office->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sms_template_office_id->Visible) { // sms_template_office_id ?>
        <td data-name="sms_template_office_id"<?= $Page->sms_template_office_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_sms_template_office_id" class="el_message_template_admin_sms_template_office_id">
<span<?= $Page->sms_template_office_id->viewAttributes() ?>>
<?= $Page->sms_template_office_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->wa_status_user->Visible) { // wa_status_user ?>
        <td data-name="wa_status_user"<?= $Page->wa_status_user->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_wa_status_user" class="el_message_template_admin_wa_status_user">
<span<?= $Page->wa_status_user->viewAttributes() ?>>
<?= $Page->wa_status_user->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->wa_type_user->Visible) { // wa_type_user ?>
        <td data-name="wa_type_user"<?= $Page->wa_type_user->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_wa_type_user" class="el_message_template_admin_wa_type_user">
<span<?= $Page->wa_type_user->viewAttributes() ?>>
<?= $Page->wa_type_user->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->wa_status_office->Visible) { // wa_status_office ?>
        <td data-name="wa_status_office"<?= $Page->wa_status_office->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_wa_status_office" class="el_message_template_admin_wa_status_office">
<span<?= $Page->wa_status_office->viewAttributes() ?>>
<?= $Page->wa_status_office->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->wa_type_office->Visible) { // wa_type_office ?>
        <td data-name="wa_type_office"<?= $Page->wa_type_office->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_wa_type_office" class="el_message_template_admin_wa_type_office">
<span<?= $Page->wa_type_office->viewAttributes() ?>>
<?= $Page->wa_type_office->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->wa_to_office->Visible) { // wa_to_office ?>
        <td data-name="wa_to_office"<?= $Page->wa_to_office->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_wa_to_office" class="el_message_template_admin_wa_to_office">
<span<?= $Page->wa_to_office->viewAttributes() ?>>
<?= $Page->wa_to_office->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->wa_id->Visible) { // wa_id ?>
        <td data-name="wa_id"<?= $Page->wa_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_wa_id" class="el_message_template_admin_wa_id">
<span<?= $Page->wa_id->viewAttributes() ?>>
<?= $Page->wa_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->notification_status_user->Visible) { // notification_status_user ?>
        <td data-name="notification_status_user"<?= $Page->notification_status_user->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_notification_status_user" class="el_message_template_admin_notification_status_user">
<span<?= $Page->notification_status_user->viewAttributes() ?>>
<?= $Page->notification_status_user->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->notification_status_office->Visible) { // notification_status_office ?>
        <td data-name="notification_status_office"<?= $Page->notification_status_office->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_notification_status_office" class="el_message_template_admin_notification_status_office">
<span<?= $Page->notification_status_office->viewAttributes() ?>>
<?= $Page->notification_status_office->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->notification_to_office->Visible) { // notification_to_office ?>
        <td data-name="notification_to_office"<?= $Page->notification_to_office->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_notification_to_office" class="el_message_template_admin_notification_to_office">
<span<?= $Page->notification_to_office->viewAttributes() ?>>
<?= $Page->notification_to_office->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_visible->Visible) { // visible ?>
        <td data-name="_visible"<?= $Page->_visible->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin__visible" class="el_message_template_admin__visible">
<span<?= $Page->_visible->viewAttributes() ?>>
<?= $Page->_visible->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cron->Visible) { // cron ?>
        <td data-name="cron"<?= $Page->cron->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_cron" class="el_message_template_admin_cron">
<span<?= $Page->cron->viewAttributes() ?>>
<?= $Page->cron->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->next_cycle->Visible) { // next_cycle ?>
        <td data-name="next_cycle"<?= $Page->next_cycle->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_next_cycle" class="el_message_template_admin_next_cycle">
<span<?= $Page->next_cycle->viewAttributes() ?>>
<?= $Page->next_cycle->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->delay->Visible) { // delay ?>
        <td data-name="delay"<?= $Page->delay->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_delay" class="el_message_template_admin_delay">
<span<?= $Page->delay->viewAttributes() ?>>
<?= $Page->delay->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->delay_method->Visible) { // delay_method ?>
        <td data-name="delay_method"<?= $Page->delay_method->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_delay_method" class="el_message_template_admin_delay_method">
<span<?= $Page->delay_method->viewAttributes() ?>>
<?= $Page->delay_method->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator_admin->Visible) { // operator_admin ?>
        <td data-name="operator_admin"<?= $Page->operator_admin->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_operator_admin" class="el_message_template_admin_operator_admin">
<span<?= $Page->operator_admin->viewAttributes() ?>>
<?= $Page->operator_admin->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime_admin->Visible) { // datetime_admin ?>
        <td data-name="datetime_admin"<?= $Page->datetime_admin->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_datetime_admin" class="el_message_template_admin_datetime_admin">
<span<?= $Page->datetime_admin->viewAttributes() ?>>
<?= $Page->datetime_admin->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_message_template_admin_company_id" class="el_message_template_admin_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("message_template_admin");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
