<?php

namespace PHPMaker2024\fibre;

// Page object
$MenusView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fmenusview" id="fmenusview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { menus: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fmenusview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmenusview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="menus">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->id->Visible) { // id ?>
    <tr id="r_id"<?= $Page->id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_id"><?= $Page->id->caption() ?></span></td>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el_menus_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <tr id="r_image"<?= $Page->image->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_image"><?= $Page->image->caption() ?></span></td>
        <td data-name="image"<?= $Page->image->cellAttributes() ?>>
<span id="el_menus_image">
<span<?= $Page->image->viewAttributes() ?>>
<?= $Page->image->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->show_title->Visible) { // show_title ?>
    <tr id="r_show_title"<?= $Page->show_title->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_show_title"><?= $Page->show_title->caption() ?></span></td>
        <td data-name="show_title"<?= $Page->show_title->cellAttributes() ?>>
<span id="el_menus_show_title">
<span<?= $Page->show_title->viewAttributes() ?>>
<?= $Page->show_title->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->page_title->Visible) { // page_title ?>
    <tr id="r_page_title"<?= $Page->page_title->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_page_title"><?= $Page->page_title->caption() ?></span></td>
        <td data-name="page_title"<?= $Page->page_title->cellAttributes() ?>>
<span id="el_menus_page_title">
<span<?= $Page->page_title->viewAttributes() ?>>
<?= $Page->page_title->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->page_url->Visible) { // page_url ?>
    <tr id="r_page_url"<?= $Page->page_url->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_page_url"><?= $Page->page_url->caption() ?></span></td>
        <td data-name="page_url"<?= $Page->page_url->cellAttributes() ?>>
<span id="el_menus_page_url">
<span<?= $Page->page_url->viewAttributes() ?>>
<?= $Page->page_url->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->target->Visible) { // target ?>
    <tr id="r_target"<?= $Page->target->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_target"><?= $Page->target->caption() ?></span></td>
        <td data-name="target"<?= $Page->target->cellAttributes() ?>>
<span id="el_menus_target">
<span<?= $Page->target->viewAttributes() ?>>
<?= $Page->target->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->parent_id->Visible) { // parent_id ?>
    <tr id="r_parent_id"<?= $Page->parent_id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_parent_id"><?= $Page->parent_id->caption() ?></span></td>
        <td data-name="parent_id"<?= $Page->parent_id->cellAttributes() ?>>
<span id="el_menus_parent_id">
<span<?= $Page->parent_id->viewAttributes() ?>>
<?= $Page->parent_id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->show_in_main_menu->Visible) { // show_in_main_menu ?>
    <tr id="r_show_in_main_menu"<?= $Page->show_in_main_menu->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_show_in_main_menu"><?= $Page->show_in_main_menu->caption() ?></span></td>
        <td data-name="show_in_main_menu"<?= $Page->show_in_main_menu->cellAttributes() ?>>
<span id="el_menus_show_in_main_menu">
<span<?= $Page->show_in_main_menu->viewAttributes() ?>>
<?= $Page->show_in_main_menu->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <tr id="r_status"<?= $Page->status->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_status"><?= $Page->status->caption() ?></span></td>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el_menus_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->order_by->Visible) { // order_by ?>
    <tr id="r_order_by"<?= $Page->order_by->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_order_by"><?= $Page->order_by->caption() ?></span></td>
        <td data-name="order_by"<?= $Page->order_by->cellAttributes() ?>>
<span id="el_menus_order_by">
<span<?= $Page->order_by->viewAttributes() ?>>
<?= $Page->order_by->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->mega_menu->Visible) { // mega_menu ?>
    <tr id="r_mega_menu"<?= $Page->mega_menu->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_mega_menu"><?= $Page->mega_menu->caption() ?></span></td>
        <td data-name="mega_menu"<?= $Page->mega_menu->cellAttributes() ?>>
<span id="el_menus_mega_menu">
<span<?= $Page->mega_menu->viewAttributes() ?>>
<?= $Page->mega_menu->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->bgcolor->Visible) { // bgcolor ?>
    <tr id="r_bgcolor"<?= $Page->bgcolor->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_bgcolor"><?= $Page->bgcolor->caption() ?></span></td>
        <td data-name="bgcolor"<?= $Page->bgcolor->cellAttributes() ?>>
<span id="el_menus_bgcolor">
<span<?= $Page->bgcolor->viewAttributes() ?>>
<?= $Page->bgcolor->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->submenu->Visible) { // submenu ?>
    <tr id="r_submenu"<?= $Page->submenu->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_submenu"><?= $Page->submenu->caption() ?></span></td>
        <td data-name="submenu"<?= $Page->submenu->cellAttributes() ?>>
<span id="el_menus_submenu">
<span<?= $Page->submenu->viewAttributes() ?>>
<?= $Page->submenu->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->submenu_code->Visible) { // submenu_code ?>
    <tr id="r_submenu_code"<?= $Page->submenu_code->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_submenu_code"><?= $Page->submenu_code->caption() ?></span></td>
        <td data-name="submenu_code"<?= $Page->submenu_code->cellAttributes() ?>>
<span id="el_menus_submenu_code">
<span<?= $Page->submenu_code->viewAttributes() ?>>
<?= $Page->submenu_code->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->footer_group->Visible) { // footer_group ?>
    <tr id="r_footer_group"<?= $Page->footer_group->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_footer_group"><?= $Page->footer_group->caption() ?></span></td>
        <td data-name="footer_group"<?= $Page->footer_group->cellAttributes() ?>>
<span id="el_menus_footer_group">
<span<?= $Page->footer_group->viewAttributes() ?>>
<?= $Page->footer_group->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <tr id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_operator"><?= $Page->operator->caption() ?></span></td>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el_menus_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <tr id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_menus_datetime"><?= $Page->datetime->caption() ?></span></td>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el_menus_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
