<?php

namespace PHPMaker2024\fibre;

// Page object
$MenusSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { menus: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmenussearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmenussearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["show_title", [], fields.show_title.isInvalid],
            ["page_title", [], fields.page_title.isInvalid],
            ["page_url", [], fields.page_url.isInvalid],
            ["target", [], fields.target.isInvalid],
            ["parent_id", [], fields.parent_id.isInvalid],
            ["show_in_main_menu", [], fields.show_in_main_menu.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["order_by", [ew.Validators.integer], fields.order_by.isInvalid],
            ["mega_menu", [], fields.mega_menu.isInvalid],
            ["bgcolor", [], fields.bgcolor.isInvalid],
            ["submenu", [], fields.submenu.isInvalid],
            ["submenu_code", [], fields.submenu_code.isInvalid],
            ["footer_group", [], fields.footer_group.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "show_title": <?= $Page->show_title->toClientList($Page) ?>,
            "target": <?= $Page->target->toClientList($Page) ?>,
            "parent_id": <?= $Page->parent_id->toClientList($Page) ?>,
            "show_in_main_menu": <?= $Page->show_in_main_menu->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "mega_menu": <?= $Page->mega_menu->toClientList($Page) ?>,
            "submenu": <?= $Page->submenu->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmenussearch" id="fmenussearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="menus">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="menus" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label for="x_image" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="menus" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->show_title->Visible) { // show_title ?>
    <div id="r_show_title" class="row"<?= $Page->show_title->rowAttributes() ?>>
        <label for="x_show_title" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_show_title"><?= $Page->show_title->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_show_title" id="z_show_title" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->show_title->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_show_title" class="ew-search-field ew-search-field-single">
    <select
        id="x_show_title"
        name="x_show_title"
        class="form-select ew-select<?= $Page->show_title->isInvalidClass() ?>"
        <?php if (!$Page->show_title->IsNativeSelect) { ?>
        data-select2-id="fmenussearch_x_show_title"
        <?php } ?>
        data-table="menus"
        data-field="x_show_title"
        data-value-separator="<?= $Page->show_title->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->show_title->getPlaceHolder()) ?>"
        <?= $Page->show_title->editAttributes() ?>>
        <?= $Page->show_title->selectOptionListHtml("x_show_title") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->show_title->getErrorMessage(false) ?></div>
<?php if (!$Page->show_title->IsNativeSelect) { ?>
<script>
loadjs.ready("fmenussearch", function() {
    var options = { name: "x_show_title", selectId: "fmenussearch_x_show_title" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmenussearch.lists.show_title?.lookupOptions.length) {
        options.data = { id: "x_show_title", form: "fmenussearch" };
    } else {
        options.ajax = { id: "x_show_title", form: "fmenussearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.menus.fields.show_title.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->page_title->Visible) { // page_title ?>
    <div id="r_page_title" class="row"<?= $Page->page_title->rowAttributes() ?>>
        <label for="x_page_title" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_page_title"><?= $Page->page_title->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_page_title" id="z_page_title" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->page_title->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_page_title" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->page_title->getInputTextType() ?>" name="x_page_title" id="x_page_title" data-table="menus" data-field="x_page_title" value="<?= $Page->page_title->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->page_title->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->page_title->formatPattern()) ?>"<?= $Page->page_title->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->page_title->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->page_url->Visible) { // page_url ?>
    <div id="r_page_url" class="row"<?= $Page->page_url->rowAttributes() ?>>
        <label for="x_page_url" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_page_url"><?= $Page->page_url->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_page_url" id="z_page_url" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->page_url->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_page_url" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->page_url->getInputTextType() ?>" name="x_page_url" id="x_page_url" data-table="menus" data-field="x_page_url" value="<?= $Page->page_url->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->page_url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->page_url->formatPattern()) ?>"<?= $Page->page_url->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->page_url->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->target->Visible) { // target ?>
    <div id="r_target" class="row"<?= $Page->target->rowAttributes() ?>>
        <label for="x_target" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_target"><?= $Page->target->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_target" id="z_target" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->target->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_target" class="ew-search-field ew-search-field-single">
    <select
        id="x_target"
        name="x_target"
        class="form-select ew-select<?= $Page->target->isInvalidClass() ?>"
        <?php if (!$Page->target->IsNativeSelect) { ?>
        data-select2-id="fmenussearch_x_target"
        <?php } ?>
        data-table="menus"
        data-field="x_target"
        data-value-separator="<?= $Page->target->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->target->getPlaceHolder()) ?>"
        <?= $Page->target->editAttributes() ?>>
        <?= $Page->target->selectOptionListHtml("x_target") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->target->getErrorMessage(false) ?></div>
<?php if (!$Page->target->IsNativeSelect) { ?>
<script>
loadjs.ready("fmenussearch", function() {
    var options = { name: "x_target", selectId: "fmenussearch_x_target" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmenussearch.lists.target?.lookupOptions.length) {
        options.data = { id: "x_target", form: "fmenussearch" };
    } else {
        options.ajax = { id: "x_target", form: "fmenussearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.menus.fields.target.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->parent_id->Visible) { // parent_id ?>
    <div id="r_parent_id" class="row"<?= $Page->parent_id->rowAttributes() ?>>
        <label for="x_parent_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_parent_id"><?= $Page->parent_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_parent_id" id="z_parent_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->parent_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_parent_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_parent_id"
        name="x_parent_id"
        class="form-select ew-select<?= $Page->parent_id->isInvalidClass() ?>"
        <?php if (!$Page->parent_id->IsNativeSelect) { ?>
        data-select2-id="fmenussearch_x_parent_id"
        <?php } ?>
        data-table="menus"
        data-field="x_parent_id"
        data-value-separator="<?= $Page->parent_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->parent_id->getPlaceHolder()) ?>"
        <?= $Page->parent_id->editAttributes() ?>>
        <?= $Page->parent_id->selectOptionListHtml("x_parent_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->parent_id->getErrorMessage(false) ?></div>
<?= $Page->parent_id->Lookup->getParamTag($Page, "p_x_parent_id") ?>
<?php if (!$Page->parent_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmenussearch", function() {
    var options = { name: "x_parent_id", selectId: "fmenussearch_x_parent_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmenussearch.lists.parent_id?.lookupOptions.length) {
        options.data = { id: "x_parent_id", form: "fmenussearch" };
    } else {
        options.ajax = { id: "x_parent_id", form: "fmenussearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.menus.fields.parent_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->show_in_main_menu->Visible) { // show_in_main_menu ?>
    <div id="r_show_in_main_menu" class="row"<?= $Page->show_in_main_menu->rowAttributes() ?>>
        <label for="x_show_in_main_menu" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_show_in_main_menu"><?= $Page->show_in_main_menu->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_show_in_main_menu" id="z_show_in_main_menu" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->show_in_main_menu->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_show_in_main_menu" class="ew-search-field ew-search-field-single">
    <select
        id="x_show_in_main_menu"
        name="x_show_in_main_menu"
        class="form-select ew-select<?= $Page->show_in_main_menu->isInvalidClass() ?>"
        <?php if (!$Page->show_in_main_menu->IsNativeSelect) { ?>
        data-select2-id="fmenussearch_x_show_in_main_menu"
        <?php } ?>
        data-table="menus"
        data-field="x_show_in_main_menu"
        data-value-separator="<?= $Page->show_in_main_menu->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->show_in_main_menu->getPlaceHolder()) ?>"
        <?= $Page->show_in_main_menu->editAttributes() ?>>
        <?= $Page->show_in_main_menu->selectOptionListHtml("x_show_in_main_menu") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->show_in_main_menu->getErrorMessage(false) ?></div>
<?php if (!$Page->show_in_main_menu->IsNativeSelect) { ?>
<script>
loadjs.ready("fmenussearch", function() {
    var options = { name: "x_show_in_main_menu", selectId: "fmenussearch_x_show_in_main_menu" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmenussearch.lists.show_in_main_menu?.lookupOptions.length) {
        options.data = { id: "x_show_in_main_menu", form: "fmenussearch" };
    } else {
        options.ajax = { id: "x_show_in_main_menu", form: "fmenussearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.menus.fields.show_in_main_menu.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fmenussearch_x_status"
        <?php } ?>
        data-table="menus"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fmenussearch", function() {
    var options = { name: "x_status", selectId: "fmenussearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmenussearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fmenussearch" };
    } else {
        options.ajax = { id: "x_status", form: "fmenussearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.menus.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_by->Visible) { // order_by ?>
    <div id="r_order_by" class="row"<?= $Page->order_by->rowAttributes() ?>>
        <label for="x_order_by" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_order_by"><?= $Page->order_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_order_by" id="z_order_by" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_order_by" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_by->getInputTextType() ?>" name="x_order_by" id="x_order_by" data-table="menus" data-field="x_order_by" value="<?= $Page->order_by->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->order_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_by->formatPattern()) ?>"<?= $Page->order_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_by->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mega_menu->Visible) { // mega_menu ?>
    <div id="r_mega_menu" class="row"<?= $Page->mega_menu->rowAttributes() ?>>
        <label for="x_mega_menu" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_mega_menu"><?= $Page->mega_menu->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_mega_menu" id="z_mega_menu" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mega_menu->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_mega_menu" class="ew-search-field ew-search-field-single">
    <select
        id="x_mega_menu"
        name="x_mega_menu"
        class="form-select ew-select<?= $Page->mega_menu->isInvalidClass() ?>"
        <?php if (!$Page->mega_menu->IsNativeSelect) { ?>
        data-select2-id="fmenussearch_x_mega_menu"
        <?php } ?>
        data-table="menus"
        data-field="x_mega_menu"
        data-value-separator="<?= $Page->mega_menu->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->mega_menu->getPlaceHolder()) ?>"
        <?= $Page->mega_menu->editAttributes() ?>>
        <?= $Page->mega_menu->selectOptionListHtml("x_mega_menu") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->mega_menu->getErrorMessage(false) ?></div>
<?php if (!$Page->mega_menu->IsNativeSelect) { ?>
<script>
loadjs.ready("fmenussearch", function() {
    var options = { name: "x_mega_menu", selectId: "fmenussearch_x_mega_menu" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmenussearch.lists.mega_menu?.lookupOptions.length) {
        options.data = { id: "x_mega_menu", form: "fmenussearch" };
    } else {
        options.ajax = { id: "x_mega_menu", form: "fmenussearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.menus.fields.mega_menu.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bgcolor->Visible) { // bgcolor ?>
    <div id="r_bgcolor" class="row"<?= $Page->bgcolor->rowAttributes() ?>>
        <label for="x_bgcolor" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_bgcolor"><?= $Page->bgcolor->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bgcolor" id="z_bgcolor" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bgcolor->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_bgcolor" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bgcolor->getInputTextType() ?>" name="x_bgcolor" id="x_bgcolor" data-table="menus" data-field="x_bgcolor" value="<?= $Page->bgcolor->EditValue ?>" size="30" maxlength="7" placeholder="<?= HtmlEncode($Page->bgcolor->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bgcolor->formatPattern()) ?>"<?= $Page->bgcolor->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bgcolor->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->submenu->Visible) { // submenu ?>
    <div id="r_submenu" class="row"<?= $Page->submenu->rowAttributes() ?>>
        <label for="x_submenu" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_submenu"><?= $Page->submenu->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_submenu" id="z_submenu" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->submenu->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_submenu" class="ew-search-field ew-search-field-single">
    <select
        id="x_submenu"
        name="x_submenu"
        class="form-select ew-select<?= $Page->submenu->isInvalidClass() ?>"
        <?php if (!$Page->submenu->IsNativeSelect) { ?>
        data-select2-id="fmenussearch_x_submenu"
        <?php } ?>
        data-table="menus"
        data-field="x_submenu"
        data-value-separator="<?= $Page->submenu->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->submenu->getPlaceHolder()) ?>"
        <?= $Page->submenu->editAttributes() ?>>
        <?= $Page->submenu->selectOptionListHtml("x_submenu") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->submenu->getErrorMessage(false) ?></div>
<?php if (!$Page->submenu->IsNativeSelect) { ?>
<script>
loadjs.ready("fmenussearch", function() {
    var options = { name: "x_submenu", selectId: "fmenussearch_x_submenu" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmenussearch.lists.submenu?.lookupOptions.length) {
        options.data = { id: "x_submenu", form: "fmenussearch" };
    } else {
        options.ajax = { id: "x_submenu", form: "fmenussearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.menus.fields.submenu.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->submenu_code->Visible) { // submenu_code ?>
    <div id="r_submenu_code" class="row"<?= $Page->submenu_code->rowAttributes() ?>>
        <label for="x_submenu_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_submenu_code"><?= $Page->submenu_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_submenu_code" id="z_submenu_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->submenu_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_submenu_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->submenu_code->getInputTextType() ?>" name="x_submenu_code" id="x_submenu_code" data-table="menus" data-field="x_submenu_code" value="<?= $Page->submenu_code->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->submenu_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->submenu_code->formatPattern()) ?>"<?= $Page->submenu_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->submenu_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->footer_group->Visible) { // footer_group ?>
    <div id="r_footer_group" class="row"<?= $Page->footer_group->rowAttributes() ?>>
        <label for="x_footer_group" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_footer_group"><?= $Page->footer_group->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_footer_group" id="z_footer_group" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->footer_group->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_footer_group" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->footer_group->getInputTextType() ?>" name="x_footer_group" id="x_footer_group" data-table="menus" data-field="x_footer_group" value="<?= $Page->footer_group->EditValue ?>" size="30" maxlength="30" placeholder="<?= HtmlEncode($Page->footer_group->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->footer_group->formatPattern()) ?>"<?= $Page->footer_group->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->footer_group->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="menus" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_menus_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_menus_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="menus" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmenussearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmenussearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmenussearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("menus");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
