<?php

namespace PHPMaker2024\fibre;

// Page object
$MemberInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { member_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmember_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmember_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["type", [], fields.type.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["classification", [], fields.classification.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["_email", [], fields._email.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["blood_grp", [], fields.blood_grp.isInvalid],
            ["dob", [ew.Validators.datetime(fields.dob.clientFormatPattern)], fields.dob.isInvalid],
            ["dom", [ew.Validators.datetime(fields.dom.clientFormatPattern)], fields.dom.isInvalid],
            ["join_date", [ew.Validators.datetime(fields.join_date.clientFormatPattern)], fields.join_date.isInvalid],
            ["spouse_name", [], fields.spouse_name.isInvalid],
            ["children_name", [], fields.children_name.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["remakrs", [], fields.remakrs.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["couple_image", [], fields.couple_image.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "type": <?= $Page->type->toClientList($Page) ?>,
            "blood_grp": <?= $Page->blood_grp->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmember_infosearch" id="fmember_infosearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="member_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="member_info" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type" class="row"<?= $Page->type->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_type"><?= $Page->type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_type" id="z_type" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_type" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->type->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_type" class="ew-auto-suggest">
    <input type="<?= $Page->type->getInputTextType() ?>" class="form-control" name="sv_x_type" id="sv_x_type" value="<?= RemoveHtml($Page->type->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->type->formatPattern()) ?>"<?= $Page->type->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="member_info" data-field="x_type" data-input="sv_x_type" data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>" name="x_type" id="x_type" value="<?= HtmlEncode($Page->type->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fmember_infosearch", function() {
    fmember_infosearch.createAutoSuggest(Object.assign({"id":"x_type","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->type->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.member_info.fields.type.autoSuggestOptions));
});
</script>
<?= $Page->type->Lookup->getParamTag($Page, "p_x_type") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label for="x_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="member_info" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->classification->Visible) { // classification ?>
    <div id="r_classification" class="row"<?= $Page->classification->rowAttributes() ?>>
        <label for="x_classification" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_classification"><?= $Page->classification->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_classification" id="z_classification" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->classification->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_classification" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->classification->getInputTextType() ?>" name="x_classification" id="x_classification" data-table="member_info" data-field="x_classification" value="<?= $Page->classification->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->classification->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->classification->formatPattern()) ?>"<?= $Page->classification->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->classification->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="member_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="22" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email" class="row"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info__email"><?= $Page->_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__email" id="z__email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="member_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address" class="row"<?= $Page->address->rowAttributes() ?>>
        <label for="x_address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_address"><?= $Page->address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_address" id="z_address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="member_info" data-field="x_address" value="<?= $Page->address->EditValue ?>" maxlength="252" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->blood_grp->Visible) { // blood_grp ?>
    <div id="r_blood_grp" class="row"<?= $Page->blood_grp->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_blood_grp"><?= $Page->blood_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_blood_grp" id="z_blood_grp" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->blood_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_blood_grp" class="ew-search-field ew-search-field-single">
<template id="tp_x_blood_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="member_info" data-field="x_blood_grp" name="x_blood_grp" id="x_blood_grp"<?= $Page->blood_grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_blood_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_blood_grp[]"
    name="x_blood_grp[]"
    value="<?= HtmlEncode($Page->blood_grp->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_blood_grp"
    data-target="dsl_x_blood_grp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->blood_grp->isInvalidClass() ?>"
    data-table="member_info"
    data-field="x_blood_grp"
    data-value-separator="<?= $Page->blood_grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->blood_grp->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->blood_grp->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
    <div id="r_dob" class="row"<?= $Page->dob->rowAttributes() ?>>
        <label for="x_dob" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_dob"><?= $Page->dob->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dob" id="z_dob" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dob->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_dob" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="member_info" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage(false) ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmember_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmember_infosearch", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dom->Visible) { // dom ?>
    <div id="r_dom" class="row"<?= $Page->dom->rowAttributes() ?>>
        <label for="x_dom" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_dom"><?= $Page->dom->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dom" id="z_dom" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dom->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_dom" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dom->getInputTextType() ?>" name="x_dom" id="x_dom" data-table="member_info" data-field="x_dom" value="<?= $Page->dom->EditValue ?>" placeholder="<?= HtmlEncode($Page->dom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dom->formatPattern()) ?>"<?= $Page->dom->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dom->getErrorMessage(false) ?></div>
<?php if (!$Page->dom->ReadOnly && !$Page->dom->Disabled && !isset($Page->dom->EditAttrs["readonly"]) && !isset($Page->dom->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmember_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmember_infosearch", "x_dom", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->join_date->Visible) { // join_date ?>
    <div id="r_join_date" class="row"<?= $Page->join_date->rowAttributes() ?>>
        <label for="x_join_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_join_date"><?= $Page->join_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_join_date" id="z_join_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->join_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_join_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->join_date->getInputTextType() ?>" name="x_join_date" id="x_join_date" data-table="member_info" data-field="x_join_date" value="<?= $Page->join_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->join_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->join_date->formatPattern()) ?>"<?= $Page->join_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->join_date->getErrorMessage(false) ?></div>
<?php if (!$Page->join_date->ReadOnly && !$Page->join_date->Disabled && !isset($Page->join_date->EditAttrs["readonly"]) && !isset($Page->join_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmember_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmember_infosearch", "x_join_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->spouse_name->Visible) { // spouse_name ?>
    <div id="r_spouse_name" class="row"<?= $Page->spouse_name->rowAttributes() ?>>
        <label for="x_spouse_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_spouse_name"><?= $Page->spouse_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_spouse_name" id="z_spouse_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->spouse_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_spouse_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->spouse_name->getInputTextType() ?>" name="x_spouse_name" id="x_spouse_name" data-table="member_info" data-field="x_spouse_name" value="<?= $Page->spouse_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->spouse_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->spouse_name->formatPattern()) ?>"<?= $Page->spouse_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->spouse_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->children_name->Visible) { // children_name ?>
    <div id="r_children_name" class="row"<?= $Page->children_name->rowAttributes() ?>>
        <label for="x_children_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_children_name"><?= $Page->children_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_children_name" id="z_children_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->children_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_children_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->children_name->getInputTextType() ?>" name="x_children_name" id="x_children_name" data-table="member_info" data-field="x_children_name" value="<?= $Page->children_name->EditValue ?>" maxlength="192" placeholder="<?= HtmlEncode($Page->children_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->children_name->formatPattern()) ?>"<?= $Page->children_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->children_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="member_info" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="252" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remakrs->Visible) { // remakrs ?>
    <div id="r_remakrs" class="row"<?= $Page->remakrs->rowAttributes() ?>>
        <label for="x_remakrs" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_remakrs"><?= $Page->remakrs->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remakrs" id="z_remakrs" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remakrs->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_remakrs" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remakrs->getInputTextType() ?>" name="x_remakrs" id="x_remakrs" data-table="member_info" data-field="x_remakrs" value="<?= $Page->remakrs->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->remakrs->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remakrs->formatPattern()) ?>"<?= $Page->remakrs->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remakrs->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="member_info" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="member_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmember_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmember_infosearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->couple_image->Visible) { // couple_image ?>
    <div id="r_couple_image" class="row"<?= $Page->couple_image->rowAttributes() ?>>
        <label for="x_couple_image" class="<?= $Page->LeftColumnClass ?>"><span id="elh_member_info_couple_image"><?= $Page->couple_image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_couple_image" id="z_couple_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->couple_image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_member_info_couple_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->couple_image->getInputTextType() ?>" name="x_couple_image" id="x_couple_image" data-table="member_info" data-field="x_couple_image" value="<?= $Page->couple_image->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->couple_image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->couple_image->formatPattern()) ?>"<?= $Page->couple_image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->couple_image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmember_infosearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmember_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmember_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("member_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
