<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialRequiredWeeklySearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_weekly: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmaterial_required_weeklysearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmaterial_required_weeklysearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["week", [], fields.week.isInvalid],
            ["y_week", [ew.Validators.between], false],
            ["rid", [ew.Validators.integer], fields.rid.isInvalid],
            ["packing", [], fields.packing.isInvalid],
            ["stock", [ew.Validators.float], fields.stock.isInvalid],
            ["required", [ew.Validators.float], fields.required.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "week": <?= $Page->week->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing": <?= $Page->packing->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmaterial_required_weeklysearch" id="fmaterial_required_weeklysearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_required_weekly">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->week->Visible) { // week ?>
    <div id="r_week" class="row"<?= $Page->week->rowAttributes() ?>>
        <label for="x_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_weekly_week"><?= $Page->week->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_week" id="z_week" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->week->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->week->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_material_required_weekly_week" class="ew-search-field">
    <select
        id="x_week"
        name="x_week"
        class="form-select ew-select<?= $Page->week->isInvalidClass() ?>"
        <?php if (!$Page->week->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_weeklysearch_x_week"
        <?php } ?>
        data-table="material_required_weekly"
        data-field="x_week"
        data-value-separator="<?= $Page->week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->week->getPlaceHolder()) ?>"
        <?= $Page->week->editAttributes() ?>>
        <?= $Page->week->selectOptionListHtml("x_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->week->getErrorMessage(false) ?></div>
<?= $Page->week->Lookup->getParamTag($Page, "p_x_week") ?>
<?php if (!$Page->week->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_weeklysearch", function() {
    var options = { name: "x_week", selectId: "fmaterial_required_weeklysearch_x_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_weeklysearch.lists.week?.lookupOptions.length) {
        options.data = { id: "x_week", form: "fmaterial_required_weeklysearch" };
    } else {
        options.ajax = { id: "x_week", form: "fmaterial_required_weeklysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_weekly.fields.week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_material_required_weekly_week" class="ew-search-field2 d-none">
    <select
        id="y_week"
        name="y_week"
        class="form-select ew-select<?= $Page->week->isInvalidClass() ?>"
        <?php if (!$Page->week->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_weeklysearch_y_week"
        <?php } ?>
        data-table="material_required_weekly"
        data-field="x_week"
        data-value-separator="<?= $Page->week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->week->getPlaceHolder()) ?>"
        <?= $Page->week->editAttributes() ?>>
        <?= $Page->week->selectOptionListHtml("y_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->week->getErrorMessage(false) ?></div>
<?= $Page->week->Lookup->getParamTag($Page, "p_y_week") ?>
<?php if (!$Page->week->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_weeklysearch", function() {
    var options = { name: "y_week", selectId: "fmaterial_required_weeklysearch_y_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_weeklysearch.lists.week?.lookupOptions.length) {
        options.data = { id: "y_week", form: "fmaterial_required_weeklysearch" };
    } else {
        options.ajax = { id: "y_week", form: "fmaterial_required_weeklysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_weekly.fields.week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_weekly_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_weekly_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid"
        name="x_rid"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fmaterial_required_weeklysearch_x_rid"
        data-table="material_required_weekly"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<script>
loadjs.ready("fmaterial_required_weeklysearch", function() {
    var options = { name: "x_rid", selectId: "fmaterial_required_weeklysearch_x_rid" };
    if (fmaterial_required_weeklysearch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fmaterial_required_weeklysearch" };
    } else {
        options.ajax = { id: "x_rid", form: "fmaterial_required_weeklysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.material_required_weekly.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing->Visible) { // packing ?>
    <div id="r_packing" class="row"<?= $Page->packing->rowAttributes() ?>>
        <label for="x_packing" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_weekly_packing"><?= $Page->packing->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing" id="z_packing" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_weekly_packing" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing"
        name="x_packing"
        class="form-select ew-select<?= $Page->packing->isInvalidClass() ?>"
        <?php if (!$Page->packing->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_weeklysearch_x_packing"
        <?php } ?>
        data-table="material_required_weekly"
        data-field="x_packing"
        data-value-separator="<?= $Page->packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing->getPlaceHolder()) ?>"
        <?= $Page->packing->editAttributes() ?>>
        <?= $Page->packing->selectOptionListHtml("x_packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing->getErrorMessage(false) ?></div>
<?= $Page->packing->Lookup->getParamTag($Page, "p_x_packing") ?>
<?php if (!$Page->packing->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_weeklysearch", function() {
    var options = { name: "x_packing", selectId: "fmaterial_required_weeklysearch_x_packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_weeklysearch.lists.packing?.lookupOptions.length) {
        options.data = { id: "x_packing", form: "fmaterial_required_weeklysearch" };
    } else {
        options.ajax = { id: "x_packing", form: "fmaterial_required_weeklysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_weekly.fields.packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->stock->Visible) { // stock ?>
    <div id="r_stock" class="row"<?= $Page->stock->rowAttributes() ?>>
        <label for="x_stock" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_weekly_stock"><?= $Page->stock->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_stock" id="z_stock" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->stock->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_weekly_stock" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->stock->getInputTextType() ?>" name="x_stock" id="x_stock" data-table="material_required_weekly" data-field="x_stock" value="<?= $Page->stock->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->stock->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->stock->formatPattern()) ?>"<?= $Page->stock->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->stock->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->required->Visible) { // required ?>
    <div id="r_required" class="row"<?= $Page->required->rowAttributes() ?>>
        <label for="x_required" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_weekly_required"><?= $Page->required->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_required" id="z_required" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->required->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_weekly_required" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->required->getInputTextType() ?>" name="x_required" id="x_required" data-table="material_required_weekly" data-field="x_required" value="<?= $Page->required->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->required->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->required->formatPattern()) ?>"<?= $Page->required->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->required->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmaterial_required_weeklysearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmaterial_required_weeklysearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmaterial_required_weeklysearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_required_weekly");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
