<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialRequiredWeeklyLoomplanList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_weekly_loomplan: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "material_required_weekly_loomplan_short") {
    if ($Page->MasterRecordExists) {
        include_once "views/MaterialRequiredWeeklyLoomplanShortMaster.php";
    }
}
?>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fmaterial_required_weekly_loomplansrch" id="fmaterial_required_weekly_loomplansrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fmaterial_required_weekly_loomplansrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_weekly_loomplan: currentTable } });
var currentForm;
var fmaterial_required_weekly_loomplansrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmaterial_required_weekly_loomplansrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["weaving_works", [], fields.weaving_works.isInvalid],
            ["week", [], fields.week.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
            "week": <?= $Page->week->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
<?php
if (!$Page->weaving_works->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_weaving_works" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->weaving_works->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_weaving_works" class="ew-search-caption ew-label"><?= $Page->weaving_works->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_weaving_works" id="z_weaving_works" value="=">
</div>
        </div>
        <div id="el_material_required_weekly_loomplan_weaving_works" class="ew-search-field">
    <select
        id="x_weaving_works"
        name="x_weaving_works"
        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_weekly_loomplansrch_x_weaving_works"
        <?php } ?>
        data-table="material_required_weekly_loomplan"
        data-field="x_weaving_works"
        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
        <?= $Page->weaving_works->editAttributes() ?>>
        <?= $Page->weaving_works->selectOptionListHtml("x_weaving_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage(false) ?></div>
<?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x_weaving_works") ?>
<?php if (!$Page->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_weekly_loomplansrch", function() {
    var options = { name: "x_weaving_works", selectId: "fmaterial_required_weekly_loomplansrch_x_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_weekly_loomplansrch.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x_weaving_works", form: "fmaterial_required_weekly_loomplansrch" };
    } else {
        options.ajax = { id: "x_weaving_works", form: "fmaterial_required_weekly_loomplansrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_weekly_loomplan.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->week->Visible) { // week ?>
<?php
if (!$Page->week->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_week" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->week->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_week" class="ew-search-caption ew-label"><?= $Page->week->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_week" id="z_week" value="=">
</div>
        </div>
        <div id="el_material_required_weekly_loomplan_week" class="ew-search-field">
    <select
        id="x_week"
        name="x_week"
        class="form-select ew-select<?= $Page->week->isInvalidClass() ?>"
        <?php if (!$Page->week->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_weekly_loomplansrch_x_week"
        <?php } ?>
        data-table="material_required_weekly_loomplan"
        data-field="x_week"
        data-value-separator="<?= $Page->week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->week->getPlaceHolder()) ?>"
        <?= $Page->week->editAttributes() ?>>
        <?= $Page->week->selectOptionListHtml("x_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->week->getErrorMessage(false) ?></div>
<?= $Page->week->Lookup->getParamTag($Page, "p_x_week") ?>
<?php if (!$Page->week->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_weekly_loomplansrch", function() {
    var options = { name: "x_week", selectId: "fmaterial_required_weekly_loomplansrch_x_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_weekly_loomplansrch.lists.week?.lookupOptions.length) {
        options.data = { id: "x_week", form: "fmaterial_required_weekly_loomplansrch" };
    } else {
        options.ajax = { id: "x_week", form: "fmaterial_required_weekly_loomplansrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_weekly_loomplan.fields.week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
<?php
if (!$Page->po->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_po" class="ew-search-caption ew-label"><?= $Page->po->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_material_required_weekly_loomplan_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="material_required_weekly_loomplan" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_material_required_weekly_loomplan_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="material_required_weekly_loomplan" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fmaterial_required_weekly_loomplansrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fmaterial_required_weekly_loomplansrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fmaterial_required_weekly_loomplansrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fmaterial_required_weekly_loomplansrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fmaterial_required_weekly_loomplansrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fmaterial_required_weekly_loomplansrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fmaterial_required_weekly_loomplansrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_required_weekly_loomplan">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "material_required_weekly_loomplan_short" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="material_required_weekly_loomplan_short">
<input type="hidden" name="fk_godown" value="<?= HtmlEncode($Page->weaving_works->getSessionValue()) ?>">
<input type="hidden" name="fk_week" value="<?= HtmlEncode($Page->week->getSessionValue()) ?>">
<input type="hidden" name="fk_rid" value="<?= HtmlEncode($Page->req_material_rid->getSessionValue()) ?>">
<input type="hidden" name="fk_packing_type" value="<?= HtmlEncode($Page->req_material_packing->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_material_required_weekly_loomplan" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_material_required_weekly_loomplanlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->poid->Visible) { // poid ?>
        <th data-name="poid" class="<?= $Page->poid->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_poid" class="material_required_weekly_loomplan_poid"><?= $Page->renderFieldHeader($Page->poid) ?></div></th>
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <th data-name="weaving_works" class="<?= $Page->weaving_works->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_weaving_works" class="material_required_weekly_loomplan_weaving_works"><?= $Page->renderFieldHeader($Page->weaving_works) ?></div></th>
<?php } ?>
<?php if ($Page->week->Visible) { // week ?>
        <th data-name="week" class="<?= $Page->week->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_week" class="material_required_weekly_loomplan_week"><?= $Page->renderFieldHeader($Page->week) ?></div></th>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_po" class="material_required_weekly_loomplan_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <th data-name="buyer_id" class="<?= $Page->buyer_id->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_buyer_id" class="material_required_weekly_loomplan_buyer_id"><?= $Page->renderFieldHeader($Page->buyer_id) ?></div></th>
<?php } ?>
<?php if ($Page->product_id->Visible) { // product_id ?>
        <th data-name="product_id" class="<?= $Page->product_id->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_product_id" class="material_required_weekly_loomplan_product_id"><?= $Page->renderFieldHeader($Page->product_id) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_required_weekly_loomplan_batch_no" class="material_required_weekly_loomplan_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_quantity" class="material_required_weekly_loomplan_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->Size_wl->Visible) { // Size_wl ?>
        <th data-name="Size_wl" class="<?= $Page->Size_wl->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_Size_wl" class="material_required_weekly_loomplan_Size_wl"><?= $Page->renderFieldHeader($Page->Size_wl) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_sqm" class="material_required_weekly_loomplan_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <th data-name="req_material_rid" class="<?= $Page->req_material_rid->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_req_material_rid" class="material_required_weekly_loomplan_req_material_rid"><?= $Page->renderFieldHeader($Page->req_material_rid) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <th data-name="req_material_packing" class="<?= $Page->req_material_packing->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_req_material_packing" class="material_required_weekly_loomplan_req_material_packing"><?= $Page->renderFieldHeader($Page->req_material_packing) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <th data-name="req_material_qty" class="<?= $Page->req_material_qty->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_req_material_qty" class="material_required_weekly_loomplan_req_material_qty"><?= $Page->renderFieldHeader($Page->req_material_qty) ?></div></th>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
        <th data-name="unit" class="<?= $Page->unit->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_unit" class="material_required_weekly_loomplan_unit"><?= $Page->renderFieldHeader($Page->unit) ?></div></th>
<?php } ?>
<?php if ($Page->material_qty->Visible) { // material_qty ?>
        <th data-name="material_qty" class="<?= $Page->material_qty->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_material_qty" class="material_required_weekly_loomplan_material_qty"><?= $Page->renderFieldHeader($Page->material_qty) ?></div></th>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
        <th data-name="method" class="<?= $Page->method->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_method" class="material_required_weekly_loomplan_method"><?= $Page->renderFieldHeader($Page->method) ?></div></th>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <th data-name="despatch_week" class="<?= $Page->despatch_week->headerCellClass() ?>"><div id="elh_material_required_weekly_loomplan_despatch_week" class="material_required_weekly_loomplan_despatch_week"><?= $Page->renderFieldHeader($Page->despatch_week) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->poid->Visible) { // poid ?>
        <td data-name="poid"<?= $Page->poid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_poid" class="el_material_required_weekly_loomplan_poid">
<span<?= $Page->poid->viewAttributes() ?>>
<?= $Page->poid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <td data-name="weaving_works"<?= $Page->weaving_works->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_weaving_works" class="el_material_required_weekly_loomplan_weaving_works">
<span<?= $Page->weaving_works->viewAttributes() ?>>
<?= $Page->weaving_works->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->week->Visible) { // week ?>
        <td data-name="week"<?= $Page->week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_week" class="el_material_required_weekly_loomplan_week">
<span<?= $Page->week->viewAttributes() ?>>
<?= $Page->week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_po" class="el_material_required_weekly_loomplan_po">
<span<?= $Page->po->viewAttributes() ?>>
<?= $Page->po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id"<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_buyer_id" class="el_material_required_weekly_loomplan_buyer_id">
<span<?= $Page->buyer_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyer_id->getViewValue()) && $Page->buyer_id->linkAttributes() != "") { ?>
<a<?= $Page->buyer_id->linkAttributes() ?>><?= $Page->buyer_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->buyer_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_id->Visible) { // product_id ?>
        <td data-name="product_id"<?= $Page->product_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_product_id" class="el_material_required_weekly_loomplan_product_id">
<span<?= $Page->product_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->product_id->getViewValue()) && $Page->product_id->linkAttributes() != "") { ?>
<a<?= $Page->product_id->linkAttributes() ?>><?= $Page->product_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_batch_no" class="el_material_required_weekly_loomplan_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?php if (!EmptyString($Page->batch_no->getViewValue()) && $Page->batch_no->linkAttributes() != "") { ?>
<a<?= $Page->batch_no->linkAttributes() ?>><?= $Page->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_quantity" class="el_material_required_weekly_loomplan_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Size_wl->Visible) { // Size_wl ?>
        <td data-name="Size_wl"<?= $Page->Size_wl->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_Size_wl" class="el_material_required_weekly_loomplan_Size_wl">
<span<?= $Page->Size_wl->viewAttributes() ?>>
<?= $Page->Size_wl->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_sqm" class="el_material_required_weekly_loomplan_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <td data-name="req_material_rid"<?= $Page->req_material_rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_req_material_rid" class="el_material_required_weekly_loomplan_req_material_rid">
<span<?= $Page->req_material_rid->viewAttributes() ?>>
<?php if (!EmptyString($Page->req_material_rid->getViewValue()) && $Page->req_material_rid->linkAttributes() != "") { ?>
<a<?= $Page->req_material_rid->linkAttributes() ?>><?= $Page->req_material_rid->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->req_material_rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <td data-name="req_material_packing"<?= $Page->req_material_packing->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_req_material_packing" class="el_material_required_weekly_loomplan_req_material_packing">
<span<?= $Page->req_material_packing->viewAttributes() ?>>
<?= $Page->req_material_packing->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <td data-name="req_material_qty"<?= $Page->req_material_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_req_material_qty" class="el_material_required_weekly_loomplan_req_material_qty">
<span<?= $Page->req_material_qty->viewAttributes() ?>>
<?= $Page->req_material_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->unit->Visible) { // unit ?>
        <td data-name="unit"<?= $Page->unit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_unit" class="el_material_required_weekly_loomplan_unit">
<span<?= $Page->unit->viewAttributes() ?>>
<?= $Page->unit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->material_qty->Visible) { // material_qty ?>
        <td data-name="material_qty"<?= $Page->material_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_material_qty" class="el_material_required_weekly_loomplan_material_qty">
<span<?= $Page->material_qty->viewAttributes() ?>>
<?= $Page->material_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->method->Visible) { // method ?>
        <td data-name="method"<?= $Page->method->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_method" class="el_material_required_weekly_loomplan_method">
<span<?= $Page->method->viewAttributes() ?>>
<?= $Page->method->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <td data-name="despatch_week"<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_weekly_loomplan_despatch_week" class="el_material_required_weekly_loomplan_despatch_week">
<span<?= $Page->despatch_week->viewAttributes() ?>>
<?= $Page->despatch_week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->poid->Visible) { // poid ?>
        <td data-name="poid" class="<?= $Page->poid->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_poid" class="material_required_weekly_loomplan_poid">
        </span></td>
    <?php } ?>
    <?php if ($Page->weaving_works->Visible) { // weaving_works ?>
        <td data-name="weaving_works" class="<?= $Page->weaving_works->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_weaving_works" class="material_required_weekly_loomplan_weaving_works">
        </span></td>
    <?php } ?>
    <?php if ($Page->week->Visible) { // week ?>
        <td data-name="week" class="<?= $Page->week->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_week" class="material_required_weekly_loomplan_week">
        </span></td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po" class="<?= $Page->po->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_po" class="material_required_weekly_loomplan_po">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id" class="<?= $Page->buyer_id->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_buyer_id" class="material_required_weekly_loomplan_buyer_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->product_id->Visible) { // product_id ?>
        <td data-name="product_id" class="<?= $Page->product_id->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_product_id" class="material_required_weekly_loomplan_product_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no" class="<?= $Page->batch_no->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_batch_no" class="material_required_weekly_loomplan_batch_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity" class="<?= $Page->quantity->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_quantity" class="material_required_weekly_loomplan_quantity">
        </span></td>
    <?php } ?>
    <?php if ($Page->Size_wl->Visible) { // Size_wl ?>
        <td data-name="Size_wl" class="<?= $Page->Size_wl->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_Size_wl" class="material_required_weekly_loomplan_Size_wl">
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm" class="<?= $Page->sqm->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_sqm" class="material_required_weekly_loomplan_sqm">
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <td data-name="req_material_rid" class="<?= $Page->req_material_rid->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_req_material_rid" class="material_required_weekly_loomplan_req_material_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <td data-name="req_material_packing" class="<?= $Page->req_material_packing->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_req_material_packing" class="material_required_weekly_loomplan_req_material_packing">
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <td data-name="req_material_qty" class="<?= $Page->req_material_qty->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_req_material_qty" class="material_required_weekly_loomplan_req_material_qty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->req_material_qty->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->unit->Visible) { // unit ?>
        <td data-name="unit" class="<?= $Page->unit->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_unit" class="material_required_weekly_loomplan_unit">
        </span></td>
    <?php } ?>
    <?php if ($Page->material_qty->Visible) { // material_qty ?>
        <td data-name="material_qty" class="<?= $Page->material_qty->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_material_qty" class="material_required_weekly_loomplan_material_qty">
        </span></td>
    <?php } ?>
    <?php if ($Page->method->Visible) { // method ?>
        <td data-name="method" class="<?= $Page->method->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_method" class="material_required_weekly_loomplan_method">
        </span></td>
    <?php } ?>
    <?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <td data-name="despatch_week" class="<?= $Page->despatch_week->footerCellClass() ?>"><span id="elf_material_required_weekly_loomplan_despatch_week" class="material_required_weekly_loomplan_despatch_week">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_required_weekly_loomplan");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
