<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialRequiredProcessingOutsideOldList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_processing_outside_old: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fmaterial_required_processing_outside_oldsrch" id="fmaterial_required_processing_outside_oldsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fmaterial_required_processing_outside_oldsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_processing_outside_old: currentTable } });
var currentForm;
var fmaterial_required_processing_outside_oldsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmaterial_required_processing_outside_oldsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["location", [], fields.location.isInvalid],
            ["issue_to", [ew.Validators.integer], fields.issue_to.isInvalid],
            ["week", [], fields.week.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["short", [ew.Validators.float], fields.short.isInvalid],
            ["y_short", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "issue_to": <?= $Page->issue_to->toClientList($Page) ?>,
            "week": <?= $Page->week->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->location->Visible) { // location ?>
<?php
if (!$Page->location->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_location" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->location->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_location" class="ew-search-caption ew-label"><?= $Page->location->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</div>
        </div>
        <div id="el_material_required_processing_outside_old_location" class="ew-search-field">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outside_oldsrch_x_location"
        <?php } ?>
        data-table="material_required_processing_outside_old"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outside_oldsrch", function() {
    var options = { name: "x_location", selectId: "fmaterial_required_processing_outside_oldsrch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outside_oldsrch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fmaterial_required_processing_outside_oldsrch" };
    } else {
        options.ajax = { id: "x_location", form: "fmaterial_required_processing_outside_oldsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside_old.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
<?php
if (!$Page->issue_to->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_issue_to" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->issue_to->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->issue_to->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_to" id="z_issue_to" value="=">
</div>
        </div>
        <div id="el_material_required_processing_outside_old_issue_to" class="ew-search-field">
    <select
        id="x_issue_to"
        name="x_issue_to"
        class="form-control ew-select<?= $Page->issue_to->isInvalidClass() ?>"
        data-select2-id="fmaterial_required_processing_outside_oldsrch_x_issue_to"
        data-table="material_required_processing_outside_old"
        data-field="x_issue_to"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->issue_to->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->issue_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>"
        <?= $Page->issue_to->editAttributes() ?>>
        <?= $Page->issue_to->selectOptionListHtml("x_issue_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage(false) ?></div>
<?= $Page->issue_to->Lookup->getParamTag($Page, "p_x_issue_to") ?>
<script>
loadjs.ready("fmaterial_required_processing_outside_oldsrch", function() {
    var options = { name: "x_issue_to", selectId: "fmaterial_required_processing_outside_oldsrch_x_issue_to" };
    if (fmaterial_required_processing_outside_oldsrch.lists.issue_to?.lookupOptions.length) {
        options.data = { id: "x_issue_to", form: "fmaterial_required_processing_outside_oldsrch" };
    } else {
        options.ajax = { id: "x_issue_to", form: "fmaterial_required_processing_outside_oldsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.material_required_processing_outside_old.fields.issue_to.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->week->Visible) { // week ?>
<?php
if (!$Page->week->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_week" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->week->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_week" class="ew-search-caption ew-label"><?= $Page->week->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_week" id="z_week" value="=">
</div>
        </div>
        <div id="el_material_required_processing_outside_old_week" class="ew-search-field">
    <select
        id="x_week"
        name="x_week"
        class="form-select ew-select<?= $Page->week->isInvalidClass() ?>"
        <?php if (!$Page->week->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outside_oldsrch_x_week"
        <?php } ?>
        data-table="material_required_processing_outside_old"
        data-field="x_week"
        data-value-separator="<?= $Page->week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->week->getPlaceHolder()) ?>"
        <?= $Page->week->editAttributes() ?>>
        <?= $Page->week->selectOptionListHtml("x_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->week->getErrorMessage(false) ?></div>
<?= $Page->week->Lookup->getParamTag($Page, "p_x_week") ?>
<?php if (!$Page->week->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outside_oldsrch", function() {
    var options = { name: "x_week", selectId: "fmaterial_required_processing_outside_oldsrch_x_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outside_oldsrch.lists.week?.lookupOptions.length) {
        options.data = { id: "x_week", form: "fmaterial_required_processing_outside_oldsrch" };
    } else {
        options.ajax = { id: "x_week", form: "fmaterial_required_processing_outside_oldsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside_old.fields.week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
<?php
if (!$Page->po->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_po" class="ew-search-caption ew-label"><?= $Page->po->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_material_required_processing_outside_old_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="material_required_processing_outside_old" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_material_required_processing_outside_old_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="material_required_processing_outside_old" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->short->Visible) { // short ?>
<?php
if (!$Page->short->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_short" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->short->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_short" class="ew-search-caption ew-label"><?= $Page->short->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_short" id="z_short" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->short->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->short->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_material_required_processing_outside_old_short" class="ew-search-field">
<input type="<?= $Page->short->getInputTextType() ?>" name="x_short" id="x_short" data-table="material_required_processing_outside_old" data-field="x_short" value="<?= $Page->short->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->short->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->short->formatPattern()) ?>"<?= $Page->short->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->short->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_material_required_processing_outside_old_short" class="ew-search-field2 d-none">
<input type="<?= $Page->short->getInputTextType() ?>" name="y_short" id="y_short" data-table="material_required_processing_outside_old" data-field="x_short" value="<?= $Page->short->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->short->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->short->formatPattern()) ?>"<?= $Page->short->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->short->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fmaterial_required_processing_outside_oldsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fmaterial_required_processing_outside_oldsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fmaterial_required_processing_outside_oldsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fmaterial_required_processing_outside_oldsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fmaterial_required_processing_outside_oldsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fmaterial_required_processing_outside_oldsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fmaterial_required_processing_outside_oldsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_required_processing_outside_old">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_material_required_processing_outside_old" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_material_required_processing_outside_oldlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_id" class="material_required_processing_outside_old_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->poid->Visible) { // poid ?>
        <th data-name="poid" class="<?= $Page->poid->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_poid" class="material_required_processing_outside_old_poid"><?= $Page->renderFieldHeader($Page->poid) ?></div></th>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
        <th data-name="jc_no" class="<?= $Page->jc_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_required_processing_outside_old_jc_no" class="material_required_processing_outside_old_jc_no"><?= $Page->renderFieldHeader($Page->jc_no) ?></div></th>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
        <th data-name="location" class="<?= $Page->location->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_location" class="material_required_processing_outside_old_location"><?= $Page->renderFieldHeader($Page->location) ?></div></th>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
        <th data-name="issue_to" class="<?= $Page->issue_to->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_required_processing_outside_old_issue_to" class="material_required_processing_outside_old_issue_to"><?= $Page->renderFieldHeader($Page->issue_to) ?></div></th>
<?php } ?>
<?php if ($Page->week->Visible) { // week ?>
        <th data-name="week" class="<?= $Page->week->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_week" class="material_required_processing_outside_old_week"><?= $Page->renderFieldHeader($Page->week) ?></div></th>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_po" class="material_required_processing_outside_old_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_required_processing_outside_old_company_id" class="material_required_processing_outside_old_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <th data-name="buyer_id" class="<?= $Page->buyer_id->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_buyer_id" class="material_required_processing_outside_old_buyer_id"><?= $Page->renderFieldHeader($Page->buyer_id) ?></div></th>
<?php } ?>
<?php if ($Page->product_id->Visible) { // product_id ?>
        <th data-name="product_id" class="<?= $Page->product_id->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_product_id" class="material_required_processing_outside_old_product_id"><?= $Page->renderFieldHeader($Page->product_id) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_required_processing_outside_old_batch_no" class="material_required_processing_outside_old_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_quantity" class="material_required_processing_outside_old_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
        <th data-name="size_cm" class="<?= $Page->size_cm->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_size_cm" class="material_required_processing_outside_old_size_cm"><?= $Page->renderFieldHeader($Page->size_cm) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_sqm" class="material_required_processing_outside_old_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->t_sqm->Visible) { // t_sqm ?>
        <th data-name="t_sqm" class="<?= $Page->t_sqm->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_t_sqm" class="material_required_processing_outside_old_t_sqm"><?= $Page->renderFieldHeader($Page->t_sqm) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <th data-name="req_material_rid" class="<?= $Page->req_material_rid->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_req_material_rid" class="material_required_processing_outside_old_req_material_rid"><?= $Page->renderFieldHeader($Page->req_material_rid) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <th data-name="req_material_qty" class="<?= $Page->req_material_qty->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_req_material_qty" class="material_required_processing_outside_old_req_material_qty"><?= $Page->renderFieldHeader($Page->req_material_qty) ?></div></th>
<?php } ?>
<?php if ($Page->issued_qty->Visible) { // issued_qty ?>
        <th data-name="issued_qty" class="<?= $Page->issued_qty->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_issued_qty" class="material_required_processing_outside_old_issued_qty"><?= $Page->renderFieldHeader($Page->issued_qty) ?></div></th>
<?php } ?>
<?php if ($Page->issued_pkt->Visible) { // issued_pkt ?>
        <th data-name="issued_pkt" class="<?= $Page->issued_pkt->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_issued_pkt" class="material_required_processing_outside_old_issued_pkt"><?= $Page->renderFieldHeader($Page->issued_pkt) ?></div></th>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
        <th data-name="lot_no" class="<?= $Page->lot_no->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_lot_no" class="material_required_processing_outside_old_lot_no"><?= $Page->renderFieldHeader($Page->lot_no) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <th data-name="req_material_packing" class="<?= $Page->req_material_packing->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_req_material_packing" class="material_required_processing_outside_old_req_material_packing"><?= $Page->renderFieldHeader($Page->req_material_packing) ?></div></th>
<?php } ?>
<?php if ($Page->stock->Visible) { // stock ?>
        <th data-name="stock" class="<?= $Page->stock->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_stock" class="material_required_processing_outside_old_stock"><?= $Page->renderFieldHeader($Page->stock) ?></div></th>
<?php } ?>
<?php if ($Page->short->Visible) { // short ?>
        <th data-name="short" class="<?= $Page->short->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_short" class="material_required_processing_outside_old_short"><?= $Page->renderFieldHeader($Page->short) ?></div></th>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
        <th data-name="unit" class="<?= $Page->unit->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_unit" class="material_required_processing_outside_old_unit"><?= $Page->renderFieldHeader($Page->unit) ?></div></th>
<?php } ?>
<?php if ($Page->material_qty->Visible) { // material_qty ?>
        <th data-name="material_qty" class="<?= $Page->material_qty->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_material_qty" class="material_required_processing_outside_old_material_qty"><?= $Page->renderFieldHeader($Page->material_qty) ?></div></th>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
        <th data-name="method" class="<?= $Page->method->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_method" class="material_required_processing_outside_old_method"><?= $Page->renderFieldHeader($Page->method) ?></div></th>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <th data-name="despatch_week" class="<?= $Page->despatch_week->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_despatch_week" class="material_required_processing_outside_old_despatch_week"><?= $Page->renderFieldHeader($Page->despatch_week) ?></div></th>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <th data-name="despatch_date" class="<?= $Page->despatch_date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_required_processing_outside_old_despatch_date" class="material_required_processing_outside_old_despatch_date"><?= $Page->renderFieldHeader($Page->despatch_date) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_material_required_processing_outside_old_operator" class="material_required_processing_outside_old_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_id" class="el_material_required_processing_outside_old_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->poid->Visible) { // poid ?>
        <td data-name="poid"<?= $Page->poid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_poid" class="el_material_required_processing_outside_old_poid">
<span<?= $Page->poid->viewAttributes() ?>>
<?= $Page->poid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_no->Visible) { // jc_no ?>
        <td data-name="jc_no"<?= $Page->jc_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_jc_no" class="el_material_required_processing_outside_old_jc_no">
<span<?= $Page->jc_no->viewAttributes() ?>>
<?= $Page->jc_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location"<?= $Page->location->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_location" class="el_material_required_processing_outside_old_location">
<span<?= $Page->location->viewAttributes() ?>>
<?= $Page->location->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->issue_to->Visible) { // issue_to ?>
        <td data-name="issue_to"<?= $Page->issue_to->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_issue_to" class="el_material_required_processing_outside_old_issue_to">
<span<?= $Page->issue_to->viewAttributes() ?>>
<?= $Page->issue_to->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->week->Visible) { // week ?>
        <td data-name="week"<?= $Page->week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_week" class="el_material_required_processing_outside_old_week">
<span<?= $Page->week->viewAttributes() ?>>
<?= $Page->week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_po" class="el_material_required_processing_outside_old_po">
<span<?= $Page->po->viewAttributes() ?>>
<?= $Page->po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_company_id" class="el_material_required_processing_outside_old_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id"<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_buyer_id" class="el_material_required_processing_outside_old_buyer_id">
<span<?= $Page->buyer_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyer_id->getViewValue()) && $Page->buyer_id->linkAttributes() != "") { ?>
<a<?= $Page->buyer_id->linkAttributes() ?>><?= $Page->buyer_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->buyer_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_id->Visible) { // product_id ?>
        <td data-name="product_id"<?= $Page->product_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_product_id" class="el_material_required_processing_outside_old_product_id">
<span<?= $Page->product_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->product_id->getViewValue()) && $Page->product_id->linkAttributes() != "") { ?>
<a<?= $Page->product_id->linkAttributes() ?>><?= $Page->product_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_batch_no" class="el_material_required_processing_outside_old_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?php if (!EmptyString($Page->batch_no->getViewValue()) && $Page->batch_no->linkAttributes() != "") { ?>
<a<?= $Page->batch_no->linkAttributes() ?>><?= $Page->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_quantity" class="el_material_required_processing_outside_old_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm"<?= $Page->size_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_size_cm" class="el_material_required_processing_outside_old_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<?= $Page->size_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_sqm" class="el_material_required_processing_outside_old_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_sqm->Visible) { // t_sqm ?>
        <td data-name="t_sqm"<?= $Page->t_sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_t_sqm" class="el_material_required_processing_outside_old_t_sqm">
<span<?= $Page->t_sqm->viewAttributes() ?>>
<?= $Page->t_sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <td data-name="req_material_rid"<?= $Page->req_material_rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_req_material_rid" class="el_material_required_processing_outside_old_req_material_rid">
<span<?= $Page->req_material_rid->viewAttributes() ?>>
<?php if (!EmptyString($Page->req_material_rid->getViewValue()) && $Page->req_material_rid->linkAttributes() != "") { ?>
<a<?= $Page->req_material_rid->linkAttributes() ?>><?= $Page->req_material_rid->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->req_material_rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <td data-name="req_material_qty"<?= $Page->req_material_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_req_material_qty" class="el_material_required_processing_outside_old_req_material_qty">
<span<?= $Page->req_material_qty->viewAttributes() ?>>
<?= $Page->req_material_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->issued_qty->Visible) { // issued_qty ?>
        <td data-name="issued_qty"<?= $Page->issued_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_issued_qty" class="el_material_required_processing_outside_old_issued_qty">
<span<?= $Page->issued_qty->viewAttributes() ?>>
<?= $Page->issued_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->issued_pkt->Visible) { // issued_pkt ?>
        <td data-name="issued_pkt"<?= $Page->issued_pkt->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_issued_pkt" class="el_material_required_processing_outside_old_issued_pkt">
<span<?= $Page->issued_pkt->viewAttributes() ?>>
<?= $Page->issued_pkt->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lot_no->Visible) { // lot_no ?>
        <td data-name="lot_no"<?= $Page->lot_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_lot_no" class="el_material_required_processing_outside_old_lot_no">
<span<?= $Page->lot_no->viewAttributes() ?>>
<?= $Page->lot_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <td data-name="req_material_packing"<?= $Page->req_material_packing->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_req_material_packing" class="el_material_required_processing_outside_old_req_material_packing">
<span<?= $Page->req_material_packing->viewAttributes() ?>>
<?= $Page->req_material_packing->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->stock->Visible) { // stock ?>
        <td data-name="stock"<?= $Page->stock->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_stock" class="el_material_required_processing_outside_old_stock">
<span<?= $Page->stock->viewAttributes() ?>>
<?= $Page->stock->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->short->Visible) { // short ?>
        <td data-name="short"<?= $Page->short->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_short" class="el_material_required_processing_outside_old_short">
<span<?= $Page->short->viewAttributes() ?>>
<?= $Page->short->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->unit->Visible) { // unit ?>
        <td data-name="unit"<?= $Page->unit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_unit" class="el_material_required_processing_outside_old_unit">
<span<?= $Page->unit->viewAttributes() ?>>
<?= $Page->unit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->material_qty->Visible) { // material_qty ?>
        <td data-name="material_qty"<?= $Page->material_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_material_qty" class="el_material_required_processing_outside_old_material_qty">
<span<?= $Page->material_qty->viewAttributes() ?>>
<?= $Page->material_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->method->Visible) { // method ?>
        <td data-name="method"<?= $Page->method->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_method" class="el_material_required_processing_outside_old_method">
<span<?= $Page->method->viewAttributes() ?>>
<?= $Page->method->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <td data-name="despatch_week"<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_despatch_week" class="el_material_required_processing_outside_old_despatch_week">
<span<?= $Page->despatch_week->viewAttributes() ?>>
<?= $Page->despatch_week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <td data-name="despatch_date"<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_despatch_date" class="el_material_required_processing_outside_old_despatch_date">
<span<?= $Page->despatch_date->viewAttributes() ?>>
<?= $Page->despatch_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_processing_outside_old_operator" class="el_material_required_processing_outside_old_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_id" class="material_required_processing_outside_old_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->poid->Visible) { // poid ?>
        <td data-name="poid" class="<?= $Page->poid->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_poid" class="material_required_processing_outside_old_poid">
        </span></td>
    <?php } ?>
    <?php if ($Page->jc_no->Visible) { // jc_no ?>
        <td data-name="jc_no" class="<?= $Page->jc_no->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_jc_no" class="material_required_processing_outside_old_jc_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location" class="<?= $Page->location->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_location" class="material_required_processing_outside_old_location">
        </span></td>
    <?php } ?>
    <?php if ($Page->issue_to->Visible) { // issue_to ?>
        <td data-name="issue_to" class="<?= $Page->issue_to->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_issue_to" class="material_required_processing_outside_old_issue_to">
        </span></td>
    <?php } ?>
    <?php if ($Page->week->Visible) { // week ?>
        <td data-name="week" class="<?= $Page->week->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_week" class="material_required_processing_outside_old_week">
        </span></td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po" class="<?= $Page->po->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_po" class="material_required_processing_outside_old_po">
        </span></td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id" class="<?= $Page->company_id->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_company_id" class="material_required_processing_outside_old_company_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id" class="<?= $Page->buyer_id->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_buyer_id" class="material_required_processing_outside_old_buyer_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->product_id->Visible) { // product_id ?>
        <td data-name="product_id" class="<?= $Page->product_id->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_product_id" class="material_required_processing_outside_old_product_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no" class="<?= $Page->batch_no->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_batch_no" class="material_required_processing_outside_old_batch_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity" class="<?= $Page->quantity->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_quantity" class="material_required_processing_outside_old_quantity">
        </span></td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm" class="<?= $Page->size_cm->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_size_cm" class="material_required_processing_outside_old_size_cm">
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm" class="<?= $Page->sqm->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_sqm" class="material_required_processing_outside_old_sqm">
        </span></td>
    <?php } ?>
    <?php if ($Page->t_sqm->Visible) { // t_sqm ?>
        <td data-name="t_sqm" class="<?= $Page->t_sqm->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_t_sqm" class="material_required_processing_outside_old_t_sqm">
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <td data-name="req_material_rid" class="<?= $Page->req_material_rid->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_req_material_rid" class="material_required_processing_outside_old_req_material_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <td data-name="req_material_qty" class="<?= $Page->req_material_qty->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_req_material_qty" class="material_required_processing_outside_old_req_material_qty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->req_material_qty->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->issued_qty->Visible) { // issued_qty ?>
        <td data-name="issued_qty" class="<?= $Page->issued_qty->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_issued_qty" class="material_required_processing_outside_old_issued_qty">
        </span></td>
    <?php } ?>
    <?php if ($Page->issued_pkt->Visible) { // issued_pkt ?>
        <td data-name="issued_pkt" class="<?= $Page->issued_pkt->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_issued_pkt" class="material_required_processing_outside_old_issued_pkt">
        </span></td>
    <?php } ?>
    <?php if ($Page->lot_no->Visible) { // lot_no ?>
        <td data-name="lot_no" class="<?= $Page->lot_no->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_lot_no" class="material_required_processing_outside_old_lot_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <td data-name="req_material_packing" class="<?= $Page->req_material_packing->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_req_material_packing" class="material_required_processing_outside_old_req_material_packing">
        </span></td>
    <?php } ?>
    <?php if ($Page->stock->Visible) { // stock ?>
        <td data-name="stock" class="<?= $Page->stock->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_stock" class="material_required_processing_outside_old_stock">
        </span></td>
    <?php } ?>
    <?php if ($Page->short->Visible) { // short ?>
        <td data-name="short" class="<?= $Page->short->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_short" class="material_required_processing_outside_old_short">
        </span></td>
    <?php } ?>
    <?php if ($Page->unit->Visible) { // unit ?>
        <td data-name="unit" class="<?= $Page->unit->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_unit" class="material_required_processing_outside_old_unit">
        </span></td>
    <?php } ?>
    <?php if ($Page->material_qty->Visible) { // material_qty ?>
        <td data-name="material_qty" class="<?= $Page->material_qty->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_material_qty" class="material_required_processing_outside_old_material_qty">
        </span></td>
    <?php } ?>
    <?php if ($Page->method->Visible) { // method ?>
        <td data-name="method" class="<?= $Page->method->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_method" class="material_required_processing_outside_old_method">
        </span></td>
    <?php } ?>
    <?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <td data-name="despatch_week" class="<?= $Page->despatch_week->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_despatch_week" class="material_required_processing_outside_old_despatch_week">
        </span></td>
    <?php } ?>
    <?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <td data-name="despatch_date" class="<?= $Page->despatch_date->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_despatch_date" class="material_required_processing_outside_old_despatch_date">
        </span></td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator" class="<?= $Page->operator->footerCellClass() ?>"><span id="elf_material_required_processing_outside_old_operator" class="material_required_processing_outside_old_operator">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_required_processing_outside_old");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
