<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialRequiredProcessingOutsideEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fmaterial_required_processing_outsideedit" id="fmaterial_required_processing_outsideedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_processing_outside: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fmaterial_required_processing_outsideedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmaterial_required_processing_outsideedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["poid", [fields.poid.visible && fields.poid.required ? ew.Validators.required(fields.poid.caption) : null], fields.poid.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["week", [fields.week.visible && fields.week.required ? ew.Validators.required(fields.week.caption) : null], fields.week.isInvalid],
            ["po", [fields.po.visible && fields.po.required ? ew.Validators.required(fields.po.caption) : null], fields.po.isInvalid],
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null], fields.buyer_id.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["product_id", [fields.product_id.visible && fields.product_id.required ? ew.Validators.required(fields.product_id.caption) : null], fields.product_id.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null], fields.batch_no.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null], fields.quantity.isInvalid],
            ["size_cm", [fields.size_cm.visible && fields.size_cm.required ? ew.Validators.required(fields.size_cm.caption) : null], fields.size_cm.isInvalid],
            ["sqm", [fields.sqm.visible && fields.sqm.required ? ew.Validators.required(fields.sqm.caption) : null], fields.sqm.isInvalid],
            ["t_sqm", [fields.t_sqm.visible && fields.t_sqm.required ? ew.Validators.required(fields.t_sqm.caption) : null], fields.t_sqm.isInvalid],
            ["req_material_grp", [fields.req_material_grp.visible && fields.req_material_grp.required ? ew.Validators.required(fields.req_material_grp.caption) : null], fields.req_material_grp.isInvalid],
            ["req_material_sgrp", [fields.req_material_sgrp.visible && fields.req_material_sgrp.required ? ew.Validators.required(fields.req_material_sgrp.caption) : null], fields.req_material_sgrp.isInvalid],
            ["req_material_product", [fields.req_material_product.visible && fields.req_material_product.required ? ew.Validators.required(fields.req_material_product.caption) : null], fields.req_material_product.isInvalid],
            ["req_material_packing", [fields.req_material_packing.visible && fields.req_material_packing.required ? ew.Validators.required(fields.req_material_packing.caption) : null], fields.req_material_packing.isInvalid],
            ["req_material_rid", [fields.req_material_rid.visible && fields.req_material_rid.required ? ew.Validators.required(fields.req_material_rid.caption) : null, ew.Validators.integer], fields.req_material_rid.isInvalid],
            ["req_material_qty", [fields.req_material_qty.visible && fields.req_material_qty.required ? ew.Validators.required(fields.req_material_qty.caption) : null], fields.req_material_qty.isInvalid],
            ["issued_qty", [fields.issued_qty.visible && fields.issued_qty.required ? ew.Validators.required(fields.issued_qty.caption) : null, ew.Validators.float], fields.issued_qty.isInvalid],
            ["issued_pkt", [fields.issued_pkt.visible && fields.issued_pkt.required ? ew.Validators.required(fields.issued_pkt.caption) : null, ew.Validators.float], fields.issued_pkt.isInvalid],
            ["lot_no", [fields.lot_no.visible && fields.lot_no.required ? ew.Validators.required(fields.lot_no.caption) : null], fields.lot_no.isInvalid],
            ["stock", [fields.stock.visible && fields.stock.required ? ew.Validators.required(fields.stock.caption) : null], fields.stock.isInvalid],
            ["short", [fields.short.visible && fields.short.required ? ew.Validators.required(fields.short.caption) : null], fields.short.isInvalid],
            ["unit", [fields.unit.visible && fields.unit.required ? ew.Validators.required(fields.unit.caption) : null], fields.unit.isInvalid],
            ["material_qty", [fields.material_qty.visible && fields.material_qty.required ? ew.Validators.required(fields.material_qty.caption) : null], fields.material_qty.isInvalid],
            ["method", [fields.method.visible && fields.method.required ? ew.Validators.required(fields.method.caption) : null], fields.method.isInvalid],
            ["despatch_week", [fields.despatch_week.visible && fields.despatch_week.required ? ew.Validators.required(fields.despatch_week.caption) : null], fields.despatch_week.isInvalid],
            ["despatch_date", [fields.despatch_date.visible && fields.despatch_date.required ? ew.Validators.required(fields.despatch_date.caption) : null], fields.despatch_date.isInvalid],
            ["production_plan", [fields.production_plan.visible && fields.production_plan.required ? ew.Validators.required(fields.production_plan.caption) : null], fields.production_plan.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["issue_to", [fields.issue_to.visible && fields.issue_to.required ? ew.Validators.required(fields.issue_to.caption) : null], fields.issue_to.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "req_material_grp": <?= $Page->req_material_grp->toClientList($Page) ?>,
            "req_material_sgrp": <?= $Page->req_material_sgrp->toClientList($Page) ?>,
            "req_material_product": <?= $Page->req_material_product->toClientList($Page) ?>,
            "req_material_packing": <?= $Page->req_material_packing->toClientList($Page) ?>,
            "req_material_rid": <?= $Page->req_material_rid->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_required_processing_outside">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_material_required_processing_outside_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->poid->Visible) { // poid ?>
    <div id="r_poid"<?= $Page->poid->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_poid" for="x_poid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->poid->caption() ?><?= $Page->poid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->poid->cellAttributes() ?>>
<span id="el_material_required_processing_outside_poid">
<span<?= $Page->poid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->poid->getDisplayValue($Page->poid->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_poid" data-hidden="1" name="x_poid" id="x_poid" value="<?= HtmlEncode($Page->poid->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_location" for="x_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_material_required_processing_outside_location">
<span<?= $Page->location->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->location->getDisplayValue($Page->location->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_location" data-hidden="1" name="x_location" id="x_location" value="<?= HtmlEncode($Page->location->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->week->Visible) { // week ?>
    <div id="r_week"<?= $Page->week->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_week" for="x_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->week->caption() ?><?= $Page->week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->week->cellAttributes() ?>>
<span id="el_material_required_processing_outside_week">
<span<?= $Page->week->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->week->getDisplayValue($Page->week->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_week" data-hidden="1" name="x_week" id="x_week" value="<?= HtmlEncode($Page->week->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po"<?= $Page->po->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po->caption() ?><?= $Page->po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po->cellAttributes() ?>>
<span id="el_material_required_processing_outside_po">
<span<?= $Page->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->po->getDisplayValue($Page->po->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_po" data-hidden="1" name="x_po" id="x_po" value="<?= HtmlEncode($Page->po->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id"<?= $Page->buyer_id->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_buyer_id" for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_id->caption() ?><?= $Page->buyer_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el_material_required_processing_outside_buyer_id">
<span<?= $Page->buyer_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyer_id->EditValue) && $Page->buyer_id->linkAttributes() != "") { ?>
<a<?= $Page->buyer_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->buyer_id->getDisplayValue($Page->buyer_id->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->buyer_id->getDisplayValue($Page->buyer_id->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_buyer_id" data-hidden="1" name="x_buyer_id" id="x_buyer_id" value="<?= HtmlEncode($Page->buyer_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_material_required_processing_outside_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->grp->getDisplayValue($Page->grp->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_grp" data-hidden="1" name="x_grp" id="x_grp" value="<?= HtmlEncode($Page->grp->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_material_required_processing_outside_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->s_grp->EditValue) && $Page->s_grp->linkAttributes() != "") { ?>
<a<?= $Page->s_grp->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->s_grp->getDisplayValue($Page->s_grp->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->s_grp->getDisplayValue($Page->s_grp->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_s_grp" data-hidden="1" name="x_s_grp" id="x_s_grp" value="<?= HtmlEncode($Page->s_grp->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_material_required_processing_outside_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->EditValue) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->product->getDisplayValue($Page->product->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->product->getDisplayValue($Page->product->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_product" data-hidden="1" name="x_product" id="x_product" value="<?= HtmlEncode($Page->product->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_id->Visible) { // product_id ?>
    <div id="r_product_id"<?= $Page->product_id->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_product_id" for="x_product_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_id->caption() ?><?= $Page->product_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_id->cellAttributes() ?>>
<span id="el_material_required_processing_outside_product_id">
<span<?= $Page->product_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->product_id->EditValue) && $Page->product_id->linkAttributes() != "") { ?>
<a<?= $Page->product_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->product_id->getDisplayValue($Page->product_id->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->product_id->getDisplayValue($Page->product_id->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_product_id" data-hidden="1" name="x_product_id" id="x_product_id" value="<?= HtmlEncode($Page->product_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no"<?= $Page->batch_no->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_batch_no" for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->batch_no->caption() ?><?= $Page->batch_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->batch_no->cellAttributes() ?>>
<span id="el_material_required_processing_outside_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?php if (!EmptyString($Page->batch_no->EditValue) && $Page->batch_no->linkAttributes() != "") { ?>
<a<?= $Page->batch_no->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->batch_no->getDisplayValue($Page->batch_no->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->batch_no->getDisplayValue($Page->batch_no->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_batch_no" data-hidden="1" name="x_batch_no" id="x_batch_no" value="<?= HtmlEncode($Page->batch_no->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_material_required_processing_outside_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->quantity->getDisplayValue($Page->quantity->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_quantity" data-hidden="1" name="x_quantity" id="x_quantity" value="<?= HtmlEncode($Page->quantity->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm"<?= $Page->size_cm->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_size_cm" for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size_cm->caption() ?><?= $Page->size_cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size_cm->cellAttributes() ?>>
<span id="el_material_required_processing_outside_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->size_cm->getDisplayValue($Page->size_cm->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_size_cm" data-hidden="1" name="x_size_cm" id="x_size_cm" value="<?= HtmlEncode($Page->size_cm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm"<?= $Page->sqm->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_sqm" for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm->caption() ?><?= $Page->sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm->cellAttributes() ?>>
<span id="el_material_required_processing_outside_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->sqm->getDisplayValue($Page->sqm->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_sqm" data-hidden="1" name="x_sqm" id="x_sqm" value="<?= HtmlEncode($Page->sqm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->t_sqm->Visible) { // t_sqm ?>
    <div id="r_t_sqm"<?= $Page->t_sqm->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_t_sqm" for="x_t_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->t_sqm->caption() ?><?= $Page->t_sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->t_sqm->cellAttributes() ?>>
<span id="el_material_required_processing_outside_t_sqm">
<span<?= $Page->t_sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->t_sqm->getDisplayValue($Page->t_sqm->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_t_sqm" data-hidden="1" name="x_t_sqm" id="x_t_sqm" value="<?= HtmlEncode($Page->t_sqm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_grp->Visible) { // req_material_grp ?>
    <div id="r_req_material_grp"<?= $Page->req_material_grp->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_req_material_grp" for="x_req_material_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_grp->caption() ?><?= $Page->req_material_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_grp->cellAttributes() ?>>
<span id="el_material_required_processing_outside_req_material_grp">
    <select
        id="x_req_material_grp"
        name="x_req_material_grp"
        class="form-select ew-select<?= $Page->req_material_grp->isInvalidClass() ?>"
        <?php if (!$Page->req_material_grp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideedit_x_req_material_grp"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_req_material_grp"
        data-value-separator="<?= $Page->req_material_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->req_material_grp->editAttributes() ?>>
        <?= $Page->req_material_grp->selectOptionListHtml("x_req_material_grp") ?>
    </select>
    <?= $Page->req_material_grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->req_material_grp->getErrorMessage() ?></div>
<?= $Page->req_material_grp->Lookup->getParamTag($Page, "p_x_req_material_grp") ?>
<?php if (!$Page->req_material_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideedit", function() {
    var options = { name: "x_req_material_grp", selectId: "fmaterial_required_processing_outsideedit_x_req_material_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideedit.lists.req_material_grp?.lookupOptions.length) {
        options.data = { id: "x_req_material_grp", form: "fmaterial_required_processing_outsideedit" };
    } else {
        options.ajax = { id: "x_req_material_grp", form: "fmaterial_required_processing_outsideedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.req_material_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_sgrp->Visible) { // req_material_sgrp ?>
    <div id="r_req_material_sgrp"<?= $Page->req_material_sgrp->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_req_material_sgrp" for="x_req_material_sgrp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_sgrp->caption() ?><?= $Page->req_material_sgrp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_sgrp->cellAttributes() ?>>
<span id="el_material_required_processing_outside_req_material_sgrp">
    <select
        id="x_req_material_sgrp"
        name="x_req_material_sgrp"
        class="form-select ew-select<?= $Page->req_material_sgrp->isInvalidClass() ?>"
        <?php if (!$Page->req_material_sgrp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideedit_x_req_material_sgrp"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_req_material_sgrp"
        data-value-separator="<?= $Page->req_material_sgrp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_sgrp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->req_material_sgrp->editAttributes() ?>>
        <?= $Page->req_material_sgrp->selectOptionListHtml("x_req_material_sgrp") ?>
    </select>
    <?= $Page->req_material_sgrp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->req_material_sgrp->getErrorMessage() ?></div>
<?= $Page->req_material_sgrp->Lookup->getParamTag($Page, "p_x_req_material_sgrp") ?>
<?php if (!$Page->req_material_sgrp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideedit", function() {
    var options = { name: "x_req_material_sgrp", selectId: "fmaterial_required_processing_outsideedit_x_req_material_sgrp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideedit.lists.req_material_sgrp?.lookupOptions.length) {
        options.data = { id: "x_req_material_sgrp", form: "fmaterial_required_processing_outsideedit" };
    } else {
        options.ajax = { id: "x_req_material_sgrp", form: "fmaterial_required_processing_outsideedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.req_material_sgrp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_product->Visible) { // req_material_product ?>
    <div id="r_req_material_product"<?= $Page->req_material_product->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_req_material_product" for="x_req_material_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_product->caption() ?><?= $Page->req_material_product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_product->cellAttributes() ?>>
<span id="el_material_required_processing_outside_req_material_product">
    <select
        id="x_req_material_product"
        name="x_req_material_product"
        class="form-select ew-select<?= $Page->req_material_product->isInvalidClass() ?>"
        <?php if (!$Page->req_material_product->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideedit_x_req_material_product"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_req_material_product"
        data-value-separator="<?= $Page->req_material_product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->req_material_product->editAttributes() ?>>
        <?= $Page->req_material_product->selectOptionListHtml("x_req_material_product") ?>
    </select>
    <?= $Page->req_material_product->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->req_material_product->getErrorMessage() ?></div>
<?= $Page->req_material_product->Lookup->getParamTag($Page, "p_x_req_material_product") ?>
<?php if (!$Page->req_material_product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideedit", function() {
    var options = { name: "x_req_material_product", selectId: "fmaterial_required_processing_outsideedit_x_req_material_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideedit.lists.req_material_product?.lookupOptions.length) {
        options.data = { id: "x_req_material_product", form: "fmaterial_required_processing_outsideedit" };
    } else {
        options.ajax = { id: "x_req_material_product", form: "fmaterial_required_processing_outsideedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.req_material_product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
    <div id="r_req_material_packing"<?= $Page->req_material_packing->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_req_material_packing" for="x_req_material_packing" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_packing->caption() ?><?= $Page->req_material_packing->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_packing->cellAttributes() ?>>
<span id="el_material_required_processing_outside_req_material_packing">
    <select
        id="x_req_material_packing"
        name="x_req_material_packing"
        class="form-select ew-select<?= $Page->req_material_packing->isInvalidClass() ?>"
        <?php if (!$Page->req_material_packing->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideedit_x_req_material_packing"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_req_material_packing"
        data-value-separator="<?= $Page->req_material_packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_packing->getPlaceHolder()) ?>"
        <?= $Page->req_material_packing->editAttributes() ?>>
        <?= $Page->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
    </select>
    <?= $Page->req_material_packing->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->req_material_packing->getErrorMessage() ?></div>
<?= $Page->req_material_packing->Lookup->getParamTag($Page, "p_x_req_material_packing") ?>
<?php if (!$Page->req_material_packing->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideedit", function() {
    var options = { name: "x_req_material_packing", selectId: "fmaterial_required_processing_outsideedit_x_req_material_packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideedit.lists.req_material_packing?.lookupOptions.length) {
        options.data = { id: "x_req_material_packing", form: "fmaterial_required_processing_outsideedit" };
    } else {
        options.ajax = { id: "x_req_material_packing", form: "fmaterial_required_processing_outsideedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.req_material_packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
    <div id="r_req_material_rid"<?= $Page->req_material_rid->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_req_material_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_rid->caption() ?><?= $Page->req_material_rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_rid->cellAttributes() ?>>
<span id="el_material_required_processing_outside_req_material_rid">
    <select
        id="x_req_material_rid"
        name="x_req_material_rid"
        class="form-control ew-select<?= $Page->req_material_rid->isInvalidClass() ?>"
        data-select2-id="fmaterial_required_processing_outsideedit_x_req_material_rid"
        data-table="material_required_processing_outside"
        data-field="x_req_material_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->req_material_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->req_material_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_rid->getPlaceHolder()) ?>"
        <?= $Page->req_material_rid->editAttributes() ?>>
        <?= $Page->req_material_rid->selectOptionListHtml("x_req_material_rid") ?>
    </select>
    <?= $Page->req_material_rid->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->req_material_rid->getErrorMessage() ?></div>
<?= $Page->req_material_rid->Lookup->getParamTag($Page, "p_x_req_material_rid") ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideedit", function() {
    var options = { name: "x_req_material_rid", selectId: "fmaterial_required_processing_outsideedit_x_req_material_rid" };
    if (fmaterial_required_processing_outsideedit.lists.req_material_rid?.lookupOptions.length) {
        options.data = { id: "x_req_material_rid", form: "fmaterial_required_processing_outsideedit" };
    } else {
        options.ajax = { id: "x_req_material_rid", form: "fmaterial_required_processing_outsideedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.material_required_processing_outside.fields.req_material_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
    <div id="r_req_material_qty"<?= $Page->req_material_qty->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_req_material_qty" for="x_req_material_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_qty->caption() ?><?= $Page->req_material_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_qty->cellAttributes() ?>>
<span id="el_material_required_processing_outside_req_material_qty">
<span<?= $Page->req_material_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->req_material_qty->getDisplayValue($Page->req_material_qty->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_req_material_qty" data-hidden="1" name="x_req_material_qty" id="x_req_material_qty" value="<?= HtmlEncode($Page->req_material_qty->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issued_qty->Visible) { // issued_qty ?>
    <div id="r_issued_qty"<?= $Page->issued_qty->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_issued_qty" for="x_issued_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issued_qty->caption() ?><?= $Page->issued_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issued_qty->cellAttributes() ?>>
<span id="el_material_required_processing_outside_issued_qty">
<input type="<?= $Page->issued_qty->getInputTextType() ?>" name="x_issued_qty" id="x_issued_qty" data-table="material_required_processing_outside" data-field="x_issued_qty" value="<?= $Page->issued_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->issued_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issued_qty->formatPattern()) ?>"<?= $Page->issued_qty->editAttributes() ?> aria-describedby="x_issued_qty_help">
<?= $Page->issued_qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issued_qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issued_pkt->Visible) { // issued_pkt ?>
    <div id="r_issued_pkt"<?= $Page->issued_pkt->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_issued_pkt" for="x_issued_pkt" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issued_pkt->caption() ?><?= $Page->issued_pkt->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issued_pkt->cellAttributes() ?>>
<span id="el_material_required_processing_outside_issued_pkt">
<input type="<?= $Page->issued_pkt->getInputTextType() ?>" name="x_issued_pkt" id="x_issued_pkt" data-table="material_required_processing_outside" data-field="x_issued_pkt" value="<?= $Page->issued_pkt->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->issued_pkt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issued_pkt->formatPattern()) ?>"<?= $Page->issued_pkt->editAttributes() ?> aria-describedby="x_issued_pkt_help">
<?= $Page->issued_pkt->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issued_pkt->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no"<?= $Page->lot_no->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_lot_no" for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lot_no->caption() ?><?= $Page->lot_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lot_no->cellAttributes() ?>>
<span id="el_material_required_processing_outside_lot_no">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="material_required_processing_outside" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?> aria-describedby="x_lot_no_help">
<?= $Page->lot_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->stock->Visible) { // stock ?>
    <div id="r_stock"<?= $Page->stock->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_stock" for="x_stock" class="<?= $Page->LeftColumnClass ?>"><?= $Page->stock->caption() ?><?= $Page->stock->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->stock->cellAttributes() ?>>
<span id="el_material_required_processing_outside_stock">
<span<?= $Page->stock->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->stock->getDisplayValue($Page->stock->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_stock" data-hidden="1" name="x_stock" id="x_stock" value="<?= HtmlEncode($Page->stock->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->short->Visible) { // short ?>
    <div id="r_short"<?= $Page->short->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_short" for="x_short" class="<?= $Page->LeftColumnClass ?>"><?= $Page->short->caption() ?><?= $Page->short->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->short->cellAttributes() ?>>
<span id="el_material_required_processing_outside_short">
<span<?= $Page->short->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->short->getDisplayValue($Page->short->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_short" data-hidden="1" name="x_short" id="x_short" value="<?= HtmlEncode($Page->short->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit"<?= $Page->unit->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_unit" for="x_unit" class="<?= $Page->LeftColumnClass ?>"><?= $Page->unit->caption() ?><?= $Page->unit->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->unit->cellAttributes() ?>>
<span id="el_material_required_processing_outside_unit">
<span<?= $Page->unit->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->unit->getDisplayValue($Page->unit->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_unit" data-hidden="1" name="x_unit" id="x_unit" value="<?= HtmlEncode($Page->unit->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->material_qty->Visible) { // material_qty ?>
    <div id="r_material_qty"<?= $Page->material_qty->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_material_qty" for="x_material_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->material_qty->caption() ?><?= $Page->material_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->material_qty->cellAttributes() ?>>
<span id="el_material_required_processing_outside_material_qty">
<span<?= $Page->material_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->material_qty->getDisplayValue($Page->material_qty->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_material_qty" data-hidden="1" name="x_material_qty" id="x_material_qty" value="<?= HtmlEncode($Page->material_qty->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method"<?= $Page->method->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_method" for="x_method" class="<?= $Page->LeftColumnClass ?>"><?= $Page->method->caption() ?><?= $Page->method->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->method->cellAttributes() ?>>
<span id="el_material_required_processing_outside_method">
<span<?= $Page->method->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->method->getDisplayValue($Page->method->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_method" data-hidden="1" name="x_method" id="x_method" value="<?= HtmlEncode($Page->method->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week"<?= $Page->despatch_week->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_despatch_week" for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_week->caption() ?><?= $Page->despatch_week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el_material_required_processing_outside_despatch_week">
<span<?= $Page->despatch_week->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->despatch_week->getDisplayValue($Page->despatch_week->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_despatch_week" data-hidden="1" name="x_despatch_week" id="x_despatch_week" value="<?= HtmlEncode($Page->despatch_week->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
    <div id="r_despatch_date"<?= $Page->despatch_date->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_despatch_date" for="x_despatch_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_date->caption() ?><?= $Page->despatch_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el_material_required_processing_outside_despatch_date">
<span<?= $Page->despatch_date->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->despatch_date->getDisplayValue($Page->despatch_date->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_despatch_date" data-hidden="1" name="x_despatch_date" id="x_despatch_date" value="<?= HtmlEncode($Page->despatch_date->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->production_plan->Visible) { // production_plan ?>
    <div id="r_production_plan"<?= $Page->production_plan->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_production_plan" for="x_production_plan" class="<?= $Page->LeftColumnClass ?>"><?= $Page->production_plan->caption() ?><?= $Page->production_plan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->production_plan->cellAttributes() ?>>
<span id="el_material_required_processing_outside_production_plan">
<span<?= $Page->production_plan->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->production_plan->getDisplayValue($Page->production_plan->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_production_plan" data-hidden="1" name="x_production_plan" id="x_production_plan" value="<?= HtmlEncode($Page->production_plan->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
    <div id="r_issue_to"<?= $Page->issue_to->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_issue_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_to->caption() ?><?= $Page->issue_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_to->cellAttributes() ?>>
<span id="el_material_required_processing_outside_issue_to">
<span<?= $Page->issue_to->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->issue_to->getDisplayValue($Page->issue_to->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_issue_to" data-hidden="1" name="x_issue_to" id="x_issue_to" value="<?= HtmlEncode($Page->issue_to->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmaterial_required_processing_outsideedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmaterial_required_processing_outsideedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_required_processing_outside");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
