<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialRequiredProcessingOutsideAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_processing_outside: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fmaterial_required_processing_outsideadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmaterial_required_processing_outsideadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["poid", [fields.poid.visible && fields.poid.required ? ew.Validators.required(fields.poid.caption) : null, ew.Validators.integer], fields.poid.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["week", [fields.week.visible && fields.week.required ? ew.Validators.required(fields.week.caption) : null], fields.week.isInvalid],
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null], fields.buyer_id.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["product_id", [fields.product_id.visible && fields.product_id.required ? ew.Validators.required(fields.product_id.caption) : null], fields.product_id.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null], fields.batch_no.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null], fields.quantity.isInvalid],
            ["size_cm", [fields.size_cm.visible && fields.size_cm.required ? ew.Validators.required(fields.size_cm.caption) : null], fields.size_cm.isInvalid],
            ["sqm", [fields.sqm.visible && fields.sqm.required ? ew.Validators.required(fields.sqm.caption) : null, ew.Validators.float], fields.sqm.isInvalid],
            ["t_sqm", [fields.t_sqm.visible && fields.t_sqm.required ? ew.Validators.required(fields.t_sqm.caption) : null, ew.Validators.float], fields.t_sqm.isInvalid],
            ["req_material_grp", [fields.req_material_grp.visible && fields.req_material_grp.required ? ew.Validators.required(fields.req_material_grp.caption) : null], fields.req_material_grp.isInvalid],
            ["req_material_sgrp", [fields.req_material_sgrp.visible && fields.req_material_sgrp.required ? ew.Validators.required(fields.req_material_sgrp.caption) : null], fields.req_material_sgrp.isInvalid],
            ["req_material_product", [fields.req_material_product.visible && fields.req_material_product.required ? ew.Validators.required(fields.req_material_product.caption) : null], fields.req_material_product.isInvalid],
            ["req_material_packing", [fields.req_material_packing.visible && fields.req_material_packing.required ? ew.Validators.required(fields.req_material_packing.caption) : null], fields.req_material_packing.isInvalid],
            ["req_material_rid", [fields.req_material_rid.visible && fields.req_material_rid.required ? ew.Validators.required(fields.req_material_rid.caption) : null, ew.Validators.integer], fields.req_material_rid.isInvalid],
            ["req_material_qty", [fields.req_material_qty.visible && fields.req_material_qty.required ? ew.Validators.required(fields.req_material_qty.caption) : null, ew.Validators.float], fields.req_material_qty.isInvalid],
            ["issued_pkt", [fields.issued_pkt.visible && fields.issued_pkt.required ? ew.Validators.required(fields.issued_pkt.caption) : null, ew.Validators.float], fields.issued_pkt.isInvalid],
            ["lot_no", [fields.lot_no.visible && fields.lot_no.required ? ew.Validators.required(fields.lot_no.caption) : null], fields.lot_no.isInvalid],
            ["stock", [fields.stock.visible && fields.stock.required ? ew.Validators.required(fields.stock.caption) : null, ew.Validators.float], fields.stock.isInvalid],
            ["short", [fields.short.visible && fields.short.required ? ew.Validators.required(fields.short.caption) : null, ew.Validators.float], fields.short.isInvalid],
            ["unit", [fields.unit.visible && fields.unit.required ? ew.Validators.required(fields.unit.caption) : null], fields.unit.isInvalid],
            ["material_qty", [fields.material_qty.visible && fields.material_qty.required ? ew.Validators.required(fields.material_qty.caption) : null, ew.Validators.float], fields.material_qty.isInvalid],
            ["method", [fields.method.visible && fields.method.required ? ew.Validators.required(fields.method.caption) : null], fields.method.isInvalid],
            ["despatch_week", [fields.despatch_week.visible && fields.despatch_week.required ? ew.Validators.required(fields.despatch_week.caption) : null], fields.despatch_week.isInvalid],
            ["despatch_date", [fields.despatch_date.visible && fields.despatch_date.required ? ew.Validators.required(fields.despatch_date.caption) : null, ew.Validators.datetime(fields.despatch_date.clientFormatPattern)], fields.despatch_date.isInvalid],
            ["production_plan", [fields.production_plan.visible && fields.production_plan.required ? ew.Validators.required(fields.production_plan.caption) : null], fields.production_plan.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["updated", [fields.updated.visible && fields.updated.required ? ew.Validators.required(fields.updated.caption) : null, ew.Validators.integer], fields.updated.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "week": <?= $Page->week->toClientList($Page) ?>,
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "product_id": <?= $Page->product_id->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "req_material_grp": <?= $Page->req_material_grp->toClientList($Page) ?>,
            "req_material_sgrp": <?= $Page->req_material_sgrp->toClientList($Page) ?>,
            "req_material_product": <?= $Page->req_material_product->toClientList($Page) ?>,
            "req_material_packing": <?= $Page->req_material_packing->toClientList($Page) ?>,
            "req_material_rid": <?= $Page->req_material_rid->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "method": <?= $Page->method->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "production_plan": <?= $Page->production_plan->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmaterial_required_processing_outsideadd" id="fmaterial_required_processing_outsideadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_required_processing_outside">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->poid->Visible) { // poid ?>
    <div id="r_poid"<?= $Page->poid->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_poid" for="x_poid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->poid->caption() ?><?= $Page->poid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->poid->cellAttributes() ?>>
<span id="el_material_required_processing_outside_poid">
<input type="<?= $Page->poid->getInputTextType() ?>" name="x_poid" id="x_poid" data-table="material_required_processing_outside" data-field="x_poid" value="<?= $Page->poid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->poid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->poid->formatPattern()) ?>"<?= $Page->poid->editAttributes() ?> aria-describedby="x_poid_help">
<?= $Page->poid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->poid->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_location" for="x_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_material_required_processing_outside_location">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_location"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <?= $Page->location->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_location", selectId: "fmaterial_required_processing_outsideadd_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_location", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->week->Visible) { // week ?>
    <div id="r_week"<?= $Page->week->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_week" for="x_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->week->caption() ?><?= $Page->week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->week->cellAttributes() ?>>
<span id="el_material_required_processing_outside_week">
    <select
        id="x_week"
        name="x_week"
        class="form-select ew-select<?= $Page->week->isInvalidClass() ?>"
        <?php if (!$Page->week->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_week"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_week"
        data-value-separator="<?= $Page->week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->week->getPlaceHolder()) ?>"
        <?= $Page->week->editAttributes() ?>>
        <?= $Page->week->selectOptionListHtml("x_week") ?>
    </select>
    <?= $Page->week->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->week->getErrorMessage() ?></div>
<?= $Page->week->Lookup->getParamTag($Page, "p_x_week") ?>
<?php if (!$Page->week->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_week", selectId: "fmaterial_required_processing_outsideadd_x_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.week?.lookupOptions.length) {
        options.data = { id: "x_week", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_week", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id"<?= $Page->buyer_id->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_buyer_id" for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_id->caption() ?><?= $Page->buyer_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el_material_required_processing_outside_buyer_id">
<div class="input-group flex-nowrap">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-select ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        <?php if (!$Page->buyer_id->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_buyer_id"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_buyer_id"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "buyer") && !$Page->buyer_id->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_buyer_id" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->buyer_id->caption() ?>" data-title="<?= $Page->buyer_id->caption() ?>" data-ew-action="add-option" data-el="x_buyer_id" data-url="<?= GetUrl("buyeraddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->buyer_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage() ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<?php if (!$Page->buyer_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_buyer_id", selectId: "fmaterial_required_processing_outsideadd_x_buyer_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.buyer_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_material_required_processing_outside_grp">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_grp"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_grp", selectId: "fmaterial_required_processing_outsideadd_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_grp", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_material_required_processing_outside_s_grp">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_s_grp"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <?= $Page->s_grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_s_grp", selectId: "fmaterial_required_processing_outsideadd_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_material_required_processing_outside_product">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_product"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <?= $Page->product->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_product", selectId: "fmaterial_required_processing_outsideadd_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_product", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_id->Visible) { // product_id ?>
    <div id="r_product_id"<?= $Page->product_id->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_product_id" for="x_product_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_id->caption() ?><?= $Page->product_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_id->cellAttributes() ?>>
<span id="el_material_required_processing_outside_product_id">
<div class="input-group flex-nowrap">
    <select
        id="x_product_id"
        name="x_product_id"
        class="form-select ew-select<?= $Page->product_id->isInvalidClass() ?>"
        <?php if (!$Page->product_id->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_product_id"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_product_id"
        data-value-separator="<?= $Page->product_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_id->getPlaceHolder()) ?>"
        <?= $Page->product_id->editAttributes() ?>>
        <?= $Page->product_id->selectOptionListHtml("x_product_id") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "ref") && !$Page->product_id->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_product_id" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->product_id->caption() ?>" data-title="<?= $Page->product_id->caption() ?>" data-ew-action="add-option" data-el="x_product_id" data-url="<?= GetUrl("refaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->product_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->product_id->getErrorMessage() ?></div>
<?= $Page->product_id->Lookup->getParamTag($Page, "p_x_product_id") ?>
<?php if (!$Page->product_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_product_id", selectId: "fmaterial_required_processing_outsideadd_x_product_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.product_id?.lookupOptions.length) {
        options.data = { id: "x_product_id", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_product_id", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.product_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no"<?= $Page->batch_no->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_batch_no" for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->batch_no->caption() ?><?= $Page->batch_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->batch_no->cellAttributes() ?>>
<span id="el_material_required_processing_outside_batch_no">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-control ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        data-select2-id="fmaterial_required_processing_outsideadd_x_batch_no"
        data-table="material_required_processing_outside"
        data-field="x_batch_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->batch_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <?= $Page->batch_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage() ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_batch_no", selectId: "fmaterial_required_processing_outsideadd_x_batch_no" };
    if (fmaterial_required_processing_outsideadd.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.material_required_processing_outside.fields.batch_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_material_required_processing_outside_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="material_required_processing_outside" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm"<?= $Page->size_cm->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_size_cm" for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size_cm->caption() ?><?= $Page->size_cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size_cm->cellAttributes() ?>>
<span id="el_material_required_processing_outside_size_cm">
<input type="<?= $Page->size_cm->getInputTextType() ?>" name="x_size_cm" id="x_size_cm" data-table="material_required_processing_outside" data-field="x_size_cm" value="<?= $Page->size_cm->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->size_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_cm->formatPattern()) ?>"<?= $Page->size_cm->editAttributes() ?> aria-describedby="x_size_cm_help">
<?= $Page->size_cm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->size_cm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm"<?= $Page->sqm->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_sqm" for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm->caption() ?><?= $Page->sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm->cellAttributes() ?>>
<span id="el_material_required_processing_outside_sqm">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="material_required_processing_outside" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?> aria-describedby="x_sqm_help">
<?= $Page->sqm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->t_sqm->Visible) { // t_sqm ?>
    <div id="r_t_sqm"<?= $Page->t_sqm->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_t_sqm" for="x_t_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->t_sqm->caption() ?><?= $Page->t_sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->t_sqm->cellAttributes() ?>>
<span id="el_material_required_processing_outside_t_sqm">
<input type="<?= $Page->t_sqm->getInputTextType() ?>" name="x_t_sqm" id="x_t_sqm" data-table="material_required_processing_outside" data-field="x_t_sqm" value="<?= $Page->t_sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->t_sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_sqm->formatPattern()) ?>"<?= $Page->t_sqm->editAttributes() ?> aria-describedby="x_t_sqm_help">
<?= $Page->t_sqm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->t_sqm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_grp->Visible) { // req_material_grp ?>
    <div id="r_req_material_grp"<?= $Page->req_material_grp->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_req_material_grp" for="x_req_material_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_grp->caption() ?><?= $Page->req_material_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_grp->cellAttributes() ?>>
<span id="el_material_required_processing_outside_req_material_grp">
    <select
        id="x_req_material_grp"
        name="x_req_material_grp"
        class="form-select ew-select<?= $Page->req_material_grp->isInvalidClass() ?>"
        <?php if (!$Page->req_material_grp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_req_material_grp"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_req_material_grp"
        data-value-separator="<?= $Page->req_material_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->req_material_grp->editAttributes() ?>>
        <?= $Page->req_material_grp->selectOptionListHtml("x_req_material_grp") ?>
    </select>
    <?= $Page->req_material_grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->req_material_grp->getErrorMessage() ?></div>
<?= $Page->req_material_grp->Lookup->getParamTag($Page, "p_x_req_material_grp") ?>
<?php if (!$Page->req_material_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_req_material_grp", selectId: "fmaterial_required_processing_outsideadd_x_req_material_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.req_material_grp?.lookupOptions.length) {
        options.data = { id: "x_req_material_grp", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_req_material_grp", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.req_material_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_sgrp->Visible) { // req_material_sgrp ?>
    <div id="r_req_material_sgrp"<?= $Page->req_material_sgrp->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_req_material_sgrp" for="x_req_material_sgrp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_sgrp->caption() ?><?= $Page->req_material_sgrp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_sgrp->cellAttributes() ?>>
<span id="el_material_required_processing_outside_req_material_sgrp">
    <select
        id="x_req_material_sgrp"
        name="x_req_material_sgrp"
        class="form-select ew-select<?= $Page->req_material_sgrp->isInvalidClass() ?>"
        <?php if (!$Page->req_material_sgrp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_req_material_sgrp"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_req_material_sgrp"
        data-value-separator="<?= $Page->req_material_sgrp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_sgrp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->req_material_sgrp->editAttributes() ?>>
        <?= $Page->req_material_sgrp->selectOptionListHtml("x_req_material_sgrp") ?>
    </select>
    <?= $Page->req_material_sgrp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->req_material_sgrp->getErrorMessage() ?></div>
<?= $Page->req_material_sgrp->Lookup->getParamTag($Page, "p_x_req_material_sgrp") ?>
<?php if (!$Page->req_material_sgrp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_req_material_sgrp", selectId: "fmaterial_required_processing_outsideadd_x_req_material_sgrp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.req_material_sgrp?.lookupOptions.length) {
        options.data = { id: "x_req_material_sgrp", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_req_material_sgrp", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.req_material_sgrp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_product->Visible) { // req_material_product ?>
    <div id="r_req_material_product"<?= $Page->req_material_product->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_req_material_product" for="x_req_material_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_product->caption() ?><?= $Page->req_material_product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_product->cellAttributes() ?>>
<span id="el_material_required_processing_outside_req_material_product">
    <select
        id="x_req_material_product"
        name="x_req_material_product"
        class="form-select ew-select<?= $Page->req_material_product->isInvalidClass() ?>"
        <?php if (!$Page->req_material_product->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_req_material_product"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_req_material_product"
        data-value-separator="<?= $Page->req_material_product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->req_material_product->editAttributes() ?>>
        <?= $Page->req_material_product->selectOptionListHtml("x_req_material_product") ?>
    </select>
    <?= $Page->req_material_product->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->req_material_product->getErrorMessage() ?></div>
<?= $Page->req_material_product->Lookup->getParamTag($Page, "p_x_req_material_product") ?>
<?php if (!$Page->req_material_product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_req_material_product", selectId: "fmaterial_required_processing_outsideadd_x_req_material_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.req_material_product?.lookupOptions.length) {
        options.data = { id: "x_req_material_product", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_req_material_product", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.req_material_product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
    <div id="r_req_material_packing"<?= $Page->req_material_packing->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_req_material_packing" for="x_req_material_packing" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_packing->caption() ?><?= $Page->req_material_packing->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_packing->cellAttributes() ?>>
<span id="el_material_required_processing_outside_req_material_packing">
    <select
        id="x_req_material_packing"
        name="x_req_material_packing"
        class="form-select ew-select<?= $Page->req_material_packing->isInvalidClass() ?>"
        <?php if (!$Page->req_material_packing->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_req_material_packing"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_req_material_packing"
        data-value-separator="<?= $Page->req_material_packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_packing->getPlaceHolder()) ?>"
        <?= $Page->req_material_packing->editAttributes() ?>>
        <?= $Page->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
    </select>
    <?= $Page->req_material_packing->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->req_material_packing->getErrorMessage() ?></div>
<?= $Page->req_material_packing->Lookup->getParamTag($Page, "p_x_req_material_packing") ?>
<?php if (!$Page->req_material_packing->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_req_material_packing", selectId: "fmaterial_required_processing_outsideadd_x_req_material_packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.req_material_packing?.lookupOptions.length) {
        options.data = { id: "x_req_material_packing", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_req_material_packing", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.req_material_packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
    <div id="r_req_material_rid"<?= $Page->req_material_rid->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_req_material_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_rid->caption() ?><?= $Page->req_material_rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_rid->cellAttributes() ?>>
<span id="el_material_required_processing_outside_req_material_rid">
    <select
        id="x_req_material_rid"
        name="x_req_material_rid"
        class="form-control ew-select<?= $Page->req_material_rid->isInvalidClass() ?>"
        data-select2-id="fmaterial_required_processing_outsideadd_x_req_material_rid"
        data-table="material_required_processing_outside"
        data-field="x_req_material_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->req_material_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->req_material_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_rid->getPlaceHolder()) ?>"
        <?= $Page->req_material_rid->editAttributes() ?>>
        <?= $Page->req_material_rid->selectOptionListHtml("x_req_material_rid") ?>
    </select>
    <?= $Page->req_material_rid->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->req_material_rid->getErrorMessage() ?></div>
<?= $Page->req_material_rid->Lookup->getParamTag($Page, "p_x_req_material_rid") ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_req_material_rid", selectId: "fmaterial_required_processing_outsideadd_x_req_material_rid" };
    if (fmaterial_required_processing_outsideadd.lists.req_material_rid?.lookupOptions.length) {
        options.data = { id: "x_req_material_rid", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_req_material_rid", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.material_required_processing_outside.fields.req_material_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
    <div id="r_req_material_qty"<?= $Page->req_material_qty->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_req_material_qty" for="x_req_material_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_qty->caption() ?><?= $Page->req_material_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_qty->cellAttributes() ?>>
<span id="el_material_required_processing_outside_req_material_qty">
<input type="<?= $Page->req_material_qty->getInputTextType() ?>" name="x_req_material_qty" id="x_req_material_qty" data-table="material_required_processing_outside" data-field="x_req_material_qty" value="<?= $Page->req_material_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_qty->formatPattern()) ?>"<?= $Page->req_material_qty->editAttributes() ?> aria-describedby="x_req_material_qty_help">
<?= $Page->req_material_qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->req_material_qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issued_pkt->Visible) { // issued_pkt ?>
    <div id="r_issued_pkt"<?= $Page->issued_pkt->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_issued_pkt" for="x_issued_pkt" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issued_pkt->caption() ?><?= $Page->issued_pkt->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issued_pkt->cellAttributes() ?>>
<span id="el_material_required_processing_outside_issued_pkt">
<input type="<?= $Page->issued_pkt->getInputTextType() ?>" name="x_issued_pkt" id="x_issued_pkt" data-table="material_required_processing_outside" data-field="x_issued_pkt" value="<?= $Page->issued_pkt->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->issued_pkt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issued_pkt->formatPattern()) ?>"<?= $Page->issued_pkt->editAttributes() ?> aria-describedby="x_issued_pkt_help">
<?= $Page->issued_pkt->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issued_pkt->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no"<?= $Page->lot_no->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_lot_no" for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lot_no->caption() ?><?= $Page->lot_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lot_no->cellAttributes() ?>>
<span id="el_material_required_processing_outside_lot_no">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="material_required_processing_outside" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?> aria-describedby="x_lot_no_help">
<?= $Page->lot_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->stock->Visible) { // stock ?>
    <div id="r_stock"<?= $Page->stock->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_stock" for="x_stock" class="<?= $Page->LeftColumnClass ?>"><?= $Page->stock->caption() ?><?= $Page->stock->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->stock->cellAttributes() ?>>
<span id="el_material_required_processing_outside_stock">
<input type="<?= $Page->stock->getInputTextType() ?>" name="x_stock" id="x_stock" data-table="material_required_processing_outside" data-field="x_stock" value="<?= $Page->stock->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->stock->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->stock->formatPattern()) ?>"<?= $Page->stock->editAttributes() ?> aria-describedby="x_stock_help">
<?= $Page->stock->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->stock->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->short->Visible) { // short ?>
    <div id="r_short"<?= $Page->short->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_short" for="x_short" class="<?= $Page->LeftColumnClass ?>"><?= $Page->short->caption() ?><?= $Page->short->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->short->cellAttributes() ?>>
<span id="el_material_required_processing_outside_short">
<input type="<?= $Page->short->getInputTextType() ?>" name="x_short" id="x_short" data-table="material_required_processing_outside" data-field="x_short" value="<?= $Page->short->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->short->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->short->formatPattern()) ?>"<?= $Page->short->editAttributes() ?> aria-describedby="x_short_help">
<?= $Page->short->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->short->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit"<?= $Page->unit->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_unit" for="x_unit" class="<?= $Page->LeftColumnClass ?>"><?= $Page->unit->caption() ?><?= $Page->unit->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->unit->cellAttributes() ?>>
<span id="el_material_required_processing_outside_unit">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_unit"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <?= $Page->unit->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage() ?></div>
<?= $Page->unit->Lookup->getParamTag($Page, "p_x_unit") ?>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_unit", selectId: "fmaterial_required_processing_outsideadd_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_unit", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->material_qty->Visible) { // material_qty ?>
    <div id="r_material_qty"<?= $Page->material_qty->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_material_qty" for="x_material_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->material_qty->caption() ?><?= $Page->material_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->material_qty->cellAttributes() ?>>
<span id="el_material_required_processing_outside_material_qty">
<input type="<?= $Page->material_qty->getInputTextType() ?>" name="x_material_qty" id="x_material_qty" data-table="material_required_processing_outside" data-field="x_material_qty" value="<?= $Page->material_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->material_qty->formatPattern()) ?>"<?= $Page->material_qty->editAttributes() ?> aria-describedby="x_material_qty_help">
<?= $Page->material_qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->material_qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method"<?= $Page->method->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_method" for="x_method" class="<?= $Page->LeftColumnClass ?>"><?= $Page->method->caption() ?><?= $Page->method->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->method->cellAttributes() ?>>
<span id="el_material_required_processing_outside_method">
    <select
        id="x_method"
        name="x_method"
        class="form-select ew-select<?= $Page->method->isInvalidClass() ?>"
        <?php if (!$Page->method->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_method"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_method"
        data-value-separator="<?= $Page->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>"
        <?= $Page->method->editAttributes() ?>>
        <?= $Page->method->selectOptionListHtml("x_method") ?>
    </select>
    <?= $Page->method->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->method->getErrorMessage() ?></div>
<?= $Page->method->Lookup->getParamTag($Page, "p_x_method") ?>
<?php if (!$Page->method->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_method", selectId: "fmaterial_required_processing_outsideadd_x_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.method?.lookupOptions.length) {
        options.data = { id: "x_method", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_method", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week"<?= $Page->despatch_week->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_despatch_week" for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_week->caption() ?><?= $Page->despatch_week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el_material_required_processing_outside_despatch_week">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_despatch_week"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <?= $Page->despatch_week->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage() ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_despatch_week", selectId: "fmaterial_required_processing_outsideadd_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
    <div id="r_despatch_date"<?= $Page->despatch_date->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_despatch_date" for="x_despatch_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_date->caption() ?><?= $Page->despatch_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el_material_required_processing_outside_despatch_date">
<input type="<?= $Page->despatch_date->getInputTextType() ?>" name="x_despatch_date" id="x_despatch_date" data-table="material_required_processing_outside" data-field="x_despatch_date" value="<?= $Page->despatch_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->despatch_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->despatch_date->formatPattern()) ?>"<?= $Page->despatch_date->editAttributes() ?> aria-describedby="x_despatch_date_help">
<?= $Page->despatch_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->despatch_date->getErrorMessage() ?></div>
<?php if (!$Page->despatch_date->ReadOnly && !$Page->despatch_date->Disabled && !isset($Page->despatch_date->EditAttrs["readonly"]) && !isset($Page->despatch_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_required_processing_outsideadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_required_processing_outsideadd", "x_despatch_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->production_plan->Visible) { // production_plan ?>
    <div id="r_production_plan"<?= $Page->production_plan->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_production_plan" for="x_production_plan" class="<?= $Page->LeftColumnClass ?>"><?= $Page->production_plan->caption() ?><?= $Page->production_plan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->production_plan->cellAttributes() ?>>
<span id="el_material_required_processing_outside_production_plan">
    <select
        id="x_production_plan"
        name="x_production_plan"
        class="form-select ew-select<?= $Page->production_plan->isInvalidClass() ?>"
        <?php if (!$Page->production_plan->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_processing_outsideadd_x_production_plan"
        <?php } ?>
        data-table="material_required_processing_outside"
        data-field="x_production_plan"
        data-value-separator="<?= $Page->production_plan->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->production_plan->getPlaceHolder()) ?>"
        <?= $Page->production_plan->editAttributes() ?>>
        <?= $Page->production_plan->selectOptionListHtml("x_production_plan") ?>
    </select>
    <?= $Page->production_plan->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->production_plan->getErrorMessage() ?></div>
<?php if (!$Page->production_plan->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_processing_outsideadd", function() {
    var options = { name: "x_production_plan", selectId: "fmaterial_required_processing_outsideadd_x_production_plan" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_processing_outsideadd.lists.production_plan?.lookupOptions.length) {
        options.data = { id: "x_production_plan", form: "fmaterial_required_processing_outsideadd" };
    } else {
        options.ajax = { id: "x_production_plan", form: "fmaterial_required_processing_outsideadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_processing_outside.fields.production_plan.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_material_required_processing_outside_remarks">
<textarea data-table="material_required_processing_outside" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->updated->Visible) { // updated ?>
    <div id="r_updated"<?= $Page->updated->rowAttributes() ?>>
        <label id="elh_material_required_processing_outside_updated" for="x_updated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->updated->caption() ?><?= $Page->updated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->updated->cellAttributes() ?>>
<span id="el_material_required_processing_outside_updated">
<input type="<?= $Page->updated->getInputTextType() ?>" name="x_updated" id="x_updated" data-table="material_required_processing_outside" data-field="x_updated" value="<?= $Page->updated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->updated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->updated->formatPattern()) ?>"<?= $Page->updated->editAttributes() ?> aria-describedby="x_updated_help">
<?= $Page->updated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->updated->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmaterial_required_processing_outsideadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmaterial_required_processing_outsideadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_required_processing_outside");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
